/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.sphgeom;

import cds.healpix.Healpix;
import cds.healpix.common.math.Math;

public class EllipticalCone {
    public static final double EPSILON = 1.0E-14;
    protected double lon;
    protected double lat;
    protected double a;
    protected double b;
    protected double pa;
    private double r11;
    private double r12;
    private double r13;
    private double r21;
    private double r22;
    private double r23;
    private double r31;
    private double r32;
    private double r33;
    private double sina;
    private double sinb;
    private double cosPA;
    private double sinPA;
    private double sigX2;
    private double sigY2;
    private double rho;
    private double oneOver1minRho2;
    private double twiceRhoOverSigXSigY;
    private double a11;
    private double a12;
    private double a21;
    private double a22;
    private double xF0;
    private double yF0;
    private double zF0;
    private double xF1;
    private double yF1;
    private double zF1;

    public EllipticalCone(double lonRad, double latRad, double aRad, double bRad) {
        this(lonRad, latRad, aRad, bRad, 0.0);
    }

    public EllipticalCone(double lonRad, double latRad, double aRad, double bRad, double posAngRad) {
        this.setProjCenter(lonRad, latRad);
        this.setEllipseParams(aRad, bRad, posAngRad);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getSinA() {
        return this.sina;
    }

    public double getSinB() {
        return this.sinb;
    }

    private final double distanceToF0(double x, double y, double z) {
        return this.angularDistance(x, y, z, this.xF0, this.yF0, this.zF0);
    }

    private final double distanceToF1(double x, double y, double z) {
        return this.angularDistance(x, y, z, this.xF1, this.yF1, this.zF1);
    }

    private final double angularDistance(double xA, double yA, double zA, double xB, double yB, double zB) {
        assert (Math.abs(1.0 - Math.sqrt(xA * xA + yA * yA + zA * zA)) < 1.0E-14) : "A: sqrt(x^2 + y^2 + z^2): " + Math.sqrt(xA * xA + yA * yA + zA * zA);
        assert (Math.abs(1.0 - Math.sqrt(xB * xB + yB * yB + zB * zB)) < 1.0E-14) : "B: sqrt(x^2 + y^2 + z^2): " + Math.sqrt(xB * xB + yB * yB + zB * zB);
        double dotProd = xA * xB + yA * yB + zA * zB;
        double vpx = yA * zB - zA * yB;
        double vpy = zA * xB - xA * zB;
        double vpz = xA * yB - yA * xB;
        double vecProdNorm = Math.sqrt(vpx * vpx + vpy * vpy + vpz * vpz);
        return java.lang.Math.atan2(vecProdNorm, dotProd);
    }

    private double halfSumOfDistanceToFocii(double lonRad, double latRad) {
        Healpix.checkLatitude(latRad);
        double z = Math.cos(latRad);
        double x = z * Math.cos(lonRad);
        double y = z * Math.sin(lonRad);
        z = Math.sin(latRad);
        return (this.distanceToF0(x, y, z) + this.distanceToF1(x, y, z)) / 2.0;
    }

    public boolean contains(double lonRad, double latRad) {
        return this.halfSumOfDistanceToFocii(lonRad, latRad) <= this.a;
    }

    public boolean overlapCone(double lonRad, double latRad, double rRad) {
        return this.halfSumOfDistanceToFocii(lonRad, latRad) <= this.a + rRad;
    }

    public boolean containsCone(double lonRad, double latRad, double rRad) {
        return rRad > this.b ? false : this.halfSumOfDistanceToFocii(lonRad, latRad) <= this.a - rRad;
    }

    public double[][] pathAlongEdge(int halfNumberOfPoints) {
        double[][] coos = new double[2 * halfNumberOfPoints][];
        double step = 2.0 * this.sina / (double)halfNumberOfPoints;
        coos[0] = this.deproj(this.rotateEllipse(new double[]{this.sina, 0.0}));
        coos[halfNumberOfPoints] = this.deproj(this.rotateEllipse(new double[]{-this.sina, 0.0}));
        int i = 1;
        while (i < halfNumberOfPoints) {
            double x = this.sina - (double)i * step;
            double xn = x / this.sina;
            double y = this.sinb * Math.sqrt(1.0 - xn * xn);
            coos[i] = this.deproj(this.rotateEllipse(new double[]{x, y}));
            coos[coos.length - ++i] = this.deproj(this.rotateEllipse(new double[]{-x, -y}));
        }
        return coos;
    }

    private double[] rotateEllipse(double[] xy) {
        double x = xy[0];
        double y = xy[1];
        xy[0] = this.a11 * x + this.a12 * y;
        xy[1] = this.a21 * x + this.a22 * y;
        return xy;
    }

    private double squaredMahalanobisDistance(double x, double y) {
        return this.oneOver1minRho2 * (x * x / this.sigX2 - this.twiceRhoOverSigXSigY * x * y + y * y / this.sigY2);
    }

    public void setProjCenter(double lon, double lat) {
        Healpix.checkLatitude(lat);
        this.lon = lon;
        this.lat = lat;
        double ca = Math.cos(lon);
        double sa = Math.sin(lon);
        double cd = Math.cos(lat);
        double sd = Math.sin(lat);
        this.r11 = ca * cd;
        this.r12 = sa * cd;
        this.r13 = sd;
        this.r21 = -sa;
        this.r22 = ca;
        this.r23 = 0.0;
        this.r31 = -ca * sd;
        this.r32 = -sa * sd;
        this.r33 = cd;
    }

    private void setEllipseParams(double a, double b, double pa) {
        assert (a > 0.0 && b > 0.0);
        if (a < b) {
            throw new IllegalArgumentException("In ellipse a (" + a + ") must be >= to b (" + b + ")!");
        }
        this.a = a;
        this.b = b;
        this.pa = pa;
        this.sina = Math.sin(a);
        double sa2 = this.sina * this.sina;
        this.sinb = Math.sin(b);
        double sb2 = this.sinb * this.sinb;
        this.cosPA = Math.cos(pa);
        this.sinPA = Math.sin(pa);
        double cpa2 = this.cosPA * this.cosPA;
        double spa2 = this.sinPA * this.sinPA;
        this.sigX2 = sa2 * spa2 + sb2 * cpa2;
        this.sigY2 = sa2 * cpa2 + sb2 * spa2;
        this.rho = this.cosPA * this.sinPA * (sa2 - sb2);
        this.oneOver1minRho2 = 1.0 / (1.0 - this.rho * this.rho);
        this.twiceRhoOverSigXSigY = 2.0 * this.rho / Math.sqrt(this.sigX2 * this.sigY2);
        this.a11 = this.sinPA;
        this.a12 = -this.cosPA;
        this.a21 = this.cosPA;
        this.a22 = this.sinPA;
        double cosb = Math.cos(b);
        double cosg = Math.cos(a) / cosb;
        double sing = Math.sqrt((this.sina + this.sinb) * (this.sina - this.sinb)) / cosb;
        this.xF0 = cosg;
        this.yF0 = sing * this.sinPA;
        this.zF0 = sing * this.cosPA;
        this.xF1 = cosg;
        this.yF1 = -this.yF0;
        this.zF1 = -this.zF0;
        double[] f0 = this.globlaXYZFromLocalXYZ(this.xF0, this.yF0, this.zF0);
        double[] f1 = this.globlaXYZFromLocalXYZ(this.xF1, this.yF1, this.zF1);
        this.xF0 = f0[0];
        this.yF0 = f0[1];
        this.zF0 = f0[2];
        this.xF1 = f1[0];
        this.yF1 = f1[1];
        this.zF1 = f1[2];
        double[] lonlat = new double[2];
        EllipticalCone.setLonLatFromXYZ(lonlat, this.xF0, this.yF0, this.zF0);
        EllipticalCone.setLonLatFromXYZ(lonlat, this.xF1, this.yF1, this.zF1);
    }

    private boolean proj(double lon, double lat, double[] resultXY) {
        Healpix.checkLatitude(lat);
        double z = Math.cos(lat);
        double x = z * Math.cos(lon);
        double y = z * Math.sin(lon);
        z = Math.sin(lat);
        assert (-1.0 <= x && x <= 1.0) : "x: " + x + " should be in [-1, 1]";
        assert (-1.0 <= y && y <= 1.0) : "y: " + y + " should be in [-1, 1]";
        assert (-1.0 <= z && z <= 1.0) : "z: " + z + " should be in [-1, 1]";
        assert (Math.abs(1.0 - (x * x + y * y + z * z)) < 1.0E-14) : "(x^2 + y^2 + z^2): " + (x * x + y * y + z * z);
        return this.projAssert(this.r11 * x + this.r12 * y + this.r13 * z, this.r21 * x + this.r22 * y + this.r23 * z, this.r31 * x + this.r32 * y + this.r33 * z, resultXY);
    }

    private final boolean projAssert(double x, double y, double z, double[] resultXY) {
        assert (-1.0 <= x && x <= 1.0) : "x: " + x + " should be in [-1, 1]";
        assert (-1.0 <= y && y <= 1.0) : "y: " + y + " should be in [-1, 1]";
        assert (-1.0 <= z && z <= 1.0) : "z: " + z + " should be in [-1, 1]";
        assert (Math.abs(1.0 - (x * x + y * y + z * z)) < 1.0E-14) : "(x^2 + y^2 + z^2): " + (x * x + y * y + z * z);
        return this.proj(x, y, z, resultXY);
    }

    protected boolean proj(double x, double y, double z, double[] resultXY) {
        resultXY[0] = y;
        resultXY[1] = z;
        return x >= 0.0;
    }

    private double[] deproj(double[] xy2lonlat) {
        double x2D = xy2lonlat[0];
        double y2D = xy2lonlat[1];
        double r2 = x2D * x2D + y2D * y2D;
        double x2 = 1.0 - r2;
        if (x2 < 0.0) {
            if (x2 > -2.0E-16) {
                x2 = 0.0;
            } else {
                xy2lonlat[0] = Double.NaN;
                xy2lonlat[0] = Double.NaN;
                return xy2lonlat;
            }
        }
        this.setLonLatFromLocalXYZ(xy2lonlat, Math.sqrt(x2), x2D, y2D);
        return xy2lonlat;
    }

    private final double[] globlaXYZFromLocalXYZ(double x, double y, double z) {
        return new double[]{this.r11 * x + this.r21 * y + this.r31 * z, this.r12 * x + this.r22 * y + this.r32 * z, this.r13 * x + this.r23 * y + this.r33 * z};
    }

    private final void setLonLatFromLocalXYZ(double[] toLonLat, double x, double y, double z) {
        EllipticalCone.setLonLatFromXYZ(toLonLat, this.r11 * x + this.r21 * y + this.r31 * z, this.r12 * x + this.r22 * y + this.r32 * z, this.r13 * x + this.r23 * y + this.r33 * z);
    }

    private static final void setLonLatFromXYZ(double[] toLonLat, double x, double y, double z) {
        assert (-1.00000000000001 <= x && x <= 1.00000000000001) : "x: " + x + " should be in [-1, 1]";
        assert (-1.00000000000001 <= y && y <= 1.00000000000001) : "y: " + y + " should be in [-1, 1]";
        assert (-1.00000000000001 <= z && z <= 1.00000000000001) : "z: " + z + " should be in [-1, 1]";
        assert (Math.abs(1.0 - Math.sqrt(x * x + y * y + z * z)) < 1.0E-14) : "sqrt(x^2 + y^2 + z^2): " + Math.sqrt(x * x + y * y + z * z);
        double r2 = x * x + y * y;
        toLonLat[1] = Math.atan2(z, Math.sqrt(r2));
        r2 = Math.atan2(y, x);
        toLonLat[0] = r2 < 0.0 ? java.lang.Math.PI * 2 + r2 : r2;
    }
}

