/*
 * Copyright (c) 2018, SnakeYAML
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.snakeyaml.engine.v2.scanner;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.Optional;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

@org.junit.jupiter.api.Tag("fast")
class SimpleKeyTest {

  @Test
  @DisplayName("Resolve implicit integer")
  void testToString() {
    SimpleKey simpleKey = new SimpleKey(0, true, 0, 0, 0, Optional.empty());
    assertEquals("SimpleKey - tokenNumber=0 required=true index=0 line=0 column=0",
        simpleKey.toString());
  }
}

