#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    html
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_HTML_Persist
  class Persist
    @@persist=nil
    attr_accessor :is0,:is1,:is2,:is3,:is4,:heading0,:heading1,:heading2,:heading3,:heading4, :title, :dot_nav, :tocband_banner, :tocband_bannerless, :headings, :heading_endnotes, :main, :endnote_all, :tail, :credits, :heading_idx, :idx, :seg_endnotes, :seg_endnotes_array, :segtocband, :get_hash_fn, :get_hash_to, :seg_subtoc, :seg_subtoc_array, :fn, :seg_name ,:seg_name_x,:seg_name_x_tracker
    def initialize(args=nil)
      @@persist=args=(args ? args : (@@persist || persist_init_hash_values))
      @is0=args[:is0]
      @is1=args[:is1]
      @is2=args[:is2]
      @is3=args[:is3]
      @is4=args[:is4]
      @heading0=args[:heading0]
      @heading1=args[:heading1]
      @heading2=args[:heading2]
      @heading3=args[:heading3]
      @heading4=args[:heading4]
      @title=args[:title]
      @dot_nav=args[:dot_nav]
      @tocband_banner=args[:tocband_banner]
      @tocband_bannerless=args[:tocband_bannerless]
      @headings=args[:headings]
      @heading_endnotes=args[:heading_endnotes]
      @main=args[:main]
      @endnote_all=args[:endnote_all]
      @tail=args[:tail]
      @credits=args[:credits]
      @heading_idx=args[:heading_idx]
      @idx=args[:idx]
      @seg_endnotes=args[:seg_endnotes]
      @seg_endnotes_array=args[:seg_endnotes_array]
      @get_hash_to=args[:get_hash_to]
      @get_hash_fn=args[:get_hash_fn]
      @seg_subtoc=args[:seg_subtoc]
      @seg_subtoc_array=args[:seg_subtoc_array]
      @segtocband=args[:fn]
      @fn=args[:fn]
      @seg_name=args[:seg_name]
      @seg_name_x=args[:seg_name_x]
      @seg_name_x_tracker=args[:seg_name_x_tracker]
    end
    def is0
      @is0
    end
    def is1
      @is1
    end
    def is2
      @is2
    end
    def is3
      @is3
    end
    def is4
      @is4
    end
    def heading0
      @heading0
    end
    def heading1
      @heading1
    end
    def heading2
      @heading2
    end
    def heading3
      @heading3
    end
    def heading4
      @heading4
    end
    def title
      @title
    end
    def dot_nav
      @dot_nav
    end
    def tocband_banner
      @tocband_banner
    end
    def tocband_bannerless
      @tocband_bannerless
    end
    def headings
      @headings
    end
    def heading_endnotes
      @heading_endnotes
    end
    def main
      @main
    end
    def endnote_all
      @endnote_all
    end
    def tail
      @tail
    end
    def credits
      @credits
    end
    def heading_idx
      @heading_idx
    end
    def idx
      @idx
    end
    def seg_endnotes
      @seg_endnotes
    end
    def seg_endnotes_array
      @seg_endnotes_array
    end
    def get_hash_to
      @get_hash_to
    end
    def get_hash_fn
      @get_hash_fn
    end
    def seg_subtoc
      @seg_subtoc
    end
    def seg_subtoc_array
      @seg_subtoc_array
    end
    def segtocband
      @segtocband
    end
    def fn
      @fn
    end
    def seg_name
      @seg_name
    end
    def seg_name_x
      @seg_name_x
    end
    def seg_name_x_tracker
      @seg_name_x_tracker
    end
    def persist_init_hash_values
      {
        is0: 0,
        is1: 0,
        is2: 0,
        is3: 0,
        is4: 0,
        heading0: '',
        heading1: '',
        heading2: '',
        heading3: '',
        heading4: '',
        tocband_banner: [],
        tocband_bannerless: [],
        title: [],
        headings: [],
        main: [],
        idx: [],
        tail: [],
        credits: [],
        endnote_all: [],
        heading_endnotes: '',
        seg_endnotes: {},
        seg_endnotes_array: [],
        get_hash_fn: '',
        get_hash_to: '',
        seg_subtoc: {},
        seg_subtoc_array: [],
        segtocband: '',
        fn: '',
        seg_name: [],
        seg_name_x: [],
        seg_name_x_tracker: 0,
      }
    end
    def persist_init
      @@persist=nil
      Persist.new(persist_init_hash_values)
    end
  end
end
__END__
