.TH saned 8 "29 Sep 2017" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX saned
.SH NAME
saned \- SANE network daemon
.SH SYNOPSIS
.B saned
.B [ \-a
.I [ username ]
.B ]
.B [ \-u
.I username
.B ]
.B [ \-b
.I address
.B ]
.B [ \-p
.I port
.B ]
.B [ \-l ]
.B [ \-D ]
.B [ \-o ]
.B [ \-d
.I n
.B ]
.B [ \-e ]
.B [ \-h ]
.B [ \-B
.I buffer-size
.B ]

.SH DESCRIPTION
.B saned
is the SANE (Scanner Access Now Easy) daemon that allows remote clients
to access image acquisition devices available on the local host.

.SH OPTIONS
.PP
.B saned
recognises the following options:

.TP
.BR \-a "\fI [username]\fR, " \-\-alone [=\fIusername]\fR
is equivalent to the combination of
.B \-l \-D \-u
.I username
options. However,
.I username
is optional and running user will only be set when specified.

.TP
.BR \-u "\fI username\fR, " \-\-user =\fIusername\fR
requests that
.B saned
drop root privileges and run as the user (and group) associated with
.I username
after binding.

.TP
.BR \-b "\fI address\fR, " \-\-bind =\fIaddress\fR
tells
.B saned
to bind to the
.I address
given.

.TP
.BR \-p "\fI port\fR, " \-\-port=\fIport\fR
tells
.B saned
to listen on the
.I port
given.  A value of 0 tells
.B saned
to pick an unused port.  The default is the
.B sane-port (6566).

.TP
.BR \-l ", " \-\-listen
requests that
.B saned
run in standalone daemon mode.  In this mode,
.B saned
will listen for incoming client connections;
.BR inetd (8)
is not required for
.B saned
operations in this mode.

.TP
.BR \-D ", " \-\-daemonize
will request
.B saned
to detach from the console and run in the background.

.TP
.BR \-o ", " \-\-once
requests that
.B saned
exits after the first client disconnects.  This is useful for debugging.

.TP
.BR \-d "\fI n\fR, " \-\-debug =\fIn\fR
sets the level of
.B saned
debug output to
.IR n .
When compiled with debugging enabled, this flag may be
followed by a number to request more or less debug info.  The larger
the number, the more verbose the debug output.  E.g.,
.B \-d128
will request output of all debug info.  A level of 0 produces no
output at all.  The default value is 2.

.TP
.BR \-e ", " \-\-stderr
will divert
.B saned
debug output to stderr instead of the syslog default.

.TP
.BR \-B ", " \-\-buffer-size=\fIbuffer\-size\fR
specifies the size of the read buffer used for communication with the backend in KB.
Default value is 1MB.

.TP
.BR \-h ", " \-\-help
displays a short help message.

.SH CONFIGURATION
The
.I saned.conf
configuration file contains both options for the daemon and the access
list.
.TP
\fBdata_portrange\fP = \fImin_port\fP - \fImax_port\fP
Specify the port range to use for the data connection. Pick a port
range between 1024 and 65535; don't pick a too large port range, as it
may have performance issues. Use this option if your
.B saned
server is sitting behind a firewall. If that firewall is a Linux
machine, we strongly recommend using the Netfilter
\fInf_conntrack_sane\fP module instead.
.TP
\fBdata_connect_timeout\fP = \fItimeout\fP
Specify the time in milliseconds that
.B saned
will wait for a data
connection. Without this option, if the data connection is not done
before the scanner reaches the end of scan, the scanner will continue
to scan past the end and may damage it depending on the
backend. Specify zero to have the old behavior. The default is 4000ms.
.PP
The access list is a list of host names, IP addresses or IP subnets
(CIDR notation) that are permitted to use local SANE devices. IPv6
addresses must be enclosed in brackets, and should always be specified
in their compressed form. Connections from localhost are always
permitted. Empty lines and lines starting with a hash mark (#) are
ignored. A line containing the single character ``+'' is interpreted
to match any hostname. This allows any remote machine to use your
scanner and may present a security risk, so this shouldn't be used
unless you know what you're doing.
.PP
A sample configuration file is shown below:
.PP
.RS
# Daemon options
.br
data_portrange = 10000 - 10100
.br
# Access list
.br
scan\-client.somedomain.firm
.br
# this is a comment
.br
192.168.0.1
.br
192.168.2.12/29
.br
[::1]
.br
[2001:db8:185e::42:12]/64
.RE
.PP
The case of the host names does not matter, so AHost.COM is considered
identical to ahost.com.
.SH FILES
.TP
.I /etc/hosts.equiv
The hosts listed in this file are permitted to access all local SANE
devices.  Caveat: this file imposes serious security risks and its use
is not recommended.
.TP
.I @CONFIGDIR@/saned.conf
Contains a list of hosts permitted to access local SANE devices (see
also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @CONFIGDIR@/saned.users
If this file contains lines of the form

user:password:backend

access to the listed backends is restricted. A backend may be listed multiple
times for different user/password combinations. The server uses MD5 hashing
if supported by the client.
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  On *NIX systems, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR tmp/config ,
.IR . ,
and
.I "@CONFIGDIR@"
being searched (in this order).

.SH NOTES
.B saned
does
.I not
provide confidentiality when communicating with clients. If
.B saned
is exposed directly on the network, other users may be able to intercept
scanned images, or learn passwords for connecting to
.BR saned ,
with little effort. Client systems should connect to
.B saned
through a secure tunnel to the server instead.
.PP
.B saned
is not a trusted program and should not run with root privileges.
.PP
Refer to
.I @DOCDIR@/saned/saned.install.md
for details on configuring
.B saned
as a service.

.SH "SEE ALSO"
.BR sane (7),
.BR scanimage (1),
.BR xscanimage (1),
.BR xcam (1),
.BR sane\-dll (5),
.BR sane\-net (5),
.BR sane\-"backendname" (5),
.BR inetd (8),
.BR xinetd (8),
.BR systemd (1)
.br
.I http://www.penguin-breeder.org/?page=sane\-net
.SH AUTHOR
David Mosberger
