
''' Generated by OTF2 Template Engine '''

import ctypes
import traceback
import sys

from .Config import conf, StrParam
from .ErrorCodes import ErrorCode, HandleErrorCode
from .GeneralDefinitions import *
from .AttributeList import AttributeList
from .Definitions import *
from .Events import *
from .Callbacks import callback_wrapper


class GlobalSnapReaderCallbacks(ctypes.Structure):
    pass

def GlobalSnapReaderCallbacks_New():
    c_New = conf.lib.OTF2_GlobalSnapReaderCallbacks_New
    c_New.argtypes = []
    c_New.restype = ctypes.POINTER(GlobalSnapReaderCallbacks)
    # NOTE: Do not errcheck here. This function returns a value, not an error code
    return c_New()

def GlobalSnapReaderCallbacks_Delete(globalSnapReaderCallbacks):
    c_Delete = conf.lib.OTF2_GlobalSnapReaderCallbacks_Delete
    c_Delete.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks) ]
    c_Delete.restype = None
    return c_Delete(globalSnapReaderCallbacks)

def GlobalSnapReaderCallbacks_Clear(globalSnapReaderCallbacks):
    c_Clear = conf.lib.OTF2_GlobalSnapReaderCallbacks_Clear
    c_Clear.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks) ]
    c_Clear.restype = None
    return c_Clear(globalSnapReaderCallbacks)

def _callback_wrapper(type, func, convert_args=None):
    def wrapper(location, time, userData, attribute_list, *args):
        if userData:
            py_userData = ctypes.cast(userData, ctypes.py_object).value
        else:
            py_userData = None
        try:
            if convert_args is not None:
                args = convert_args(*args)
            if not attribute_list:
                attribute_list = None
            ret = func(location, time, py_userData, attribute_list, *args)
            if ret is None:
                ret = CALLBACK_SUCCESS
        except:
            sys.stderr.write("An unhandled python exception has occurred in an "
                             "OTF2_GlobalSnapReaderCallback:\n")
            sys.stderr.write(traceback.format_exc())
            ret = CALLBACK_ERROR
        return ret.value
    return callback_wrapper(func, wrapper, type)

_GlobalSnapReaderCallback_FP_Unknown = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList))

_GlobalSnapReaderCallback_FP_SnapshotStart = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_SnapshotEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MeasurementOnOff = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, MeasurementMode)

_GlobalSnapReaderCallback_FP_Enter = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, RegionRef)

_GlobalSnapReaderCallback_FP_MpiSend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MpiIsend = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MpiIsendComplete = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MpiRecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MpiIrecvRequest = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MpiIrecv = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_MpiCollectiveBegin = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp)

_GlobalSnapReaderCallback_FP_MpiCollectiveEnd = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, CollectiveOp, CommRef, ctypes.c_uint32, ctypes.c_uint64, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_OmpFork = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32)

_GlobalSnapReaderCallback_FP_OmpAcquireLock = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint32, ctypes.c_uint32)

_GlobalSnapReaderCallback_FP_OmpTaskCreate = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_OmpTaskSwitch = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ctypes.c_uint64)

_GlobalSnapReaderCallback_FP_Metric = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, MetricRef, ctypes.c_uint8, ctypes.POINTER(Type), ctypes.POINTER(MetricValue))

_GlobalSnapReaderCallback_FP_ParameterString = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ParameterRef, StringRef)

_GlobalSnapReaderCallback_FP_ParameterInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ParameterRef, ctypes.c_int64)

_GlobalSnapReaderCallback_FP_ParameterUnsignedInt = ctypes.CFUNCTYPE(CallbackCode,
        LocationRef, TimeStamp, ctypes.c_void_p,
        ctypes.POINTER(AttributeList), TimeStamp, ParameterRef, ctypes.c_uint64)

def GlobalSnapReaderCallbacks_SetUnknownCallback(globalSnapReaderCallbacks, unknownCallback):
    c_SetUnknownCallback = conf.lib.OTF2_GlobalSnapReaderCallback_SetUnknownCallback
    c_SetUnknownCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_Unknown ]
    c_SetUnknownCallback.restype = ErrorCode
    c_SetUnknownCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_Unknown,
                                         unknownCallback)
    c_SetUnknownCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetSnapshotStartCallback(globalSnapReaderCallbacks, snapshotStartCallback):
    c_SetSnapshotStartCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetSnapshotStartCallback
    c_SetSnapshotStartCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_SnapshotStart ]
    c_SetSnapshotStartCallback.restype = ErrorCode
    c_SetSnapshotStartCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_snapshotStartCallback,
                                         snapshotStartCallback)
    c_SetSnapshotStartCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetSnapshotEndCallback(globalSnapReaderCallbacks, snapshotEndCallback):
    c_SetSnapshotEndCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetSnapshotEndCallback
    c_SetSnapshotEndCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_SnapshotEnd ]
    c_SetSnapshotEndCallback.restype = ErrorCode
    c_SetSnapshotEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_snapshotEndCallback,
                                         snapshotEndCallback)
    c_SetSnapshotEndCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMeasurementOnOffCallback(globalSnapReaderCallbacks, measurementOnOffCallback):
    c_SetMeasurementOnOffCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMeasurementOnOffCallback
    c_SetMeasurementOnOffCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MeasurementOnOff ]
    c_SetMeasurementOnOffCallback.restype = ErrorCode
    c_SetMeasurementOnOffCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_measurementOnOffCallback,
                                         measurementOnOffCallback)
    c_SetMeasurementOnOffCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetEnterCallback(globalSnapReaderCallbacks, enterCallback):
    c_SetEnterCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetEnterCallback
    c_SetEnterCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_Enter ]
    c_SetEnterCallback.restype = ErrorCode
    c_SetEnterCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_enterCallback,
                                         enterCallback)
    c_SetEnterCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiSendCallback(globalSnapReaderCallbacks, mpiSendCallback):
    c_SetMpiSendCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiSendCallback
    c_SetMpiSendCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiSend ]
    c_SetMpiSendCallback.restype = ErrorCode
    c_SetMpiSendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiSendCallback,
                                         mpiSendCallback)
    c_SetMpiSendCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiIsendCallback(globalSnapReaderCallbacks, mpiIsendCallback):
    c_SetMpiIsendCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiIsendCallback
    c_SetMpiIsendCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiIsend ]
    c_SetMpiIsendCallback.restype = ErrorCode
    c_SetMpiIsendCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiIsendCallback,
                                         mpiIsendCallback)
    c_SetMpiIsendCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiIsendCompleteCallback(globalSnapReaderCallbacks, mpiIsendCompleteCallback):
    c_SetMpiIsendCompleteCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiIsendCompleteCallback
    c_SetMpiIsendCompleteCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiIsendComplete ]
    c_SetMpiIsendCompleteCallback.restype = ErrorCode
    c_SetMpiIsendCompleteCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiIsendCompleteCallback,
                                         mpiIsendCompleteCallback)
    c_SetMpiIsendCompleteCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiRecvCallback(globalSnapReaderCallbacks, mpiRecvCallback):
    c_SetMpiRecvCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiRecvCallback
    c_SetMpiRecvCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiRecv ]
    c_SetMpiRecvCallback.restype = ErrorCode
    c_SetMpiRecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiRecvCallback,
                                         mpiRecvCallback)
    c_SetMpiRecvCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiIrecvRequestCallback(globalSnapReaderCallbacks, mpiIrecvRequestCallback):
    c_SetMpiIrecvRequestCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiIrecvRequestCallback
    c_SetMpiIrecvRequestCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiIrecvRequest ]
    c_SetMpiIrecvRequestCallback.restype = ErrorCode
    c_SetMpiIrecvRequestCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiIrecvRequestCallback,
                                         mpiIrecvRequestCallback)
    c_SetMpiIrecvRequestCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiIrecvCallback(globalSnapReaderCallbacks, mpiIrecvCallback):
    c_SetMpiIrecvCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiIrecvCallback
    c_SetMpiIrecvCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiIrecv ]
    c_SetMpiIrecvCallback.restype = ErrorCode
    c_SetMpiIrecvCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiIrecvCallback,
                                         mpiIrecvCallback)
    c_SetMpiIrecvCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiCollectiveBeginCallback(globalSnapReaderCallbacks, mpiCollectiveBeginCallback):
    c_SetMpiCollectiveBeginCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiCollectiveBeginCallback
    c_SetMpiCollectiveBeginCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiCollectiveBegin ]
    c_SetMpiCollectiveBeginCallback.restype = ErrorCode
    c_SetMpiCollectiveBeginCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiCollectiveBeginCallback,
                                         mpiCollectiveBeginCallback)
    c_SetMpiCollectiveBeginCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMpiCollectiveEndCallback(globalSnapReaderCallbacks, mpiCollectiveEndCallback):
    c_SetMpiCollectiveEndCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMpiCollectiveEndCallback
    c_SetMpiCollectiveEndCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_MpiCollectiveEnd ]
    c_SetMpiCollectiveEndCallback.restype = ErrorCode
    c_SetMpiCollectiveEndCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_mpiCollectiveEndCallback,
                                         mpiCollectiveEndCallback)
    c_SetMpiCollectiveEndCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetOmpForkCallback(globalSnapReaderCallbacks, ompForkCallback):
    c_SetOmpForkCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetOmpForkCallback
    c_SetOmpForkCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_OmpFork ]
    c_SetOmpForkCallback.restype = ErrorCode
    c_SetOmpForkCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_ompForkCallback,
                                         ompForkCallback)
    c_SetOmpForkCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetOmpAcquireLockCallback(globalSnapReaderCallbacks, ompAcquireLockCallback):
    c_SetOmpAcquireLockCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetOmpAcquireLockCallback
    c_SetOmpAcquireLockCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_OmpAcquireLock ]
    c_SetOmpAcquireLockCallback.restype = ErrorCode
    c_SetOmpAcquireLockCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_ompAcquireLockCallback,
                                         ompAcquireLockCallback)
    c_SetOmpAcquireLockCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetOmpTaskCreateCallback(globalSnapReaderCallbacks, ompTaskCreateCallback):
    c_SetOmpTaskCreateCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetOmpTaskCreateCallback
    c_SetOmpTaskCreateCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_OmpTaskCreate ]
    c_SetOmpTaskCreateCallback.restype = ErrorCode
    c_SetOmpTaskCreateCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_ompTaskCreateCallback,
                                         ompTaskCreateCallback)
    c_SetOmpTaskCreateCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetOmpTaskSwitchCallback(globalSnapReaderCallbacks, ompTaskSwitchCallback):
    c_SetOmpTaskSwitchCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetOmpTaskSwitchCallback
    c_SetOmpTaskSwitchCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_OmpTaskSwitch ]
    c_SetOmpTaskSwitchCallback.restype = ErrorCode
    c_SetOmpTaskSwitchCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_ompTaskSwitchCallback,
                                         ompTaskSwitchCallback)
    c_SetOmpTaskSwitchCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetMetricCallback(globalSnapReaderCallbacks, metricCallback):
    c_SetMetricCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetMetricCallback
    c_SetMetricCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_Metric ]
    c_SetMetricCallback.restype = ErrorCode
    c_SetMetricCallback.errcheck = HandleErrorCode
    def convert_args_metric(metric, number_of_metrics, type_ids_array, metric_values_array):
        type_ids = [type_ids_array[i] for i in range(number_of_metrics)]
        metric_values = [metric_values_array[i] for i in range(number_of_metrics)]
        return metric, type_ids, metric_values
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_Metric,
                                         metricCallback, convert_args_metric)
    c_SetMetricCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetParameterStringCallback(globalSnapReaderCallbacks, parameterStringCallback):
    c_SetParameterStringCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetParameterStringCallback
    c_SetParameterStringCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_ParameterString ]
    c_SetParameterStringCallback.restype = ErrorCode
    c_SetParameterStringCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_parameterStringCallback,
                                         parameterStringCallback)
    c_SetParameterStringCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetParameterIntCallback(globalSnapReaderCallbacks, parameterIntCallback):
    c_SetParameterIntCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetParameterIntCallback
    c_SetParameterIntCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_ParameterInt ]
    c_SetParameterIntCallback.restype = ErrorCode
    c_SetParameterIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_parameterIntCallback,
                                         parameterIntCallback)
    c_SetParameterIntCallback(globalSnapReaderCallbacks, wrapped_callback)

def GlobalSnapReaderCallbacks_SetParameterUnsignedIntCallback(globalSnapReaderCallbacks, parameterUnsignedIntCallback):
    c_SetParameterUnsignedIntCallback = conf.lib.OTF2_GlobalSnapReaderCallbacks_SetParameterUnsignedIntCallback
    c_SetParameterUnsignedIntCallback.argtypes = [ ctypes.POINTER(GlobalSnapReaderCallbacks), _GlobalSnapReaderCallback_FP_ParameterUnsignedInt ]
    c_SetParameterUnsignedIntCallback.restype = ErrorCode
    c_SetParameterUnsignedIntCallback.errcheck = HandleErrorCode
    wrapped_callback = _callback_wrapper(_GlobalSnapReaderCallback_FP_parameterUnsignedIntCallback,
                                         parameterUnsignedIntCallback)
    c_SetParameterUnsignedIntCallback(globalSnapReaderCallbacks, wrapped_callback)

__all__ = [
    'GlobalSnapReaderCallbacks',
    'GlobalSnapReaderCallbacks_New',
    'GlobalSnapReaderCallbacks_Delete',
    'GlobalSnapReaderCallbacks_Clear',
    'GlobalSnapReaderCallbacks_SetUnknownCallback',
    'GlobalSnapReaderCallbacks_SetSnapshotStartCallback',
    'GlobalSnapReaderCallbacks_SetSnapshotEndCallback',
    'GlobalSnapReaderCallbacks_SetMeasurementOnOffCallback',
    'GlobalSnapReaderCallbacks_SetEnterCallback',
    'GlobalSnapReaderCallbacks_SetMpiSendCallback',
    'GlobalSnapReaderCallbacks_SetMpiIsendCallback',
    'GlobalSnapReaderCallbacks_SetMpiIsendCompleteCallback',
    'GlobalSnapReaderCallbacks_SetMpiRecvCallback',
    'GlobalSnapReaderCallbacks_SetMpiIrecvRequestCallback',
    'GlobalSnapReaderCallbacks_SetMpiIrecvCallback',
    'GlobalSnapReaderCallbacks_SetMpiCollectiveBeginCallback',
    'GlobalSnapReaderCallbacks_SetMpiCollectiveEndCallback',
    'GlobalSnapReaderCallbacks_SetOmpForkCallback',
    'GlobalSnapReaderCallbacks_SetOmpAcquireLockCallback',
    'GlobalSnapReaderCallbacks_SetOmpTaskCreateCallback',
    'GlobalSnapReaderCallbacks_SetOmpTaskSwitchCallback',
    'GlobalSnapReaderCallbacks_SetMetricCallback',
    'GlobalSnapReaderCallbacks_SetParameterStringCallback',
    'GlobalSnapReaderCallbacks_SetParameterIntCallback',
    'GlobalSnapReaderCallbacks_SetParameterUnsignedIntCallback',
]
