
#include <stdint.h>
#include "tones.h"

static int16_t pattern[] = {
	0x0000, 0x1483,
	0x269d, 0x3420, 0x3b7d, 0x3bd3, 0x3510, 0x280f, 0x164c, 0x01e5,
	0xed4c, 0xdadd, 0xcce2, 0xc4e1, 0xc3ee, 0xca06, 0xd68e, 0xe7f0,
	0xfc34, 0x10e4, 0x239a, 0x3217, 0x3aab, 0x3c48, 0x36d1, 0x2ace,
	0x19ce, 0x05b0, 0xf0f2, 0xddf4, 0xcf02, 0xc5d6, 0xc390, 0xc86a,
	0xd3da, 0xe481, 0xf869, 0x0d36, 0x2074, 0x2fdb, 0x3999, 0x3c89,
	0x384f, 0x2d6e, 0x1d2d, 0x097a, 0xf4a7, 0xe12c, 0xd154, 0xc706,
	0xc36e, 0xc707, 0xd154, 0xe12c, 0xf4a7, 0x0979, 0x1d2e, 0x2d6d,
	0x3850, 0x3c88, 0x399a, 0x2fdb, 0x2072, 0x0d39, 0xf865, 0xe486,
	0xd3d4, 0xc871, 0xc389, 0xc5dd, 0xcefb, 0xddfa, 0xf0ee, 0x05b3,
	0x19cc, 0x2acf, 0x36d0, 0x3c4a, 0x3aaa, 0x3216, 0x239b, 0x10e3,
	0xfc35, 0xe7f1, 0xd68c, 0xca08, 0xc3ec, 0xc4e3, 0xccdf, 0xdae1,
	0xed49, 0x01e7, 0x164b, 0x280e, 0x3511, 0x3bd4, 0x3b7b, 0x3422,
	0x269c, 0x1481, 0x0003, 0xeb7b, 0xd964, 0xcbe2, 0xc47e, 0xc433,
	0xcaea, 0xd7f6, 0xe9b2, 0xfe1a, 0x12b8, 0x251d, 0x3324, 0x3b1a,
	0x3c16, 0x35f7, 0x2975, 0x180d, 0x03cf, 0xef18, 0xdc69, 0xcde7,
	0xc559, 0xc3b3, 0xc935, 0xd52b, 0xe637, 0xfa4e, 0x0f0f, 0x220b,
	0x30ff, 0x3a28, 0x3c73, 0x3793, 0x2c28, 0x1b7d, 0x0799, 0xf2c8,
	0xdf8e, 0xd023, 0xc66a, 0xc375, 0xc7b2, 0xd291, 0xe2d2, 0xf689,
	0x0b57, 0x1ed7, 0x2ea8, 0x38fc, 0x3c90, 0x38fd, 0x2ea8, 0x1ed7,
	0x0b56, 0xf68a, 0xe2d1, 0xd293, 0xc7af, 0xc379, 0xc665, 0xd028,
	0xdf8a, 0xf2cc, 0x0795, 0x1b80, 0x2c26, 0x3795, 0x3c71, 0x3a2a,
	0x30fd, 0x220d, 0x0f0e, 0xfa4e, 0xe636, 0xd52d, 0xc934, 0xc3b3,
	0xc559, 0xcde7, 0xdc69, 0xef18, 0x03d0, 0x180a, 0x297a, 0x35f2,
	0x3c1a, 0x3b17, 0x3326, 0x251c, 0x12b9, 0xfe17, 0xe9b6, 0xd7f2,
	0xcaef, 0xc42d, 0xc483, 0xcbde, 0xd967, 0xeb7b,
};

static int16_t tone[12000];

extern int16_t *ringback_spl;
extern int ringback_size;
extern int ringback_max;
extern int16_t *busy_spl;
extern int busy_size;
extern int busy_max;
extern int16_t *congestion_spl;
extern int congestion_size;
extern int congestion_max;

void init_radiocom_tones(void)
{
	int i, j;


	for (i = 0, j = 0; i < 12000; i++) {
		tone[i] = pattern[j++];
		if (j == 200)
			j = 0;
	}

	ringback_spl = tone;
	ringback_size = 12000;
	ringback_max = 8 * 5000; /* 1500 / 3500 */

	busy_spl = tone;
	busy_size = 4000;
	busy_max = 8 * 1000; /* 500 / 500 */

	congestion_spl = tone;
	congestion_size = 4000;
	congestion_max = 8 * 1000; /* 500 / 500 */
}

