using Gee;

public class UnicodeMatch {

  public string match_key   { get; private set; default = ""; }
  public string match_value { get; private set; default = ""; }

  public UnicodeMatch( string key, string val ) {
    match_key = key;
    match_value = val;
  }

}

public class UnicodeInsert {

  private static HashMap<string, string>? _insert_map = null;

  /* Constructor */
  public UnicodeInsert() {
    if( _insert_map == null ) {
      _insert_map = new HashMap<string, string>();
      _insert_map.set( "\\!'", "¡" );
      _insert_map.set( "\\\"A", "Ä" );
      _insert_map.set( "\\\"E", "Ë" );
      _insert_map.set( "\\\"H", "Ḧ" );
      _insert_map.set( "\\\"I", "Ï" );
      _insert_map.set( "\\\"O", "Ö" );
      _insert_map.set( "\\\"U", "Ü" );
      _insert_map.set( "\\\"W", "Ẅ" );
      _insert_map.set( "\\\"X", "Ẍ" );
      _insert_map.set( "\\\"Y", "Ÿ" );
      _insert_map.set( "\\\"a", "ä" );
      _insert_map.set( "\\\"e", "ë" );
      _insert_map.set( "\\\"h", "ḧ" );
      _insert_map.set( "\\\"i", "ï" );
      _insert_map.set( "\\\"o", "ö" );
      _insert_map.set( "\\\"t", "ẗ" );
      _insert_map.set( "\\\"u", "ü" );
      _insert_map.set( "\\\"w", "ẅ" );
      _insert_map.set( "\\\"x", "ẍ" );
      _insert_map.set( "\\\"y", "ÿ" );
      _insert_map.set( "\\'", "′" );
      _insert_map.set( "\\''", "″" );
      _insert_map.set( "\\'''", "‴" );
      _insert_map.set( "\\'A", "Á" );
      _insert_map.set( "\\'C", "Ć" );
      _insert_map.set( "\\'E", "É" );
      _insert_map.set( "\\'G", "Ǵ" );
      _insert_map.set( "\\'I", "Í" );
      _insert_map.set( "\\'K", "Ḱ" );
      _insert_map.set( "\\'L", "Ĺ" );
      _insert_map.set( "\\'M", "Ḿ" );
      _insert_map.set( "\\'N", "Ń" );
      _insert_map.set( "\\'O", "Ó" );
      _insert_map.set( "\\'P", "Ṕ" );
      _insert_map.set( "\\'R", "Ŕ" );
      _insert_map.set( "\\'S", "Ś" );
      _insert_map.set( "\\'U", "Ú" );
      _insert_map.set( "\\'W", "Ẃ" );
      _insert_map.set( "\\'Y", "Ý" );
      _insert_map.set( "\\'Z", "Ź" );
      _insert_map.set( "\\'a", "á" );
      _insert_map.set( "\\'c", "ć" );
      _insert_map.set( "\\'e", "é" );
      _insert_map.set( "\\'g", "ǵ" );
      _insert_map.set( "\\'i", "í" );
      _insert_map.set( "\\'k", "ḱ" );
      _insert_map.set( "\\'l", "ĺ" );
      _insert_map.set( "\\'m", "ḿ" );
      _insert_map.set( "\\'n", "ń" );
      _insert_map.set( "\\'o", "ó" );
      _insert_map.set( "\\'p", "ṕ" );
      _insert_map.set( "\\'r", "ŕ" );
      _insert_map.set( "\\'s", "ś" );
      _insert_map.set( "\\'u", "ú" );
      _insert_map.set( "\\'w", "ẃ" );
      _insert_map.set( "\\'y", "ý" );
      _insert_map.set( "\\'z", "ź" );
      _insert_map.set( "\\--", "–" );
      _insert_map.set( "\\---", "—" );
      _insert_map.set( "\\->", "→" );
      _insert_map.set( "\\.A", "Ȧ" );
      _insert_map.set( "\\.B", "Ḃ" );
      _insert_map.set( "\\.C", "Ċ" );
      _insert_map.set( "\\.D", "Ḋ" );
      _insert_map.set( "\\.E", "Ė" );
      _insert_map.set( "\\.F", "Ḟ" );
      _insert_map.set( "\\.G", "Ġ" );
      _insert_map.set( "\\.H", "Ḣ" );
      _insert_map.set( "\\.I", "İ" );
      _insert_map.set( "\\.M", "Ṁ" );
      _insert_map.set( "\\.N", "Ṅ" );
      _insert_map.set( "\\.O", "Ȯ" );
      _insert_map.set( "\\.P", "Ṗ" );
      _insert_map.set( "\\.R", "Ṙ" );
      _insert_map.set( "\\.S", "Ṡ" );
      _insert_map.set( "\\.T", "Ṫ" );
      _insert_map.set( "\\.W", "Ẇ" );
      _insert_map.set( "\\.X", "Ẋ" );
      _insert_map.set( "\\.Y", "Ẏ" );
      _insert_map.set( "\\.Z", "Ż" );
      _insert_map.set( "\\.a", "ȧ" );
      _insert_map.set( "\\.b", "ḃ" );
      _insert_map.set( "\\.c", "ċ" );
      _insert_map.set( "\\.d", "ḋ" );
      _insert_map.set( "\\.e", "ė" );
      _insert_map.set( "\\.f", "ḟ" );
      _insert_map.set( "\\.g", "ġ" );
      _insert_map.set( "\\.h", "ḣ" );
      _insert_map.set( "\\.m", "ṁ" );
      _insert_map.set( "\\.n", "ṅ" );
      _insert_map.set( "\\.o", "ȯ" );
      _insert_map.set( "\\.p", "ṗ" );
      _insert_map.set( "\\.r", "ṙ" );
      _insert_map.set( "\\.s", "ṡ" );
      _insert_map.set( "\\.t", "ṫ" );
      _insert_map.set( "\\.w", "ẇ" );
      _insert_map.set( "\\.x", "ẋ" );
      _insert_map.set( "\\.y", "ẏ" );
      _insert_map.set( "\\.z", "ż" );
      _insert_map.set( "\\:=", "≝" );
      _insert_map.set( "\\<-", "←" );
      _insert_map.set( "\\<=", "≤" );
      _insert_map.set( "\\<==", "⇐" );
      _insert_map.set( "\\<==>", "⇔" );
      _insert_map.set( "\\==>", "⇒" );
      _insert_map.set( "\\=A", "Ā" );
      _insert_map.set( "\\=E", "Ē" );
      _insert_map.set( "\\=G", "Ḡ" );
      _insert_map.set( "\\=I", "Ī" );
      _insert_map.set( "\\=O", "Ō" );
      _insert_map.set( "\\=U", "Ū" );
      _insert_map.set( "\\=Y", "Ȳ" );
      _insert_map.set( "\\=a", "ā" );
      _insert_map.set( "\\=e", "ē" );
      _insert_map.set( "\\=g", "ḡ" );
      _insert_map.set( "\\=i", "ī" );
      _insert_map.set( "\\=o", "ō" );
      _insert_map.set( "\\=u", "ū" );
      _insert_map.set( "\\=y", "ȳ" );
      _insert_map.set( "\\>=", "≥" );
      _insert_map.set( "\\AA", "Å" );
      _insert_map.set( "\\AE", "Æ" );
      _insert_map.set( "\\AElig", "Æ" );
      _insert_map.set( "\\Aacute", "Á" );
      _insert_map.set( "\\Abreve", "Ă" );
      _insert_map.set( "\\Acirc", "Â" );
      _insert_map.set( "\\Acy", "А" );
      _insert_map.set( "\\Afr", "𝔄" );
      _insert_map.set( "\\Agrave", "À" );
      _insert_map.set( "\\Alpha", "Α" );
      _insert_map.set( "\\Amacr", "Ā" );
      _insert_map.set( "\\And", "⩓" );
      _insert_map.set( "\\Aogon", "Ą" );
      _insert_map.set( "\\Aopf", "𝔸" );
      _insert_map.set( "\\ApplyFunction", "⁡" );
      _insert_map.set( "\\Aring", "Å" );
      _insert_map.set( "\\Ascr", "𝒜" );
      _insert_map.set( "\\Assign", "≔" );
      _insert_map.set( "\\Atilde", "Ã" );
      _insert_map.set( "\\Auml", "Ä" );
      _insert_map.set( "\\Backslash", "∖" );
      _insert_map.set( "\\Barv", "⫧" );
      _insert_map.set( "\\Barwed", "⌆" );
      _insert_map.set( "\\Bcy", "Б" );
      _insert_map.set( "\\Because", "∵" );
      _insert_map.set( "\\Bernoullis", "ℬ" );
      _insert_map.set( "\\Beta", "Β" );
      _insert_map.set( "\\Bfr", "𝔅" );
      _insert_map.set( "\\Bopf", "𝔹" );
      _insert_map.set( "\\Box", "□" );
      _insert_map.set( "\\Breve", "˘" );
      _insert_map.set( "\\Bscr", "ℬ" );
      _insert_map.set( "\\Bumpeq", "≎" );
      _insert_map.set( "\\CHcy", "Ч" );
      _insert_map.set( "\\Cacute", "Ć" );
      _insert_map.set( "\\Cap", "⋒" );
      _insert_map.set( "\\CapitalDifferentialD", "ⅅ" );
      _insert_map.set( "\\Cayleys", "ℭ" );
      _insert_map.set( "\\Ccaron", "Č" );
      _insert_map.set( "\\Ccedil", "Ç" );
      _insert_map.set( "\\Ccirc", "Ĉ" );
      _insert_map.set( "\\Cconint", "∰" );
      _insert_map.set( "\\Cdot", "Ċ" );
      _insert_map.set( "\\Cedilla", "¸" );
      _insert_map.set( "\\CenterDot", "·" );
      _insert_map.set( "\\Cfr", "ℭ" );
      _insert_map.set( "\\Chi", "Χ" );
      _insert_map.set( "\\CircleDot", "⊙" );
      _insert_map.set( "\\CircleMinus", "⊖" );
      _insert_map.set( "\\CirclePlus", "⊕" );
      _insert_map.set( "\\CircleTimes", "⊗" );
      _insert_map.set( "\\ClockwiseContourIntegral", "∲" );
      _insert_map.set( "\\CloseCurlyDoubleQuote", "”" );
      _insert_map.set( "\\CloseCurlyQuote", "’" );
      _insert_map.set( "\\Colon", "∷" );
      _insert_map.set( "\\Colone", "⩴" );
      _insert_map.set( "\\Congruent", "≡" );
      _insert_map.set( "\\Conint", "∯" );
      _insert_map.set( "\\ContourIntegral", "∮" );
      _insert_map.set( "\\Copf", "ℂ" );
      _insert_map.set( "\\Coproduct", "∐" );
      _insert_map.set( "\\CounterClockwiseContourIntegral", "∳" );
      _insert_map.set( "\\Cross", "⨯" );
      _insert_map.set( "\\Cscr", "𝒞" );
      _insert_map.set( "\\Cup", "⋓" );
      _insert_map.set( "\\CupCap", "≍" );
      _insert_map.set( "\\DD", "ⅅ" );
      _insert_map.set( "\\DDotrahd", "⤑" );
      _insert_map.set( "\\DH", "Ð" );
      _insert_map.set( "\\DJcy", "Ђ" );
      _insert_map.set( "\\DScy", "Ѕ" );
      _insert_map.set( "\\DZcy", "Џ" );
      _insert_map.set( "\\Dagger", "‡" );
      _insert_map.set( "\\Darr", "↡" );
      _insert_map.set( "\\Dashv", "⫤" );
      _insert_map.set( "\\Dcaron", "Ď" );
      _insert_map.set( "\\Dcy", "Д" );
      _insert_map.set( "\\Del", "∇" );
      _insert_map.set( "\\Delta", "Δ" );
      _insert_map.set( "\\Dfr", "𝔇" );
      _insert_map.set( "\\DiacriticalAcute", "´" );
      _insert_map.set( "\\DiacriticalDot", "˙" );
      _insert_map.set( "\\DiacriticalDoubleAcute", "˝" );
      _insert_map.set( "\\DiacriticalTilde", "˜" );
      _insert_map.set( "\\Diamond", "◇" );
      _insert_map.set( "\\DifferentialD", "ⅆ" );
      _insert_map.set( "\\Dopf", "𝔻" );
      _insert_map.set( "\\Dot", "¨" );
      _insert_map.set( "\\DotDot", "⃜" );
      _insert_map.set( "\\DotEqual", "≐" );
      _insert_map.set( "\\DoubleContourIntegral", "∯" );
      _insert_map.set( "\\DoubleDot", "¨" );
      _insert_map.set( "\\DoubleDownArrow", "⇓" );
      _insert_map.set( "\\DoubleLeftArrow", "⇐" );
      _insert_map.set( "\\DoubleLeftRightArrow", "⇔" );
      _insert_map.set( "\\DoubleLeftTee", "⫤" );
      _insert_map.set( "\\DoubleLongLeftArrow", "" );
      _insert_map.set( "\\DoubleLongLeftRightArrow", "" );
      _insert_map.set( "\\DoubleLongRightArrow", "" );
      _insert_map.set( "\\DoubleRightArrow", "⇒" );
      _insert_map.set( "\\DoubleRightTee", "⊨" );
      _insert_map.set( "\\DoubleUpArrow", "⇑" );
      _insert_map.set( "\\DoubleUpDownArrow", "⇕" );
      _insert_map.set( "\\DoubleVerticalBar", "∥" );
      _insert_map.set( "\\DownArrow", "↓" );
      _insert_map.set( "\\DownArrowBar", "⤓" );
      _insert_map.set( "\\DownArrowUpArrow", "⇵" );
      _insert_map.set( "\\DownBreve", "̑" );
      _insert_map.set( "\\DownLeftRightVector", "⥐" );
      _insert_map.set( "\\DownLeftTeeVector", "⥞" );
      _insert_map.set( "\\DownLeftVector", "↽" );
      _insert_map.set( "\\DownLeftVectorBar", "⥖" );
      _insert_map.set( "\\DownRightTeeVector", "⥟" );
      _insert_map.set( "\\DownRightVector", "⇁" );
      _insert_map.set( "\\DownRightVectorBar", "⥗" );
      _insert_map.set( "\\DownTee", "⊤" );
      _insert_map.set( "\\DownTeeArrow", "↧" );
      _insert_map.set( "\\Downarrow", "⇓" );
      _insert_map.set( "\\Dscr", "𝒟" );
      _insert_map.set( "\\Dstrok", "Đ" );
      _insert_map.set( "\\ENG", "Ŋ" );
      _insert_map.set( "\\ETH", "Ð" );
      _insert_map.set( "\\Eacute", "É" );
      _insert_map.set( "\\Ecaron", "Ě" );
      _insert_map.set( "\\Ecirc", "Ê" );
      _insert_map.set( "\\Ecy", "Э" );
      _insert_map.set( "\\Edot", "Ė" );
      _insert_map.set( "\\Efr", "𝔈" );
      _insert_map.set( "\\Egrave", "È" );
      _insert_map.set( "\\Element", "∈" );
      _insert_map.set( "\\Emacr", "Ē" );
      _insert_map.set( "\\EmptySmallSquare", "◽" );
      _insert_map.set( "\\EmptyVerySmallSquare", "" );
      _insert_map.set( "\\Eogon", "Ę" );
      _insert_map.set( "\\Eopf", "𝔼" );
      _insert_map.set( "\\Epsilon", "Ε" );
      _insert_map.set( "\\Equal", "⩵" );
      _insert_map.set( "\\EqualTilde", "≂" );
      _insert_map.set( "\\Equilibrium", "⇌" );
      _insert_map.set( "\\Escr", "ℰ" );
      _insert_map.set( "\\Esim", "⩳" );
      _insert_map.set( "\\Eta", "Η" );
      _insert_map.set( "\\Euml", "Ë" );
      _insert_map.set( "\\Exists", "∃" );
      _insert_map.set( "\\ExponentialE", "ⅇ" );
      _insert_map.set( "\\F", "Φ" );
      _insert_map.set( "\\Fcy", "Ф" );
      _insert_map.set( "\\Ffr", "𝔉" );
      _insert_map.set( "\\FilledSmallSquare", "◾" );
      _insert_map.set( "\\FilledVerySmallSquare", "" );
      _insert_map.set( "\\Finv", "Ⅎ" );
      _insert_map.set( "\\Fopf", "𝔽" );
      _insert_map.set( "\\ForAll", "∀" );
      _insert_map.set( "\\Fouriertrf", "ℱ" );
      _insert_map.set( "\\Fscr", "ℱ" );
      _insert_map.set( "\\GJcy", "Ѓ" );
      _insert_map.set( "\\Gamma", "Γ" );
      _insert_map.set( "\\Gammad", "Ϝ" );
      _insert_map.set( "\\Gbreve", "Ğ" );
      _insert_map.set( "\\Gcedil", "Ģ" );
      _insert_map.set( "\\Gcirc", "Ĝ" );
      _insert_map.set( "\\Gcy", "Г" );
      _insert_map.set( "\\Gdot", "Ġ" );
      _insert_map.set( "\\Gfr", "𝔊" );
      _insert_map.set( "\\Gg", "⋙" );
      _insert_map.set( "\\Gopf", "𝔾" );
      _insert_map.set( "\\GreaterEqual", "≥" );
      _insert_map.set( "\\GreaterEqualLess", "⋛" );
      _insert_map.set( "\\GreaterFullEqual", "≧" );
      _insert_map.set( "\\GreaterGreater", "⪢" );
      _insert_map.set( "\\GreaterLess", "≷" );
      _insert_map.set( "\\GreaterSlantEqual", "⩾" );
      _insert_map.set( "\\GreaterTilde", "≳" );
      _insert_map.set( "\\Gscr", "𝒢" );
      _insert_map.set( "\\Gt", "≫" );
      _insert_map.set( "\\HARDcy", "Ъ" );
      _insert_map.set( "\\Hacek", "ˇ" );
      _insert_map.set( "\\Hat", "̂" );
      _insert_map.set( "\\Hcirc", "Ĥ" );
      _insert_map.set( "\\Hfr", "ℌ" );
      _insert_map.set( "\\HilbertSpace", "ℋ" );
      _insert_map.set( "\\Hopf", "ℍ" );
      _insert_map.set( "\\HorizontalLine", "─" );
      _insert_map.set( "\\Hscr", "ℋ" );
      _insert_map.set( "\\Hstrok", "Ħ" );
      _insert_map.set( "\\HumpDownHump", "≎" );
      _insert_map.set( "\\HumpEqual", "≏" );
      _insert_map.set( "\\IEcy", "Е" );
      _insert_map.set( "\\IJlig", "Ĳ" );
      _insert_map.set( "\\IOcy", "Ё" );
      _insert_map.set( "\\Iacute", "Í" );
      _insert_map.set( "\\Icirc", "Î" );
      _insert_map.set( "\\Icy", "И" );
      _insert_map.set( "\\Idot", "İ" );
      _insert_map.set( "\\Ifr", "ℑ" );
      _insert_map.set( "\\Igrave", "Ì" );
      _insert_map.set( "\\Im", "ℑ" );
      _insert_map.set( "\\Imacr", "Ī" );
      _insert_map.set( "\\ImaginaryI", "ⅈ" );
      _insert_map.set( "\\Implies", "⇒" );
      _insert_map.set( "\\Int", "∬" );
      _insert_map.set( "\\Integral", "∫" );
      _insert_map.set( "\\Intersection", "⋂" );
      _insert_map.set( "\\InvisibleComma", "​" );
      _insert_map.set( "\\InvisibleTimes", "⁢" );
      _insert_map.set( "\\Iogon", "Į" );
      _insert_map.set( "\\Iopf", "𝕀" );
      _insert_map.set( "\\Iscr", "ℐ" );
      _insert_map.set( "\\Itilde", "Ĩ" );
      _insert_map.set( "\\Iukcy", "І" );
      _insert_map.set( "\\Iuml", "Ï" );
      _insert_map.set( "\\Jcirc", "Ĵ" );
      _insert_map.set( "\\Jcy", "Й" );
      _insert_map.set( "\\Jfr", "𝔍" );
      _insert_map.set( "\\Join", "⋈" );
      _insert_map.set( "\\Jopf", "𝕁" );
      _insert_map.set( "\\Jscr", "𝒥" );
      _insert_map.set( "\\Jsercy", "Ј" );
      _insert_map.set( "\\Jukcy", "Є" );
      _insert_map.set( "\\KHcy", "Х" );
      _insert_map.set( "\\KJcy", "Ќ" );
      _insert_map.set( "\\Kappa", "Κ" );
      _insert_map.set( "\\Kcedil", "Ķ" );
      _insert_map.set( "\\Kcy", "К" );
      _insert_map.set( "\\Kfr", "𝔎" );
      _insert_map.set( "\\Kopf", "𝕂" );
      _insert_map.set( "\\Kscr", "𝒦" );
      _insert_map.set( "\\L", "Ł" );
      _insert_map.set( "\\LJcy", "Љ" );
      _insert_map.set( "\\Lacute", "Ĺ" );
      _insert_map.set( "\\Lambda", "Λ" );
      _insert_map.set( "\\Lang", "⟪" );
      _insert_map.set( "\\Laplacetrf", "ℒ" );
      _insert_map.set( "\\Larr", "↞" );
      _insert_map.set( "\\Lcaron", "Ľ" );
      _insert_map.set( "\\Lcedil", "Ļ" );
      _insert_map.set( "\\Lcy", "Л" );
      _insert_map.set( "\\LeftAngleBracket", "⟨" );
      _insert_map.set( "\\LeftArrow", "←" );
      _insert_map.set( "\\LeftArrowBar", "⇤" );
      _insert_map.set( "\\LeftArrowRightArrow", "⇆" );
      _insert_map.set( "\\LeftCeiling", "⌈" );
      _insert_map.set( "\\LeftDoubleBracket", "⟦" );
      _insert_map.set( "\\LeftDownTeeVector", "⥡" );
      _insert_map.set( "\\LeftDownVector", "⇃" );
      _insert_map.set( "\\LeftDownVectorBar", "⥙" );
      _insert_map.set( "\\LeftFloor", "⌊" );
      _insert_map.set( "\\LeftRightArrow", "↔" );
      _insert_map.set( "\\LeftRightVector", "⥎" );
      _insert_map.set( "\\LeftTee", "⊣" );
      _insert_map.set( "\\LeftTeeArrow", "↤" );
      _insert_map.set( "\\LeftTeeVector", "⥚" );
      _insert_map.set( "\\LeftTriangle", "⊲" );
      _insert_map.set( "\\LeftTriangleBar", "⧏" );
      _insert_map.set( "\\LeftTriangleEqual", "⊴" );
      _insert_map.set( "\\LeftUpDownVector", "⥑" );
      _insert_map.set( "\\LeftUpTeeVector", "⥠" );
      _insert_map.set( "\\LeftUpVector", "↿" );
      _insert_map.set( "\\LeftUpVectorBar", "⥘" );
      _insert_map.set( "\\LeftVector", "↼" );
      _insert_map.set( "\\LeftVectorBar", "⥒" );
      _insert_map.set( "\\Leftarrow", "⇐" );
      _insert_map.set( "\\Leftrightarrow", "⇔" );
      _insert_map.set( "\\LessEqualGreater", "⋚" );
      _insert_map.set( "\\LessFullEqual", "≦" );
      _insert_map.set( "\\LessGreater", "≶" );
      _insert_map.set( "\\LessLess", "⪡" );
      _insert_map.set( "\\LessSlantEqual", "⩽" );
      _insert_map.set( "\\LessTilde", "≲" );
      _insert_map.set( "\\Lfr", "𝔏" );
      _insert_map.set( "\\Ll", "⋘" );
      _insert_map.set( "\\Lleftarrow", "⇚" );
      _insert_map.set( "\\Lmidot", "Ŀ" );
      _insert_map.set( "\\LongLeftArrow", "" );
      _insert_map.set( "\\LongLeftRightArrow", "" );
      _insert_map.set( "\\LongRightArrow", "" );
      _insert_map.set( "\\Longleftarrow", "⇐" );
      _insert_map.set( "\\Longleftrightarrow", "⇔" );
      _insert_map.set( "\\Longrightarrow", "⇒" );
      _insert_map.set( "\\Lopf", "𝕃" );
      _insert_map.set( "\\LowerLeftArrow", "↙" );
      _insert_map.set( "\\LowerRightArrow", "↘" );
      _insert_map.set( "\\Lscr", "ℒ" );
      _insert_map.set( "\\Lsh", "↰" );
      _insert_map.set( "\\Lstrok", "Ł" );
      _insert_map.set( "\\Lt", "≪" );
      _insert_map.set( "\\Map", "⤅" );
      _insert_map.set( "\\Mcy", "М" );
      _insert_map.set( "\\MediumSpace", " " );
      _insert_map.set( "\\Mellintrf", "ℳ" );
      _insert_map.set( "\\Mfr", "𝔐" );
      _insert_map.set( "\\MinusPlus", "∓" );
      _insert_map.set( "\\Mopf", "𝕄" );
      _insert_map.set( "\\Mscr", "ℳ" );
      _insert_map.set( "\\Mu", "Μ" );
      _insert_map.set( "\\NJcy", "Њ" );
      _insert_map.set( "\\Nacute", "Ń" );
      _insert_map.set( "\\Ncaron", "Ň" );
      _insert_map.set( "\\Ncedil", "Ņ" );
      _insert_map.set( "\\Ncy", "Н" );
      _insert_map.set( "\\NegativeMediumSpace", " " );
      _insert_map.set( "\\NegativeThickSpace", " " );
      _insert_map.set( "\\NegativeThinSpace", " " );
      _insert_map.set( "\\NegativeVeryThinSpace", " " );
      _insert_map.set( "\\NestedGreaterGreater", "≫" );
      _insert_map.set( "\\NestedLessLess", "≪" );
      _insert_map.set( "\\Nfr", "𝔑" );
      _insert_map.set( "\\NoBreak", "﻿" );
      _insert_map.set( "\\NonBreakingSpace", " " );
      _insert_map.set( "\\Nopf", "ℕ" );
      _insert_map.set( "\\Not", "⫬" );
      _insert_map.set( "\\NotCongruent", "≢" );
      _insert_map.set( "\\NotCupCap", "≭" );
      _insert_map.set( "\\NotDoubleVerticalBar", "∦" );
      _insert_map.set( "\\NotElement", "∉" );
      _insert_map.set( "\\NotEqual", "≠" );
      _insert_map.set( "\\NotEqualTilde", "≂̸" );
      _insert_map.set( "\\NotExists", "∄" );
      _insert_map.set( "\\NotGreater", "≯" );
      _insert_map.set( "\\NotGreaterEqual", "≱⃥" );
      _insert_map.set( "\\NotGreaterFullEqual", "≰" );
      _insert_map.set( "\\NotGreaterGreater", "≫̸" );
      _insert_map.set( "\\NotGreaterLess", "≹" );
      _insert_map.set( "\\NotGreaterSlantEqual", "≱" );
      _insert_map.set( "\\NotGreaterTilde", "≵" );
      _insert_map.set( "\\NotHumpDownHump", "≎̸" );
      _insert_map.set( "\\NotHumpEqual", "≏̸" );
      _insert_map.set( "\\NotLeftTriangle", "⋪" );
      _insert_map.set( "\\NotLeftTriangleBar", "⧏̸" );
      _insert_map.set( "\\NotLeftTriangleEqual", "⋬" );
      _insert_map.set( "\\NotLess", "≮" );
      _insert_map.set( "\\NotLessEqual", "≰⃥" );
      _insert_map.set( "\\NotLessGreater", "≸" );
      _insert_map.set( "\\NotLessLess", "≪̸" );
      _insert_map.set( "\\NotLessSlantEqual", "≰" );
      _insert_map.set( "\\NotLessTilde", "≴" );
      _insert_map.set( "\\NotNestedGreaterGreater", "⒢̸" );
      _insert_map.set( "\\NotNestedLessLess", "⒡̸" );
      _insert_map.set( "\\NotPrecedes", "⊀" );
      _insert_map.set( "\\NotPrecedesEqual", "⪯̸" );
      _insert_map.set( "\\NotPrecedesSlantEqual", "⋠" );
      _insert_map.set( "\\NotReverseElement", "∌" );
      _insert_map.set( "\\NotRightTriangle", "⋫" );
      _insert_map.set( "\\NotRightTriangleBar", "⧐̸" );
      _insert_map.set( "\\NotRightTriangleEqual", "⋭" );
      _insert_map.set( "\\NotSquareSubset", "⊏̸" );
      _insert_map.set( "\\NotSquareSubsetEqual", "⋢" );
      _insert_map.set( "\\NotSquareSuperset", "⊐̸" );
      _insert_map.set( "\\NotSquareSupersetEqual", "⋣" );
      _insert_map.set( "\\NotSubset", "⊄" );
      _insert_map.set( "\\NotSubsetEqual", "⊈" );
      _insert_map.set( "\\NotSucceeds", "⊁" );
      _insert_map.set( "\\NotSucceedsEqual", "⪰̸" );
      _insert_map.set( "\\NotSucceedsSlantEqual", "⋡" );
      _insert_map.set( "\\NotSucceedsTilde", "≿̸" );
      _insert_map.set( "\\NotSuperset", "⊅" );
      _insert_map.set( "\\NotSupersetEqual", "⊉" );
      _insert_map.set( "\\NotTilde", "≁" );
      _insert_map.set( "\\NotTildeEqual", "≄" );
      _insert_map.set( "\\NotTildeFullEqual", "≇" );
      _insert_map.set( "\\NotTildeTilde", "≉" );
      _insert_map.set( "\\NotVerticalBar", "∤" );
      _insert_map.set( "\\Nscr", "𝒩" );
      _insert_map.set( "\\Ntilde", "Ñ" );
      _insert_map.set( "\\Nu", "Ν" );
      _insert_map.set( "\\O", "Ø" );
      _insert_map.set( "\\OE", "Œ" );
      _insert_map.set( "\\OElig", "Œ" );
      _insert_map.set( "\\Oacute", "Ó" );
      _insert_map.set( "\\Ocirc", "Ô" );
      _insert_map.set( "\\Ocy", "О" );
      _insert_map.set( "\\Odblac", "Ő" );
      _insert_map.set( "\\Ofr", "𝔒" );
      _insert_map.set( "\\Ograve", "Ò" );
      _insert_map.set( "\\Omacr", "Ō" );
      _insert_map.set( "\\Omega", "Ω" );
      _insert_map.set( "\\Omicron", "Ο" );
      _insert_map.set( "\\Oopf", "𝕆" );
      _insert_map.set( "\\OpenCurlyDoubleQuote", "“" );
      _insert_map.set( "\\OpenCurlyQuote", "‘" );
      _insert_map.set( "\\Or", "⩔" );
      _insert_map.set( "\\Oscr", "𝒪" );
      _insert_map.set( "\\Oslash", "Ø" );
      _insert_map.set( "\\Otilde", "Õ" );
      _insert_map.set( "\\Otimes", "⨷" );
      _insert_map.set( "\\Ouml", "Ö" );
      _insert_map.set( "\\OverBar", "¯" );
      _insert_map.set( "\\OverBrace", "︷" );
      _insert_map.set( "\\OverBracket", "⎴" );
      _insert_map.set( "\\OverParenthesis", "︵" );
      _insert_map.set( "\\P", "¶" );
      _insert_map.set( "\\PartialD", "∂" );
      _insert_map.set( "\\Pcy", "П" );
      _insert_map.set( "\\Pfr", "𝔓" );
      _insert_map.set( "\\Phi", "Φ" );
      _insert_map.set( "\\Pi", "Π" );
      _insert_map.set( "\\PlusMinus", "±" );
      _insert_map.set( "\\Poincareplane", "ℌ" );
      _insert_map.set( "\\Popf", "ℙ" );
      _insert_map.set( "\\Precedes", "≺" );
      _insert_map.set( "\\PrecedesEqual", "⪯" );
      _insert_map.set( "\\PrecedesSlantEqual", "≼" );
      _insert_map.set( "\\PrecedesTilde", "≾" );
      _insert_map.set( "\\Prime", "″" );
      _insert_map.set( "\\Product", "∏" );
      _insert_map.set( "\\Proportion", "∷" );
      _insert_map.set( "\\Proportional", "∝" );
      _insert_map.set( "\\Pscr", "𝒫" );
      _insert_map.set( "\\Psi", "Ψ 2" );
      _insert_map.set( "\\Qfr", "𝔔" );
      _insert_map.set( "\\Qopf", "ℚ" );
      _insert_map.set( "\\Qscr", "𝒬" );
      _insert_map.set( "\\RBarr", "⤐" );
      _insert_map.set( "\\Racute", "Ŕ" );
      _insert_map.set( "\\Rang", "⟫" );
      _insert_map.set( "\\Rarr", "↠" );
      _insert_map.set( "\\Rarrtl", "⤖" );
      _insert_map.set( "\\Rcaron", "Ř" );
      _insert_map.set( "\\Rcedil", "Ŗ" );
      _insert_map.set( "\\Rcy", "Р" );
      _insert_map.set( "\\Re", "ℜ" );
      _insert_map.set( "\\ReverseElement", "∋" );
      _insert_map.set( "\\ReverseEquilibrium", "⇋" );
      _insert_map.set( "\\ReverseUpEquilibrium", "⥯" );
      _insert_map.set( "\\Rfr", "ℜ" );
      _insert_map.set( "\\Rho", "Ρ" );
      _insert_map.set( "\\RightAngleBracket", "⟩" );
      _insert_map.set( "\\RightArrow", "→" );
      _insert_map.set( "\\RightArrowBar", "⇥" );
      _insert_map.set( "\\RightArrowLeftArrow", "⇄" );
      _insert_map.set( "\\RightCeiling", "⌉" );
      _insert_map.set( "\\RightDoubleBracket", "⟧" );
      _insert_map.set( "\\RightDownTeeVector", "⥝" );
      _insert_map.set( "\\RightDownVector", "⇂" );
      _insert_map.set( "\\RightDownVectorBar", "⥕" );
      _insert_map.set( "\\RightFloor", "⌋" );
      _insert_map.set( "\\RightTee", "⊢" );
      _insert_map.set( "\\RightTeeArrow", "↦" );
      _insert_map.set( "\\RightTeeVector", "⥛" );
      _insert_map.set( "\\RightTriangle", "⊳" );
      _insert_map.set( "\\RightTriangleBar", "⧐" );
      _insert_map.set( "\\RightTriangleEqual", "⊵" );
      _insert_map.set( "\\RightUpDownVector", "⥏" );
      _insert_map.set( "\\RightUpTeeVector", "⥜" );
      _insert_map.set( "\\RightUpVector", "↾" );
      _insert_map.set( "\\RightUpVectorBar", "⥔" );
      _insert_map.set( "\\RightVector", "⇀" );
      _insert_map.set( "\\RightVectorBar", "⥓" );
      _insert_map.set( "\\Rightarrow", "⇒" );
      _insert_map.set( "\\Ropf", "ℝ" );
      _insert_map.set( "\\RoundImplies", "⥰" );
      _insert_map.set( "\\Rrightarrow", "⇛" );
      _insert_map.set( "\\Rscr", "ℛ" );
      _insert_map.set( "\\Rsh", "↱" );
      _insert_map.set( "\\RuleDelayed", "⧴" );
      _insert_map.set( "\\S", "§" );
      _insert_map.set( "\\SHCHcy", "Щ" );
      _insert_map.set( "\\SHcy", "Ш" );
      _insert_map.set( "\\SOFTcy", "Ь" );
      _insert_map.set( "\\Sacute", "Ś" );
      _insert_map.set( "\\Sc", "⪼" );
      _insert_map.set( "\\Scaron", "Š" );
      _insert_map.set( "\\Scedil", "Ş" );
      _insert_map.set( "\\Scirc", "Ŝ" );
      _insert_map.set( "\\Scy", "С" );
      _insert_map.set( "\\Sfr", "𝔖" );
      _insert_map.set( "\\ShortDownArrow", "⌄" );
      _insert_map.set( "\\ShortLeftArrow", "←" );
      _insert_map.set( "\\ShortRightArrow", "→" );
      _insert_map.set( "\\ShortUpArrow", "⌃" );
      _insert_map.set( "\\Sigma", "Σ" );
      _insert_map.set( "\\SmallCircle", "∘" );
      _insert_map.set( "\\Sopf", "𝕊" );
      _insert_map.set( "\\Sqrt", "√" );
      _insert_map.set( "\\Square", "□" );
      _insert_map.set( "\\SquareIntersection", "⊓" );
      _insert_map.set( "\\SquareSubset", "⊏" );
      _insert_map.set( "\\SquareSubsetEqual", "⊑" );
      _insert_map.set( "\\SquareSuperset", "⊐" );
      _insert_map.set( "\\SquareSupersetEqual", "⊒" );
      _insert_map.set( "\\SquareUnion", "⊔" );
      _insert_map.set( "\\Sscr", "𝒮" );
      _insert_map.set( "\\Star", "⋆" );
      _insert_map.set( "\\Sub", "⋐" );
      _insert_map.set( "\\Subset", "⋐" );
      _insert_map.set( "\\SubsetEqual", "⊆" );
      _insert_map.set( "\\Succeeds", "≻" );
      _insert_map.set( "\\SucceedsEqual", "≽" );
      _insert_map.set( "\\SucceedsSlantEqual", "≽" );
      _insert_map.set( "\\SucceedsTilde", "≿" );
      _insert_map.set( "\\SuchThat", "∋" );
      _insert_map.set( "\\Sum", "∑" );
      _insert_map.set( "\\Sup", "⋑" );
      _insert_map.set( "\\Superset", "⊃" );
      _insert_map.set( "\\SupersetEqual", "⊇" );
      _insert_map.set( "\\Supset", "⋑" );
      _insert_map.set( "\\TH", "Þ" );
      _insert_map.set( "\\THORN", "Þ" );
      _insert_map.set( "\\TSHcy", "Ћ" );
      _insert_map.set( "\\TScy", "Ц" );
      _insert_map.set( "\\Tau", "Τ" );
      _insert_map.set( "\\Tcaron", "Ť" );
      _insert_map.set( "\\Tcedil", "Ţ" );
      _insert_map.set( "\\Tcy", "Т" );
      _insert_map.set( "\\Tfr", "𝔗" );
      _insert_map.set( "\\Therefore", "∴" );
      _insert_map.set( "\\Theta", "Θ" );
      _insert_map.set( "\\ThickSpace", "   " );
      _insert_map.set( "\\ThinSpace", " " );
      _insert_map.set( "\\Tilde", "∼" );
      _insert_map.set( "\\TildeEqual", "≃" );
      _insert_map.set( "\\TildeFullEqual", "≅" );
      _insert_map.set( "\\TildeTilde", "≈" );
      _insert_map.set( "\\Topf", "𝕋" );
      _insert_map.set( "\\TripleDot", "⃛" );
      _insert_map.set( "\\Tscr", "𝒯" );
      _insert_map.set( "\\Tstrok", "Ŧ" );
      _insert_map.set( "\\Uacute", "Ú" );
      _insert_map.set( "\\Uarr", "↟" );
      _insert_map.set( "\\Uarrocir", "⥉" );
      _insert_map.set( "\\Ubrcy", "Ў" );
      _insert_map.set( "\\Ubreve", "Ŭ" );
      _insert_map.set( "\\Ucirc", "Û" );
      _insert_map.set( "\\Ucy", "У" );
      _insert_map.set( "\\Udblac", "Ű" );
      _insert_map.set( "\\Ufr", "𝔘" );
      _insert_map.set( "\\Ugrave", "Ù" );
      _insert_map.set( "\\Umacr", "Ū" );
      _insert_map.set( "\\UnderBar", "̲" );
      _insert_map.set( "\\UnderBrace", "︸" );
      _insert_map.set( "\\UnderBracket", "⎵" );
      _insert_map.set( "\\UnderParenthesis", "︶" );
      _insert_map.set( "\\Union", "⋃" );
      _insert_map.set( "\\UnionPlus", "⊎" );
      _insert_map.set( "\\Uogon", "Ų" );
      _insert_map.set( "\\Uopf", "𝕌" );
      _insert_map.set( "\\UpArrow", "↑" );
      _insert_map.set( "\\UpArrowBar", "⤒" );
      _insert_map.set( "\\UpArrowDownArrow", "⇅" );
      _insert_map.set( "\\UpDownArrow", "↕" );
      _insert_map.set( "\\UpEquilibrium", "⥮" );
      _insert_map.set( "\\UpTee", "⊥" );
      _insert_map.set( "\\UpTeeArrow", "↥" );
      _insert_map.set( "\\Uparrow", "⇑" );
      _insert_map.set( "\\Updownarrow", "⇕" );
      _insert_map.set( "\\UpperLeftArrow", "↖" );
      _insert_map.set( "\\UpperRightArrow", "↗" );
      _insert_map.set( "\\Upsilon", "Υ" );
      _insert_map.set( "\\Uring", "Ů" );
      _insert_map.set( "\\Uscr", "𝒰" );
      _insert_map.set( "\\Utilde", "Ũ" );
      _insert_map.set( "\\Uuml", "Ü" );
      _insert_map.set( "\\VDash", "⊫" );
      _insert_map.set( "\\Vbar", "⫫" );
      _insert_map.set( "\\Vcy", "В" );
      _insert_map.set( "\\Vdash", "⊩" );
      _insert_map.set( "\\Vdashl", "⫦" );
      _insert_map.set( "\\Vee", "⋁" );
      _insert_map.set( "\\Verbar", "‖" );
      _insert_map.set( "\\Vert", "‖" );
      _insert_map.set( "\\VerticalBar", "∣" );
      _insert_map.set( "\\VerticalSeparator", "❘" );
      _insert_map.set( "\\VerticalTilde", "≀" );
      _insert_map.set( "\\VeryThinSpace", " " );
      _insert_map.set( "\\Vfr", "𝔙" );
      _insert_map.set( "\\Vopf", "𝕍" );
      _insert_map.set( "\\Vscr", "𝒱" );
      _insert_map.set( "\\Vvdash", "⊪" );
      _insert_map.set( "\\W", "Ω" );
      _insert_map.set( "\\Wcirc", "Ŵ" );
      _insert_map.set( "\\Wedge", "⋀" );
      _insert_map.set( "\\Wfr", "𝔚" );
      _insert_map.set( "\\Wopf", "𝕎" );
      _insert_map.set( "\\Wscr", "𝒲" );
      _insert_map.set( "\\Xfr", "𝔛" );
      _insert_map.set( "\\Xi", "Ξ 1" );
      _insert_map.set( "\\Xopf", "𝕏" );
      _insert_map.set( "\\Xscr", "𝒳" );
      _insert_map.set( "\\YAcy", "Я" );
      _insert_map.set( "\\YIcy", "Ї" );
      _insert_map.set( "\\YUcy", "Ю" );
      _insert_map.set( "\\Yacute", "Ý" );
      _insert_map.set( "\\Yang", "⚊" );
      _insert_map.set( "\\Ycirc", "Ŷ" );
      _insert_map.set( "\\Ycy", "Ы" );
      _insert_map.set( "\\Yfr", "𝔜" );
      _insert_map.set( "\\Yopf", "𝕐" );
      _insert_map.set( "\\Yscr", "𝒴" );
      _insert_map.set( "\\Yuml", "Ÿ" );
      _insert_map.set( "\\ZHcy", "Ж" );
      _insert_map.set( "\\Zacute", "Ź" );
      _insert_map.set( "\\Zcaron", "Ž" );
      _insert_map.set( "\\Zcy", "З" );
      _insert_map.set( "\\Zdot", "Ż" );
      _insert_map.set( "\\ZeroWidthSpace", "​" );
      _insert_map.set( "\\Zeta", "Ζ" );
      _insert_map.set( "\\Zfr", "ℨ" );
      _insert_map.set( "\\Zopf", "ℤ" );
      _insert_map.set( "\\Zscr", "𝒵" );

      _insert_map.set( "\\^(", "⁽" );
      _insert_map.set( "\\^)", "⁾" );
      _insert_map.set( "\\^+", "⁺" );
      _insert_map.set( "\\^-", "⁻" );
      _insert_map.set( "\\^0", "⁰" );
      _insert_map.set( "\\^1", "¹" );
      _insert_map.set( "\\^2", "²" );
      _insert_map.set( "\\^3", "³" );
      _insert_map.set( "\\^4", "⁴" );
      _insert_map.set( "\\^5", "⁵" );
      _insert_map.set( "\\^6", "⁶" );
      _insert_map.set( "\\^7", "⁷" );
      _insert_map.set( "\\^8", "⁸" );
      _insert_map.set( "\\^9", "⁹" );
      _insert_map.set( "\\^=", "⁼" );
      _insert_map.set( "\\^A", "ᴬ" );
      _insert_map.set( "\\^B", "ᴮ" );
      _insert_map.set( "\\^C", "Ĉ" );
      _insert_map.set( "\\^D", "ᴰ" );
      _insert_map.set( "\\^E", "ᴱ" );
      _insert_map.set( "\\^G", "ᴳ" );
      _insert_map.set( "\\^H", "ᴴ" );
      _insert_map.set( "\\^I", "ᴵ" );
      _insert_map.set( "\\^J", "ᴶ" );
      _insert_map.set( "\\^K", "ᴷ" );
      _insert_map.set( "\\^L", "ᴸ" );
      _insert_map.set( "\\^M", "ᴹ" );
      _insert_map.set( "\\^N", "ᴺ" );
      _insert_map.set( "\\^O", "ᴼ" );
      _insert_map.set( "\\^P", "ᴾ" );
      _insert_map.set( "\\^R", "ᴿ" );
      _insert_map.set( "\\^S", "Ŝ" );
      _insert_map.set( "\\^T", "ᵀ" );
      _insert_map.set( "\\^U", "ᵁ" );
      _insert_map.set( "\\^V", "ⱽ" );
      _insert_map.set( "\\^W", "ᵂ" );
      _insert_map.set( "\\^Y", "Ŷ" );
      _insert_map.set( "\\^Z", "Ẑ" );
      _insert_map.set( "\\^a", "ᵃ" );
      _insert_map.set( "\\^alpha", "ᵅ" );
      _insert_map.set( "\\^b", "ᵇ" );
      _insert_map.set( "\\^beta", "ᵝ" );
      _insert_map.set( "\\^c", "ᶜ" );
      _insert_map.set( "\\^chi", "ᵡ" );
      _insert_map.set( "\\^d", "ᵈ" );
      _insert_map.set( "\\^delta", "ᵟ" );
      _insert_map.set( "\\^e", "ᵉ" );
      _insert_map.set( "\\^epsilon", "ᵋ" );
      _insert_map.set( "\\^f", "ᶠ" );
      _insert_map.set( "\\^g", "ᵍ" );
      _insert_map.set( "\\^gamma", "ᵞ" );
      _insert_map.set( "\\^h", "ʰ" );
      _insert_map.set( "\\^i", "ⁱ" );
      _insert_map.set( "\\^iota", "ᶥ" );
      _insert_map.set( "\\^j", "ʲ" );
      _insert_map.set( "\\^k", "ᵏ" );
      _insert_map.set( "\\^l", "ˡ" );
      _insert_map.set( "\\^m", "ᵐ" );
      _insert_map.set( "\\^n", "ⁿ" );
      _insert_map.set( "\\^o", "ᵒ" );
      _insert_map.set( "\\^p", "ᵖ" );
      _insert_map.set( "\\^phi", "ᶲ" );
      _insert_map.set( "\\^r", "ʳ" );
      _insert_map.set( "\\^s", "ˢ" );
      _insert_map.set( "\\^t", "ᵗ" );
      _insert_map.set( "\\^theta", "ᶿ" );
      _insert_map.set( "\\^u", "ᵘ" );
      _insert_map.set( "\\^v", "ᵛ" );
      _insert_map.set( "\\^varphi", "ᵠ" );
      _insert_map.set( "\\^w", "ʷ" );
      _insert_map.set( "\\^x", "ˣ" );
      _insert_map.set( "\\^y", "ʸ" );
      _insert_map.set( "\\^z", "ᶻ" );
      _insert_map.set( "\\_(", "₍" );
      _insert_map.set( "\\_)", "₎" );
      _insert_map.set( "\\_+", "₊" );
      _insert_map.set( "\\_-", "₋" );
      _insert_map.set( "\\_0", "₀" );
      _insert_map.set( "\\_1", "₁" );
      _insert_map.set( "\\_2", "₂" );
      _insert_map.set( "\\_3", "₃" );
      _insert_map.set( "\\_4", "₄" );
      _insert_map.set( "\\_5", "₅" );
      _insert_map.set( "\\_6", "₆" );
      _insert_map.set( "\\_7", "₇" );
      _insert_map.set( "\\_8", "₈" );
      _insert_map.set( "\\_9", "₉" );
      _insert_map.set( "\\_=", "₌" );
      _insert_map.set( "\\_a", "ₐ" );
      _insert_map.set( "\\_beta", "ᵦ" );
      _insert_map.set( "\\_chi", "ᵪ" );
      _insert_map.set( "\\_e", "ₑ" );
      _insert_map.set( "\\_gamma", "ᵧ" );
      _insert_map.set( "\\_h", "ₕ" );
      _insert_map.set( "\\_i", "ᵢ" );
      _insert_map.set( "\\_j", "ⱼ" );
      _insert_map.set( "\\_k", "ₖ" );
      _insert_map.set( "\\_l", "ₗ" );
      _insert_map.set( "\\_m", "ₘ" );
      _insert_map.set( "\\_n", "ₙ" );
      _insert_map.set( "\\_o", "ₒ" );
      _insert_map.set( "\\_p", "ₚ" );
      _insert_map.set( "\\_r", "ᵣ" );
      _insert_map.set( "\\_rho", "ᵨ" );
      _insert_map.set( "\\_s", "ₛ" );
      _insert_map.set( "\\_t", "ₜ" );
      _insert_map.set( "\\_u", "ᵤ" );
      _insert_map.set( "\\_v", "ᵥ" );
      _insert_map.set( "\\_varphi", "ᵩ" );
      _insert_map.set( "\\_x", "ₓ" );
      _insert_map.set( "\\`", "‘" );
      _insert_map.set( "\\`A", "À" );
      _insert_map.set( "\\`E", "È" );
      _insert_map.set( "\\`I", "Ì" );
      _insert_map.set( "\\`N", "Ǹ" );
      _insert_map.set( "\\`O", "Ò" );
      _insert_map.set( "\\`U", "Ù" );
      _insert_map.set( "\\`W", "Ẁ" );
      _insert_map.set( "\\`Y", "Ỳ" );
      _insert_map.set( "\\``", "“" );
      _insert_map.set( "\\`a", "à" );
      _insert_map.set( "\\`e", "è" );
      _insert_map.set( "\\`i", "ì" );
      _insert_map.set( "\\`n", "ǹ" );
      _insert_map.set( "\\`o", "ò" );
      _insert_map.set( "\\`u", "ù" );
      _insert_map.set( "\\`w", "ẁ" );
      _insert_map.set( "\\`y", "ỳ" );

      _insert_map.set( "\\aa", "å" );
      _insert_map.set( "\\aacute", "á" );
      _insert_map.set( "\\abreve", "ă" );
      _insert_map.set( "\\ac", "⤏" );
      _insert_map.set( "\\acE", "⧛" );
      _insert_map.set( "\\acd", "∿" );
      _insert_map.set( "\\acirc", "â" );
      _insert_map.set( "\\acute", "´" );
      _insert_map.set( "\\acy", "а" );
      _insert_map.set( "\\ae", "æ" );
      _insert_map.set( "\\aelig", "æ" );
      _insert_map.set( "\\af", "⁡" );
      _insert_map.set( "\\afr", "𝔞" );
      _insert_map.set( "\\agrave", "à" );
      _insert_map.set( "\\aleph", "ℵ" );
      _insert_map.set( "\\alpha", "α" );
      _insert_map.set( "\\amacr", "ā" );
      _insert_map.set( "\\amalg", "⨿" );
      _insert_map.set( "\\and", "∧" );
      _insert_map.set( "\\andand", "⩕" );
      _insert_map.set( "\\andd", "⩜" );
      _insert_map.set( "\\andslope", "⩘" );
      _insert_map.set( "\\andv", "⩚" );
      _insert_map.set( "\\ang", "∠" );
      _insert_map.set( "\\ange", "⦤" );
      _insert_map.set( "\\angle", "∠" );
      _insert_map.set( "\\angmsd", "∡" );
      _insert_map.set( "\\angmsdaa", "⦨" );
      _insert_map.set( "\\angmsdab", "⦩" );
      _insert_map.set( "\\angmsdac", "⦪" );
      _insert_map.set( "\\angmsdad", "⦫" );
      _insert_map.set( "\\angmsdae", "⦬" );
      _insert_map.set( "\\angmsdaf", "⦭" );
      _insert_map.set( "\\angmsdag", "⦮" );
      _insert_map.set( "\\angmsdah", "⦯" );
      _insert_map.set( "\\angrt", "∟" );
      _insert_map.set( "\\angrtvb", "⦝" );
      _insert_map.set( "\\angrtvbd", "⦝" );
      _insert_map.set( "\\angsph", "∢" );
      _insert_map.set( "\\angst", "Å" );
      _insert_map.set( "\\angzarr", "⍼" );
      _insert_map.set( "\\aogon", "ą" );
      _insert_map.set( "\\aopf", "𝕒" );
      _insert_map.set( "\\ap", "≈" );
      _insert_map.set( "\\apE", "≊" );
      _insert_map.set( "\\apacir", "⩯" );
      _insert_map.set( "\\ape", "≊" );
      _insert_map.set( "\\apid", "≋" );
      _insert_map.set( "\\approx", "≈" );
      _insert_map.set( "\\approxeq", "≊" );
      _insert_map.set( "\\aquarius", "♒" );
      _insert_map.set( "\\aries", "♈" );
      _insert_map.set( "\\aring", "å" );
      _insert_map.set( "\\ascnode", "☊" );
      _insert_map.set( "\\ascr", "𝒶" );
      _insert_map.set( "\\ast", "∗" );
      _insert_map.set( "\\astrosun", "☉" );
      _insert_map.set( "\\asymp", "≍" );
      _insert_map.set( "\\atilde", "ã" );
      _insert_map.set( "\\auml", "ä" );
      _insert_map.set( "\\awconint", "∳" );
      _insert_map.set( "\\awint", "⨑" );

      _insert_map.set( "\\bNot", "⫭" );
      _insert_map.set( "\\backcong", "≌" );
      _insert_map.set( "\\backepsilon", "∍" );
      _insert_map.set( "\\backprime", "‵" );
      _insert_map.set( "\\backsim", "∽" );
      _insert_map.set( "\\backsimeq", "⋍" );
      _insert_map.set( "\\barA", "Ā" );
      _insert_map.set( "\\barE", "Ē" );
      _insert_map.set( "\\barG", "Ḡ" );
      _insert_map.set( "\\barI", "Ī" );
      _insert_map.set( "\\barO", "Ō" );
      _insert_map.set( "\\barU", "Ū" );
      _insert_map.set( "\\barY", "Ȳ" );
      _insert_map.set( "\\bara", "ā" );
      _insert_map.set( "\\bare", "ē" );
      _insert_map.set( "\\barg", "ḡ" );
      _insert_map.set( "\\bari", "ī" );
      _insert_map.set( "\\baro", "ō" );
      _insert_map.set( "\\baru", "ū" );
      _insert_map.set( "\\barvee", "⊽" );
      _insert_map.set( "\\barwed", "⊼" );
      _insert_map.set( "\\barwedge", "⊼" );
      _insert_map.set( "\\bary", "ȳ" );
      _insert_map.set( "\\bb0", "𝟘" );
      _insert_map.set( "\\bb1", "𝟙" );
      _insert_map.set( "\\bb2", "𝟚" );
      _insert_map.set( "\\bb3", "𝟛" );
      _insert_map.set( "\\bb4", "𝟜" );
      _insert_map.set( "\\bb5", "𝟝" );
      _insert_map.set( "\\bb6", "𝟞" );
      _insert_map.set( "\\bb7", "𝟟" );
      _insert_map.set( "\\bb8", "𝟠" );
      _insert_map.set( "\\bb9", "𝟡" );
      _insert_map.set( "\\bbA", "𝔸" );
      _insert_map.set( "\\bbB", "𝔹" );
      _insert_map.set( "\\bbC", "ℂ" );
      _insert_map.set( "\\bbD", "𝔻" );
      _insert_map.set( "\\bbE", "𝔼" );
      _insert_map.set( "\\bbF", "𝔽" );
      _insert_map.set( "\\bbG", "𝔾" );
      _insert_map.set( "\\bbH", "ℍ" );
      _insert_map.set( "\\bbI", "𝕀" );
      _insert_map.set( "\\bbJ", "𝕁" );
      _insert_map.set( "\\bbK", "𝕂" );
      _insert_map.set( "\\bbL", "𝕃" );
      _insert_map.set( "\\bbM", "𝕄" );
      _insert_map.set( "\\bbN", "ℕ" );
      _insert_map.set( "\\bbO", "𝕆" );
      _insert_map.set( "\\bbP", "ℙ" );
      _insert_map.set( "\\bbQ", "ℚ" );
      _insert_map.set( "\\bbR", "ℝ" );
      _insert_map.set( "\\bbS", "𝕊" );
      _insert_map.set( "\\bbT", "𝕋" );
      _insert_map.set( "\\bbU", "𝕌" );
      _insert_map.set( "\\bbV", "𝕍" );
      _insert_map.set( "\\bbW", "𝕎" );
      _insert_map.set( "\\bbX", "𝕏" );
      _insert_map.set( "\\bbY", "𝕐" );
      _insert_map.set( "\\bbZ", "ℤ" );
      _insert_map.set( "\\bba", "𝕒" );
      _insert_map.set( "\\bbb", "𝕓" );
      _insert_map.set( "\\bbc", "𝕔" );
      _insert_map.set( "\\bbd", "𝕕" );
      _insert_map.set( "\\bbe", "𝕖" );
      _insert_map.set( "\\bbf", "𝕗" );
      _insert_map.set( "\\bbg", "𝕘" );
      _insert_map.set( "\\bbh", "𝕙" );
      _insert_map.set( "\\bbi", "𝕚" );
      _insert_map.set( "\\bbj", "𝕛" );
      _insert_map.set( "\\bbk", "𝕜" );
      _insert_map.set( "\\bbl", "𝕝" );
      _insert_map.set( "\\bbm", "𝕞" );
      _insert_map.set( "\\bbn", "𝕟" );
      _insert_map.set( "\\bbo", "𝕠" );
      _insert_map.set( "\\bbp", "𝕡" );
      _insert_map.set( "\\bbq", "𝕢" );
      _insert_map.set( "\\bbr", "𝕣" );
      _insert_map.set( "\\bbrk", "⎵" );
      _insert_map.set( "\\bbs", "𝕤" );
      _insert_map.set( "\\bbt", "𝕥" );
      _insert_map.set( "\\bbu", "𝕦" );
      _insert_map.set( "\\bbv", "𝕧" );
      _insert_map.set( "\\bbw", "𝕨" );
      _insert_map.set( "\\bbx", "𝕩" );
      _insert_map.set( "\\bby", "𝕪" );
      _insert_map.set( "\\bbz", "𝕫" );
      _insert_map.set( "\\bcong", "≌" );
      _insert_map.set( "\\bcy", "б" );
      _insert_map.set( "\\becaus", "∵" );
      _insert_map.set( "\\because", "∵" );
      _insert_map.set( "\\bemptyv", "⦰" );
      _insert_map.set( "\\bepsi", "϶" );
      _insert_map.set( "\\bernou", "ℬ" );
      _insert_map.set( "\\beta", "β" );
      _insert_map.set( "\\beth", "ℶ" );
      _insert_map.set( "\\between", "≬" );
      _insert_map.set( "\\bfr", "𝔟" );
      _insert_map.set( "\\bigcap", "⋂" );
      _insert_map.set( "\\bigcirc", "○" );
      _insert_map.set( "\\bigcup", "⋃" );
      _insert_map.set( "\\bigodot", "⊙" );
      _insert_map.set( "\\bigoplus", "⊕" );
      _insert_map.set( "\\bigotimes", "⊗" );
      _insert_map.set( "\\bigsqcup", "⊔" );
      _insert_map.set( "\\bigstar", "★" );
      _insert_map.set( "\\bigtriangledown", "▽" );
      _insert_map.set( "\\bigtriangleup", "△" );
      _insert_map.set( "\\biguplus", "⊎" );
      _insert_map.set( "\\bigvee", "⋁" );
      _insert_map.set( "\\bigwedge", "⋀" );
      _insert_map.set( "\\bkarow", "⤍" );
      _insert_map.set( "\\blackbishop", "♝" );
      _insert_map.set( "\\blackking", "♚" );
      _insert_map.set( "\\blackknight", "♞" );
      _insert_map.set( "\\blacklozenge", "◆" );
      _insert_map.set( "\\blackpawn", "♟" );
      _insert_map.set( "\\blackqueen", "♛" );
      _insert_map.set( "\\blackrook", "♜" );
      _insert_map.set( "\\blacksquare", "■" );
      _insert_map.set( "\\blacktriangle", "▲" );
      _insert_map.set( "\\blacktriangledown", "▼" );
      _insert_map.set( "\\blacktriangleleft", "◀" );
      _insert_map.set( "\\blacktriangleright", "▷" );
      _insert_map.set( "\\blank", "␣" );
      _insert_map.set( "\\blk12", "▒" );
      _insert_map.set( "\\blk14", "░" );
      _insert_map.set( "\\blk34", "▓" );
      _insert_map.set( "\\block", "█" );
      _insert_map.set( "\\bnequiv", "≡⃥" );
      _insert_map.set( "\\bnot", "⌐" );
      _insert_map.set( "\\bopf", "𝕓" );
      _insert_map.set( "\\bot", "⊥" );
      _insert_map.set( "\\bottom", "⊥" );
      _insert_map.set( "\\bowtie", "⋈" );
      _insert_map.set( "\\boxDL", "╗" );
      _insert_map.set( "\\boxDR", "╔" );
      _insert_map.set( "\\boxDl", "╖" );
      _insert_map.set( "\\boxDr", "╓" );
      _insert_map.set( "\\boxH", "═" );
      _insert_map.set( "\\boxHD", "╦" );
      _insert_map.set( "\\boxHU", "╩" );
      _insert_map.set( "\\boxHd", "╤" );
      _insert_map.set( "\\boxHu", "╧" );
      _insert_map.set( "\\boxUL", "╝" );
      _insert_map.set( "\\boxUR", "╚" );
      _insert_map.set( "\\boxUl", "╜" );
      _insert_map.set( "\\boxUr", "╙" );
      _insert_map.set( "\\boxV", "║" );
      _insert_map.set( "\\boxVH", "╬" );
      _insert_map.set( "\\boxVL", "╣" );
      _insert_map.set( "\\boxVR", "╠" );
      _insert_map.set( "\\boxVh", "╫" );
      _insert_map.set( "\\boxVl", "╢" );
      _insert_map.set( "\\boxVr", "╟" );
      _insert_map.set( "\\boxbox", "⧉" );
      _insert_map.set( "\\boxdL", "╕" );
      _insert_map.set( "\\boxdR", "╒" );
      _insert_map.set( "\\boxdl", "┐" );
      _insert_map.set( "\\boxdot", "⊡" );
      _insert_map.set( "\\boxdr", "┌" );
      _insert_map.set( "\\boxh", "─" );
      _insert_map.set( "\\boxhD", "╥" );
      _insert_map.set( "\\boxhU", "╨" );
      _insert_map.set( "\\boxhd", "┬" );
      _insert_map.set( "\\boxhu", "┴" );
      _insert_map.set( "\\boxminus", "⊟" );
      _insert_map.set( "\\boxplus", "⊞" );
      _insert_map.set( "\\boxtimes", "⊠" );
      _insert_map.set( "\\boxuL", "╛" );
      _insert_map.set( "\\boxuR", "╘" );
      _insert_map.set( "\\boxul", "┘" );
      _insert_map.set( "\\boxur", "└" );
      _insert_map.set( "\\boxv", "│" );
      _insert_map.set( "\\boxvH", "╪" );
      _insert_map.set( "\\boxvL", "╡" );
      _insert_map.set( "\\boxvR", "╞" );
      _insert_map.set( "\\boxvh", "┼" );
      _insert_map.set( "\\boxvl", "┤" );
      _insert_map.set( "\\boxvr", "├" );
      _insert_map.set( "\\bprime", "‵" );
      _insert_map.set( "\\breve", "˘" );
      _insert_map.set( "\\breveA", "Ă" );
      _insert_map.set( "\\breveE", "Ĕ" );
      _insert_map.set( "\\breveG", "Ğ" );
      _insert_map.set( "\\breveI", "Ĭ" );
      _insert_map.set( "\\breveO", "Ŏ" );
      _insert_map.set( "\\breveU", "Ŭ" );
      _insert_map.set( "\\brevea", "ă" );
      _insert_map.set( "\\brevee", "ĕ" );
      _insert_map.set( "\\breveg", "ğ" );
      _insert_map.set( "\\brevei", "ĭ" );
      _insert_map.set( "\\breveo", "ŏ" );
      _insert_map.set( "\\breveu", "ŭ" );
      _insert_map.set( "\\brvbar", "¦" );
      _insert_map.set( "\\bscr", "𝒷" );
      _insert_map.set( "\\bsemi", "⁏" );
      _insert_map.set( "\\bsim", "∽" );
      _insert_map.set( "\\bsime", "⋍" );
      _insert_map.set( "\\bsolb", "⧅" );
      _insert_map.set( "\\bull", "•" );
      _insert_map.set( "\\bullet", "∙" );
      _insert_map.set( "\\bump", "≎" );
      _insert_map.set( "\\bumpE", "⪮" );
      _insert_map.set( "\\bumpe", "≏" );
      _insert_map.set( "\\bumpeq", "≏" );
      _insert_map.set( "\\cC", "Ç" );
      _insert_map.set( "\\cacute", "ć" );
      _insert_map.set( "\\calA", "𝒜" );
      _insert_map.set( "\\calB", "ℬ" );
      _insert_map.set( "\\calC", "𝒞" );
      _insert_map.set( "\\calD", "𝒟" );
      _insert_map.set( "\\calE", "ℰ" );
      _insert_map.set( "\\calF", "ℱ" );
      _insert_map.set( "\\calG", "𝒢" );
      _insert_map.set( "\\calH", "ℋ" );
      _insert_map.set( "\\calI", "ℐ" );
      _insert_map.set( "\\calJ", "𝒥" );
      _insert_map.set( "\\calK", "𝒦" );
      _insert_map.set( "\\calL", "ℒ" );
      _insert_map.set( "\\calM", "ℳ" );
      _insert_map.set( "\\calN", "𝒩" );
      _insert_map.set( "\\calO", "𝒪" );
      _insert_map.set( "\\calP", "𝒫" );
      _insert_map.set( "\\calQ", "𝒬" );
      _insert_map.set( "\\calR", "ℛ" );
      _insert_map.set( "\\calS", "𝒮" );
      _insert_map.set( "\\calT", "𝒯" );
      _insert_map.set( "\\calU", "𝒰" );
      _insert_map.set( "\\calV", "𝒱" );
      _insert_map.set( "\\calW", "𝒲" );
      _insert_map.set( "\\calX", "𝒳" );
      _insert_map.set( "\\calY", "𝒴" );
      _insert_map.set( "\\calZ", "𝒵" );
      _insert_map.set( "\\cala", "𝒶" );
      _insert_map.set( "\\calb", "𝒷" );
      _insert_map.set( "\\calc", "𝒸" );
      _insert_map.set( "\\cald", "𝒹" );
      _insert_map.set( "\\cale", "ℯ" );
      _insert_map.set( "\\calf", "𝒻" );
      _insert_map.set( "\\calg", "ℊ" );
      _insert_map.set( "\\calh", "𝒽" );
      _insert_map.set( "\\cali", "𝒾" );
      _insert_map.set( "\\calj", "𝒿" );
      _insert_map.set( "\\calk", "𝓀" );
      _insert_map.set( "\\call", "𝓁" );
      _insert_map.set( "\\calm", "𝓂" );
      _insert_map.set( "\\caln", "𝓃" );
      _insert_map.set( "\\calo", "ℴ" );
      _insert_map.set( "\\calp", "𝓅" );
      _insert_map.set( "\\calq", "𝓆" );
      _insert_map.set( "\\calr", "𝓇" );
      _insert_map.set( "\\cals", "𝓈" );
      _insert_map.set( "\\calt", "𝓉" );
      _insert_map.set( "\\calu", "𝓊" );
      _insert_map.set( "\\calv", "𝓋" );
      _insert_map.set( "\\calw", "𝓌" );
      _insert_map.set( "\\calx", "𝓍" );
      _insert_map.set( "\\caly", "𝓎" );
      _insert_map.set( "\\calz", "𝓏" );
      _insert_map.set( "\\cancer", "♋" );
      _insert_map.set( "\\cap", "∩" );
      _insert_map.set( "\\capand", "⩄" );
      _insert_map.set( "\\capbrcup", "⩉" );
      _insert_map.set( "\\capcap", "⩋" );
      _insert_map.set( "\\capcup", "⩇" );
      _insert_map.set( "\\capdot", "⩀" );
      _insert_map.set( "\\capricornus", "♑" );
      _insert_map.set( "\\caps", "∩" );
      _insert_map.set( "\\capslockkey", "⇪" );
      _insert_map.set( "\\caret", "⁁" );
      _insert_map.set( "\\caron", "ˇ" );
      _insert_map.set( "\\cc", "ç" );
      _insert_map.set( "\\ccaps", "⩍" );
      _insert_map.set( "\\ccaron", "č" );
      _insert_map.set( "\\ccedil", "ç" );
      _insert_map.set( "\\ccirc", "ĉ" );
      _insert_map.set( "\\ccups", "⩌" );
      _insert_map.set( "\\ccupssm", "⩐" );
      _insert_map.set( "\\cdot", "⋅" );
      _insert_map.set( "\\cdots", "⋯" );
      _insert_map.set( "\\cedil", "¸" );
      _insert_map.set( "\\cemptyv", "⦲" );
      _insert_map.set( "\\cent", "¢" );
      _insert_map.set( "\\centerdot", "⋅" );
      _insert_map.set( "\\cents", "¢" );
      _insert_map.set( "\\cfr", "𝔠" );
      _insert_map.set( "\\chcy", "ч" );
      _insert_map.set( "\\check", "✓" );
      _insert_map.set( "\\checkA", "Ǎ" );
      _insert_map.set( "\\checkC", "Č" );
      _insert_map.set( "\\checkD", "Ď" );
      _insert_map.set( "\\checkE", "Ě" );
      _insert_map.set( "\\checkN", "Ň" );
      _insert_map.set( "\\checkR", "Ř" );
      _insert_map.set( "\\checkS", "Š" );
      _insert_map.set( "\\checkT", "Ť" );
      _insert_map.set( "\\checkZ", "Ž" );
      _insert_map.set( "\\checka", "ǎ" );
      _insert_map.set( "\\checkc", "č" );
      _insert_map.set( "\\checkd", "ď" );
      _insert_map.set( "\\checke", "ě" );
      _insert_map.set( "\\checkmark", "✓" );
      _insert_map.set( "\\checkn", "ň" );
      _insert_map.set( "\\checkr", "ř" );
      _insert_map.set( "\\checks", "š" );
      _insert_map.set( "\\checkt", "ť" );
      _insert_map.set( "\\checkz", "ž" );
      _insert_map.set( "\\chi", "χ" );
      _insert_map.set( "\\cir", "○" );
      _insert_map.set( "\\cirE", "⧃" );
      _insert_map.set( "\\circ", "∘" );
      _insert_map.set( "\\circeq", "≗" );
      _insert_map.set( "\\circlearrowleft", "↺" );
      _insert_map.set( "\\circlearrowright", "↻" );
      _insert_map.set( "\\circledR", "®" );
      _insert_map.set( "\\circledS", "Ⓢ" );
      _insert_map.set( "\\circledast", "⊛" );
      _insert_map.set( "\\circledcirc", "⊚" );
      _insert_map.set( "\\circleddash", "⊝" );
      _insert_map.set( "\\cire", "≗" );
      _insert_map.set( "\\cirfnint", "⨐" );
      _insert_map.set( "\\cirmid", "⫯" );
      _insert_map.set( "\\cirscir", "⧂" );
      _insert_map.set( "\\clubs", "♣" );
      _insert_map.set( "\\clubsuit", "♣" );
      _insert_map.set( "\\cmdkey", "⌘" );
      _insert_map.set( "\\colone", "≔" );
      _insert_map.set( "\\coloneq", "≔" );
      _insert_map.set( "\\comp", "∁" );
      _insert_map.set( "\\compfn", "∘" );
      _insert_map.set( "\\complement", "∁" );
      _insert_map.set( "\\complexes", "ℂ" );
      _insert_map.set( "\\cong", "≅" );
      _insert_map.set( "\\congdot", "⩭" );
      _insert_map.set( "\\conint", "∮" );
      _insert_map.set( "\\conjunction", "☌" );
      _insert_map.set( "\\copf", "𝕔" );
      _insert_map.set( "\\coprod", "∐" );
      _insert_map.set( "\\copy", "©" );
      _insert_map.set( "\\copyright", "©" );
      _insert_map.set( "\\copysr", "℗" );
      _insert_map.set( "\\cross", "✗" );
      _insert_map.set( "\\cscr", "𝒸" );
      _insert_map.set( "\\csub", "⫏" );
      _insert_map.set( "\\csube", "⫑" );
      _insert_map.set( "\\csup", "⫐" );
      _insert_map.set( "\\csupe", "⫒" );
      _insert_map.set( "\\ctdot", "⋯" );
      _insert_map.set( "\\cudarrl", "⤸" );
      _insert_map.set( "\\cudarrr", "⤵" );
      _insert_map.set( "\\cuepr", "⋞" );
      _insert_map.set( "\\cuesc", "⋟" );
      _insert_map.set( "\\cularr", "↶" );
      _insert_map.set( "\\cularrp", "⤽" );
      _insert_map.set( "\\cup", "∪" );
      _insert_map.set( "\\cupbrcap", "⩈" );
      _insert_map.set( "\\cupcap", "⩆" );
      _insert_map.set( "\\cupcup", "⩊" );
      _insert_map.set( "\\cupdot", "⊍" );
      _insert_map.set( "\\cupor", "⩅" );
      _insert_map.set( "\\cups", "∪" );
      _insert_map.set( "\\curarr", "↷" );
      _insert_map.set( "\\curarrm", "⤼" );
      _insert_map.set( "\\curlyeqprec", "⋞" );
      _insert_map.set( "\\curlyeqsucc", "⋟" );
      _insert_map.set( "\\curlyvee", "⋎" );
      _insert_map.set( "\\curlywedge", "⋏" );
      _insert_map.set( "\\curren", "¤" );
      _insert_map.set( "\\curvearrowleft", "↶" );
      _insert_map.set( "\\curvearrowright", "↷" );
      _insert_map.set( "\\cuvee", "⋎" );
      _insert_map.set( "\\cuwed", "⋏" );
      _insert_map.set( "\\cwconint", "∲" );
      _insert_map.set( "\\cwint", "∱" );
      _insert_map.set( "\\cylcty", "⌭" );
      _insert_map.set( "\\dA", "Ạ" );
      _insert_map.set( "\\dArr", "⇓" );
      _insert_map.set( "\\dB", "Ḅ" );
      _insert_map.set( "\\dD", "Ḍ" );
      _insert_map.set( "\\dE", "Ẹ" );
      _insert_map.set( "\\dH", "Ḥ" );
      _insert_map.set( "\\dHar", "⥥" );
      _insert_map.set( "\\dI", "Ị" );
      _insert_map.set( "\\dK", "Ḳ" );
      _insert_map.set( "\\dL", "Ḷ" );
      _insert_map.set( "\\dM", "Ṃ" );
      _insert_map.set( "\\dN", "Ṇ" );
      _insert_map.set( "\\dO", "Ọ" );
      _insert_map.set( "\\dR", "Ṛ" );
      _insert_map.set( "\\dS", "Ṣ" );
      _insert_map.set( "\\dT", "Ṭ" );
      _insert_map.set( "\\dU", "Ụ" );
      _insert_map.set( "\\dV", "Ṿ" );
      _insert_map.set( "\\dW", "Ẉ" );
      _insert_map.set( "\\dY", "Ỵ" );
      _insert_map.set( "\\dZ", "Ẓ" );
      _insert_map.set( "\\da", "ạ" );
      _insert_map.set( "\\dag", "†" );
      _insert_map.set( "\\dagger", "†" );
      _insert_map.set( "\\daleth", "ℸ" );
      _insert_map.set( "\\darr", "↓" );
      _insert_map.set( "\\dash", "‐" );
      _insert_map.set( "\\dashleftarrow", "⇠" );
      _insert_map.set( "\\dashrightarrow", "⇢" );
      _insert_map.set( "\\dashv", "⊣" );
      _insert_map.set( "\\db", "ḅ" );
      _insert_map.set( "\\dbkarow", "⤏" );
      _insert_map.set( "\\dblac", "˝" );
      _insert_map.set( "\\dcaron", "ď" );
      _insert_map.set( "\\dcy", "д" );
      _insert_map.set( "\\dd", "ḍ" );
      _insert_map.set( "\\ddag", "‡" );
      _insert_map.set( "\\ddagger", "‡" );
      _insert_map.set( "\\ddarr", "⇊" );
      _insert_map.set( "\\ddotA", "Ä" );
      _insert_map.set( "\\ddotE", "Ë" );
      _insert_map.set( "\\ddotH", "Ḧ" );
      _insert_map.set( "\\ddotI", "Ï" );
      _insert_map.set( "\\ddotO", "Ö" );
      _insert_map.set( "\\ddotU", "Ü" );
      _insert_map.set( "\\ddotW", "Ẅ" );
      _insert_map.set( "\\ddotX", "Ẍ" );
      _insert_map.set( "\\ddotY", "Ÿ" );
      _insert_map.set( "\\ddota", "ä" );
      _insert_map.set( "\\ddote", "ë" );
      _insert_map.set( "\\ddoth", "ḧ" );
      _insert_map.set( "\\ddoti", "ï" );
      _insert_map.set( "\\ddoto", "ö" );
      _insert_map.set( "\\ddots", "⋱" );
      _insert_map.set( "\\ddotseq", "⩷" );
      _insert_map.set( "\\ddott", "ẗ" );
      _insert_map.set( "\\ddotu", "ü" );
      _insert_map.set( "\\ddotw", "ẅ" );
      _insert_map.set( "\\ddotx", "ẍ" );
      _insert_map.set( "\\ddoty", "ÿ" );
      _insert_map.set( "\\de", "ẹ" );
      _insert_map.set( "\\def", "≝" );
      _insert_map.set( "\\degree", "°" );
      _insert_map.set( "\\delkey", "⌫" );
      _insert_map.set( "\\delta", "δ" );
      _insert_map.set( "\\demptyv", "⦱" );
      _insert_map.set( "\\descnode", "☋" );
      _insert_map.set( "\\dfisht", "⥿" );
      _insert_map.set( "\\dfr", "𝔡" );
      _insert_map.set( "\\dh", "ḥ" );
      _insert_map.set( "\\dharl", "⇃" );
      _insert_map.set( "\\dharr", "⇂" );
      _insert_map.set( "\\di", "ị" );
      _insert_map.set( "\\diam", "⋄" );
      _insert_map.set( "\\diamond", "⋄" );
      _insert_map.set( "\\diamondsuit", "♢" );
      _insert_map.set( "\\diams", "♦" );
      _insert_map.set( "\\die", "¨" );
      _insert_map.set( "\\digamma", "Ϝ" );
      _insert_map.set( "\\disin", "⋲" );
      _insert_map.set( "\\div", "÷" );
      _insert_map.set( "\\divide", "÷" );
      _insert_map.set( "\\divideontimes", "⋇" );
      _insert_map.set( "\\divides", "∣" );
      _insert_map.set( "\\divonx", "⋇" );
      _insert_map.set( "\\djcy", "ђ" );
      _insert_map.set( "\\dk", "ḳ" );
      _insert_map.set( "\\dl", "ḷ" );
      _insert_map.set( "\\dlcorn", "⌞" );
      _insert_map.set( "\\dlcrop", "⌍" );
      _insert_map.set( "\\dm", "ṃ" );
      _insert_map.set( "\\dn", "ṇ" );
      _insert_map.set( "\\do", "ọ" );
      _insert_map.set( "\\dopf", "𝕕" );
      _insert_map.set( "\\dot", "˙" );
      _insert_map.set( "\\dotA", "Ȧ" );
      _insert_map.set( "\\dotB", "Ḃ" );
      _insert_map.set( "\\dotC", "Ċ" );
      _insert_map.set( "\\dotD", "Ḋ" );
      _insert_map.set( "\\dotE", "Ė" );
      _insert_map.set( "\\dotF", "Ḟ" );
      _insert_map.set( "\\dotG", "Ġ" );
      _insert_map.set( "\\dotH", "Ḣ" );
      _insert_map.set( "\\dotI", "İ" );
      _insert_map.set( "\\dotM", "Ṁ" );
      _insert_map.set( "\\dotN", "Ṅ" );
      _insert_map.set( "\\dotO", "Ȯ" );
      _insert_map.set( "\\dotP", "Ṗ" );
      _insert_map.set( "\\dotR", "Ṙ" );
      _insert_map.set( "\\dotS", "Ṡ" );
      _insert_map.set( "\\dotT", "Ṫ" );
      _insert_map.set( "\\dotW", "Ẇ" );
      _insert_map.set( "\\dotX", "Ẋ" );
      _insert_map.set( "\\dotY", "Ẏ" );
      _insert_map.set( "\\dotZ", "Ż" );
      _insert_map.set( "\\dota", "ȧ" );
      _insert_map.set( "\\dotb", "ḃ" );
      _insert_map.set( "\\dotc", "ċ" );
      _insert_map.set( "\\dotd", "ḋ" );
      _insert_map.set( "\\dote", "ė" );
      _insert_map.set( "\\doteq", "≐" );
      _insert_map.set( "\\doteqdot", "≑" );
      _insert_map.set( "\\dotf", "ḟ" );
      _insert_map.set( "\\dotg", "ġ" );
      _insert_map.set( "\\doth", "ḣ" );
      _insert_map.set( "\\dotm", "ṁ" );
      _insert_map.set( "\\dotminus", "∸" );
      _insert_map.set( "\\dotn", "ṅ" );
      _insert_map.set( "\\doto", "ȯ" );
      _insert_map.set( "\\dotp", "ṗ" );
      _insert_map.set( "\\dotplus", "∔" );
      _insert_map.set( "\\dotr", "ṙ" );
      _insert_map.set( "\\dots", "ṡ" );
      _insert_map.set( "\\dotsquare", "⊡" );
      _insert_map.set( "\\dott", "ṫ" );
      _insert_map.set( "\\dotw", "ẇ" );
      _insert_map.set( "\\dotx", "ẋ" );
      _insert_map.set( "\\doty", "ẏ" );
      _insert_map.set( "\\dotz", "ż" );
      _insert_map.set( "\\doublebarwedge", "⌆" );
      _insert_map.set( "\\downarrow", "↓" );
      _insert_map.set( "\\downdownarrows", "⇊" );
      _insert_map.set( "\\downharpoonleft", "⇃" );
      _insert_map.set( "\\downharpoonright", "⇂" );
      _insert_map.set( "\\dr", "ṛ" );
      _insert_map.set( "\\drbkarow", "⤐" );
      _insert_map.set( "\\drcorn", "⌟" );
      _insert_map.set( "\\drcrop", "⌌" );
      _insert_map.set( "\\ds", "ṣ" );
      _insert_map.set( "\\dscr", "𝒹" );
      _insert_map.set( "\\dscy", "ѕ" );
      _insert_map.set( "\\dsol", "⧶" );
      _insert_map.set( "\\dstrok", "đ" );
      _insert_map.set( "\\dt", "ṭ" );
      _insert_map.set( "\\dtdot", "⋱" );
      _insert_map.set( "\\dtri", "▿" );
      _insert_map.set( "\\dtrif", "▾" );
      _insert_map.set( "\\du", "ụ" );
      _insert_map.set( "\\duarr", "⇵" );
      _insert_map.set( "\\duhar", "⥯" );
      _insert_map.set( "\\dv", "ṿ" );
      _insert_map.set( "\\dw", "ẉ" );
      _insert_map.set( "\\dwangle", "⦦" );
      _insert_map.set( "\\dy", "ỵ" );
      _insert_map.set( "\\dz", "ẓ" );
      _insert_map.set( "\\dzcy", "џ" );
      _insert_map.set( "\\dzigrarr", "" );
      _insert_map.set( "\\eDDot", "⩷" );
      _insert_map.set( "\\eDot", "≑" );
      _insert_map.set( "\\eacute", "é" );
      _insert_map.set( "\\earth", "⊕" );
      _insert_map.set( "\\easter", "≛" );
      _insert_map.set( "\\ecaron", "ě" );
      _insert_map.set( "\\ecir", "≖" );
      _insert_map.set( "\\ecirc", "ê" );
      _insert_map.set( "\\ecolon", "≕" );
      _insert_map.set( "\\ecy", "э" );
      _insert_map.set( "\\edot", "ė" );
      _insert_map.set( "\\ee", "ⅇ" );
      _insert_map.set( "\\efDot", "≒" );
      _insert_map.set( "\\efr", "𝔢" );
      _insert_map.set( "\\eg", "⪚" );
      _insert_map.set( "\\egrave", "è" );
      _insert_map.set( "\\egs", "⋝" );
      _insert_map.set( "\\egsdot", "⪘" );
      _insert_map.set( "\\ejectkey", "⏏" );
      _insert_map.set( "\\el", "⪙" );
      _insert_map.set( "\\ell", "ℓ" );
      _insert_map.set( "\\els", "⋜" );
      _insert_map.set( "\\elsdot", "⪗" );
      _insert_map.set( "\\emacr", "ē" );
      _insert_map.set( "\\empty", "∅" );
      _insert_map.set( "\\emptyset", "∅" );
      _insert_map.set( "\\emptyv", "∅" );
      _insert_map.set( "\\emsp", " " );
      _insert_map.set( "\\emsp13", " " );
      _insert_map.set( "\\emsp14", " " );
      _insert_map.set( "\\eng", "ŋ" );
      _insert_map.set( "\\ensp", " " );
      _insert_map.set( "\\enterkey", "⌤" );
      _insert_map.set( "\\eogon", "ę" );
      _insert_map.set( "\\eopf", "𝕖" );
      _insert_map.set( "\\epar", "⋕" );
      _insert_map.set( "\\eparsl", "⧣" );
      _insert_map.set( "\\eplus", "⩱" );
      _insert_map.set( "\\epsdice1", "⚀" );
      _insert_map.set( "\\epsdice2", "⚁" );
      _insert_map.set( "\\epsdice3", "⚂" );
      _insert_map.set( "\\epsdice4", "⚃" );
      _insert_map.set( "\\epsdice5", "⚄" );
      _insert_map.set( "\\epsdice6", "⚅" );
      _insert_map.set( "\\epsilon", "∊ 1" );
      _insert_map.set( "\\epsiv", "ɛ" );
      _insert_map.set( "\\eqcirc", "≖" );
      _insert_map.set( "\\eqcolon", "≕" );
      _insert_map.set( "\\eqsim", "≂" );
      _insert_map.set( "\\eqslantgtr", "⋝" );
      _insert_map.set( "\\eqslantless", "⋜" );
      _insert_map.set( "\\equest", "≟" );
      _insert_map.set( "\\equiv", "≡" );
      _insert_map.set( "\\equivDD", "⩸" );
      _insert_map.set( "\\eqvparsl", "⧥" );
      _insert_map.set( "\\erDot", "≓" );
      _insert_map.set( "\\erarr", "⥱" );
      _insert_map.set( "\\esckey", "⎋" );
      _insert_map.set( "\\escr", "ℯ" );
      _insert_map.set( "\\esdot", "≐" );
      _insert_map.set( "\\esim", "≂" );
      _insert_map.set( "\\eta", "η" );
      _insert_map.set( "\\eth", "ð" );
      _insert_map.set( "\\euml", "ë" );
      _insert_map.set( "\\euro", "€" );
      _insert_map.set( "\\exist", "∃" );
      _insert_map.set( "\\exists", "∃" );
      _insert_map.set( "\\expectation", "ℰ" );
      _insert_map.set( "\\exponentiale", "ⅇ" );
      _insert_map.set( "\\f", "φ" );
      _insert_map.set( "\\fallingdotseq", "≒" );
      _insert_map.set( "\\fcy", "ф" );
      _insert_map.set( "\\female", "♀" );
      _insert_map.set( "\\ffilig", "ﬃ" );
      _insert_map.set( "\\fflig", "ﬀ" );
      _insert_map.set( "\\ffllig", "ﬄ" );
      _insert_map.set( "\\ffr", "𝔣" );
      _insert_map.set( "\\filig", "ﬁ" );
      _insert_map.set( "\\flat", "♭" );
      _insert_map.set( "\\fllig", "ﬂ" );
      _insert_map.set( "\\fnof", "ƒ" );
      _insert_map.set( "\\fopf", "𝕗" );
      _insert_map.set( "\\forall", "∀" );
      _insert_map.set( "\\fork", "⋔" );
      _insert_map.set( "\\forkv", "⫙" );
      _insert_map.set( "\\fpartint", "⨍" );
      _insert_map.set( "\\frac", "½" );
      _insert_map.set( "\\frac13", "⅓" );
      _insert_map.set( "\\frac14", "¼" );
      _insert_map.set( "\\frac15", "⅕" );
      _insert_map.set( "\\frac16", "⅙" );
      _insert_map.set( "\\frac18", "⅛" );
      _insert_map.set( "\\frac23", "⅔" );
      _insert_map.set( "\\frac25", "⅖" );
      _insert_map.set( "\\frac34", "¾" );
      _insert_map.set( "\\frac35", "⅗" );
      _insert_map.set( "\\frac38", "⅜" );
      _insert_map.set( "\\frac45", "⅘" );
      _insert_map.set( "\\frac56", "⅚" );
      _insert_map.set( "\\frac58", "⅝" );
      _insert_map.set( "\\frac78", "⅞" );
      _insert_map.set( "\\frakA", "𝔄" );
      _insert_map.set( "\\frakB", "𝔅" );
      _insert_map.set( "\\frakC", "ℭ" );
      _insert_map.set( "\\frakD", "𝔇" );
      _insert_map.set( "\\frakE", "𝔈" );
      _insert_map.set( "\\frakF", "𝔉" );
      _insert_map.set( "\\frakG", "𝔊" );
      _insert_map.set( "\\frakH", "ℌ" );
      _insert_map.set( "\\frakI", "ℑ" );
      _insert_map.set( "\\frakJ", "𝔍" );
      _insert_map.set( "\\frakK", "𝔎" );
      _insert_map.set( "\\frakL", "𝔏" );
      _insert_map.set( "\\frakM", "𝔐" );
      _insert_map.set( "\\frakN", "𝔑" );
      _insert_map.set( "\\frakO", "𝔒" );
      _insert_map.set( "\\frakP", "𝔓" );
      _insert_map.set( "\\frakQ", "𝔔" );
      _insert_map.set( "\\frakR", "ℜ" );
      _insert_map.set( "\\frakS", "𝔖" );
      _insert_map.set( "\\frakT", "𝔗" );
      _insert_map.set( "\\frakU", "𝔘" );
      _insert_map.set( "\\frakV", "𝔙" );
      _insert_map.set( "\\frakW", "𝔚" );
      _insert_map.set( "\\frakX", "𝔛" );
      _insert_map.set( "\\frakY", "𝔜" );
      _insert_map.set( "\\frakZ", "ℨ" );
      _insert_map.set( "\\fraka", "𝔞" );
      _insert_map.set( "\\frakb", "𝔟" );
      _insert_map.set( "\\frakc", "𝔠" );
      _insert_map.set( "\\frakd", "𝔡" );
      _insert_map.set( "\\frake", "𝔢" );
      _insert_map.set( "\\frakf", "𝔣" );
      _insert_map.set( "\\frakg", "𝔤" );
      _insert_map.set( "\\frakh", "𝔥" );
      _insert_map.set( "\\fraki", "𝔦" );
      _insert_map.set( "\\frakj", "𝔧" );
      _insert_map.set( "\\frakk", "𝔨" );
      _insert_map.set( "\\frakl", "𝔩" );
      _insert_map.set( "\\frakm", "𝔪" );
      _insert_map.set( "\\frakn", "𝔫" );
      _insert_map.set( "\\frako", "𝔬" );
      _insert_map.set( "\\frakp", "𝔭" );
      _insert_map.set( "\\frakq", "𝔮" );
      _insert_map.set( "\\frakr", "𝔯" );
      _insert_map.set( "\\fraks", "𝔰" );
      _insert_map.set( "\\frakt", "𝔱" );
      _insert_map.set( "\\fraku", "𝔲" );
      _insert_map.set( "\\frakv", "𝔳" );
      _insert_map.set( "\\frakw", "𝔴" );
      _insert_map.set( "\\frakx", "𝔵" );
      _insert_map.set( "\\fraky", "𝔶" );
      _insert_map.set( "\\frakz", "𝔷" );
      _insert_map.set( "\\frown", "⌢" );
      _insert_map.set( "\\fscr", "𝒻" );
      _insert_map.set( "\\gE", "≧" );
      _insert_map.set( "\\gEl", "⋛" );
      _insert_map.set( "\\gacute", "ǵ" );
      _insert_map.set( "\\gamma", "γ" );
      _insert_map.set( "\\gammad", "Ϝ" );
      _insert_map.set( "\\gap", "≳" );
      _insert_map.set( "\\gbreve", "ğ" );
      _insert_map.set( "\\gcirc", "ĝ" );
      _insert_map.set( "\\gcy", "г" );
      _insert_map.set( "\\gdot", "ġ" );
      _insert_map.set( "\\ge", "≥" );
      _insert_map.set( "\\gel", "⋛" );
      _insert_map.set( "\\gemini", "♊" );
      _insert_map.set( "\\geq", "≥" );
      _insert_map.set( "\\geqq", "≧" );
      _insert_map.set( "\\geqslant", "⩾" );
      _insert_map.set( "\\ges", "⩾" );
      _insert_map.set( "\\gescc", "⪩" );
      _insert_map.set( "\\gesdot", "⪀" );
      _insert_map.set( "\\gesdoto", "⪂" );
      _insert_map.set( "\\gesdotol", "⪄" );
      _insert_map.set( "\\gesl", "⋛" );
      _insert_map.set( "\\gesles", "⪔" );
      _insert_map.set( "\\gets", "←" );
      _insert_map.set( "\\gfr", "𝔤" );
      _insert_map.set( "\\gg", "≫" );
      _insert_map.set( "\\ggg", "⋙" );
      _insert_map.set( "\\gimel", "ℷ" );
      _insert_map.set( "\\gjcy", "ѓ" );
      _insert_map.set( "\\gl", "≷" );
      _insert_map.set( "\\glE", "⪒" );
      _insert_map.set( "\\gla", "⪥" );
      _insert_map.set( "\\glj", "⪤" );
      _insert_map.set( "\\gnE", "≩" );
      _insert_map.set( "\\gnap", "⪊" );
      _insert_map.set( "\\gnapprox", "⪊" );
      _insert_map.set( "\\gne", "≩" );
      _insert_map.set( "\\gneq", "≩" );
      _insert_map.set( "\\gneqq", "≩" );
      _insert_map.set( "\\gnsim", "⋧" );
      _insert_map.set( "\\gopf", "𝕘" );
      _insert_map.set( "\\gscr", "ℊ" );
      _insert_map.set( "\\gsim", "≳" );
      _insert_map.set( "\\gsime", "⪎" );
      _insert_map.set( "\\gsiml", "⪐" );
      _insert_map.set( "\\gtcc", "⪧" );
      _insert_map.set( "\\gtcir", "⩺" );
      _insert_map.set( "\\gtdot", "⋗" );
      _insert_map.set( "\\gtlPar", "⦕" );
      _insert_map.set( "\\gtquest", "⩼" );
      _insert_map.set( "\\gtrapprox", "≳" );
      _insert_map.set( "\\gtrarr", "⥸" );
      _insert_map.set( "\\gtrdot", "⋗" );
      _insert_map.set( "\\gtreqless", "⋛" );
      _insert_map.set( "\\gtreqqless", "⋛" );
      _insert_map.set( "\\gtrless", "≷" );
      _insert_map.set( "\\gtrsim", "≳" );
      _insert_map.set( "\\gvertneqq", "≩" );
      _insert_map.set( "\\gvnE", "≩" );
      _insert_map.set( "\\h", "θ" );
      _insert_map.set( "\\hArr", "⇔" );
      _insert_map.set( "\\hairsp", " " );
      _insert_map.set( "\\half", "½" );
      _insert_map.set( "\\hamilt", "ℋ" );
      _insert_map.set( "\\hardcy", "ъ" );
      _insert_map.set( "\\harr", "↔" );
      _insert_map.set( "\\harrcir", "⥈" );
      _insert_map.set( "\\harrw", "↭" );
      _insert_map.set( "\\hbar", "ℏ" );
      _insert_map.set( "\\hcirc", "ĥ" );
      _insert_map.set( "\\heartsuit", "♡" );
      _insert_map.set( "\\hellip", "…" );
      _insert_map.set( "\\hercon", "⊹" );
      _insert_map.set( "\\hfr", "𝔥" );
      _insert_map.set( "\\hksearow", "⤥" );
      _insert_map.set( "\\hkswarow", "⤦" );
      _insert_map.set( "\\hoarr", "⇿" );
      _insert_map.set( "\\homtht", "∻" );
      _insert_map.set( "\\hookleftarrow", "↩" );
      _insert_map.set( "\\hookrightarrow", "↪" );
      _insert_map.set( "\\hopf", "𝕙" );
      _insert_map.set( "\\horbar", "―" );
      _insert_map.set( "\\hscr", "𝒽" );
      _insert_map.set( "\\hslash", "ℏ" );
      _insert_map.set( "\\hstrok", "ħ" );
      _insert_map.set( "\\hybull", "⁃" );
      _insert_map.set( "\\hyphen", "‐" );
      _insert_map.set( "\\iacute", "í" );
      _insert_map.set( "\\ic", "​" );
      _insert_map.set( "\\icirc", "î" );
      _insert_map.set( "\\icy", "и" );
      _insert_map.set( "\\iecy", "е" );
      _insert_map.set( "\\iexcl", "¡" );
      _insert_map.set( "\\iff", "⇔" );
      _insert_map.set( "\\ifr", "𝔦" );
      _insert_map.set( "\\igrave", "ì" );
      _insert_map.set( "\\ii", "ⅈ" );
      _insert_map.set( "\\iiiint", "⨌" );
      _insert_map.set( "\\iiint", "∭" );
      _insert_map.set( "\\iinfin", "⧜" );
      _insert_map.set( "\\iint", "∬" );
      _insert_map.set( "\\iiota", "℩" );
      _insert_map.set( "\\ijlig", "ĳ" );
      _insert_map.set( "\\imacr", "ī" );
      _insert_map.set( "\\image", "ℑ" );
      _insert_map.set( "\\imagline", "ℐ" );
      _insert_map.set( "\\imagpart", "ℑ" );
      _insert_map.set( "\\imath", "ı" );
      _insert_map.set( "\\imof", "⊷" );
      _insert_map.set( "\\imped", "𝕃" );
      _insert_map.set( "\\implies", "⇒" );
      _insert_map.set( "\\in", "∈" );
      _insert_map.set( "\\incare", "℅" );
      _insert_map.set( "\\infin", "∞" );
      _insert_map.set( "\\infty", "∞" );
      _insert_map.set( "\\inodot", "ı" );
      _insert_map.set( "\\int", "∫" );
      _insert_map.set( "\\intcal", "⊺" );
      _insert_map.set( "\\integers", "ℤ" );
      _insert_map.set( "\\intercal", "⊺" );
      _insert_map.set( "\\intlarhk", "⨗" );
      _insert_map.set( "\\intprod", "⨼" );
      _insert_map.set( "\\iocy", "ё" );
      _insert_map.set( "\\iogon", "į" );
      _insert_map.set( "\\iopf", "𝕚" );
      _insert_map.set( "\\iota", "ι" );
      _insert_map.set( "\\iprod", "⨼" );
      _insert_map.set( "\\iquest", "¿" );
      _insert_map.set( "\\iscr", "𝒾" );
      _insert_map.set( "\\isin", "∈" );
      _insert_map.set( "\\isinE", "⋹" );
      _insert_map.set( "\\isindot", "⋵" );
      _insert_map.set( "\\isins", "⋴" );
      _insert_map.set( "\\isinsv", "⋳" );
      _insert_map.set( "\\isinv", "∈" );
      _insert_map.set( "\\it", "⁢" );
      _insert_map.set( "\\itilde", "ĩ" );
      _insert_map.set( "\\iukcy", "і" );
      _insert_map.set( "\\iuml", "ï" );
      _insert_map.set( "\\jcirc", "ĵ" );
      _insert_map.set( "\\jcy", "й" );
      _insert_map.set( "\\jfr", "𝔧" );
      _insert_map.set( "\\jopf", "𝕛" );
      _insert_map.set( "\\jscr", "𝒿" );
      _insert_map.set( "\\jsercy", "ј" );
      _insert_map.set( "\\jukcy", "є" );
      _insert_map.set( "\\jupiter", "♃" );
      _insert_map.set( "\\kappa", "κ" );
      _insert_map.set( "\\kcedil", "ķ" );
      _insert_map.set( "\\kcy", "к" );
      _insert_map.set( "\\kfr", "𝔨" );
      _insert_map.set( "\\kgreen", "ĸ" );
      _insert_map.set( "\\khcy", "х" );
      _insert_map.set( "\\kjcy", "ќ" );
      _insert_map.set( "\\kopf", "𝕜" );
      _insert_map.set( "\\kscr", "𝓀" );
      _insert_map.set( "\\lAarr", "⇚" );
      _insert_map.set( "\\lArr", "⇐" );
      _insert_map.set( "\\lAtail", "⤛" );
      _insert_map.set( "\\lBarr", "⤎" );
      _insert_map.set( "\\lE", "≦" );
      _insert_map.set( "\\lEg", "⋚" );
      _insert_map.set( "\\lHar", "⥢" );
      _insert_map.set( "\\lacute", "ĺ" );
      _insert_map.set( "\\laemptyv", "⦴" );
      _insert_map.set( "\\lagran", "ℒ" );
      _insert_map.set( "\\lambda", "λ" );
      _insert_map.set( "\\land", "∧" );
      _insert_map.set( "\\lang", "⟨" );
      _insert_map.set( "\\langd", "⦑" );
      _insert_map.set( "\\langle", "⟨" );
      _insert_map.set( "\\lap", "≲" );
      _insert_map.set( "\\laquo", "«" );
      _insert_map.set( "\\larr", "←" );
      _insert_map.set( "\\larrb", "⇤" );
      _insert_map.set( "\\larrbfs", "⤟" );
      _insert_map.set( "\\larrfs", "⤝" );
      _insert_map.set( "\\larrhk", "↩" );
      _insert_map.set( "\\larrlp", "↫" );
      _insert_map.set( "\\larrpl", "⤹" );
      _insert_map.set( "\\larrsim", "⥳" );
      _insert_map.set( "\\larrtl", "↢" );
      _insert_map.set( "\\lat", "⪫" );
      _insert_map.set( "\\latail", "⤙" );
      _insert_map.set( "\\late", "⪭" );
      _insert_map.set( "\\lates", "⪭" );
      _insert_map.set( "\\lbarr", "⤌" );
      _insert_map.set( "\\lbbrk", "⦗" );
      _insert_map.set( "\\lbrke", "⦋" );
      _insert_map.set( "\\lbrksld", "⦏" );
      _insert_map.set( "\\lbrkslu", "⦍" );
      _insert_map.set( "\\lcaron", "ľ" );
      _insert_map.set( "\\lcedil", "ļ" );
      _insert_map.set( "\\lceil", "⌈" );
      _insert_map.set( "\\lcy", "л" );
      _insert_map.set( "\\ldca", "⤶" );
      _insert_map.set( "\\ldots", "…" );
      _insert_map.set( "\\ldquo", "“" );
      _insert_map.set( "\\ldquor", "„" );
      _insert_map.set( "\\ldrdhar", "⥧" );
      _insert_map.set( "\\ldrushar", "⥋" );
      _insert_map.set( "\\ldsh", "↲" );
      _insert_map.set( "\\le", "≤" );
      _insert_map.set( "\\leadsto", "↝" );
      _insert_map.set( "\\leftarrow", "←" );
      _insert_map.set( "\\leftarrowtail", "↢" );
      _insert_map.set( "\\leftharpoondown", "↽" );
      _insert_map.set( "\\leftharpoonup", "↼" );
      _insert_map.set( "\\leftleftarrows", "⇇" );
      _insert_map.set( "\\leftmoon", "☾" );
      _insert_map.set( "\\leftrightarrow", "↔" );
      _insert_map.set( "\\leftrightarrows", "⇆" );
      _insert_map.set( "\\leftrightharpoons", "⇋" );
      _insert_map.set( "\\leftrightsquigarrow", "↭" );
      _insert_map.set( "\\leftthreetimes", "⋋" );
      _insert_map.set( "\\leg", "⋚" );
      _insert_map.set( "\\leo", "♌" );
      _insert_map.set( "\\leq", "≤" );
      _insert_map.set( "\\leqq", "≦" );
      _insert_map.set( "\\leqslant", "≤" );
      _insert_map.set( "\\les", "⩽" );
      _insert_map.set( "\\lescc", "⪨" );
      _insert_map.set( "\\lesdot", "⩿" );
      _insert_map.set( "\\lesdoto", "⪁" );
      _insert_map.set( "\\lesdotor", "⪃" );
      _insert_map.set( "\\lesg", "⋚" );
      _insert_map.set( "\\lesges", "⪓" );
      _insert_map.set( "\\lessapprox", "≲" );
      _insert_map.set( "\\lessdot", "⋖" );
      _insert_map.set( "\\lesseqgtr", "⋚" );
      _insert_map.set( "\\lesseqqgtr", "⋚" );
      _insert_map.set( "\\lessgtr", "≶" );
      _insert_map.set( "\\lesssim", "≲" );
      _insert_map.set( "\\lfisht", "⥼" );
      _insert_map.set( "\\lfloor", "⌊" );
      _insert_map.set( "\\lfr", "𝔩" );
      _insert_map.set( "\\lgE", "⪑" );
      _insert_map.set( "\\lhard", "↽" );
      _insert_map.set( "\\lharu", "↼" );
      _insert_map.set( "\\lharul", "⥪" );
      _insert_map.set( "\\lhblk", "▄" );
      _insert_map.set( "\\lhd", "⊲" );
      _insert_map.set( "\\libra", "♎" );
      _insert_map.set( "\\ljcy", "љ" );
      _insert_map.set( "\\ll", "≪" );
      _insert_map.set( "\\llarr", "⇇" );
      _insert_map.set( "\\llcorner", "⌞" );
      _insert_map.set( "\\llhard", "⥫" );
      _insert_map.set( "\\lll", "⋘" );
      _insert_map.set( "\\lltri", "◺" );
      _insert_map.set( "\\lmidot", "ŀ" );
      _insert_map.set( "\\lmoust", "⎰" );
      _insert_map.set( "\\lmoustache", "⎰" );
      _insert_map.set( "\\lnE", "≨" );
      _insert_map.set( "\\lnap", "⪉" );
      _insert_map.set( "\\lnapprox", "⪉" );
      _insert_map.set( "\\lne", "≨" );
      _insert_map.set( "\\lneq", "≨" );
      _insert_map.set( "\\lneqq", "≨" );
      _insert_map.set( "\\lnot", "¬" );
      _insert_map.set( "\\lnsim", "⋦" );
      _insert_map.set( "\\loang", "" );
      _insert_map.set( "\\loarr", "⇽" );
      _insert_map.set( "\\lobrk", "⟦" );
      _insert_map.set( "\\longleftarrow", "←" );
      _insert_map.set( "\\longleftrightarrow", "↔" );
      _insert_map.set( "\\longmapsto", "⇖" );
      _insert_map.set( "\\longrightarrow", "→" );
      _insert_map.set( "\\looparrowleft", "↫" );
      _insert_map.set( "\\looparrowright", "↬" );
      _insert_map.set( "\\lopar", "⦅" );
      _insert_map.set( "\\lopf", "𝕝" );
      _insert_map.set( "\\loplus", "⨭" );
      _insert_map.set( "\\lor", "∨" );
      _insert_map.set( "\\lotimes", "⨴" );
      _insert_map.set( "\\lowast", "∗" );
      _insert_map.set( "\\loz", "◊" );
      _insert_map.set( "\\lozenge", "◊" );
      _insert_map.set( "\\lozf", "⧫" );
      _insert_map.set( "\\lparlt", "⦓" );
      _insert_map.set( "\\lrarr", "⇆" );
      _insert_map.set( "\\lrcorner", "⌟" );
      _insert_map.set( "\\lrhar", "⇋" );
      _insert_map.set( "\\lrhard", "⥭" );
      _insert_map.set( "\\lrtri", "⊿" );
      _insert_map.set( "\\lscr", "ℓ" );
      _insert_map.set( "\\lsh", "↰" );
      _insert_map.set( "\\lsim", "≲" );
      _insert_map.set( "\\lsime", "⪍" );
      _insert_map.set( "\\lsimg", "⪏" );
      _insert_map.set( "\\lsquo", "‘" );
      _insert_map.set( "\\lsquor", "‚" );
      _insert_map.set( "\\lstrok", "ł" );
      _insert_map.set( "\\ltcc", "⪦" );
      _insert_map.set( "\\ltcir", "⩹" );
      _insert_map.set( "\\ltdot", "⋖" );
      _insert_map.set( "\\lthree", "⋋" );
      _insert_map.set( "\\ltimes", "⋉" );
      _insert_map.set( "\\ltlarr", "⥶" );
      _insert_map.set( "\\ltquest", "⩻" );
      _insert_map.set( "\\ltrPar", "⦖" );
      _insert_map.set( "\\ltri", "◃" );
      _insert_map.set( "\\ltrie", "⊴" );
      _insert_map.set( "\\ltrif", "◂" );
      _insert_map.set( "\\lurdshar", "⥊" );
      _insert_map.set( "\\luruhar", "⥦" );
      _insert_map.set( "\\lvertneqq", "≨" );
      _insert_map.set( "\\lvnE", "≨" );
      _insert_map.set( "\\l{}", "ł" );
      _insert_map.set( "\\mDDot", "∺" );
      _insert_map.set( "\\macr", "¯" );
      _insert_map.set( "\\male", "♂" );
      _insert_map.set( "\\malt", "✠" );
      _insert_map.set( "\\maltese", "✠" );
      _insert_map.set( "\\map", "↦" );
      _insert_map.set( "\\mapsto", "↦" );
      _insert_map.set( "\\mapstodown", "↧" );
      _insert_map.set( "\\mapstoleft", "↤" );
      _insert_map.set( "\\mapstoup", "↥" );
      _insert_map.set( "\\marker", "▮" );
      _insert_map.set( "\\mars", "♂" );
      _insert_map.set( "\\mbox'", "’" );
      _insert_map.set( "\\mbox''", "”" );
      _insert_map.set( "\\mcomma", "⨩" );
      _insert_map.set( "\\mcy", "м" );
      _insert_map.set( "\\mdash", "—" );
      _insert_map.set( "\\measuredangle", "∡" );
      _insert_map.set( "\\mercury", "☿" );
      _insert_map.set( "\\mfr", "𝔪" );
      _insert_map.set( "\\mho", "℧" );
      _insert_map.set( "\\micro", "µ" );
      _insert_map.set( "\\mid", "∣" );
      _insert_map.set( "\\midcir", "⫰" );
      _insert_map.set( "\\middot", "·" );
      _insert_map.set( "\\minus", "−" );
      _insert_map.set( "\\minusb", "⊟" );
      _insert_map.set( "\\minusd", "∸" );
      _insert_map.set( "\\minusdu", "⨪" );
      _insert_map.set( "\\mlcp", "⫛" );
      _insert_map.set( "\\mldr", "…" );
      _insert_map.set( "\\mnplus", "∓" );
      _insert_map.set( "\\models", "⊨" );
      _insert_map.set( "\\mopf", "𝕞" );
      _insert_map.set( "\\mp", "∓" );
      _insert_map.set( "\\mscr", "𝓂" );
      _insert_map.set( "\\mstpos", "∾" );
      _insert_map.set( "\\mu", "μ" );
      _insert_map.set( "\\multimap", "⊸" );
      _insert_map.set( "\\mumap", "⊸" );
      _insert_map.set( "\\nGg", "⋙̸" );
      _insert_map.set( "\\nGt", "≫̸" );
      _insert_map.set( "\\nGtv", "≫̸" );
      _insert_map.set( "\\nLeftarrow", "⇍" );
      _insert_map.set( "\\nLeftrightarrow", "⇎" );
      _insert_map.set( "\\nLl", "⋘̸" );
      _insert_map.set( "\\nLt", "≪̸" );
      _insert_map.set( "\\nLtv", "≪̸" );
      _insert_map.set( "\\nRightarrow", "⇏" );
      _insert_map.set( "\\nVDash", "⊯" );
      _insert_map.set( "\\nVdash", "⊮" );
      _insert_map.set( "\\nabla", "∇" );
      _insert_map.set( "\\nacute", "ń" );
      _insert_map.set( "\\nang", "∠̸" );
      _insert_map.set( "\\nap", "≉" );
      _insert_map.set( "\\napE", "⩰̸" );
      _insert_map.set( "\\napid", "≋̸" );
      _insert_map.set( "\\napos", "ŉ" );
      _insert_map.set( "\\napprox", "≉" );
      _insert_map.set( "\\natur", "♮" );
      _insert_map.set( "\\natural", "♮" );
      _insert_map.set( "\\naturals", "ℕ" );
      _insert_map.set( "\\nbsp", " " );
      _insert_map.set( "\\nbump", "≎̸" );
      _insert_map.set( "\\nbumpe", "≏̸" );
      _insert_map.set( "\\ncap", "⩃" );
      _insert_map.set( "\\ncaron", "ň" );
      _insert_map.set( "\\ncedil", "ņ" );
      _insert_map.set( "\\ncong", "≇" );
      _insert_map.set( "\\ncongdot", "⩭̸" );
      _insert_map.set( "\\ncup", "⩂" );
      _insert_map.set( "\\ncy", "н" );
      _insert_map.set( "\\ndash", "–" );
      _insert_map.set( "\\ndivides", "∤" );
      _insert_map.set( "\\ne", "≠" );
      _insert_map.set( "\\neArr", "⇗" );
      _insert_map.set( "\\nearhk", "⤤" );
      _insert_map.set( "\\nearr", "↗" );
      _insert_map.set( "\\nearrow", "↗" );
      _insert_map.set( "\\nedot", "≠" );
      _insert_map.set( "\\neg", "¬" );
      _insert_map.set( "\\neptune", "♆" );
      _insert_map.set( "\\neq", "≠" );
      _insert_map.set( "\\nequiv", "≢" );
      _insert_map.set( "\\nesear", "⤨" );
      _insert_map.set( "\\nesim", "≂̸" );
      _insert_map.set( "\\nexist", "∄" );
      _insert_map.set( "\\nexists", "∄" );
      _insert_map.set( "\\nfr", "𝔫" );
      _insert_map.set( "\\ng", "ŋ" );
      _insert_map.set( "\\ngE", "≱" );
      _insert_map.set( "\\nge", "≱⃥" );
      _insert_map.set( "\\ngeq", "≱" );
      _insert_map.set( "\\ngeqq", "≱" );
      _insert_map.set( "\\ngeqslant", "≱" );
      _insert_map.set( "\\nges", "≱" );
      _insert_map.set( "\\ngsim", "≵" );
      _insert_map.set( "\\ngt", "≯" );
      _insert_map.set( "\\ngtr", "≯" );
      _insert_map.set( "\\nhArr", "⇎" );
      _insert_map.set( "\\nharr", "↮" );
      _insert_map.set( "\\nhpar", "⫲" );
      _insert_map.set( "\\ni", "∋" );
      _insert_map.set( "\\nis", "⋼" );
      _insert_map.set( "\\nisd", "⋺" );
      _insert_map.set( "\\niv", "∋" );
      _insert_map.set( "\\njcy", "њ" );
      _insert_map.set( "\\nlArr", "⇍" );
      _insert_map.set( "\\nlE", "≰" );
      _insert_map.set( "\\nlarr", "↚" );
      _insert_map.set( "\\nldr", "‥" );
      _insert_map.set( "\\nle", "≰⃥" );
      _insert_map.set( "\\nleftarrow", "↚" );
      _insert_map.set( "\\nleftrightarrow", "↮" );
      _insert_map.set( "\\nleq", "≰" );
      _insert_map.set( "\\nleqq", "≰" );
      _insert_map.set( "\\nleqslant", "≰" );
      _insert_map.set( "\\nles", "≰" );
      _insert_map.set( "\\nless", "≮" );
      _insert_map.set( "\\nlsim", "≴" );
      _insert_map.set( "\\nlt", "≮" );
      _insert_map.set( "\\nltri", "⋪" );
      _insert_map.set( "\\nltrie", "⋬" );
      _insert_map.set( "\\nmid", "∤" );
      _insert_map.set( "\\nopf", "𝕟" );
      _insert_map.set( "\\not", "¬" );
      _insert_map.set( "\\not<", "≮" );
      _insert_map.set( "\\not>", "≯" );
      _insert_map.set( "\\not\\Vdash", "⊮" );
      _insert_map.set( "\\not\\approx", "≉" );
      _insert_map.set( "\\not\\cong", "≇" );
      _insert_map.set( "\\not\\equiv", "≢" );
      _insert_map.set( "\\not\\ge", "≱" );
      _insert_map.set( "\\not\\gtrless", "≹" );
      _insert_map.set( "\\not\\in", "∉" );
      _insert_map.set( "\\not\\le", "≰" );
      _insert_map.set( "\\not\\models", "⊭" );
      _insert_map.set( "\\not\\ni", "∌" );
      _insert_map.set( "\\not\\sim", "≄" );
      _insert_map.set( "\\not\\sqsubseteq", "⋢" );
      _insert_map.set( "\\not\\sqsupseteq", "⋣" );
      _insert_map.set( "\\not\\subset", "⊄" );
      _insert_map.set( "\\not\\subseteq", "⊈" );
      _insert_map.set( "\\not\\supset", "⊅" );
      _insert_map.set( "\\not\\supseteq", "⊉" );
      _insert_map.set( "\\not\\vdash", "⊬" );
      _insert_map.set( "\\notin", "∉" );
      _insert_map.set( "\\notindot", "⋶" );
      _insert_map.set( "\\notinva", "∉̸" );
      _insert_map.set( "\\notinvb", "⋷" );
      _insert_map.set( "\\notinvc", "⋶" );
      _insert_map.set( "\\notni", "∌" );
      _insert_map.set( "\\notniva", "∌" );
      _insert_map.set( "\\notnivb", "⋾" );
      _insert_map.set( "\\notnivc", "⋽" );
      _insert_map.set( "\\npar", "∦" );
      _insert_map.set( "\\nparallel", "∦" );
      _insert_map.set( "\\nparsl", "∥⃥" );
      _insert_map.set( "\\npart", "∂̸" );
      _insert_map.set( "\\npolint", "⨔" );
      _insert_map.set( "\\npr", "⊀" );
      _insert_map.set( "\\nprcue", "⋠" );
      _insert_map.set( "\\npre", "⪯̸" );
      _insert_map.set( "\\nprec", "⊀" );
      _insert_map.set( "\\npreceq", "⪯̸" );
      _insert_map.set( "\\nrArr", "⇏" );
      _insert_map.set( "\\nrarr", "↛" );
      _insert_map.set( "\\nrarrc", "⤳̸" );
      _insert_map.set( "\\nrarrw", "↝̸" );
      _insert_map.set( "\\nrightarrow", "↛" );
      _insert_map.set( "\\nrtri", "⋫" );
      _insert_map.set( "\\nrtrie", "⋭" );
      _insert_map.set( "\\nsc", "⊁" );
      _insert_map.set( "\\nsccue", "⋡" );
      _insert_map.set( "\\nsce", "⪰̸" );
      _insert_map.set( "\\nscr", "𝓃" );
      _insert_map.set( "\\nshortmid", "∤" );
      _insert_map.set( "\\nshortparallel", "∦" );
      _insert_map.set( "\\nsim", "≁" );
      _insert_map.set( "\\nsime", "≄" );
      _insert_map.set( "\\nsimeq", "≄" );
      _insert_map.set( "\\nsmid", "∤" );
      _insert_map.set( "\\nspar", "∦" );
      _insert_map.set( "\\nsqsube", "⋢" );
      _insert_map.set( "\\nsqsupe", "⋣" );
      _insert_map.set( "\\nsub", "⊄" );
      _insert_map.set( "\\nsubE", "⊈" );
      _insert_map.set( "\\nsube", "⊈" );
      _insert_map.set( "\\nsubset", "⊄" );
      _insert_map.set( "\\nsubseteq", "⊈" );
      _insert_map.set( "\\nsubseteqq", "⊈" );
      _insert_map.set( "\\nsucc", "⊁" );
      _insert_map.set( "\\nsucceq", "⪰̸" );
      _insert_map.set( "\\nsup", "⊅" );
      _insert_map.set( "\\nsupE", "⊉" );
      _insert_map.set( "\\nsupe", "⊉" );
      _insert_map.set( "\\nsupset", "⊅" );
      _insert_map.set( "\\nsupseteq", "⊉" );
      _insert_map.set( "\\nsupseteqq", "⊉" );
      _insert_map.set( "\\ntgl", "≹" );
      _insert_map.set( "\\ntilde", "ñ" );
      _insert_map.set( "\\ntlg", "≸" );
      _insert_map.set( "\\ntriangleleft", "⋪" );
      _insert_map.set( "\\ntrianglelefteq", "⋬" );
      _insert_map.set( "\\ntriangleright", "⋫" );
      _insert_map.set( "\\ntrianglerighteq", "⋭" );
      _insert_map.set( "\\nu", "ν" );
      _insert_map.set( "\\numero", "№" );
      _insert_map.set( "\\numsp", " " );
      _insert_map.set( "\\nvDash", "⊭" );
      _insert_map.set( "\\nvHarr", "⇎" );
      _insert_map.set( "\\nvap", "≉̸" );
      _insert_map.set( "\\nvdash", "⊬" );
      _insert_map.set( "\\nvge", "≱" );
      _insert_map.set( "\\nvgt", "≯" );
      _insert_map.set( "\\nvinfin", "⧞" );
      _insert_map.set( "\\nvlArr", "⇍" );
      _insert_map.set( "\\nvle", "≰" );
      _insert_map.set( "\\nvlt", "≮" );
      _insert_map.set( "\\nvltrie", "⋬̸" );
      _insert_map.set( "\\nvrArr", "⇏" );
      _insert_map.set( "\\nvrtrie", "⋭̸" );
      _insert_map.set( "\\nvsim", "≁̸" );
      _insert_map.set( "\\nwArr", "⇖" );
      _insert_map.set( "\\nwarhk", "⤣" );
      _insert_map.set( "\\nwarr", "↖" );
      _insert_map.set( "\\nwarrow", "↖" );
      _insert_map.set( "\\nwnear", "⤧" );
      _insert_map.set( "\\o", "ο" );
      _insert_map.set( "\\oS", "Ⓢ" );
      _insert_map.set( "\\oacute", "ó" );
      _insert_map.set( "\\oast", "⊛" );
      _insert_map.set( "\\ocir", "⊚" );
      _insert_map.set( "\\ocirc", "ô" );
      _insert_map.set( "\\ocy", "о" );
      _insert_map.set( "\\odash", "⊝" );
      _insert_map.set( "\\odblac", "ő" );
      _insert_map.set( "\\odiv", "⨸" );
      _insert_map.set( "\\odot", "⊙" );
      _insert_map.set( "\\odsold", "⦼" );
      _insert_map.set( "\\oe", "œ" );
      _insert_map.set( "\\oelig", "œ" );
      _insert_map.set( "\\ofcir", "⦿" );
      _insert_map.set( "\\ofr", "𝔬" );
      _insert_map.set( "\\ogon", "˛" );
      _insert_map.set( "\\ograve", "ò" );
      _insert_map.set( "\\ogt", "⧁" );
      _insert_map.set( "\\ohbar", "⦵" );
      _insert_map.set( "\\ohm", "Ω" );
      _insert_map.set( "\\oint", "∮" );
      _insert_map.set( "\\olarr", "↺" );
      _insert_map.set( "\\olcir", "⦾" );
      _insert_map.set( "\\olcross", "⦻" );
      _insert_map.set( "\\olt", "⧀" );
      _insert_map.set( "\\omacr", "ō" );
      _insert_map.set( "\\omega", "ω" );
      _insert_map.set( "\\omicron", "ο" );
      _insert_map.set( "\\omid", "⦶" );
      _insert_map.set( "\\ominus", "⊖" );
      _insert_map.set( "\\oopf", "𝕠" );
      _insert_map.set( "\\opar", "⦷" );
      _insert_map.set( "\\operp", "⦹" );
      _insert_map.set( "\\oplus", "⊕" );
      _insert_map.set( "\\opposition", "☍" );
      _insert_map.set( "\\optkey", "⌥" );
      _insert_map.set( "\\or", "∨" );
      _insert_map.set( "\\orarr", "↻" );
      _insert_map.set( "\\ord", "⩝" );
      _insert_map.set( "\\order", "ℴ" );
      _insert_map.set( "\\orderof", "ℴ" );
      _insert_map.set( "\\ordf", "ª" );
      _insert_map.set( "\\ordm", "º" );
      _insert_map.set( "\\origof", "⊶" );
      _insert_map.set( "\\oror", "⩖" );
      _insert_map.set( "\\orslope", "⩗" );
      _insert_map.set( "\\orv", "⩛" );
      _insert_map.set( "\\oscr", "ℴ" );
      _insert_map.set( "\\oslash", "⊘" );
      _insert_map.set( "\\osol", "⊘" );
      _insert_map.set( "\\otilde", "õ" );
      _insert_map.set( "\\otimes", "⊗" );
      _insert_map.set( "\\otimesas", "⨶" );
      _insert_map.set( "\\ouml", "ö" );
      _insert_map.set( "\\ovbar", "⌽" );
      _insert_map.set( "\\owns", "∋" );
      _insert_map.set( "\\o{}", "ø" );
      _insert_map.set( "\\par", "∥" );
      _insert_map.set( "\\para", "¶" );
      _insert_map.set( "\\parallel", "∥" );
      _insert_map.set( "\\parsim", "⫳" );
      _insert_map.set( "\\parsl", "∥" );
      _insert_map.set( "\\part", "∂" );
      _insert_map.set( "\\partial", "∂" );
      _insert_map.set( "\\pcy", "п" );
      _insert_map.set( "\\permil", "‰" );
      _insert_map.set( "\\perp", "⊥" );
      _insert_map.set( "\\pertenk", "‱" );
      _insert_map.set( "\\pfr", "𝔭" );
      _insert_map.set( "\\phi", "φ" );
      _insert_map.set( "\\phmmat", "ℳ" );
      _insert_map.set( "\\phone", "☎" );
      _insert_map.set( "\\pi", "π" );
      _insert_map.set( "\\pilcrow", "¶" );
      _insert_map.set( "\\pisces", "♓" );
      _insert_map.set( "\\pitchfork", "⋔" );
      _insert_map.set( "\\planck", "ℏ" );
      _insert_map.set( "\\planckh", "ℎ" );
      _insert_map.set( "\\plankv", "ℏ" );
      _insert_map.set( "\\plusacir", "⨣" );
      _insert_map.set( "\\plusb", "⊞" );
      _insert_map.set( "\\pluscir", "⨢" );
      _insert_map.set( "\\plusdo", "∔" );
      _insert_map.set( "\\plusdu", "⨥" );
      _insert_map.set( "\\pluse", "⩲" );
      _insert_map.set( "\\plusmn", "±" );
      _insert_map.set( "\\plussim", "⨦" );
      _insert_map.set( "\\plustwo", "⨧" );
      _insert_map.set( "\\pluto", "♇" );
      _insert_map.set( "\\pm", "±" );
      _insert_map.set( "\\pointint", "⨕" );
      _insert_map.set( "\\popf", "𝕡" );
      _insert_map.set( "\\pound", "£" );
      _insert_map.set( "\\pounds", "£" );
      _insert_map.set( "\\pr", "≺" );
      _insert_map.set( "\\prE", "⪯" );
      _insert_map.set( "\\prap", "≾" );
      _insert_map.set( "\\prcue", "≼" );
      _insert_map.set( "\\pre", "⪯" );
      _insert_map.set( "\\prec", "≺" );
      _insert_map.set( "\\precapprox", "≾" );
      _insert_map.set( "\\preccurlyeq", "≼" );
      _insert_map.set( "\\preceq", "≼" );
      _insert_map.set( "\\precnapprox", "⋨" );
      _insert_map.set( "\\precneqq", "⪵" );
      _insert_map.set( "\\precnsim", "⋨" );
      _insert_map.set( "\\precsim", "≾" );
      _insert_map.set( "\\prime", "′" );
      _insert_map.set( "\\primes", "ℙ" );
      _insert_map.set( "\\prnE", "⪵" );
      _insert_map.set( "\\prnap", "⋨" );
      _insert_map.set( "\\prnsim", "⋨" );
      _insert_map.set( "\\prod", "∏" );
      _insert_map.set( "\\profalar", "⌮" );
      _insert_map.set( "\\profline", "⌒" );
      _insert_map.set( "\\profsurf", "⌓" );
      _insert_map.set( "\\prop", "∝" );
      _insert_map.set( "\\propto", "∝" );
      _insert_map.set( "\\prsim", "≾" );
      _insert_map.set( "\\prurel", "⊰" );
      _insert_map.set( "\\pscr", "𝓅" );
      _insert_map.set( "\\psi", "ψ" );
      _insert_map.set( "\\puncsp", " " );
      _insert_map.set( "\\qfr", "𝔮" );
      _insert_map.set( "\\qint", "⨌" );
      _insert_map.set( "\\qopf", "𝕢" );
      _insert_map.set( "\\qprime", "⁗" );
      _insert_map.set( "\\qscr", "𝓆" );
      _insert_map.set( "\\quaternions", "ℍ" );
      _insert_map.set( "\\quatint", "⨖" );
      _insert_map.set( "\\questeq", "≟" );
      _insert_map.set( "\\rAarr", "⇛" );
      _insert_map.set( "\\rArr", "⇒" );
      _insert_map.set( "\\rAtail", "⤜" );
      _insert_map.set( "\\rBarr", "⤏" );
      _insert_map.set( "\\rHar", "⥤" );
      _insert_map.set( "\\race", "⧚" );
      _insert_map.set( "\\racute", "ŕ" );
      _insert_map.set( "\\radic", "√" );
      _insert_map.set( "\\raemptyv", "⦳" );
      _insert_map.set( "\\rang", "⟩" );
      _insert_map.set( "\\rangd", "⦒" );
      _insert_map.set( "\\range", "⦥" );
      _insert_map.set( "\\rangle", "⟩" );
      _insert_map.set( "\\raquo", "»" );
      _insert_map.set( "\\rarr", "→" );
      _insert_map.set( "\\rarrap", "⥵" );
      _insert_map.set( "\\rarrb", "⇥" );
      _insert_map.set( "\\rarrbfs", "⤠" );
      _insert_map.set( "\\rarrc", "⤳" );
      _insert_map.set( "\\rarrfs", "⤞" );
      _insert_map.set( "\\rarrhk", "↪" );
      _insert_map.set( "\\rarrlp", "↬" );
      _insert_map.set( "\\rarrpl", "⥅" );
      _insert_map.set( "\\rarrsim", "⥴" );
      _insert_map.set( "\\rarrtl", "↣" );
      _insert_map.set( "\\rarrw", "↝" );
      _insert_map.set( "\\ratail", "↣" );
      _insert_map.set( "\\ratio", "∶" );
      _insert_map.set( "\\rationals", "ℚ" );
      _insert_map.set( "\\rbarr", "⤍" );
      _insert_map.set( "\\rbbrk", "⦘" );
      _insert_map.set( "\\rbrke", "⦌" );
      _insert_map.set( "\\rbrksld", "⦎" );
      _insert_map.set( "\\rbrkslu", "⦐" );
      _insert_map.set( "\\rcaron", "ř" );
      _insert_map.set( "\\rcedil", "ŗ" );
      _insert_map.set( "\\rceil", "⌉" );
      _insert_map.set( "\\rcy", "р" );
      _insert_map.set( "\\rdca", "⤷" );
      _insert_map.set( "\\rdldhar", "⥩" );
      _insert_map.set( "\\rdquo", "”" );
      _insert_map.set( "\\rdquor", "”" );
      _insert_map.set( "\\rdsh", "↳" );
      _insert_map.set( "\\real", "ℜ" );
      _insert_map.set( "\\realine", "ℛ" );
      _insert_map.set( "\\realpart", "ℜ" );
      _insert_map.set( "\\reals", "ℝ" );
      _insert_map.set( "\\rect", "▭" );
      _insert_map.set( "\\reg", "®" );
      _insert_map.set( "\\registered", "®" );
      _insert_map.set( "\\returnkey", "⏎" );
      _insert_map.set( "\\revtabkey", "⇤" );
      _insert_map.set( "\\rfisht", "⥽" );
      _insert_map.set( "\\rfloor", "⌋" );
      _insert_map.set( "\\rfr", "𝔯" );
      _insert_map.set( "\\rhard", "⇁" );
      _insert_map.set( "\\rharu", "⇀" );
      _insert_map.set( "\\rharul", "⥬" );
      _insert_map.set( "\\rhd", "⊳" );
      _insert_map.set( "\\rho", "ρ" );
      _insert_map.set( "\\rightarrow", "→" );
      _insert_map.set( "\\rightarrowtail", "↣" );
      _insert_map.set( "\\rightdelkey", "⌦" );
      _insert_map.set( "\\rightharpoondown", "⇁" );
      _insert_map.set( "\\rightharpoonup", "⇀" );
      _insert_map.set( "\\rightleftarrows", "⇄" );
      _insert_map.set( "\\rightleftharpoons", "⇌" );
      _insert_map.set( "\\rightmoon", "☽" );
      _insert_map.set( "\\rightrightarrows", "⇉" );
      _insert_map.set( "\\rightsquigarrow", "⇝" );
      _insert_map.set( "\\rightthreetimes", "⋌" );
      _insert_map.set( "\\ring", "˚" );
      _insert_map.set( "\\risingdotseq", "≓" );
      _insert_map.set( "\\rlarr", "⇄" );
      _insert_map.set( "\\rlhar", "⇌" );
      _insert_map.set( "\\rmoust", "⎱" );
      _insert_map.set( "\\rmoustache", "⎱" );
      _insert_map.set( "\\rnmid", "⫮" );
      _insert_map.set( "\\roang", "" );
      _insert_map.set( "\\roarr", "⇾" );
      _insert_map.set( "\\robrk", "⟧" );
      _insert_map.set( "\\ropar", "⦆" );
      _insert_map.set( "\\ropf", "𝕣" );
      _insert_map.set( "\\roplus", "⨮" );
      _insert_map.set( "\\rotimes", "⨵" );
      _insert_map.set( "\\rpargt", "⦔" );
      _insert_map.set( "\\rppolint", "⨒" );
      _insert_map.set( "\\rrarr", "⇉" );
      _insert_map.set( "\\rscr", "𝓇" );
      _insert_map.set( "\\rsh", "↱" );
      _insert_map.set( "\\rsquo", "’" );
      _insert_map.set( "\\rsquor", "’" );
      _insert_map.set( "\\rthree", "⋌" );
      _insert_map.set( "\\rtimes", "⋊" );
      _insert_map.set( "\\rtri", "▹" );
      _insert_map.set( "\\rtrie", "⊵" );
      _insert_map.set( "\\rtrif", "▸" );
      _insert_map.set( "\\rtriltri", "⧎" );
      _insert_map.set( "\\ruluhar", "⥨" );
      _insert_map.set( "\\rx", "℞" );
      _insert_map.set( "\\sacute", "ś" );
      _insert_map.set( "\\sagittarius", "♐" );
      _insert_map.set( "\\saturn", "♄" );
      _insert_map.set( "\\sc", "≻" );
      _insert_map.set( "\\scE", "≾" );
      _insert_map.set( "\\scap", "≿" );
      _insert_map.set( "\\scaron", "š" );
      _insert_map.set( "\\sccue", "≽" );
      _insert_map.set( "\\sce", "≽" );
      _insert_map.set( "\\scedil", "ş" );
      _insert_map.set( "\\scirc", "ŝ" );
      _insert_map.set( "\\scnE", "⪶" );
      _insert_map.set( "\\scnap", "⋩" );
      _insert_map.set( "\\scnsim", "⋩" );
      _insert_map.set( "\\scorpio", "♏" );
      _insert_map.set( "\\scpolint", "⨓" );
      _insert_map.set( "\\scsim", "≿" );
      _insert_map.set( "\\scy", "с" );
      _insert_map.set( "\\sdot", "⋅" );
      _insert_map.set( "\\sdotb", "⊡" );
      _insert_map.set( "\\sdote", "⩦" );
      _insert_map.set( "\\seArr", "⇘" );
      _insert_map.set( "\\searhk", "⤥" );
      _insert_map.set( "\\searr", "↘" );
      _insert_map.set( "\\searrow", "↘" );
      _insert_map.set( "\\sect", "§" );
      _insert_map.set( "\\section", "§" );
      _insert_map.set( "\\seswar", "⤩" );
      _insert_map.set( "\\setminus", "∖" );
      _insert_map.set( "\\setmn", "∖" );
      _insert_map.set( "\\sext", "✶" );
      _insert_map.set( "\\sfr", "𝔰" );
      _insert_map.set( "\\sharp", "♯" );
      _insert_map.set( "\\shchcy", "щ" );
      _insert_map.set( "\\shcy", "ш" );
      _insert_map.set( "\\shiftkey", "⇧" );
      _insert_map.set( "\\shortmid", "∣" );
      _insert_map.set( "\\shortparallel", "∥" );
      _insert_map.set( "\\shy", "­" );
      _insert_map.set( "\\sigma", "σ" );
      _insert_map.set( "\\sim", "∼" );
      _insert_map.set( "\\simdot", "⩪" );
      _insert_map.set( "\\sime", "≃" );
      _insert_map.set( "\\simeq", "≃" );
      _insert_map.set( "\\simg", "⪞" );
      _insert_map.set( "\\simgE", "⪠" );
      _insert_map.set( "\\siml", "⪝" );
      _insert_map.set( "\\simlE", "⪟" );
      _insert_map.set( "\\simne", "≆" );
      _insert_map.set( "\\simplus", "⨤" );
      _insert_map.set( "\\simrarr", "⥲" );
      _insert_map.set( "\\slarr", "←" );
      _insert_map.set( "\\smallfrown", "⌢" );
      _insert_map.set( "\\smallsetminus", "∖" );
      _insert_map.set( "\\smallsmile", "⌣" );
      _insert_map.set( "\\smashp", "⨳" );
      _insert_map.set( "\\smeparsl", "⧤" );
      _insert_map.set( "\\smid", "∣" );
      _insert_map.set( "\\smile", "⌣" );
      _insert_map.set( "\\smt", "⪪" );
      _insert_map.set( "\\smte", "⪬" );
      _insert_map.set( "\\smtes", "⪬" );
      _insert_map.set( "\\softcy", "ь" );
      _insert_map.set( "\\solb", "⧄" );
      _insert_map.set( "\\solbar", "⌿" );
      _insert_map.set( "\\sopf", "𝕤" );
      _insert_map.set( "\\space", "␣" );
      _insert_map.set( "\\spades", "♠" );
      _insert_map.set( "\\spadesuit", "♠" );
      _insert_map.set( "\\spar", "∥" );
      _insert_map.set( "\\sphericalangle", "∢" );
      _insert_map.set( "\\sqcap", "⊓" );
      _insert_map.set( "\\sqcaps", "⊓" );
      _insert_map.set( "\\sqcup", "⊔" );
      _insert_map.set( "\\sqcups", "⊔" );
      _insert_map.set( "\\sqsub", "⊏" );
      _insert_map.set( "\\sqsube", "⊑" );
      _insert_map.set( "\\sqsubset", "⊏" );
      _insert_map.set( "\\sqsubseteq", "⊑" );
      _insert_map.set( "\\sqsup", "⊐" );
      _insert_map.set( "\\sqsupe", "⊒" );
      _insert_map.set( "\\sqsupset", "⊐" );
      _insert_map.set( "\\sqsupseteq", "⊒" );
      _insert_map.set( "\\squ", "□" );
      _insert_map.set( "\\square", "□" );
      _insert_map.set( "\\squarf", "▪" );
      _insert_map.set( "\\squf", "▪" );
      _insert_map.set( "\\srarr", "→" );
      _insert_map.set( "\\ss", "ß" );
      _insert_map.set( "\\sscr", "𝓈" );
      _insert_map.set( "\\ssetmn", "∖" );
      _insert_map.set( "\\sstarf", "⋆" );
      _insert_map.set( "\\star", "⋆" );
      _insert_map.set( "\\starf", "★" );
      _insert_map.set( "\\straightepsilon", "ε" );
      _insert_map.set( "\\straightphi", "φ" );
      _insert_map.set( "\\subE", "⊆" );
      _insert_map.set( "\\subdot", "⪽" );
      _insert_map.set( "\\sube", "⊆" );
      _insert_map.set( "\\subedot", "⫃" );
      _insert_map.set( "\\submult", "⫁" );
      _insert_map.set( "\\subnE", "⊊" );
      _insert_map.set( "\\subne", "⊊" );
      _insert_map.set( "\\subplus", "⪿" );
      _insert_map.set( "\\subrarr", "⥹" );
      _insert_map.set( "\\subset", "⊂" );
      _insert_map.set( "\\subseteq", "⊆" );
      _insert_map.set( "\\subseteqq", "⊆" );
      _insert_map.set( "\\subsetneq", "⊊" );
      _insert_map.set( "\\subsetneqq", "⊊" );
      _insert_map.set( "\\subsim", "⫇" );
      _insert_map.set( "\\subsub", "⫕" );
      _insert_map.set( "\\subsup", "⫓" );
      _insert_map.set( "\\succ", "≻" );
      _insert_map.set( "\\succapprox", "≿" );
      _insert_map.set( "\\succcurlyeq", "≽" );
      _insert_map.set( "\\succeq", "≽" );
      _insert_map.set( "\\succnapprox", "⋩" );
      _insert_map.set( "\\succneqq", "⪶" );
      _insert_map.set( "\\succnsim", "⋩" );
      _insert_map.set( "\\succsim", "≿" );
      _insert_map.set( "\\sum", "∑" );
      _insert_map.set( "\\sung", "♪" );
      _insert_map.set( "\\sup", "^" );
      _insert_map.set( "\\sup1", "¹" );
      _insert_map.set( "\\sup2", "²" );
      _insert_map.set( "\\sup3", "³" );
      _insert_map.set( "\\supE", "⊇" );
      _insert_map.set( "\\supdot", "⪾" );
      _insert_map.set( "\\supdsub", "⫘" );
      _insert_map.set( "\\supe", "⊇" );
      _insert_map.set( "\\supedot", "⫄" );
      _insert_map.set( "\\suphsol", "⊃/" );
      _insert_map.set( "\\suphsub", "⫗" );
      _insert_map.set( "\\suplarr", "⥻" );
      _insert_map.set( "\\supmult", "⫂" );
      _insert_map.set( "\\supnE", "⊋" );
      _insert_map.set( "\\supne", "⊋" );
      _insert_map.set( "\\supplus", "⫀" );
      _insert_map.set( "\\supset", "⊃" );
      _insert_map.set( "\\supseteq", "⊇" );
      _insert_map.set( "\\supseteqq", "⊇" );
      _insert_map.set( "\\supsetneq", "⊋" );
      _insert_map.set( "\\supsetneqq", "⊋" );
      _insert_map.set( "\\supsim", "⫈" );
      _insert_map.set( "\\supsub", "⫔" );
      _insert_map.set( "\\supsup", "⫖" );
      _insert_map.set( "\\surd", "√" );
      _insert_map.set( "\\swArr", "⇙" );
      _insert_map.set( "\\swarhk", "⤦" );
      _insert_map.set( "\\swarr", "↙" );
      _insert_map.set( "\\swarrow", "↙" );
      _insert_map.set( "\\swnwar", "⤪" );
      _insert_map.set( "\\szlig", "ß" );
      _insert_map.set( "\\tabkey", "⇥" );
      _insert_map.set( "\\target", "⌖" );
      _insert_map.set( "\\tau", "τ" );
      _insert_map.set( "\\taurus", "♉" );
      _insert_map.set( "\\tbrk", "⎴" );
      _insert_map.set( "\\tcaron", "ť" );
      _insert_map.set( "\\tcedil", "ţ" );
      _insert_map.set( "\\tcy", "т" );
      _insert_map.set( "\\tdot", "⃛" );
      _insert_map.set( "\\telrec", "⌕" );
      _insert_map.set( "\\textbabygamma", "ɤ" );
      _insert_map.set( "\\textbarglotstop", "ʡ" );
      _insert_map.set( "\\textbari", "ɨ" );
      _insert_map.set( "\\textbaro", "ɵ" );
      _insert_map.set( "\\textbarrevglotstop", "ʢ" );
      _insert_map.set( "\\textbaru", "ʉ" );
      _insert_map.set( "\\textbeltl", "ɬ" );
      _insert_map.set( "\\textbeta", "β" );
      _insert_map.set( "\\textbullseye", "ʘ" );
      _insert_map.set( "\\textchi", "χ" );
      _insert_map.set( "\\textcloserevepsilon", "ɞ" );
      _insert_map.set( "\\textcrh", "ħ" );
      _insert_map.set( "\\textctc", "ɕ" );
      _insert_map.set( "\\textctj", "ʝ" );
      _insert_map.set( "\\textctz", "ʑ" );
      _insert_map.set( "\\textdoublepipe", "ǁ" );
      _insert_map.set( "\\textdyoghlig", "ʤ" );
      _insert_map.set( "\\textepsilon", "ɛ" );
      _insert_map.set( "\\textesh", "ʃ" );
      _insert_map.set( "\\textfishhookr", "ɾ" );
      _insert_map.set( "\\textgamma", "ɣ" );
      _insert_map.set( "\\textglotstop", "ʔ" );
      _insert_map.set( "\\textgrgamma", "γ" );
      _insert_map.set( "\\texthtb", "ɓ" );
      _insert_map.set( "\\texthtd", "ɗ" );
      _insert_map.set( "\\texthtg", "ɠ" );
      _insert_map.set( "\\texthth", "ɦ" );
      _insert_map.set( "\\texththeng", "ɧ" );
      _insert_map.set( "\\texthtscg", "ʛ" );
      _insert_map.set( "\\textinvscr", "ʁ" );
      _insert_map.set( "\\textiota", "ι" );
      _insert_map.set( "\\textltailm", "ɱ" );
      _insert_map.set( "\\textltailn", "ɲ" );
      _insert_map.set( "\\textltilde", "ɫ" );
      _insert_map.set( "\\textlyoghlig", "ɮ" );
      _insert_map.set( "\\textopeno", "ɔ" );
      _insert_map.set( "\\textphi", "ɸ" );
      _insert_map.set( "\\textpipe", "ǀ" );
      _insert_map.set( "\\textregistered", "®" );
      _insert_map.set( "\\textreve", "ɘ" );
      _insert_map.set( "\\textrevepsilon", "ɜ" );
      _insert_map.set( "\\textrevglotstop", "ʕ" );
      _insert_map.set( "\\textrhookrevepsilon", "ɝ" );
      _insert_map.set( "\\textrighthookschwa", "ɚ" );
      _insert_map.set( "\\textrtaild", "ɖ" );
      _insert_map.set( "\\textrtaill", "ɭ" );
      _insert_map.set( "\\textrtailn", "ɳ" );
      _insert_map.set( "\\textrtailr", "ɽ" );
      _insert_map.set( "\\textrtails", "ʂ" );
      _insert_map.set( "\\textrtailt", "ʈ" );
      _insert_map.set( "\\textrtailz", "ʐ" );
      _insert_map.set( "\\textscb", "ʙ" );
      _insert_map.set( "\\textscg", "ɢ" );
      _insert_map.set( "\\textsch", "ʜ" );
      _insert_map.set( "\\textschwa", "ə" );
      _insert_map.set( "\\textsci", "ɪ" );
      _insert_map.set( "\\textscl", "ʟ" );
      _insert_map.set( "\\textscn", "ɴ" );
      _insert_map.set( "\\textscoelig", "ɶ" );
      _insert_map.set( "\\textscr", "ʀ" );
      _insert_map.set( "\\textscripta", "ɑ" );
      _insert_map.set( "\\textscriptv", "ʋ" );
      _insert_map.set( "\\textscy", "ʏ" );
      _insert_map.set( "\\textteshlig", "ʧ" );
      _insert_map.set( "\\texttheta", "θ" );
      _insert_map.set( "\\texttrademark", "™" );
      _insert_map.set( "\\textturna", "ɐ" );
      _insert_map.set( "\\textturnh", "ɥ" );
      _insert_map.set( "\\textturnlonglegr", "ɺ" );
      _insert_map.set( "\\textturnm", "ɯ" );
      _insert_map.set( "\\textturnmrleg", "ɰ" );
      _insert_map.set( "\\textturnr", "ɹ" );
      _insert_map.set( "\\textturnrrtail", "ɻ" );
      _insert_map.set( "\\textturnscripta", "ɒ" );
      _insert_map.set( "\\textturnv", "ʌ" );
      _insert_map.set( "\\textturnw", "ʍ" );
      _insert_map.set( "\\textturny", "ʎ" );
      _insert_map.set( "\\textupsilon", "ʊ" );
      _insert_map.set( "\\textyogh", "ʒ" );
      _insert_map.set( "\\tfr", "𝔱" );
      _insert_map.set( "\\th", "þ" );
      _insert_map.set( "\\there4", "∴" );
      _insert_map.set( "\\therefore", "∴" );
      _insert_map.set( "\\theta", "θ" );
      _insert_map.set( "\\thickapprox", "≈" );
      _insert_map.set( "\\thicksim", "∼" );
      _insert_map.set( "\\thinsp", " " );
      _insert_map.set( "\\thkap", "≈" );
      _insert_map.set( "\\thksim", "∼" );
      _insert_map.set( "\\thorn", "þ" );
      _insert_map.set( "\\tilde", "˜" );
      _insert_map.set( "\\times", "×" );
      _insert_map.set( "\\timesb", "⊠" );
      _insert_map.set( "\\timesbar", "⨱" );
      _insert_map.set( "\\timesd", "⨰" );
      _insert_map.set( "\\tint", "∭" );
      _insert_map.set( "\\to", "→" );
      _insert_map.set( "\\toea", "⤨" );
      _insert_map.set( "\\top", "⊤" );
      _insert_map.set( "\\topbot", "⌶" );
      _insert_map.set( "\\topcir", "⫱" );
      _insert_map.set( "\\topf", "𝕥" );
      _insert_map.set( "\\topfork", "⫚" );
      _insert_map.set( "\\tosa", "⤩" );
      _insert_map.set( "\\tprime", "‴" );
      _insert_map.set( "\\trade", "™" );
      _insert_map.set( "\\trademark", "™" );
      _insert_map.set( "\\triangle", "△" );
      _insert_map.set( "\\triangledown", "▽" );
      _insert_map.set( "\\triangleleft", "◁" );
      _insert_map.set( "\\trianglelefteq", "⊴" );
      _insert_map.set( "\\triangleq", "≜" );
      _insert_map.set( "\\triangleright", "▷" );
      _insert_map.set( "\\trianglerighteq", "⊵" );
      _insert_map.set( "\\tridot", "◬" );
      _insert_map.set( "\\trie", "≜" );
      _insert_map.set( "\\triminus", "⨺" );
      _insert_map.set( "\\triplus", "⨹" );
      _insert_map.set( "\\trisb", "⧍" );
      _insert_map.set( "\\tritime", "⨻" );
      _insert_map.set( "\\tscr", "𝓉" );
      _insert_map.set( "\\tscy", "ц" );
      _insert_map.set( "\\tshcy", "ћ" );
      _insert_map.set( "\\tstrok", "ŧ" );
      _insert_map.set( "\\twixt", "≬" );
      _insert_map.set( "\\twoheadleftarrow", "↞" );
      _insert_map.set( "\\twoheadrightarrow", "↠" );
      _insert_map.set( "\\uA", "Ă" );
      _insert_map.set( "\\uArr", "⇑" );
      _insert_map.set( "\\uE", "Ĕ" );
      _insert_map.set( "\\uG", "Ğ" );
      _insert_map.set( "\\uHar", "⥣" );
      _insert_map.set( "\\uI", "Ĭ" );
      _insert_map.set( "\\uO", "Ŏ" );
      _insert_map.set( "\\uU", "Ŭ" );
      _insert_map.set( "\\ua", "ă" );
      _insert_map.set( "\\uacute", "ú" );
      _insert_map.set( "\\uarr", "↑" );
      _insert_map.set( "\\ubrcy", "ў" );
      _insert_map.set( "\\ubreve", "ŭ" );
      _insert_map.set( "\\ucirc", "û" );
      _insert_map.set( "\\ucy", "у" );
      _insert_map.set( "\\udarr", "⇅" );
      _insert_map.set( "\\udblac", "ű" );
      _insert_map.set( "\\udhar", "⥮" );
      _insert_map.set( "\\ue", "ĕ" );
      _insert_map.set( "\\ufisht", "⥾" );
      _insert_map.set( "\\ufr", "𝔲" );
      _insert_map.set( "\\ug", "ğ" );
      _insert_map.set( "\\ugrave", "ù" );
      _insert_map.set( "\\uharl", "↿" );
      _insert_map.set( "\\uharr", "↾" );
      _insert_map.set( "\\uhblk", "▀" );
      _insert_map.set( "\\ui", "ĭ" );
      _insert_map.set( "\\ulcorn", "⌜" );
      _insert_map.set( "\\ulcorner", "⌜" );
      _insert_map.set( "\\ulcrop", "⌏" );
      _insert_map.set( "\\ultri", "◸" );
      _insert_map.set( "\\umacr", "ū" );
      _insert_map.set( "\\uml", "¨" );
      _insert_map.set( "\\unlhd", "⊴" );
      _insert_map.set( "\\unrhd", "⊵" );
      _insert_map.set( "\\uo", "ŏ" );
      _insert_map.set( "\\uogon", "ų" );
      _insert_map.set( "\\uopf", "𝕦" );
      _insert_map.set( "\\uparrow", "↑" );
      _insert_map.set( "\\updownarrow", "↕" );
      _insert_map.set( "\\upharpoonleft", "↿" );
      _insert_map.set( "\\upharpoonright", "↾" );
      _insert_map.set( "\\uplus", "⊎" );
      _insert_map.set( "\\upsilon", "υ" );
      _insert_map.set( "\\upuparrows", "⇈" );
      _insert_map.set( "\\uranus", "⛢" );
      _insert_map.set( "\\urcorn", "⌝" );
      _insert_map.set( "\\urcorner", "⌝" );
      _insert_map.set( "\\urcrop", "⌎" );
      _insert_map.set( "\\uring", "ů" );
      _insert_map.set( "\\urtri", "◹" );
      _insert_map.set( "\\uscr", "𝓊" );
      _insert_map.set( "\\utdot", "⋰" );
      _insert_map.set( "\\utilde", "ũ" );
      _insert_map.set( "\\utri", "▵" );
      _insert_map.set( "\\utrif", "▴" );
      _insert_map.set( "\\uu", "ŭ" );
      _insert_map.set( "\\uuarr", "⇈" );
      _insert_map.set( "\\uuml", "ü" );
      _insert_map.set( "\\uwangle", "⦧" );
      _insert_map.set( "\\v", "ν" );
      _insert_map.set( "\\vA", "Ǎ" );
      _insert_map.set( "\\vArr", "⇕" );
      _insert_map.set( "\\vBar", "⫨" );
      _insert_map.set( "\\vBarv", "⫩" );
      _insert_map.set( "\\vC", "Č" );
      _insert_map.set( "\\vD", "Ď" );
      _insert_map.set( "\\vDash", "⊨" );
      _insert_map.set( "\\vE", "Ě" );
      _insert_map.set( "\\vN", "Ň" );
      _insert_map.set( "\\vR", "Ř" );
      _insert_map.set( "\\vS", "Š" );
      _insert_map.set( "\\vT", "Ť" );
      _insert_map.set( "\\vZ", "Ž" );
      _insert_map.set( "\\va", "ǎ" );
      _insert_map.set( "\\vangrt", "⊾" );
      _insert_map.set( "\\varepsilon", "ε" );
      _insert_map.set( "\\varkappa", "ϰ" );
      _insert_map.set( "\\varnothing", "∅" );
      _insert_map.set( "\\varphi", "ϕ" );
      _insert_map.set( "\\varpi", "ϖ" );
      _insert_map.set( "\\varpropto", "∝" );
      _insert_map.set( "\\varr", "↕" );
      _insert_map.set( "\\varrho", "ϱ" );
      _insert_map.set( "\\varsigma", "ς" );
      _insert_map.set( "\\varsubsetneq", "⊊" );
      _insert_map.set( "\\varsubsetneqq", "⊊" );
      _insert_map.set( "\\varsupsetneq", "⊋" );
      _insert_map.set( "\\varsupsetneqq", "⊋" );
      _insert_map.set( "\\vartheta", "ϑ" );
      _insert_map.set( "\\vartriangle", "△" );
      _insert_map.set( "\\vartriangleleft", "⊲" );
      _insert_map.set( "\\vartriangleright", "⊳" );
      _insert_map.set( "\\vc", "č" );
      _insert_map.set( "\\vcy", "в" );
      _insert_map.set( "\\vd", "ď" );
      _insert_map.set( "\\vdash", "⊢" );
      _insert_map.set( "\\vdots", "⋮" );
      _insert_map.set( "\\ve", "ě" );
      _insert_map.set( "\\vee", "∨" );
      _insert_map.set( "\\veebar", "⊻" );
      _insert_map.set( "\\veeeq", "≚" );
      _insert_map.set( "\\vellip", "⋮" );
      _insert_map.set( "\\venus", "♀" );
      _insert_map.set( "\\vfr", "𝔳" );
      _insert_map.set( "\\virgo", "♍" );
      _insert_map.set( "\\vltri", "⊲" );
      _insert_map.set( "\\vn", "ň" );
      _insert_map.set( "\\vnsub", "⊄" );
      _insert_map.set( "\\vnsup", "⊅" );
      _insert_map.set( "\\vopf", "𝕧" );
      _insert_map.set( "\\vprop", "∝" );
      _insert_map.set( "\\vr", "ř" );
      _insert_map.set( "\\vrtri", "⊳" );
      _insert_map.set( "\\vs", "š" );
      _insert_map.set( "\\vscr", "𝓋" );
      _insert_map.set( "\\vsubnE", "⊊" );
      _insert_map.set( "\\vsubne", "⊊" );
      _insert_map.set( "\\vsupnE", "⊋" );
      _insert_map.set( "\\vsupne", "⊋" );
      _insert_map.set( "\\vt", "ť" );
      _insert_map.set( "\\vz", "ž" );
      _insert_map.set( "\\vzigzag", "⦚" );
      _insert_map.set( "\\w", "ω" );
      _insert_map.set( "\\wcirc", "ŵ" );
      _insert_map.set( "\\wedbar", "⩟" );
      _insert_map.set( "\\wedge", "∧" );
      _insert_map.set( "\\wedgeq", "≙" );
      _insert_map.set( "\\weierp", "℘" );
      _insert_map.set( "\\wfr", "𝔴" );
      _insert_map.set( "\\whitebishop", "♗" );
      _insert_map.set( "\\whiteking", "♔" );
      _insert_map.set( "\\whiteknight", "♘" );
      _insert_map.set( "\\whitepawn", "♙" );
      _insert_map.set( "\\whitequeen", "♕" );
      _insert_map.set( "\\whiterook", "♖" );
      _insert_map.set( "\\wopf", "𝕨" );
      _insert_map.set( "\\wp", "℘" );
      _insert_map.set( "\\wr", "≀" );
      _insert_map.set( "\\wreath", "≀" );
      _insert_map.set( "\\wscr", "𝓌" );
      _insert_map.set( "\\xcap", "⋂" );
      _insert_map.set( "\\xcirc", "◯" );
      _insert_map.set( "\\xcup", "⋃" );
      _insert_map.set( "\\xdtri", "▽" );
      _insert_map.set( "\\xfr", "𝔵" );
      _insert_map.set( "\\xhArr", "" );
      _insert_map.set( "\\xharr", "" );
      _insert_map.set( "\\xi", "ξ" );
      _insert_map.set( "\\xlArr", "" );
      _insert_map.set( "\\xlarr", "" );
      _insert_map.set( "\\xmap", "" );
      _insert_map.set( "\\xnis", "⋻" );
      _insert_map.set( "\\xodot", "⊙" );
      _insert_map.set( "\\xopf", "𝕩" );
      _insert_map.set( "\\xoplus", "⊕" );
      _insert_map.set( "\\xotime", "⊗" );
      _insert_map.set( "\\xrArr", "" );
      _insert_map.set( "\\xrarr", "" );
      _insert_map.set( "\\xscr", "𝓍" );
      _insert_map.set( "\\xsqcup", "⊔" );
      _insert_map.set( "\\xuplus", "⊎" );
      _insert_map.set( "\\xutri", "△" );
      _insert_map.set( "\\xvee", "⋁" );
      _insert_map.set( "\\xwedge", "⋀" );
      _insert_map.set( "\\yacute", "ý" );
      _insert_map.set( "\\yacy", "я" );
      _insert_map.set( "\\ycirc", "ŷ" );
      _insert_map.set( "\\ycy", "ы" );
      _insert_map.set( "\\yen", "¥" );
      _insert_map.set( "\\yfr", "𝔶" );
      _insert_map.set( "\\yicy", "ї" );
      _insert_map.set( "\\yopf", "𝕪" );
      _insert_map.set( "\\yscr", "𝓎" );
      _insert_map.set( "\\yucy", "ю" );
      _insert_map.set( "\\yuml", "ÿ" );
      _insert_map.set( "\\zacute", "ź" );
      _insert_map.set( "\\zcaron", "ž" );
      _insert_map.set( "\\zcy", "з" );
      _insert_map.set( "\\zdot", "ż" );
      _insert_map.set( "\\zeetrf", "ℨ" );
      _insert_map.set( "\\zeta", "ζ" );
      _insert_map.set( "\\zfr", "𝔷" );
      _insert_map.set( "\\zhcy", "ж" );
      _insert_map.set( "\\zigrarr", "⇝" );
      _insert_map.set( "\\zopf", "𝕫" );
      _insert_map.set( "\\zscr", "𝓏" );
      _insert_map.set( "\\~A", "Ā" );
      _insert_map.set( "\\~E", "Ẽ" );
      _insert_map.set( "\\~I", "Ĩ" );
      _insert_map.set( "\\~N", "Ñ" );
      _insert_map.set( "\\~O", "Õ" );
      _insert_map.set( "\\~U", "Ũ" );
      _insert_map.set( "\\~Y", "Ỹ" );
      _insert_map.set( "\\~a", "ã" );
      _insert_map.set( "\\~e", "ẽ" );
      _insert_map.set( "\\~i", "ĩ" );
      _insert_map.set( "\\~n", "ñ" );
      _insert_map.set( "\\~o", "õ" );
      _insert_map.set( "\\~u", "ũ" );
      _insert_map.set( "\\~y", "ỹ" );
    }
  }

  /* Populates the source completion provider with the list of proposals from this */
  public GLib.List<Gtk.SourceCompletionItem> create_proposals() {
    var proposals = new GLib.List<Gtk.SourceCompletionItem>();
    var it        = _insert_map.map_iterator();
    while( it.next() ) {
      var key   = (string)it.get_key();
      var val   = (string)it.get_value();
      var item   = new Gtk.SourceCompletionItem();
      item.label = key;
      item.text  = val;
      proposals.append( item );
    }
    proposals.sort((a, b) => {
      return( GLib.strcmp( a.label, b.label ) );
    });
    return( proposals );
  }

  /* Returns the last word of the given string */
  private string get_last_word( string str ) {

    for( int i=(str.char_count() - 1); i>=0; i-- ) {
      if( str.get_char( i ).isspace() ) {
        return( str.substring( str.index_of_nth_char( i + 1 ) ) );
      }
    }

    return( str );

  }

  /* Returns the replacement string with the substituted value */
  public string replace_with_value( string str, string val ) {

    var word = get_last_word( str );

    if( str == word ) {
      return( val );
    } else {
      return( str.substring( 0, (str.length - word.length) ) + val );
    }

  }

  /* Replaces the last word (if it is a key) with the associated value and returns this new string */
  public string do_replace( string str ) {

    var word = get_last_word( str );

    if( _insert_map.has_key( word ) ) {
      var val = _insert_map.get( word );
      return( replace_with_value( str, val ) );
    }

    return( str );

  }

  /* Returns an array of matching unicode strings and their values */
  public GLib.List<TextCompletionItem> get_matches( string partial ) {
    var it      = _insert_map.map_iterator();
    var matches = new GLib.List<TextCompletionItem>();
    while( it.next() ) {
      var key = (string)it.get_key();
      if( key.has_prefix( partial ) ) {
        var val  = (string)it.get_value();
        var item = new TextCompletionItem.with_alt( key, val );
        matches.append( item );
      }
    }
    matches.sort( TextCompletionItem.compare );
    return( matches );
  }

}
