# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ShaderProperty(Object):
    r"""
    ShaderProperty - represent GPU shader properties
    
    Superclass: Object
    
    ShaderProperty is used to hold user-defined modifications of a GPU
    shader program used in a mapper.
    
    @sa
    Volume OpenGLUniform
    
    @par Thanks: Developed by Simon Drouin (sdrouin2@bwh.harvard.edu) at
    Brigham and Women's Hospital.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkShaderProperty, obj, update, **traits)
    
    fragment_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _fragment_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFragmentShaderCode,
                        self.fragment_shader_code)

    geometry_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _geometry_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGeometryShaderCode,
                        self.geometry_shader_code)

    vertex_shader_code = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _vertex_shader_code_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexShaderCode,
                        self.vertex_shader_code)

    def _get_fragment_custom_uniforms(self):
        return wrap_vtk(self._vtk_obj.GetFragmentCustomUniforms())
    fragment_custom_uniforms = traits.Property(_get_fragment_custom_uniforms, desc=\
        r"""
        The Uniforms object allows to set custom uniform variables that
        are used in replacement shader code.
        """
    )

    def _get_geometry_custom_uniforms(self):
        return wrap_vtk(self._vtk_obj.GetGeometryCustomUniforms())
    geometry_custom_uniforms = traits.Property(_get_geometry_custom_uniforms, desc=\
        r"""
        
        """
    )

    def get_nth_shader_replacement(self, *args):
        """
        get_nth_shader_replacement(self, index:int, name:str,
            replaceFirst:bool, replacementValue:str, replaceAll:bool)
            -> None
        C++: virtual void get_nth_shader_replacement(IdType index,
            std::string &name, bool &replaceFirst,
            std::string &replacementValue, bool &replaceAll)"""
        ret = self._wrap_call(self._vtk_obj.GetNthShaderReplacement, *args)
        return ret

    def get_nth_shader_replacement_type_as_string(self, *args):
        """
        get_nth_shader_replacement_type_as_string(self, index:int) -> str
        C++: virtual std::string get_nth_shader_replacement_type_as_string(
            IdType index)"""
        ret = self._wrap_call(self._vtk_obj.GetNthShaderReplacementTypeAsString, *args)
        return ret

    def _get_number_of_shader_replacements(self):
        return self._vtk_obj.GetNumberOfShaderReplacements()
    number_of_shader_replacements = traits.Property(_get_number_of_shader_replacements, desc=\
        r"""
        
        """
    )

    def _get_shader_m_time(self):
        return self._vtk_obj.GetShaderMTime()
    shader_m_time = traits.Property(_get_shader_m_time, desc=\
        r"""
        get_shader_m_time returns the last time a modification
        was made that affected the code of the shader (either code
        replacement was changed or one or more uniform variables were
        added or removed. This timestamp can be used by mappers to
        determine if the shader must be recompiled. Simply changing the
        value of an existing uniform variable doesn't affect this
        timestamp as it doesn't change the shader code.
        @return timestamp of the last modification
        """
    )

    def _get_vertex_custom_uniforms(self):
        return wrap_vtk(self._vtk_obj.GetVertexCustomUniforms())
    vertex_custom_uniforms = traits.Property(_get_vertex_custom_uniforms, desc=\
        r"""
        
        """
    )

    def add_fragment_shader_replacement(self, *args):
        """
        add_fragment_shader_replacement(self, originalValue:str,
            replaceFirst:bool, replacementValue:str, replaceAll:bool)
            -> None
        C++: virtual void add_fragment_shader_replacement(
            const std::string &originalValue, bool replaceFirst,
            const std::string &replacementValue, bool replaceAll)"""
        ret = self._wrap_call(self._vtk_obj.AddFragmentShaderReplacement, *args)
        return ret

    def add_geometry_shader_replacement(self, *args):
        """
        add_geometry_shader_replacement(self, originalValue:str,
            replaceFirst:bool, replacementValue:str, replaceAll:bool)
            -> None
        C++: virtual void add_geometry_shader_replacement(
            const std::string &originalValue, bool replaceFirst,
            const std::string &replacementValue, bool replaceAll)"""
        ret = self._wrap_call(self._vtk_obj.AddGeometryShaderReplacement, *args)
        return ret

    def add_vertex_shader_replacement(self, *args):
        """
        add_vertex_shader_replacement(self, originalValue:str,
            replaceFirst:bool, replacementValue:str, replaceAll:bool)
            -> None
        C++: virtual void add_vertex_shader_replacement(
            const std::string &originalValue, bool replaceFirst,
            const std::string &replacementValue, bool replaceAll)
        This function enables you to apply your own substitutions to the
        shader creation process. The shader code in this class is created
        by applying a bunch of string replacements to a shader template.
        Using this function you can apply your own string replacements to
        add features you desire.
        """
        ret = self._wrap_call(self._vtk_obj.AddVertexShaderReplacement, *args)
        return ret

    def clear_all_fragment_shader_replacements(self):
        """
        clear_all_fragment_shader_replacements(self) -> None
        C++: virtual void clear_all_fragment_shader_replacements()"""
        ret = self._vtk_obj.ClearAllFragmentShaderReplacements()
        return ret
        

    def clear_all_geometry_shader_replacements(self):
        """
        clear_all_geometry_shader_replacements(self) -> None
        C++: virtual void clear_all_geometry_shader_replacements()"""
        ret = self._vtk_obj.ClearAllGeometryShaderReplacements()
        return ret
        

    def clear_all_shader_replacements(self):
        """
        clear_all_shader_replacements(self) -> None
        C++: virtual void clear_all_shader_replacements()"""
        ret = self._vtk_obj.ClearAllShaderReplacements()
        return ret
        

    def clear_all_vertex_shader_replacements(self):
        """
        clear_all_vertex_shader_replacements(self) -> None
        C++: virtual void clear_all_vertex_shader_replacements()"""
        ret = self._vtk_obj.ClearAllVertexShaderReplacements()
        return ret
        

    def clear_fragment_shader_replacement(self, *args):
        """
        clear_fragment_shader_replacement(self, originalValue:str,
            replaceFirst:bool) -> None
        C++: virtual void clear_fragment_shader_replacement(
            const std::string &originalValue, bool replaceFirst)"""
        ret = self._wrap_call(self._vtk_obj.ClearFragmentShaderReplacement, *args)
        return ret

    def clear_geometry_shader_replacement(self, *args):
        """
        clear_geometry_shader_replacement(self, originalValue:str,
            replaceFirst:bool) -> None
        C++: virtual void clear_geometry_shader_replacement(
            const std::string &originalValue, bool replaceFirst)"""
        ret = self._wrap_call(self._vtk_obj.ClearGeometryShaderReplacement, *args)
        return ret

    def clear_vertex_shader_replacement(self, *args):
        """
        clear_vertex_shader_replacement(self, originalValue:str,
            replaceFirst:bool) -> None
        C++: virtual void clear_vertex_shader_replacement(
            const std::string &originalValue, bool replaceFirst)"""
        ret = self._wrap_call(self._vtk_obj.ClearVertexShaderReplacement, *args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, p:ShaderProperty) -> None
        C++: void deep_copy(ShaderProperty *p)
        Assign one property to another.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def has_fragment_shader_code(self):
        """
        has_fragment_shader_code(self) -> bool
        C++: bool has_fragment_shader_code()"""
        ret = self._vtk_obj.HasFragmentShaderCode()
        return ret
        

    def has_geometry_shader_code(self):
        """
        has_geometry_shader_code(self) -> bool
        C++: bool has_geometry_shader_code()"""
        ret = self._vtk_obj.HasGeometryShaderCode()
        return ret
        

    def has_vertex_shader_code(self):
        """
        has_vertex_shader_code(self) -> bool
        C++: bool has_vertex_shader_code()
        Allow the program to set the shader codes used directly instead
        of using the built in templates. Be aware, if set, this template
        will be used for all cases, primitive types, picking etc.
        """
        ret = self._vtk_obj.HasVertexShaderCode()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('fragment_shader_code',
    'GetFragmentShaderCode'), ('geometry_shader_code',
    'GetGeometryShaderCode'), ('vertex_shader_code',
    'GetVertexShaderCode'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'fragment_shader_code',
    'geometry_shader_code', 'vertex_shader_code'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ShaderProperty, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ShaderProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['fragment_shader_code', 'geometry_shader_code',
            'vertex_shader_code']),
            title='Edit ShaderProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ShaderProperty properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

