/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/PropListHolder.hpp"
#include "MsXpS/libXpertMassCore/Oligomer.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC OligomerPair : public PropListHolder
{
  public:
  OligomerPair(const QString &name,
               const OligomerSPtr first_csp,
               const OligomerSPtr second_csp,
               Enums::MassType mass_type,
               double error,
               bool isMatching = false);

  OligomerPair(const OligomerPair &);

  virtual ~OligomerPair();

  QString getName();

  const OligomerSPtr getFirst() const;
  const OligomerSPtr getSecond() const;

  void setMassType(Enums::MassType mass_type);
  Enums::MassType getMassType() const;

  void setError(double);
  double getError() const;

  void setMatching(bool isMatching);
  bool isMatching() const;

  double getFirstMass();
  double getSecondMass();

  int firstCharge();
  int secondCharge();

  //////////////// OPERATORS /////////////////////
  using PropListHolder::operator=;
  OligomerPair &operator=(const OligomerPair &other);

  protected:
  QString m_name;
  OligomerSPtr msp_first;
  OligomerSPtr msp_second;
  Enums::MassType m_massType;
  double m_error;
  bool m_isMatching;
};

typedef std::shared_ptr<OligomerPair> OligomerPairSPtr;
typedef std::shared_ptr<const OligomerPair> OligomerPairCstSPtr;


} // namespace libXpertMassCore
} // namespace MsXpS
