; RUN: llc -march=hexagon < %s -enable-misched=false | FileCheck %s

; Test that LICM doesn't hoist an instruction incorrectly
; when register aliases are not processed. In this case, LICM hoists
; a register assignment of 0, but the register is defined as
; double register (with two and instructions) already.

; CHECK: [[REG0:r([0-9]+)]] = and
; CHECK: [[REG1:r([0-9]+)]] = and
; CHECK-NOT: [[REG0]] =
; CHECK-NOT: [[REG1]] =
; CHECK: .LBB

; Function Attrs: nounwind readnone
define i64 @f0(i64 %a0) #0 {
b0:
  %v0 = lshr i64 %a0, 1
  %v1 = and i64 %v0, 6148914691236517205
  %v2 = and i64 %a0, 6148914691236517205
  br label %b1

b1:                                               ; preds = %b1, %b0
  %v3 = phi i64 [ %v2, %b0 ], [ %v197, %b1 ]
  %v4 = phi i64 [ %v1, %b0 ], [ %v196, %b1 ]
  %v5 = phi i64 [ 0, %b0 ], [ %v195, %b1 ]
  %v6 = phi i32 [ 0, %b0 ], [ %v198, %b1 ]
  %v7 = and i64 %v3, 1
  %v8 = zext i32 %v6 to i64
  %v9 = shl i64 %v7, %v8
  %v10 = and i64 %v4, 1
  %v11 = add nuw nsw i32 %v6, 32
  %v12 = zext i32 %v11 to i64
  %v13 = shl i64 %v10, %v12
  %v14 = or i64 %v13, %v5
  %v15 = or i64 %v14, %v9
  %v16 = lshr i64 %v4, 2
  %v17 = lshr i64 %v3, 2
  %v18 = add nuw nsw i32 %v6, 1
  %v19 = and i64 %v17, 1
  %v20 = zext i32 %v18 to i64
  %v21 = shl i64 %v19, %v20
  %v22 = and i64 %v16, 1
  %v23 = add nsw i32 %v6, 33
  %v24 = zext i32 %v23 to i64
  %v25 = shl i64 %v22, %v24
  %v26 = or i64 %v25, %v15
  %v27 = or i64 %v26, %v21
  %v28 = lshr i64 %v4, 4
  %v29 = lshr i64 %v3, 4
  %v30 = add nsw i32 %v6, 2
  %v31 = and i64 %v29, 1
  %v32 = zext i32 %v30 to i64
  %v33 = shl i64 %v31, %v32
  %v34 = and i64 %v28, 1
  %v35 = add nsw i32 %v6, 34
  %v36 = zext i32 %v35 to i64
  %v37 = shl i64 %v34, %v36
  %v38 = or i64 %v37, %v27
  %v39 = or i64 %v38, %v33
  %v40 = lshr i64 %v4, 6
  %v41 = lshr i64 %v3, 6
  %v42 = add nsw i32 %v6, 3
  %v43 = and i64 %v41, 1
  %v44 = zext i32 %v42 to i64
  %v45 = shl i64 %v43, %v44
  %v46 = and i64 %v40, 1
  %v47 = add nsw i32 %v6, 35
  %v48 = zext i32 %v47 to i64
  %v49 = shl i64 %v46, %v48
  %v50 = or i64 %v49, %v39
  %v51 = or i64 %v50, %v45
  %v52 = lshr i64 %v4, 8
  %v53 = lshr i64 %v3, 8
  %v54 = add nsw i32 %v6, 4
  %v55 = and i64 %v53, 1
  %v56 = zext i32 %v54 to i64
  %v57 = shl i64 %v55, %v56
  %v58 = and i64 %v52, 1
  %v59 = add nsw i32 %v6, 36
  %v60 = zext i32 %v59 to i64
  %v61 = shl i64 %v58, %v60
  %v62 = or i64 %v61, %v51
  %v63 = or i64 %v62, %v57
  %v64 = lshr i64 %v4, 10
  %v65 = lshr i64 %v3, 10
  %v66 = add nsw i32 %v6, 5
  %v67 = and i64 %v65, 1
  %v68 = zext i32 %v66 to i64
  %v69 = shl i64 %v67, %v68
  %v70 = and i64 %v64, 1
  %v71 = add nsw i32 %v6, 37
  %v72 = zext i32 %v71 to i64
  %v73 = shl i64 %v70, %v72
  %v74 = or i64 %v73, %v63
  %v75 = or i64 %v74, %v69
  %v76 = lshr i64 %v4, 12
  %v77 = lshr i64 %v3, 12
  %v78 = add nsw i32 %v6, 6
  %v79 = and i64 %v77, 1
  %v80 = zext i32 %v78 to i64
  %v81 = shl i64 %v79, %v80
  %v82 = and i64 %v76, 1
  %v83 = add nsw i32 %v6, 38
  %v84 = zext i32 %v83 to i64
  %v85 = shl i64 %v82, %v84
  %v86 = or i64 %v85, %v75
  %v87 = or i64 %v86, %v81
  %v88 = lshr i64 %v4, 14
  %v89 = lshr i64 %v3, 14
  %v90 = add nsw i32 %v6, 7
  %v91 = and i64 %v89, 1
  %v92 = zext i32 %v90 to i64
  %v93 = shl i64 %v91, %v92
  %v94 = and i64 %v88, 1
  %v95 = add nsw i32 %v6, 39
  %v96 = zext i32 %v95 to i64
  %v97 = shl i64 %v94, %v96
  %v98 = or i64 %v97, %v87
  %v99 = or i64 %v98, %v93
  %v100 = lshr i64 %v4, 16
  %v101 = lshr i64 %v3, 16
  %v102 = add nsw i32 %v6, 8
  %v103 = and i64 %v101, 1
  %v104 = zext i32 %v102 to i64
  %v105 = shl i64 %v103, %v104
  %v106 = and i64 %v100, 1
  %v107 = add nsw i32 %v6, 40
  %v108 = zext i32 %v107 to i64
  %v109 = shl i64 %v106, %v108
  %v110 = or i64 %v109, %v99
  %v111 = or i64 %v110, %v105
  %v112 = lshr i64 %v4, 18
  %v113 = lshr i64 %v3, 18
  %v114 = add nsw i32 %v6, 9
  %v115 = and i64 %v113, 1
  %v116 = zext i32 %v114 to i64
  %v117 = shl i64 %v115, %v116
  %v118 = and i64 %v112, 1
  %v119 = add nsw i32 %v6, 41
  %v120 = zext i32 %v119 to i64
  %v121 = shl i64 %v118, %v120
  %v122 = or i64 %v121, %v111
  %v123 = or i64 %v122, %v117
  %v124 = lshr i64 %v4, 20
  %v125 = lshr i64 %v3, 20
  %v126 = add nsw i32 %v6, 10
  %v127 = and i64 %v125, 1
  %v128 = zext i32 %v126 to i64
  %v129 = shl i64 %v127, %v128
  %v130 = and i64 %v124, 1
  %v131 = add nsw i32 %v6, 42
  %v132 = zext i32 %v131 to i64
  %v133 = shl i64 %v130, %v132
  %v134 = or i64 %v133, %v123
  %v135 = or i64 %v134, %v129
  %v136 = lshr i64 %v4, 22
  %v137 = lshr i64 %v3, 22
  %v138 = add nsw i32 %v6, 11
  %v139 = and i64 %v137, 1
  %v140 = zext i32 %v138 to i64
  %v141 = shl i64 %v139, %v140
  %v142 = and i64 %v136, 1
  %v143 = add nsw i32 %v6, 43
  %v144 = zext i32 %v143 to i64
  %v145 = shl i64 %v142, %v144
  %v146 = or i64 %v145, %v135
  %v147 = or i64 %v146, %v141
  %v148 = lshr i64 %v4, 24
  %v149 = lshr i64 %v3, 24
  %v150 = add nsw i32 %v6, 12
  %v151 = and i64 %v149, 1
  %v152 = zext i32 %v150 to i64
  %v153 = shl i64 %v151, %v152
  %v154 = and i64 %v148, 1
  %v155 = add nsw i32 %v6, 44
  %v156 = zext i32 %v155 to i64
  %v157 = shl i64 %v154, %v156
  %v158 = or i64 %v157, %v147
  %v159 = or i64 %v158, %v153
  %v160 = lshr i64 %v4, 26
  %v161 = lshr i64 %v3, 26
  %v162 = add nsw i32 %v6, 13
  %v163 = and i64 %v161, 1
  %v164 = zext i32 %v162 to i64
  %v165 = shl i64 %v163, %v164
  %v166 = and i64 %v160, 1
  %v167 = add nsw i32 %v6, 45
  %v168 = zext i32 %v167 to i64
  %v169 = shl i64 %v166, %v168
  %v170 = or i64 %v169, %v159
  %v171 = or i64 %v170, %v165
  %v172 = lshr i64 %v4, 28
  %v173 = lshr i64 %v3, 28
  %v174 = add nsw i32 %v6, 14
  %v175 = and i64 %v173, 1
  %v176 = zext i32 %v174 to i64
  %v177 = shl i64 %v175, %v176
  %v178 = and i64 %v172, 1
  %v179 = add nsw i32 %v6, 46
  %v180 = zext i32 %v179 to i64
  %v181 = shl i64 %v178, %v180
  %v182 = or i64 %v181, %v171
  %v183 = or i64 %v182, %v177
  %v184 = lshr i64 %v4, 30
  %v185 = lshr i64 %v3, 30
  %v186 = add nsw i32 %v6, 15
  %v187 = and i64 %v185, 1
  %v188 = zext i32 %v186 to i64
  %v189 = shl i64 %v187, %v188
  %v190 = and i64 %v184, 1
  %v191 = add nsw i32 %v6, 47
  %v192 = zext i32 %v191 to i64
  %v193 = shl i64 %v190, %v192
  %v194 = or i64 %v193, %v183
  %v195 = or i64 %v194, %v189
  %v196 = lshr i64 %v4, 32
  %v197 = lshr i64 %v3, 32
  %v198 = add nsw i32 %v6, 16
  %v199 = icmp eq i32 %v198, 32
  br i1 %v199, label %b2, label %b1

b2:                                               ; preds = %b1
  ret i64 %v195
}

attributes #0 = { nounwind readnone "target-cpu"="hexagonv60" }
