; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=newgvn < %s | FileCheck %s

define i32 addrspace(1)* @addrspacecast(i32* %ptr) {
; CHECK-LABEL: @addrspacecast(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[Z1:%.*]] = addrspacecast i32* [[PTR:%.*]] to i32 addrspace(1)*
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store i32 addrspace(1)* [[Z1]], i32 addrspace(1)** undef
; CHECK-NEXT:    ret i32 addrspace(1)* [[Z1]]
;
block1:
  %z1 = addrspacecast i32* %ptr to i32 addrspace(1)*
  br label %block2

block2:
  %z2 = addrspacecast i32* %ptr to i32 addrspace(1)*
  store i32 addrspace(1)* %z1, i32 addrspace(1)** undef
  ret i32 addrspace(1)* %z2
}

; Make sure casts with the same source value but different result
; address spaces aren't incorrectly merged.
define i32 addrspace(1)* @addrspacecast_different_result_types(i32* %ptr) {
; CHECK-LABEL: @addrspacecast_different_result_types(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[Z1:%.*]] = addrspacecast i32* [[PTR:%.*]] to i32 addrspace(2)*
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[Z2:%.*]] = addrspacecast i32* [[PTR]] to i32 addrspace(1)*
; CHECK-NEXT:    store i32 addrspace(2)* [[Z1]], i32 addrspace(2)** undef
; CHECK-NEXT:    ret i32 addrspace(1)* [[Z2]]
;
block1:
  %z1 = addrspacecast i32* %ptr to i32 addrspace(2)*
  br label %block2

block2:
  %z2 = addrspacecast i32* %ptr to i32 addrspace(1)*
  store i32 addrspace(2)* %z1, i32 addrspace(2)** undef
  ret i32 addrspace(1)* %z2
}

define i32 addrspace(1)* @addrspacecast_simplify(i32 addrspace(1)* %ptr) {
; CHECK-LABEL: @addrspacecast_simplify(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[CAST0:%.*]] = addrspacecast i32 addrspace(1)* [[PTR:%.*]] to i32*
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store i32 addrspace(1)* [[PTR]], i32 addrspace(1)** undef
; CHECK-NEXT:    ret i32 addrspace(1)* [[PTR]]
;
block1:
  %cast0 = addrspacecast i32 addrspace(1)* %ptr to i32*
  %z1 = addrspacecast i32* %cast0 to i32 addrspace(1)*
  br label %block2

block2:
  %z2 = addrspacecast i32* %cast0 to i32 addrspace(1)*
  store i32 addrspace(1)* %z1, i32 addrspace(1)** undef
  ret i32 addrspace(1)* %z2
}

@h = common local_unnamed_addr global i32* null, align 4

define i32 addrspace(1)* @addrspacecast_constant() {
; CHECK-LABEL: @addrspacecast_constant(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    store i32* undef, i32** @h, align 4
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store i32 addrspace(1)* undef, i32 addrspace(1)** undef
; CHECK-NEXT:    ret i32 addrspace(1)* undef
;
block1:
  store i32* undef, i32** @h, align 4
  %ptr = load i32*, i32** @h, align 4
  %z1 = addrspacecast i32* %ptr to i32 addrspace(1)*
  br label %block2

block2:
  %z2 = addrspacecast i32* %ptr to i32 addrspace(1)*
  store i32 addrspace(1)* %z1, i32 addrspace(1)** undef
  ret i32 addrspace(1)* %z2
}

define i32 addrspace(1)* @addrspacecast_leader(i32** %arg.ptr) {
; CHECK-LABEL: @addrspacecast_leader(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[LOAD0:%.*]] = load i32*, i32** [[ARG_PTR:%.*]]
; CHECK-NEXT:    [[Z1:%.*]] = addrspacecast i32* [[LOAD0]] to i32 addrspace(1)*
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store i32 addrspace(1)* [[Z1]], i32 addrspace(1)** undef
; CHECK-NEXT:    ret i32 addrspace(1)* [[Z1]]
;
block1:
  %load0 = load i32*, i32** %arg.ptr
  %z1 = addrspacecast i32* %load0 to i32 addrspace(1)*
  br label %block2

block2:
  %load1 = load i32*, i32** %arg.ptr
  %z2 = addrspacecast i32* %load1 to i32 addrspace(1)*
  store i32 addrspace(1)* %z1, i32 addrspace(1)** undef
  ret i32 addrspace(1)* %z2
}
