%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
  lsrtags = "specific-notation, text"

  texidoc = "
This snippet lets you draw a QR-code, for example to provide a link to
the composer's, or the music editor's website. Actually encoding the
URL into a QR-code is not done here (this just draws the QR-code from a
grid of \"black\" or \"white\" values), but see the code for a short Python
snippet you can use to avoid having to fill for each small square if
it's black or white.
"

  doctitle = "Adding a QR code"
} % begin verbatim


%% Original thread: https://lists.gnu.org/archive/html/lilypond-user-fr/2022-07/msg00005.html
%% (snippet author: Jean Abou Samra <jean@abou-samra.fr>)

\paper { tagline = ##f }

#(define (index-map f . lsts)
"Applies @code{f} to corresponding elements of @code{lists}, just as @code{map},
providing an additional counter starting at zero.  @code{f} needs to have the
counter in its arguments like @code{(index-map (lambda (i arg) <body>) lists)}"
   (let loop ((lsts lsts)
              (acc '())
              (i 0))
     (if (any null? lsts)
         (reverse! acc)
         (loop (map cdr lsts)
               (cons (apply f i (map car lsts))
                     acc)
               (1+ i)))))

#(define-markup-command (qr-code layout props data) (string?)
   #:properties ((width 10))
   (let* (;; Return lines in reversed order, since translating in Y-axis
          ;; uses increasing values. Meaning lines will be stacked upwards.
          (lines (reverse
                   (remove
                     string-null?
                     (map string-trim-both (string-split data #\newline)))))
          (n (length lines))
          (square-width (/ width n))
          (box (make-filled-box-stencil `(0 . ,square-width)
                                        `(0 . ,square-width))))

     ;; Build the final qr-code-stencil from line-stencils list
     (apply ly:stencil-add
            ;; Get a list of line-stencils
            (index-map
             (lambda (i line)
               ;; Build a line-stencil from square-stencils list
               (apply ly:stencil-add
                      ;; Get a list of (already translated) square-stencils
                      ;; per line
                      (index-map
                       (lambda (j char)
                         (ly:stencil-translate
                          (stencil-with-color
                           box
                           (case char
                            ((#\0)
                             white)
                            ((#\1)
                             black)
                            (else
                             (ly:warning
                               "unrecognized character ~a, should be 0 or 1"
                               char)
                             red)))
                          (cons (* j square-width)
                                (* i square-width))))
                      (string->list line))))
             lines))))


%{
A string representation of the QR code.  0 means white, 1 means black.
You can generate this automatically using Python and the pyqrcode module
("pip install pyqrcode").  Use this line of code in a Python prompt:

>>> import pyqrcode; print(pyqrcode.create("https://lilypond.org").text(quiet_zone=0))
%}

lilypondDotOrg =
"11111110011100011110101111111
10000010010000010111101000001
10111010010110001000101011101
10111010001010111101001011101
10111010110100000111001011101
10000010011100011001101000001
11111110101010101010101111111
00000000111000111110100000000
00110011101100001000111010000
10101001111000001000001111101
00110111010100000110001011010
01010001100110010111000110001
01111011110010011110010100111
01111101001101010001001101101
01111011000001000011001111011
11001001001011001000111011010
11100110111011011001110111000
00001100010001001011100100100
10111111011001010011001000100
00001100001000101011011011100
01010010000011000000111111111
00000000110011100010100011001
11111110101001101011101010110
10000010000110111110100010011
10111010011010111100111111111
10111010110001101111000011110
10111010100101101010100101001
10000010001001000100000010010
11111110010100110010111100010"

\markup \qr-code \lilypondDotOrg

\markup \vspace #5

\markup \override #'(width . 15) \qr-code \lilypondDotOrg
