/*
  ==============================================================================

   This file is part of the JUCE framework.
   Copyright (c) Raw Material Software Limited

   JUCE is an open source framework subject to commercial or open source
   licensing.

   By downloading, installing, or using the JUCE framework, or combining the
   JUCE framework with any other source code, object code, content or any other
   copyrightable work, you agree to the terms of the JUCE End User Licence
   Agreement, and all incorporated terms including the JUCE Privacy Policy and
   the JUCE Website Terms of Service, as applicable, which will bind you. If you
   do not agree to the terms of these agreements, we will not license the JUCE
   framework to you, and you must discontinue the installation or download
   process and cease use of the JUCE framework.

   JUCE End User Licence Agreement: https://juce.com/legal/juce-8-licence/
   JUCE Privacy Policy: https://juce.com/juce-privacy-policy
   JUCE Website Terms of Service: https://juce.com/juce-website-terms-of-service/

   Or:

   You may also use this code under the terms of the AGPLv3:
   https://www.gnu.org/licenses/agpl-3.0.en.html

   THE JUCE FRAMEWORK IS PROVIDED "AS IS" WITHOUT ANY WARRANTY, AND ALL
   WARRANTIES, WHETHER EXPRESSED OR IMPLIED, INCLUDING WARRANTY OF
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED.

  ==============================================================================
*/

namespace juce
{

// This byte-code is generated from native/java/app/com/rmsl/juce/JuceWebViewClasses.java with min sdk version 23.
// See juce_core/native/java/README.txt on how to generate this byte-code.
static const uint8 juceWebViewClasses[] =
{
    0x1f, 0x8b, 0x08, 0x08, 0x96, 0xd6, 0x11, 0x65, 0x00, 0x03, 0x63, 0x6c,
    0x61, 0x73, 0x73, 0x65, 0x73, 0x2e, 0x64, 0x65, 0x78, 0x00, 0x95, 0x59,
    0x6b, 0x6c, 0x1c, 0x57, 0x15, 0x3e, 0x33, 0xb3, 0x0f, 0xbf, 0xf6, 0x6d,
    0x7b, 0xd7, 0x8f, 0x38, 0x9b, 0xb5, 0xdb, 0x3c, 0x1a, 0x67, 0x6d, 0x27,
    0x4e, 0xec, 0x38, 0xa4, 0x8e, 0x1d, 0x87, 0xc4, 0xac, 0xdb, 0x26, 0xb6,
    0x37, 0xd4, 0x09, 0x4d, 0xc7, 0xbb, 0x13, 0xef, 0x26, 0xeb, 0x99, 0x65,
    0x67, 0xd6, 0x09, 0x54, 0x04, 0x53, 0x82, 0x14, 0xa9, 0x0f, 0x55, 0xe2,
    0x55, 0x21, 0x28, 0x41, 0x0a, 0x52, 0xa9, 0x5a, 0x29, 0x3f, 0x4a, 0x55,
    0x5a, 0x7e, 0x14, 0xd4, 0x1f, 0x15, 0x14, 0x10, 0x10, 0xa9, 0x95, 0xa8,
    0xa0, 0x88, 0xa2, 0x46, 0xa8, 0x48, 0xfc, 0x00, 0x29, 0x42, 0x88, 0xf2,
    0xdd, 0x3b, 0x77, 0xd6, 0xe3, 0x8d, 0x4b, 0xda, 0xb5, 0xbf, 0x3d, 0xe7,
    0x9e, 0x73, 0xee, 0xbd, 0xe7, 0x9e, 0x7b, 0xee, 0x99, 0x99, 0x9d, 0xbc,
    0x76, 0xb1, 0x69, 0x60, 0xf7, 0x30, 0xfd, 0xbc, 0xfa, 0xb5, 0x0f, 0x7f,
    0x7c, 0xf3, 0xbf, 0x7f, 0x3c, 0x39, 0xf6, 0x98, 0xfc, 0xbd, 0x6b, 0x37,
    0xae, 0xdf, 0xd4, 0x27, 0x2e, 0x3e, 0xba, 0x2d, 0x9e, 0x6b, 0xe9, 0x24,
    0x2a, 0x13, 0xd1, 0xc5, 0xec, 0x9e, 0x28, 0x89, 0xcf, 0x5c, 0x07, 0x91,
    0x41, 0xb6, 0x7c, 0x33, 0xb0, 0x53, 0x26, 0xba, 0x1b, 0xf4, 0x59, 0xd0,
    0x66, 0x26, 0xf7, 0x10, 0x8d, 0x81, 0xbe, 0x01, 0xea, 0x07, 0xbd, 0xea,
    0x23, 0x7a, 0x1c, 0xbd, 0x57, 0xd1, 0x18, 0x08, 0x12, 0x0d, 0x01, 0xfb,
    0x80, 0x7b, 0x81, 0x49, 0xe0, 0x38, 0xf0, 0x20, 0x70, 0x1a, 0x78, 0x18,
    0x58, 0x06, 0xca, 0x40, 0x15, 0x78, 0x04, 0xf8, 0x32, 0x70, 0x19, 0xf8,
    0x3e, 0xf0, 0x0a, 0xf0, 0x2b, 0xe0, 0x6f, 0x00, 0x85, 0x30, 0x2f, 0x70,
    0x14, 0x28, 0x00, 0x57, 0x80, 0xe7, 0x80, 0xdf, 0x00, 0xff, 0x02, 0x62,
    0x61, 0xa2, 0x7e, 0x60, 0x06, 0xb8, 0x04, 0xfc, 0x08, 0xf8, 0x03, 0xd0,
    0x1c, 0xc1, 0xdc, 0x80, 0x09, 0x7c, 0x1b, 0x78, 0x15, 0x78, 0x17, 0x20,
    0xf8, 0xd8, 0x0b, 0x4c, 0x00, 0x59, 0xe0, 0x1c, 0xf0, 0x08, 0x70, 0x09,
    0x78, 0x14, 0xb8, 0x02, 0x3c, 0x01, 0x7c, 0x1d, 0xf8, 0x0e, 0xf0, 0x0c,
    0xf0, 0x43, 0xe0, 0x39, 0xe0, 0x3a, 0xf0, 0x12, 0xf0, 0x0a, 0xf0, 0x4b,
    0xe0, 0xd7, 0xc0, 0xef, 0x81, 0xb7, 0x80, 0x77, 0x80, 0xbf, 0x00, 0x7f,
    0x07, 0xfe, 0x0d, 0x44, 0x63, 0x44, 0x7d, 0xc0, 0x08, 0x70, 0x04, 0x38,
    0x03, 0xac, 0x00, 0x5f, 0x05, 0x1e, 0x03, 0x5e, 0x00, 0x5e, 0x07, 0x7e,
    0x01, 0xbc, 0x05, 0xfc, 0x19, 0x78, 0x1f, 0xb8, 0x05, 0xf8, 0x5b, 0x89,
    0xe2, 0xc0, 0x56, 0x60, 0x2f, 0x70, 0x04, 0x38, 0x05, 0x18, 0xc0, 0x2a,
    0xf0, 0x04, 0xf0, 0x03, 0xe0, 0x27, 0xc0, 0x6f, 0x81, 0xf7, 0x01, 0xb9,
    0x8d, 0xa8, 0x1d, 0xd8, 0x01, 0x4c, 0x03, 0xa7, 0x01, 0x0b, 0x78, 0x12,
    0xf8, 0x16, 0x70, 0x15, 0x78, 0x01, 0x78, 0x13, 0xf8, 0x2b, 0xf0, 0x01,
    0xe0, 0x6f, 0x47, 0x2c, 0x80, 0x03, 0x40, 0x16, 0x30, 0x00, 0x6c, 0x23,
    0x89, 0xb0, 0x13, 0xc2, 0x48, 0x22, 0x64, 0x04, 0xb7, 0x08, 0xd3, 0x10,
    0xba, 0x51, 0x1c, 0x48, 0x00, 0x48, 0x11, 0x42, 0xea, 0x50, 0x17, 0xd0,
    0x0d, 0x6c, 0x02, 0x7a, 0x44, 0xbe, 0x24, 0x81, 0x2d, 0x40, 0x0a, 0xe8,
    0x05, 0xfa, 0x80, 0xbb, 0xc8, 0xce, 0xa1, 0xad, 0xc0, 0x36, 0x60, 0x3b,
    0xb0, 0x83, 0xe5, 0x16, 0x30, 0x4a, 0x76, 0x1e, 0xb1, 0xcf, 0x48, 0x80,
    0xa8, 0x11, 0x54, 0x11, 0xed, 0x66, 0x81, 0x71, 0xc8, 0x03, 0x82, 0xcf,
    0x08, 0x9b, 0x16, 0x61, 0xd3, 0x28, 0x7c, 0x60, 0x9f, 0x26, 0xc1, 0xcf,
    0x05, 0x6c, 0x7d, 0xb7, 0x18, 0x73, 0xa7, 0xf0, 0x91, 0x7d, 0xfa, 0x05,
    0x7f, 0x1a, 0xf2, 0x5d, 0x82, 0xcf, 0x83, 0x4f, 0x0b, 0xbe, 0x0c, 0x7e,
    0x50, 0xf0, 0x17, 0x5d, 0xfc, 0x65, 0xf0, 0x03, 0x82, 0x1f, 0x77, 0xd9,
    0xb3, 0xb9, 0x86, 0x04, 0xff, 0x14, 0xf8, 0xdd, 0x82, 0x7f, 0xda, 0x25,
    0xbf, 0xe6, 0xe2, 0x9f, 0x07, 0xbf, 0x57, 0xf0, 0x2f, 0xba, 0xf8, 0xd7,
    0xc0, 0xef, 0x11, 0xfc, 0x9b, 0x2e, 0xf9, 0x0d, 0x57, 0xdf, 0x77, 0xc1,
    0x0f, 0x0b, 0xfe, 0xa6, 0x4b, 0xfe, 0x4f, 0x57, 0xdf, 0xff, 0xb8, 0xe4,
    0x9e, 0xe0, 0x9a, 0xbc, 0x25, 0xb8, 0x26, 0x1f, 0x71, 0xd9, 0xb7, 0xb2,
    0xf3, 0x2a, 0xf8, 0x6e, 0xf0, 0xfb, 0xc5, 0x5e, 0xb2, 0x75, 0x1d, 0x10,
    0x7c, 0xc6, 0xc5, 0x33, 0xdf, 0x3e, 0x25, 0xf8, 0xbe, 0xa0, 0x5d, 0x0b,
    0x7a, 0xc4, 0x98, 0x21, 0x64, 0xcb, 0x7d, 0x3c, 0x7f, 0x6c, 0x1a, 0x41,
    0x06, 0xe5, 0x38, 0x8d, 0xd1, 0x59, 0x91, 0x53, 0x4b, 0x22, 0xaf, 0x26,
    0x39, 0xb5, 0xed, 0x58, 0x8e, 0x4d, 0x73, 0xda, 0x45, 0x19, 0xe6, 0x93,
    0x90, 0xb7, 0x62, 0x07, 0x35, 0x9e, 0x0f, 0x5e, 0xca, 0xf3, 0xbd, 0x6e,
    0x20, 0x99, 0xef, 0xb3, 0x44, 0x9f, 0xe6, 0x39, 0x90, 0xa4, 0x07, 0x05,
    0x5d, 0x10, 0xf4, 0x94, 0xa0, 0xa7, 0x39, 0xed, 0xa1, 0xcf, 0x11, 0xcb,
    0x9d, 0x30, 0xef, 0x17, 0x40, 0x86, 0x4e, 0x10, 0xcb, 0x73, 0x7b, 0x9c,
    0x10, 0xb2, 0xd8, 0xa6, 0x31, 0xba, 0x9f, 0xd3, 0x3e, 0x7a, 0x80, 0xfb,
    0x6f, 0xcb, 0xc3, 0xd4, 0x4e, 0xc7, 0x39, 0x8d, 0xd3, 0x09, 0x4e, 0xdb,
    0x68, 0x8e, 0xd3, 0x56, 0x9a, 0xe7, 0x54, 0x21, 0x95, 0xd3, 0x14, 0x2d,
    0x72, 0xda, 0xcb, 0x69, 0x04, 0x27, 0x44, 0xe6, 0xb4, 0x9b, 0x66, 0x39,
    0xed, 0xe1, 0x34, 0x0a, 0x4e, 0xe6, 0x74, 0x13, 0x8d, 0x73, 0xda, 0x40,
    0x87, 0x44, 0x3c, 0x26, 0x38, 0xf5, 0xd0, 0x11, 0x4e, 0xa3, 0xf4, 0x10,
    0xa7, 0x49, 0x3a, 0xc3, 0x69, 0x82, 0x1e, 0xe6, 0xf1, 0x69, 0xe4, 0xfd,
    0x63, 0x88, 0xc0, 0x61, 0x4e, 0x43, 0x74, 0x94, 0x53, 0x99, 0x8e, 0x71,
    0xda, 0x40, 0x9f, 0xe1, 0xd4, 0x5e, 0x4f, 0x4c, 0xac, 0x27, 0x26, 0xd6,
    0xc1, 0xe8, 0x09, 0x4e, 0xed, 0x75, 0xc4, 0xc4, 0x3a, 0x62, 0x38, 0xb1,
    0x59, 0x4e, 0x7d, 0x74, 0x92, 0x53, 0x3f, 0x7d, 0x96, 0x53, 0x7b, 0x7d,
    0x31, 0x9c, 0xe0, 0x45, 0x4e, 0x9b, 0xa9, 0x28, 0xe8, 0x39, 0x4e, 0x83,
    0x74, 0x9e, 0xd3, 0x00, 0x95, 0x38, 0x6d, 0xa1, 0x65, 0xbe, 0x6f, 0x5d,
    0xdc, 0xcf, 0x56, 0xec, 0xdb, 0x14, 0xa7, 0x7e, 0x3e, 0x6e, 0x9b, 0x88,
    0x7b, 0x57, 0x2d, 0xfe, 0x84, 0x9d, 0xb4, 0xcf, 0x30, 0xfb, 0x7c, 0x88,
    0xcf, 0x9b, 0x28, 0x30, 0x5f, 0x8c, 0xdb, 0xed, 0xb0, 0xd0, 0x07, 0x5d,
    0xfa, 0x77, 0xa0, 0x7f, 0x52, 0xe8, 0x23, 0x42, 0xce, 0xea, 0xd0, 0x40,
    0xc0, 0xd6, 0x7f, 0x00, 0xfd, 0x4b, 0x42, 0x1f, 0x15, 0xfd, 0x03, 0xae,
    0xfe, 0x1e, 0x14, 0xaf, 0xdf, 0x09, 0x7d, 0x4c, 0xe8, 0xbb, 0x5c, 0xfa,
    0x56, 0xe8, 0x6f, 0x0a, 0x7d, 0xeb, 0x06, 0xfa, 0x3e, 0xe8, 0x8f, 0x24,
    0xec, 0x76, 0xdb, 0x06, 0xfa, 0xc3, 0xd0, 0x9f, 0x16, 0x7a, 0x1f, 0xd6,
    0xef, 0x15, 0x3a, 0x56, 0xe3, 0xe6, 0xb0, 0x20, 0x7d, 0x7e, 0x2b, 0x25,
    0x27, 0x9b, 0xe4, 0x10, 0x02, 0x20, 0xe3, 0x4f, 0x22, 0xc7, 0x16, 0xb5,
    0x27, 0xcc, 0x5a, 0xa7, 0x24, 0xb6, 0x62, 0x85, 0x6b, 0xd7, 0x74, 0xbc,
    0x6f, 0xf2, 0x6e, 0x64, 0x44, 0x10, 0x59, 0xa2, 0xd4, 0x6a, 0xa4, 0x3d,
    0xae, 0x44, 0xfa, 0x40, 0x9a, 0x92, 0x4a, 0x8b, 0x1c, 0x91, 0x89, 0x6b,
    0x9d, 0xbe, 0x2c, 0xc6, 0x73, 0x92, 0x44, 0x95, 0x30, 0x1b, 0xaf, 0x45,
    0xd6, 0xc3, 0x64, 0xd3, 0xe4, 0x00, 0x76, 0xbd, 0x49, 0x0a, 0x49, 0xeb,
    0xed, 0xfd, 0xc2, 0xde, 0xad, 0xbf, 0xdd, 0xcf, 0x26, 0xee, 0xa7, 0x54,
    0xe7, 0x8b, 0xaf, 0xe6, 0xcb, 0x36, 0xf8, 0xc2, 0x74, 0x9e, 0xf5, 0x3a,
    0x85, 0xe9, 0xb6, 0x53, 0x4c, 0x0e, 0x22, 0x2e, 0x4c, 0x5b, 0xd7, 0x6f,
    0x7c, 0x07, 0x62, 0xf3, 0x51, 0xba, 0x7b, 0x84, 0xce, 0x5b, 0xf3, 0xc5,
    0xf6, 0x42, 0xa6, 0x53, 0xb2, 0x42, 0x0b, 0x8a, 0x07, 0x7e, 0xb1, 0xea,
    0x15, 0xe4, 0xfe, 0xba, 0x63, 0xb7, 0x59, 0xea, 0xc6, 0x7a, 0x12, 0xc8,
    0x27, 0xd6, 0x5f, 0xae, 0x8d, 0xdd, 0xc0, 0xc6, 0x1e, 0x50, 0x68, 0x76,
    0xd0, 0x83, 0xf1, 0x7b, 0x29, 0x3c, 0x11, 0x84, 0xbd, 0x5c, 0xdb, 0x33,
    0x96, 0x3f, 0xb3, 0xe3, 0x5e, 0x6a, 0x97, 0x25, 0x7a, 0x55, 0x5e, 0x98,
    0xf0, 0xd2, 0xdc, 0x84, 0x8f, 0x52, 0x4a, 0x84, 0xca, 0xc7, 0xdb, 0x69,
    0x52, 0x36, 0x06, 0x1a, 0xb1, 0xa6, 0x30, 0xc6, 0xf1, 0xd5, 0xd6, 0xc9,
    0xea, 0x52, 0x39, 0xd9, 0x80, 0x5a, 0x8b, 0x8b, 0x2a, 0x2d, 0x24, 0xbd,
    0xb0, 0x8f, 0x51, 0x79, 0x60, 0x0b, 0x4d, 0x7a, 0x4f, 0xf5, 0xfa, 0x48,
    0x0f, 0x6f, 0x62, 0xf1, 0x57, 0xa2, 0xad, 0x3a, 0x74, 0x93, 0xf0, 0x4b,
    0xc1, 0x77, 0xd4, 0xab, 0x27, 0x3d, 0xa8, 0x11, 0x7a, 0xd2, 0xc7, 0x65,
    0x7e, 0xd4, 0xcd, 0x94, 0x12, 0xa2, 0xb9, 0xbb, 0x7c, 0x18, 0xad, 0x99,
    0x6b, 0x7a, 0x30, 0xe6, 0xe7, 0xc3, 0x9b, 0xe1, 0x7d, 0x0a, 0x73, 0xce,
    0xf5, 0x31, 0x4d, 0x90, 0x5b, 0x27, 0xa1, 0x49, 0x29, 0xad, 0xb6, 0x6c,
    0x60, 0x2f, 0x4d, 0xfa, 0x3b, 0x3d, 0x07, 0x11, 0xe9, 0x4e, 0x1a, 0x62,
    0x97, 0x00, 0xbe, 0x7b, 0xee, 0xfd, 0x9b, 0x0b, 0x33, 0x3f, 0xee, 0x22,
    0xbb, 0x12, 0x2a, 0xb5, 0x88, 0xb2, 0xeb, 0xf6, 0xdc, 0x03, 0x0d, 0xa8,
    0x4e, 0xb3, 0xc7, 0xfd, 0xd4, 0x8e, 0x25, 0x0d, 0x4a, 0x92, 0x32, 0x22,
    0x45, 0x79, 0x9b, 0x65, 0x90, 0x9f, 0x5a, 0xfc, 0x2c, 0x83, 0x18, 0x2d,
    0x9f, 0xec, 0xa3, 0xb6, 0xc5, 0x16, 0x5f, 0x0f, 0x45, 0x80, 0xa8, 0x2f,
    0xe2, 0x0b, 0x80, 0x6e, 0xf5, 0xd9, 0xd7, 0xef, 0x4d, 0x7c, 0xce, 0x1e,
    0x58, 0x7a, 0x6b, 0xf1, 0x66, 0xbe, 0xcc, 0xf6, 0xf9, 0x79, 0x64, 0x06,
    0x7d, 0x1e, 0xc4, 0x77, 0xd4, 0xa7, 0x20, 0x43, 0xcb, 0xe3, 0x43, 0x34,
    0x31, 0x1c, 0xe2, 0xb1, 0x77, 0x6c, 0x23, 0x3c, 0xf6, 0xb0, 0xc5, 0x46,
    0x0e, 0x62, 0x3b, 0x47, 0x65, 0xd8, 0x7b, 0x43, 0xde, 0xf2, 0xf8, 0x4e,
    0xf2, 0x1c, 0x6f, 0xf2, 0xfe, 0xc9, 0xeb, 0x95, 0x42, 0x5e, 0xe6, 0x09,
    0xeb, 0x63, 0xef, 0x76, 0xcf, 0xed, 0xfe, 0x2b, 0xf0, 0x1f, 0x99, 0x58,
    0x1e, 0xef, 0xe7, 0xbe, 0x8e, 0xfa, 0x7c, 0xd4, 0xe9, 0x63, 0x96, 0x11,
    0xe1, 0x37, 0x6b, 0x39, 0x9e, 0x33, 0xbf, 0xdb, 0xe0, 0x35, 0xbb, 0x6f,
    0x90, 0xf8, 0x5f, 0x17, 0xcf, 0x60, 0x27, 0x76, 0x01, 0x9e, 0xfb, 0xfb,
    0xd1, 0x4e, 0x41, 0x63, 0x67, 0xdb, 0xa9, 0x70, 0x03, 0x2d, 0x44, 0xfd,
    0x7c, 0x6d, 0x4d, 0xb0, 0xf6, 0x09, 0x5b, 0x56, 0xbb, 0x66, 0x55, 0xe1,
    0x05, 0x49, 0xca, 0x28, 0xc6, 0x09, 0x92, 0xff, 0x61, 0x8f, 0xe9, 0xff,
    0xe6, 0x8a, 0x2f, 0xc5, 0xa3, 0xe1, 0xe1, 0x23, 0xdb, 0xa3, 0xb7, 0xf0,
    0x5c, 0x64, 0xbe, 0xb7, 0x43, 0xb0, 0x30, 0xe8, 0x87, 0x8f, 0x41, 0x0a,
    0x48, 0xf0, 0x4b, 0xf2, 0xf2, 0x7d, 0x63, 0xfe, 0x34, 0xae, 0x8b, 0x51,
    0xe0, 0xb6, 0x18, 0xb1, 0x39, 0xca, 0xe3, 0x83, 0x88, 0x50, 0x90, 0x9f,
    0x65, 0xa5, 0x96, 0xcb, 0x1f, 0x61, 0x9b, 0xdd, 0xfd, 0x09, 0x6c, 0xfb,
    0x84, 0xad, 0x7b, 0x9d, 0x91, 0x8f, 0x58, 0xa7, 0xdf, 0xf4, 0x5f, 0x66,
    0x2b, 0xdd, 0x23, 0xf6, 0xfd, 0x93, 0xf4, 0x19, 0x16, 0x7d, 0xd6, 0xaa,
    0x8e, 0x9d, 0x53, 0x73, 0xa8, 0x3b, 0x11, 0xce, 0xcb, 0xeb, 0xeb, 0x55,
    0xb8, 0x11, 0xa7, 0x60, 0x17, 0x6a, 0xe3, 0x5a, 0xfd, 0x73, 0x7a, 0x36,
    0x88, 0x3d, 0x63, 0x95, 0xa2, 0x11, 0x95, 0xa2, 0x09, 0x23, 0x4b, 0xae,
    0xf3, 0xe0, 0xa9, 0xe9, 0x83, 0x5c, 0xd6, 0x20, 0x76, 0xa4, 0x9b, 0x9c,
    0xfb, 0xd0, 0x00, 0xe7, 0xed, 0xfb, 0x87, 0x26, 0x31, 0x6f, 0x77, 0xad,
    0xbf, 0x73, 0xee, 0x1d, 0x1b, 0x66, 0xe5, 0x11, 0xd4, 0x5f, 0xab, 0x63,
    0xac, 0x67, 0x73, 0x6d, 0xb7, 0x3d, 0xb5, 0x39, 0xba, 0x6b, 0xd7, 0x3f,
    0xe7, 0x3a, 0xa5, 0xd4, 0x7a, 0x3a, 0x7c, 0x13, 0xbf, 0xef, 0x95, 0x85,
    0x27, 0x8a, 0xa0, 0x32, 0xad, 0x5d, 0x1b, 0x99, 0x2c, 0xca, 0xaf, 0x66,
    0xb6, 0x2c, 0x26, 0xec, 0x63, 0x62, 0xfc, 0x2e, 0xd1, 0xee, 0x12, 0xfd,
    0xba, 0xb1, 0x4a, 0x26, 0xef, 0x11, 0xbe, 0x04, 0xc0, 0xf5, 0xf0, 0xdd,
    0x57, 0xb6, 0x6d, 0xcf, 0x92, 0xef, 0x40, 0x51, 0x2f, 0x5a, 0x07, 0x49,
    0x3e, 0x38, 0x46, 0x2d, 0x93, 0x85, 0x8a, 0xb1, 0xac, 0x4d, 0x96, 0x8a,
    0x9a, 0x6e, 0x91, 0x4f, 0x50, 0x69, 0x9a, 0xe4, 0xe9, 0x0c, 0x35, 0x4f,
    0x57, 0x73, 0xda, 0x49, 0x6d, 0x31, 0x5b, 0xd4, 0x2e, 0x90, 0x94, 0x21,
    0x25, 0x03, 0xa1, 0x07, 0x5f, 0x19, 0x92, 0x33, 0xac, 0x89, 0xaf, 0x8e,
    0x8c, 0xaa, 0xe7, 0x2b, 0x46, 0x31, 0x9f, 0xce, 0x19, 0xba, 0x85, 0xce,
    0xe9, 0x49, 0x46, 0x2f, 0x5a, 0x63, 0x2e, 0xd5, 0x52, 0x45, 0x2d, 0x17,
    0x8a, 0x39, 0x33, 0x3d, 0x51, 0xb4, 0x96, 0xd5, 0xf2, 0x18, 0x45, 0x6a,
    0x2a, 0x5d, 0xb3, 0xd2, 0xf3, 0x95, 0xe2, 0x18, 0x75, 0xad, 0x13, 0x15,
    0x2c, 0xab, 0x9c, 0x9e, 0x35, 0x4b, 0x53, 0x95, 0x8a, 0x51, 0x19, 0xa3,
    0xd6, 0x9a, 0xd2, 0x30, 0xd3, 0x33, 0x9a, 0x69, 0xaa, 0x4b, 0xda, 0x18,
    0xf5, 0xd5, 0xa4, 0x17, 0xb4, 0xc5, 0xf3, 0x45, 0x2b, 0x3d, 0xad, 0xae,
    0xa8, 0x66, 0xae, 0x52, 0x2c, 0x5b, 0xc7, 0xe0, 0x43, 0xe5, 0xac, 0x9a,
    0x83, 0x55, 0xb2, 0xde, 0xca, 0x19, 0xf6, 0x28, 0xe4, 0x25, 0x0d, 0xa3,
    0xf7, 0xd4, 0x5b, 0x64, 0xd5, 0x52, 0x55, 0x9b, 0x54, 0x4b, 0xa5, 0x45,
    0x35, 0x77, 0xfe, 0x4e, 0xfa, 0x03, 0xb7, 0xcf, 0x80, 0x98, 0xb9, 0xe3,
    0x3a, 0x46, 0xbd, 0x1b, 0x58, 0x9c, 0xd0, 0x4c, 0xa3, 0x5a, 0xc9, 0x69,
    0x27, 0xb4, 0xcf, 0x57, 0x35, 0xd3, 0xda, 0x60, 0x39, 0xeb, 0x8c, 0xcc,
    0xb2, 0xa1, 0x9b, 0x58, 0x4e, 0xf7, 0x06, 0x56, 0xb3, 0x9a, 0x65, 0x15,
    0xf5, 0x25, 0x73, 0x8c, 0x12, 0x1b, 0x68, 0xd9, 0xf6, 0x6d, 0xb0, 0x08,
    0xa1, 0x71, 0x5c, 0x4c, 0x67, 0x72, 0xc6, 0x72, 0xba, 0xb2, 0x6c, 0x96,
    0xd2, 0xe7, 0xb0, 0xed, 0x69, 0xd7, 0xde, 0x4f, 0x96, 0x54, 0xd3, 0xd4,
    0xcc, 0xbe, 0xf5, 0x6b, 0xda, 0xfe, 0x31, 0x3a, 0x08, 0xd3, 0x81, 0x3b,
    0x9b, 0xba, 0x44, 0x7d, 0x83, 0x63, 0xb4, 0xeb, 0x13, 0xf5, 0x18, 0xa3,
    0xa1, 0x3b, 0xdb, 0xdf, 0xa7, 0x5a, 0xc5, 0x15, 0xcd, 0x95, 0x18, 0x1f,
    0xa3, 0x0f, 0x9a, 0x87, 0xca, 0x65, 0x57, 0x9f, 0xd4, 0x1d, 0xfb, 0x30,
    0x9b, 0xbc, 0x5a, 0x5a, 0x29, 0x9e, 0x4f, 0xab, 0xba, 0x6e, 0x58, 0x98,
    0xd5, 0xd0, 0xd3, 0x53, 0x7a, 0xae, 0x64, 0x98, 0xd8, 0x23, 0x6e, 0xc5,
    0x12, 0xe2, 0xff, 0xd8, 0xcc, 0x68, 0x56, 0xc1, 0xc8, 0xb3, 0x2d, 0xbb,
    0xdd, 0xe8, 0x98, 0xae, 0x6b, 0x15, 0x31, 0xc8, 0x96, 0x0d, 0xf4, 0x33,
    0xda, 0xf2, 0xa2, 0x30, 0x60, 0xbe, 0x6c, 0xda, 0xc0, 0x64, 0xb6, 0xb8,
    0xa4, 0xab, 0x56, 0xb5, 0x82, 0xe5, 0x44, 0x33, 0xe7, 0x70, 0x64, 0xd2,
    0x25, 0x55, 0x5f, 0x4a, 0xdf, 0xbf, 0x78, 0x4e, 0xcb, 0x59, 0xeb, 0x65,
    0xb3, 0x56, 0x05, 0xfe, 0x8c, 0x51, 0xa8, 0x2e, 0x78, 0x24, 0x65, 0x49,
    0xce, 0x4e, 0x93, 0x27, 0x3b, 0x8d, 0x92, 0xa0, 0x64, 0x59, 0x5d, 0xc8,
    0xb2, 0xba, 0xe0, 0x65, 0xdf, 0x28, 0x0f, 0x59, 0xc6, 0xf2, 0x4a, 0xa1,
    0x64, 0x33, 0x4c, 0x99, 0xc9, 0x4c, 0xf3, 0x6f, 0xa6, 0x5b, 0xa0, 0x50,
    0x5d, 0x60, 0x49, 0x5a, 0x20, 0x65, 0x01, 0xa3, 0xc8, 0x0b, 0xe8, 0xb1,
    0xc0, 0x06, 0x5a, 0xc8, 0x2c, 0x80, 0x6f, 0x38, 0x73, 0x66, 0x7a, 0x7e,
    0x72, 0xea, 0xcc, 0x19, 0x6a, 0x56, 0x73, 0x39, 0x1c, 0xfc, 0x23, 0x25,
    0x75, 0xc9, 0xa4, 0x76, 0x35, 0x9f, 0xdf, 0xe0, 0xb0, 0x53, 0x38, 0x5f,
    0x34, 0x51, 0x87, 0x74, 0x2c, 0xc4, 0xf6, 0x98, 0xa2, 0xda, 0x0a, 0x0e,
    0xab, 0x6a, 0x69, 0x6b, 0xe6, 0xd4, 0x22, 0x64, 0x08, 0xc6, 0xb1, 0x3c,
    0xc5, 0xd7, 0x5a, 0x38, 0x65, 0xd5, 0x92, 0x25, 0xea, 0x02, 0xb5, 0x2d,
    0x69, 0xd6, 0x21, 0xfb, 0xcc, 0xcc, 0x9b, 0x5a, 0x65, 0x96, 0x77, 0x36,
    0xa9, 0x19, 0x62, 0xe7, 0xc0, 0x91, 0x0f, 0x8d, 0xf9, 0x4a, 0x89, 0x92,
    0x05, 0xde, 0x69, 0x6d, 0x92, 0xa9, 0xba, 0x41, 0xa9, 0xcd, 0xb6, 0xa8,
    0x3b, 0xf5, 0xe4, 0x29, 0x18, 0xf8, 0x6e, 0x66, 0xdf, 0x87, 0xb5, 0x92,
    0x66, 0x69, 0x79, 0x6a, 0x60, 0x8d, 0x8c, 0x91, 0x3b, 0x4f, 0x1e, 0x5d,
    0x5d, 0xd6, 0x28, 0xa4, 0xd7, 0x05, 0x3f, 0x60, 0xe8, 0x93, 0xc8, 0x14,
    0xed, 0x64, 0x51, 0xcf, 0x1b, 0x17, 0x28, 0x88, 0x66, 0x45, 0xc3, 0x12,
    0xd7, 0xda, 0x0f, 0xa0, 0x3e, 0x1e, 0x41, 0x95, 0x37, 0x0b, 0x18, 0x2f,
    0x60, 0xb7, 0x67, 0x2d, 0xb5, 0xc2, 0x86, 0x0f, 0x32, 0x97, 0x72, 0x1a,
    0x46, 0xe4, 0x65, 0x8c, 0x62, 0xb5, 0x76, 0xfe, 0x28, 0xaa, 0x2e, 0x2f,
    0x8d, 0x14, 0x5d, 0x13, 0x3a, 0xe5, 0x92, 0x42, 0x65, 0x8c, 0x72, 0x68,
    0xd1, 0xa8, 0x5a, 0x73, 0x46, 0xc6, 0x50, 0xf3, 0xd4, 0x5c, 0x86, 0xa3,
    0xa2, 0x1a, 0x53, 0xd4, 0xd5, 0x70, 0x22, 0xd8, 0x6e, 0x6a, 0xd6, 0x44,
    0xb5, 0x58, 0xc2, 0x0e, 0x2d, 0x18, 0xc6, 0x32, 0xbb, 0x32, 0x54, 0x8c,
    0x92, 0xc9, 0xe5, 0x87, 0x8b, 0x66, 0xb9, 0xa4, 0x7e, 0x61, 0x9d, 0xbc,
    0x15, 0x72, 0x16, 0x42, 0x3b, 0xd4, 0x53, 0xba, 0xba, 0x58, 0x82, 0xc3,
    0x1d, 0x90, 0xce, 0x56, 0xcb, 0x65, 0xa3, 0x62, 0xcd, 0x20, 0x92, 0xc5,
    0x72, 0x49, 0xac, 0xd4, 0xa4, 0x28, 0x54, 0x6c, 0x6f, 0x0e, 0x2d, 0xa1,
    0xce, 0xd8, 0xc9, 0xca, 0x65, 0x75, 0x05, 0x98, 0x7a, 0x84, 0xcc, 0xbe,
    0x44, 0x99, 0x87, 0xb5, 0xc5, 0xea, 0xd2, 0x12, 0x8c, 0x9d, 0x29, 0xc2,
    0xb6, 0x7e, 0xad, 0x1e, 0xc2, 0xc5, 0x82, 0x51, 0x2d, 0xe5, 0x79, 0xd0,
    0x73, 0x5a, 0xd9, 0x72, 0xf6, 0x2b, 0x61, 0xcb, 0xef, 0x5f, 0xd1, 0x2a,
    0x95, 0x62, 0x5e, 0xc3, 0xde, 0xb3, 0x50, 0xb0, 0x79, 0x7d, 0x56, 0xa1,
    0x68, 0xf6, 0x0d, 0x50, 0x83, 0x65, 0x08, 0x4f, 0x9a, 0xab, 0xae, 0xb4,
    0xd9, 0x84, 0x84, 0xe8, 0xb3, 0x73, 0xb8, 0x88, 0x39, 0xeb, 0x0f, 0x54,
    0x9c, 0xa9, 0x73, 0xd5, 0x4a, 0x05, 0x93, 0x4f, 0xb9, 0xd3, 0xd3, 0xbb,
    0xc2, 0x77, 0xa9, 0xe3, 0x82, 0xe3, 0x5e, 0x6d, 0xe3, 0x1d, 0x97, 0x3a,
    0x1d, 0x95, 0x2b, 0x09, 0x1c, 0x5d, 0x5c, 0xe8, 0x58, 0x02, 0x30, 0x47,
    0x6b, 0x49, 0x91, 0x10, 0x8a, 0xdb, 0xb7, 0x3e, 0x5e, 0xa7, 0xa9, 0xed,
    0xff, 0x33, 0xd2, 0xa5, 0x4b, 0x87, 0x47, 0x1e, 0x49, 0xb1, 0x8b, 0x9e,
    0xa6, 0xe7, 0x53, 0xfb, 0x53, 0x79, 0xed, 0x62, 0x6a, 0x67, 0x0a, 0x15,
    0xb1, 0x5c, 0x2c, 0x71, 0x7f, 0xfb, 0x97, 0x8d, 0xbc, 0x06, 0x45, 0x05,
    0xa9, 0xac, 0x9a, 0x1a, 0x94, 0x05, 0xd5, 0xec, 0xcf, 0x15, 0xb4, 0xdc,
    0x79, 0xb3, 0xba, 0x6c, 0xa6, 0xf6, 0x9f, 0x55, 0x4b, 0xa6, 0xb6, 0x33,
    0xb5, 0x5c, 0xd4, 0xfb, 0xd5, 0x72, 0x31, 0xb5, 0x7f, 0x68, 0xf7, 0xce,
    0x94, 0x59, 0x50, 0xfb, 0x07, 0xd1, 0x89, 0xc5, 0x21, 0x7f, 0x76, 0xcf,
    0xe0, 0xe2, 0x62, 0x7e, 0x68, 0x64, 0x71, 0x78, 0xef, 0xee, 0xfc, 0xa0,
    0x36, 0xaa, 0x0d, 0x8c, 0xe6, 0x86, 0xcf, 0xee, 0x1b, 0xca, 0xef, 0xcb,
    0x0d, 0xe7, 0xd4, 0xe1, 0xd1, 0x91, 0xfc, 0x30, 0x46, 0x45, 0xf4, 0x4d,
    0x4c, 0x87, 0x4e, 0x23, 0xbb, 0x86, 0x76, 0x0d, 0xf5, 0xe7, 0xb5, 0x95,
    0xd4, 0x97, 0x48, 0x6e, 0x97, 0x0a, 0x89, 0x36, 0x39, 0x21, 0xdf, 0xeb,
    0x69, 0x9c, 0x89, 0x7b, 0x1c, 0xc6, 0x2b, 0x77, 0x4a, 0x85, 0x6e, 0x29,
    0x2e, 0xc9, 0x71, 0xa9, 0xd0, 0xd9, 0xcd, 0xc5, 0x34, 0xd3, 0xc3, 0xa5,
    0x9e, 0xf8, 0xf6, 0x78, 0x7b, 0x7c, 0x47, 0x5c, 0x71, 0x8c, 0x1b, 0x1c,
    0xe6, 0x1e, 0x09, 0xb7, 0xe2, 0x82, 0x1f, 0x91, 0x3b, 0x60, 0xeb, 0x4d,
    0x44, 0x13, 0xad, 0x89, 0x50, 0x22, 0x9c, 0x88, 0x91, 0x84, 0xc7, 0x52,
    0xb9, 0xf9, 0x2b, 0xab, 0x9e, 0xab, 0xa1, 0x16, 0xe9, 0xa7, 0x21, 0x49,
    0x5a, 0x0d, 0x41, 0xe6, 0x97, 0xe4, 0x20, 0x64, 0x6f, 0x84, 0x43, 0xd2,
    0x7b, 0x61, 0xc8, 0x22, 0x92, 0xf4, 0x5d, 0xe0, 0x65, 0xe0, 0x6d, 0xd8,
    0xdc, 0x02, 0x9e, 0x0d, 0x93, 0x22, 0xc9, 0xf2, 0x53, 0x49, 0x89, 0xff,
    0xb7, 0xaf, 0xae, 0x7a, 0x6e, 0x44, 0xe2, 0x3f, 0x4b, 0xde, 0x82, 0xcd,
    0x37, 0xa2, 0x24, 0x4b, 0xb2, 0x17, 0xe8, 0xc0, 0x28, 0x37, 0xa3, 0x5d,
    0xd2, 0x95, 0x56, 0x49, 0x7a, 0x11, 0xd2, 0xa6, 0x66, 0xbf, 0x2c, 0x45,
    0xb7, 0x40, 0xfa, 0x7a, 0xbb, 0xf4, 0x28, 0xa6, 0x06, 0x1a, 0x00, 0xc6,
    0x7b, 0x04, 0x75, 0xa3, 0x57, 0xfa, 0x07, 0x1e, 0x6a, 0xaf, 0xc6, 0x25,
    0xe9, 0x06, 0x70, 0xb9, 0x0d, 0xbe, 0x24, 0x24, 0xe9, 0x79, 0xe0, 0x6d,
    0xe0, 0xf1, 0x0e, 0x45, 0x7a, 0x0f, 0xb2, 0x6b, 0x18, 0xfd, 0x7a, 0x1b,
    0x9b, 0xb3, 0x11, 0x4f, 0xc0, 0x7b, 0x31, 0xfa, 0xad, 0x8e, 0x7d, 0xd2,
    0x6b, 0x1d, 0xb0, 0xea, 0x60, 0x77, 0x9a, 0xa3, 0x90, 0x3c, 0xdd, 0x69,
    0xdf, 0x5b, 0x86, 0xe3, 0x44, 0xed, 0xf1, 0x35, 0x7e, 0x73, 0xdc, 0xbe,
    0x17, 0xdd, 0x16, 0xb7, 0xef, 0x4f, 0x07, 0x40, 0xf7, 0x02, 0x07, 0x5d,
    0x36, 0x19, 0x17, 0x3f, 0x2f, 0xec, 0x1f, 0x72, 0xc9, 0x54, 0x21, 0x3b,
    0x07, 0x5a, 0x48, 0xd0, 0xba, 0x8f, 0x55, 0xd7, 0xbe, 0x22, 0xda, 0xce,
    0x7d, 0x39, 0x7b, 0xc6, 0x5c, 0x85, 0xec, 0xe9, 0x3a, 0xbb, 0x6b, 0x75,
    0xed, 0x97, 0x45, 0xdb, 0x79, 0x9e, 0x60, 0xbf, 0x85, 0x5e, 0x87, 0x6c,
    0x44, 0xd0, 0xd7, 0xeb, 0xec, 0x43, 0xb4, 0x7e, 0x1e, 0x46, 0x9d, 0xf7,
    0x25, 0x6c, 0x0c, 0xe7, 0x9d, 0x09, 0x5b, 0xb3, 0xf3, 0xde, 0x84, 0xdd,
    0x63, 0x3b, 0xef, 0x4e, 0xd8, 0x5d, 0xb6, 0xf3, 0xfe, 0x84, 0x3d, 0x0f,
    0x39, 0xef, 0x50, 0xa4, 0xa4, 0xfd, 0xfc, 0xcd, 0xde, 0xa3, 0x48, 0xe1,
    0xb5, 0xdf, 0xb4, 0xe4, 0xa4, 0x3d, 0x3e, 0x7b, 0xb7, 0xe2, 0x49, 0xda,
    0xcf, 0x89, 0x2c, 0x36, 0xec, 0x87, 0x76, 0xd6, 0x97, 0xfd, 0x56, 0xa6,
    0x84, 0xed, 0x67, 0x08, 0x16, 0x23, 0x9f, 0x90, 0xb3, 0xdf, 0xd1, 0xd8,
    0x43, 0x28, 0xf3, 0x8f, 0xbd, 0xd3, 0xf9, 0x1f, 0x8b, 0x9b, 0x02, 0xf1,
    0x0c, 0x1a, 0x00, 0x00, 0x00, 0x00,
};

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (constructor,         "<init>",              "(Landroid/content/Context;JLjava/lang/String;Ljava/lang/String;)V") \
  METHOD (canGoBack,           "canGoBack",           "()Z") \
  METHOD (goBack,              "goBack",              "()V") \
  METHOD (goForward,           "goForward",           "()V") \
  METHOD (loadDataWithBaseURL, "loadDataWithBaseURL", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V") \
  METHOD (loadUrl,             "loadUrl",             "(Ljava/lang/String;Ljava/util/Map;)V") \
  METHOD (postUrl,             "postUrl",             "(Ljava/lang/String;[B)V") \
  METHOD (reload,              "reload",              "()V") \
  METHOD (evaluateJavascript,  "evaluateJavascript",  "(Ljava/lang/String;)J") \
  METHOD (stopLoading,         "stopLoading",         "()V") \
  METHOD (disconnectNative,    "disconnectNative",    "()V")

DECLARE_JNI_CLASS_WITH_BYTECODE (JuceWebView, "com/rmsl/juce/JuceWebViewClasses$JuceWebView", 16, juceWebViewClasses)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  STATICMETHOD (getInstance, "getInstance", "()Landroid/webkit/CookieManager;")

DECLARE_JNI_CLASS (AndroidCookieManager, "android/webkit/CookieManager")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (toString, "toString", "()Ljava/lang/String;")

DECLARE_JNI_CLASS (SslError, "android/net/http/SslError")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  STATICMETHOD (encode, "encode", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;")

DECLARE_JNI_CLASS (URLEncoder, "java/net/URLEncoder")
#undef JNI_CLASS_MEMBERS

class MessageThreadExecutor  : private AsyncUpdater
{
public:
    MessageThreadExecutor() = default;

    ~MessageThreadExecutor() override
    {
        cancelPendingUpdate();
    }

    void execute (std::function<void()> fn)
    {
        const std::lock_guard lock { functionsMutex };
        functions.emplace_back (std::move (fn));
        triggerAsyncUpdate();
    }

private:
    void handleAsyncUpdate() override
    {
        const auto popFront = [&]() -> std::function<void()>
        {
            const std::lock_guard lock { functionsMutex };

            if (functions.empty())
                return nullptr;

            const ScopeGuard scope { [&] { functions.pop_front(); } };

            return functions.front();
        };

        for (auto fn = popFront(); fn != nullptr; fn = popFront())
            fn();
    }

    std::deque<std::function<void()>> functions;
    std::mutex functionsMutex;

    JUCE_DECLARE_NON_COPYABLE (MessageThreadExecutor)
};

//==============================================================================
struct WebBrowserComponent::Impl::Platform    : public AndroidViewComponent,
                                                public PlatformInterface,
                                                public AsyncUpdater
{
public:
    Platform (WebBrowserComponent& o,
              const WebBrowserComponent::Options& browserOptions,
              const StringArray& userScripts)
        : owner (o)
    {
        auto* env = getEnv();

        setView (env->NewObject (JuceWebView,
                                 JuceWebView.constructor,
                                 getMainActivity().get(),
                                 reinterpret_cast<jlong> (this),
                                 javaString (browserOptions.getUserAgent()).get(),
                                 javaString (userScripts.joinIntoString ("\n")).get()));

        owner.addAndMakeVisible (this);
    }

    void checkWindowAssociation() override
    {
        if (owner.isShowing())
        {
            if (owner.blankPageShown)
                owner.goBack();
        }
        else
        {
            if (owner.unloadPageWhenHidden && ! owner.blankPageShown)
            {
                // when the component becomes invisible, some stuff like flash
                // carries on playing audio, so we need to force it onto a blank
                // page to avoid this, (and send it back when it's made visible again).

                owner.blankPageShown = true;
                goToURL ("about:blank", nullptr, nullptr);
            }
        }
    }

    void setWebViewSize (int width, int height) override
    {
        setSize (width, height);
    }

    void evaluateJavascript (const String& script, WebBrowserComponent::EvaluationCallback callback) override
    {
        JUCE_ASSERT_MESSAGE_THREAD

        auto* env = getEnv();
        auto view = (jobject) getView();

        const auto resultId = (int64) env->CallLongMethod (view,
                                                           JuceWebView.evaluateJavascript,
                                                           javaString (script).get());

        if (callback != nullptr)
            evaluationCallbacks[resultId] = std::move (callback);
    }

    ~Platform() override
    {
        auto* env = getEnv();

        env->CallVoidMethod ((jobject) getView(), JuceWebView.stopLoading);

        masterReference.clear();

        // if other Java thread is waiting for us to respond to page load request
        // wake it up immediately (false answer will be sent), so that it releases
        // the lock we need when calling hostDeleted.
        responseReadyEvent.signal();

        resourceRequester.cancelAllResourceRequests();

        env->CallVoidMethod ((jobject) getView(), JuceWebView.disconnectNative);
    }

    void goToURL (const String& url,
                  const StringArray* headers,
                  const MemoryBlock* postData) override
    {
        auto* env = getEnv();

        if (headers == nullptr && postData == nullptr)
        {
            env->CallVoidMethod ((jobject) getView(), JuceWebView.loadUrl, javaString (url).get(), 0);
        }
        else if (headers != nullptr && postData == nullptr)
        {
            auto headersMap = LocalRef<jobject> (env->NewObject (JavaHashMap,
                                                                 JavaHashMap.constructorWithCapacity,
                                                                 headers->size()));

            for (const auto& header : *headers)
            {
                auto name  = header.upToFirstOccurrenceOf (":", false, false).trim();
                auto value = header.fromFirstOccurrenceOf (":", false, false).trim();

                env->CallObjectMethod (headersMap, JavaMap.put,
                                       javaString (name).get(),
                                       javaString (value).get());
            }

            env->CallVoidMethod ((jobject) getView(), JuceWebView.loadUrl,
                                 javaString (url).get(), headersMap.get());
        }
        else if (headers == nullptr && postData != nullptr)
        {
            auto dataStringJuce = postData->toString();
            auto dataStringJava = javaString (dataStringJuce);
            auto encodingString = LocalRef<jobject> (env->CallStaticObjectMethod (URLEncoder, URLEncoder.encode,
                                                                                  dataStringJava.get(), javaString ("utf-8").get()));

            auto bytes = LocalRef<jbyteArray> ((jbyteArray) env->CallObjectMethod (encodingString, JavaString.getBytes));

            env->CallVoidMethod ((jobject) getView(), JuceWebView.postUrl,
                                 javaString (url).get(), bytes.get());
        }
        else if (headers != nullptr && postData != nullptr)
        {
            // There is no support for both extra headers and post data in Android WebView, so
            // we need to open URL manually.

            URL urlToUse = URL (url).withPOSTData (*postData);
            connectionThread.reset (new ConnectionThread (*this, urlToUse, *headers));
        }
    }

    void stop() override
    {
        connectionThread = nullptr;

        getEnv()->CallVoidMethod ((jobject) getView(), JuceWebView.stopLoading);
    }

    void goBack() override
    {
        connectionThread = nullptr;

        auto* env = getEnv();
        auto view = (jobject) getView();

        if (env->CallBooleanMethod (view, JuceWebView.canGoBack))
            env->CallVoidMethod (view, JuceWebView.goBack);
        else
            owner.reloadLastURL();
    }

    void goForward() override
    {
        connectionThread = nullptr;

        getEnv()->CallVoidMethod ((jobject) getView(), JuceWebView.goForward);
    }

    void refresh() override
    {
        connectionThread = nullptr;

        getEnv()->CallVoidMethod ((jobject) getView(), JuceWebView.reload);
    }

    void handleAsyncUpdate() override
    {
        jassert (connectionThread != nullptr);

        if (connectionThread == nullptr)
            return;

        auto& result = connectionThread->getResult();

        if (result.statusCode >= 200 && result.statusCode < 300)
        {
            auto url = javaString (result.url);
            auto data = javaString (result.data);
            auto mimeType = javaString ("text/html");
            auto encoding = javaString ("utf-8");

            getEnv()->CallVoidMethod ((jobject) getView(), JuceWebView.loadDataWithBaseURL,
                                      url.get(), data.get(), mimeType.get(),
                                      encoding.get(), 0);
        }
        else
        {
            owner.pageLoadHadNetworkError (result.description);
        }
    }

    bool handlePageAboutToLoad (const String& url)
    {
        if (MessageManager::getInstance()->isThisTheMessageThread())
            return owner.pageAboutToLoad (url);

        WeakReference<Platform> weakRef (this);

        if (weakRef == nullptr)
            return false;

        responseReadyEvent.reset();

        bool shouldLoad = false;

        MessageManager::callAsync ([weakRef, url, &shouldLoad]
        {
            if (weakRef == nullptr)
                return;

            shouldLoad = weakRef->owner.pageAboutToLoad (url);

            weakRef->responseReadyEvent.signal();
        });

        responseReadyEvent.wait (-1);

        return shouldLoad;
    }

    WebBrowserComponent& owner;

private:
    class ConnectionThread final : private Thread
    {
    public:
        struct Result
        {
            String url;
            int statusCode = 0;
            String description;
            String data;
        };

        ConnectionThread (Platform& ownerToUse,
                          URL& url,
                          const StringArray& headers)
            : Thread (SystemStats::getJUCEVersion() + ": WebBrowserComponent::Platform::ConnectionThread"),
              owner (ownerToUse),
              webInputStream (new WebInputStream (url, true))
        {
            webInputStream->withExtraHeaders (headers.joinIntoString ("\n"));
            webInputStream->withConnectionTimeout (10000);

            result.url = url.toString (true);

            startThread();
        }

        ~ConnectionThread() override
        {
            webInputStream->cancel();
            signalThreadShouldExit();
            waitForThreadToExit (10000);

            webInputStream = nullptr;
        }

        void run() override
        {
            if (! webInputStream->connect (nullptr))
            {
                result.description = "Could not establish connection";
                owner.triggerAsyncUpdate();
                return;
            }

            result.statusCode = webInputStream->getStatusCode();
            result.description = "Status code: " + String (result.statusCode);
            readFromInputStream();
            owner.triggerAsyncUpdate();
        }

        const Result& getResult() { return result; }

    private:
        void readFromInputStream()
        {
            MemoryOutputStream ostream;

            for (;;)
            {
                if (threadShouldExit())
                    return;

                char buffer [8192];
                auto num = webInputStream->read (buffer, sizeof (buffer));

                if (num <= 0)
                    break;

                ostream.write (buffer, (size_t) num);
            }

            result.data = ostream.toUTF8();
        }

        Platform& owner;
        std::unique_ptr<WebInputStream> webInputStream;
        Result result;
    };

    class MessageThreadResourceRequester  : private AsyncUpdater
    {
    public:
        explicit MessageThreadResourceRequester (Platform& ownerIn)
            : owner (ownerIn)
        {}

        ~MessageThreadResourceRequester() override
        {
            cancelPendingUpdate();
        }

        // The Platform destructor will block for as long as a Java thread waits for a Resource, so this
        // must be called from ~Platform().
        void cancelAllResourceRequests()
        {
            std::lock_guard lock { queueMutex };

            while (! queue.empty())
            {
                auto* r = queue.front();
                queue.pop_front();
                r->event.signal();
            }
        }

        std::optional<Resource> handleResourceRequestOnMessageThread (StringRef uri)
        {
            if (MessageManager::getInstance()->isThisTheMessageThread())
                return owner.owner.impl->handleResourceRequest (uri);

            WaitableResource resource { uri };

            {
                std::lock_guard lock { queueMutex };
                queue.push_back (&resource);
            }

            triggerAsyncUpdate();
            resource.event.wait (-1);

            return resource.resource;
        }

    private:
        struct WaitableResource
        {
            explicit WaitableResource (StringRef uriIn) : uri (uriIn) {}

            String uri;
            WaitableEvent event;
            std::optional<WebBrowserComponent::Resource> resource;
        };

        void handleAsyncUpdate() override
        {
            const auto popFront = [&]() -> WaitableResource*
            {
                const std::lock_guard lock { queueMutex };

                if (queue.empty())
                    return nullptr;

                const ScopeGuard scope { [&] { queue.pop_front(); } };

                return queue.front();
            };

            for (auto* r = popFront(); r != nullptr; r = popFront())
            {
                r->resource = (owner.owner.impl->handleResourceRequest (r->uri));
                r->event.signal();
            }
        }

        Platform& owner;
        std::deque<WaitableResource*> queue;
        std::mutex queueMutex;
    };

    //==============================================================================
    #define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
     METHOD (constructor, "<init>",      "(J)V") \
     METHOD (hostDeleted, "hostDeleted", "()V") \
     CALLBACK (generatedCallback<&Platform::webViewReceivedHttpError>,   "webViewReceivedHttpError",   "(JLandroid/webkit/WebView;Landroid/webkit/WebResourceRequest;Landroid/webkit/WebResourceResponse;)V") \
     CALLBACK (generatedCallback<&Platform::handleResourceRequest>,      "handleResourceRequest",      "(JLandroid/webkit/WebView;Ljava/lang/String;)Landroid/webkit/WebResourceResponse;") \
     CALLBACK (generatedCallback<&Platform::webViewPageLoadFinished>,    "webViewPageLoadFinished",    "(JLandroid/webkit/WebView;Ljava/lang/String;)V") \
     CALLBACK (generatedCallback<&Platform::webViewReceivedSslError>,    "webViewReceivedSslError",    "(JLandroid/webkit/WebView;Landroid/webkit/SslErrorHandler;Landroid/net/http/SslError;)V") \
     CALLBACK (generatedCallback<&Platform::webViewCloseWindowRequest>,  "webViewCloseWindowRequest",  "(JLandroid/webkit/WebView;)V") \
     CALLBACK (generatedCallback<&Platform::webViewCreateWindowRequest>, "webViewCreateWindowRequest", "(JLandroid/webkit/WebView;)V") \
     CALLBACK (generatedCallback<&Platform::evaluationResultHandler>,    "evaluationResultHandler",    "(JJLjava/lang/String;)V") \
     CALLBACK (generatedCallback<&Platform::postMessageHandler>,         "postMessage",                "(JLjava/lang/String;)Ljava/lang/String;") \
     CALLBACK (generatedCallback<&Platform::pageAboutToLoad>,            "pageAboutToLoad",            "(JLjava/lang/String;)Z")

     DECLARE_JNI_CLASS_WITH_BYTECODE (NativeInterface, "com/rmsl/juce/JuceWebViewClasses$NativeInterface", 16, juceWebViewClasses)
    #undef JNI_CLASS_MEMBERS

    #define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
     METHOD (create, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;)V") \
     METHOD (setResponseHeaders, "setResponseHeaders", "(Ljava/util/Map;)V") \

     DECLARE_JNI_CLASS (WebResourceResponse, "android/webkit/WebResourceResponse")
    #undef JNI_CLASS_MEMBERS

    #define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
     METHOD (create, "<init>", "([B)V") \

     DECLARE_JNI_CLASS (ByteArrayInputStream, "java/io/ByteArrayInputStream")
    #undef JNI_CLASS_MEMBERS

    static jobject handleResourceRequest (JNIEnv* env, Platform& t, jobject /*webView*/, jstring url)
    {
        const auto uriString = juceString (url);

        if (const auto resourceRequestUri = uriString.fromFirstOccurrenceOf ("https://juce.backend", false, false);
            resourceRequestUri.isNotEmpty())
        {
            if (auto response = t.resourceRequester.handleResourceRequestOnMessageThread (resourceRequestUri))
            {
                jbyteArray byteArray = env->NewByteArray ((jsize) response->data.size());
                env->SetByteArrayRegion (byteArray, 0, (jsize) response->data.size(), (jbyte*) response->data.data());
                LocalRef<jobject> byteArrayInputStream { env->NewObject (ByteArrayInputStream, ByteArrayInputStream.create, byteArray) };
                auto resource = env->NewObject (WebResourceResponse,
                                                WebResourceResponse.create,
                                                javaString (response->mimeType).get(),
                                                response->mimeType.contains ("text") ? javaString ("utf-8").get() : nullptr,
                                                byteArrayInputStream.get());

                if (const auto allowedOrigin = t.owner.impl->options.getAllowedOrigin())
                {
                    LocalRef<jobject> headersMap { env->NewObject (JavaHashMap,
                                                                   JavaHashMap.constructorWithCapacity,
                                                                   1) };

                    env->CallObjectMethod (headersMap, JavaMap.put,
                                           javaString ("Access-Control-Allow-Origin").get(),
                                           javaString (*allowedOrigin).get());

                    env->CallVoidMethod (resource,
                                         WebResourceResponse.setResponseHeaders,
                                         headersMap.get());
                }

                return resource;
            }
        }

        return nullptr;
    }

    static void webViewPageLoadFinished (JNIEnv*, Platform& t, jobject /*webView*/, jstring url)
    {
        t.owner.pageFinishedLoading (juceString (url));
    }

    static void webViewReceivedSslError (JNIEnv* env, Platform& t, jobject /*webView*/, jobject /*sslErrorHandler*/, jobject sslError)
    {
        const auto errorString = LocalRef<jstring> ((jstring) env->CallObjectMethod (sslError, SslError.toString));
        t.owner.pageLoadHadNetworkError (juceString (errorString));
    }

    static void evaluationResultHandler (JNIEnv*, Platform& t, jlong evalId, jstring result)
    {
        auto it = t.evaluationCallbacks.find ((int64) evalId);

        if (it == t.evaluationCallbacks.end())
            return;

        (it->second) (EvaluationResult { JSON::fromString (juceString (result)) });

        t.evaluationCallbacks.erase (it);
    }

    static jobject postMessageHandler (JNIEnv*, Platform& t, jstring message)
    {
        t.messageThreadExecutor.execute ([&t, msg = juceString (message)]
                                         {
                                             var obj;

                                             if (! JSON::parse (msg, obj).wasOk())
                                             {
                                                 jassertfalse;
                                                 return;
                                             }

                                             t.owner.impl->handleNativeEvent (obj);
                                         });

        return nullptr;
    }

    static bool pageAboutToLoad (JNIEnv*, Platform& t, jstring url)
    {
        return t.handlePageAboutToLoad (juceString (url));
    }

    //==============================================================================
    static void webViewCloseWindowRequest (JNIEnv*, Platform& t, jobject)
    {
        t.owner.windowCloseRequest();
    }

    static void webViewCreateWindowRequest (JNIEnv*, Platform& t, jobject)
    {
        t.owner.newWindowAttemptingToLoad ({});
    }

    //==============================================================================
    static void webViewReceivedHttpError (JNIEnv* env, Platform& t, jobject /*webView*/, jobject /*request*/, jobject errorResponse)
    {
        LocalRef<jclass> responseClass (env->FindClass ("android/webkit/WebResourceResponse"));

        if (responseClass != nullptr)
        {
            jmethodID method = env->GetMethodID (responseClass, "getReasonPhrase", "()Ljava/lang/String;");

            if (method != nullptr)
            {
                auto errorString = LocalRef<jstring> ((jstring) env->CallObjectMethod (errorResponse, method));

                t.owner.pageLoadHadNetworkError (juceString (errorString));
                return;
            }
        }

        // Should never get here!
        jassertfalse;
        t.owner.pageLoadHadNetworkError ({});
    }

    //==============================================================================
    std::unique_ptr<ConnectionThread> connectionThread;
    WaitableEvent responseReadyEvent;
    std::unordered_map<int64, EvaluationCallback> evaluationCallbacks;
    MessageThreadExecutor messageThreadExecutor;
    MessageThreadResourceRequester resourceRequester { *this };

    WeakReference<Platform>::Master masterReference;
    friend class WeakReference<Platform>;
};

//==============================================================================
auto WebBrowserComponent::Impl::createAndInitPlatformDependentPart (WebBrowserComponent::Impl& impl,
                                                                    const WebBrowserComponent::Options& options,
                                                                    const StringArray& userScripts)
    -> std::unique_ptr<PlatformInterface>
{
    return std::make_unique<Platform> (impl.owner, options, userScripts);
}

//==============================================================================
void WebBrowserComponent::clearCookies()
{
    auto* env = getEnv();

    auto cookieManager = LocalRef<jobject> (env->CallStaticObjectMethod (AndroidCookieManager,
                                                                         AndroidCookieManager.getInstance));

    jmethodID clearCookiesMethod = env->GetMethodID (AndroidCookieManager, "removeAllCookies", "(Landroid/webkit/ValueCallback;)V");
    env->CallVoidMethod (cookieManager, clearCookiesMethod, 0);
}

bool WebBrowserComponent::areOptionsSupported (const Options& options)
{
    return (options.getBackend() == Options::Backend::defaultBackend);
}

} // namespace juce
