+++
title = "TruncatedCube"
+++

### TruncatedCube

A cube whose eight vertices have been removed. The truncated part of each vertex
is a trirectangular tetrahedron.

<img src="/img/draw/ff/3d/TruncatedCube.png" width="30%" >
<img src="/img/draw/ff/2d/TruncatedCube_xy.svg" width="30%">
<img src="/img/draw/ff/2d/TruncatedCube_xz.svg" width="30%">

#### Constructor

```python
TruncatedCube(L, t)
```

Parameters:
- L, length of the full cube
- t, side length of the trirectangular tetrahedron removed from the cube’s vertices

Constraint:

$ t \le L/2 $ 

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [TruncatedCube]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron
provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V= L^3 - \dfrac{4}{3} t^3. $$

#### Related shapes

- [Box](/ref/sample/particle/ff/hard/box), a rectangular cuboid.
- [CantellatedCube](/ref/sample/particle/ff/hard/cantellatedcube), if truncated edges and vertices.

#### Example

Scattering by uncorrelated, oriented truncated cubes for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/TruncatedCube.png">

Generated by {{% ref-ex "ff/TruncatedCube.py" %}}.

#### History

Reimplemented in BornAgain 1.6 using the generic polyhedron form factor [[Wuttke 2021](/lit/wuttke2021)]. Motivated by [[Croset 2017](/lit/croset2017)].
