/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.cff;

import com.kreative.cff.Chunk;
import com.kreative.cff.ChunkAlreadyExistsException;
import com.kreative.cff.ChunkFile;
import com.kreative.cff.ChunkFileSpec;
import com.kreative.cff.FieldType;
import com.kreative.cff.Header;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ChunkFileEditor {
    public static final int CREATE_NEVER = 0;
    public static final int CREATE_IF_EMPTY = 1;
    public static final int CREATE_ALWAYS = 2;
    private ChunkFileSpec spec;
    private ChunkFile cf;
    private File f;

    public ChunkFileEditor(ChunkFileSpec spec) {
        this.spec = spec;
        this.cf = new ChunkFile(spec.fileHeaderSpec().createHeader());
        this.f = null;
    }

    public ChunkFileEditor(ChunkFileSpec spec, ChunkFile cf) {
        this.spec = spec;
        this.cf = cf;
        this.f = null;
    }

    public ChunkFileEditor(ChunkFileSpec spec, File f, int create) throws IOException {
        this.spec = spec;
        this.cf = create == 2 || create == 1 && (!f.exists() || f.length() == 0L) ? new ChunkFile(spec.fileHeaderSpec().createHeader()) : spec.readChunkFile(new DataInputStream(new FileInputStream(f)));
        this.f = f;
    }

    public ChunkFileSpec getChunkFileSpec() {
        return this.spec;
    }

    public ChunkFile getChunkFile() {
        return this.cf;
    }

    public File getFile() {
        return this.f;
    }

    public synchronized byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        this.spec.writeChunkFile(dout, this.cf);
        dout.flush();
        bout.flush();
        dout.close();
        bout.close();
        return bout.toByteArray();
    }

    public synchronized void flush() throws IOException {
        if (this.f != null) {
            FileOutputStream fout = new FileOutputStream(this.f);
            DataOutputStream dout = new DataOutputStream(fout);
            this.spec.writeChunkFile(dout, this.cf);
            dout.flush();
            fout.flush();
            dout.close();
            fout.close();
        }
    }

    public synchronized void close() throws IOException {
        if (this.f != null) {
            FileOutputStream fout = new FileOutputStream(this.f);
            DataOutputStream dout = new DataOutputStream(fout);
            this.spec.writeChunkFile(dout, this.cf);
            dout.flush();
            fout.flush();
            dout.close();
            fout.close();
        }
    }

    public synchronized Header getHeader() {
        return this.cf.getHeader();
    }

    public synchronized void setHeader(Header h) {
        this.cf.setHeader(h);
    }

    public synchronized boolean add(Chunk ch) throws ChunkAlreadyExistsException {
        Header h = ch.getHeader();
        if (h.containsKey((Object)FieldType.ID_NUMBER) && this.contains((Number)h.get((Object)FieldType.CHARACTER_TYPE), (Number)h.get((Object)FieldType.INTEGER_TYPE), (Number)h.get((Object)FieldType.ID_NUMBER))) {
            throw new ChunkAlreadyExistsException();
        }
        this.cf.add(ch);
        return true;
    }

    public synchronized boolean contains(Number ctype, Number itype, Number id) {
        return this.contains(this.getChunkIndex(ctype, itype, id));
    }

    public synchronized boolean contains(int index) {
        return index >= 0 && index < this.cf.size();
    }

    public synchronized Chunk get(Number ctype, Number itype, Number id) {
        return this.get(this.getChunkIndex(ctype, itype, id));
    }

    public synchronized Chunk get(int index) {
        if (index >= 0 && index < this.cf.size()) {
            return (Chunk)this.cf.get(index);
        }
        return null;
    }

    public synchronized Header getAttributes(Number ctype, Number itype, Number id) {
        return this.getAttributes(this.getChunkIndex(ctype, itype, id));
    }

    public synchronized Header getAttributes(int index) {
        if (index >= 0 && index < this.cf.size()) {
            return ((Chunk)this.cf.get(index)).getHeader();
        }
        return null;
    }

    public synchronized byte[] getData(Number ctype, Number itype, Number id) {
        return this.getData(this.getChunkIndex(ctype, itype, id));
    }

    public synchronized byte[] getData(int index) {
        if (index >= 0 && index < this.cf.size()) {
            return ((Chunk)this.cf.get(index)).getData();
        }
        return null;
    }

    public synchronized boolean insert(Number ctype, Number itype, Number id, Chunk ch) throws ChunkAlreadyExistsException {
        int index = this.getChunkIndex(ctype, itype, id);
        return index < 0 ? this.add(ch) : this.insert(index, ch);
    }

    public synchronized boolean insert(int index, Chunk ch) throws ChunkAlreadyExistsException {
        Header h = ch.getHeader();
        if (h.containsKey((Object)FieldType.ID_NUMBER) && this.contains((Number)h.get((Object)FieldType.CHARACTER_TYPE), (Number)h.get((Object)FieldType.INTEGER_TYPE), (Number)h.get((Object)FieldType.ID_NUMBER))) {
            throw new ChunkAlreadyExistsException();
        }
        if (index < 0) {
            index = 0;
        }
        if (index > this.cf.size()) {
            index = this.cf.size();
        }
        this.cf.add(index, ch);
        return true;
    }

    public synchronized boolean remove(Number ctype, Number itype, Number id) {
        return this.remove(this.getChunkIndex(ctype, itype, id));
    }

    public synchronized boolean remove(int index) {
        if (index >= 0 && index < this.cf.size()) {
            this.cf.remove(index);
            return true;
        }
        return false;
    }

    public synchronized boolean set(Number ctype, Number itype, Number id, Chunk ch) throws ChunkAlreadyExistsException {
        return this.set(this.getChunkIndex(ctype, itype, id), ch);
    }

    public synchronized boolean set(int index, Chunk ch) throws ChunkAlreadyExistsException {
        if (index >= 0 && index < this.cf.size()) {
            Header h = ch.getHeader();
            Header eh = ((Chunk)this.cf.get(index)).getHeader();
            if (ChunkFileEditor.eq((Number)eh.get((Object)FieldType.CHARACTER_TYPE), (Number)h.get((Object)FieldType.CHARACTER_TYPE)) && ChunkFileEditor.eq((Number)eh.get((Object)FieldType.INTEGER_TYPE), (Number)h.get((Object)FieldType.INTEGER_TYPE)) && ChunkFileEditor.eq((Number)eh.get((Object)FieldType.ID_NUMBER), (Number)h.get((Object)FieldType.ID_NUMBER))) {
                this.cf.set(index, ch);
                return true;
            }
            if (h.containsKey((Object)FieldType.ID_NUMBER) && this.contains((Number)h.get((Object)FieldType.CHARACTER_TYPE), (Number)h.get((Object)FieldType.INTEGER_TYPE), (Number)h.get((Object)FieldType.ID_NUMBER))) {
                throw new ChunkAlreadyExistsException();
            }
            this.cf.set(index, ch);
            return true;
        }
        return false;
    }

    public synchronized boolean setAttributes(Number ctype, Number itype, Number id, Header h) throws ChunkAlreadyExistsException {
        return this.setAttributes(this.getChunkIndex(ctype, itype, id), h);
    }

    public synchronized boolean setAttributes(int index, Header h) throws ChunkAlreadyExistsException {
        if (index >= 0 && index < this.cf.size()) {
            Header eh = ((Chunk)this.cf.get(index)).getHeader();
            if (ChunkFileEditor.eq((Number)eh.get((Object)FieldType.CHARACTER_TYPE), (Number)h.get((Object)FieldType.CHARACTER_TYPE)) && ChunkFileEditor.eq((Number)eh.get((Object)FieldType.INTEGER_TYPE), (Number)h.get((Object)FieldType.INTEGER_TYPE)) && ChunkFileEditor.eq((Number)eh.get((Object)FieldType.ID_NUMBER), (Number)h.get((Object)FieldType.ID_NUMBER))) {
                ((Chunk)this.cf.get(index)).setHeader(h);
                return true;
            }
            if (h.containsKey((Object)FieldType.ID_NUMBER) && this.contains((Number)h.get((Object)FieldType.CHARACTER_TYPE), (Number)h.get((Object)FieldType.INTEGER_TYPE), (Number)h.get((Object)FieldType.ID_NUMBER))) {
                throw new ChunkAlreadyExistsException();
            }
            ((Chunk)this.cf.get(index)).setHeader(h);
            return true;
        }
        return false;
    }

    private static boolean eq(Number a, Number b) {
        return a == null ? b == null : (b == null ? a == null : a.longValue() == b.longValue());
    }

    public synchronized boolean setData(Number ctype, Number itype, Number id, byte[] data) {
        return this.setData(this.getChunkIndex(ctype, itype, id), data);
    }

    public synchronized boolean setData(int index, byte[] data) {
        if (index >= 0 && index < this.cf.size()) {
            ((Chunk)this.cf.get(index)).setData(data);
            return true;
        }
        return false;
    }

    public synchronized int getChunkCount() {
        return this.cf.size();
    }

    public synchronized int getChunkCount(Number ctype, Number itype) {
        int count = 0;
        int i = 0;
        while (i < this.cf.size()) {
            Header h = ((Chunk)this.cf.get(i)).getHeader();
            if (!(h.containsKey((Object)FieldType.CHARACTER_TYPE) && ((Number)h.get((Object)FieldType.CHARACTER_TYPE)).longValue() != ctype.longValue() || h.containsKey((Object)FieldType.INTEGER_TYPE) && ((Number)h.get((Object)FieldType.INTEGER_TYPE)).longValue() != itype.longValue())) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public synchronized Number[] getChunkIDs(Number ctype, Number itype) {
        Vector<Number> ids = new Vector<Number>();
        long localIndex = 0L;
        int i = 0;
        while (i < this.cf.size()) {
            Header h = ((Chunk)this.cf.get(i)).getHeader();
            if (!(h.containsKey((Object)FieldType.CHARACTER_TYPE) && ((Number)h.get((Object)FieldType.CHARACTER_TYPE)).longValue() != ctype.longValue() || h.containsKey((Object)FieldType.INTEGER_TYPE) && ((Number)h.get((Object)FieldType.INTEGER_TYPE)).longValue() != itype.longValue())) {
                if (h.containsKey((Object)FieldType.ID_NUMBER)) {
                    ids.add((Number)h.get((Object)FieldType.ID_NUMBER));
                } else {
                    ids.add(localIndex);
                }
                ++localIndex;
            }
            ++i;
        }
        return ids.toArray(new Number[0]);
    }

    public synchronized Number getChunkID(Number ctype, Number itype, int index) {
        long localIndex = 0L;
        int i = 0;
        while (i < this.cf.size()) {
            Header h = ((Chunk)this.cf.get(i)).getHeader();
            if (!(h.containsKey((Object)FieldType.CHARACTER_TYPE) && ((Number)h.get((Object)FieldType.CHARACTER_TYPE)).longValue() != ctype.longValue() || h.containsKey((Object)FieldType.INTEGER_TYPE) && ((Number)h.get((Object)FieldType.INTEGER_TYPE)).longValue() != itype.longValue())) {
                if (index == 0) {
                    if (h.containsKey((Object)FieldType.ID_NUMBER)) {
                        return (Number)h.get((Object)FieldType.ID_NUMBER);
                    }
                    return localIndex;
                }
                ++localIndex;
                --index;
            }
            ++i;
        }
        return null;
    }

    public synchronized int getChunkIndex(Number ctype, Number itype, Number id) {
        long localIndex = 0L;
        int i = 0;
        while (i < this.cf.size()) {
            Header h = ((Chunk)this.cf.get(i)).getHeader();
            if (!(h.containsKey((Object)FieldType.CHARACTER_TYPE) && ((Number)h.get((Object)FieldType.CHARACTER_TYPE)).longValue() != ctype.longValue() || h.containsKey((Object)FieldType.INTEGER_TYPE) && ((Number)h.get((Object)FieldType.INTEGER_TYPE)).longValue() != itype.longValue())) {
                if (h.containsKey((Object)FieldType.ID_NUMBER) ? ((Number)h.get((Object)FieldType.ID_NUMBER)).longValue() == id.longValue() : localIndex == id.longValue()) {
                    return i;
                }
                ++localIndex;
            }
            ++i;
        }
        return -1;
    }

    public synchronized Number getNextAvailableID(Number ctype, Number itype) {
        return this.getNextAvailableID(ctype, itype, 0);
    }

    public synchronized Number getNextAvailableID(Number ctype, Number itype, Number start) {
        Vector<Long> ids = new Vector<Long>();
        long localIndex = 0L;
        int i = 0;
        while (i < this.cf.size()) {
            Header h = ((Chunk)this.cf.get(i)).getHeader();
            if (!(h.containsKey((Object)FieldType.CHARACTER_TYPE) && ((Number)h.get((Object)FieldType.CHARACTER_TYPE)).longValue() != ctype.longValue() || h.containsKey((Object)FieldType.INTEGER_TYPE) && ((Number)h.get((Object)FieldType.INTEGER_TYPE)).longValue() != itype.longValue())) {
                if (h.containsKey((Object)FieldType.ID_NUMBER)) {
                    ids.add(((Number)h.get((Object)FieldType.ID_NUMBER)).longValue());
                } else {
                    ids.add(localIndex);
                }
                ++localIndex;
            }
            ++i;
        }
        long next = start.longValue();
        while (ids.contains(next)) {
            ++next;
        }
        if (this.spec.chunkHeaderSpec().containsType(FieldType.ID_NUMBER)) {
            switch (this.spec.chunkHeaderSpec().getField(FieldType.ID_NUMBER).size()) {
                case BYTE: {
                    return (byte)next;
                }
                case SHORT: {
                    return (short)next;
                }
                case MEDIUM: {
                    return (int)next;
                }
                case LONG: {
                    return next;
                }
            }
            return next;
        }
        return next;
    }
}

