//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_4.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot4(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[4] = {1.453035215033171e-01,1.339097288126363e+00,3.926963501358290e+00,8.588635689012035e+00};
  constexpr double aw[4] = {6.611470125582407e-01,2.078023258148919e-01,1.707798300741347e-02,1.996040722113680e-04};
  constexpr double x[1536] = {  6.049031327031341e-02, -3.270068487538848e-03,  1.285969134112606e-04, -4.314986936371710e-06,  1.276525412703032e-07,
 -3.319420980735172e-09,  7.145272019320873e-11, -1.055050932790330e-12, -4.990355408937095e-15,  1.304466418907947e-15, -5.793426146934574e-17,  1.508269138897369e-18,
  5.081363306251300e-01, -2.164799272614928e-02,  4.680762200994743e-04, -4.377050408282199e-07, -3.478610589995228e-07,  1.029501892042923e-08,  5.102283632027422e-11,
 -1.331871547653920e-11,  3.529162911007458e-13,  6.082140697274363e-15, -5.797250435979266e-16,  8.687790317521172e-18,  1.213095902882022e+00, -2.839120546413938e-02,
 -2.478377659247807e-04,  1.420271722757042e-05,  3.488326825024388e-07, -1.152390329015224e-08, -5.360737268033646e-10,  8.679161527009806e-12,  8.043237862745242e-13,
 -2.527796851762583e-15, -1.063998609104412e-15, -7.726630279565933e-18,  1.825338222573461e+00, -9.851826737313892e-03, -3.747230764955220e-04, -1.058212588649040e-05,
 -1.879263047087563e-07,  8.784664780373951e-10,  2.336068901393952e-10,  1.045679441176617e-11,  2.444352648020917e-13, -3.049216779358227e-16, -2.770745391675550e-16,
 -1.203413521470440e-17,  4.918271933075258e-02, -2.418180905787218e-03,  8.715542623222832e-05, -2.720426606104693e-06,  7.606170655344866e-08, -1.946892394154032e-09,
  4.419076175741316e-11, -8.023440455255573e-13,  1.306249222187942e-14, -2.168581139365994e-17, -1.497651606715970e-17,  5.888845152966189e-19,  4.288872596750001e-01,
 -1.800346190332883e-02,  4.361509674143550e-04, -4.392385040529110e-06, -1.529792386045216e-07,  8.385441170846676e-09, -1.574461941142555e-10, -2.059696792115251e-12,
  2.722802909673236e-13, -7.158181089536300e-15, -8.495273591868430e-17,  9.159584520957615e-18,  1.096750958615845e+00, -2.961874248625691e-02, -5.344381111146586e-05,
  1.737217723360234e-05,  2.299479764950535e-08, -1.893805294499017e-08, -3.167723668463467e-12,  2.522951984171050e-11,  3.871660968565490e-14, -3.318279859439934e-14,
 -7.667662410690194e-17,  4.248826514746016e-17,  1.779063870186571e+00, -1.340479953136529e-02, -5.178749175389344e-04, -1.302942844632027e-05, -8.642298476341305e-08,
  1.076622973376067e-08,  6.119867801419792e-10,  1.472777241013895e-11, -1.224471341933832e-13, -2.478704633117801e-14, -9.589812092365702e-16, -1.175066937917816e-17,
  4.072346554849607e-02, -1.833448683569742e-03,  6.069503351666052e-05, -1.764146811573363e-06,  4.613949253724532e-08, -1.112428631487767e-09,  2.688664022806664e-11,
 -4.702639947136381e-13,  6.478854708759324e-15, -2.369041099119643e-16,  1.436053268926549e-18,  2.048736701478273e-19,  3.634743405519438e-01, -1.475532334780276e-02,
  3.736078790748540e-04, -5.708732539903791e-06, -2.368251172612976e-08,  4.654094870012054e-09, -1.328112604644937e-10,  2.495472887083656e-12,  2.532168490034721e-14,
 -5.222413667318557e-15,  1.213895712282456e-16,  1.052719889730802e-18,  9.787134277002409e-01, -2.923383172861855e-02,  1.453496950769497e-04,  1.493492413219956e-05,
 -3.030650530222545e-07, -1.143636417205775e-08,  5.564938965348728e-10,  1.007473979226421e-11, -8.221744912162807e-13, -7.059312597500290e-15,  1.022485901196580e-15,
 -3.385472939767893e-18,  1.716164114946788e+00, -1.817455028500088e-02, -6.724984732712236e-04, -1.177257488463356e-05,  3.023975570754019e-07,  2.886254419852603e-08,
  7.814760050498927e-10, -1.085670951039503e-11, -1.660699443562672e-12, -5.266845545030470e-14,  3.636178736761328e-16,  9.676032248410520e-17,  3.424246593542760e-02,
 -1.421501473404065e-03,  4.332260480517815e-05, -1.172992778814022e-06,  2.936744566801742e-08, -6.088439901876410e-10,  1.550359194129830e-11, -3.740750005214931e-13,
  6.635484164931975e-16, -4.954463895820160e-17,  7.124053321897301e-18,  8.598673281392699e-20,  3.099958688480101e-01, -1.204085413203446e-02,  3.054049799575332e-04,
 -5.492665738152219e-06,  4.304602288989944e-08,  2.257459651581255e-09, -7.297112868289596e-11,  1.263088077090193e-12, -7.300945544106978e-14, -3.208267018743701e-16,
  1.131760062544174e-16, -5.361019880619323e-19,  8.651057127942970e-01, -2.744900361145129e-02,  2.904092006446387e-04,  9.023756183004319e-06, -3.907874375779626e-07,
  2.356161309485780e-09,  4.825919150878617e-10, -1.348774201651753e-11, -4.883292721633795e-13,  1.984908682711906e-14,  2.183985191994157e-16, -1.825255223910588e-17,
  1.631992294499557e+00, -2.398789928894426e-02, -7.629747323258112e-04, -1.528037825908155e-06,  1.005285680697304e-06,  3.656884013960727e-08, -4.705413557241767e-10,
 -8.071547134687993e-11, -1.918679371547486e-12,  7.992555519775018e-14,  6.221470421841353e-15,  6.991355313747852e-17,  2.917067533532330e-02, -1.124047955266787e-03,
  3.171998503189037e-05, -7.838306488210151e-07,  2.007606159195524e-08, -3.595900822444351e-10,  5.481155068952685e-12, -3.217340827793428e-13,  4.450471480344191e-15,
  2.500974252775228e-16,  5.095445390492032e-18, -2.981084385581078e-19,  2.663218146125352e-01, -9.846699754401020e-03,  2.448288270293894e-04, -4.530454766025616e-06,
  7.224699620727476e-08,  6.858740735016707e-10, -6.612022966126386e-11, -4.393434597568806e-13, -1.063839858707207e-14,  3.431108964341982e-15,  5.349069832007830e-17,
 -3.510129698041931e-18,  7.605009654135931e-01, -2.479195003178999e-02,  3.643640587407032e-04,  3.626064640546117e-06, -2.646383531048898e-07,  8.330476668931831e-09,
 -1.342875572827660e-12, -1.713641188302068e-11,  2.532020499535234e-13,  1.901908934737695e-14, -1.723533669135589e-16, -8.003424291337998e-18,  1.524166206148661e+00,
 -2.984415856077416e-02, -6.649474786186679e-04,  1.895163779282899e-05,  1.422306632020113e-06, -4.439840223587680e-09, -2.829740579891526e-09, -5.233564321200312e-11,
  4.564718491893588e-12,  2.071194241084091e-13, -4.711957537897090e-15, -5.303667854316780e-16,  2.512946254838888e-02, -9.029650336851160e-04,  2.401971824319708e-05,
 -5.156602358115700e-07,  1.359092972666462e-08, -3.111869397186640e-10, -1.071363682351617e-13, -3.323758501132377e-14,  1.227579047145541e-14,  2.422251818228275e-17,
 -1.774320445688681e-17, -4.160376087930234e-19,  2.305363515169273e-01, -8.085415679866948e-03,  1.975627153712623e-04, -3.354326105887961e-06,  6.940781701855242e-08,
 -9.679125224079429e-10, -6.400855195304958e-11,  1.191637432585222e-12,  9.740004734009386e-14,  8.151499940039195e-16, -1.972572294702916e-16, -4.513088659678911e-18,
  6.673527526602523e-01, -2.176303396225527e-02,  3.875742826443145e-04,  5.837556719160049e-07, -1.300519618541428e-07,  4.015843649916722e-09, -2.804459345322239e-10,
 -5.373482372827420e-13,  6.636519656053662e-13, -1.642745609480296e-15, -9.368619870191814e-16, -1.398151224609788e-17,  1.396096511024354e+00, -3.389893819340156e-02,
 -3.163653268750620e-04,  3.717391623628852e-05,  6.420757517483895e-07, -6.888215568794221e-08, -1.624918033904570e-09,  1.377639025243152e-10,  4.257046605608819e-12,
 -2.743617843935962e-13, -1.098024940666381e-14,  5.302573622763543e-16,  2.186732368540525e-02, -7.323346085716654e-04,  1.893166447065745e-05, -3.476944131880820e-07,
  7.479631625845385e-09, -2.850284062718463e-10,  3.540529966754128e-12,  2.280823107835302e-13,  2.139260622827424e-16, -5.741563919483370e-16, -1.557592217390460e-19,
  1.076604912537086e-18,  2.011248919372691e-01, -6.648974691858327e-03,  1.631106051353597e-04, -2.464682229023307e-06,  3.911148214777345e-08, -1.783145002656042e-09,
  5.740257048423134e-12,  3.166301406093176e-12, -1.649953120849822e-14, -5.810042925300164e-15, -2.321738909615120e-18,  1.179961446623583e-17,  5.865014511907841e-01,
 -1.866592596441308e-02,  3.836433396922775e-04, -1.185508460603355e-06, -1.070618514070495e-07, -8.155916367899326e-10, -5.934681899240987e-11,  1.261788223161805e-11,
 -1.557504296520048e-14, -2.866059307370569e-14,  1.499658641159215e-16,  5.466828948851517e-17,  1.258364039149695e+00, -3.458216670861058e-02,  1.429908083026207e-04,
  3.575989932252657e-05, -7.788050927222357e-07, -5.694185932567616e-08,  2.385192836997714e-09,  8.972026649146322e-11, -6.262479666569056e-12, -1.209829176961742e-13,
  1.508767394588219e-14,  9.734315814353786e-17,  1.921681814614791e-02, -5.959293787046843e-04,  1.530967752378776e-05, -2.670503093069081e-07,  3.075911209080945e-09,
 -1.396329260725456e-10,  7.400463234509284e-12, -1.473378372520690e-14, -1.108259903925163e-14,  1.010463601567120e-16,  2.154636952235508e-17, -4.599485883972540e-19,
  1.769631214699027e-01, -5.454280821507456e-03,  1.362112171801782e-04, -2.089937920336670e-06,  1.095322026994418e-08, -8.116178420974044e-10,  6.079848709997691e-11,
  1.659704886286922e-13, -1.247980253905436e-13,  1.412520820658888e-15,  2.251364195007868e-16, -5.336246158121757e-18,  5.178432394348912e-01, -1.568399351085109e-02,
  3.586519014191657e-04, -2.998225184886397e-06, -1.128440510368711e-07,  1.135450713584581e-09,  1.637607183174197e-10,  6.581669233109766e-13, -5.004133598895244e-13,
  7.501552398434710e-15,  9.644039797282046e-16, -3.084989023169026e-17,  1.124656392441552e+00, -3.199741584574869e-02,  4.711581364786179e-04,  1.773311866818210e-05,
 -1.261379257859473e-06,  7.680273204884732e-09,  2.193485642317833e-09, -7.957323349075522e-11, -2.183034803303644e-12,  2.238002555965459e-13, -1.641385115514631e-15,
 -4.175326870425389e-16,  1.705873596630133e-02, -4.855865955622129e-04,  1.233753618778191e-05, -2.312971918144068e-07,  1.850397210760623e-09,  8.820966410300835e-13,
  3.425475616126663e-12, -2.034530120048153e-13,  6.271572857604875e-16,  3.314143005793955e-16, -9.019609536516108e-18, -3.881230186370537e-19,  1.571697453291838e-01,
 -4.462668894897075e-03,  1.118917100180687e-04, -1.970710182567798e-06,  7.733341072622266e-09,  3.456927479730333e-10,  2.587863981382617e-11, -1.928646068416284e-12,
  5.811394730755811e-15,  3.499194757496852e-15, -1.034646597685331e-16, -3.780747741030705e-18,  4.605784225380644e-01, -1.298635712466313e-02,  3.132311190397728e-04,
 -4.429617075576822e-06, -5.691814245080819e-08,  3.913272938111186e-09,  3.284696505773867e-11, -6.867518276129792e-12,  5.929991517386268e-14,  1.318560346408727e-14,
 -5.020387960314474e-16, -1.154483701181401e-17,  1.005102488514910e+00, -2.769383435277771e-02,  5.749744024048506e-04,  8.261472156330950e-07, -7.748009589921811e-07,
  3.204614696094461e-08, -3.304936243984364e-11, -5.558231735424356e-11,  2.306207875562392e-12,  9.783879104003058e-15, -4.604095776497666e-15,  1.610053044238217e-16,
  1.529694939937072e-02, -3.974639479405957e-04,  9.749716463863378e-06, -1.988661723377549e-07,  2.276623189631232e-09,  2.509355027100077e-11, -7.854438061075421e-13,
 -7.537179941066335e-14,  4.914323418465945e-15, -6.344168783209626e-17, -5.621996938038153e-18,  2.974996629025183e-19,  1.409633973051757e-01, -3.659366542746519e-03,
  8.927641622748220e-05, -1.774728391244835e-06,  1.696865112196626e-08,  4.236886419273507e-10, -1.307741140478167e-11, -6.357899831876302e-13,  4.877714939115617e-14,
 -7.140814374047421e-16, -5.571067833136553e-17,  3.191592976818925e-18,  4.132940178252276e-01, -1.070267887399772e-02,  2.571730881680448e-04, -4.728690428513634e-06,
  1.609270394635659e-08,  2.901608597570420e-09, -9.031309631756573e-11, -1.340322913187449e-12,  1.808182739490094e-13, -3.868418521101302e-15, -1.732358485130275e-16,
  1.325366550098940e-17,  9.033533764130725e-01, -2.321873362418486e-02,  5.304226300558887e-04, -6.871049925470798e-06, -2.269043882071715e-07,  2.031547099134405e-08,
 -6.768189171875289e-10,  1.872887383186624e-12,  9.654062403751080e-13, -4.813244455440953e-14,  7.084838588476325e-16,  4.299257346722624e-17,  1.384888842331031e-02,
 -3.283634545706902e-04,  7.593850484432724e-06, -1.598848637885621e-07,  2.498165117818070e-09, -4.394897795466978e-12, -1.214080338483219e-12,  2.423177339558478e-14,
  1.195967801162144e-15, -9.113260192318186e-17,  2.173448858947619e-18,  3.758990352468499e-20,  1.276266769930878e-01, -3.025212031895325e-03,  6.982328784470259e-05,
 -1.455777953177422e-06,  2.163653110032964e-08,  3.954806072786602e-11, -1.456213235454524e-11,  3.170163154311951e-13,  1.018369296652985e-14, -9.048764583330315e-16,
  2.344293540010914e-17,  3.079187293825490e-19,  3.742496937546811e-01, -8.864270972016246e-03,  2.034965649238674e-04, -4.127636097291488e-06,  5.214748222683084e-08,
  7.850570238686667e-10, -7.185265352468622e-11,  1.782935660662732e-12,  2.060137272856821e-14, -3.224830555125239e-15,  1.044534976669308e-16,  1.888816843474528e-19,
  8.183896986237236e-01, -1.934145591912524e-02,  4.368964584047678e-04, -8.071109232970804e-06,  3.335404143428916e-08,  6.838654348052131e-09, -4.022009045390150e-10,
  1.219348949080071e-11, -9.315634301427952e-14, -1.151258731854996e-14,  6.920232480382470e-16, -1.864326201553919e-17,  1.264572413104089e-02, -2.746232439849380e-04,
  5.907772335653531e-06, -1.219247616051671e-07,  2.185606527177096e-09, -2.347440557225438e-11, -3.693118141189111e-13,  2.715493119084069e-14, -5.329280754191711e-16,
 -1.225941970930428e-17,  1.235389428600753e-18, -4.065846225705694e-20,  1.165406147575937e-01, -2.530664657875528e-03,  5.440478155134982e-05, -1.118894881862914e-06,
  1.973817216762817e-08, -1.901343185842904e-10, -4.721485225745956e-12,  3.009363513111011e-13, -6.280782752781395e-15, -9.677948757659161e-17,  1.204655062583647e-17,
 -4.217609211883325e-19,  3.417557902599624e-01, -7.419570536778117e-03,  1.592328825466859e-04, -3.244149388874242e-06,  5.467837593897149e-08, -3.456898161603089e-10,
 -2.477422930200274e-11,  1.317737247549106e-12, -3.089453290007617e-14, -1.036788732550909e-16,  4.000769588938738e-17, -1.660687701763874e-18,  7.474236934670170e-01,
 -1.621709832395057e-02,  3.463548440125565e-04, -6.861040699784704e-06,  9.846065854075846e-08,  7.162288523566713e-10, -1.354784422478021e-10,  6.441251340574062e-12,
 -1.864131620235480e-13,  2.323115738728969e-15,  9.165374817331143e-17, -7.099799270759223e-18,  1.163327890544104e-02, -2.326566458063959e-04,  4.638057381852133e-06,
 -9.097121202207135e-08,  1.678365711207850e-09, -2.528670488918442e-11,  1.357398503632944e-13,  9.513917687297533e-15, -4.473088982738998e-16,  9.215584151053581e-18,
  5.713714876767785e-20, -1.224467939453866e-20,  1.072105599561685e-01, -2.144081079006161e-03,  4.273428309454940e-05, -8.372212438047682e-07,  1.536328986285693e-08,
 -2.257495708144179e-10,  8.443599731743831e-13,  1.059638440172495e-13, -4.776977856288126e-15,  1.025003163408601e-16,  2.545789851381194e-19, -1.161424662655863e-19,
  3.143987845735825e-01, -6.287235236847075e-03,  1.252489258383060e-04, -2.446337068034212e-06,  4.424557167662985e-08, -6.047045852686111e-10, -7.806015455910775e-13,
  4.607458369461883e-13, -1.956242826150872e-14,  4.581454628465502e-16, -2.075113073221425e-18, -3.511948340665870e-19,  6.876136541454679e-01, -1.374860821949730e-02,
  2.735158600502915e-04, -5.297403165103666e-06,  9.177668217392092e-08, -9.542607740332023e-10, -2.367827309698773e-11,  2.085670401195777e-12, -8.634478554605561e-14,
  2.419703556429276e-15, -3.866241324320705e-17, -3.826086014739742e-19,  1.077054311830523e-02, -1.994992301199214e-04,  3.691596079859108e-06, -6.792083726128052e-08,
  1.219721265940420e-09, -2.014686224598134e-11,  2.503916106945748e-13,  2.408126415240046e-16, -1.536433646074954e-16,  5.966205109118923e-18, -1.285291941628039e-19,
  5.224853108424891e-22,  9.925981624677262e-02, -1.838546709357312e-03,  3.401917785994434e-05, -6.256866437512883e-07,  1.121612123025952e-08, -1.838560574101502e-10,
  2.199420296196070e-12,  7.540400723220428e-15, -1.633451823976788e-15,  6.230174673272093e-17, -1.379238454547804e-18,  8.367878468453355e-21,  2.910836961233226e-01,
 -5.391541721614181e-03,  9.974738111351394e-05, -1.832879720138158e-06,  3.270438156893306e-08, -5.252161677519471e-10,  5.606838730607385e-12,  6.430657338155292e-14,
 -6.553231112043981e-15,  2.438568771704437e-16, -5.751941871686592e-18,  5.906104645300749e-20,  6.366260464543306e-01, -1.179136549486373e-02,  2.180705184805822e-04,
 -3.997372153797267e-06,  7.042733115576143e-08, -1.064337509992166e-09,  6.979189308830915e-12,  4.170221514779425e-13, -2.655552855729628e-14,  9.913830968890359e-16,
 -2.694572698648183e-17,  4.897744911356385e-19,  1.002688039701212e-02, -1.729234208057975e-04,  2.981387074506633e-06, -5.130777826097249e-08,  8.752723618424690e-10,
 -1.444705016540184e-11,  2.140276083807566e-13, -2.138337512592694e-15, -1.910432523452017e-17,  1.936592650436905e-18, -6.707741968868418e-20,  1.483783119549280e-21,
  9.240634610154914e-02, -1.593636282006058e-03,  2.747562221235324e-05, -4.727891056238029e-07,  8.060927888690143e-09, -1.327247515865895e-10,  1.946408234160460e-12,
 -1.834863052955154e-14, -2.360288305079445e-16,  2.010000507877899e-17, -6.897176390798874e-19,  1.554534648201640e-20,  2.709857562772174e-01, -4.673394510697259e-03,
  8.057032957941765e-05, -1.386057576104052e-06,  2.359818639821085e-08, -3.860715043622947e-10,  5.509228874194762e-12, -4.331251130562512e-14, -1.162943676779101e-15,
  7.698438831181155e-17, -2.611170704541908e-18,  6.161120187482664e-20,  5.926709152964853e-01, -1.022106368220317e-02,  1.761975719753443e-04, -3.029128267290815e-06,
  5.138120016331499e-08, -8.262076475884794e-10,  1.087175051478373e-11, -3.048855952559714e-14, -5.541499456314643e-15,  2.891818585346520e-16, -9.925368413678591e-18,
  2.611271963221746e-19,  9.379298826179976e-03, -1.513172734978656e-04,  2.441031745228436e-06, -3.935678978590625e-08,  6.327065676296230e-10, -1.004914843056098e-11,
  1.530529117272578e-13, -2.038906274421626e-15,  1.581440005715380e-17,  3.112846299468800e-19, -2.041789524667364e-20,  6.513489900911023e-22,  8.643832804219115e-02,
 -1.394518765535273e-03,  2.249612644275642e-05, -3.626952009127036e-07,  5.829787246578484e-09, -9.252118436628738e-11,  1.404678543814172e-12, -1.847315291755454e-14,
  1.310037615070730e-16,  3.460489808306014e-18, -2.087631956046207e-19,  6.621353120410431e-21,  2.534843071921869e-01, -4.089486344991405e-03,  6.597027867913524e-05,
 -1.063535321746403e-06,  1.708763086388999e-08, -2.706503882452903e-10,  4.075506806106803e-12, -5.177071266659375e-14,  2.711816598455466e-16,  1.474922393402214e-17,
 -7.752243735250450e-19,  2.443012208114661e-20,  5.543937955733300e-01, -8.944071855554053e-03,  1.442798143379185e-04, -2.325596068872734e-06,  3.732598143434564e-08,
 -5.882044461119857e-10,  8.665177034703208e-12, -9.925699834215520e-14, -8.341606340355056e-17,  6.080116095261528e-17, -2.752589528641921e-18,  8.786588038992348e-20,
  8.810319466144519e-03, -1.335201191709837e-04,  2.023453792537098e-06, -3.066006212207353e-08,  4.641548842058684e-10, -6.997863765513841e-12,  1.038800865702666e-13,
 -1.465890865424444e-15,  1.762698738458401e-17, -1.012961334814606e-19, -3.573901168307525e-21,  1.861888206629890e-22,  8.119469336535204e-02, -1.230502988109114e-03,
  1.864785524227732e-05, -2.825566293487131e-07,  4.277355407601628e-09, -6.447266918864154e-11,  9.561061260124263e-13, -1.344003884660756e-14,  1.591005401131171e-16,
 -7.929300660126243e-19, -3.811940380203625e-20,  1.883953464832919e-21,  2.381071174683491e-01, -3.608505195144553e-03,  5.468555903246494e-05, -8.285935028451039e-07,
  1.254184368844476e-08, -1.889318136077420e-10,  2.794663836716962e-12, -3.889598199745926e-14,  4.413795170528779e-16, -1.255758864977359e-18, -1.517240389783155e-19,
  6.840534418304219e-21,  5.207624811058554e-01, -7.892134587189759e-03,  1.196017914783771e-04, -1.812124318822582e-06,  2.742119070815119e-08, -4.124725275199039e-10,
  6.062005346678883e-12, -8.217813568877072e-14,  8.214201105488246e-16,  3.528059989315426e-18, -5.736825912903255e-19,  2.324553487303501e-20,  8.306449326648938e-03,
 -1.186877431635460e-04,  1.695876636452956e-06, -2.423064128093446e-08,  3.461167701637933e-10, -4.937575446085770e-12,  7.006042659275793e-14, -9.756157987066344e-16,
  1.281150709820960e-17, -1.398114064072457e-19,  5.591531860353443e-22,  3.343911844186373e-23,  7.655109557161774e-02, -1.093809916642523e-03,  1.562896285937636e-05,
 -2.233058205799098e-07,  3.189719238273594e-09, -4.550029949466257e-11,  6.454155653719835e-13, -8.976689114470522e-15,  1.173522559577757e-16, -1.257356007444131e-18,
  3.958676873528673e-21,  3.488835521407208e-22,  2.244895576932963e-01, -3.207647054107280e-03,  4.583261920519818e-05, -6.548512766046269e-07,  9.353668383071647e-09,
 -1.334046746702583e-10,  1.890870315528335e-12, -2.621819365631094e-14,  3.388260744915636e-16, -3.454499825846685e-18,  2.589000493209194e-21,  1.334188686885068e-21,
  4.909796133326624e-01, -7.015422925374039e-03,  1.002400997993955e-04, -1.432204635933434e-06,  2.045564592761947e-08, -2.916266438778285e-10,  4.125713219988145e-12,
 -5.676639900060172e-14,  7.117786628754364e-16, -6.247002240788038e-18, -4.626984200507902e-20,  4.760549250225207e-21,  7.857114560633918e-03, -1.061966115821931e-04,
  1.435349789037921e-06, -1.939993824172138e-08,  2.621874877399226e-10, -3.542050129932790e-12,  4.776848278679062e-14, -6.399813061002178e-16,  8.389999221498798e-18,
 -1.030015179186369e-19,  1.027473175315296e-21, -2.640054312306741e-24,  7.241008814335846e-02, -9.786933770998508e-04,  1.322798583508914e-05, -1.787870827379573e-07,
  2.416275249348529e-09, -3.264233052551113e-11,  4.401783926456302e-13, -5.895088444598286e-15,  7.717443994618011e-17, -9.427149540566274e-19,  9.210732179485957e-21,
 -1.520465362782432e-23,  2.123458659219130e-01, -2.870062674288357e-03,  3.879166391350053e-05, -5.243006368587559e-07,  7.085774971999022e-09, -9.571995190135767e-11,
  1.290485659417340e-12, -1.726656942089831e-14,  2.252436041283831e-16, -2.716376722910652e-18,  2.509081063429232e-20,  2.385949860465537e-23,  4.644202271948746e-01,
 -6.277094837656884e-03,  8.484096853093053e-05, -1.146691466416003e-06,  1.549693739623032e-08, -2.093219473563701e-10,  2.820554491018120e-12, -3.765275969340363e-14,
  4.868891541602420e-16, -5.679198000852897e-18,  4.424478439640275e-20,  4.394938530866044e-22,  7.453913372723769e-03, -9.557870270581625e-05,  1.225569126427454e-06,
 -1.571496432028335e-08,  2.015027016406668e-10, -2.583453489402676e-12,  3.310469417684461e-14, -4.232859901287848e-16,  5.370756006373632e-18, -6.651572069555239e-20,
  7.671146484001477e-22, -7.059258967396864e-24,  6.869424140507789e-02, -8.808401902284072e-04,  1.129467655767985e-05, -1.448269367117824e-07,  1.857019614359698e-09,
 -2.380861779077664e-11,  3.050789053488387e-13, -3.900385733302606e-15,  4.946723941999211e-17, -6.116851165481960e-19,  7.016407414408389e-21, -6.312545727928374e-23,
  2.014489769571584e-01, -2.583103784476276e-03,  3.312215025963107e-05, -4.247114502464807e-07,  5.445782845277371e-09, -6.981888935606045e-11,  8.945902093270754e-13,
 -1.143402163094086e-14,  1.448553770610088e-16, -1.784210411674169e-18,  2.018546249744867e-20, -1.708408769703211e-22,  4.405877142068609e-01, -5.649489045448064e-03,
  7.244123025869408e-05, -9.288830508230223e-07,  1.191037859507450e-08, -1.526955775401803e-10,  1.956208370137672e-12, -2.498648276284075e-14,  3.157197051150405e-16,
 -3.851582984087908e-18,  4.205211533881660e-20, -2.956952100574840e-22,  7.090085860912209e-03, -8.647732431279471e-05,  1.054758341588449e-06, -1.286481178795274e-08,
  1.569104489983956e-10, -1.913759829089089e-12,  2.333759721509737e-14, -2.844005135813740e-16,  3.456877367917401e-18, -4.165654631622929e-20,  4.890165413021208e-22,
 -5.324071079600089e-24,  6.534125705054707e-02, -7.969631379922211e-04,  9.720507923496365e-06, -1.185603349845810e-07,  1.446064847457363e-09, -1.763692291760784e-11,
  2.150743411467742e-13, -2.620890613633057e-15,  3.185257871438933e-17, -3.836453640663362e-19,  4.496163231218893e-21, -4.867479124639152e-23,  1.916161983475320e-01,
 -2.337130529445897e-03,  2.850583000177289e-05, -3.476835378217261e-07,  4.240648670527488e-09, -5.172090070722362e-11,  6.307028044694831e-13, -7.685126411670380e-15,
  9.336941606733309e-17, -1.123211801432018e-18,  1.310865172515656e-20, -1.398849056372224e-22,  4.190825097105042e-01, -5.111522594028522e-03,  6.234491007204811e-05,
 -7.604162538938743e-07,  9.274684348502273e-09, -1.131175671956632e-10,  1.379343567877063e-12, -1.680427773391087e-14,  2.040048426857233e-16, -2.447037439682806e-18,
  2.826948030798366e-20, -2.907919650711773e-22,  6.760131623556826e-03, -7.861681268896138e-05,  9.142726070932087e-07, -1.063251305792809e-08,  1.236504344900924e-10,
 -1.437977335115095e-12,  1.672206641123238e-14, -1.944198778291227e-16,  2.258581598785054e-18, -2.616111391569271e-20,  3.001901936920380e-22, -3.350809272648789e-24,
  6.230044413803077e-02, -7.245217430483856e-04,  8.425810714123292e-06, -9.798777885779692e-08,  1.139545361949036e-09, -1.325219708463355e-11,  1.541079483762108e-13,
 -1.791727478508702e-15,  2.081374746457222e-17, -2.410489150739119e-19,  2.764487000049130e-21, -3.080419115123993e-23,  1.826988766368180e-01, -2.124692855383342e-03,
  2.470907185452330e-05, -2.873536001262634e-07,  3.341768068979043e-09, -3.886263735431341e-11,  4.519262951236660e-13, -5.254184281055010e-15,  6.102991355876995e-17,
 -7.065409627572612e-19,  8.092421847177547e-21, -8.978234691265169e-23,  3.995794948635485e-01, -4.646901576135187e-03,  5.404104618223807e-05, -6.284691265801553e-07,
  7.308756897811383e-09, -8.499606162660199e-11,  9.883938947474781e-13, -1.149070651743404e-14,  1.334412814794731e-16, -1.543519252953969e-18,  1.762434892352293e-20,
 -1.935018993617448e-22,  6.459529431503712e-03, -7.178141222569340e-05,  7.976697347572462e-07, -8.864091232412775e-09,  9.850203525526522e-11, -1.094599788752738e-12,
  1.216355732918061e-14, -1.351578247964741e-16,  1.501462416608123e-18, -1.666391376038238e-20,  1.843483848617640e-22, -2.019032904920239e-24,  5.953013564162385e-02,
 -6.615276316391406e-04,  7.351214667745622e-06, -8.169024670654526e-08,  9.077812127739000e-10, -1.008768045897936e-11,  1.120976162129620e-13, -1.245592443295490e-15,
  1.383708351704340e-17, -1.535634256483547e-19,  1.698550923724087e-21, -1.859263804542860e-23,  1.745748213877676e-01, -1.939959768118644e-03,  2.155777025425388e-05,
 -2.395603510666936e-07,  2.662109494689955e-09, -2.958257472718872e-11,  3.287309419450682e-13, -3.652731618846110e-15,  4.057654484046735e-17, -4.502683545755215e-19,
  4.978377019480553e-21, -5.441989583725677e-23,  3.818114278002387e-01, -4.242873073203243e-03,  4.714885555784370e-05, -5.239408436673097e-07,  5.822281620995657e-09,
 -6.469982528243710e-11,  7.189633088155087e-13, -7.988743996202267e-15,  8.873812361471013e-17, -9.844634409964539e-19,  1.087460427817861e-20, -1.184942703372203e-22,
  6.184528581092433e-03, -6.580030492982884e-05,  7.000824832290163e-07, -7.448529010402189e-09,  7.924863477324364e-11, -8.431655701017967e-13,  8.970831138050010e-15,
 -9.544337782756002e-17,  1.015378479566775e-18, -1.079901273560115e-20,  1.147315666802850e-22, -1.214623974037844e-24,  5.699576559190019e-02, -6.064065686621628e-04,
  6.451863967530079e-06, -6.864461984878101e-08,  7.303445270105891e-10, -7.770497898400011e-12,  8.267393712807180e-14, -8.795924355580622e-16,  9.357554958288997e-18,
 -9.952060676893225e-20,  1.057281192406442e-21, -1.119112663245586e-23,  1.671426663289858e-01, -1.778314752207387e-03,  1.892038355985192e-05, -2.013034594036600e-07,
  2.141768422530750e-09, -2.278733638352250e-11,  2.424449986655065e-13, -2.579440342043212e-15,  2.744121769441083e-17, -2.918373162914957e-19,  3.100034919792037e-21,
 -3.279941564919644e-23,  3.655566110286192e-01, -3.889340336818551e-03,  4.138064472031833e-05, -4.402694533103420e-07,  4.684247383935703e-09, -4.983802689159218e-11,
  5.302495046512435e-13, -5.641455729267370e-15,  6.001535251963981e-17, -6.382196314549941e-19,  6.777641622442863e-21, -7.164025088600175e-23,  5.931991425210015e-03,
 -6.053682869645996e-05,  6.177870744511312e-07, -6.304606254688072e-09,  6.433941584228175e-11, -6.565929439721519e-13,  6.700620124765667e-15, -6.838046160668985e-17,
  6.978152782881132e-19, -7.120523028553551e-21,  7.263415496400808e-23, -7.400007576400741e-25,  5.466841786423045e-02, -5.578990949461465e-04,  5.693440788465255e-06,
 -5.810238492955263e-08,  5.929432153045360e-10, -6.051070326177980e-12,  6.175199261799623e-14, -6.301848299732782e-16,  6.430963811237108e-18, -6.562147595795183e-20,
  6.693739977995558e-22, -6.819259762587802e-24,  1.603176136143266e-01, -1.636064386598100e-03,  1.669627320698810e-05, -1.703878776851394e-07,  1.738832856318217e-09,
 -1.774503787503778e-11,  1.810905056797730e-13, -1.848044826685960e-15,  1.885905154541884e-17, -1.924359458732264e-19,  1.962882299563249e-21, -1.999435728569642e-23,
  3.506295837455500e-01, -3.578225510725565e-03,  3.651630780050259e-05, -3.726541910681923e-07,  3.802989736880960e-09, -3.881005323972292e-11,  3.960617803138624e-13,
 -4.041842906592635e-15,  4.124630680490051e-17, -4.208656508185023e-19,  4.292580982263187e-21, -4.371266421838415e-23,  5.699273011839571e-03, -5.588059719111400e-05,
  5.479016597179379e-07, -5.372101296810628e-09,  5.267272282489766e-11, -5.164488730838736e-13,  5.063709982896943e-15, -4.964892719224722e-17,  4.867978110789218e-19,
 -4.772840374341142e-21,  4.679104003641474e-23, -4.585126231174442e-25,  5.252371694427171e-02, -5.149879052022303e-04,  5.049386409200499e-06, -4.950854737457921e-08,
  4.854245757897753e-10, -4.759521845494588e-12,  4.666645510713702e-14, -4.575576721886145e-16,  4.486260712690045e-18, -4.398579112792636e-20,  4.312176121043767e-22,
 -4.225503008246998e-24,  1.540281809430155e-01, -1.510225377425429e-03,  1.480755454363103e-05, -1.451860594934923e-07,  1.423529573448272e-09, -1.395751354281421e-11,
  1.368514930408773e-13, -1.341808486440452e-15,  1.315615577787649e-17, -1.289899776377783e-19,  1.264549900739516e-21, -1.239087264965246e-23,  3.368740074877729e-01,
 -3.303003852854682e-03,  3.238550380620732e-05, -3.175354626113415e-07,  3.113392036607504e-09, -3.052638467180691e-11,  2.993069782790180e-13, -2.934659781356538e-15,
  2.877370660790475e-17, -2.821114494319835e-19,  2.765614956813780e-21, -2.709705348547123e-23,  5.484128012618022e-03, -5.174166212222630e-05,  4.881723389753814e-07,
 -4.605809375896517e-09,  4.345489963281544e-11, -4.099883728338701e-13,  3.868158952403615e-15, -3.649530301715054e-17,  3.443253842555800e-19, -3.248615095222184e-21,
  3.064892670040990e-23, -2.890989930119902e-25,  5.054097019435936e-02, -4.768440483353439e-04,  4.498929196600692e-06, -4.244650632737339e-08,  4.004743839032513e-10,
 -3.778396507170913e-12,  3.564842133476951e-14, -3.363356946546431e-16,  3.173255252726089e-18, -2.993878172828726e-20,  2.824559181442331e-22, -2.664281494003593e-24,
  1.482136862170673e-01, -1.398366788026908e-03,  1.319331381438416e-05, -1.244763039886156e-07,  1.174409285040170e-09, -1.108031903484061e-11,  1.045406112339023e-13,
 -9.863196494664611e-16,  9.305713663849812e-18, -8.779677480096942e-20,  8.283121430145571e-22, -7.813020714392123e-24,  3.241571648434307e-01, -3.058358677849347e-03,
  2.885500867102668e-05, -2.722412944491950e-07,  2.568542716165391e-09, -2.423369185654237e-11,  2.286400721514797e-13, -2.157173025951555e-15,  2.035245857475921e-17,
 -1.920194572394276e-19,  1.811583375411719e-21, -1.708729951916591e-23,  5.284637984385664e-03, -4.804613457755309e-05,  4.368191453536185e-07, -3.971411382476190e-09,
  3.610672410892135e-11, -3.282700779993858e-13,  2.984520079508868e-15, -2.713424147293453e-17,  2.466952095778175e-19, -2.242864281233867e-21,  2.039115788375119e-23,
 -1.853664682637199e-25,  4.870249750594553e-02, -4.427865742833131e-04,  4.025665220586833e-06, -3.659998159222183e-08,  3.327546079886218e-10, -3.025291931385022e-12,
  2.750492694376825e-14, -2.500654403879227e-16,  2.273509123672925e-18, -2.066992756291347e-20,  1.879220442493418e-22, -1.708309296357920e-24,  1.428222817166917e-01,
 -1.298491701476703e-03,  1.180544575073436e-05, -1.073311051686454e-07,  9.758179723424027e-10, -8.871805730485671e-12,  8.065944505808843e-14, -7.333282362373089e-16,
  6.667168363330252e-18, -6.061548945780923e-20,  5.510894633777363e-22, -5.009676336286108e-24,  3.123656600102922e-01, -2.839922542017846e-03,  2.581961168326953e-05,
 -2.347431444352136e-07,  2.134204980562270e-09, -1.940346715282307e-11,  1.764097341877573e-13, -1.603857278630486e-15,  1.458171851480194e-17, -1.325716852305880e-19,
  1.205281965326334e-21, -1.095654375391194e-23,  5.099153962625831e-03, -4.473286303823929e-05,  3.924237334789464e-07, -3.442578367174169e-09,  3.020037985151525e-11,
 -2.649360001894897e-13,  2.324178847925885e-15, -2.038910241162431e-17,  1.788655216463343e-19, -1.569115695868985e-21,  1.376519565240736e-23, -1.207459384554337e-25,
  4.699310224862761e-02, -4.122519190511614e-04,  3.616523205090257e-06, -3.172632918975679e-08,  2.783225508997539e-10, -2.441613773070357e-12,  2.141931289743188e-14,
 -1.879031660859207e-16,  1.648400064766433e-18, -1.446075439613639e-20,  1.268581406917348e-22, -1.112777533815291e-24,  1.378094026343401e-01, -1.208947440812125e-03,
  1.060561824307457e-05, -9.303889856618083e-08,  8.161934974236644e-10, -7.160143072582966e-12,  6.281310604208116e-14, -5.510345519620821e-16,  4.834007881085079e-18,
 -4.240681610421519e-20,  3.720171724342165e-22, -3.263267490728331e-24,  3.014020255949239e-01, -2.644080886595293e-03,  2.319547694166236e-05, -2.034847546750202e-07,
  1.785091355868909e-09, -1.565990116997067e-11,  1.373781253463151e-13, -1.205163991518892e-15,  1.057242624568498e-17, -9.274765682882221e-20,  8.136359222090866e-22,
 -7.137056130592286e-24,  4.926250743949047e-03, -4.175088635961369e-05,  3.538464853731692e-07, -2.998914421419439e-09,  2.541635448904787e-11, -2.154083060401899e-13,
  1.825625241018302e-15, -1.547251158071839e-17,  1.311323947540160e-19, -1.111371153657051e-21,  9.419069655544237e-24, -7.982237618709657e-26,  4.539964994380432e-02,
 -3.847704317321329e-04,  3.261000587418232e-06, -2.763758322921367e-08,  2.342336305287720e-10, -1.985173349369175e-12,  1.682471136320003e-14, -1.425925406471038e-16,
  1.208498130429133e-18, -1.024224379847706e-20,  8.680484984120927e-23, -7.356319759747673e-25,  1.331365315161022e-01, -1.128356733458918e-03,  9.563032050208228e-06,
 -8.104846568595986e-08,  6.869007397989958e-10, -5.821610838837632e-12,  4.933922876847151e-14, -4.181590893497117e-16,  3.543975545467840e-18, -3.003584395866655e-20,
  2.545591445417994e-22, -2.157273602141998e-24,  2.911820203307116e-01, -2.467821487918156e-03,  2.091524363116060e-05, -1.772605588743811e-07,  1.502316027791399e-09,
 -1.273240624730002e-11,  1.079094982407926e-13, -9.145529555938108e-16,  7.751005258517335e-18, -6.569119274266899e-20,  5.567445489017409e-22, -4.718156309669763e-24,
  4.764690171613226e-03, -3.905746177257879e-05,  3.201646413873639e-07, -2.624476679809672e-09,  2.151354944446755e-11, -1.763524184668493e-13,  1.445608758160354e-15,
 -1.185004831977708e-17,  9.713806984399611e-20, -7.962671630577133e-22,  6.527217445138764e-24, -5.350173873605931e-26,  4.391072990907479e-02, -3.599482008394772e-04,
  2.950593341442042e-06, -2.418681645374831e-08,  1.982659155194697e-10, -1.625239656136080e-12,  1.332253167515087e-14, -1.092084170064105e-16,  8.952111038781938e-19,
 -7.338288753511076e-21,  6.015393876987244e-23, -4.930646601241290e-25,  1.287702060185688e-01, -1.055564416125400e-03,  8.652748730008865e-06, -7.092893568682860e-08,
  5.814237850467700e-10, -4.766088966942776e-12,  3.906892807383136e-14, -3.202586334885163e-16,  2.625247142891444e-18, -2.151986438252334e-20,  1.764041502494739e-22,
 -1.445934381902446e-24,  2.816324589495102e-01, -2.308617896053782e-03,  1.892436905127917e-05, -1.551282022898408e-07,  1.271628083369063e-09, -1.042388139952756e-11,
  8.544739207935430e-14, -7.004355217590337e-16,  5.741660516979392e-18, -4.706595168501718e-20,  3.858123311230593e-22, -3.162393049658216e-24,  4.613391421124045e-03,
 -3.661652418068206e-05,  2.906256418944388e-07, -2.306698017260576e-09,  1.830828039862145e-11, -1.453129662598150e-13,  1.153350161950456e-15, -9.154149351533943e-18,
  7.265655567923222e-20, -5.766756523613066e-22,  4.577079000513030e-24, -3.632601624135501e-26,  4.251638141441465e-02, -3.374528553999658e-04,  2.678365981047071e-06,
 -2.125821196542422e-08,  1.687265964265787e-10, -1.339184329704370e-12,  1.062911661154637e-14, -8.436338255853552e-17,  6.695928334349203e-19, -5.314563570487260e-21,
  4.218173108571210e-23, -3.347755720975615e-25,  1.246812158494038e-01, -9.895957958655464e-04,  7.854429655046118e-06, -6.234067026538658e-08,  4.947983927311581e-10,
 -3.927218754731034e-12,  3.117036630219120e-14, -2.473994437092109e-16,  1.963611337865441e-18, -1.558519858258079e-20,  1.236998382478157e-22, -9.817445271474647e-25,
  2.726894558157242e-01, -2.164338366559126e-03,  1.717837072558235e-05, -1.363448642527577e-07,  1.082170265449785e-09, -8.589193951959153e-12,  6.817250029679730e-14,
 -5.410856736765902e-16,  4.294601263096927e-18, -3.408628386414610e-20,  2.705430898398630e-22, -2.147166844469433e-24,  };
  constexpr double w[1536] = {  6.705271744302512e-01, -2.619524415748476e-02,  1.170505443615014e-03, -5.212507391660261e-05,  2.226764042968755e-06,
 -9.101956829896582e-08,  3.564981193444281e-09, -1.345525555824187e-10,  4.896995955161307e-12, -1.718629076719417e-13,  5.885797931863237e-15, -1.967508214907542e-16,
  4.923850774034377e-01, -6.102048378251209e-02,  5.984054190981936e-03, -4.750345201718488e-04,  3.245346093385506e-05, -1.967662395491961e-06,  1.078804139517892e-07,
 -5.416181691060193e-09,  2.512770251927413e-10, -1.084557412526323e-11,  4.377427639174442e-13, -1.657383407187138e-14,  2.766459366018412e-01, -7.159779222560791e-02,
  1.107747989912342e-02, -1.258604694679263e-03,  1.147622517070151e-04, -8.805172950913010e-06,  5.855572174689868e-07, -3.444164597383306e-08,  1.818386367229415e-09,
 -8.714920993381575e-11,  3.825389293701088e-12, -1.547007429322682e-13,  1.058038027849112e-01, -3.920842516813883e-02,  7.890444304068555e-03, -1.099085682206082e-03,
  1.176251999607948e-04, -1.024916140773799e-05,  7.544081954652198e-07, -4.812062384170294e-08,  2.710097375579992e-09, -1.367042060000506e-10,  6.246447395396613e-12,
 -2.605704157434666e-13,  5.812170347845984e-01, -1.884095045028581e-02,  7.108935133815364e-04, -2.743364050767291e-05,  1.028863902264230e-06, -3.739266091795442e-08,
  1.308257239661402e-09, -4.416008018103575e-11,  1.470378443112132e-12, -4.686515812469304e-14,  1.433168107488489e-15, -4.392336913137117e-17,  3.173671952467840e-01,
 -2.940190999835824e-02,  2.446540566526668e-03, -1.688073575877398e-04,  1.022073143214845e-05, -5.576050113386260e-07,  2.786451336262093e-08, -1.288892697839561e-09,
  5.558759344650922e-11, -2.249855891057696e-12,  8.580542645576780e-14, -3.088702820329786e-15,  1.029786936323241e-01, -2.184924851446969e-02,  2.978100763057629e-03,
 -3.061361594409207e-04,  2.575619649355683e-05, -1.849489737775504e-06,  1.163867702712915e-07, -6.535094165133102e-09,  3.317146778930152e-10, -1.537428320723965e-11,
  6.558077563139172e-13, -2.587950045208975e-14,  2.225743561776223e-02, -7.753079918417320e-03,  1.488587521594949e-03, -1.998624881883918e-04,  2.076936118246708e-05,
 -1.766722550973481e-06,  1.274690651375241e-07, -7.994829740360994e-09,  4.438280705641113e-10, -2.211165542989846e-11,  9.994855008422408e-13, -4.130033654237445e-14,
  5.154745311749055e-01, -1.423827729636185e-02,  4.603523377502005e-04, -1.559013012158877e-05,  5.168899354955420e-07, -1.675528854931338e-08,  5.383097934469455e-10,
 -1.593686641414683e-11,  4.782781609550726e-13, -1.485876292251713e-14,  4.008553071464174e-16, -1.071037884055932e-17,  2.291195283556284e-01, -1.581276057967675e-02,
  1.125196897471922e-03, -6.758008985489504e-05,  3.623130076320198e-06, -1.773270477183401e-07,  8.032417734945108e-09, -3.409554707202846e-10,  1.358932800888897e-11,
 -5.114370365351589e-13,  1.831736764540624e-14, -6.233072690515878e-16,  4.709727932749992e-02, -7.778028068040335e-03,  9.185867091586822e-04, -8.394942134161464e-05,
  6.423227395483094e-06, -4.262016380318456e-07,  2.509035836137103e-08, -1.331627128043510e-09,  6.441521407934181e-11, -2.864711089033830e-12,  1.179445001130080e-13,
 -4.514520507255497e-15,  5.316570847197180e-03, -1.680627113769757e-03,  3.018639912027896e-04, -3.852097526489689e-05,  3.847235932986064e-06, -3.169923384167838e-07,
  2.228149137525273e-08, -1.367453661304863e-09,  7.453506994287025e-11, -3.655799816504111e-12,  1.630404248783837e-13, -6.658924154739529e-15,  4.648720720916946e-01,
 -1.118474421985909e-02,  3.137559782297879e-04, -9.424782222104056e-06,  2.820158116914545e-07, -7.863549692092581e-09,  2.437232469288417e-10, -6.805555899893103e-12,
  1.495897234182061e-13, -5.000950223262164e-15,  1.518536027909813e-16, -2.280219823843866e-18,  1.798410766960742e-01, -9.284178667578850e-03,  5.718165823268733e-04,
 -3.004690148406809e-05,  1.427741348988546e-06, -6.299872177348453e-08,  2.570360991318215e-09, -9.965916149618473e-11,  3.690721706943381e-12, -1.280268619779927e-13,
  4.255734501977686e-15, -1.373871871414595e-16,  2.612206165572552e-02, -3.196404090343102e-03,  3.258240934849099e-04, -2.610188400080382e-05,  1.793730902156188e-06,
 -1.088669012141181e-07,  5.927727817068764e-09, -2.944062070938359e-10,  1.345780287876351e-11, -5.693730716294554e-13,  2.245705102785987e-14, -8.285571528078032e-16,
  1.515742331469163e-03, -4.105844334877702e-04,  6.727011894579109e-05, -8.004806072773394e-06,  7.578512630359470e-07, -5.985717326133854e-08,  4.065608261868069e-09,
 -2.425847575744723e-10,  1.291528260670962e-11, -6.210092984032295e-13,  2.723078979604575e-14, -1.096113081274851e-15,  4.245316914924495e-01, -9.060553773740886e-03,
  2.234141762047887e-04, -5.909689215595607e-06,  1.700332253808654e-07, -3.888158269307225e-09,  1.006189088573126e-10, -3.869131297328073e-12,  6.232180271790907e-14,
 -2.034393284573740e-16,  9.219040216286547e-17, -1.754893171368385e-18,  1.500145272259918e-01, -5.841428359421938e-03,  3.154811621917253e-04, -1.468469695274577e-05,
  6.130209088295546e-07, -2.477281651536125e-08,  9.202921906677667e-10, -3.148287130806662e-11,  1.096537261449993e-12, -3.655057635669560e-14,  1.059165422613046e-15,
 -3.194339041127722e-17,  1.708623014288580e-02, -1.481112578607899e-03,  1.320071650833187e-04, -9.211595569556585e-06,  5.604194652544080e-07, -3.100354260326018e-08,
  1.549295703199853e-09, -7.105055596674955e-11,  3.051761591311806e-12, -1.221245708754554e-13,  4.557185278518328e-15, -1.613036457803730e-16,  5.450298601003190e-04,
 -1.158460717165786e-04,  1.688889029401667e-05, -1.829767843028840e-06,  1.613260566369096e-07, -1.205803105873196e-08,  7.830762292118488e-10, -4.504462255651326e-11,
  2.327250688890785e-12, -1.090979791840230e-13,  4.681952344281987e-15, -1.850816086887930e-16,  3.914733385633112e-01, -7.515880009516160e-03,  1.665892841437367e-04,
 -3.712711078191435e-06,  1.088560195803441e-07, -2.534406443644817e-09,  2.293562316883874e-11, -1.506151892184105e-12,  9.139914660381242e-14,  7.142090980100122e-16,
 -6.990897402503458e-17, -4.452053323230884e-18,  1.307745280223483e-01, -3.886805637493668e-03,  1.849758110311745e-04, -7.881480756769350e-06,  2.832495683014076e-07,
 -1.027699369208299e-08,  3.781216024794603e-10, -1.131655885148828e-11,  3.076896908785680e-13, -1.159415414454323e-14,  3.774477152949552e-16, -5.648699040144421e-18,
  1.274010742267395e-02, -7.514785539118597e-04,  5.988700862258708e-05, -3.704967490377507e-06,  1.945060855370311e-07, -9.737878365690922e-09,  4.544511613555913e-10,
 -1.890232034148617e-11,  7.416673619460595e-13, -2.870001851468706e-14,  1.016402833247943e-15, -3.243245744950549e-17,  2.569311931570322e-04, -3.802094513950407e-05,
  4.880462274821673e-06, -4.704630522543966e-07,  3.772093823283907e-08, -2.630278707285091e-09,  1.614924473256595e-10, -8.849157469132181e-12,  4.398992352705131e-13,
 -2.000125007258956e-14,  8.344612683458330e-16, -3.219253310710572e-17,  3.638299898625301e-01, -6.335471754127187e-03,  1.308863996167826e-04, -2.354951280484169e-06,
  6.197052084442418e-08, -2.162421433519883e-09,  2.009797671402873e-11,  1.033793045474617e-12,  4.021298724397528e-14, -3.526543996443010e-15, -6.055534607676027e-17,
  5.844562220603064e-18,  1.176795618396979e-01, -2.721151760717195e-03,  1.121493126460589e-04, -4.592454888668778e-06,  1.472510498611027e-07, -4.184079660301166e-09,
  1.546244044992549e-10, -5.666350303658012e-12,  1.087202990405431e-13, -1.013120984160146e-15,  1.350383504618252e-16, -7.049714981512192e-18,  1.046993585746358e-02,
 -4.089994901138128e-04,  2.919505364892107e-05, -1.699954610033434e-06,  7.659416000489591e-08, -3.230209809915915e-09,  1.453923135713889e-10, -5.957891645089925e-12,
  1.960348252212228e-13, -6.406248484794305e-15,  2.613973942408017e-16, -8.865841918112225e-18,  1.577171435808397e-04, -1.425517819376695e-05,  1.626101954577813e-06,
 -1.395160693627088e-07,  9.862034305431748e-09, -6.261642819648417e-10,  3.621132577961831e-11, -1.875255865141829e-12,  8.780177248888195e-14, -3.834878775948701e-15,
  1.569644871844588e-16, -5.856419057046874e-18,  3.404230524979677e-01, -5.387624787345264e-03,  1.072636330969590e-04, -1.672303181097782e-06,  2.612707521329443e-08,
 -1.307657193271454e-09,  4.783572107704964e-11,  3.701220676074688e-13, -6.409395296419758e-14, -7.654942525688825e-16,  1.487509792385701e-16, -3.173810520096386e-19,
  1.082898336920591e-01, -2.009632424639443e-03,  6.893680192058890e-05, -2.751314922779131e-06,  8.980477895790060e-08, -1.995012748830646e-09,  4.321334577347408e-11,
 -2.306281155470817e-12,  1.007321660444164e-13, -8.909968294445150e-16, -7.543776520455540e-17, -2.235533067538874e-19,  9.196061935428015e-03, -2.401189088891292e-04,
  1.450177866763450e-05, -8.478107141660391e-07,  3.633957172046028e-08, -1.191288919861762e-09,  4.231068316694012e-11, -1.994941535916992e-12,  7.843009360199666e-14,
 -1.704911211585964e-15,  2.282504691651076e-17, -2.046449017751575e-18,  1.189436222934435e-04, -5.975683087785087e-06,  6.004609396575310e-07, -4.812064463676488e-08,
  3.000949774664703e-09, -1.638838038757092e-10,  8.662335596284410e-12, -4.370152419291923e-13,  1.955026137421747e-14, -7.684590698667264e-16,  2.915712779482567e-17,
 -1.145289053070709e-18,  3.204696003794971e-01, -4.604261504261864e-03,  8.904283394311872e-05, -1.401717381752221e-06,  1.112438762161666e-08, -2.558127773895475e-10,
  3.240563579555805e-11, -1.189383029236091e-12, -1.481127731202123e-14,  2.265405926852491e-15, -2.191351726491836e-17, -3.760497281538570e-18,  1.011760376356625e-01,
 -1.568524837502571e-03,  4.336267742110289e-05, -1.593261504476967e-06,  5.673270379483120e-08, -1.416706053360674e-09,  1.540031609529591e-11, -5.726298983559626e-14,
  3.193812326174879e-14, -2.152004212195149e-15,  3.025387259629842e-17,  2.328700720513885e-18,  8.415106626412259e-03, -1.564434977275097e-04,  7.168005614155225e-06,
 -4.163868177021526e-07,  1.938312842857683e-08, -6.154877854834406e-10,  1.307168390178721e-11, -3.736503541173337e-13,  2.535389708678452e-14, -1.216157683140808e-15,
  2.102500571649962e-17,  6.294646421742180e-19,  1.018873439415465e-04, -2.857673258249346e-06,  2.306398347750896e-07, -1.818375405798942e-08,  1.090990424238214e-09,
 -5.155210301493675e-11,  2.198749014510073e-12, -9.997189432946680e-14,  4.751172369533636e-15, -1.969105110847492e-16,  6.308433154664583e-18, -1.689023445111808e-19,
  3.033747444842759e-01, -3.956346822991414e-03,  7.322684668521130e-05, -1.233829617029074e-06,  1.108967161475776e-08,  1.322829094801162e-10,  2.247318038551139e-12,
 -7.295825923980120e-13,  2.943876568165536e-14,  5.089367181242122e-17, -4.815938551037991e-17,  1.541576223498301e-18,  9.549376728622098e-02, -1.284688716128925e-03,
  2.882163685126467e-05, -8.914023022640127e-07,  3.229976764547336e-08, -1.010669054885251e-09,  1.887353869769482e-11,  7.595508090387569e-14, -1.157788617516921e-14,
 -2.331391798349524e-16,  3.857703806562558e-17, -1.211436220905379e-18,  7.878709074245639e-03, -1.146511718727515e-04,  3.674387586895111e-06, -1.900503822834283e-07,
  9.689483381572092e-09, -3.693794542082597e-10,  8.739903482083183e-12, -7.050029086664825e-14, -3.292241980098620e-16, -2.302267341715806e-16,  1.892912252720024e-17,
 -5.487445458613747e-19,  9.309946274656476e-05, -1.652072236389738e-06,  9.042348899308348e-08, -6.820883102466310e-09,  4.272926515172188e-10, -2.029271764445106e-11,
  7.430556143680728e-13, -2.375798928935538e-14,  9.028760683170468e-16, -4.438387368248027e-17,  2.001223772792308e-18, -6.279103545893535e-20,  2.886317301231639e-01,
 -3.426546326184311e-03,  5.956776652035251e-05, -1.037411467965566e-06,  1.313984619594134e-08,  3.931273759686372e-11, -6.580575632173896e-12,  4.448253238487175e-15,
  1.280251300564623e-14, -5.968713297679812e-16,  7.220112424213777e-18,  5.395410497320202e-19,  9.075899182260219e-02, -1.089493266585733e-03,  2.063838461302404e-05,
 -5.117476216116463e-07,  1.656938757670495e-08, -5.737581333100631e-10,  1.607060442750799e-11, -2.340203179496822e-13, -4.575650668048536e-15,  3.365810967757669e-16,
 -3.429210708119899e-18, -4.146485519715362e-19,  7.467520143848974e-03, -9.223399087185855e-05,  2.115086675748526e-06, -8.347122879741478e-08,  4.216166318646458e-09,
 -1.881046346403792e-10,  6.142422963990029e-12, -1.138470888192596e-13, -5.581243501549722e-16,  8.853358035933724e-17, -8.458161125098773e-20, -1.980613937387197e-19,
  8.754976026633423e-05, -1.165348957425642e-06,  3.882972532107801e-08, -2.443969804964294e-09,  1.581229275793107e-10, -8.219313094363967e-12,  3.251709548043710e-13,
 -9.528686193789238e-15,  2.104451483185862e-16, -5.321961728120087e-18,  2.913496866403897e-19, -1.724106881210341e-20,  2.758048434056820e-01, -2.996219114557247e-03,
  4.838002143090214e-05, -8.288182434069152e-07,  1.252154626257667e-08, -8.797396674066483e-11, -3.396611876245623e-12,  1.503069505912825e-13, -1.002660302871268e-15,
 -1.654443375520039e-16,  9.031572257086406e-18, -2.054844203044636e-19,  8.669771003831263e-02, -9.451909781608253e-04,  1.577075704771721e-05, -3.198789896204774e-07,
  8.377040989146658e-09, -2.735616892596465e-10,  8.975868586302675e-12, -2.325842584059721e-13,  3.031089650207925e-15,  7.640643770921493e-17, -5.678475797650490e-18,
  1.317564919891277e-19,  7.127382760002574e-03, -7.841240451178057e-05,  1.417008811674442e-06, -3.918466184282194e-08,  1.671071871133537e-09, -7.832221456189603e-11,
  3.115824768202946e-12, -9.140088475593388e-14,  1.491562843667105e-15,  1.610872136131983e-17, -1.819137942214511e-18,  4.236937250188418e-20,  8.337112615183748e-05,
 -9.391516390815281e-07,  2.041196858203664e-08, -8.837988197939575e-10,  5.354985260289338e-11, -2.980042643573151e-12,  1.336857914993346e-13, -4.619797312711020e-15,
  1.150780619485656e-16, -1.714647549231311e-18,  7.099210156429722e-21, -5.654879836156373e-22,  2.645356609652336e-01, -2.645712195091173e-03,  3.956750257118365e-05,
 -6.456623201042218e-07,  1.025334856125628e-08, -1.260633771484054e-10, -1.372708975695872e-13,  7.526089395249049e-14, -2.556590183045186e-15,  2.857070061562939e-17,
  1.526209074035351e-18, -1.016846239205814e-19,  8.314771942621560e-02, -8.324504481306769e-04,  1.258823744123521e-05, -2.199092581497052e-07,  4.595155574574021e-09,
 -1.240700207990108e-10,  3.988620400244983e-12, -1.240871715382136e-13,  3.064611065118513e-15, -4.126843845639083e-17, -7.503253014785160e-19,  6.680379762910824e-20,
  6.833940449060734e-03, -6.859923380250107e-05,  1.066546868431952e-06, -2.168644988813573e-08,  6.737525255383928e-10, -2.873139182369333e-11,  1.233927125025130e-12,
 -4.465066372475197e-14,  1.221712553614553e-15, -1.975971936559227e-17, -1.496503381506373e-19,  2.241959433474712e-20,  7.988972725613896e-05, -8.073001853748167e-07,
  1.344131983476206e-08, -3.666898550664570e-10,  1.747050962754464e-11, -9.630575781132426e-13,  4.695400381802282e-14, -1.873349467568887e-15,  5.874728259501910e-17,
 -1.335447713513883e-18,  1.593615045880449e-20,  2.081641738575240e-22,  2.545405086723935e-01, -2.357564901771489e-03,  3.272168401708943e-05, -5.013928416713402e-07,
  7.827046056922759e-09, -1.121167216715942e-10,  1.023975512129938e-12,  1.520587458252456e-14, -1.171767883513213e-15,  3.540774535461894e-17, -5.129304322115040e-19,
 -9.057479669283144e-21,  8.000416853611410e-02, -7.412102253480717e-04,  1.032263449417313e-05, -1.620374325441752e-07,  2.840658919643379e-09, -6.042154600080094e-11,
  1.648088180867824e-12, -5.137081119541645e-14,  1.519516127218456e-15, -3.641436994791027e-17,  5.373274945597422e-19,  3.994021724481667e-21,  6.575172181629680e-03,
 -6.095958284414468e-05,  8.562503785739154e-07, -1.424850129499287e-08,  3.140142204205533e-10, -1.036338894881216e-11,  4.242700095585993e-13, -1.671538657810304e-14,
  5.586996320704715e-16, -1.458420671398515e-17,  2.471359001169131e-19,  1.835353851072224e-22,  7.685290736708155e-05, -7.137596720889195e-07,  1.024024691205721e-08,
 -1.945587762072361e-10,  6.155824082548447e-12, -2.929441393171128e-13,  1.452316258333459e-14, -6.315751819521922e-16,  2.289111628916453e-17, -6.682486583758676e-19,
  1.458557505964342e-20, -1.769997593168223e-22,  2.455984825491955e-01, -2.117890614799417e-03,  2.738693655738780e-05, -3.926813732175905e-07,  5.847506385427998e-09,
 -8.564171841142601e-11,  1.086414676352482e-12, -6.097418485450971e-15, -2.851292587721747e-16,  1.469342050926682e-17, -4.138452186455930e-19,  6.916824467634989e-21,
  7.719315971796283e-02, -6.657142409601306e-04,  8.616842698817938e-06, -1.245094641974512e-07,  1.935063342562992e-09, -3.369497952798551e-11,  7.231128023345799e-13,
 -1.958618172194329e-14,  5.866040111423453e-16, -1.653635283822504e-17,  3.872400203768535e-19, -6.231084608059355e-21,  6.344054500734288e-03, -5.472091593007076e-05,
  7.100064740961246e-07, -1.045750746374377e-08,  1.792859544194633e-10, -4.195831709821329e-12,  1.407113686645872e-13, -5.428496788360287e-15,  1.972198484865107e-16,
 -6.153750333281360e-18,  1.548655004458136e-19, -2.762651947900928e-21,  7.414882770445632e-05, -6.398490478830597e-07,  8.351112418765103e-09, -1.287701048803803e-10,
  2.696943225596864e-12, -9.242025920534296e-14,  4.188170167142603e-15, -1.873252338065533e-16,  7.372913374461876e-18, -2.462897491560697e-19,  6.791723822289473e-21,
 -1.456747388632739e-22,  2.375373522820013e-01, -1.916174622717468e-03,  2.318399452932288e-05, -3.114786048870683e-07,  4.377958889050139e-09, -6.225854086200108e-11,
  8.480514252255680e-13, -9.378564489523252e-15,  1.545718712208335e-17,  3.725996011011132e-18, -1.562048013156345e-19,  4.174337717208743e-21,  7.465939180516454e-02,
 -6.022754988540430e-04,  7.288879891898993e-06, -9.815110432845953e-08,  1.399265326475092e-09, -2.125608724525807e-11,  3.663365111180867e-13, -7.859181224050804e-15,
  2.085860302600770e-16, -5.972657272423154e-18,  1.607152146678012e-19, -3.679969209184096e-21,  6.135797848934164e-03, -4.949945668310103e-05,  5.994376734286941e-07,
 -8.117872973585044e-09,  1.197828693797435e-10, -2.097099380279904e-12,  5.100006935481765e-14, -1.685479537840418e-15,  6.084933797525943e-17, -2.050524170989914e-18,
  6.015651118628228e-20, -1.464443670104221e-21,  7.171414905054662e-05, -5.785997617405792e-07,  7.017556999820180e-09, -9.633733550900778e-11,  1.537781539797397e-12,
 -3.478271798793700e-14,  1.222569294590836e-15, -5.170659863769493e-17,  2.101605420141636e-18, -7.572433601066523e-20,  2.354507769664971e-21, -6.178747892407205e-23,
  2.302214902196696e-01, -1.744550717780258e-03,  1.982878805167655e-05, -2.503738214371839e-07,  3.315733035989411e-09, -4.491199617006543e-11,  6.057320578001405e-13,
 -7.643304734380295e-15,  7.258055001931901e-17,  2.098311651260322e-19, -3.950680517194507e-20,  1.446511152576352e-21,  7.235995063801959e-02, -5.483246422134917e-04,
  6.232737951976933e-06, -7.874954469076686e-08,  1.047433689706965e-09, -1.451168376431514e-11,  2.146570937810978e-13, -3.651634106234252e-15,  7.759653107854942e-17,
 -1.998702883782593e-18,  5.458078372460071e-20, -1.402909271862192e-21,  5.946816323897240e-03, -4.506385395863577e-05,  5.123177592273988e-07, -6.483198639810365e-09,
  8.715750149305466e-11, -1.273722187232037e-12,  2.265390041070595e-14, -5.603152260242047e-16,  1.790392432435641e-17, -6.040806724641483e-19,  1.898513960765128e-20,
 -5.260470694262527e-22,  6.950524069852401e-05, -5.267097170713073e-07,  5.990268399200313e-09, -7.608615835021343e-11,  1.048855527821765e-12, -1.719742964309915e-14,
  4.100996273275971e-16, -1.424848576074294e-17,  5.587267589792540e-19, -2.079743778109363e-20,  6.922079193531120e-22, -2.016415538426861e-23,  2.235427088315649e-01,
 -1.597099953916773e-03,  1.711534182879039e-05, -2.037861767606889e-07,  2.546888527159290e-09, -3.268147311013707e-11,  4.237851998801237e-13, -5.406805310259153e-15,
  6.312369254697539e-17, -5.070548512484760e-19, -4.141194412868154e-21,  3.586587956824416e-22,  7.026076614590264e-02, -5.019782086152100e-04,  5.379541616813352e-06,
 -6.406300196354200e-08,  8.016503094365063e-10, -1.036025120271580e-11,  1.387758876799912e-13, -1.996521798742251e-15,  3.341630675243163e-17, -6.975015861976706e-19,
  1.732286988096655e-20, -4.504823918714096e-22,  5.774296399268840e-03, -4.125456522330250e-05,  4.421292855631045e-07, -5.267316553086411e-09,  6.611448919009227e-11,
 -8.693593962153890e-13,  1.254398332613609e-14, -2.251704015537396e-16,  5.559830707601092e-18, -1.698996412759845e-19,  5.364405066696500e-21, -1.579020599119281e-22,
  6.748883557431773e-05, -4.821776341769061e-07,  5.168007345330519e-09, -6.162786402488916e-11,  7.790985832141721e-13, -1.065905917677613e-14,  1.787357334089605e-16,
 -4.383268195468555e-18,  1.471935357645781e-19, -5.349588274078827e-21,  1.836797636696714e-22, -5.684134178950193e-24,  2.174135834772433e-01, -1.469312527262076e-03,
  1.489449806204515e-05, -1.677599685694979e-07,  1.983810797127100e-09, -2.411646185313098e-11,  2.978397136971469e-13, -3.688153730610503e-15,  4.449719664068152e-17,
 -4.810557518593921e-19,  3.223098812775569e-21,  4.614514212723632e-23,  6.833434563634182e-02, -4.618135092046748e-04,  4.681445179933933e-06, -5.273036319673536e-08,
  6.237641734888796e-10, -7.598859272597160e-12,  9.483685103142029e-14, -1.226226364679187e-15,  1.714683753561816e-17, -2.813130430299336e-19,  5.727343006692625e-21,
 -1.364934269785729e-22,  5.615975659045668e-03, -3.795360353272490e-05,  3.847425670647558e-07, -4.334066928684990e-09,  5.131156222452403e-11, -6.283086576684397e-13,
  8.041590250130046e-15, -1.144064442494829e-16,  2.056309953594321e-18, -4.995495655724312e-20,  1.451519499726074e-21, -4.296197071525077e-23,  6.563840894396137e-05,
 -4.435946604955133e-07,  4.496891350417548e-09, -5.066868080003881e-11,  6.010200637925799e-13, -7.447222445727308e-15,  1.008130139290712e-16, -1.718017544989332e-18,
  4.239293591060525e-20, -1.358697526847710e-21,  4.587369938566586e-23, -1.461065894752732e-24,  2.117626120127271e-01, -1.357703721687795e-03,  1.305707608964064e-05,
 -1.395216588038817e-07,  1.565365467402945e-09, -1.806167680469581e-11,  2.120936041112202e-13, -2.514347467100688e-15,  2.971723398801533e-17, -3.393801939140226e-19,
  3.406190997751974e-21, -1.884471631062250e-23,  6.655821245851426e-02, -4.267341419519970e-04,  4.103918080670696e-06, -4.385295114025378e-08,  4.920524347853728e-10,
 -5.680806564311803e-12,  6.692082029213886e-14, -8.047509453649876e-16,  1.004078425501123e-17, -1.363638230730962e-19,  2.184390551554279e-21, -4.311108683336407e-23,
  5.470006261209409e-03, -3.507063329227541e-05,  3.372762642651428e-07, -3.604098425152816e-09,  4.044848422092018e-11, -4.676523615638299e-13,  5.551663755196640e-15,
 -6.905500682613322e-17,  9.671259192215705e-19, -1.726071167394193e-20,  4.081824141193818e-22, -1.123958942584171e-23,  6.393234659953705e-05, -4.098986862915507e-07,
  3.942036672082857e-09, -4.212652821537284e-11,  4.730124440811522e-13, -5.486763999307383e-15,  6.628893326306356e-17, -8.868804773618929e-19,  1.523393098563335e-20,
 -3.717788074502897e-22,  1.129892010860639e-23, -3.552967078149500e-25,  2.065306737294335e-01, -1.259544141539088e-03,  1.152200539875550e-05, -1.171112485526642e-07,
  1.249842587713471e-09, -1.371918709725737e-11,  1.533454293134555e-13, -1.734420946137584e-15,  1.972203436519428e-17, -2.225978874497379e-19,  2.410754843688939e-21,
 -2.255707880315660e-23,  6.491378399025143e-02, -3.958820041401482e-04,  3.621433565175661e-06, -3.680883731095998e-08,  3.928424572538410e-10, -4.312807570655712e-12,
  4.825023800300813e-14, -5.481552000921902e-16,  6.347807633388040e-18, -7.643462506139455e-20,  1.007141432510726e-21, -1.568660220340812e-23,  5.334860887376286e-03,
 -3.253508474364210e-05,  2.976232783943333e-07, -3.025108581183904e-09,  3.228720197407050e-11, -3.545991353977157e-13,  3.975916900524153e-15, -4.565262907510507e-17,
  5.516276391665886e-19, -7.588140121276802e-21,  1.334204194441648e-22, -3.046295524898520e-24,  6.235279412684798e-05, -3.802636235289447e-07,  3.478565291042421e-09,
 -3.535735545016622e-11,  3.774166003856295e-13, -4.148603446207623e-15,  4.674972060946553e-17, -5.497717844969926e-19,  7.259683840048011e-21, -1.245571080574777e-22,
  2.968583038171379e-24, -8.523568471741588e-26,  2.016684027834583e-01, -1.172669112192819e-03,  1.022820615055914e-05, -9.912419195856015e-08,  1.008667500224930e-09,
 -1.055713268175459e-11,  1.125343563188100e-13, -1.214759799410984e-15,  1.322097501851813e-17, -1.442279204903659e-19,  1.556304766003267e-21, -1.602196789545052e-23,
  6.338554413294500e-02, -3.685766776890096e-04,  3.214784418847903e-06, -3.115532443998424e-08,  3.170319021565667e-10, -3.318322267858447e-12,  3.538071820374893e-14,
 -3.824157123797787e-16,  4.186089140950884e-18, -4.668909972677858e-20,  5.426531811102994e-22, -6.926817187056996e-24,  5.209264340234297e-03, -3.029102893838767e-05,
  2.642031981167119e-07, -2.560466257340540e-09,  2.605525313976125e-11, -2.727427641081100e-13,  2.909802840137685e-15, -3.154943622119484e-17,  3.501410446874970e-19,
 -4.108888705757439e-21,  5.536127946301959e-23, -9.518153138714525e-25,  6.088484660187011e-05, -3.540355309898988e-07,  3.087955146191846e-09, -2.992631253649867e-11,
  3.045381638635251e-13, -3.188555484791044e-15,  3.406374266076415e-17, -3.719425766396744e-19,  4.255362307433610e-21, -5.534399480393775e-23,  9.401780401397896e-25,
 -2.167211258215565e-26,  1.971342115012168e-01, -1.095342214215330e-03,  9.129025910743330e-06, -8.453867027316322e-08,  8.220061924260855e-10, -8.221060442360181e-12,
  8.374175242057448e-14, -8.640142976410036e-16,  8.996575141775728e-18, -9.421669860301119e-20,  9.867750287091464e-22, -1.019402397788337e-23,  6.196042161535099e-02,
 -3.442723863717074e-04,  2.869305611166476e-06, -2.657099590547142e-08,  2.583616516859799e-10, -2.583956417761433e-12,  2.632255941595023e-14, -2.716847075726100e-16,
  2.833802477286204e-18, -2.988864428692963e-20,  3.212206157481654e-22, -3.603564998310913e-24,  5.092142368194504e-03, -2.829361002640397e-05,  2.358104187395645e-07,
 -2.183705852880602e-09,  2.123320979014474e-11, -2.123651458798559e-13,  2.163689612099274e-15, -2.235176687388162e-17,  2.341060541430317e-19, -2.511189174352822e-21,
  2.860928981665522e-23, -3.762752668274992e-25,  5.951594825663058e-05, -3.306900929879843e-07,  2.756105442656552e-09, -2.552273707118514e-11,  2.481713175629245e-13,
 -2.482230981458470e-15,  2.529917268920778e-17, -2.618603345182935e-19,  2.768056607892011e-21, -3.080273268363098e-23,  3.934838157919604e-25, -6.562806974038743e-27,
  1.928927821419343e-01, -1.026156102561305e-03,  8.188381138899286e-06, -7.260041937953687e-08,  6.758791747031045e-10, -6.471917490837207e-12,  6.311953684296183e-14,
 -6.235736720854355e-16,  6.218932915719510e-18, -6.244959180474142e-20,  6.296029124041180e-22, -6.336680812064874e-24,  6.062731586267939e-02, -3.225267916594985e-04,
  2.573655504713086e-06, -2.281873188915845e-08,  2.124327958123497e-10, -2.034166629389401e-12,  1.983922348056700e-14, -1.960158994380586e-16,  1.955840709819070e-18,
 -1.968278829222986e-20,  2.001109952574625e-22, -2.073277934443121e-24,  4.982582682989027e-03, -2.650647458667992e-05,  2.115127681330307e-07, -1.875330025159798e-09,
  1.745854550301971e-11, -1.671766135269718e-13,  1.630538624750469e-15, -1.611386253962262e-17,  1.609735317079140e-19, -1.628376768227952e-21,  1.688665217411764e-23,
 -1.866363013608561e-25,  5.823543642286148e-05, -3.098024085720605e-07,  2.472119230863092e-09, -2.191848781123524e-11,  2.040523377233407e-13, -1.953954700787249e-15,
  1.905935625874037e-17, -1.884523191045144e-19,  1.887521553899122e-21, -1.931341846550624e-23,  2.089722130245981e-25, -2.612901855283505e-27,  1.889139014054483e-01,
 -9.639593649275827e-04,  7.378040357224555e-06, -6.274510834752689e-08,  5.602832449832923e-10, -5.145997832629842e-12,  4.813931601014295e-14, -4.561747432320297e-16,
  4.364194032441786e-18, -4.205495226569813e-20,  4.073982217355483e-22, -3.956690233657101e-24,  5.937673065922774e-02, -3.029779976626730e-04,  2.318960711613378e-06,
 -1.972115017708439e-08,  1.761002730721470e-10, -1.617417879099434e-12,  1.513053761295240e-14, -1.433827112696477e-16,  1.371919121485036e-18, -1.322864001580866e-20,
  1.284826076569870e-22, -1.259817617124906e-24,  4.879804849430505e-03, -2.489988057432709e-05,  1.905809836584637e-07, -1.620758915441774e-09,  1.447259047185599e-11,
 -1.329257337556186e-13,  1.243499067629415e-15, -1.178458535085487e-17,  1.127941205182131e-19, -1.089247548337914e-21,  1.064491338894785e-23, -1.067415055755363e-25,
  5.703418952466905e-05, -2.910248568797653e-07,  2.227472674857918e-09, -1.894310873216947e-11,  1.691528209665943e-13, -1.553614606284812e-15,  1.453412761618501e-17,
 -1.377575522763961e-19,  1.319458131207552e-21, -1.278423422102669e-23,  1.266420574836159e-25, -1.331449744280493e-27,  1.851715492881628e-01, -9.078018447748253e-04,
  6.675682010933934e-06, -5.454523815399643e-08,  4.679581255956607e-10, -4.129442379237762e-12,  3.711457956507357e-14, -3.379097953160949e-16,  3.106054430946615e-18,
 -2.876100477563921e-20,  2.678358284604433e-22, -2.504236657678959e-24,  5.820048776736866e-02, -2.853273646261723e-04,  2.098205424842294e-06, -1.714388350666682e-08,
  1.470819446879588e-10, -1.297907784845601e-12,  1.166534008327663e-14, -1.062078072905621e-16,  9.762934504680702e-19, -9.041740188949631e-21,  8.426556456002734e-23,
 -7.902360812797785e-25,  4.783136748910902e-03, -2.344928462929612e-05,  1.724384770803982e-07, -1.408949350693256e-09,  1.208775229165991e-11, -1.066670189677892e-13,
  9.587044568095084e-16, -8.728717112265886e-18,  8.024380238351255e-20, -7.434735284826628e-22,  6.941575918272990e-24, -6.556197274235096e-26,  5.590435197248701e-05,
 -2.740705796740896e-07,  2.015426659455108e-09, -1.646752016838426e-11,  1.412792576324589e-13, -1.246703829922096e-15,  1.120521195890956e-17, -1.020234666926755e-19,
  9.380842102377622e-22, -8.699492767675115e-24,  8.155037312548065e-26, -7.822249319245505e-28,  1.816431791811994e-01, -8.568932530170242e-04,  6.063486144530027e-06,
 -4.767324791356372e-08,  3.935646368877748e-10, -3.341886442752334e-12,  2.890254721198177e-14, -2.532119475569391e-16,  2.239686242030165e-18, -1.995676971856801e-20,
  1.788620048661813e-22, -1.610253437361102e-24,  5.709150065763852e-02, -2.693265001124379e-04,  1.905788726959508e-06, -1.498397725439672e-08,  1.236996395783627e-10,
 -1.050374250245407e-12,  9.084239976262631e-15, -7.958612500901830e-17,  7.039541585124209e-19, -6.272897487772981e-21,  5.623296904730850e-23, -5.067074341665330e-25,
  4.691995983564805e-03, -2.213427291698527e-05,  1.566249432873873e-07, -1.231440062450606e-09,  1.016610545659091e-11, -8.632374480565882e-14,  7.465777483175711e-16,
 -6.540717969607528e-18,  5.785514247541627e-20, -5.156023973297915e-22,  4.624483457352550e-24, -4.175961965531806e-26,  5.483911681563282e-05, -2.587009840541307e-07,
  1.830601217866300e-09, -1.439282679549093e-11,  1.188194225550968e-13, -1.008934938447128e-15,  8.725863950982873e-18, -7.644732385390008e-20,  6.762376139378986e-22,
 -6.028073925369038e-24,  5.412735570063824e-26, -4.910532152406482e-28,  1.783091435068096e-01, -8.105714763885776e-04,  5.527099560594736e-06, -4.187549954801684e-08,
  3.331284422661808e-10, -2.725823511509381e-12,  2.271708434361036e-14, -1.917834952531508e-16,  1.634652858312039e-18, -1.403600862970387e-20,  1.212279183264610e-22,
 -1.051902478864348e-24,  5.604359398283197e-02, -2.547672980945865e-04,  1.737199324641562e-06, -1.316171144370218e-08,  1.047041941179285e-10, -8.567420840223600e-13,
  7.140111285409206e-15, -6.027868698596839e-17,  5.137822559190218e-19, -4.411666077462358e-21,  3.810551142508807e-23, -3.307298409716719e-25,  4.605875039944314e-03,
 -2.093774249466561e-05,  1.427696270027392e-07, -1.081679348524205e-09,  8.604987666414722e-12, -7.041031390263994e-14,  5.868014993699598e-16, -4.953936136062860e-18,
  4.222484808959747e-20, -3.625805219484136e-22,  3.132214127856796e-24, -2.720220962777667e-26,  5.383255233773791e-05, -2.447161742130610e-07,  1.668663033908898e-09,
 -1.264245331250969e-11,  1.005733864659319e-13, -8.229417873982120e-16,  6.858421374239720e-18, -5.790074767557837e-20,  4.935224687693564e-22, -4.238096384081151e-24,
  3.662274867523145e-26, -3.184795604515844e-28,  1.751522313469060e-01, -7.682780523907883e-04,  5.054866064831878e-06, -3.695367825821301e-08,  2.836577894673498e-10,
 -2.239577377880630e-12,  1.800969170875896e-14, -1.467068198373214e-16,  1.206563522996816e-18, -9.996658424710999e-21,  8.331150923639629e-23, -6.975734812699489e-25,
  5.505135825195735e-02, -2.414742305823846e-04,  1.588773608597079e-06, -1.161475457603747e-08,  8.915528207053426e-11, -7.039121100363514e-13,  5.660550230292125e-15,
 -4.611080575287747e-17,  3.792301394855347e-19, -3.142019640262838e-21,  2.618581050162166e-23, -2.192716541663958e-25,  4.524329345569739e-03, -1.984526780652045e-05,
  1.305714389089551e-07, -9.545445678307480e-10,  7.327119110558409e-12, -5.785016624928963e-14,  4.652054941098187e-16, -3.789561744150539e-18,  3.116661951406153e-20,
 -2.582254314449293e-22,  2.152150158016200e-24, -1.802450819320188e-26,  5.287946246398605e-05, -2.319475471188476e-07,  1.526093035077467e-09, -1.115652725337889e-11,
  8.563791241399143e-14, -6.761412539038884e-16,  5.437229740365778e-18, -4.429166690590031e-20,  3.642704634261578e-22, -3.018145744073781e-24,  2.515642122827449e-26,
 -2.107653891028328e-28,  1.721572931354184e-01, -7.295390037185862e-04,  4.637247389350724e-06, -3.275132356795787e-08,  2.428770532313547e-10, -1.852586269063851e-12,
  1.439259987039881e-14, -1.132671287056911e-16,  8.999625651656913e-19, -7.203607316266688e-21,  5.799924585330966e-23, -4.691771911160091e-25,  5.411003186887217e-02,
 -2.292983237703839e-04,  1.457513646106529e-06, -1.029393021775261e-08,  7.633766105152942e-11, -5.822785678388406e-13,  4.523677305460671e-15, -3.560051377175669e-17,
  2.828634784254144e-19, -2.264137554330217e-21,  1.822959140210194e-23, -1.474687574440187e-25,  4.446967574416710e-03, -1.884460562037848e-05,  1.197839975258923e-07,
 -8.459942142111709e-10,  6.273718415965227e-12, -4.785386041901605e-14,  3.717729547723112e-16, -2.925785356624033e-18,  2.324680170173338e-20, -1.860758235199498e-22,
  1.498194934826542e-24, -1.212024781648485e-26,  5.197527345355514e-05, -2.202520063061302e-07,  1.400011563517521e-09, -9.887812287433475e-12,  7.332597434679273e-14,
 -5.593064134578543e-16,  4.345208490166237e-18, -3.419600178046898e-20,  2.717042101542452e-22, -2.174827480598416e-24,  1.751105003442648e-26, -1.416765967283662e-28,
  1.693109336777295e-01, -6.939497246994565e-04,  4.266382979292164e-06, -2.914395924329355e-08,  2.090385188832172e-10, -1.542191918946963e-12,  1.158829084669605e-14,
 -8.820722998708332e-17,  6.778676499379092e-19, -5.247962601923398e-21,  4.086802164258025e-23, -3.197584774036392e-25,  5.321540464651766e-02, -2.181124077580974e-04,
  1.340948819360952e-06, -9.160114768996899e-09,  6.570201420253421e-11, -4.847198301486780e-13,  3.642266766574396e-15, -2.772404214318182e-17,  2.130577265353244e-19,
 -1.649465344086414e-21,  1.284507180106061e-23, -1.005025869691535e-25,  4.373443717350020e-03, -1.792530463165725e-05,  1.102042581143103e-07, -7.528129618258656e-10,
  5.399640633075102e-12, -3.983611343808480e-14,  2.993352927789217e-16, -2.278466924814009e-18,  1.750989325614062e-20, -1.355593884150099e-22,  1.055659870053070e-24,
 -8.259808811748146e-27,  5.111594122042038e-05, -2.095073990034365e-07,  1.288045472647548e-09, -8.798728323418721e-12,  6.310992688067395e-14, -4.655965790747142e-16,
  3.498571438351491e-18, -2.663026937587404e-20,  2.046521897809985e-22, -1.584392974507281e-24,  1.233842065204429e-26, -9.654209134791595e-29,  1.666012592647280e-01,
 -6.611629623847400e-04,  3.935752075507184e-06, -2.603178028044066e-08,  1.807877825129078e-10, -1.291423331103786e-12,  9.395870945706350e-15, -6.924832843226397e-17,
  5.152731086760906e-19, -3.862520318928951e-21,  2.912401338487064e-23, -2.206374943575555e-25,  5.236373832340435e-02, -2.078073389375104e-04,  1.237029616085782e-06,
 -8.181938940398125e-09,  5.682264454281094e-11, -4.059018141518293e-13,  2.953176523138413e-15, -2.176514973193074e-17,  1.619533163840819e-19, -1.214012517534799e-21,
  9.153848548016081e-24, -6.934775341393395e-26,  4.303450549867035e-03, -1.707839500483726e-05,  1.016637839847815e-07, -6.724227635272277e-10,  4.669900368705210e-12,
 -3.335855004407273e-14,  2.427032435637414e-16, -1.788742531082157e-18,  1.330993783491663e-20, -9.977216411488412e-23,  7.522985313944995e-25, -5.699283222821317e-27,
  5.029787498563661e-05, -1.996088875553983e-07,  1.188226107905752e-09, -7.859143658208009e-12,  5.458086765954214e-14, -3.898881050170457e-16,  2.836667290484250e-18,
 -2.090646741531065e-20,  1.555639151244907e-22, -1.166117536233024e-24,  8.792729222592889e-27, -6.661262688234127e-29,  };
  int offset = -4;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 4;
    if (std::isnan(t)) {
      fill_n(rr+offset, 4, 0.5);
      fill_n(ww+offset, 4, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 4; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=4; ++j) {
        const int boxof = it*48+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
