//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_23.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot23(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[23] = {2.653218387609836e-02,2.389716199993339e-01,6.648260832562888e-01,1.306071615803997e+00,2.165735979535348e+00,
    3.247979609296123e+00,4.558211647594767e+00,6.103249261459857e+00,7.891532362130975e+00,9.933411571882624e+00,1.224153595127313e+01,1.483138058862574e+01,
    1.772197621399749e+01,2.093694020760516e+01,2.450597390184634e+01,2.846711245452768e+01,3.287025236104362e+01,3.778298740536300e+01,4.330095920116128e+01,
    4.956801284212563e+01,5.682101866501256e+01,6.551242711227015e+01,7.680290116031279e+01};
  constexpr double aw[23] = {3.172743849181671e-01,2.568445435065200e-01,1.681601273621231e-01,8.886822756600514e-02,3.779583099224686e-02,
    1.288348755977721e-02,3.501057850522795e-03,7.533967345431294e-04,1.273198375510694e-04,1.672593592065391e-05,1.686946839735520e-06,1.286532413056337e-07,
    7.281634756563973e-09,2.988545587992385e-10,8.639140291448407e-12,1.694707616774984e-13,2.148647282367977e-15,1.648444738950766e-17,6.973799596694894e-20,
    1.415504201675422e-22,1.097655801996775e-25,2.113201496269695e-29,3.411379229909481e-34};
  constexpr double x[8832] = {  2.233276443804096e-03, -2.373231831940797e-05,  1.889343188909143e-07, -1.335056012122436e-09,  8.827709309771545e-12,
 -5.591152949676807e-14,  3.433752199032877e-16, -2.059481875055814e-18,  1.211662233227607e-20, -7.012670824701344e-23,  3.999969295648870e-25, -2.251126551555626e-27,
  2.004212297484025e-02, -2.111222514272325e-04,  1.651274625987462e-06, -1.132453032684587e-08,  7.152301904779432e-11, -4.238661114803884e-13,  2.371257301554280e-15,
 -1.249825136385738e-17,  6.141967201386315e-20, -2.745230554929187e-22,  1.049064024353715e-24, -2.749266294466378e-27,  5.535475601081648e-02, -5.729163505159661e-04,
  4.322263072809598e-06, -2.783611473823004e-08,  1.587284876368493e-10, -7.983663001989768e-13,  3.387299170153704e-15, -1.025537529587816e-17, -1.461962552871901e-22,
  3.252385294425955e-22, -3.341537182609949e-24,  2.385959747169551e-26,  1.075653119623770e-01, -1.083997079375546e-03,  7.733368981266424e-06, -4.492004517591137e-08,
  2.118736507598211e-10, -7.121699416148632e-13,  3.996730825933417e-16,  1.847480656498388e-17, -1.909839047879791e-19,  1.232245842592591e-21, -5.416175031991799e-24,
  9.177394231887038e-27,  1.757756362971030e-01, -1.708774052737796e-03,  1.127333525184806e-05, -5.585257029286202e-08,  1.800119899042174e-10,  5.789134286303265e-14,
 -6.086694514901342e-15,  5.181888841475456e-17, -2.515940987027544e-19,  3.885072208709256e-22,  6.041615417747200e-24, -7.229951369361292e-26,  2.588080484901034e-01,
 -2.403551542772727e-03,  1.428308541521250e-05, -5.511041354604040e-08,  4.593458175593700e-11,  1.273152527814202e-12, -1.146653957419331e-14,  4.686585759086618e-17,
  4.718639600750003e-20, -2.241743257456120e-21,  1.710039761301754e-23, -5.279376030295575e-26,  3.552223455372104e-01, -3.119464676898618e-03,  1.615947306823032e-05,
 -4.007410721077173e-08, -1.612658402335602e-10,  2.301997805042473e-12, -1.024135403493787e-14, -1.372325500374923e-17,  5.051246068300195e-19, -3.148733589473131e-21,
  1.839583605482611e-24,  1.250476006896292e-25,  4.633370107492963e-01, -3.805806569948170e-03,  1.645231664520705e-05, -1.198249374465220e-08, -3.734723793899589e-10,
  2.459125933409607e-12, -7.603779843986731e-16, -9.126689515754687e-17,  5.861026072128354e-19,  3.102011770849341e-22, -2.813189154622021e-23,  1.645087380760528e-25,
  5.812545624405071e-01, -4.413538594527098e-03,  1.493973659963244e-05,  2.415131533216706e-08, -5.087232774757322e-10,  1.427933853125177e-12,  1.239247788317027e-14,
 -1.154770785758254e-16,  2.544692408094751e-20,  5.018467193924501e-21, -2.602176845521886e-23, -1.077646863526703e-25,  7.068909296932108e-01, -4.898755986186141e-03,
  1.166959513769617e-05,  6.067951300311615e-08, -5.045553741259796e-10, -4.887877339361408e-13,  2.075765903942463e-14, -4.886278221711898e-17, -7.394939805946379e-19,
  4.788138501728531e-21,  1.811271264985666e-23, -2.971667610277464e-25,  8.380086774175740e-01, -5.225873187867288e-03,  6.959565974171067e-06,  8.924241647065899e-08,
 -3.457106214759130e-10, -2.460848588336833e-12,  1.784906807673559e-14,  6.928680590303193e-17, -9.248316299299662e-19, -1.395194312573656e-21,  4.717583391752333e-23,
 -2.630073080523091e-26,  9.722538190564642e-01, -5.370299728137419e-03,  1.354472094195838e-06,  1.029734635528821e-07, -7.401605117687340e-11, -3.541533605227147e-12,
  4.241569186737776e-15,  1.476526174781687e-16, -2.499277293651058e-19, -6.796461464894088e-21,  1.497697911249749e-23,  3.321163247252481e-25,  1.107195852389798e+00,
 -5.320399483094491e-03, -4.453796385899266e-06,  9.838350514176037e-08,  2.248005871369972e-10, -3.178633964747683e-12, -1.217867371115819e-14,  1.206775092935474e-16,
  6.808100676214339e-19, -4.863058141886485e-21, -3.863807930692447e-23,  1.969500861621320e-25,  1.240370533521040e+00, -5.078564559748085e-03, -9.732228926516865e-06,
  7.638354741273216e-08,  4.529621231249658e-10, -1.531444936586639e-12, -2.138736810593011e-14,  8.750243121986539e-18,  9.730452107897881e-19,  2.215383968070417e-21,
 -4.075140529458374e-23, -2.223871154433389e-25,  1.369324769947186e+00, -4.661289249518838e-03, -1.382217793525483e-05,  4.212482841735363e-08,  5.384779058632912e-10,
  6.013417627249995e-13, -1.817494642798066e-14, -9.806994373966868e-17,  3.911534980559839e-19,  6.125325068914348e-21,  7.514651770801118e-24, -2.662947875161630e-25,
  1.491662871736055e+00, -4.098197514483363e-03, -1.624566822900003e-05,  3.660355144305371e-09,  4.631029865560162e-10,  2.213609481995899e-12, -5.659940919501218e-15,
 -1.197725419712885e-16, -4.178569523030775e-19,  3.008446483112171e-21,  3.644251095918904e-23,  6.648332502522721e-26,  1.605093258991925e+00, -3.430055527186435e-03,
 -1.678444750466058e-05, -3.022528452114179e-08,  2.682456462813664e-10,  2.636783080204950e-12,  7.322569801073479e-15, -5.439456232799036e-17, -6.718517820476265e-19,
 -2.284548868440587e-21,  1.409564672598457e-23,  2.051363711040729e-25,  1.707474595316523e+00, -2.705883351410966e-03, -1.551748210446663e-05, -5.241222877839266e-08,
  3.596684253183115e-11,  1.877074304229208e-12,  1.286844577898948e-14,  2.924096219518474e-17, -2.792524789345479e-19, -3.459089564653805e-21, -1.624677001539625e-23,
  1.854632896313883e-26,  1.796860214970588e+00, -1.979359843430900e-03, -1.280914697697713e-05, -5.937186485197464e-08, -1.467680369892748e-10,  5.481632628890623e-13,
  9.435763632152107e-15,  6.223993446602569e-17,  1.959784359854233e-19, -6.807931880909291e-22, -1.419330668007186e-23, -1.027240356890343e-25,  1.871539655571588e+00,
 -1.304784162489198e-03, -9.248682106348460e-06, -5.204493827329713e-08, -2.247241270548866e-10, -5.469714793808457e-13,  1.926348545438108e-15,  3.625727269796708e-17,
  2.796055182176118e-19,  1.392650364832004e-21,  3.127612170359767e-24, -2.322424335329516e-26,  1.930076146690449e+00, -7.329073858930402e-04, -5.550163357876437e-06,
 -3.539354638889549e-08, -1.954494353826295e-10, -9.119748224392067e-13, -3.199540691159345e-15, -3.570554222833975e-18,  6.783925920039256e-20,  8.155446141441658e-22,
  6.090599012399592e-24,  3.459477925024830e-26,  1.971339341982962e+00, -3.069683178541461e-04, -2.429607962506772e-06, -1.674864033366348e-08, -1.053564092193492e-10,
 -6.138700116047403e-13, -3.312134796699214e-15, -1.631415047122561e-17, -7.053407355255624e-20, -2.379751693712652e-22, -2.904932503294510e-25,  4.610854763060179e-27,
  1.994538294998245e+00, -5.920076212077495e-05, -4.799605302024274e-07, -3.446202888585724e-09, -2.309083558607933e-11, -1.476935212880260e-13, -9.122695236925506e-16,
 -5.476105515133797e-18, -3.205601013570097e-20, -1.832947086717076e-22, -1.024049310592810e-24, -5.584846636815233e-27,  2.141271936714975e-03, -2.228260749061871e-05,
  1.737256039098825e-07, -1.202329593434116e-09,  7.787434791523629e-12, -4.832092332452412e-14,  2.907793919639433e-16, -1.709238634710084e-18,  9.857707172950304e-21,
 -5.594313095357254e-23,  3.129843998798906e-25, -1.728342737189020e-27,  1.922322033885856e-02, -1.984368023759246e-04,  1.521976420715886e-06, -1.024500358218234e-08,
  6.358756263225637e-11, -3.709421032471907e-13,  2.047392918371928e-15, -1.068308677797550e-17,  5.226276213809875e-20, -2.350041201847993e-22,  9.267097592226327e-25,
 -2.775113540029447e-27,  5.313019066056940e-02, -5.396323905961587e-04,  4.002954750456659e-06, -2.541987801675224e-08,  1.435508942186778e-10, -7.205075096286863e-13,
  3.101670786477261e-15, -1.009656987199796e-17,  9.392805522463870e-21,  2.107612264980422e-22, -2.424625981642213e-24,  1.804828817379928e-26,  1.033497235627070e-01,
 -1.024229738348622e-03,  7.214200417459439e-06, -4.164332881477784e-08,  1.977646737835762e-10, -6.970213347868259e-13,  8.377826721324202e-16,  1.303215480397476e-17,
 -1.504130877365725e-19,  1.024980005387698e-21, -4.920428518445949e-24,  1.286254943764058e-26,  1.691167378334081e-01, -1.621219292024137e-03,  1.062039936635646e-05,
 -5.297057576037195e-08,  1.798218939629003e-10, -7.167349969400505e-14, -4.746078901274755e-15,  4.403244172790118e-17, -2.339692331553871e-19,  5.725737983115675e-22,
  3.304590342737577e-24, -5.268963307528314e-26,  2.494182033648444e-01, -2.291917824823324e-03,  1.362696324298587e-05, -5.418625987793868e-08,  6.875253677894107e-11,
  1.013803166375151e-12, -1.014437448189143e-14,  4.721185001168423e-17, -2.179337302174409e-20, -1.607274986360142e-21,  1.456490563273906e-23, -6.083359542546999e-26,
  3.429999353437473e-01, -2.992152902055315e-03,  1.566457803933426e-05, -4.229949484973460e-08, -1.177059354762329e-10,  2.053316843916235e-12, -1.041619094504199e-14,
  6.511670095792957e-19,  3.942906539006248e-19, -2.979294448682021e-21,  6.293976066427413e-24,  7.863367497851997e-26,  4.483759723678072e-01, -3.674861053702498e-03,
  1.627429090102296e-05, -1.756641387107462e-08, -3.246683750233358e-10,  2.412333439653041e-12, -3.053063840819931e-15, -7.253579990960275e-17,  5.787812222986633e-19,
 -6.682086726715235e-22, -2.077463788607285e-23,  1.665425254947251e-25,  5.638410869854131e-01, -4.292997541321014e-03,  1.518170673586609e-05,  1.625527647962035e-08,
 -4.774511506125309e-10,  1.686804590196618e-12,  9.196201270217590e-15, -1.119808061614390e-16,  1.864599483221644e-19,  3.907471350049280e-21, -2.894044493192724e-23,
 -2.721024207709570e-26,  6.874870364033491e-01, -4.802624417118269e-03,  1.234907567597662e-05,  5.255497776868784e-08, -5.094732390358312e-10, -9.532179253219985e-15,
  1.908497118634058e-14, -6.965411969295702e-17, -5.571905892421897e-19,  5.256043616364508e-21,  5.461848980863185e-24, -2.727138280047532e-25,  8.172231826551096e-01,
 -5.166010643616185e-03,  7.995739642964520e-06,  8.334118491503095e-08, -3.905041074854261e-10, -2.012568259413082e-12,  1.936979726371685e-14,  3.924857722728908e-17,
 -9.416611354437296e-19,  4.371063728297877e-22,  4.369530233289527e-23, -1.282361901592636e-25,  9.508020822149396e-01, -5.354546697793046e-03,  2.580732415499110e-06,
  1.012294789078511e-07, -1.434994832621618e-10, -3.391249655952361e-12,  8.228077971076147e-15,  1.358834804153803e-16, -4.804343589468892e-19, -5.920958850376831e-21,
  2.833746026321183e-23,  2.690408304264213e-25,  1.085850550692268e+00, -5.351251229000453e-03, -3.253759568009596e-06,  1.014570430789266e-07,  1.585907218820993e-10,
 -3.428084657477188e-12, -8.523038990222440e-15,  1.393827735538957e-16,  4.802807241139831e-19, -6.205774830488970e-21, -2.781436074428265e-23,  2.905254746453426e-25,
  1.219906535409834e+00, -5.152635283503400e-03, -8.773242705817164e-06,  8.335816849934092e-08,  4.172385561630322e-10, -2.038221162788224e-12, -2.069679469127868e-14,
  4.083134859385304e-17,  1.021306453433204e-18,  4.128393706093463e-22, -4.873631257509906e-23, -1.347145904831181e-25,  1.350461867370230e+00, -4.769697459707823e-03,
 -1.326466848470461e-05,  5.081208390917841e-08,  5.459285115036897e-10,  1.338111947667300e-13, -2.071224307832427e-14, -8.199098653555187e-17,  6.140656298211921e-19,
  6.171423258394999e-21, -5.666478988828485e-24, -3.287593804223114e-25,  1.475010611373638e+00, -4.227857888287277e-03, -1.615585218385632e-05,  1.141563384598181e-08,
  5.057377990213995e-10,  2.036126605167071e-12, -9.182457515960252e-15, -1.311253042584206e-16, -2.828037637352575e-19,  4.502896352805341e-21,  3.769153418729709e-23,
 -1.426036460829950e-26,  1.591102296966720e+00, -3.565704890869532e-03, -1.711962965167237e-05, -2.550248273248634e-08,  3.226024953389315e-10,  2.791747112894909e-12,
  5.487049743808953e-15, -7.708260304700318e-17, -7.416746581993492e-19, -1.529769798975650e-21,  2.387578726346984e-23,  2.368844031595715e-25,  1.696398816579668e+00,
 -2.832526248769474e-03, -1.614168209398978e-05, -5.151938826618799e-08,  7.665735100259231e-11,  2.194612696022447e-12,  1.354248595780395e-14,  1.818942195197194e-17,
 -4.151570502285522e-19, -4.078816755214854e-21, -1.436671705575415e-23,  6.975795099585116e-26,  1.788733261827443e+00, -2.084721873525365e-03, -1.353529579336965e-05,
 -6.161953814246439e-08, -1.333954769293593e-10,  7.962160784604836e-13,  1.126176186527846e-14,  6.800040828261720e-17,  1.601182393658176e-19, -1.343602880313476e-21,
 -1.905466060521033e-23, -1.174074412521720e-25,  1.866168497225163e+00, -1.381333714626658e-03, -9.895146757881754e-06, -5.572516382380740e-08, -2.351135766810264e-10,
 -4.874984841691281e-13,  3.074511454420214e-15,  4.602863613041708e-17,  3.316963145511164e-19,  1.491696409119837e-21,  1.672065074351186e-24, -4.420923676688307e-26,
  1.927052947709116e+00, -7.790621586869557e-04, -5.994264560043037e-06, -3.867085474146905e-08, -2.144635303488606e-10, -9.896893131865710e-13, -3.264357424068341e-15,
 -8.798254989165770e-19,  1.019695243468121e-19,  1.091658493936126e-21,  7.766358079259225e-24,  4.162321031600036e-26,  1.970071280364113e+00, -3.272387351664107e-04,
 -2.641125442093389e-06, -1.853704110826215e-08, -1.184670742858013e-10, -6.991058378670361e-13, -3.801831622715840e-15, -1.871010605714979e-17, -7.925307480886578e-20,
 -2.445987391728740e-22, -1.488709689933154e-26,  8.161814775841240e-27,  1.994293541496939e+00, -6.321237729879845e-05, -5.236331638731158e-07, -3.840531119744276e-09,
 -2.627669650981318e-11, -1.715502679856128e-13, -1.081012837750287e-15, -6.615888215755186e-18, -3.945519372112588e-20, -2.296206324332445e-22, -1.304132397673990e-24,
 -7.218672929602950e-27,  2.054832635913490e-03, -2.094846736014275e-05,  1.600145360041451e-07, -1.085098461835235e-09,  6.887103453164001e-12, -4.188265467705014e-14,
  2.470506014684197e-16, -1.423740158002364e-18,  8.051922214115938e-21, -4.482042200104615e-23,  2.460238656138931e-25, -1.333390428900486e-27,  1.845306982732031e-02,
 -1.867360023430472e-04,  1.404904340224749e-06, -9.284381916847325e-09,  5.663681005373383e-11, -3.252127754955767e-13,  1.770457995137500e-15, -9.139123592008716e-18,
  4.444070412514588e-20, -2.003444708400274e-22,  8.073278133677544e-25, -2.631557464761059e-27,  5.103383017563161e-02, -5.087909302625716e-04,  3.711234405623928e-06,
 -2.323439575686719e-08,  1.298624489593129e-10, -6.494195154529020e-13,  2.824190563912838e-15, -9.691853066098983e-18,  1.541278429160298e-20,  1.282391680623895e-22,
 -1.734486632452377e-24,  1.351232540456605e-26,  9.936514147745222e-02, -9.684622745978343e-04,  6.733009701441328e-06, -3.858941027483247e-08,  1.840522007627330e-10,
 -6.730468754546030e-13,  1.140580895267552e-15,  8.772479341484070e-18, -1.169151878800391e-19,  8.399950543215223e-22, -4.319659137528624e-24,  1.413501951863333e-26,
  1.627978301512039e-01, -1.538749920306924e-03,  1.000194911638455e-05, -5.011067788404204e-08,  1.773449419922304e-10, -1.716106741125483e-13, -3.614732865230204e-15,
  3.689650826242247e-17, -2.114902444799096e-19,  6.633630673297740e-22,  1.351354951366642e-24, -3.669466767094474e-26,  2.404644736487743e-01, -2.185482901402501e-03,
  1.298395585147842e-05, -5.293679165442148e-08,  8.670040677620590e-11,  7.860729807967472e-13, -8.840133554533119e-15,  4.569583954824934e-17, -6.981876254904098e-20,
 -1.078680605095500e-21,  1.186512275010767e-23, -6.084118016847513e-26,  3.312787010273093e-01, -2.868895636581642e-03,  1.514699559841231e-05, -4.386781123612304e-08,
 -7.913105279215148e-11,  1.804875596426106e-12, -1.023705794474703e-14,  1.160702938166103e-17,  2.922924674198279e-19, -2.670189725107665e-21,  8.884342443343098e-24,
  4.062610313532924e-26,  4.339354618850378e-01, -3.545594586553419e-03,  1.603390321760732e-05, -2.237976894213593e-08, -2.773082505528155e-10,  2.316753142073796e-12,
 -4.829449878977293e-15, -5.454591730068593e-17,  5.415051737803420e-19, -1.356002948453445e-21, -1.372318104002116e-23,  1.518121314596782e-25,  5.469130596597837e-01,
 -4.170890864260686e-03,  1.533208399877672e-05,  8.896886309624894e-09, -4.417579360563449e-10,  1.870684064263867e-12,  6.163819624349967e-15, -1.039879160606975e-16,
  3.061888752171036e-19,  2.746029505355176e-21, -2.866772706194096e-23,  3.643850088386735e-26,  6.684779226666705e-01, -4.701447605731154e-03,  1.293089840773781e-05,
  4.442607049141133e-08, -5.052511322772355e-10,  4.232643210701843e-13,  1.691364855335877e-14, -8.443727829751437e-17, -3.668141883918724e-19,  5.247813599798061e-21,
 -5.506935577808143e-24, -2.225971976370143e-25,  7.966932520669032e-01, -5.098153460109376e-03,  8.957099864701948e-06,  7.679667917739912e-08, -4.260351986598200e-10,
 -1.537884350818200e-12,  2.005159253486172e-14,  9.691993261293050e-18, -8.960489557826180e-19,  2.047855161948469e-21,  3.629897518874250e-23, -2.027112122531399e-25,
  9.294328187784262e-01, -5.329085934045189e-03,  3.779510196648337e-06,  9.840287655879604e-08, -2.090513378188445e-10, -3.150044773515124e-12,  1.178722303119488e-14,
  1.173395180483695e-16, -6.705650058964253e-19, -4.576552238789080e-21,  3.819840736246107e-23,  1.753172606101682e-25,  1.064401250304622e+00, -5.372373506990971e-03,
 -2.023345184023959e-06,  1.034362424961827e-07,  8.830769311481360e-11, -3.584281749070871e-12, -4.440120982045302e-15,  1.509887789693211e-16,  2.401174550163990e-19,
 -7.042346684198626e-21, -1.358232023642757e-23,  3.496622427548728e-25,  1.199162113530142e+00, -5.218709815414198e-03, -7.734321209498437e-06,  8.968133658993969e-08,
  3.716186023177639e-10, -2.517531828778817e-12, -1.909647750881182e-14,  7.336504361820628e-17,  9.999460475655143e-19, -1.622283535412273e-21, -5.216145902910148e-23,
 -1.710651468372613e-26,  1.331174914233165e+00, -4.873227310787693e-03, -1.260251554470239e-05,  5.954060312191064e-08,  5.434601802995300e-10, -3.884081419666842e-13,
 -2.269996908777660e-14, -5.885893959147007e-17,  8.285592715383910e-19,  5.643729138397973e-21, -2.094001731501105e-23, -3.590017481833171e-25,  1.457841751951800e+00,
 -4.356416183798778e-03, -1.596901214286873e-05,  1.981998027149156e-08,  5.439545374023365e-10,  1.770827029513199e-12, -1.295423349552207e-14, -1.372933398653485e-16,
 -9.397864634832275e-20,  5.968490729021806e-21,  3.481792007366853e-23, -1.198632586243120e-25,  1.576563754668027e+00, -3.703794013274697e-03, -1.739282599702590e-05,
 -1.988779081584063e-08,  3.795654554849521e-10,  2.894810871535955e-12,  2.989621409151900e-15, -1.014922928799350e-16, -7.769944487588963e-19, -3.612039621008570e-22,
  3.463188553622630e-23,  2.475911835774317e-25,  1.684806563177441e+00, -2.964108334071602e-03, -1.675104959538958e-05, -4.992392883744895e-08,  1.238327070538496e-10,
  2.524103322726639e-12,  1.384297430451229e-14,  2.451199442506031e-18, -5.714286375583198e-19, -4.573169870383231e-21, -9.851886033221602e-24,  1.382453334425831e-25,
  1.780173077011655e+00, -2.195996952360674e-03, -1.428696135202527e-05, -6.361112870878416e-08, -1.146113249243715e-10,  1.089875281478276e-12,  1.322912649121675e-14,
  7.219288942738924e-17,  9.675748071859568e-20, -2.211904802514846e-21, -2.441154700619602e-23, -1.243193153753550e-25,  1.860480513681090e+00, -1.463234360131186e-03,
 -1.058672713875435e-05, -5.956051123459213e-08, -2.440148600134866e-10, -3.969951950958695e-13,  4.520053987052138e-15,  5.751077107659036e-17,  3.860605525456079e-19,
  1.511644810741128e-21, -8.901778891830344e-25, -7.382924588974154e-26,  1.923837767484260e+00, -8.289323422714959e-04, -6.479570305304651e-06, -4.226487949464101e-08,
 -2.350406900387582e-10, -1.067922243421609e-12, -3.236953313461790e-15,  3.075657796770427e-18,  1.473213166346135e-19,  1.441014993029693e-21,  9.751896521692838e-24,
  4.852805500007483e-26,  1.968718611667209e+00, -3.492908354761681e-04, -2.875420742639889e-06, -2.054951219951913e-08, -1.334055807157644e-10, -7.969310931182299e-13,
 -4.362540088284532e-15, -2.138642351591181e-17, -8.797011422234489e-20, -2.365899003875618e-22,  4.542460021002472e-25,  1.351763365485350e-26,  1.994032011530788e+00,
 -6.759320560319940e-05, -5.723600680424181e-07, -4.289881599050700e-09, -2.998292089835120e-11, -1.998681985770505e-13, -1.285251887552858e-15, -8.021439523075847e-18,
 -4.874234563751368e-20, -2.887268572503716e-22, -1.666756402449652e-24, -9.360050594874756e-27,  1.973519094837704e-03, -1.971862413998936e-05,  1.476278815695808e-07,
 -9.812969259777016e-10,  6.105657847410495e-12, -3.640412692020493e-14,  2.105634750368113e-16, -1.190104902032856e-18,  6.602254089281807e-21, -3.605860442435751e-23,
  1.942482809010511e-25, -1.033525274371752e-27,  1.772791978955598e-02, -1.759274924855211e-04,  1.298721498021442e-06, -8.428002519366406e-09,  5.053753995205804e-11,
 -2.856382785230384e-13,  1.533430847331722e-15, -7.826409690301499e-18,  3.778224194088609e-20, -1.703038836005189e-22,  6.963735632679342e-25, -2.402788329860856e-27,
  4.905632898632376e-02, -4.801819470727411e-04,  3.444471514561798e-06, -2.125691216509277e-08,  1.175301877442975e-10, -5.848358573589584e-13,  2.560328574257525e-15,
 -9.137072494855021e-18,  1.891374132263162e-20,  6.965415181370184e-23, -1.220184693873678e-24,  1.001873904503266e-26,  9.559615707900469e-02, -9.164014394641984e-04,
  6.287166606930114e-06, -3.575069899087348e-08,  1.708828280661053e-10, -6.431213667005699e-13,  1.338147675174357e-15,  5.482902288054880e-18, -8.963527017949914e-20,
  6.796702916880920e-22, -3.698104726603035e-24,  1.393567566496004e-26,  1.567991209643536e-01, -1.461091691873313e-03,  9.417518491784673e-06, -4.730499234996668e-08,
  1.731250163305262e-10, -2.467094194715491e-13, -2.672730873310832e-15,  3.051843114949415e-17, -1.869892044932496e-19,  6.890428309722227e-22,  2.346584026961337e-26,
 -2.421666810916316e-26,  2.319262969171364e-01, -2.084127516002305e-03,  1.235752023488518e-05, -5.143491094935256e-08,  1.004024269802857e-10,  5.889783780598646e-13,
 -7.597143633501503e-15,  4.292674630905483e-17, -1.007433583452160e-19, -6.564423420042025e-22,  9.282650707733463e-24, -5.595506420709689e-26,  3.200421095790562e-01,
 -2.749844193075537e-03,  1.461413360433634e-05, -4.485834870744034e-08, -4.545901540040890e-11,  1.564056804293197e-12, -9.795058681462029e-15,  1.949388387683912e-17,
  2.029089431079522e-19, -2.288182537336180e-21,  1.000712149099886e-23,  1.193537331530526e-26,  4.200078232297559e-01, -3.418469539453351e-03,  1.574023172035078e-05,
 -2.645280271219120e-08, -2.322460503549896e-10,  2.184428422057930e-12, -6.122161493667687e-15, -3.809207867770500e-17,  4.843579314515754e-19, -1.778060724182337e-21,
 -7.559027354896733e-24,  1.272848537332631e-25,  5.304753198837727e-01, -4.047924409056713e-03,  1.539769590550285e-05,  2.135137451109418e-09, -4.030947014966992e-10,
  1.984866500072746e-12,  3.402636785263441e-15, -9.282545210793963e-17,  3.849246164529396e-19,  1.645710599160554e-21, -2.603028619194726e-23,  8.010113123557692e-26,
  6.498822100069442e-01, -4.596004612819495e-03,  1.341585569365290e-05,  3.643100457472472e-08, -4.929241952197585e-10,  7.996671494475668e-13,  1.441306438328800e-14,
 -9.321318601847435e-17, -1.840536411197795e-19,  4.849874537168162e-21, -1.392275001714195e-23, -1.586207705872550e-25,  7.764496219067532e-01, -5.022928469647753e-03,
  9.836830443890127e-06,  6.976023672100106e-08, -4.519749432777734e-10, -1.056552043925838e-12,  1.993451368479003e-14, -1.754014365342693e-17, -7.984770297180400e-19,
  3.306922251729944e-21,  2.635811058281180e-23, -2.433906778538208e-25,  9.081843393679437e-01, -5.294188059205464e-03,  4.938249489781817e-06,  9.457049013333067e-08,
 -2.689703117609209e-10, -2.830291457977409e-12,  1.474972876024348e-14,  9.355345114038707e-17, -8.062447200880912e-19, -2.925852009141832e-21,  4.354190571063062e-23,
  6.647923090706116e-26,  1.042887270596777e+00, -5.383576787666527e-03, -7.760131580419685e-07,  1.042713405917946e-07,  1.590235367198371e-11, -3.639481408221433e-12,
 -1.435463268857808e-16,  1.545419109153987e-16, -1.940215682069532e-20, -7.270216367356909e-21,  2.295473998752883e-24,  3.642661649188779e-25,  1.178170478367865e+00,
 -5.276182585378876e-03, -6.624209955947124e-06,  9.520028998300419e-08,  3.168696086283656e-10, -2.947649184294747e-12, -1.660592850172556e-14,  1.040270156981973e-16,
  9.041557396368907e-19, -3.685285614979906e-21, -5.002267574794452e-23,  1.151976747030813e-25,  1.311485097492099e+00, -4.971042450275752e-03, -1.183620976013259e-05,
  6.814371585135940e-08,  5.301267900490377e-10, -9.498067460869946e-13, -2.394761267559370e-14, -2.928683221837181e-17,  1.012850340258337e-18,  4.490947674136270e-21,
 -3.659251327356777e-23, -3.442586772455909e-25,  1.440162301621921e+00, -4.483066390850447e-03, -1.567784229712014e-05,  2.878838236235219e-08,  5.759498009392525e-10,
  1.413662888960267e-12, -1.680640151592992e-14, -1.366064015906885e-16,  1.443684139421336e-19,  7.220819236697016e-21,  2.691733796701050e-23, -2.405827957087992e-25,
  1.561468933507021e+00, -3.843783572968043e-03, -1.759312076159298e-05, -1.334869213296043e-08,  4.379344625793525e-10,  2.929648831463214e-12, -2.001823659099231e-16,
 -1.262756746754762e-16, -7.624666988231983e-19,  1.238209469640464e-21,  4.517858005739273e-23,  2.254183742589703e-25,  1.672678371586785e+00, -3.100475443049847e-03,
 -1.733652445067586e-05, -4.752071356626360e-08,  1.776313133935460e-10,  2.854937502196960e-12,  1.363039136749257e-14, -1.853142450047629e-17, -7.414764889283679e-19,
 -4.821929960644965e-21, -1.976851972058905e-24,  2.217900061968519e-25,  1.771155621693527e+00, -2.313375379513483e-03, -1.506052049536679e-05, -6.525258652115048e-08,
 -8.947362487462574e-11,  1.431900424019948e-12,  1.528049845385648e-14,  7.381594520033817e-17, -1.759720473558075e-21, -3.296871913700062e-21, -2.978312549057098e-23,
 -1.168110747495723e-25,  1.854453567561883e+00, -1.550854016138782e-03, -1.132512006642311e-05, -6.352180081730377e-08, -2.507320898880274e-10, -2.677444167437570e-13,
  6.311402799720099e-15,  7.072154922890558e-17,  4.389575859757576e-19,  1.400112203230424e-21, -4.977067288864313e-24, -1.137468732212898e-25,  1.920415060429388e+00,
 -8.828632004761342e-04, -7.010031162585192e-06, -4.620057957580032e-08, -2.571660614201129e-10, -1.143992257060985e-12, -3.076474695489114e-15,  8.699535393204662e-18,
  2.067503457617621e-19,  1.875584379094428e-21,  1.201719499428094e-23,  5.407211257183692e-26,  1.967273826957884e+00, -3.733181136499176e-04, -3.135366796971110e-06,
 -2.281740863919439e-08, -1.504413934335349e-10, -9.091437069809926e-13, -5.002018643863270e-15, -2.433294991850409e-17, -9.599802116834212e-20, -2.044041903886901e-22,
  1.212865564795301e-24,  2.147458899066444e-26,  1.993752142988113e+00, -7.238647089953938e-05, -6.268545661172819e-07, -4.803342876422057e-09, -3.430789134231144e-11,
 -2.335957849009909e-13, -1.533347979765325e-15, -9.761219399855076e-18, -6.044277120191440e-20, -3.644065397873107e-22, -2.137688074719798e-24, -1.217266717197118e-26,
  1.896934339615794e-03, -1.858309620588077e-05,  1.364152943520146e-07, -8.891674010888429e-10,  5.425529866535165e-12, -3.172775297560723e-14,  1.800133963719803e-16,
 -9.981874912848800e-19,  5.433705807299524e-21, -2.912635269852468e-23,  1.540285193510703e-25, -8.047508361479392e-28,  1.704436768531235e-02, -1.659289399505404e-04,
  1.202254829754350e-06, -7.663176531033408e-09,  4.517573020664245e-11, -2.513344690769669e-13,  1.330333288639041e-15, -6.710299250063638e-18,  3.212790207613210e-20,
 -1.444873104407249e-22,  5.963709615085328e-25, -2.140209428102824e-27,  4.718914120332561e-02, -4.536154062152680e-04,  3.200296055113085e-06, -1.946674995784938e-08,
  1.064275887060874e-10, -5.263876352555844e-13,  2.313278450944077e-15, -8.500320735229598e-18,  2.064127500244573e-20,  2.882604967098901e-23, -8.405835349866046e-25,
  7.357333317227617e-27,  9.202849327849587e-02, -8.677746260023394e-04,  5.874144291963497e-06, -3.311768157024976e-08,  1.583524086097220e-10, -6.094660711825448e-13,
  1.454994046327826e-15,  2.978699140956152e-18, -6.768427482787061e-20,  5.437506481526191e-22, -3.105395081269194e-24,  1.291018029033685e-26,  1.511019052720887e-01,
 -1.387975489815051e-03,  8.866305232522167e-06, -4.457767217294815e-08,  1.676151910088518e-10, -3.012540419488979e-13, -1.898266746879730e-15,  2.492994383110679e-17,
 -1.623961850569000e-19,  6.716356810844592e-22, -8.256907997873871e-25, -1.485360015910152e-26,  2.237836377798622e-01, -1.987708087503146e-03,  1.175029767214989e-05,
 -4.974374039923221e-08,  1.104540715305920e-10,  4.206866387876982e-13, -6.443396811915669e-15,  3.939181530982117e-17, -1.182665678314906e-19, -3.323129575407909e-22,
  6.978015531863553e-24, -4.853977332859453e-26,  3.092731352846801e-01, -2.635094394476719e-03,  1.407246079431135e-05, -4.534801878695863e-08, -1.648100217852762e-11,
  1.336185725581044e-12, -9.170155601944928e-15,  2.474686082956215e-17,  1.278061836552544e-19, -1.883851327398753e-21,  1.006468455856674e-23, -7.961007537901972e-27,
  4.065836934941914e-01, -3.293877324357272e-03,  1.540191741303156e-05, -2.982754617097673e-08, -1.901043995604547e-10,  2.026388076490069e-12, -6.981725219787344e-15,
 -2.366468050704732e-17,  4.161799852311645e-19, -1.976678417738054e-21, -2.579937933823145e-24,  9.878340395314484e-26,  5.145299968728745e-01, -3.924746955432996e-03,
  1.538594249529726e-05, -3.993220119150281e-09, -3.627838666052217e-10,  2.036780057529900e-12,  9.834868148279977e-16, -7.975346235650368e-17,  4.263572461143953e-19,
  6.834494711645259e-22, -2.190680696811200e-23,  1.043095336629369e-25,  6.317154264711492e-01, -4.487061821277437e-03,  1.380629323785340e-05,  2.869006149353668e-08,
 -4.736858943107144e-10,  1.113752693462236e-12,  1.174604710988569e-14, -9.642932533121248e-17, -2.098436427653108e-20,  4.173157490046981e-21, -1.942597504398873e-23,
 -9.187859213492943e-26,  7.565204236290319e-01, -4.941009710027392e-03,  1.062994999093292e-05,  6.238536645550666e-08, -4.683759122583530e-10, -5.867877449100897e-13,
  1.910489687366246e-14, -4.100439068278385e-17, -6.630748097828264e-19,  4.142705338601353e-21,  1.538164900042351e-23, -2.502580407618263e-25,  8.870936776862471e-01,
 -5.250220012564209e-03,  6.045470836712408e-06,  8.983418920844261e-08, -3.218394627734253e-10, -2.447864590851193e-12,  1.699461319927468e-14,  6.640825713895522e-17,
 -8.798144140696568e-19, -1.157874231278762e-21,  4.407514696114313e-23, -4.062651715923158e-26,  1.021348470677805e+00, -5.384781069081709e-03,  4.743709011136431e-07,
  1.039447409328134e-07, -5.657260858520176e-11, -3.591311027942939e-12,  4.135895106369128e-15,  1.497821629353108e-16, -2.756648878224465e-19, -6.864027778379204e-21,
  1.777851207194456e-23,  3.320374928030181e-25,  1.156967111488987e+00, -5.324525078536142e-03, -5.453399741773200e-06,  9.977797317549799e-08,  2.541834626693586e-10,
 -3.308105069429433e-12, -1.331073945075551e-14,  1.304633359307455e-16,  7.370429317523603e-19, -5.546308501455669e-21, -4.210025091922555e-23,  2.423038986543535e-25,
  1.291416928665583e+00, -5.062318683209747e-03, -1.096832162446425e-05,  7.644233661546236e-08,  5.053363285192191e-10, -1.530588790212135e-12, -2.429176349266486e-14,
  5.399912513133916e-18,  1.144664161457879e-18,  2.740075570643558e-21, -5.046578153107297e-23, -2.776554081660166e-25,  1.421981602309356e+00, -4.606948628551918e-03,
 -1.527623202455927e-05,  3.820656173580678e-08,  5.998834415438655e-10,  9.651786079202751e-13, -2.052627366050286e-14, -1.276424843949911e-16,  4.208192047063421e-19,
  8.049885060757212e-21,  1.366409747702185e-23, -3.599357667473964e-25,  1.545811468810561e+00, -3.985045712906605e-03, -1.770933403880841e-05, -5.874509050312747e-09,
  4.961789749291409e-10,  2.879712870400401e-12, -4.068190426045538e-15, -1.495941080150545e-16, -6.831110042347650e-19,  3.227819561314744e-21,  5.382353682420460e-23,
  1.596283578210134e-25,  1.659995547925017e+00, -3.241395863286443e-03, -1.788777917650754e-05, -4.420427523348676e-08,  2.379447903589521e-10,  3.172998717089183e-12,
  1.275324330346822e-14, -4.503068304653784e-17, -9.138945115184362e-19, -4.679079971556953e-21,  9.788599257531849e-24,  3.134712921146995e-25,  1.761656161329949e+00,
 -2.437013695027134e-03, -1.585112948591009e-05, -6.643443355510206e-08, -5.700141118104270e-11,  1.823310051648036e-12,  1.732701823309019e-14,  7.162103885104567e-17,
 -1.430693828687776e-19, -4.584004222537389e-21, -3.435240437038162e-23, -8.629614217974100e-26,  1.848064025173292e+00, -1.644572572278563e-03, -1.211160009918578e-05,
 -6.756742088602809e-08, -2.544034500320419e-10, -9.087609645413440e-14,  8.495501857825160e-15,  8.552560804188211e-17,  4.844438263723513e-19,  1.086698960192492e-21,
 -1.106612322914841e-23, -1.648851496181014e-25,  1.916767834808244e+00, -9.412327912286020e-04, -7.589893828827633e-06, -5.050218994024289e-08, -2.807603889870406e-10,
 -1.214091173888740e-12, -2.729424189346338e-15,  1.649337250849892e-17,  2.835063788599932e-19,  2.404807436861654e-21,  1.445920498715360e-23,  5.611101375987590e-26,
  1.965728594865243e+00, -3.995386291506473e-04, -3.424239885949849e-06, -2.537669453789520e-08, -1.698817606658368e-10, -1.037721569935433e-12, -5.727376247967039e-15,
 -2.751123094654210e-17, -1.022277250103565e-19, -1.338728345394463e-22,  2.398492403046835e-24,  3.314016901991481e-26,  1.993452188718096e+00, -7.764156816699075e-05,
 -6.879491520086516e-07, -5.391740969465058e-09, -3.937113222928239e-11, -2.739072058593004e-13, -1.835836669302767e-15, -1.192289629363837e-17, -7.523874751130868e-20,
 -4.616420560301568e-22, -2.751005010406140e-24, -1.587289611991472e-26,  1.824719044465711e-03, -1.753302488908874e-05,  1.262459313256057e-07, -8.072097874848724e-10,
  4.832011716144086e-12, -2.772410217777459e-14,  1.543489081775554e-16, -8.399624853630413e-19,  4.488031010329361e-21, -2.361839895039521e-23,  1.226448714463923e-25,
 -6.293909944337016e-28,  1.639932245899649e-02, -1.566668170540640e-04,  1.114473150412054e-06, -6.978905460078233e-09,  4.045368245169310e-11, -2.215496023001019e-13,
  1.156088025063290e-15, -5.761006565037410e-18,  2.733376904651827e-20, -1.224370787522318e-22,  5.080805022464580e-25, -1.874124887615022e-27,  4.542444467986678e-02,
 -4.289192743755917e-04,  2.976574241728260e-06, -1.784519361518594e-08,  9.643613311833867e-11, -4.736496795313559e-13,  2.084629978401186e-15, -7.829090965419425e-18,
  2.114596804255351e-20,  1.044022404441411e-24, -5.631299679025958e-25,  5.348746916762852e-27,  8.864892374099248e-02, -8.223289624648989e-04,  5.491537910005878e-06,
 -3.067963611426143e-08,  1.465178502826145e-10, -5.737728602102117e-13,  1.510853244593336e-15,  1.103116548653117e-18, -5.021185475342942e-20,  4.304943985956457e-22,
 -2.567829350681153e-24,  1.148482283629658e-26,  1.456885400351124e-01, -1.319139657739113e-03,  8.347258002501831e-06, -4.194627805149215e-08,  1.611881262840214e-10,
 -3.390011231323101e-13, -1.269399111219376e-15,  2.011260816635807e-17, -1.389493061024239e-19,  6.276993006318566e-22, -1.321880821390196e-24, -8.083384906977412e-27,
  2.160170728592216e-01, -1.896062775472291e-03,  1.116422782036560e-05, -4.791720038930589e-08,  1.174084793238112e-10,  2.788438844855928e-13, -5.394847301076872e-15,
  3.546570992320396e-17, -1.256983880655290e-19, -9.348609771744517e-23,  5.023891509481696e-24, -4.024081076361858e-26,  2.989544668826650e-01, -2.524693941343152e-03,
  1.352754620253445e-05, -4.540963985936712e-08,  8.100133442219622e-12,  1.124819175229415e-12, -8.429633019564047e-15,  2.782831684447155e-17,  6.711107274857337e-20,
 -1.492412400354736e-21,  9.417067361402567e-24, -2.037080931626546e-26,  3.936522789669088e-01, -3.172142395716673e-03,  1.502704420970785e-05, -3.255429770159573e-08,
 -1.512984269697186e-10,  1.852313982213197e-12, -7.468680676112621e-15, -1.149741000984946e-17,  3.441325172832460e-19, -2.001380784872646e-21,  1.139115290790663e-24,
  7.058311876422995e-26,  4.990767454250754e-01, -3.801946666666245e-03,  1.530454302450251e-05, -9.471325991110340e-09, -3.219850665265096e-10,  2.035145199887306e-12,
 -1.056055898183232e-15, -6.587628620889538e-17,  4.363269013703409e-19, -9.770122114671597e-23, -1.709526882639948e-23,  1.119911137139539e-25,  6.139900807788928e-01,
 -4.375361407126735e-03,  1.410588231416762e-05,  2.130368681232606e-08, -4.488103140316081e-10,  1.363314970530912e-12,  9.058100658709186e-15, -9.485384006556817e-17,
  1.144583509002110e-19,  3.333819123655551e-21, -2.209770219243248e-23, -3.111111947658380e-26,  7.369310244456783e-01, -4.853103742925867e-03,  1.133330255347355e-05,
  5.482194690919003e-08, -4.756312828841812e-10, -1.443038545420457e-13,  1.768285971935803e-14, -5.973914024382219e-17, -5.054779515030940e-19,  4.542333865018172e-21,
  4.759475405994183e-24, -2.284687372654645e-25,  8.661962242607985e-01, -5.197635318993293e-03,  7.091042302192151e-06,  8.431583503982587e-08, -3.665839949761379e-10,
 -2.020888577618798e-12,  1.845601827396378e-14,  3.792230262274594e-17, -8.904547386395975e-19,  5.411054402313161e-22,  4.021311596021423e-23, -1.311776871475750e-25,
  9.998248072680098e-01, -5.376017558814552e-03,  1.713927873314135e-06,  1.024717677603141e-07, -1.270726088028768e-10, -3.442942272776387e-12,  8.170288490636051e-15,
  1.371719541397703e-16, -5.066157480635701e-19, -5.879600518645318e-21,  3.090903707769454e-23,  2.589541270544525e-25,  1.135589430747631e+00, -5.363298930591934e-03,
 -4.233898521499566e-06,  1.032995420504058e-07,  1.851356250742514e-10, -3.581257547280526e-12, -9.359774061734142e-15,  1.505518552325775e-16,  5.099315043728242e-19,
 -6.984774243673432e-21, -2.908420271670320e-23,  3.434653084796315e-25,  1.270998161127619e+00, -5.146261104300049e-03, -1.000361377256234e-05,  8.425127410622465e-08,
  4.689285021996768e-10, -2.107560980210658e-12, -2.361583446607281e-14,  4.319574233365295e-17,  1.204302819449036e-18,  5.080423536401313e-22, -6.028642825062379e-23,
 -1.612236984366609e-25,  1.403312523844641e+00, -4.727160114225770e-03, -1.475961740522597e-05,  4.793117479725034e-08,  6.139802265893084e-10,  4.314525881347865e-13,
 -2.386760691471007e-14, -1.094669131806416e-16,  7.163519887940302e-19,  8.248904018112816e-21, -4.416581399749871e-24, -4.561320914703605e-25,  1.529587686403052e+00,
 -4.126863065518129e-03, -1.773031553428346e-05,  2.518336634513899e-09,  5.524453319532516e-10,  2.729465084931925e-12, -8.542356692884646e-15, -1.691669268221181e-16,
 -5.267338269129941e-19,  5.490862547804318e-21,  5.848549553097859e-23,  4.389319604130190e-26,  1.646740498342831e+00, -3.386550252299840e-03, -1.839324104932948e-05,
 -3.987333867143771e-08,  3.043456862415691e-10,  3.460489358764297e-12,  1.105833915342003e-14, -7.686631196754369e-17, -1.071727109043609e-18, -3.985202360326964e-21,
  2.553956632461164e-23,  4.002425246864149e-25,  1.751649421415475e+00, -2.567024166542906e-03, -1.665253641393712e-05, -6.703146161641569e-08, -1.621764507285918e-11,
  2.262543687910547e-12,  1.924157420688753e-14,  6.413070779383539e-17, -3.336019608153895e-19, -6.018108719494530e-21, -3.689213892637008e-23, -2.288748609406198e-26,
  1.841286716381309e+00, -1.744777868998970e-03, -1.294685367274082e-05, -7.164049197774754e-08, -2.539788850665557e-10,  1.435370246469290e-13,  1.111243461447338e-14,
  1.015530972890472e-16,  5.136913201800219e-19,  4.815059175844453e-22, -1.964253814404801e-23, -2.264754104323434e-25,  1.912877516902520e+00, -1.004454281486290e-03,
 -8.223685458974262e-06, -5.519199339572979e-08, -3.056542147631667e-10, -1.272946318831676e-12, -2.126760441299791e-15,  2.706716385054524e-17,  3.810789044142660e-19,
  3.031756347975722e-21,  1.685277622752287e-23,  5.115728058796735e-26,  1.964073656504750e+00, -4.281984646015625e-04, -3.745778689843987e-06, -2.826857526575024e-08,
 -1.920750845121372e-10, -1.184795744668113e-12, -6.544063439740280e-15, -3.083799724222773e-17, -1.049283096864108e-19, -4.239208062501228e-24,  4.205961999382777e-24,
  5.002892830983734e-26,  1.993130189798954e+00, -8.341510637383262e-05, -7.566185280323275e-07, -6.068016774184199e-09, -4.531839237959411e-11, -3.222615930048936e-13,
 -2.206042841253516e-15, -1.461912417263422e-17, -9.401891679572762e-20, -5.869881208913918e-22, -3.551742289458442e-24, -2.074521984459431e-26,  1.756547333400293e-03,
 -1.656053007263586e-05,  1.170056198953384e-07, -7.341398996076651e-10,  4.312749033181347e-12, -2.428648014102665e-14,  1.327192231057426e-16, -7.090544572984646e-19,
  3.719788761536945e-21, -1.922416631442706e-23,  9.804912144874001e-26, -4.943596923798885e-28,  1.578997146661468e-02, -1.480753431374853e-04,  1.034468353299051e-06,
 -6.365640055803785e-09,  3.628757959766598e-11, -1.956442854177220e-13,  1.006389793274216e-15, -4.953084069614304e-18,  2.327267068861168e-20, -1.036873654807771e-22,
  4.312465226527433e-25, -1.621436696159800e-27,  4.375507263960111e-02, -4.059377217580639e-04,  2.771385783473296e-06, -1.637535423479411e-08,  8.744608913651862e-11,
 -4.261727806375363e-13,  1.874866003161964e-15, -7.155734720542667e-18,  2.083043528697034e-20, -1.724904621668739e-23, -3.624594298716817e-25,  3.845363964520020e-27,
  8.544519597453432e-02, -7.798302881583713e-04,  5.137075703235477e-06, -2.842517660303223e-08,  1.354066196293803e-10, -5.373096660483825e-13,  1.521439690972067e-15,
 -2.745603966838871e-19, -3.644524487156471e-20,  3.374327448699704e-22, -2.096603638704479e-24,  9.928924475535121e-27,  1.405424108195157e-01, -1.254331697016471e-03,
  7.859148125308774e-06, -3.942298081085325e-08,  1.541465539697584e-10, -3.631908066851125e-13, -7.651745856119695e-16,  1.601697807941197e-17, -1.173755338093702e-19,
  5.692290668969814e-22, -1.567386906760980e-24, -3.373967794833975e-27,  2.086078532833183e-01, -1.809016663641178e-03,  1.060065478162576e-05, -4.600075515023662e-08,
  1.217686724253892e-10,  1.608276962839101e-13, -4.458369073143020e-15,  3.142498077563896e-17, -1.258512073445449e-19,  7.448864924367476e-23,  3.434137999786365e-24,
 -3.210932140824057e-26,  2.890686860001537e-01, -2.418649391559656e-03,  1.298411564396191e-05, -4.511079021676981e-08,  2.863757247163418e-11,  9.320538802920159e-13,
 -7.627943883455808e-15,  2.918704348302547e-17,  1.992693699777632e-20, -1.135949371259358e-21,  8.358694835060689e-24, -2.690296708452921e-26,  3.812016134979498e-01,
 -3.053527049713668e-03,  1.462305872079167e-05, -3.468852937138401e-08, -1.160645565676208e-10,  1.670380781655165e-12, -7.647172675436098e-15, -1.623561747269355e-18,
  2.735809104599196e-19, -1.901396014281389e-21,  3.676591507675849e-24,  4.540590657368433e-26,  4.841129920472629e-01, -3.680049444580666e-03,  1.516131363585204e-05,
 -1.429943976306132e-08, -2.816768994914600e-10,  1.989235454237427e-12, -2.706531410509372e-15, -5.209246139789715e-17,  4.216841835432924e-19, -6.836011745195892e-22,
 -1.223471513124195e-23,  1.072572206579600e-25,  5.967157788277763e-01, -4.261611703521012e-03,  1.431937636863106e-05,  1.435176974392750e-08, -4.195826117609100e-10,
  1.549357125736080e-12,  6.470285994859505e-15, -8.944322279303841e-17,  2.183778273142295e-19,  2.437970794562991e-21, -2.233634585061308e-23,  1.805352448464981e-26,
  7.177039260363157e-01, -4.759935313238369e-03,  1.194548313622787e-05,  4.721121655855230e-08, -4.744177639569952e-10,  2.583365540589459e-13,  1.580844400854160e-14,
 -7.328032212969414e-17, -3.408497497439540e-19,  4.542889181360008e-21, -4.424275423919178e-24, -1.864123392473752e-25,  8.455254030458780e-01, -5.136962445173519e-03,
  8.066385278613411e-06,  7.815151902361855e-08, -4.025028393475297e-10, -1.568393334994974e-12,  1.912398901562314e-14,  1.003728942882987e-17, -8.436069044679419e-19,
  2.013260015170805e-21,  3.293003731878577e-23, -1.948920315304554e-25,  9.783558921324655e-01, -5.357427212437710e-03,  2.929155768878862e-06,  9.989965981384482e-08,
 -1.936697438452218e-10, -3.202784021367480e-12,  1.175414115671740e-14,  1.178328450024621e-16, -6.935353541447807e-19, -4.443626056131655e-21,  4.015123476101036e-23,
  1.578376316478015e-25,  1.114076407238291e+00, -5.392166899423117e-03, -2.978930173181721e-06,  1.056779690780574e-07,  1.116140968134332e-10, -3.753702401543407e-12,
 -4.955097492786583e-15,  1.626527666111232e-16,  2.413754096737793e-19, -7.825232572496414e-21, -1.251491170174215e-23,  4.014937025433720e-25,  1.250259637582722e+00,
 -5.222121805976837e-03, -8.949070778259063e-06,  9.138661495768019e-08,  4.212299664199428e-10, -2.655472516028238e-12, -2.186746259236119e-14,  8.154932003491777e-17,
  1.177865898454464e-18, -2.002078086513597e-21, -6.409586003212727e-23, -7.284597250201701e-27,  1.384171608650793e+00, -4.842768905826520e-03, -1.412531999160673e-05,
  5.779177544955504e-08,  6.166473256638980e-10, -1.752883540433088e-13, -2.656758815780535e-14, -8.186682905122760e-17,  1.005118353144430e-18,  7.652132009565905e-21,
 -2.578448354238865e-23, -5.055669652950156e-25,  1.512796957993802e+00, -4.268430376213630e-03, -1.764529985619570e-05,  1.178139488790411e-08,  6.045917878736401e-10,
  2.465902603429290e-12, -1.348206276647475e-14, -1.824070163594806e-16, -2.868916475873642e-19,  7.823907114825265e-21,  5.697257363335143e-23, -1.198512852400911e-25,
  1.632897099019909e+00, -3.535521969215826e-03, -1.884017546494600e-05, -3.443651243105095e-08,  3.760145795378318e-10,  3.696062414916681e-12,  8.405992382275743e-15,
 -1.132241502803399e-16, -1.192367522696110e-18, -2.590535300746199e-21,  4.464907593582659e-23,  4.623441062549866e-25,  1.741109788291086e+00, -2.703462774196718e-03,
 -1.745689468189158e-05, -6.690325977710109e-08,  3.378953393765819e-11,  2.744472693359506e-12,  2.085317617410810e-14,  4.970383798509852e-17, -5.768116520257943e-19,
 -7.486137192310239e-21, -3.573898782998087e-23,  8.298172049849541e-26,  1.834094913453522e+00, -1.851860206995669e-03, -1.383077715370003e-05, -7.566569724801720e-08,
 -2.482011913733447e-10,  4.462248948895848e-13,  1.418746115813227e-14,  1.180962563378051e-16,  5.143016191914255e-19, -5.232988755643689e-22, -3.109504255740118e-23,
 -2.946215739288523e-25,  1.908723806274518e+00, -1.072978070299190e-03, -8.916180545683366e-06, -6.028862172966521e-08, -3.315546084843900e-10, -1.313410416042823e-12,
 -1.180796605093608e-15,  4.114226908651849e-17,  5.028643166105414e-19,  3.746914464395585e-21,  1.877984350521956e-23,  3.383108742391160e-26,  1.962298705572775e+00,
 -4.595756879721156e-04, -4.104251227031461e-06, -3.154017778928496e-08, -2.174134721161503e-10, -1.352593121702428e-12, -7.454299911245316e-15, -3.416099143760756e-17,
 -1.014639920103675e-19,  2.145223161008346e-22,  6.907605721098181e-24,  7.416550528199942e-26,  1.992783944235244e+00, -8.977215524989563e-05, -8.340077015299283e-07,
 -6.847695137604483e-09, -5.232807429573671e-11, -3.804791712945502e-13, -2.660881905085427e-15, -1.799514263672958e-17, -1.179435490053013e-19, -7.490751957109760e-22,
 -4.599280272601521e-24, -2.716038593755341e-26,  1.692123117197882e-03, -1.565858658452742e-05,  1.085944786576094e-07, -6.688552021681555e-10,  3.857330805476527e-12,
 -2.132662375462087e-14,  1.144332825331930e-16, -6.003779489636573e-19,  3.093373122363032e-21, -1.570455356717232e-23,  7.869133948919837e-26, -3.899214249893259e-28,
  1.521375135189460e-02, -1.400955658934038e-04,  9.614392807438660e-07, -5.815075217980103e-09,  3.260541455118776e-11, -1.730743460557637e-13,  8.775913880361370e-16,
 -4.264888650561960e-18,  1.983386683364885e-20, -8.779468928141784e-23,  3.650683466624543e-25, -1.390678735736605e-27,  4.217445214303327e-02, -3.845294993887974e-04,
  2.583002819720990e-06, -1.504202640396148e-08,  7.935675866342532e-11, -3.835056665968933e-13,  1.683725974223872e-15, -6.501585116139862e-18,  1.998601344637932e-20,
 -2.871675634217027e-23, -2.190482627121334e-25,  2.728712272392561e-27,  8.240595865531422e-02, -7.400620642520731e-04,  4.808624409118248e-06, -2.634266112474040e-08,
  1.250243136323746e-10, -5.010084854270774e-13,  1.499140133999173e-15, -1.261805560441318e-18, -2.570608665760866e-20,  2.618510257325569e-22, -1.693604489239716e-24,
  8.403209551900760e-27,  1.356478927120766e-01, -1.193309445035984e-03,  7.400627885502003e-06, -3.701559918022258e-08,  1.467333076826745e-10, -3.765792258182662e-13,
 -3.662904087104117e-16,  1.257650946287947e-17, -9.803810047396102e-20,  5.045858598454087e-22, -1.642009080580927e-24, -2.419046879507232e-28,  2.015379480835289e-01,
 -1.726386132417533e-03,  1.006042362430867e-05, -4.403224665434309e-08,  1.239841514759248e-10,  6.393391382296928e-14, -3.634274144860767e-15,  2.746453080046378e-17,
 -1.210170450764970e-19,  1.858341899103474e-22,  2.186806000753126e-24, -2.474514577069680e-26,  2.795984186491068e-01, -2.316932641437548e-03,  1.244611906476681e-05,
 -4.451312857990642e-08,  4.551436002262886e-11,  7.588265918580900e-13, -6.807480808259442e-15,  2.923255193621478e-17, -1.524313455444028e-20, -8.261977073138290e-22,
  7.112685941043011e-24, -2.914990910829532e-26,  3.692187966074275e-01, -2.938236724731839e-03,  1.419672431942970e-05, -3.628827172211182e-08, -8.449109634196074e-11,
  1.487230245452975e-12, -7.580135457923051e-15,  6.067721488632506e-18,  2.081999054556414e-19, -1.720829876557573e-21,  5.200500776347775e-24,  2.465002315022440e-26,
  4.696341843204355e-01, -3.559518926362770e-03,  1.496397954966619e-05, -1.849199060893118e-08, -2.426521312799364e-10,  1.908274552316659e-12, -3.980526319172600e-15,
 -3.907773275370428e-17,  3.893734367781819e-19, -1.081933808484253e-21, -7.775865066757050e-24,  9.441992844715273e-26,  5.798993748192488e-01, -4.146479528421879e-03,
  1.445236529076793e-05,  7.893946034555940e-09, -3.872410549479079e-10,  1.675455704204102e-12,  4.075686397372561e-15, -8.122104349781844e-17,  2.903593966387334e-19,
  1.571768873523538e-21, -2.071862239981290e-23,  5.308429763482091e-26,  6.988587190716709e-01, -4.662233828331733e-03,  1.246670895122983e-05,  3.968176251213125e-08,
 -4.656289403078977e-10,  6.120340219900533e-13,  1.362814835249337e-14, -8.162011661020984e-17, -1.823315545246443e-19,  4.216959890031693e-21, -1.148640660278425e-23,
 -1.335863887222796e-25,  8.251123974453453e-01, -5.068791792488469e-03,  8.964609005467771e-06,  7.148550995893520e-08, -4.292736335319993e-10, -1.109019923492097e-12,
  1.903970455225897e-14, -1.556179961801691e-17, -7.495983731106980e-19,  3.147127341534937e-21,  2.352790364723070e-23, -2.272347704744842e-25,  9.569805614936071e-01,
 -5.329256224056804e-03,  4.107298155821739e-06,  9.630490073726241e-08, -2.546507321970803e-10, -2.883737051980388e-12,  1.472098705910353e-14,  9.340177745286046e-17,
 -8.232218543551994e-19, -2.731543923032561e-21,  4.463216678142606e-23,  4.543271345160197e-26,  1.092468143577426e+00, -5.410901179126001e-03, -1.702573703473308e-06,
  1.068583015923258e-07,  3.572311830473365e-11, -3.817363487358461e-12, -3.355205994255822e-16,  1.658077893815001e-16, -4.502927122876640e-20, -7.967029934108037e-21,
  5.462295144652863e-24,  4.066054982030379e-25,  1.229235066811536e+00, -5.289217457551371e-03, -7.813835998500462e-06,  9.767375559705207e-08,  3.630789439674842e-10,
 -3.148716132610865e-12, -1.907074986637053e-14,  1.175953501975247e-16,  1.060016647142102e-18, -4.522596583559562e-21, -6.068947804004317e-23,  1.626061609639430e-25,
  1.364579156235932e+00, -4.952830227576806e-03, -1.337285041990780e-05,  6.759473158671703e-08,  6.065994978541183e-10, -8.365368729690835e-13, -2.836982489943601e-14,
 -4.553809614425891e-17,  1.256657745433831e-18,  6.175618241234339e-21, -4.791509039322217e-23, -4.880709168773883e-25,  1.495442044027707e+00, -4.408859193875390e-03,
 -1.744431654053978e-05,  2.183007560670283e-08,  6.502562449928741e-10,  2.080282601841117e-12, -1.867258406102843e-14, -1.866548114300955e-16,  3.400691017375230e-20,
  9.940779424907307e-21,  4.742468986655336e-23, -3.180062213169536e-25,  1.618451103039974e+00, -3.687788366005933e-03, -1.921484444044753e-05, -2.781910419725869e-08,
  4.516738730897318e-10,  3.855378464987821e-12,  4.690206396511016e-15, -1.524870093384083e-16, -1.248495201669026e-18, -3.895905046774506e-22,  6.548932306621766e-23,
  4.744146381197785e-25,  1.730011560931965e+00, -2.846315746915900e-03, -1.825458937275422e-05, -6.589588669019690e-08,  9.378460699556758e-11,  3.259304998294024e-12,
  2.194404321954879e-14,  2.666752404298336e-17, -8.707897990913750e-19, -8.800789622561028e-21, -2.886745267259293e-23,  2.375925603796587e-25,  1.826460335341441e+00,
 -1.966205084242672e-03, -1.476223524698420e-05, -7.954586245500186e-08, -2.355943564307422e-10,  8.282373798520850e-13,  1.771986710954885e-14,  1.339858743915319e-16,
  4.697676520856524e-19, -2.046331305155689e-21, -4.553717740690258e-23, -3.603514668717134e-25,  1.904284523210229e+00, -1.147293555665607e-03, -9.672343934880838e-06,
 -6.580475485442755e-08, -3.580029518136909e-10, -1.325977491313529e-12,  2.177964262345924e-16,  5.953951982313265e-17,  6.515521255964417e-19,  4.518615281334909e-21,
  1.953272130007572e-23, -3.753174884430106e-27,  1.960392251468819e+00, -4.939848835220580e-04, -4.504530156495258e-06, -3.524526035175842e-08, -2.463337020544412e-10,
 -1.543332096265343e-12, -8.454682770797334e-15, -3.722402958730201e-17, -8.789897434632488e-20,  5.652829235767688e-22,  1.087771836386489e-23,  1.081704972799605e-25,
  1.992410970180256e+00, -9.678774121911497e-05, -9.214663814148134e-07, -7.749470102485262e-09, -6.061939704471480e-11, -4.508394358492725e-13, -3.221905949733556e-15,
 -2.223878314588114e-17, -1.485305640466722e-19, -9.592649316036894e-22, -5.971568205672684e-24, -3.559484287721544e-26,  1.631176889186984e-03, -1.482091808556240e-05,
  1.009249126366581e-07, -6.104064689197338e-10,  3.456956329676517e-12, -1.877126780639233e-14,  9.892768252820372e-17, -5.098603452665674e-19,  2.580765891013985e-21,
 -1.287466821204488e-23,  6.339314376118097e-26, -3.087988416457138e-28,  1.466832235386048e-02, -1.326745624196719e-04,  8.946778678908338e-07, -5.319975449222230e-09,
  2.934523541592072e-11, -1.533762586014625e-13,  7.666043520084860e-16, -3.678072245272125e-18,  1.692193142896364e-20, -7.435341325192397e-23,  3.084914500015191e-25,
 -1.185283588595993e-27,  4.067654871863716e-02, -3.645664780262044e-04,  2.409870584006627e-06, -1.383154420099483e-08,  7.207636321300928e-11, -3.452095165666310e-13,
  1.510469134621935e-15, -5.880045733097726e-18,  1.882102109087857e-20, -3.533831198202389e-23, -1.180173606257444e-25,  1.905435894030741e-27,  7.952069336784023e-02,
 -7.028242589980455e-04,  4.504190439884194e-06, -2.442049216318216e-08,  1.153606307013748e-10, -4.655377818918294e-13,  1.453621235902434e-15, -1.945951170600890e-18,
 -1.741362262485146e-20,  2.010769293124607e-22, -1.355356252401176e-24,  6.995696475204876e-27,  1.309903073802742e-01, -1.135841834187319e-03,  6.970277315623891e-06,
 -3.472848301521519e-08,  1.391405744309926e-10, -3.814826626396507e-13, -5.542869032189751e-17,  9.717274975659339e-18, -8.105176303312011e-20,  4.393432473240971e-22,
 -1.605853450997315e-24,  1.722343512951385e-27,  1.947900715818998e-01, -1.647982499916892e-03,  9.543966683846477e-06, -4.204275622386533e-08,  1.244506602132108e-10,
 -1.449144632275409e-14, -2.918368576934542e-15,  2.371389595632213e-17, -1.129971087216936e-19,  2.534703030686563e-22,  1.241005096965462e-24, -1.842962096138812e-26,
  2.705264619178525e-01, -2.219486842065427e-03,  1.191680372840159e-05, -4.367208655076306e-08,  5.912300135645068e-11,  6.051884890643960e-13, -5.999892724035376e-15,
  2.832128074391419e-17, -4.017434749149926e-20, -5.673211078793486e-22,  5.835939484309823e-24, -2.850943516673008e-26,  3.576902098443056e-01, -2.826425552086910e-03,
  1.375410365585400e-05, -3.741198633018953e-08, -5.654830903611037e-11,  1.308042840217417e-12, -7.325981830674640e-15,  1.178088156988398e-17,  1.502092931772746e-19,
 -1.496154883459283e-21,  5.917257822225957e-24,  8.719942923594453e-27,  4.556340374976449e-01, -3.440757841785827e-03,  1.472002274866106e-05, -2.207463855671212e-08,
 -2.055234781420026e-10,  1.800981837135580e-12, -4.906501275354195e-15, -2.729316534207260e-17,  3.457827774782228e-19, -1.314715831170855e-21, -3.988066943814097e-24,
  7.732915446586508e-26,  5.635451491860692e-01, -4.030584448791091e-03,  1.451103845247231e-05,  1.970723042794097e-09, -3.529323577913784e-10,  1.747078533048963e-12,
  1.938972930555674e-15, -7.117913654954853e-17,  3.326553457752057e-19,  7.968769972157427e-22, -1.787382151451319e-23,  7.400422794523217e-26,  6.804120894812035e-01,
 -4.560721041343417e-03,  1.289864908305558e-05,  3.234660889406573e-08, -4.503054432617757e-10,  9.111627482843817e-13,  1.128322872185115e-14, -8.512495588773386e-17,
 -4.005968746172259e-20,  3.656199153301071e-21, -1.615166379592672e-23, -7.878128008003941e-26,  8.049859300567495e-01, -4.993761903729655e-03,  9.780572807579050e-06,
  6.446432089576331e-08, -4.469333392512102e-10, -6.598956349716226e-13,  1.828636701300153e-14, -3.757432338900889e-17, -6.217992519536156e-19,  3.885618597568076e-21,
  1.338261844375349e-23, -2.292513955325912e-25,  9.357364691376607e-01, -5.291848722944761e-03,  5.236671707722494e-06,  9.178912184815115e-08, -3.085963259842522e-10,
 -2.502105618123286e-12,  1.695511991632143e-14,  6.583182842591631e-17, -8.892363884097502e-19, -9.386114302141189e-22,  4.423639338541011e-23, -6.116615831243502e-26,
  1.070805424986215e+00, -5.419388651011098e-03, -4.193612435727255e-07,  1.068202279967447e-07, -4.033058216635132e-11, -3.770130041148639e-12,  4.244307521411018e-15,
  1.598544517457502e-16, -3.236865664927377e-19, -7.401197008176012e-21,  2.247868847849556e-23,  3.586118926338723e-25,  1.207960731726646e+00, -5.346945989582955e-03,
 -6.609050839843289e-06,  1.029555422416901e-07,  2.958134590707493e-10, -3.563235861140136e-12, -1.533091375251051e-14,  1.484592694892422e-16,  8.556751846111977e-19,
 -6.758596438467123e-21, -4.995137850395875e-23,  3.213127635885488e-25,  1.344559237871313e+00, -5.056405002453244e-03, -1.250415301981995e-05,  7.712913412436157e-08,
  5.829810267095188e-10, -1.527978214066806e-12, -2.905136114670645e-14, -2.178578430940653e-18,  1.439498389818113e-18,  3.851803592110882e-21, -6.758176984916588e-23,
 -3.928546907803670e-25,  1.477529410930585e+00, -4.547186017834497e-03, -1.711864176066677e-05,  3.254090130928027e-08,  6.869592277553974e-10,  1.569890551037417e-12,
 -2.382745047067067e-14, -1.795056179419827e-16,  4.220910277405021e-19,  1.149673525755821e-20,  2.886981343570733e-23, -5.237905151276685e-25,  1.603390579022804e+00,
 -3.842713690863845e-03, -1.950275279978474e-05, -1.997087852327638e-08,  5.295379335723161e-10,  3.912199341097492e-12, -1.370261571786278e-16, -1.921174933694984e-16,
 -1.210442083295103e-18,  2.634755018713205e-21,  8.525544653036342e-23,  4.091651805468235e-25,  1.718329259207319e+00, -2.995484813975357e-03, -1.903409230885624e-05,
 -6.384503574440409e-08,  1.642802164639583e-10,  3.791473397405973e-12,  2.225153591896456e-14, -6.466107568056166e-18, -1.205376732297640e-18, -9.690128834256388e-21,
 -1.412752803383762e-23,  4.394687040153173e-25,  1.818353185143498e+00, -2.088183833784397e-03, -1.573877761262551e-05, -8.315844236502100e-08, -2.144645189004947e-10,
  1.300150699877357e-12,  2.166816186101381e-14,  1.474562036995565e-16,  3.593434775700336e-19, -4.200852782634982e-21, -6.253391386806436e-23, -4.073127149148297e-25,
  1.899535450198816e+00, -1.227930322828091e-03, -1.049724184659254e-05, -7.174406329423534e-08, -3.843223612746983e-10, -1.298233413601178e-12,  2.202321434469962e-15,
  8.314137907646753e-17,  8.280908948424834e-19,  5.279082305404193e-21,  1.799143640950139e-23, -7.251759180997481e-26,  1.958341463035061e+00, -5.317823193123709e-04,
 -4.952176609325634e-06, -3.944491744527893e-08, -2.793154430903879e-10, -1.759047549370916e-12, -9.532618758635810e-15, -3.961716235742284e-17, -5.845514840258809e-20,
  1.108374459460255e-21,  1.661949978632587e-23,  1.552743362720769e-25,  1.992008462576505e+00, -1.045486489750895e-04, -1.020591250781286e-06, -8.795937931766171e-09,
 -7.046279815143764e-11, -5.362081325954812e-13, -3.916672400387788e-15, -2.759363975792864e-17, -1.877683941437745e-19, -1.232491263864438e-21, -7.770163260433210e-24,
 -4.664736033166088e-26,  1.573462915436057e-03, -1.404190572050203e-05,  9.391991878109783e-08, -5.579742600899876e-10,  3.104163727777000e-12, -1.655939585381007e-14,
  8.574143946112175e-17, -4.342276214197888e-19,  2.159828433216277e-21, -1.059092252364736e-23,  5.125449624513972e-26, -2.455271480304390e-28,  1.415154560111272e-02,
 -1.257647432007926e-04,  8.335572218148194e-07, -4.874026177101528e-09,  2.645365946428263e-11, -1.361547873338854e-13,  6.708133585983792e-16, -3.177115151642733e-18,
  1.445525507667541e-20, -6.300209681198645e-23,  2.603823089105697e-25, -1.005683150992187e-27,  3.925581653982751e-02, -3.459323348997705e-04,  2.250589776366160e-06,
 -1.273164102944404e-08,  6.552169616310157e-11, -3.108671001155064e-13,  1.354062816732890e-15, -5.298886756589984e-18,  1.748230755815734e-20, -3.857347592819676e-23,
 -4.812233607991184e-26,  1.302975388935959e-27,  7.677965080242204e-02, -6.679322364098910e-04,  4.221917986467945e-06, -2.264733217118568e-08,  1.063940323847178e-10,
 -4.313613504670227e-13,  1.392350303773745e-15, -2.397251013559856e-18, -1.108000584803327e-20,  1.526392243797396e-22, -1.075621921308540e-24,  5.747408530033246e-27,
  1.265558777812988e-01, -1.081709316495554e-03,  6.566641242370692e-06, -3.256325591095877e-08,  1.315182027916974e-10, -3.798268547839273e-13,  1.826341362614085e-16,
  7.364455256651854e-18, -6.636977675401768e-20,  3.770075349594220e-22, -1.502755806269704e-24,  2.849013830402384e-27,  1.883476975299001e-01, -1.573615013825363e-03,
  9.051379580388600e-06, -4.005745132829819e-08,  1.235121311594526e-10, -7.696428416230751e-14, -2.303570812133328e-15,  2.025207971140712e-17, -1.031592811764901e-19,
  2.885021001817694e-22,  5.484100370921523e-25, -1.323527895368618e-26,  2.618358881842853e-01, -2.126231720553700e-03,  1.139878930868368e-05, -4.263684545225330e-08,
  6.985020436206198e-11,  4.705444228405417e-13, -5.227658146668549e-15,  2.675155906376935e-17, -5.669296258563831e-20, -3.583605961400163e-22,  4.629667391145932e-24,
 -2.610895965235637e-26,  3.466017108127984e-01, -2.718201952570250e-03,  1.330056387416143e-05, -3.811690419583964e-08, -3.211636691609816e-11,  1.136672688782143e-12,
 -6.936591655263592e-15,  1.577200040154996e-17,  1.006667442733407e-19, -1.255447986680136e-21,  6.035436551067718e-24, -2.638263562013540e-27,  4.421047734562732e-01,
 -3.324110450109398e-03,  1.443656409799084e-05, -2.508149309600454e-08, -1.707370296910384e-10,  1.675260978904682e-12, -5.523096999559991e-15, -1.700984715232236e-17,
  2.963526156236010e-19, -1.411572997728363e-21, -9.883638468998733e-25,  5.902339811476141e-26,  5.476550057729123e-01, -3.914494875355510e-03,  1.450196508592165e-05,
 -3.394789387719752e-09, -3.176805562082457e-10,  1.770922311059587e-12,  9.835359742057884e-17, -6.020656520425984e-17,  3.492903864927921e-19,  1.503863198409395e-22,
 -1.438846114740228e-23,  8.259587130299395e-26,  6.623778710676171e-01, -4.456100218002388e-03,  1.324422587776773e-05,  2.530140968870936e-08, -4.295675260704969e-10,
  1.153330407616945e-12,  8.900646847012060e-15, -8.443144526077524e-17,  7.923844037856041e-20,  2.956034793357943e-21, -1.849251585314331e-23, -2.886905072081775e-26,
  7.851720981431052e-01, -4.912545449787920e-03,  1.051087969717161e-05,  5.723125311710040e-08, -4.558388022467642e-10, -2.357637641514659e-13,  1.697737249130030e-14,
 -5.514992087781116e-17, -4.746681659257192e-19,  4.224367802301821e-21,  3.722775955383080e-24, -2.063229851314883e-25,  9.146597136357149e-01, -5.245637066316209e-03,
  6.306937723847338e-06,  8.647392179750143e-08, -3.544366095644957e-10, -2.076297898369028e-12,  1.839734948010660e-14,  3.717019541969585e-17, -8.920767534091620e-19,
  7.496875242398604e-22,  3.954655917437934e-23, -1.477943313960825e-25,  1.049129255951710e+00, -5.417632827114994e-03,  8.561434993233513e-07,  1.055787501230264e-07,
 -1.143590680814545e-10, -3.615965265770047e-12,  8.536574486677833e-15,  1.454363903637385e-16, -5.703587130364126e-19, -6.210795133811081e-21,  3.637094567547132e-23,
  2.668272834363436e-25,  1.186475133872931e+00, -5.394801607782781e-03, -5.347598745137991e-06,  1.070999143277623e-07,  2.212210171379615e-10, -3.878439230517506e-12,
 -1.082986651650694e-14,  1.715923547093044e-16,  5.801695012942462e-19, -8.434849595142808e-21, -3.298198410137266e-23,  4.416961812466918e-25,  1.324139633720319e+00,
 -5.152580025702081e-03, -1.152376823836706e-05,  8.617454542187872e-08,  5.454715692940084e-10, -2.220628974663928e-12, -2.845052302970375e-14,  4.555105818326067e-17,
  1.525738728924797e-18,  8.477581687177006e-22, -8.138433509660898e-23, -2.234498028918200e-25,  1.459069508373501e+00, -4.682384159734949e-03, -1.666127197084639e-05,
  4.375068397876738e-08,  7.122408680328507e-10,  9.396333500781718e-13, -2.860097939949478e-14, -1.592021594031315e-16,  8.506965056351278e-19,  1.213532701289349e-20,
  1.777899360765920e-24, -6.990846395673861e-25,  1.587706373597489e+00, -3.999544345126635e-03, -1.968899141167125e-05, -1.087440471863827e-08,  6.072911512005382e-10,
  3.840094281459473e-12, -6.039449397234388e-15, -2.286429296558113e-16, -1.050226100434052e-18,  6.364233149507954e-21,  1.000171955030045e-22,  2.440787186286359e-25,
  1.706037993170175e+00, -3.150771479027030e-03, -1.978186584011782e-05, -6.058104466725892e-08,  2.454114830306826e-10,  4.318653783394929e-12,  2.147749426384639e-14,
 -5.068691610859477e-17, -1.559121908280689e-18, -9.801028195074492e-21,  1.029272380976271e-23,  6.737418770625880e-25,  1.809742229815911e+00, -2.218141827408773e-03,
 -1.675631400139639e-05, -8.635217007782156e-08, -1.829206586290032e-10,  1.870873382422465e-12,  2.593153957892062e-14,  1.560173106856953e-16,  1.587164300806560e-19,
 -7.065662811286147e-21, -8.072770553315239e-23, -4.096320815048187e-25,  1.894450170336265e+00, -1.315458458821586e-03, -1.139591078689009e-05, -7.809721891923237e-08,
 -4.095536697205750e-10, -1.214267435481896e-12,  4.930780949572468e-15,  1.128119817617628e-16,  1.030058417115470e-18,  5.905183397297624e-21,  1.248505250164380e-23,
 -1.865440888182914e-25,  1.956131990232044e+00, -5.733718184236150e-04, -5.453532176919521e-06, -4.420822311578140e-08, -3.168749924342161e-10, -2.001311334356730e-12,
 -1.066109157203117e-14, -4.070661765398951e-17, -4.784486358645285e-21,  1.927251178381145e-21,  2.478912096710551e-23,  2.191477288323411e-25,  1.991573241853583e+00,
 -1.131555994572623e-04, -1.133278124338422e-06, -1.001451879803840e-08, -8.219323568686515e-11, -6.402019495492028e-13, -4.780536855230453e-15, -3.437637612094869e-17,
 -2.382629072034132e-19, -1.588315026715296e-21, -1.012577889168731e-23, -6.104331855568576e-26,  1.518756764915292e-03, -1.331650926605176e-05,  8.751164938200514e-08,
 -5.108493346591379e-10,  2.792607845714229e-12, -1.464003050338294e-14,  7.449605444236474e-17, -3.708379863737214e-19,  1.812997274268863e-21, -8.741345866020189e-24,
  4.158481062633471e-26, -1.959849438223594e-28,  1.366146301020043e-02, -1.193232447059815e-04,  7.775213499176672e-07, -4.471706982911923e-09,  2.388461472817462e-11,
 -1.210725331401573e-13,  5.880029655502805e-16, -2.748909730975891e-18,  1.236442483177640e-20, -5.342445327344751e-23,  2.196288195589786e-25, -8.506447728918179e-28,
  3.790715358343633e-02, -3.285213748491550e-04,  2.103900578986893e-06, -1.173131625355456e-08,  5.961763258623663e-11, -2.800880962129792e-13,  1.213315260303611e-15,
 -4.761939137276788e-18,  1.607154518548777e-20, -3.949087988222858e-23, -9.290944654968370e-28,  8.655203394363842e-28,  7.417379135289903e-02, -6.352156692748306e-04,
  3.960084946362720e-06, -2.101225332475513e-08,  9.809534592293975e-11, -3.987856924299900e-13,  1.321033080563699e-15, -2.671720122358230e-18, -6.301517935318371e-21,
  1.143426105766931e-22, -8.470535196209790e-25,  4.670229839483709e-27,  1.223316817119153e-01, -1.030704025347615e-03,  6.188258186142176e-06, -3.051943285969877e-08,
  1.239810118814113e-10, -3.731970393477071e-13,  3.610643586449615e-16,  5.446435066900139e-18, -5.384743466029716e-20,  3.195998210136607e-22, -1.363680013618340e-24,
  3.394372399372957e-27,  1.821950624325573e-01, -1.503093275117533e-03,  8.582487313242014e-06, -3.809638915870905e-08,  1.214640335459031e-10, -1.258085874733950e-13,
 -1.781142589735846e-15,  1.712033313513174e-17, -9.250683191641765e-20,  3.000799297640229e-22,  6.051779973348580e-26, -9.109339607519074e-27,  2.535101292419383e-01,
 -2.037068303222637e-03,  1.089414194724077e-05, -4.145052109495458e-08,  7.806602181420511e-11,  3.538534520973166e-13, -4.505710317212203e-15,  2.476451739807033e-17,
 -6.652904101454013e-20, -1.952176062306619e-22,  3.551677896906649e-24, -2.279629058187935e-26,  3.359388050119034e-01, -2.613634118884241e-03,  1.284079918129104e-05,
 -3.845778757192056e-08, -1.101021415430602e-11,  9.758177882840754e-13, -6.456341302542960e-15,  1.831641333640381e-17,  5.976544118490062e-20, -1.018794517471537e-21,
  5.743347637788786e-24, -1.004989827257423e-26,  4.290373482222998e-01, -3.209865790588890e-03,  1.412027737130792e-05, -2.755258919020345e-08, -1.385905933458146e-10,
  1.538015845905094e-12, -5.874272712777396e-15, -8.342495530540738e-18,  2.454023502903643e-19, -1.404406488395152e-21,  1.219865995428142e-24,  4.163075303511715e-26,
  5.322286812661562e-01, -3.798725823788077e-03,  1.443189799271619e-05, -8.194752880782233e-09, -2.823685187411038e-10,  1.754317633315260e-12, -1.430884850153728e-15,
 -4.904659083131143e-17,  3.452242664156918e-19, -3.521698468304199e-22, -1.074704980375513e-23,  8.158667076814327e-26,  6.447671381642843e-01, -4.349046961179189e-03,
  1.350740092475575e-05,  1.862367115663435e-08, -4.045543738673943e-10,  1.338956670924884e-12,  6.587034875550196e-15, -8.033760989638953e-17,  1.721521510320552e-19,
  2.203653600416545e-21, -1.883060561377462e-23,  1.173207096916111e-26,  7.656942646576369e-01, -4.825835517469507e-03,  1.115380881294291e-05,  4.992169447161729e-08,
 -4.566128600975240e-10,  1.515875207628673e-13,  1.524349075979232e-14, -6.789445565298897e-17, -3.220016564107049e-19,  4.202536569665438e-21, -4.522168278675704e-24,
 -1.663467428138046e-25,  8.937845083257290e-01, -5.191130221624877e-03,  7.309307052763473e-06,  8.049501477365175e-08, -3.914794282890548e-10, -1.625462559341720e-12,
  1.904461891290608e-14,  9.346943341672091e-18, -8.383610035865870e-19,  2.182237035778637e-21,  3.166068068762201e-23, -2.054453071848303e-25,  1.027480395863266e+00,
 -5.405752422012044e-03,  2.109763239880548e-06,  1.031829271905344e-07, -1.843112430553241e-10, -3.364479293095704e-12,  1.232178501978288e-14,  1.239092524496042e-16,
 -7.652352117458803e-19, -4.554873672012307e-21,  4.555553184377124e-23,  1.477556014372672e-25,  1.164818582526325e+00, -5.432387408467057e-03, -4.043763524496186e-06,
  1.100064458068975e-07,  1.414518575621124e-10, -4.078891814091987e-12, -5.812601945242591e-15,  1.850841522290132e-16,  2.576673909569413e-19, -9.342659897002008e-21,
 -1.196301208691131e-23,  5.027012553087796e-25,  1.303351687301572e+00, -5.240489038994161e-03, -1.043889278863108e-05,  9.451022345442294e-08,  4.943627236003724e-10,
 -2.882613971885614e-12, -2.649154705753654e-14,  9.421918948300781e-17,  1.495858769401502e-18, -2.541353130892576e-21, -8.643810065724438e-23,  2.235054544633416e-28,
  1.440076991504413e+00, -4.813379394501247e-03, -1.606739328896759e-05,  5.525812842689032e-08,  7.238258371307439e-10,  2.031966641846635e-13, -3.261211360628963e-14,
 -1.250386808277622e-16,  1.281089979514980e-18,  1.155457890619810e-20, -3.155892403384428e-23, -8.005493088459379e-25,  1.571392586717041e+00, -4.157407289950091e-03,
 -1.975868147165114e-05, -5.534486748005538e-10,  6.821063805260168e-10,  3.614765603179637e-12, -1.287190333914805e-14, -2.577954317537184e-16, -7.471617478795572e-19,
  1.050694598448441e-20,  1.051252211113212e-22, -2.936034175540595e-26,  1.693113896359602e+00, -3.311860800479551e-03, -2.048233941299345e-05, -5.593605778603075e-08,
  3.367936942515505e-10,  4.811123390469025e-12,  1.930765397897984e-14, -1.060825391242939e-16, -1.896762159594685e-18, -8.726189175758872e-21,  4.515154702721996e-23,
  9.065766537087017e-25,  1.800594932510794e+00, -2.356383927178495e-03, -1.780875203814788e-05, -8.894425377238970e-08, -1.389238894089709e-10,  2.545967894684982e-12,
  3.032824627051743e-14,  1.563687585683574e-16, -1.579831874728017e-19, -1.063941712492828e-20, -9.739280211503525e-23, -3.310348242431819e-25,  1.888999906897206e+00,
 -1.410487608522970e-03, -1.237317205377030e-05, -8.483678715856693e-08, -4.323796790168583e-10, -1.054099746165651e-12,  8.583522509272640e-15,  1.492528676906433e-16,
  1.249240015690030e-18,  6.193773092071441e-21,  6.671338699464440e-25, -3.621765615546513e-25,  1.953747760811818e+00, -6.192113947826183e-04, -6.015817809189253e-06,
 -4.961272181784799e-08, -3.595519945821790e-10, -2.270800814395834e-12, -1.179110975988738e-14, -3.953803281223958e-17,  8.497707699298685e-20,  3.134868689507123e-21,
  3.620466213713155e-23,  3.033374196501850e-25,  1.991101693004092e+00, -1.227258932122125e-04, -1.261786559861423e-06, -1.143862016967597e-08, -9.622725661506755e-11,
 -7.674026192200401e-13, -5.859002352701763e-15, -4.299938425384690e-17, -3.034262706907331e-19, -2.052196681928230e-21, -1.320340692838427e-23, -7.960637990468613e-26,
  1.466853133488761e-03, -1.264019888850197e-05,  8.164019060027245e-08, -4.684162871988829e-10,  2.516877916055059e-12, -1.297045066029578e-14,  6.487970022906961e-17,
 -3.175521811465128e-19,  1.526283447017607e-21, -7.238280215206525e-24,  3.385176146120763e-26, -1.570519765852324e-28,  1.319627945842774e-02, -1.133113984020379e-04,
  7.260762953725166e-07, -4.108183384114822e-09,  2.159827399008682e-11, -1.078411041351569e-13,  5.162952987324502e-16, -2.382395838629247e-18,  1.059062916655160e-20,
 -4.534730438151806e-23,  1.851936353785718e-25, -7.181110076570322e-28,  3.662586125782166e-02, -3.122374730769466e-04,  1.968668222185354e-06, -1.082071036939134e-08,
  5.429656102182017e-11, -2.525117389601689e-13,  1.086967641870140e-15, -4.270335283318065e-18,  1.465745430096430e-20, -3.886677911761585e-23,  2.984323926236345e-26,
  5.504705687431914e-28,  7.169472998707745e-02, -6.045174910196650e-04,  3.717097370779154e-06, -1.950483667187558e-08,  9.043051810950090e-11, -3.679978034104377e-13,
  1.243976281746717e-15, -2.813661643840546e-18, -2.748108406767130e-21,  8.429041736318320e-23, -6.621916695457212e-25,  3.758934454407752e-27,  1.183056051295783e-01,
 -9.826297337574192e-04,  5.833682517585801e-06, -2.859492888849287e-08,  1.166151165206321e-10, -3.628859427773584e-13,  4.910972222836319e-16,  3.897175769252842e-18,
 -4.328702662185818e-20,  2.681085687518956e-22, -1.209758704209090e-24,  3.550893874737894e-27,  1.763171601755411e-01, -1.436229170607806e-03,  8.136901064469715e-06,
 -3.617525951060857e-08,  1.185575300824738e-10, -1.631281021097028e-13, -1.341593198199023e-15,  1.433270482135837e-17, -8.174776451541206e-20,  2.954834391678425e-22,
 -2.672259796159916e-25, -5.933124383108297e-27,  2.455330427003960e-01, -1.951883057861834e-03,  1.040444517694634e-05, -4.015049228366862e-08,  8.411661887165835e-11,
  2.537911524775763e-13, -3.842980926557901e-15,  2.254866302799432e-17, -7.123175963865579e-20, -7.215050279300674e-23,  2.628148250409973e-24, -1.916795635255723e-26,
  3.256867961911988e-01, -2.512755264590663e-03,  1.237886600291397e-05, -3.848606137959138e-08,  6.999140111011044e-12,  8.272036966379862e-13, -5.921909875604171e-15,
  1.968546457342597e-17,  2.710388808286185e-20, -7.993563648335932e-22,  5.197735501970782e-24, -1.429477677686280e-26,  4.164216653014063e-01, -3.098261504855225e-03,
  1.377733170172388e-05, -2.953168024997473e-08, -1.092546333231952e-10,  1.395071301186884e-12, -6.005436481712335e-15, -1.285840584952106e-18,  1.961207192079796e-19,
 -1.323636719100248e-21,  2.707894161340708e-24,  2.643700663416499e-26,  5.172639606058207e-01, -3.683738140008904e-03,  1.430760416380940e-05, -1.243426887556984e-08,
 -2.477304245147526e-10,  1.704730564508197e-12, -2.651986212378014e-15, -3.827831329356381e-17,  3.256571825280703e-19, -7.121181885724645e-22, -7.306198346980845e-24,
  7.396556132998836e-26,  6.275883315334860e-01, -4.240201769084300e-03,  1.369295723294697e-05,  1.237287100906605e-08, -3.763730483558105e-10,  1.470742714022406e-12,
  4.425604432094784e-15, -7.370321648440560e-17,  2.381377216230922e-19,  1.470217545533335e-21, -1.762791906683985e-23,  4.101580848325553e-26,  7.465730027006608e-01,
 -4.734332648061254e-03,  1.170919693568024e-05,  4.265935469728993e-08, -4.500820865226427e-10,  4.935926096165794e-13,  1.322060561457068e-14, -7.582624935871234e-17,
 -1.756041103963946e-19,  3.889197047007068e-21, -1.079080622390898e-23, -1.178660566278441e-25,  8.731429005911924e-01, -5.128900796031464e-03,  8.236672958146574e-06,
  7.399613954895790e-08, -4.194121009445914e-10, -1.168201767224184e-12,  1.894419488044391e-14, -1.599753568716765e-17, -7.392771581470726e-19,  3.258020363424155e-21,
  2.194207078037741e-23, -2.310807069858230e-25,  1.005898906909980e+00, -5.383976672216433e-03,  3.328099077024350e-06,  9.971282624065263e-08, -2.483774713046223e-10,
 -3.030028700334067e-12,  1.542633778162249e-14,  9.716028776017340e-17, -8.951841214155458e-19, -2.640001832104016e-21,  4.926456140740859e-23,  2.126800989334221e-26,
  1.143032739258059e+00, -5.459424972716969e-03, -2.712818571488778e-06,  1.116112479647774e-07,  5.890225562933064e-11, -4.155587259650869e-12, -5.657796395117147e-16,
  1.878993023218088e-16, -8.191810580976124e-20, -9.376181842619470e-21,  1.022485183325007e-23,  4.942310041311739e-25,  1.282230075419664e+00, -5.319333825082265e-03,
 -9.259323028970042e-06,  1.019252567841169e-07,  4.305936712156548e-10, -3.481452742106771e-12, -2.320175525471377e-14,  1.399598471275997e-16,  1.342788698875140e-18,
 -5.927012851011391e-21, -8.106445916826908e-23,  2.439912744270570e-25,  1.420570873253053e+00, -4.939069243006220e-03, -1.533481515258313e-05,  6.682822488859137e-08,
  7.198048101754276e-10, -6.165007139561033e-13, -3.547887386421523e-14, -7.770142736263344e-17,  1.665772956353151e-18,  9.581752688056809e-21, -6.700568378154575e-23,
 -7.896516626767736e-25,  1.554447045611995e+00, -4.315312401296669e-03, -1.969751608128515e-05,  1.091933288791101e-08,  7.507153810600701e-10,  3.216897267172033e-12,
 -2.036229818669017e-14, -2.748495699978957e-16, -2.944531778177430e-19,  1.458386766851701e-20,  9.604619114407032e-23, -3.958613106629128e-25,  1.679534623756281e+00,
 -3.478305367717950e-03, -2.111798607911271e-05, -4.975353863552045e-08,  4.373727771786873e-10,  5.231728854160355e-12,  1.544332213098608e-14, -1.713750291786949e-16,
 -2.168242703063625e-18, -6.064184358176239e-21,  8.923554317574175e-23,  1.082043460287977e-24,  1.790877649094134e+00, -2.503156920818277e-03, -1.888760729918846e-05,
 -9.071865955539453e-08, -8.037566230304197e-11,  3.325432993936995e-12,  3.457270230256264e-14,  1.444073871907585e-16, -6.142042251414085e-19, -1.477709756376536e-20,
 -1.080110842100058e-22, -1.270737666614682e-25,  1.883153370068825e+00, -1.513664280127923e-03, -1.343337731413597e-05, -9.191082027725153e-08, -4.510389049746583e-10,
 -7.932236210071940e-13,  1.335561980778219e-14,  1.927661622616756e-16,  1.468243536472833e-18,  5.833355988071299e-21, -2.052879209620218e-23, -6.150728774626760e-25,
  1.951170748834151e+00, -6.698206993987504e-04, -6.647237008701104e-06, -5.574462690350109e-08, -4.078854803452650e-10, -2.566650001075125e-12, -1.284098657712560e-14,
 -3.470572721038640e-17,  2.273841602291152e-19,  4.879731272426429e-21,  5.181499195206880e-23,  4.099287602487102e-25,  1.990589692956907e+00, -1.333966314781444e-04,
 -1.408820220688932e-06, -1.310911083890297e-08, -1.130849661166668e-10, -9.236357433832495e-13, -7.210794846662685e-15, -5.400025617626610e-17, -3.877148664252025e-19,
 -2.656931283773108e-21, -1.720477379910316e-23, -1.031562992134180e-25,  1.417563922509431e-03, -1.200889593473230e-05,  7.625252096055678e-08, -4.301398363157747e-10,
  2.272347356996909e-12, -1.151474810133972e-14,  5.663462836241976e-17, -2.726319581700615e-19,  1.288501302768351e-21, -6.012851361050151e-24,  2.764302179481987e-26,
 -1.263589491575156e-28,  1.275434694660786e-02, -1.076942657652634e-04,  6.787824744153274e-07, -3.779214338117905e-09,  1.956015120329095e-11, -9.621366506159077e-14,
  4.540972429082813e-16, -2.068245771688223e-18,  9.084167036423915e-21, -3.853703636759789e-23,  1.561380543613813e-25, -6.057226575288797e-28,  3.540760803828524e-02,
 -2.969931275396675e-04,  1.843869992393917e-06, -9.990989581975033e-09,  4.949778182200665e-11, -2.278076303926776e-13,  9.737563415861819e-16, -3.823410657396288e-18,
  1.328491012341539e-20, -3.726047249267179e-23,  4.883608768324080e-26,  3.254598611262621e-28,  6.933468521430838e-02, -5.756928960640417e-04,  3.491482962916240e-06,
 -1.811523281626260e-08,  8.336269486515228e-11, -3.390950713084002e-13,  1.164384139483457e-15, -2.857852655040022e-18, -1.527214396579465e-22,  6.087656536889471e-23,
 -5.140334559417268e-25,  2.999014107830975e-27,  1.144662959586682e-01, -9.373016581445985e-04,  5.501501086619300e-06, -2.678647398820078e-08,  1.094833274985702e-10,
 -3.499380922513137e-13,  5.822117424250125e-16,  2.657387239718839e-18, -3.446858151900407e-20,  2.228300916027538e-22, -1.054847506816458e-24,  3.458761682360146e-27,
  1.706997297760847e-01, -1.372838385564812e-03,  7.714066502086301e-06, -3.430605770893230e-08,  1.150040059474439e-10, -1.907964065431689e-13, -9.753187433690676e-16,
  1.188444722808192e-17, -7.135874030866547e-20,  2.803245610486311e-22, -4.734636116333676e-25, -3.561761705168839e-27,  2.378889629240100e-01, -1.870551486103896e-03,
  9.930866309690255e-06, -3.876882103916545e-08,  8.831992801663627e-11,  1.688766726821575e-13, -3.243785256482752e-15,  2.024639141567165e-17, -7.213048364334657e-20,
  1.716869381708722e-23,  1.863719896775970e-24, -1.561438139073005e-26,  3.158309163315469e-01, -2.415568555631828e-03,  1.191822663968978e-05, -3.824925587462575e-08,
  2.216700111491675e-11,  6.917649968934984e-13, -5.362621708035812e-15,  2.013121132538923e-17,  1.911232998890469e-21, -6.047227661253015e-22,  4.520432568053261e-24,
 -1.616133647397326e-26,  4.042467729593530e-01, -2.989488019534268e-03,  1.341335847007204e-05, -3.106437410261507e-08, -8.279394718607371e-11,  1.251174725621439e-12,
 -5.960580397853750e-15,  4.250552803817237e-18,  1.506642973554812e-19, -1.195916475280476e-21,  3.587836711907169e-24,  1.404270322010156e-26,  5.027568929653617e-01,
 -3.569938967281345e-03,  1.413572379133731e-05, -1.612900051302846e-08, -2.143531266146903e-10,  1.629373408269451e-12, -3.582104722722023e-15, -2.831768777803641e-17,
  2.955162184002420e-19, -9.424569451805607e-22, -4.294511417539872e-24,  6.249993727707331e-26,  6.108474105742504e-01, -4.130164317277351e-03,  1.380628737775604e-05,
  6.591306474747766e-09, -3.460585674759924e-10,  1.553098180058114e-12,  2.475608974831137e-15, -6.536814270651885e-17,  2.788651001682010e-19,  8.072670676231619e-22,
 -1.538908879287225e-23,  5.895813584428265e-26,  7.278260896646541e-01, -4.638732987236727e-03,  1.217828093036180e-05,  3.555352413586747e-08, -4.372120072311949e-10,
  7.849006971181241e-13,  1.103919997639289e-14, -7.929797174813420e-17, -4.447837757562102e-20,  3.368523600263429e-21, -1.488301702197703e-23, -6.855242206622769e-26,
  8.527645446867034e-01, -5.059571293877312e-03,  9.083671549393144e-06,  6.712313793371706e-08, -4.382791471873817e-10, -7.214755516933695e-13,  1.818379214300190e-14,
 -3.762836712726493e-17, -6.086514139270073e-19,  3.931551547607585e-21,  1.176432877283087e-23, -2.270874404750359e-25,  9.844237267019577e-01, -5.352637693212417e-03,
  4.498876481531132e-06,  9.527496378998583e-08, -3.050724170126974e-10, -2.630461936524806e-12,  1.773420727324479e-14,  6.737377480463382e-17, -9.548512312830420e-19,
 -6.859351002344637e-22,  4.760023127139430e-23, -9.362792032877322e-26,  1.121160131020310e+00, -5.475760472413505e-03, -1.370569190653495e-06,  1.118898318304358e-07,
 -2.392196182724074e-11, -4.106636052296077e-12,  4.608762134745285e-15,  1.799977491280164e-16, -4.070099649044189e-19, -8.549854677848425e-21,  3.054445636140379e-23,
  4.193701392393302e-25,  1.260812495402394e+00, -5.388404356922833e-03, -7.997274873165876e-06,  1.082288850302404e-07,  3.557378018607344e-10, -3.986631769448938e-12,
 -1.871770694060382e-14,  1.789144486834345e-16,  1.074264219529709e-18, -8.886523592790590e-21, -6.529018142373635e-23,  4.658800617934502e-25,  1.400574592970689e+00,
 -5.058345463400720e-03, -1.446433369715694e-05,  7.819956982370333e-08,  6.988160491319925e-10, -1.487779349720112e-12, -3.686046428441669e-14, -1.946108041584216e-17,
  1.954378837234280e-18,  6.239370580984385e-21, -9.905581655224008e-23, -6.445117476327050e-25,  1.536871760106963e+00, -4.472159503256148e-03, -1.949238544963075e-05,
  2.341630085236456e-08,  8.095396653167859e-10,  2.635298564077031e-12, -2.810601943550699e-14, -2.751715333175957e-16,  2.944273985820879e-19,  1.795681463769604e-20,
  6.957983468010352e-23, -8.094568490566813e-25,  1.665279911828982e+00, -3.649510386427237e-03, -2.166952738497964e-05, -4.190013436244245e-08,  5.452837941191751e-10,
  5.536771460017702e-12,  9.646088859008081e-15, -2.434680209779453e-16, -2.310580942105358e-18, -1.517507388498143e-21,  1.384202523164785e-22,  1.124897703880759e-24,
  1.780555901252924e+00, -2.658628782852304e-03, -1.998160281075995e-05, -9.142618985797774e-08, -5.255711198694600e-12,  4.200956240412135e-12,  3.825499049784259e-14,
  1.154019772123408e-16, -1.224440938968097e-18, -1.911294096800908e-20, -1.060603576277791e-22,  2.469847981363495e-25,  1.876876619054498e+00, -1.625666783640284e-03,
 -1.458006875633010e-05, -9.923500973772849e-08, -4.632325981852422e-10, -4.024231825655070e-13,  1.944095233800335e-14,  2.428930778642955e-16,  1.656101612064757e-18,
  4.377486864955421e-21, -5.473192202111023e-23, -9.536890363419663e-25,  1.948380711742222e+00, -7.257892940797966e-04, -7.357078629305848e-06, -6.269851661515732e-08,
 -4.623740365633754e-10, -2.885495048677818e-12, -1.368140303966033e-14, -2.418128290464931e-17,  4.450343966587494e-19,  7.349158808691445e-21,  7.258160739530456e-23,
  5.367932998876263e-25,  1.990032523659254e+00, -1.453286573496844e-04, -1.577627233432587e-06, -1.507619537808261e-08, -1.334183830137783e-10, -1.116334240177942e-12,
 -8.911878313021371e-15, -6.807970339110702e-17, -4.969192172533437e-19, -3.444053931627934e-21, -2.236328627092291e-23, -1.322514661080408e-25,  1.370716538573229e-03,
 -1.141892143587235e-05,  7.130162086660671e-08, -3.955533008647993e-10,  2.055049634202548e-12, -1.024265478036870e-14,  4.954710132469949e-17, -2.346603292629704e-19,
  1.090671265437614e-21, -5.010771838886446e-24,  2.263744662752615e-26, -1.021050621590405e-28,  1.233415050586336e-02, -1.024402303901113e-04,  6.352480415496930e-07,
 -3.481073077194214e-09,  1.774033493701358e-11, -8.597865352175241e-14,  4.000558062881115e-16, -1.798594741810387e-18,  7.803096781662179e-21, -3.279549628477582e-23,
  1.316275230508763e-25, -5.111483548008783e-28,  3.424839669359408e-02, -2.827086098989841e-04,  1.728583567167458e-06, -9.234240065758192e-09,  4.516690230077716e-11,
 -2.056753312587140e-13,  8.724536638941324e-16, -3.419353675205259e-18,  1.198167433810814e-20, -3.507163328742055e-23,  5.944587690370962e-26,  1.658955749980311e-28,
  6.708643194375481e-02, -5.486083945777628e-04,  3.281884029131184e-06, -1.683419374501467e-08,  7.685376926491772e-11, -3.121087534006599e-13,  1.084598454394298e-15,
 -2.831396834446772e-18,  1.698753323290189e-21,  4.276074886190832e-23, -3.963251731312477e-25,  2.371525168972247e-27,  1.108031189181305e-01, -8.945461475945878e-04,
  5.190345362249676e-06, -2.508994849080808e-08,  1.026297096941641e-10, -3.351896383318067e-13,  6.423262649226102e-16,  1.674893417089580e-18, -2.717006963039355e-20,
  1.836169024920787e-22, -9.075824247295517e-25,  3.216721190482691e-27,  1.653292378069096e-01, -1.312741560958708e-03,  7.313304446996191e-06, -3.249768423875874e-08,
  1.109796607632962e-10, -2.104597282463151e-13, -6.730334887172453e-16,  9.758506409292710e-18, -6.164065837973946e-20,  2.587988095342283e-22, -5.903652877719507e-25,
 -1.849060781933680e-27,  2.305627386299582e-01, -1.792941205866733e-03,  9.474217442543505e-06, -3.733272375401124e-08,  9.096352804285860e-11,  9.756884353983040e-14,
 -2.709012748490190e-15,  1.796120853067294e-17, -7.032710976038636e-20,  7.895981496723969e-23,  1.249488562947046e-24, -1.236877696629401e-26,  3.063564366341635e-01,
 -2.322051670370197e-03,  1.146179803789954e-05, -3.779070278815934e-08,  3.476088421931976e-11,  5.698141714325268e-13, -4.801123628717884e-15,  1.987754582373490e-17,
 -1.677707313734891e-20, -4.382853313163920e-22,  3.800051981406692e-24, -1.636128232137822e-26,  3.925010443754626e-01, -2.883692910157738e-03,  1.303343849280691e-05,
 -3.219661213097621e-08, -5.918870121886695e-11,  1.110055019721611e-12, -5.780336047269153e-15,  8.411685499825078e-18,  1.103157651141238e-19, -1.043045980447745e-21,
  3.986567776377797e-24,  4.548692786387834e-27,  4.887020037867535e-01, -3.457683227987475e-03,  1.392265744944783e-05, -1.930287262947936e-08, -1.826842024248298e-10,
  1.534924332306294e-12, -4.247915613157010e-15, -1.943202411465225e-17,  2.591240850231087e-19, -1.063026488360280e-21, -1.829148692504484e-24,  4.945772376247376e-26,
  5.945480250911376e-01, -4.019489384807082e-03,  1.385319527873113e-05,  1.305489438388557e-09, -3.145454023404988e-10,  1.591580210436760e-12,  7.737848114321081e-16,
 -5.609301061551876e-17,  2.975002805373707e-19,  2.465861716133126e-22, -1.258732520042068e-23,  6.690499537338805e-26,  7.094685460751897e-01, -4.539717809482946e-03,
  1.256351346472262e-05,  2.869735483180484e-08, -4.190448042056682e-10,  1.023144356107114e-12,  8.816311615737116e-15, -7.890098642108022e-17,  6.547006476008862e-20,
  2.726433553518903e-21, -1.689840047504248e-23, -2.425080408046009e-26,  8.326765300611424e-01, -4.983800167312515e-03,  9.846673970545202e-06,  6.001855103984856e-08,
 -4.484406984738890e-10, -2.997750063544437e-13,  1.687933566163976e-14, -5.476899526139937e-17, -4.609957125634406e-19,  4.208902401723147e-21,  2.303106618058112e-24,
 -1.997778294206680e-25,  9.630922766236478e-01, -5.312160307922181e-03,  5.611229501999667e-06,  8.999663572873827e-08, -3.532905362499672e-10, -2.185666026585615e-12,
  1.919175197315630e-14,  3.678111222354199e-17, -9.465278275469214e-19,  1.107304665319939e-21,  4.141480323644065e-23, -1.823246608426733e-25,  1.099243646294508e+00,
 -5.481367015438369e-03, -3.287401881528007e-08,  1.108577120461638e-07, -1.045491246532087e-10, -3.937293379546582e-12,  9.421967404710595e-15,  1.623186309451818e-16,
 -6.886705426500402e-19, -6.993134192134801e-21,  4.637077466141065e-23,  2.933274625005183e-25,  1.239139275396977e+00, -5.447097018274924e-03, -6.667082850828537e-06,
  1.132601900856271e-07,  2.719374539863991e-10, -4.372169509995578e-12, -1.327827107149215e-14,  2.077115788812799e-16,  7.127700560870689e-19, -1.103546278863116e-20,
 -4.099081867485336e-23,  6.254898277312828e-25,  1.380115989915219e+00, -5.170119049762568e-03, -1.345999034643874e-05,  8.909446012217770e-08,  6.602071133571030e-10,
 -2.371723473773024e-12, -3.650179847978854e-14,  4.585689053356847e-17,  2.101483392810657e-18,  1.782189887972988e-21, -1.217994689842441e-22, -3.699746924133802e-25,
  1.518673339394298e+00, -4.626750654984480e-03, -1.913206054891051e-05,  3.675134036320984e-08,  8.548842038643735e-10,  1.869975774124451e-12, -3.557834574540509e-14,
 -2.549464055293315e-16,  9.813012674274172e-19,  1.990931289669229e-20,  2.523352944757222e-23, -1.193927778878542e-24,  1.650332194007754e+00, -3.824721009269014e-03,
 -2.211629343441434e-05, -3.227960010831360e-08,  6.577388516194392e-10,  5.678107373986876e-12,  1.793803202663233e-15, -3.171168808352112e-16, -2.253883979674150e-18,
  4.976821329860459e-21,  1.850516321930508e-22,  9.529234972716134e-25,  1.769594738901125e+00, -2.822864777353582e-03, -2.107628462539274e-05, -9.078723318576231e-08,
  8.818065830952879e-11,  5.152759140612608e-12,  4.082858613170583e-14,  6.442221039265143e-17, -1.984876238664716e-18, -2.298411090069802e-20, -8.332376591082449e-23,
  8.199805413713375e-25,  1.870132950493321e+00, -1.747197048480872e-03, -1.581553610209451e-05, -1.066833462350556e-07, -4.660328465727785e-10,  1.518885580370002e-13,
  2.700406124834273e-14,  2.978982262106431e-16,  1.763111747463083e-18,  1.231658747552226e-21, -1.055774646041583e-22, -1.367325572017169e-24,  1.945354892739161e+00,
 -7.877857205248413e-04, -8.155811505236838e-06, -7.057621887439859e-08, -5.234128864628353e-10, -3.220098704836100e-12, -1.411505570395601e-14, -5.098149774278365e-18,
  7.679186794231354e-19,  1.076477762065193e-20,  9.919030915791286e-23,  6.724012892630527e-25,  1.989424767634286e+00, -1.587113980792597e-04, -1.772126019150774e-06,
 -1.740180605047522e-08, -1.580481193733572e-10, -1.355011987814586e-12, -1.106066866780318e-14, -8.614949804297113e-17, -6.384974649455628e-19, -4.464739554878116e-21,
 -2.892154037325706e-23, -1.666187049319202e-25,  1.326152385841097e-03, -1.086695121376276e-05,  6.674570921819898e-08, -3.642488871488398e-10,  1.861575330524391e-12,
 -9.128586992918375e-15,  4.343931140153352e-17, -2.024787157023032e-19,  9.255547187674575e-22, -4.189152049616918e-24,  1.858310576054850e-26, -8.292705627814384e-29,
  1.193429563556938e-02, -9.752063957559129e-05,  5.951231351089120e-07, -3.210479258600401e-09,  1.611283737108754e-11, -7.695448164712047e-14,  3.530204489083744e-16,
 -1.566812203105032e-18,  6.712033567775534e-21, -2.795592220886642e-23,  1.109251788681241e-25, -4.323124858190145e-28,  3.314453472986242e-02, -2.693112048809491e-04,
  1.621976561424802e-06, -8.543371789913520e-09,  4.125524848453349e-11, -1.858431703289002e-13,  7.818930870334222e-16, -3.055670374706232e-18,  1.076332187536556e-20,
 -3.258389756653007e-23,  6.411966593720002e-26,  5.290387553342410e-29,  6.494325800897897e-02, -5.231409247691352e-04,  3.087050182260472e-06, -1.565308334813836e-08,
  7.086551361754752e-11, -2.870222792610492e-13,  1.006291126360271e-15, -2.755271738485024e-18,  2.976470888146255e-21,  2.883549566873818e-23, -3.036912346013840e-25,
  1.855797595070749e-27,  1.073061117624945e-01, -8.542002909173268e-04,  4.898899959993587e-06, -2.350065163116071e-08,  9.608339116324164e-11, -3.193034266683440e-13,
  6.779964478846874e-16,  9.044794512208243e-19, -2.118003458119882e-20,  1.500528778203997e-22, -7.729940449412479e-25,  2.891248075431940e-27,  1.601928567980138e-01,
 -1.255765152913881e-03,  6.933844781672436e-06, -3.075647185922811e-08,  1.066299544391576e-10, -2.235481242030190e-13, -4.260430034557372e-16,  7.930380322722999e-18,
 -5.276501844147685e-20,  2.339404284758835e-22, -6.439217011402087e-25, -6.621007055004488e-28,  2.235397590961919e-01, -1.718914568802600e-03,  9.035010665027396e-06,
 -3.586506239065808e-08,  9.230417592148851e-11,  3.833614681374077e-14, -2.237115260317145e-15,  1.576485567316515e-17, -6.670817150493825e-20,  1.189172877549574e-22,
  7.689013651364034e-25, -9.552619594293422e-27,  2.972487610678662e-01, -2.232160958463462e-03,  1.101200296077370e-05, -3.714943107233318e-08,  4.504960856246688e-11,
  4.611918288819131e-13, -4.254239425585958e-15,  1.911616591493427e-17, -2.999112976775553e-20, -3.004848952371040e-22,  3.096367552408514e-24, -1.549037213749402e-26,
  3.811723402431136e-01, -2.780985300186472e-03,  1.264210548722503e-05, -3.297347328305466e-08, -3.835388539307237e-11,  9.745185943427058e-13, -5.500811333479538e-15,
  1.137202869237148e-17,  7.566441346186503e-20, -8.817692434101447e-22,  4.027657766679625e-24, -2.269601309503308e-27,  4.750924992545556e-01, -3.347275900136078e-03,
  1.367447993544339e-05, -2.198593984935949e-08, -1.530445964098265e-10,  1.427346425912865e-12, -4.681754961556564e-15, -1.176245315131195e-17,  2.200273422482012e-19,
 -1.096533445514208e-21,  5.930088157877197e-26,  3.649968672813124e-26,  5.786917003027777e-01, -3.908684292248513e-03,  1.383971709243513e-05, -3.472089729206015e-09,
 -2.826497264236839e-10,  1.592384427005580e-12, -6.628640797485154e-16, -4.652234367481497e-17,  2.980295076913027e-19, -1.975228863979225e-22, -9.618097312689842e-24,
  6.694646925592220e-26,  6.915127132784031e-01, -4.437944582756752e-03,  1.286836389719823e-05,  2.216709176901279e-08, -3.966433584915204e-10,  1.208547832243738e-12,
  6.650231243217984e-15, -7.536737794880646e-17,  1.513008493239350e-19,  2.040353744244354e-21, -1.714585880588401e-23,  1.138591246084712e-26,  8.129032649601652e-01,
 -4.902268176328669e-03,  1.052371822985218e-05,  5.281699692152211e-08, -4.505173941199201e-10,  8.539993391866994e-14,  1.516208679667856e-14, -6.709526303483253e-17,
 -3.098308119045751e-19,  4.136882066119408e-21, -5.595027473783331e-24, -1.574769737938272e-25,  9.419401149713046e-01, -5.263049886546600e-03,  6.655912575413635e-06,
  8.401959578864376e-08, -3.923319088407565e-10, -1.716080316410637e-12,  1.980575417714840e-14,  7.432895106392483e-18, -8.789537815404044e-19,  2.584826538446933e-21,
  3.206517016191621e-23, -2.366936313116892e-25,  1.077326029507046e+00, -5.476343172155702e-03,  1.284827102673589e-06,  1.085687429789123e-07, -1.806793899239376e-10,
 -3.659336578379310e-12,  1.362320347525066e-14,  1.366337402888424e-16, -9.043255080677854e-19, -4.924322889288849e-21,  5.594629146966787e-23,  1.394947814607904e-25,
  1.217252917305334e+00, -5.494929973172164e-03, -5.284790789356266e-06,  1.168963463451404e-07,  1.817900943052926e-10, -4.618856579285225e-12, -7.204685246716714e-15,
  2.239029511182634e-16,  2.928743890693535e-19, -1.209731998062632e-20, -1.160415783728037e-23,  6.936723306080394e-25,  1.359227173429951e+00, -5.273346773652044e-03,
 -1.232919494026095e-05,  9.923127353022009e-08,  6.041556151131031e-10, -3.224734770117256e-12, -3.427355430776766e-14,  1.131648470537541e-16,  2.074954918219547e-18,
 -3.311980859712096e-21, -1.302205702070065e-22, -1.860006353728475e-27,  1.499863348536370e+00, -4.777808017352321e-03, -1.860789813928053e-05,  5.067993486468854e-08,
  8.831878636605692e-10,  9.346484490677511e-13, -4.216870673055511e-14, -2.119904928072740e-16,  1.702714194476863e-18,  1.977906919024204e-20, -3.365135330026471e-23,
 -1.454060763128737e-24,  1.634677259976936e+00, -4.003013242236370e-03, -2.243675917421953e-05, -2.084810512763083e-08,  7.709710649395917e-10,  5.606675877906214e-12,
 -8.057644850122485e-15, -3.848701583694864e-16, -1.932351903179251e-18,  1.310613150446654e-20,  2.181231672371370e-22,  5.008038742186141e-25,  1.757959204034255e+00,
 -2.995800675831186e-03, -2.215369145633561e-05, -8.849818654433387e-08,  2.011403961871377e-10,  6.146328191228775e-12,  4.161467681408476e-14, -1.289293736389741e-17,
 -2.861696946900200e-18, -2.538378741967867e-20, -3.112082821439386e-23,  1.579193424540685e-24,  1.862882827441131e+00, -1.878968424655566e-03, -1.714025307301482e-05,
 -1.140774054084071e-07, -4.558054605796687e-10,  9.064640161290555e-13,  3.613522051353333e-14,  3.540867044634767e-16,  1.715749867719568e-18, -4.325036799980546e-21,
 -1.754734836393399e-22, -1.807164331019726e-24,  1.942067685486049e+00, -8.565672535318692e-04, -9.055158657748935e-06, -7.948444059366843e-08, -5.911980617101936e-10,
 -3.557409294439594e-12, -1.384971162837055e-14,  2.650162822580014e-17,  1.234337310480839e-18,  1.536088357709414e-20,  1.314546521946550e-22,  7.867161692896496e-25,
  1.988760181959268e+00, -1.737688395828999e-04, -1.997063684621788e-06, -2.016266465499848e-08, -1.880108993876550e-10, -1.651879938754758e-12, -1.378474274171698e-14,
 -1.093913723602457e-16, -8.219176657264291e-19, -5.779149573417785e-21, -3.707172302942901e-23, -2.039703563135162e-25,  1.283725526421552e-03, -1.034997665487625e-05,
  6.254758729865659e-08, -3.358694800373215e-10,  1.688986527243856e-12, -8.150863952126896e-15,  3.816286708215641e-17, -1.751373042077416e-19,  7.872891470736639e-22,
 -3.514087744399516e-24,  1.528012341273254e-26, -6.781085927333192e-29,  1.155349708779708e-02, -9.290948885971156e-05,  5.580948778636623e-07, -2.964540730071068e-09,
  1.465504071274373e-11, -6.898506926835488e-14,  3.120112966442123e-16, -1.367309386386146e-18,  5.781086386498258e-21, -2.387932102435922e-23,  9.337604585565198e-26,
 -3.676074619716198e-28,  3.209260771682269e-02, -2.567345288069264e-04,  1.523297172195920e-06, -7.912031536297709e-09,  3.771930576871021e-11, -1.680665874041252e-13,
  7.009834883795844e-16, -2.729514424712027e-18,  9.636790352027393e-21, -2.999835290997421e-23,  6.456615479425557e-26, -2.849967323261715e-29,  6.289892412623006e-02,
 -4.991770237700227e-04,  2.905831016080717e-06, -1.456387251636892e-08,  6.536038834798004e-11, -2.637854214442805e-13,  9.306172049835533e-16, -2.645608160998343e-18,
  3.814366384160146e-21,  1.818994222706346e-23, -2.316816422695627e-25,  1.430470471253420e-27,  1.039659432120805e-01, -8.161114673931311e-04,  4.625908289912448e-06,
 -2.201351451881576e-08,  8.986171774763867e-11, -3.027994097769319e-13,  6.946041678907654e-16,  3.074238133398519e-19, -1.630499014274369e-20,  1.215712821725077e-22,
 -6.537671391273421e-25,  2.523401937127566e-27,  1.552784407048099e-01, -1.201742045003501e-03,  6.574854451855821e-06, -2.908664368570642e-08,  1.020737740353188e-10,
 -2.312917438529564e-13, -2.264006904657100e-16,  6.371637108463859e-18, -4.481144396737243e-20,  2.078551166099173e-22, -6.547270296025212e-25,  1.104382827969419e-28,
  2.168059707455227e-01, -1.648330859695513e-03,  8.613507369252860e-06, -3.438483319647784e-08,  9.256851674123679e-11, -1.029469632730079e-14, -1.824903206328205e-15,
  1.370384830263400e-17, -6.196818647659686e-20,  1.419904622194867e-22,  4.017834393324743e-25, -7.215063240439717e-27,  2.884935041035918e-01, -2.145835188110389e-03,
  1.057082145931737e-05, -3.636021425600180e-08,  5.329518326014024e-11,  3.653954931998050e-13, -3.733886213496074e-15,  1.800596470941375e-17, -3.873985416070053e-20,
 -1.898591237563572e-22,  2.445659864789107e-24, -1.402169951044519e-26,  3.702481539132100e-01, -2.681440180041488e-03,  1.224336208853685e-05, -3.343827271286003e-08,
 -2.015662288766399e-11,  8.465655004318508e-13, -5.153048913239375e-15,  1.331619701215757e-17,  4.678274725641245e-20, -7.241481978897712e-22,  3.820302383666591e-24,
 -6.821107741920924e-27,  4.619204604422528e-01, -3.238974884492210e-03,  1.339687837637899e-05, -2.421248110306863e-08, -1.256440089388998e-10,  1.311791356493370e-12,
 -4.918445447829496e-15, -5.349798838468037e-18,  1.809490604632637e-19, -1.065625789461568e-21,  1.400005599970972e-24,  2.468988127546475e-26,  5.632780293724248e-01,
 -3.798207683853531e-03,  1.377196465203243e-05, -7.740991831613685e-09, -2.510611054563786e-10,  1.561912772647398e-12, -1.833537827807649e-15, -3.716773407629234e-17,
  2.846922770069596e-19, -5.246405806651679e-22, -6.778535857451130e-24,  6.138597041889315e-26,  6.739683636462649e-01, -4.334039648353607e-03,  1.309711503319957e-05,
  1.602213075642316e-08, -3.710441811721102e-10,  1.343440218649229e-12,  4.617834316239951e-15, -6.948138570989953e-17,  2.126056204396272e-19,  1.372772679925604e-21,
 -1.604825760045865e-23,  3.677973844232721e-26,  7.934664131686092e-01, -4.815665500354704e-03,  1.111439114169260e-05,  4.564149680754958e-08, -4.453278794995804e-10,
  4.257614053260197e-13,  1.316662171537932e-14, -7.468290962386056e-17, -1.664729337507566e-19,  3.788658084522134e-21, -1.146011706659786e-23, -1.087092034923419e-25,
  9.210006416326506e-01, -5.205878800149222e-03,  7.625434966389513e-06,  7.749355386391736e-08, -4.218993068079637e-10, -1.241328742941861e-12,  1.963573724365526e-14,
 -1.897812240819572e-17, -7.654005329868437e-19,  3.651122540307204e-21,  2.111347680763078e-23, -2.554627396308573e-25,  1.055449388715305e+00, -5.460907841029111e-03,
  2.567952587481491e-06,  1.051113835221819e-07, -2.503042054228617e-10, -3.289888914702837e-12,  1.702029501778707e-14,  1.053000308732243e-16, -1.040265152924448e-18,
 -2.610244691981370e-21,  5.862144197376610e-23, -1.612856890777462e-26,  1.195197585369631e+00, -5.531554899014933e-03, -3.867655803352189e-06,  1.190587213279296e-07,
  8.819540888235626e-11, -4.715882728805157e-12, -8.699583920099213e-16,  2.262769743781481e-16, -1.436395892933362e-19, -1.195373184547418e-20,  1.853396857406854e-23,
  6.595614813614907e-25,  1.337944285967874e+00, -5.367058087788882e-03, -1.108269055048040e-05,  1.083383236486591e-07,  5.317301032689448e-10, -4.001919633739823e-12,
 -3.020041692741216e-14,  1.766572787235274e-16,  1.863016592594428e-18, -8.404666276530312e-21, -1.214963289734317e-22,  3.974557742580117e-25,  1.480458582327285e+00,
 -4.923997284622470e-03, -1.791451936811419e-05,  6.490359737365592e-08,  8.913141169074300e-10, -1.418268028619153e-13, -4.723716854095548e-14, -1.464980368333763e-16,
  2.374796532992240e-18,  1.712215137068696e-20, -9.952307174278519e-23, -1.498184598082234e-24,  1.618304941585127e+00, -4.183289885343460e-03, -2.260926714340247e-05,
 -7.629790610651313e-09,  8.802638225192019e-10,  5.277485667471290e-12, -1.961657360877201e-14, -4.374408193243179e-16, -1.299952408044453e-18,  2.207213371816614e-20,
  2.247236825305719e-22, -2.468885773665351e-25,  1.745614906403031e+00, -3.177213716673108e-03, -2.319212866708405e-05, -8.424258193683458e-08,  3.339681591566462e-10,
  7.129551195492512e-12,  3.983340473617259e-14, -1.191777309188961e-16, -3.778900851989153e-18, -2.498843844093345e-20,  5.716572316378168e-23,  2.438096270818820e-24,
  1.855083867004357e+00, -2.021688442640726e-03, -1.855217888654573e-05, -1.211746580316704e-07, -4.281693944407207e-10,  1.898690308582214e-12,  4.678430296725181e-14,
  4.049821709688516e-16,  1.413471927055953e-18, -1.305013182209334e-20, -2.633791205651988e-22, -2.160646449381794e-24,  1.938490258820947e+00, -9.329901048094380e-04,
 -1.006813245242057e-05, -8.953051558215564e-08, -6.655846995101922e-10, -3.875885515278350e-12, -1.246391614844572e-14,  7.593206109325003e-17,  1.890497204387170e-18,
  2.132937131067345e-20,  1.671987510009177e-22,  8.163175791308981e-25,  1.988031545559232e+00, -1.907669289661139e-04, -2.258216154125440e-06, -2.345421258237583e-08,
 -2.246211505118050e-10, -2.022644236231947e-12, -1.724934230135473e-14, -1.393259167393806e-16, -1.058918533053136e-18, -7.452060918635609e-21, -4.682081369330263e-23,
 -2.376449055334186e-25,  1.243301487752261e-03, -9.865270361265522e-06,  5.867407343900491e-08, -3.101016870010508e-10,  1.534745356626381e-12, -7.291067254302493e-15,
  3.359351818769523e-17, -1.518558144110434e-19,  6.710985975817618e-22, -2.958868348322349e-24,  1.256648738636495e-26, -5.604590738764123e-29,  1.119056883785089e-02,
 -8.858314389784900e-05,  5.238830261184439e-07, -2.740703477635930e-09,  1.334722573850704e-11, -6.193607900864531e-14,  2.761922866626835e-16, -1.195378904242226e-18,
  4.984911668581265e-21, -2.045168443235687e-23,  7.838019933727529e-26, -3.162073837088390e-28,  3.108945519668791e-02, -2.449179189409183e-04,  1.431865814602244e-06,
 -7.334524586165414e-09,  3.452019544165614e-11, -1.521262340229744e-13,  6.287155491579671e-16, -2.437921368582906e-18,  8.602856526639767e-21, -2.746019308842637e-23,
  6.188576462331232e-26, -9.132808480843419e-29,  6.094762705263947e-02, -4.766120566901928e-04,  2.737168907510106e-06, -1.355912337629486e-08,  6.030210143605504e-11,
 -2.423251960684333e-13,  8.583353851910888e-16, -2.514743128571784e-18,  4.316558953669355e-21,  1.007214737097843e-23, -1.768097217506394e-25,  1.072849669243772e-27,
  1.007738727555584e-01, -7.801368617435272e-04,  4.370175932540730e-06, -2.062326726058609e-08,  8.397284360225692e-11, -2.860807054358401e-13,  6.965305841310987e-16,
 -1.491474918185158e-19, -1.237340983592347e-20,  9.752760874843393e-23, -5.512625218082164e-25,  2.132613671974622e-27,  1.505744983418633e-01, -1.150511957410937e-03,
  6.235460359978137e-06, -2.749070737715102e-08,  9.740724511239429e-11, -2.347397947395924e-13, -6.698140019975577e-17,  5.052359980505013e-18, -3.779746973023847e-20,
  1.819150990855571e-22, -6.390609906438942e-25,  5.523564737226026e-28,  2.103478856843007e-01, -1.581048124575347e-03,  8.209761792505336e-06, -3.290763726311873e-08,
  9.195458871072099e-11, -4.970713786222549e-14, -1.468170056667620e-15,  1.180516901985799e-17, -5.663841484404949e-20,  1.522920272853462e-22,  1.267540492282035e-25,
 -5.367145538167883e-27,  2.800765542769960e-01, -2.062998885822090e-03,  1.013984107706907e-05, -3.545372821051184e-08,  5.974704955439599e-11,  2.816864751142435e-13,
 -3.247974409974895e-15,  1.667463365872338e-17, -4.395810880512979e-20, -1.038775555361180e-22,  1.865834678605573e-24, -1.232154725684175e-26,  3.597157395798961e-01,
 -2.585102559261208e-03,  1.184070509999187e-05, -3.363191825933981e-08, -4.431067635109178e-12,  7.275126858694629e-13, -4.762949234199170e-15,  1.442498339900777e-17,
  2.338303383035379e-20, -5.782677700142660e-22,  3.453532679804607e-24, -9.601139039751883e-27,  4.491770251385298e-01, -3.132994279697371e-03,  1.309511167326254e-05,
 -2.601935188994817e-08, -1.005975093371412e-10,  1.192570433685058e-12, -4.992853369859817e-15, -1.604850636357536e-19,  1.438277970578958e-19, -9.910086395684655e-22,
  2.257133981652963e-24,  1.457003899686392e-26,  5.483048684570518e-01, -3.688469465974494e-03,  1.365599307875051e-05, -1.151078996535328e-08, -2.203419556298357e-10,
  1.506429759020108e-12, -2.749874790116283e-15, -2.840696535632891e-17,  2.615534613471389e-19, -7.442342109540357e-22, -4.267152845232055e-24,  5.235042642157239e-26,
  6.568428368319542e-01, -4.228592511903447e-03,  1.325466476429627e-05,  1.030574885905660e-08, -3.432205292583865e-10,  1.431732597513492e-12,  2.774168930852500e-15,
 -6.200769147439201e-17,  2.509092293221790e-19,  7.683973835727739e-22, -1.405983279297593e-23,  5.199416648814996e-26,  7.743848801626995e-01, -4.724679953420959e-03,
  1.161967228002239e-05,  3.860082160494669e-08, -4.338246314942194e-10,  7.161875498974676e-13,  1.102074388756974e-14, -7.792474030734726e-17, -3.935405320553512e-20,
  3.248957083795160e-21, -1.517566548369816e-23, -6.084216064880823e-26,  9.003048586128778e-01, -5.141272108003462e-03,  8.514118333661717e-06,  7.056992850014346e-08,
 -4.420701160661332e-10, -7.790886518212993e-13,  1.878224521949876e-14, -4.122682655806559e-17, -6.214563335819208e-19,  4.272470365390498e-21,  1.004460071423061e-23,
 -2.431485354948107e-25,  1.033654730535361e+00, -5.435391808400622e-03,  3.803163127112853e-06,  1.006032623008725e-07, -3.117980426916177e-10, -2.849853351425521e-12,
  1.949173641218336e-14,  7.095667671481303e-17, -1.092581330454655e-18, -3.213316789373234e-22,  5.484345226179121e-23, -1.505311997350437e-25,  1.173018556163637e+00,
 -5.556764502539542e-03, -2.433594693039342e-06,  1.197163119887414e-07, -5.822188139382992e-12, -4.661643206790287e-12,  5.338093187100829e-15,  2.149932510990195e-16,
 -5.539095395866291e-19, -1.066327576005550e-20,  4.506208654337969e-23,  5.327588674872186e-25,  1.316307160133473e+00, -5.450381072016926e-03, -9.734348531793665e-06,
  1.161681158915130e-07,  4.448777798882316e-10, -4.660948261772001e-12, -2.447132375381733e-14,  2.305356721710331e-16,  1.478198759434044e-18, -1.280451958512621e-20,
 -9.590427779333124e-23,  7.521885880166981e-25,  1.460481235020924e+00, -5.063956251495832e-03, -1.705040660336505e-05,  7.907910052070349e-08,  8.768550897357716e-10,
 -1.315615993277489e-12, -5.018875285036496e-14, -6.153702962448614e-17,  2.904042145301854e-18,  1.186987846091972e-20, -1.614106916348689e-22, -1.267528498738710e-24,
  1.601209802267836e+00, -4.364282986077812e-03, -2.261293058419035e-05,  7.269009243716409e-09,  9.800924878633348e-10,  4.655802567975098e-12, -3.231567432695436e-14,
 -4.646283210714708e-16, -3.486521728041085e-19,  3.056881640694099e-20,  1.929840701127600e-22, -1.222644040212350e-24,  1.732528717989835e+00, -3.366692382884733e-03,
 -2.416610866165154e-05, -7.770781129862059e-08,  4.857748327410684e-10,  8.031034717657060e-12,  3.467267752920340e-14, -2.538300443267889e-16, -4.609248328132698e-18,
 -2.031452361482034e-20,  1.821703550175203e-22,  3.207720166805660e-24,  1.846690909008567e+00, -2.176035417535081e-03, -2.004591755017844e-05, -1.276566300871931e-07,
 -3.780245629173207e-10,  3.162187237363840e-12,  5.867082088005708e-14,  4.404737139429830e-16,  7.306292668948873e-19, -2.553555525814920e-20, -3.613932695607905e-22,
 -2.224537211278690e-24,  1.934590140483481e+00, -1.018019661033917e-03, -1.120900321059944e-05, -1.008154099889960e-07, -7.458830217936646e-10, -4.141912929255422e-12,
 -9.365838512121080e-15,  1.500732222558808e-16,  2.787145550368534e-18,  2.870479373659281e-20,  2.003270326717130e-22,  6.421453796803306e-25,  1.987230473364385e+00,
 -2.100227847880038e-04, -2.562641939153668e-06, -2.739566578797499e-08, -2.695507582601993e-10, -2.487532331686363e-12, -2.166789162579292e-14, -1.778860287173939e-16,
 -1.363485858534026e-18, -9.540471775251389e-21, -5.770814016095512e-23, -2.520268212684033e-25,  1.204756198834894e-03, -9.410356008814743e-06,  5.509551469620349e-08,
 -2.866699293437135e-10,  1.396654183003279e-12, -6.533514750487199e-15,  2.962685873144542e-17, -1.319926060178798e-19,  5.730587761083145e-22, -2.502727702923990e-24,
  1.030471201649688e-26, -4.723563145615167e-29,  1.084441510130803e-02, -8.452009486857703e-05,  4.922361765496683e-07, -2.536708547933417e-09,  1.217216953558722e-11,
 -5.569174533115989e-14,  2.448483933673978e-16, -1.047063274982047e-18,  4.301843859588443e-21, -1.758262517940280e-23,  6.534638540574081e-26, -2.786866796873673e-28,
  3.013214890755522e-02, -2.338058861294667e-04,  1.347067648617554e-06, -6.805744472342495e-09,  3.162319024286855e-11, -1.378259910620064e-13,  5.641625716984026e-16,
 -2.177978142859116e-18,  7.657725299220679e-21, -2.508199971216217e-23,  5.660438906866623e-26, -1.492091576340284e-28,  5.908396571442613e-02, -4.553495023607669e-04,
  2.580092054982630e-06, -1.263196617105414e-08,  5.565597648864077e-11, -2.225542034189452e-13,  7.899016813831286e-16, -2.372090060938855e-18,  4.562359448203866e-21,
  3.848712595141255e-24, -1.366662347080204e-25,  7.558930286369925e-28,  9.772171243488038e-02, -7.461429594500936e-04,  4.130572241549438e-06, -1.932456858469859e-08,
  7.841784055967342e-11, -2.694557308054061e-13,  6.873096726647014e-16, -4.930000569525072e-19, -9.237800513506476e-21,  7.723368142712031e-23, -4.664652374944777e-25,
  1.715903246061872e-27,  1.460701655177469e-01, -1.101921690857427e-03,  5.914767881457404e-06, -2.596979145096808e-08,  9.270715111493917e-11, -2.347805549425055e-13,
  5.850106075370741e-17,  3.942742407866671e-18, -3.170215014921436e-20,  1.569054706453484e-22, -6.102579333804539e-25,  7.119701368568926e-28,  2.041525835901908e-01,
 -1.516924672625771e-03,  7.823659075950973e-06, -3.144612271388612e-08,  9.063382239347380e-11, -8.117639705099227e-14, -1.162170696182368e-15,  1.008100328356441e-17,
 -5.111753078682906e-20,  1.530736828106775e-22, -7.781924551087995e-26, -4.015026096680325e-27,  2.719841251812480e-01, -1.983565283539203e-03,  9.720304675699438e-06,
 -3.445678509688033e-08,  6.463824890790411e-11,  2.091758475609729e-13, -2.801243384948247e-15,  1.522151438995167e-17, -4.648042345333601e-20, -3.959135489304911e-23,
  1.360435514616137e-24, -1.068367827134688e-26,  3.495622243050763e-01, -2.491991389633409e-03,  1.143715711642753e-05, -3.359248558766522e-08,  9.009152888349179e-12,
  6.181149483443406e-13, -4.351518552190841e-15,  1.486596031923785e-17,  4.945214201585946e-21, -4.491001255518038e-22,  2.993696932139396e-24, -1.114137178993476e-26,
  4.368525560429870e-01, -3.029507907287953e-03,  1.277398811380187e-05, -2.744460403753042e-08, -7.794219912487699e-11,  1.073175797352747e-12, -4.938144714955450e-15,
  3.889705861238318e-18,  1.099074435040485e-19, -8.904772395615114e-22,  2.708857463536513e-24,  6.248396045463795e-27,  5.337685300390479e-01, -3.579831707073117e-03,
  1.349769270092141e-05, -1.479907207714718e-08, -1.909329784782796e-10,  1.431807975222083e-12, -3.432331334099355e-15, -2.049455417124563e-17,  2.322157402753306e-19,
 -8.719522560150639e-22, -2.197650383111659e-24,  4.153503996597036e-26,  6.401411957561040e-01, -4.122151676954905e-03,  1.334633966838958e-05,  5.046341422874618e-09,
 -3.140559265205637e-10,  1.478407148431541e-12,  1.153772321662598e-15, -5.363990964171505e-17,  2.690229176653169e-19,  2.541765756829648e-22, -1.160658606210005e-23,
  5.814628068616246e-26,  7.556748437276352e-01, -4.629986557759443e-03,  1.204175217985771e-05,  3.178784549730869e-08, -4.170329277431371e-10,  9.544641557029823e-13,
  8.837942140100381e-15, -7.743428507785977e-17,  6.615447736266044e-20,  2.601206835324675e-21, -1.690928612583779e-23, -1.935535625069557e-26,  8.798811882704307e-01,
 -5.069893075035651e-03,  9.318082716516831e-06,  6.339621344095345e-08, -4.532486549295693e-10, -3.442697834923895e-13,  1.737303837314432e-14, -5.859535735747467e-17,
 -4.629142479531864e-19,  4.469277016593559e-21,  5.198580050946528e-26, -2.081292186718849e-25,  1.011981534529935e+00, -5.400226519439010e-03,  4.978672767121623e-06,
  9.518453874339244e-08, -3.639765727679194e-10, -2.362156917130143e-12,  2.099024174613114e-14,  3.621746909119991e-17, -1.066552106325592e-18,  1.708241606864563e-21,
  4.592526438355911e-23, -2.479031606999758e-25,  1.150761647569613e+00, -5.570495491217224e-03, -1.000606519639751e-06,  1.188862612277294e-07, -9.729811307379000e-11,
 -4.463635361799960e-12,  1.105477374327600e-14,  1.915167281535355e-16, -9.001698920966069e-19, -8.445068171780753e-21,  6.444047194701501e-23,  3.400614522896369e-25,
  1.294358876290800e+00, -5.522566064647872e-03, -8.300796251162544e-06,  1.225107832056916e-07,  3.463342780375003e-10, -5.165905581845114e-12, -1.742826860770320e-14,
  2.697920143716748e-16,  9.569151574613050e-19, -1.589789018398549e-20, -5.701421279895764e-23,  9.916937072710037e-25,  1.439958947058557e+00, -5.196327629973767e-03,
 -1.601836074814081e-05,  9.283244495532932e-08,  8.384136788821614e-10, -2.529973765486984e-12, -5.055601890701097e-14,  3.688161223275622e-17,  3.202852396537787e-18,
  4.428159257342098e-21, -2.069926672071983e-22, -7.630981191078804e-25,  1.583391801192921e+00, -4.544564152114941e-03, -2.242868937722591e-05,  2.364884539990590e-08,
  1.064396984313430e-09,  3.723917702036982e-12, -4.530610339382676e-14, -4.568114025695294e-16,  8.750005232295568e-19,  3.690401466851102e-20,  1.162013624842432e-22,
 -2.258493545563549e-24,  1.718669587911697e+00, -3.563606608689385e-03, -2.504652841524592e-05, -6.860795967463289e-08,  6.540524837010160e-10,  8.760606602531966e-12,
  2.540222568493176e-14, -4.113348949766211e-16, -5.173937948497783e-18, -1.005213141050975e-20,  3.337836142923302e-22,  3.590915540405993e-24,  1.837656192581028e+00,
 -2.342627774307329e-03, -2.161174105390308e-05, -1.331183374383656e-07, -2.996911555757452e-10,  4.719974244544882e-12,  7.117223200916447e-14,  4.461690254007649e-16,
 -4.716142270908065e-19, -4.184772830665164e-20, -4.503787754724235e-22, -1.691502856333945e-24,  1.930330761006967e+00, -1.112740073761463e-03, -1.249316175639938e-05,
 -1.134228346610808e-07, -8.305723721156429e-10, -4.305178764397757e-12, -3.748485422601481e-15,  2.573903785752798e-16,  3.970419571018934e-18,  3.715042415736417e-20,
  2.177537333931145e-22,  6.035269736763077e-26,  1.986347189149164e+00, -2.319162034673130e-04, -2.919004947813047e-06, -3.213652442666857e-08, -3.249320316436204e-10,
 -3.072595616570534e-12, -2.731447589931889e-14, -2.274798348375848e-16, -1.751121678444342e-18, -1.206484387329482e-20, -6.823980186179631e-23, -2.138453651127232e-25,
  1.167975039650934e-03, -8.982981843950215e-06,  5.178536402384521e-08, -2.653314116796715e-10,  1.272805340946639e-12, -5.864827980966317e-15,  2.617479555678314e-17,
 -1.150206885112719e-19,  4.898971997695619e-22, -2.130160241485468e-24,  8.366277400546199e-27, -4.139397185673065e-29,  1.051402227586973e-02, -8.070073926184138e-05,
  4.629284533590740e-07, -2.350554927811449e-09,  1.111480147862859e-11, -5.015220910062376e-14,  2.173661506465782e-16, -9.190509029343757e-19,  3.713033736032722e-21,
 -1.520657203119308e-23,  5.360586014567697e-26, -2.582711101952366e-28,  2.921797308183470e-02, -2.233476239843271e-04,  1.268345903604040e-06, -6.321110165738168e-09,
  2.899726940731854e-11, -1.249910187053891e-13,  5.064771365011777e-16, -1.946955142334513e-18,  6.793773986284921e-21, -2.296834483786829e-23,  4.856190984242509e-26,
 -2.205767742547818e-28,  5.730291008262470e-02, -4.353002935727581e-04,  2.433707824457885e-06, -1.177607147219760e-08,  5.138917459569863e-11, -2.043769960212720e-13,
  7.255407539364021e-16, -2.224873142530048e-18,  4.609701310446006e-21, -1.043830608011707e-24, -1.102453111984489e-25,  4.412934363036557e-28,  9.480179066549764e-02,
 -7.140050349325861e-04,  3.906030579439184e-06, -1.811210506352887e-08,  7.319239994932481e-11, -2.531569067027111e-13,  6.697602674943585e-16, -7.475844121009864e-19,
 -6.776256214272412e-21,  5.995123527873512e-23, -4.011151749032335e-25,  1.239855143103013e-27,  1.417551764661579e-01, -1.055825237642933e-03,  5.611875660231405e-06,
 -2.452393009884394e-08,  8.803395150026189e-11, -2.321613506308724e-13,  1.555112218356235e-16,  3.014000766068327e-18, -2.648548541818600e-20,  1.331069294282174e-22,
 -5.805747445382924e-25,  5.863873157301695e-28,  1.982077081684495e-01, -1.455820294279584e-03,  7.454948219266444e-06, -3.001039253912440e-08,  8.875330341885510e-11,
 -1.058610555070083e-13, -9.019810201094088e-16,  8.532484067213376e-18, -4.570284601060160e-20,  1.467094202333855e-22, -2.344422482490969e-25, -3.199815300917586e-27,
  2.642027954174787e-01, -1.907438895292301e-03,  9.313155138672486e-06, -3.339261592848816e-08,  6.818311692221588e-11,  1.468913981800429e-13, -2.396008800948259e-15,
  1.372094486285252e-17, -4.703563495558053e-20,  5.841471424976107e-24,  9.207057072418580e-25, -9.384570671930483e-27,  3.397747048841360e-01, -2.402103218148664e-03,
  1.103530213017067e-05, -3.335497346764521e-08,  2.036083535549971e-11,  5.186772109965125e-13, -3.935327605605943e-15,  1.478766029640586e-17, -9.187719269771760e-21,
 -3.394408682018007e-22,  2.482992997513543e-24, -1.201312840171783e-26,  4.249367946021462e-01, -2.928652954046664e-03,  1.243785796911702e-05, -2.852636662843497e-08,
 -5.765308504348276e-11,  9.563358284601241e-13, -4.784662096632254e-15,  6.915152090863143e-18,  7.984766326069227e-20, -7.787172764276378e-22,  2.829768723685657e-24,
 -5.404130435974524e-28,  5.196639710778324e-01, -3.472610308334789e-03,  1.330270426759893e-05, -1.762956659468225e-08, -1.631628455110965e-10,  1.343356018747773e-12,
 -3.906966443215691e-15, -1.357948653605138e-17,  1.996530714385877e-19, -9.266648309568537e-22, -6.217504173942889e-25,  3.003935017429458e-26,  6.238663963794857e-01,
 -4.015221903941752e-03,  1.337772566579486e-05,  2.590031888295600e-10, -2.843274813975727e-10,  1.489052837075865e-12, -2.268570317583510e-16, -4.496935391164946e-17,
  2.704348408295496e-19, -1.588273273643569e-22, -9.053731738403843e-24,  5.677907037964112e-26,  7.373498232697161e-01, -4.532238634671158e-03,  1.238383644103752e-05,
  2.527882578627710e-08, -3.959965730994856e-10,  1.140877891635164e-12,  6.712559825124902e-15, -7.395063243936006e-17,  1.475113788202031e-19,  1.917906816396759e-21,
 -1.702521984899527e-23,  1.226240339822076e-26,  8.597553488504642e-01, -4.992429057683337e-03,  1.003516998006240e-05,  5.611122019624288e-08, -4.561054370710402e-10,
  5.146945083163850e-14,  1.554907350002430e-14, -7.085102873171878e-17, -3.040685603703844e-19,  4.301650484191902e-21, -8.085562952532489e-24, -1.605474895444681e-25,
  9.904673769663936e-01, -5.355930692286460e-03,  6.084475897161764e-06,  8.901061600011422e-08, -4.061195580731778e-10, -1.850009750303043e-12,  2.153815871266202e-14,
  3.403756081266580e-18, -9.747968840051650e-19,  3.308074613565021e-21,  3.367483124842820e-23, -3.017091416016786e-25,  1.128472645077399e+00, -5.572826950189826e-03,
  4.137935255338123e-07,  1.166314864457175e-07, -1.835012622143275e-10, -4.137488662286481e-12,  1.597195878914916e-14,  1.583698396239457e-16, -1.154774895317663e-18,
 -5.632751994178193e-21,  7.455275011282909e-23,  1.178767806702204e-25,  1.272145232581428e+00, -5.583005700988125e-03, -6.800894724062619e-06,  1.272054840620391e-07,
  2.394608586034130e-10, -5.490616111319342e-12, -9.534065417694474e-15,  2.909036718826813e-16,  3.544010750334868e-19, -1.727041226065546e-20, -1.105063647798154e-23,
  1.068549276280827e-24,  1.418924714376898e+00, -5.319794781356853e-03, -1.482576556289349e-05,  1.057769037580208e-07,  7.758246738032621e-10, -3.719255731656078e-12,
 -4.807620752191783e-14,  1.402713975764786e-16,  3.206910283993997e-18, -4.326293430286523e-21, -2.255835658693289e-22, -5.874406697863580e-26,  1.564856898548357e+00,
 -4.722563751356262e-03, -2.204046641990725e-05,  4.121166889768221e-08,  1.126987486903780e-09,  2.487501115243562e-12, -5.749991037066787e-14, -4.068686368337862e-16,
  2.260749088383015e-18,  3.929280726954895e-20, -2.935301925623331e-24, -3.101513466187641e-24,  1.704009471775517e+00, -3.767080605290826e-03, -2.580115711087595e-05,
 -5.671255419775966e-08,  8.343304930464638e-10,  9.213107926802270e-12,  1.153267918308059e-14, -5.798063215858964e-16, -5.257673149508502e-18,  6.418200495793959e-21,
  4.871051657149941e-22,  3.224741206609534e-24,  1.827929671795753e+00, -2.521985100700568e-03, -2.323450414911799e-05, -1.370611936839260e-07, -1.872136075412506e-10,
  6.574795670028048e-12,  8.320166615085432e-14,  4.033706258494034e-16, -2.317200346699113e-18, -6.099061085279780e-20, -4.957902456974678e-22, -1.787139180572455e-25,
  1.925670962397159e+00, -1.218362141919303e-03, -1.393682061887661e-05, -1.274029841711357e-07, -9.169121609459236e-10, -4.293006528820924e-12,  5.450180052670841e-15,
  4.075108065216936e-16,  5.462465568870735e-18,  4.559499048120644e-20,  1.950053783582094e-22, -1.246838608491879e-24,  1.985370246643710e+00, -2.569040907212171e-04,
 -3.337986208465456e-06, -3.786495516512981e-08, -3.934898404125059e-10, -3.811328901445120e-12, -3.453756237671271e-14, -2.910084384640006e-16, -2.236561951998086e-18,
 -1.494817103165583e-20, -7.479126667644176e-23, -5.598162175564310e-26,  1.132851990189222e-03, -8.581097334562984e-06,  4.871981325515673e-08, -2.458718307797444e-10,
  1.161538727982511e-12, -5.273577006165031e-15,  2.316260195872372e-17, -1.005098624320221e-19,  4.188054479558166e-22, -1.830976828702145e-24,  6.609391092332010e-27,
 -3.915237728382890e-29,  1.019845170174824e-02, -7.710718947781238e-05,  4.357566095251849e-07, -2.180467526295607e-09,  1.016190806011657e-11, -4.523128784264885e-14,
  1.932166887308143e-16, -8.086011089976946e-19,  3.201466066957508e-21, -1.328877078889614e-23,  4.225163170384990e-26, -2.629832109156255e-28,  2.834440660574693e-02,
 -2.134965685719049e-04,  1.195195915164031e-06, -5.876510074721976e-09,  2.661471161884917e-11, -1.134659291863333e-13,  4.548842533459249e-16, -1.742429900841961e-18,
  5.999280050084055e-21, -2.124922254042648e-23,  3.656472479737273e-26, -3.352269494738590e-28,  5.559977258358086e-02, -4.163822091624640e-04,  2.297196446266427e-06,
 -1.098561977452698e-08,  4.747080433457518e-11, -1.876949709436263e-13,  6.652979254240129e-16, -2.078783107318318e-18,  4.496499742696384e-21, -5.168266812308581e-24,
 -9.868848534080911e-26,  6.737967128825712e-29,  9.200691810071120e-02, -6.836066421686637e-04,  3.695547514127118e-06, -1.698066593539098e-08,  6.828819019061645e-11,
 -2.373564656170650e-13,  6.460950902339224e-16, -9.328923663592675e-19, -4.895167012955433e-21,  4.483047306407624e-23, -3.593969573434463e-25,  6.232061195421386e-28,
  1.376198350490736e-01, -1.012083787203132e-03,  5.325887263150229e-06, -2.315230287892036e-08,  8.343440618282761e-11, -2.275078799997085e-13,  2.287264281280700e-16,
  2.238697029406960e-18, -2.210641221229907e-20,  1.102864689684758e-22, -5.640156528294619e-25,  9.354018263103633e-29,  1.925014592329810e-01, -1.397597234627770e-03,
  7.103270362585256e-06, -2.860837531874027e-08,  8.643812489465767e-11, -1.248021380820923e-13, -6.827668131052896e-16,  7.152419291568062e-18, -4.062303816674101e-20,
  1.346151860189709e-22, -3.691520419849850e-25, -3.050681280405665e-27,  2.567195389316106e-01, -1.834517750327652e-03,  8.919076503890015e-06, -3.228118026122856e-08,
  7.057614456110170e-11,  9.382777231128464e-14, -2.032816618194705e-15,  1.222548526082347e-17, -4.625960185711412e-20,  3.465746476277598e-23,  5.246754602201054e-25,
 -8.763197382101845e-27,  3.303403306844814e-01, -2.315415545941250e-03,  1.063732317580388e-05, -3.295120337266362e-08,  2.982322216213567e-11,  4.291541478467271e-13,
 -3.527095659755049e-15,  1.431625666435478e-17, -1.974929198980272e-20, -2.509235271753766e-22,  1.936612816484989e-24, -1.288629372369773e-26,  4.134190002366744e-01,
 -2.830533624089417e-03,  1.209061803631889e-05, -2.930197075322135e-08, -3.965761870501668e-11,  8.440910330493735e-13, -4.559325547954197e-15,  9.043428661567562e-18,
  5.382935110487391e-20, -6.677718218057469e-22,  2.674699985559492e-24, -6.434043285214935e-27,  5.059849732608499e-01, -3.367077265473636e-03,  1.307635562441345e-05,
 -2.003044652814568e-08, -1.372605954754891e-10,  1.245717126169620e-12, -4.202782858987669e-15, -7.726767705149626e-18,  1.661326670846346e-19, -9.285472265199858e-22,
  4.417500841588905e-25,  1.824102197839594e-26,  6.080194658559950e-01, -3.908262744153173e-03,  1.335451895488906e-05, -4.052694487256062e-09, -2.546978380875775e-10,
  1.469468794872300e-12, -1.366174200208244e-15, -3.647203151867472e-17,  2.587847900344064e-19, -4.728130016270325e-22, -6.700411309439153e-24,  4.925830797806818e-26,
  7.194207815959074e-01, -4.432060483023325e-03,  1.264994611390454e-05,  1.913348061499173e-08, -3.717327105328512e-10,  1.277724448271639e-12,  4.717478057998521e-15,
 -6.825551317784601e-17,  2.044907974012933e-19,  1.254424100894342e-21, -1.600434777160249e-23,  3.209609254826305e-26,  8.399502849125722e-01, -4.909578213409736e-03,
  1.066481626293606e-05,  4.884135183179638e-08, -4.515100449589930e-10,  3.998822899996412e-13,  1.345178183122222e-14, -7.817881945512177e-17, -1.565977862863756e-19,
  3.851802953623698e-21, -1.404209438848947e-23, -1.106197888010011e-25,  9.691476111908395e-01, -5.303095469696022e-03,  7.112485721462750e-06,  8.224475775256580e-08,
 -4.379605935660342e-10, -1.335356461970124e-12,  2.121635899440888e-14, -2.565073334702473e-17, -8.347238617822132e-19,  4.383056503613809e-21,  1.998140203300717e-23,
 -3.146259993735857e-25,  1.106196743389213e+00, -5.563974349475458e-03,  1.793095898589793e-06,  1.130557258584009e-07, -2.620808825457901e-10, -3.705291663190206e-12,
  1.986263357443123e-14,  1.187543573722399e-16, -1.303219794365117e-18, -2.611859166526169e-21,  7.492148298500391e-23, -9.728548058999669e-26,  1.249714143943552e+00,
 -5.631250274883899e-03, -5.255097145012359e-06,  1.301487118902832e-07,  1.280243116249302e-10, -5.620983801088422e-12, -1.323537348600570e-15,  2.923026494893582e-16,
 -2.640882788175550e-19, -1.678873130972401e-20,  3.441406892726000e-23,  9.699889736275549e-25,  1.397416652006449e+00, -5.433118643269833e-03, -1.348461718608292e-05,
  1.175338678060397e-07,  6.902784985197906e-10, -4.814563382861939e-12, -4.274770529541726e-14,  2.386675774830485e-16,  2.890184209265669e-18, -1.317459226048410e-20,
 -2.112273485343185e-22,  7.079069838218225e-25,  1.545617565278889e+00, -4.896599506724430e-03, -2.143634691628022e-05,  5.956277934645816e-08,  1.162062523145998e-09,
  9.802697004937316e-13, -6.766852113808240e-14, -3.121914881790503e-16,  3.638829855573129e-18,  3.629385623655659e-20, -1.497400797387385e-22, -3.472499444597568e-24,
  1.688524359620466e+00, -3.975971054035781e-03, -2.639549856523361e-05, -4.187998812001343e-08,  1.019948655250532e-09,  9.276420039633623e-12, -6.994271507135552e-15,
 -7.403355591818625e-16, -4.644627187081051e-18,  2.840313717662795e-20,  6.017091787078331e-22,  1.790375751645462e-24,  1.817459504872045e+00, -2.714480276359431e-03,
 -2.489251010049560e-05, -1.388924871077012e-07, -3.488686012652796e-11,  8.696623931748679e-12,  9.310068212725305e-14,  2.902885286955987e-16, -4.865251547873655e-18,
 -8.024827851672947e-20, -4.464282746320862e-22,  2.660421802845882e-24,  1.920564481458774e+00, -1.336227908641340e-03, -1.555647886008392e-05, -1.427490979604366e-07,
 -1.000431309637065e-09, -4.003959105875820e-12,  1.956436615114535e-14,  6.099349237014254e-16,  7.225538473271515e-18,  5.167192549925874e-20,  9.089899518553893e-23,
 -3.718572102959871e-24,  1.984286185640810e+00, -2.855386276635494e-04, -3.832809993147066e-06, -4.481856469032901e-08, -4.787094227366064e-10, -4.746614545724480e-12,
 -4.377279683752757e-14, -3.717654783693174e-16, -2.828308984090004e-18, -1.789352475532223e-20, -6.953258414081074e-23,  3.519666679389646e-25,  1.099288867308064e-03,
 -8.202832562111130e-06,  4.587747373115109e-08, -2.281017097908881e-10,  1.061405830518508e-12, -4.749990637463156e-15,  2.052638560130942e-17, -8.811509173336489e-20,
  3.572309890158392e-22, -1.601452709589069e-24,  4.846459871039494e-27, -4.198239000740325e-29,  9.896833147602986e-03, -7.372310215589763e-05,  4.105374853366370e-07,
 -2.024869543985464e-09,  9.301878395092184e-12, -4.085463172966724e-14,  1.719403876532972e-16, -7.135054899301087e-19,  2.750621085745151e-21, -1.183976463034031e-23,
  2.987432668239216e-26, -3.078557197482597e-28,  2.750910684875576e-02, -2.042100032278522e-04,  1.127159796096482e-06, -5.468252275026430e-09,  2.445072257429982e-11,
 -1.031131676657345e-13,  4.086707238805216e-16, -1.562442018490312e-18,  5.256621264420904e-21, -2.013356567021387e-23,  1.772713437595601e-26, -5.409595847509160e-28,
  5.397018184259821e-02, -3.985193150397547e-04,  2.169805084351374e-06, -1.025527005198984e-08,  4.387194493960293e-11, -1.724102316752624e-13,  6.090730216808985e-16,
 -1.938636268590158e-18,  4.238844392742248e-21, -9.197291073560750e-24, -1.066143298734206e-25, -4.635157635169702e-28,  8.933035551549406e-02, -6.548391149862461e-04,
  3.498181238005791e-06, -1.592519860030474e-08,  6.369392238953751e-11, -2.221799430893211e-13,  6.180041537839388e-16, -1.066450093706771e-18, -3.535559157687808e-21,
  3.076392660298130e-23, -3.505002715626989e-25, -2.821454529759408e-28,  1.336549861069020e-01, -9.705656492517169e-04,  5.055920197406763e-06, -2.185343546183831e-08,
  7.894382216634412e-11, -2.213426674773588e-13,  2.820720748739294e-16,  1.590456018882415e-18, -1.854348362315394e-20,  8.754814766644669e-23, -5.805191453973244e-25,
 -9.570937664191560e-28,  1.870225813189967e-01, -1.342120957728552e-03,  6.768182845141979e-06, -2.724615848589048e-08,  8.379369923084850e-11, -1.389278522992936e-13,
 -4.999915309266756e-16,  5.926900412800487e-18, -3.607627223481203e-20,  1.170132521134237e-22, -5.166213484424475e-25, -3.836452312961127e-27,  2.495217470529286e-01,
 -1.764695312275901e-03,  8.538531301144978e-06, -3.113948690435839e-08,  7.199169227942462e-11,  4.898194077751383e-14, -1.711015260906209e-15,  1.076843559982347e-17,
 -4.472741507464132e-20,  4.787825268275287e-23,  1.325136587637109e-25, -9.301767694489860e-27,  3.212463736553924e-01, -2.231889883276459e-03,  1.024504047702345e-05,
 -3.240983158306670e-08,  3.759186879373315e-11,  3.492348607382256e-13, -3.136346097872209e-15,  1.355356588866351e-17, -2.752842973000939e-20, -1.852115057149814e-22,
  1.336561097651353e-24, -1.460863214368898e-26,  4.022880750940333e-01, -2.735224716434859e-03,  1.173572534043660e-05, -2.980729412970918e-08, -2.384861133747161e-11,
  7.378789687426419e-13, -4.285464471426335e-15,  1.040132386256420e-17,  3.163150193334780e-20, -5.681693155338347e-22,  2.261610723969606e-24, -1.247153063047845e-26,
  4.927243133181115e-01, -3.263463359232265e-03,  1.282361749382724e-05, -2.203284488939844e-08, -1.133694709723445e-10,  1.142824148986342e-12, -4.349697862486480e-15,
 -2.940599683052076e-18,  1.331837702764274e-19, -8.984289213196711e-22,  9.730585660611644e-25,  5.714062926730949e-27,  5.925996843021240e-01, -3.801688179299259e-03,
  1.328239879861297e-05, -7.894856977638462e-09, -2.257142995433736e-10,  1.425344301640155e-12, -2.274359559587562e-15, -2.851094413715439e-17,  2.374310241213969e-19,
 -7.009115542109418e-22, -4.799002764843987e-24,  3.628342999063446e-26,  7.018962528078400e-01, -4.330041639402471e-03,  1.284472302347874e-05,  1.339570875202910e-08,
 -3.451968475998086e-10,  1.368786890020068e-12,  2.903860631541264e-15, -6.110985159157364e-17,  2.384964714776294e-19,  6.455155181784939e-22, -1.438991846629943e-23,
  3.911060964332876e-26,  8.204861486223957e-01, -4.822037391096813e-03,  1.120788620862837e-05,  4.169796055342369e-08, -4.404636787065122e-10,  6.960147431468871e-13,
  1.121264105709401e-14, -8.108841700867289e-17, -2.909248218282407e-20,  3.206222197733300e-21, -1.792271315988106e-23, -6.759788466757498e-26,  9.480551090569539e-01,
 -5.242368812256744e-03,  8.056586086369556e-06,  7.505110077097792e-08, -4.596489352016047e-10, -8.376502086171843e-13,  2.014884700416394e-14, -4.970990714198228e-17,
 -6.658552894324758e-19,  4.908912383098321e-21,  6.442710617419875e-24, -2.968368225802099e-25,  1.083978019914795e+00, -5.544279651947472e-03,  3.122246134354031e-06,
  1.082965307932567e-07, -3.311749976631986e-10, -3.193465909103692e-12,  2.259383600331126e-14,  7.611348855247711e-17, -1.344852507994967e-18,  2.431402257101438e-22,
  6.651473968787910e-23, -2.774337895410752e-25,  1.227114990491292e+00, -5.667017632647801e-03, -3.684730161715302e-06,  1.312987760733070e-07,  1.594266499917456e-11,
 -5.556036910883646e-12,  6.654124664928647e-15,  2.745270227851757e-16, -8.339858264663799e-19, -1.462283479171406e-20,  7.204575133196622e-23,  7.188569918587361e-25,
  1.375477611109338e+00, -5.535173867624296e-03, -1.201129556722353e-05,  1.277547046013184e-07,  5.843210249688128e-10, -5.750359893890124e-12, -3.485272209059383e-14,
  3.220078127882948e-16,  2.273233832885653e-18, -2.079309253195788e-20, -1.648770248495908e-22,  1.367222013634921e-24,  1.525693159930086e+00, -5.064914284659135e-03,
 -2.060968193377421e-05,  7.822166277890158e-08,  1.164792373011676e-09, -7.343545740248409e-13, -7.459323249731083e-14, -1.762972648139236e-16,  4.801025685958797e-18,
  2.728654576097917e-20, -2.983552671635721e-22, -3.159973785404453e-24,  1.672195374679699e+00, -4.188853851221503e-03, -2.679407041359489e-05, -2.409303935931194e-08,
  1.202037175375350e-09,  8.844123783380657e-12, -2.961692345720760e-14, -8.678435701189547e-16, -3.175993904495097e-18,  5.336126447944816e-20,  6.271801268511527e-22,
 -8.162391656659913e-25,  1.806192752816086e+00, -2.920282665840867e-03, -2.655642934318473e-05, -1.379354020606592e-07,  1.619454803223448e-10,  1.100819879600026e-11,
  9.859190702274411e-14,  8.522721469414743e-17, -8.037068645172448e-18, -9.460962480653743e-20, -2.406772150282290e-22,  6.903575446168887e-24,  1.914959425287747e+00,
 -1.467809702994671e-03, -1.736805236885286e-05, -1.593648216046477e-07, -1.074289324224899e-09, -3.301613782950965e-12,  4.016208119977240e-14,  8.712347728499375e-16,
  9.102143201012098e-18,  5.095538363401208e-20, -1.567807466642953e-22, -7.851093597863475e-24,  1.983079106133227e+00, -3.184902117195725e-04, -4.419916666209241e-06,
 -5.329818451801456e-08, -5.850457970591002e-10, -5.932915468521676e-12, -5.554974499779569e-14, -4.730723077658377e-16, -3.516898039463886e-18, -2.014690335663950e-20,
 -3.660536678095427e-23,  1.255564172080097e-24,  1.067194639184321e-03, -7.846480002104828e-06,  4.323909764545400e-08, -2.118532648832259e-10,  9.711389597403787e-13,
 -4.285724331425185e-15,  1.821078065320783e-17, -7.757246488458834e-20,  3.026026136970449e-22, -1.446883169012041e-24,  2.809945313194038e-27, -5.189168305940420e-29,
  9.608358940502736e-03, -7.053352657576728e-05,  3.871057752142064e-07, -1.882358639071250e-09,  8.524482983278198e-12, -3.695824029929226e-14,  1.531319191640672e-16,
 -6.321026410987323e-19,  2.342407613687152e-21, -1.094156532773963e-23,  1.427566294096786e-26, -4.123413546817766e-28,  2.670989499212058e-02, -1.954487037139859e-04,
  1.063821669860123e-06, -5.093020455052098e-09,  2.248309198381208e-11, -9.381170894667856e-14,  3.671690312484924e-16, -1.405742052876461e-18,  4.538023286691382e-21,
 -1.999263019109624e-23, -1.326819778858102e-26, -8.967220674034587e-28,  5.241005857097124e-02, -3.816414511524234e-04,  2.050842282640115e-06, -9.580128523075244e-09,
  4.056559881051228e-11, -1.584288698575585e-13,  5.566342733451411e-16, -1.809166219929322e-18,  3.824155420379405e-21, -1.408389986052325e-23, -1.435923209449896e-25,
 -1.271268375500849e-27,  8.676578366001396e-02, -6.276010823972030e-04,  3.313049414771110e-06, -1.494084912601578e-08,  5.939616373045266e-11, -2.077180296082338e-13,
  5.867065795542666e-16, -1.164619327522553e-18, -2.686682433660401e-21,  1.612853753473749e-23, -3.913414989096384e-25, -1.666566258067612e-27,  1.298519872459118e-01,
 -9.311461138357453e-04,  4.801112722649648e-06, -2.062536734150815e-08,  7.458793849478538e-11, -2.141028482608611e-13,  3.187386101612399e-16,  1.042900636699161e-18,
 -1.582415602019671e-20,  6.300192115328329e-23, -6.603990086041532e-25, -2.827256300083400e-27,  1.817603495989235e-01, -1.289260733824046e-03,  6.449179482717245e-06,
 -2.592828561802756e-08,  8.090792820420866e-11, -1.490629212504117e-13, -3.495976981028546e-16,  4.835512379651233e-18, -3.228089094021664e-20,  9.246387628328359e-23,
 -7.260044936318201e-25, -5.920100427709530e-27,  2.425972434289549e-01, -1.697862115043809e-03,  8.171794034652764e-06, -2.998191425494839e-08,  7.258428120454237e-11,
  1.137564340909981e-14, -1.429275310381168e-15,  9.364929805353435e-18, -4.301157100206499e-20,  4.446666076494386e-23, -3.196200622227827e-25, -1.157530344358152e-26,
  3.124802867251639e-01, -2.151474501489024e-03,  9.859948912591842e-06, -3.175644673643357e-08,  4.385404307807413e-11,  2.784111857295085e-13, -2.770115311847621e-15,
  1.257498569254051e-17, -3.339634718576847e-20, -1.454819973212270e-22,  6.243509318042539e-25, -1.812687473063793e-26,  3.915326747551036e-01, -2.642775064883156e-03,
  1.137621751750583e-05, -3.007629867949525e-08, -1.009544012288393e-11,  6.386187416184354e-13, -3.983013748483742e-15,  1.110253236687883e-17,  1.265506371216653e-20,
 -4.907328714114726e-22,  1.555967639470632e-24, -1.993211384425348e-26,  4.798739219746657e-01, -3.161961132195493e-03,  1.254907572029262e-05, -2.366959627726292e-08,
 -9.156122163543260e-11,  1.037895342330819e-12, -4.377175386258225e-15,  8.115508818073358e-19,  1.015650187810524e-19, -8.585175432677584e-22,  9.186260644466910e-25,
 -8.560144701023632e-27,  5.776047661128317e-01, -3.695867190365676e-03,  1.316692235734958e-05, -1.128145273582641e-08, -1.978135890434369e-10,  1.362013977852976e-12,
 -2.970337710782164e-15, -2.135109508738713e-17,  2.090826333358215e-19, -8.659670371002562e-22, -3.588000894717343e-24,  1.785821253192410e-26,  6.847824901074747e-01,
 -4.226732652403952e-03,  1.297324674467191e-05,  8.094785713591784e-09, -3.172582464483123e-10,  1.418826621837884e-12,  1.302352063909805e-15, -5.321390665317937e-17,
  2.517825824547070e-19,  1.034394416942146e-22, -1.276013836483496e-23,  3.277242050403329e-26,  8.013803266540941e-01, -4.730491456341580e-03,  1.166648184309269e-05,
  3.477575279880882e-08, -4.240363680693773e-10,  9.378687941985587e-13,  8.945466848680032e-15, -8.031617175840078e-17,  7.280054268587573e-20,  2.439498834319555e-21,
 -2.020432485909464e-23, -3.894910014371093e-26,  9.272200650970882e-01, -5.174439800284558e-03,  8.912603864691300e-06,  6.758845341837676e-08, -4.716907042766028e-10,
 -3.730236964200180e-13,  1.848544275623760e-14, -6.816500901194442e-17, -4.875597754088485e-19,  4.914735634888238e-21, -5.902953120480432e-24, -2.629361584433938e-25,
  1.061858954455676e+00, -5.514198188404146e-03,  4.388001222790465e-06,  1.025168760358328e-07, -3.894742032816960e-10, -2.630476892973402e-12,  2.412734543145222e-14,
  3.370527258906143e-17, -1.291542130017513e-18,  2.617342140443258e-21,  5.124388862024239e-23, -4.080435825625356e-25,  1.204397938059327e+00, -5.690197172353619e-03,
 -2.111246233125349e-06,  1.306761230049318e-07, -9.297602859131132e-11, -5.307577634867223e-12,  1.389241227744103e-14,  2.400289883033485e-16, -1.301801051634201e-18,
 -1.120720235887617e-20,  9.614991725834121e-23,  3.648431724287325e-25,  1.353154656770153e+00, -5.624982091053800e-03, -1.042607803715225e-05,  1.361415395896316e-07,
  4.617188787721171e-10, -6.471144674466396e-12, -2.493897623896647e-14,  3.816281030512515e-16,  1.421784087691759e-18, -2.604496198622527e-20, -9.481745912512975e-23,
  1.763696271082522e-24,  1.505110137730840e+00, -5.225722031989492e-03, -1.956000547877799e-05,  9.664221918953217e-08,  1.131896315901829e-09, -2.565648692090839e-12,
 -7.724894899295149e-14, -9.508289724795209e-18,  5.537262299508611e-18,  1.282817494833869e-20, -4.169555381319670e-22, -2.118251674523754e-24,  1.655009902016119e+00,
 -4.404022775926997e-03, -2.696210231599000e-05, -3.492449293750807e-09,  1.369792121247406e-09,  7.832183104896034e-12, -5.501676717231909e-14, -9.340255253555403e-16,
 -8.209316959656444e-19,  7.674738383495058e-20,  5.166215334729535e-22, -4.305511209911186e-24,  1.794076321494562e+00, -3.139293381218941e-03, -2.818842466915495e-05,
 -1.334541510464795e-07,  4.058010679455598e-10,  1.337078166661121e-11,  9.685625884829937e-14, -2.276303764959684e-16, -1.152971590886548e-17, -9.668417850211829e-20,
  1.743344442873204e-22,  1.201294253354252e-23,  1.908797767249655e+00, -1.614700474621714e-03, -1.938554728942853e-05, -1.770204302015594e-07, -1.128529663002022e-09,
 -2.010442376718310e-12,  6.889717356711486e-14,  1.189871382946150e-15,  1.072559285220201e-17,  3.612003128079081e-20, -6.295727171073093e-22, -1.396830521737525e-23,
  1.981730138789288e+00, -3.565765023304691e-04, -5.119822518491652e-06, -6.368536171464649e-08, -7.181775677160545e-10, -7.438455881429552e-12, -7.048163999713670e-14,
 -5.973665848539283e-16, -4.251240094681105e-18, -2.005210783434125e-20,  5.471150487310271e-23,  3.102962986206702e-24,  1.036484808408834e-03, -7.510478391466344e-06,
  4.078733417951262e-08, -1.969777299758523e-10,  8.896245793739024e-13, -3.873683201894851e-15,  1.616661456519892e-17, -6.870562692759062e-20,  2.519464255982529e-22,
 -1.384777164469202e-24,  1.699657727087158e-28, -6.898330031221027e-29,  9.332278668282191e-03, -6.752476983782211e-05,  3.653120602168530e-07, -1.751686415623272e-09,
  7.820678470927268e-12, -3.348735152761311e-14,  1.364237953940051e-16, -5.633758595532050e-19,  1.954010691607972e-21, -1.077883948214206e-23, -7.356889558815313e-27,
 -5.783972845498388e-28,  2.594474270377529e-02, -1.871766194843411e-04,  1.004803400549865e-06, -4.747835164333488e-09,  2.069187211396645e-11, -8.545624279435616e-14,
  3.297318700944202e-16, -1.272229011145512e-18,  3.797945010433553e-21, -2.145526597500566e-23, -6.363647803400700e-26, -1.411687384176155e-27,  5.091559341865184e-02,
 -3.656837613981303e-04,  1.939672779543024e-06, -8.955718691082476e-09,  3.752657977373799e-11, -1.456642101609868e-13,  5.076059931642316e-16, -1.696141645841664e-18,
  3.197486486392621e-21, -2.125560152069729e-23, -2.230928111418083e-25, -2.377424049150064e-27,  8.430727501458125e-02, -6.017980028971089e-04,  3.139326610624056e-06,
 -1.402299158186852e-08,  5.537992302219960e-11, -1.940376744690134e-13,  5.529583704795585e-16, -1.244498755415285e-18, -2.410255242220967e-21, -1.521180295707121e-24,
 -5.050080446798136e-25, -3.559992806492929e-27,  1.262026812823764e-01, -8.937072644584475e-04,  4.560628819823690e-06, -1.946579222221167e-08,  7.038445658035287e-11,
 -2.061580205571219e-13,  3.411536003678112e-16,  5.674312057567858e-19, -1.406830508485326e-20,  3.334578428408530e-23, -8.422949072631409e-25, -5.542283408877621e-27,
  1.767045537521039e-01, -1.238890078032787e-03,  6.145707478987511e-06, -2.465802073823053e-08,  7.785314228701404e-11, -1.559423998055814e-13, -2.282079485188258e-16,
  3.849614991657715e-18, -2.954598124080369e-20,  5.728656544336968e-23, -1.057832080193451e-24, -9.326450772282481e-27,  2.359342929282845e-01, -1.633907146112857e-03,
  7.818980862158565e-06, -2.882052305389037e-08,  7.248920973144157e-11, -1.993451236331351e-14, -1.186109476823587e-15,  8.010645134598966e-18, -4.177344903337217e-20,
  2.039482430151738e-23, -9.140399648200726e-25, -1.567411224003194e-26,  3.040297517808971e-01, -2.074106891030026e-03,  9.483253912043593e-06, -3.101373100720347e-08,
  4.878531503725334e-11,  2.160281450187592e-13, -2.433739727907872e-15,  1.142567623615868e-17, -3.839003494484000e-20, -1.379862036912311e-22, -2.905842268713354e-25,
 -2.372252978613031e-26,  3.811413055384306e-01, -2.553210795555664e-03,  1.101473772555205e-05, -3.014073425852588e-08,  1.746360600094183e-12,  5.467866836230572e-13,
 -3.669054279950756e-15,  1.123497257162942e-17, -4.126321566552858e-21, -4.486886818099008e-22,  4.776346682895861e-25, -2.930713088457797e-26,  4.674250306418885e-01,
 -3.062728031125326e-03,  1.225691724564805e-05, -2.497420643540001e-08, -7.185021857221731e-11,  9.334547457206844e-13, -4.313552202340317e-15,  3.573201685900537e-18,
  7.118646072958470e-20, -8.340052946210395e-22,  1.878649178649870e-25, -2.485666942286248e-26,  5.630310374548708e-01, -3.591125082393078e-03,  1.301344067902549e-05,
 -1.423261128315525e-08, -1.713308332254620e-10,  1.284278182772917e-12, -3.479376440730166e-15, -1.518579683567858e-17,  1.754546682605184e-19, -1.000325738813337e-21,
 -3.298750448414704e-24, -5.232627672243166e-27,  6.680836276765612e-01, -4.122642257773893e-03,  1.304086796353991e-05,  3.246874090590714e-09, -2.886851313576951e-10,
  1.433113628560100e-12, -7.496617025735564e-17, -4.519323481954933e-17,  2.466254973653680e-19, -3.827975545196145e-22, -1.168616334971535e-23,  1.443532544338133e-26,
  7.826475066358182e-01, -4.635604205781434e-03,  1.204373808877310e-05,  2.815213591555517e-08, -4.033125529331337e-10,  1.125912505148616e-12,  6.741301255286498e-15,
 -7.674044102990338e-17,  1.457052193298427e-19,  1.601504649723587e-21, -2.161656443145310e-23, -2.802484420964663e-26,  9.066698625966786e-01, -5.100023437205216e-03,
  9.678213040036542e-06,  6.000514479962484e-08, -4.748776956603270e-10,  4.612177678863983e-14,  1.638454151518213e-14, -8.100358181780970e-17, -3.175683997231642e-19,
  4.458115195991006e-21, -1.666087263931738e-23, -2.262938879209002e-25,  1.039880006433662e+00, -5.474283098217330e-03,  5.579180688039035e-06,  9.589611263726874e-08,
 -4.362404529486937e-10, -2.044665541491508e-12,  2.450925597352078e-14, -5.757677940232401e-18, -1.164999764345309e-18,  4.281231795446116e-21,  3.138203262711794e-23,
 -4.860745986343218e-25,  1.181613254638015e+00, -5.700847916630667e-03, -5.554967456222546e-07,  1.283596057091021e-07, -1.952748278320410e-10, -4.898562919993041e-12,
  1.997480395287300e-14,  1.926828179471711e-16, -1.633209494989094e-18, -7.155218208313220e-21,  1.035837597345320e-22, -2.740333227905422e-26,  1.330498422002472e+00,
 -5.701740362964928e-03, -8.752420722537787e-06,  1.424648523502693e-07,  3.271989743896444e-10, -6.937200604773648e-12, -1.376171029842853e-14,  4.115459489748072e-16,
  4.350020418458292e-19, -2.824664175298788e-20, -1.497397213978699e-23,  1.803977122246956e-24,  1.483902063007315e+00, -5.377259926710689e-03, -1.829365580044049e-05,
  1.142415978392150e-07,  1.062126888325620e-09, -4.402487924895033e-12, -7.498894126515097e-14,  1.716976244528626e-16,  5.680355095637338e-18, -5.273948375505462e-21,
 -4.764715244100084e-22, -5.205790070960785e-25,  1.636962692903993e+00, -4.619503253992755e-03, -2.686759916426172e-05,  1.959672076265704e-08,  1.511109367343508e-09,
  6.197664760752663e-12, -8.109593521845556e-14, -9.125364264492811e-16,  2.258359798131831e-18,  9.253651784679375e-20,  2.464911194809380e-22, -7.903486366035620e-24,
  1.781058174298900e+00, -3.371075069723833e-03, -2.974169155774992e-05, -1.246986659508264e-07,  6.957170853112890e-10,  1.557401586907418e-11,  8.481005804312305e-14,
 -6.498038039239489e-16, -1.474418013636366e-17, -7.770163682731360e-20,  8.077298450620964e-22,  1.649449105108129e-23,  1.902014906464792e+00, -1.778591206711122e-03,
 -2.161913450949185e-05, -1.952966949062856e-07, -1.149299757794762e-09,  8.266590497480953e-14,  1.071718707317371e-13,  1.547703446781996e-15,  1.140467616816697e-17,
 -3.550608543435389e-21, -1.410410738194358e-21, -2.168885313779941e-23,  1.980216784057353e+00, -4.007992570988059e-04, -5.958215223608422e-06, -7.646423563182981e-08,
 -8.852993050805807e-10, -9.346747288914717e-12, -8.921617930216275e-14, -7.442163518485779e-16, -4.892969026755768e-18, -1.424157243506826e-20,  2.617334119686129e-22,
  6.682095741596422e-24,  1.007080855903988e-03, -7.193398425401186e-06,  3.850651528728624e-08, -1.833430830303815e-10,  8.158795910545778e-13, -3.507904674063091e-15,
  1.434820796355566e-17, -6.144592115466402e-20,  2.014367283819827e-22, -1.443901655585406e-24, -3.236587941126772e-27, -8.360465140089990e-29,  9.067894391182709e-03,
 -6.468427685061218e-05,  3.450210686060866e-07, -1.631740880543598e-09,  7.182430398339039e-12, -3.039577089256499e-14,  1.214656244758042e-16, -5.071657986893694e-19,
  1.554076860772235e-21, -1.163210153102045e-23, -3.637052030664788e-26, -7.196958786716502e-28,  2.521176002264555e-02, -1.793605873377753e-04,  9.497607574492044e-07,
 -4.430020112876993e-09,  1.905906536478829e-11, -7.795714792709044e-14,  2.956905683694907e-16, -1.163675196869260e-18,  2.963350321422517e-21, -2.539544688154532e-23,
 -1.366458886999914e-25, -1.847652849747425e-27,  4.948322662652743e-02, -3.505862636177761e-04,  1.835712669016975e-06, -8.377953719068191e-09,  3.473133067223029e-11,
 -1.340407818685918e-13,  4.614179025510666e-16, -1.608012211349519e-18,  2.243435533981093e-21, -3.259573321003915e-23, -3.509308306892989e-25, -3.314289235842890e-27,
  8.194926736427020e-02, -5.773417205810496e-04,  2.976241422329108e-06, -1.316724979022387e-08,  5.162901122703768e-11, -1.811937388559614e-13,  5.169946383294196e-16,
 -1.326742503386429e-18, -2.871541265486467e-21, -2.541097288127927e-23, -7.015815276101088e-25, -5.176818933680023e-27,  1.226993695036107e-01, -8.581377578011283e-04,
  4.333661610311123e-06, -1.837217683737982e-08,  6.634420087829495e-11, -1.978296842641838e-13,  3.508701707859901e-16,  1.294230726713539e-19, -1.354061213920291e-20,
 -6.034796864310186e-24, -1.144372450475651e-24, -7.896348771900496e-27,  1.718454803309357e-01, -1.190887065933229e-03,  5.857181341410261e-06, -2.343758408120866e-08,
  7.468771011022887e-11, -1.602311656681709e-13, -1.334084844272230e-16,  2.928107040440240e-18, -2.835390699996485e-20,  5.720942123997173e-24, -1.543020816404441e-24,
 -1.232905255614560e-26,  2.295216054615737e-01, -1.572719007238707e-03,  7.480075584585797e-06, -2.766535835725822e-08,  7.182324253883175e-11, -4.586022457798433e-14,
 -9.804740540853343e-16,  6.677157842379629e-18, -4.187543214658984e-20, -3.123738788149884e-23, -1.694839710611555e-24, -1.928711723929160e-26,  2.958827183769678e-01,
 -1.999715940942524e-03,  9.115905119721675e-06, -3.020166884505719e-08,  5.254695646539481e-11,  1.613138777088605e-13, -2.131794648439606e-15,  1.011332519044520e-17,
 -4.383408121112945e-20, -1.721790365261148e-22, -1.454981756961805e-24, -2.848374951123611e-26,  3.711024091918654e-01, -2.466538373424785e-03,  1.065356223737564e-05,
 -3.002998456819150e-08,  1.182686198522729e-11,  4.624745520099505e-13, -3.358741083591735e-15,  1.084548486923255e-17, -2.027091845778671e-20, -4.580545591716346e-22,
 -1.003607399739254e-24, -3.700845632918363e-26,  4.553683053879805e-01, -2.965889615835235e-03,  1.195092711044728e-05, -2.598004375255754e-08, -5.420705955435674e-11,
  8.313597501537851e-13, -4.186128099699556e-15,  5.369810912924434e-18,  4.099154265513277e-20, -8.529422997495842e-22, -1.235996234483590e-24, -3.848630456756435e-26,
  5.488736072424053e-01, -3.487745402336433e-03,  1.282703414186888e-05, -1.677309080202231e-08, -1.465116269825628e-10,  1.196270960328685e-12, -3.831575050849110e-15,
 -1.017376829817113e-17,  1.369494252830318e-19, -1.143705763086628e-21, -4.025855201496691e-24, -2.624147085030985e-26,  6.518018513088546e-01, -4.018235810838864e-03,
  1.305306108099208e-05, -1.143301976120276e-09, -2.601388056902095e-10,  1.417005375872632e-12, -1.232598205836899e-15, -3.761108617149318e-17,  2.245229292353602e-19,
 -8.441922205020264e-22, -1.154050119844753e-23, -6.652628545775565e-27,  7.642997766363198e-01, -4.538010934648760e-03,  1.234361532020415e-05,  2.188735125948137e-08,
 -3.793475107675293e-10,  1.262493064162955e-12,  4.665308597869945e-15, -7.132466972298410e-17,  1.875023445550232e-19,  7.125740101573508e-22, -2.282323551427687e-23,
 -2.655709183650698e-26,  8.864289985569914e-01, -5.019846447658836e-03,  1.035278401477227e-05,  5.243505663191864e-08, -4.702120099799906e-10,  4.111284680385946e-13,
  1.399727121243000e-14, -8.874535589072604e-17, -1.713742282644008e-19,  3.603332445812663e-21, -2.579703878421559e-23, -1.871659825493173e-25,  1.018079257683390e+00,
 -5.425168197532212e-03,  6.686808675962200e-06,  8.862095027046093e-08, -4.712857397861784e-10, -1.462440594445303e-12,  2.385077240722450e-14, -4.037197265126435e-17,
 -9.935402823681610e-19,  5.098050793267357e-21,  9.309015453115496e-24, -5.061150938756361e-25,  1.158810645775093e+00, -5.699191012198185e-03,  9.629282116634990e-07,
  1.244792108625759e-07, -2.880465565002180e-10, -4.360541487314105e-12,  2.460517565514592e-14,  1.370893458108588e-16, -1.817517155209794e-18, -3.145898604044161e-21,
  9.429546420437534e-23, -3.808936714747400e-25,  1.307562360767026e+00, -5.764843059321131e-03, -7.016057327684408e-06,  1.465760727468534e-07,  1.860896773242862e-10,
 -7.128569193258432e-12, -2.196355669886538e-15,  4.092320028847122e-16, -5.741044504500617e-19, -2.732583862541196e-20,  5.877814943460720e-23,  1.499396519875255e-24,
  1.462109405414625e+00, -5.517843995388045e-03, -1.682400949213996e-05,  1.304354449648220e-07,  9.565741233335677e-10, -6.124299419435801e-12, -6.769148074983678e-14,
  3.467396139334604e-16,  5.146725024438961e-18, -2.426151820542711e-20, -4.597333614827531e-22,  1.281827768245438e-24,  1.618056879421117e+00, -4.833083691951387e-03,
 -2.648364740243913e-05,  4.465184742366643e-08,  1.613585462347438e-09,  3.956044616830570e-12, -1.051250433925436e-13, -7.857992274623514e-16,  5.675236004232323e-18,
  9.457223584213158e-20, -1.633729249634831e-22, -1.044581982264290e-23,  1.767088829085042e+00, -3.614780546804968e-03, -3.116066889984717e-05, -1.109719336877980e-07,
  1.025792482288543e-09,  1.733548260322295e-11,  5.964256562678763e-14, -1.158669345862310e-15, -1.677782601818070e-17, -3.015112938710198e-20,  1.580051274538882e-21,
  1.785489373775542e-23,  1.894539353008032e+00, -1.961230023918415e-03, -2.407247833844935e-05, -2.135170420053215e-07, -1.118203944099519e-09,  3.215502271034251e-12,
  1.555085185279454e-13,  1.897713519926086e-15,  1.001027213286890e-17, -8.134875689818500e-20, -2.533026682378934e-21, -2.896026973079558e-23,  1.978512084621094e+00,
 -4.523910629903829e-04, -6.967340623239262e-06, -9.224825046739021e-08, -1.095427152737323e-09, -1.175607079985745e-11, -1.123051652697951e-13, -9.063037965090182e-16,
 -5.131609777808515e-18,  3.778910298151690e-21,  6.873278916933276e-22,  1.330987889672654e-23,  9.789097387902352e-04, -6.893930065149799e-06,  3.638246655326099e-08,
 -1.708321367439592e-10,  7.490292649428265e-13, -3.183514218275814e-15,  1.270993178293406e-17, -5.586376082500771e-20,  1.462521893710168e-22, -1.644706406574961e-24,
 -6.634169986007541e-27, -5.893394412350318e-29,  8.814556306978708e-03, -6.200052343905385e-05,  3.261101302597604e-07, -1.521531658521044e-09,  6.602543837475395e-12,
 -2.764578257312552e-14,  1.078958958658111e-16, -4.644778017325565e-19,  1.101597095246265e-21, -1.370243191449283e-23, -6.567044367601198e-26, -5.044599166160508e-28,
  2.450918432942947e-02, -1.719700742218507e-04,  8.983799538191775e-07, -4.137173526831772e-09,  1.756830057159886e-11, -7.124174009366627e-14,  2.642893608695684e-16,
 -1.084689344527078e-18,  1.931304842049354e-21, -3.244779428183205e-23, -2.120929376266243e-25, -1.279820774868943e-27,  4.810962932332344e-02, -3.362934570305284e-04,
  1.738424872737274e-06, -7.843112441686934e-09,  3.215764530836313e-11, -1.235001202746779e-13,  4.172012369329061e-16, -1.557992355005922e-18,  7.823268653181245e-22,
 -4.949119819006408e-23, -4.866401470369354e-25, -2.255595415582949e-27,  7.968653910158723e-02, -5.541500451993077e-04,  2.823073370853364e-06, -1.236951527801382e-08,
  4.812614811978638e-11, -1.692430865393687e-13,  4.783806610830838e-16, -1.439132075455955e-18, -4.346256095906977e-21, -5.794780737513613e-23, -9.136007223672891e-25,
 -3.459056900080903e-27,  1.193347858562016e-01, -8.243325815102222e-04,  4.119435447264730e-06, -1.734186449270322e-08,  6.247185446181290e-11, -1.894148103973209e-13,
  3.483282199333580e-16, -3.168682629163720e-19, -1.466520192615801e-20, -5.861584542799264e-23, -1.466616490550453e-24, -5.238589602590294e-27,  1.671738940699887e-01,
 -1.145134548731406e-03,  5.582994108241516e-06, -2.226836564158144e-08,  7.145717900115090e-11, -1.625519149737404e-13, -6.418415346528796e-17,  2.011106782431081e-18,
 -2.938843380147600e-20, -6.656624647218346e-23, -2.043806045967250e-24, -8.295558250781386e-27,  2.233483355528662e-01, -1.514186881550853e-03,  7.154952073401075e-06,
 -2.652474182666697e-08,  7.068507925483408e-11, -6.730104631767915e-14, -8.125457519378752e-16,  5.304418266372332e-18, -4.442199017998496e-20, -1.154966429599859e-22,
 -2.477783959390529e-24, -1.340341642469990e-26,  2.880274342474036e-01, -1.928223859714479e-03,  8.758627319894464e-06, -2.933779383198514e-08,  5.528369519209164e-11,
  1.133841898225948e-13, -1.869285277585452e-15,  8.597791554227745e-18, -5.137825797963083e-20, -2.547509196502401e-22, -2.619683759224129e-24, -2.062460071317482e-26,
  3.614044358482244e-01, -2.382747422865972e-03,  1.029462912569555e-05, -2.977103691468667e-08,  2.029440798103143e-11,  3.854199563992105e-13, -3.066701604126896e-15,
  9.922041667119760e-18, -3.787421263044136e-20, -5.302318711511565e-22, -2.543941987511856e-24, -2.800507094777508e-26,  4.436939680812620e-01, -2.871542756906680e-03,
  1.163449386822751e-05, -2.671974443646263e-08, -3.857171242332682e-11,  7.328163607127902e-13, -4.022112884186255e-15,  6.177328030077916e-18,  8.980447774950640e-21,
 -9.365871088551072e-22, -2.892642756948770e-24, -3.038584004186009e-26,  5.351265295198550e-01, -3.385972303298158e-03,  1.261246504603621e-05, -1.893095829744381e-08,
 -1.235264662617150e-10,  1.101350767446202e-12, -4.061512459105243e-15, -6.483656765959623e-18,  9.257824805075118e-20, -1.329572311051863e-21, -5.233718197822731e-24,
 -2.067140321414254e-26,  6.359375730829695e-01, -3.913934816755002e-03,  1.301529720495993e-05, -5.080753157096027e-09, -2.321757586204581e-10,  1.375566284798404e-12,
 -2.190330484658542e-15, -3.100243339652884e-17,  1.857312949290903e-19, -1.313340447045282e-21, -1.186979520591364e-23,  9.972475021106355e-28,  7.463467510878735e-01,
 -4.438312646556331e-03,  1.257069730057401e-05,  1.602520696845659e-08, -3.531361582591892e-10,  1.351190740208466e-12,  2.754806813566667e-15, -6.509243523734070e-17,
  1.964744199941051e-19, -2.193462300352286e-22, -2.356901326917912e-23,  2.879611910613840e-27,  8.665190627816028e-01, -4.934634451223516e-03,  1.093719247858010e-05,
  4.499484292614391e-08, -4.588340911709169e-10,  7.167372079725941e-13,  1.145361836415384e-14, -9.236809630871781e-17, -6.205956269480529e-20,  2.424431198345598e-21,
 -3.259057841094382e-23, -1.089415526344558e-25,  9.964921253717477e-01, -5.367550135241770e-03,  7.704150982080958e-06,  8.087704255756429e-08, -4.949197716808374e-10,
 -9.070085987250976e-13,  2.230310467302710e-14, -6.919986231131204e-17, -8.085716103148271e-19,  5.038069689196181e-21, -1.175595126994069e-23, -4.284223529936004e-25,
  1.136038629919220e+00, -5.685597346619589e-03,  2.426255526378728e-06,  1.192060502281577e-07, -3.690755433722788e-10, -3.730606915053344e-12,  2.761738019642896e-14,
  7.780712265765664e-17, -1.867632729104940e-18,  2.147703086857521e-22,  7.223200130399006e-23, -5.846452762265116e-25,  1.284401928566728e+00, -5.813896084940877e-03,
 -5.243983448776657e-06,  1.484139195478519e-07,  4.390478915169489e-11, -7.046745436804865e-12,  8.860996494470207e-15,  3.756955508154860e-16, -1.500878030184552e-18,
 -2.379548593744095e-20,  1.141161006641861e-22,  1.007425007039753e-24,  1.439779112725534e+00, -5.645924846514135e-03, -1.517127120276681e-05,  1.446760975708443e-07,
  8.187208906762232e-10, -7.614710516748750e-12, -5.583285640979926e-14,  4.940518721820587e-16,  3.960514979407532e-18, -4.101927317919407e-20, -3.662023841236200e-22,
  2.920287499137559e-24,  1.598304826214775e+00, -5.042365600182667e-03, -2.579077355243676e-05,  7.095802696872472e-08,  1.665813322731430e-09,  1.192614783329416e-12,
 -1.240873941453406e-13, -5.518984889283770e-16,  8.848594720849677e-18,  7.857096380765637e-20, -6.384597534486512e-22, -1.067263629359845e-23,  1.752123131537508e+00,
 -3.869086739267333e-03, -3.238219546276156e-05, -9.171993314492858e-08,  1.383872396971388e-09,  1.831639319951712e-11,  1.961585973955867e-14, -1.699232618669994e-15,
 -1.654301146172038e-17,  4.792923318379602e-20,  2.290851660187106e-21,  1.328091858136842e-23,  1.886292624789232e+00, -2.164356522887848e-03, -2.673920048108070e-05,
 -2.306723661967739e-07, -1.012095000553249e-09,  7.618067190820729e-12,  2.125345752001217e-13,  2.149057102691738e-15,  4.939166482759892e-18, -2.093264663726825e-19,
 -3.879758595333020e-21, -3.072263950891140e-23,  1.976583586596584e+00, -5.128745250407037e-04, -8.187738389948250e-06, -1.118114603114223e-07, -1.359651880293934e-09,
 -1.477412188009223e-11, -1.399148862929010e-13, -1.061716003085112e-15, -4.333062271606215e-18,  4.597777601549933e-20,  1.507601645765313e-21,  2.502315422068438e-23,
  9.519034361320350e-04, -6.610871273194620e-06,  3.440233885734498e-08, -1.593409800566072e-10,  6.882851592049196e-13, -2.896773868773993e-15,  1.120197961044770e-17,
 -5.218567754888664e-20,  8.190633759422865e-23, -1.930377323186494e-24, -6.539665851024491e-27,  9.610918242375207e-29,  8.571658820000305e-03, -5.946292115383932e-05,
  3.084677921790823e-07, -1.420177942270162e-09,  6.074488349089305e-12, -2.520883698067628e-14,  9.530607944738068e-17, -4.376548881111786e-19,  5.580535962802097e-22,
 -1.649016572254268e-23, -6.374245857207647e-26,  8.891335246619856e-28,  2.383537029283265e-02, -1.649769464420215e-04,  8.503744972180273e-07, -3.867144977788759e-09,
  1.620446643296051e-11, -6.525740735793979e-14,  2.345955579877348e-16, -1.043284184993317e-18,  6.034677583250885e-22, -4.127539491966941e-23, -2.016148196986050e-25,
  2.587201137153845e-27,  4.679168632202385e-02, -3.227539648254689e-04,  1.647314869112569e-06, -7.347820909207463e-09,  2.978424480649668e-11, -1.140097311459765e-13,
  3.736325551296829e-16, -1.565336064703377e-18, -1.360832385154816e-21, -6.941119690024406e-23, -4.550262800400433e-25,  5.338213633976083e-27,  7.751418615786113e-02,
 -5.321463579194486e-04,  2.679149579805177e-06, -1.162596600405405e-08,  4.485274345803198e-11, -1.582633999327005e-13,  4.357728441575165e-16, -1.618808419320708e-18,
 -7.105537767928879e-21, -9.499064338260360e-23, -8.480069189281496e-25,  9.195477527796909e-27,  1.161020721289147e-01, -7.921928000617661e-04,  3.917206818342456e-06,
 -1.637217097063493e-08,  5.876615453189130e-11, -1.812167925030877e-13,  3.324862879358186e-16, -8.314890862982520e-19, -1.785447929633347e-20, -1.180212499084040e-22,
 -1.366138539855534e-24,  1.398300722017114e-26,  1.626810184982304e-01, -1.101520288599088e-03,  5.322526101986076e-06, -2.115112558025569e-08,  6.819473699070438e-11,
 -1.635256623789549e-13, -2.151469142176700e-17,  1.016132902437940e-18, -3.329767265423088e-20, -1.500543022044621e-22, -1.933539874493506e-24,  1.924650350576527e-26,
  2.174040783792776e-01, -1.458201335172466e-03,  6.843393219106122e-06, -2.540556073361364e-08,  6.915522874460950e-11, -8.518503712740334e-14, -6.846893189367150e-16,
  3.796507755971502e-18, -5.044156889781478e-20, -2.187270459500782e-22, -2.413022512278085e-24,  2.442918884179979e-26,  2.804524686100234e-01, -1.859547861194392e-03,
  8.411948181701140e-06, -2.843747239394220e-08,  5.712125144807226e-11,  7.121518551031423e-14, -1.653095236480612e-15,  6.785483535736951e-18, -6.256879585358462e-20,
 -3.675202902983242e-22, -2.660491315268511e-24,  2.944624902972923e-26,  3.520359061572315e-01, -2.301813319237963e-03,  9.939566620962247e-06, -2.938856641213713e-08,
  2.728851655945409e-11,  3.149975828631456e-13, -2.808872510607191e-15,  8.383273640637301e-18, -5.898347180953820e-20, -6.437811463808884e-22, -2.677305325596470e-24,
  3.576582058416292e-26,  4.323919048694094e-01, -2.779758765101135e-03,  1.131062088119425e-05, -2.722482706757785e-08, -2.486664957678582e-11,  6.383617029413313e-13,
 -3.850363866554810e-15,  5.901079074342488e-18, -2.701292539900155e-20, -1.063592045761964e-21, -2.899304409442303e-24,  4.770732451075176e-26,  5.217829557238208e-01,
 -3.286013228766932e-03,  1.237414458596405e-05, -2.073651812955791e-08, -1.024873817697047e-10,  1.001985022837498e-12, -4.209069508708003e-15, -4.328254834353635e-18,
  4.087463468292493e-20, -1.539167165642872e-21, -4.581100045977481e-24,  7.243499504118515e-26,  6.204896060100267e-01, -3.810117396187202e-03,  1.293293713740524e-05,
 -8.578614532148459e-09, -2.052571520699453e-10,  1.313206197868365e-12, -2.982946403059947e-15, -2.590595541104800e-17,  1.300954559973485e-19, -1.765476377664347e-21,
 -9.928249587236008e-24,  1.143150402282668e-25,  7.287957167033978e-01, -4.337071837128786e-03,  1.273000047244776e-05,  1.059420416760629e-08, -3.255952023017798e-10,
  1.396131729881746e-12,  1.017763996987342e-15, -5.911167026104296e-17,  1.719004038705663e-19, -1.128473395742815e-21, -2.079709519436049e-23,  1.554112019495510e-25,
  8.469587650253732e-01, -4.845100779710378e-03,  1.143360153725755e-05,  3.778222850037577e-08, -4.419608203616756e-10,  9.604354281469623e-13,  8.850795012462766e-15,
 -9.321576997113220e-17,  1.031743108002887e-21,  1.075269848644079e-21, -3.323446715179344e-23,  1.187259252182822e-25,  9.751511462686761e-01, -5.302170640698388e-03,
  8.626656855280369e-06,  7.284157880577274e-08, -5.078785578344824e-10, -3.977455446316145e-13,  2.002969071124329e-14, -9.229632798828424e-17, -6.396493408477816e-19,
  4.256221449295960e-21, -2.518110820236334e-23, -1.284264050829881e-25,  1.113343971378467e+00, -5.660571233908576e-03,  3.818953064211422e-06,  1.127405769919500e-07,
 -4.369178473083611e-10, -3.048374129696821e-12,  2.896412525800027e-14,  1.867375269213567e-17, -1.814080560095836e-18,  2.597116182347582e-21,  4.788844560386767e-23,
 -4.415189150537401e-25,  1.261073722803134e+00, -5.848722760946778e-03, -3.463405461507987e-06,  1.480039408127077e-07, -9.408268901223153e-11, -6.714033029364867e-12,
  1.858604112186533e-14,  3.149210216993822e-16, -2.265848130881851e-18, -1.846926134588698e-20,  1.497430848129092e-22,  6.800656467141276e-25,  1.416963966946384e+00,
 -5.760139894412854e-03, -1.336180894185201e-05,  1.564894147091918e-07,  6.542151817410666e-10, -8.775835269505135e-12, -4.046566585312408e-14,  5.946105819751645e-16,
  2.254913939025566e-18, -5.268496469925956e-20, -2.073319755405926e-22,  4.264504078882420e-24,  1.577728744956416e+00, -5.244831964214198e-03, -2.477910907022734e-05,
  9.763540168094748e-08,  1.658808677921406e-09, -1.936508852910610e-12, -1.351914583477574e-13, -2.293005803729923e-16,  1.110966743655672e-17,  4.428196226619183e-20,
 -1.053678374636523e-21, -7.601984392547653e-24,  1.736122266957490e+00, -4.132142523958183e-03, -3.333785796721782e-05, -6.663899888697369e-08,  1.750754202622212e-09,
  1.815866402944127e-11, -3.498263682791537e-14, -2.182342187783832e-15, -1.305362263906980e-17,  1.482561639706329e-19,  2.638248187736805e-21,  1.335158244322543e-24,
  1.877189469405446e+00, -2.389604207564560e-03, -2.959844786710666e-05, -2.453491702162777e-07, -8.037926472041353e-10,  1.345074276309482e-11,  2.735597189233027e-13,
  2.154056831831251e-15, -5.696918475988088e-18, -3.892190487270033e-19, -5.022570735511442e-21, -1.784594319621207e-23,  1.974392033741913e+00, -5.841369008348243e-04,
 -9.670372659210364e-06, -1.361225642075275e-07, -1.691194646176107e-09, -1.850247995380785e-11, -1.712384438881722e-13, -1.159806595465639e-15, -1.281908370218830e-18,
  1.333842668054399e-19,  3.004703591364354e-21,  4.456330319624655e-23,  9.259985371594187e-04, -6.343118026456152e-06,  3.255445657190501e-08, -1.487777862638475e-10,
  6.329210523800636e-13, -2.645230282836271e-15,  9.766743011096778e-18, -5.071304622768706e-20,  9.626279734694578e-24, -2.003050207198322e-24,  6.170680461510841e-27,
  5.479392810594954e-28,  8.338636969613249e-03, -5.706173262736654e-05,  2.919925611813016e-07, -1.326899400820390e-09,  5.592200513150257e-12, -2.306708850398625e-14,
  8.320968907960081e-17, -4.296593460805694e-19, -6.392095385613917e-23, -1.731700319995895e-23,  5.183820285996469e-26,  4.963357120713075e-27,  2.318878069018460e-02,
 -1.583552630613200e-04,  8.054822802221429e-07, -3.618018698306599e-09,  1.495326032498648e-11, -5.997689587355999e-14,  2.054214569700528e-16, -1.048937484272974e-18,
 -9.774945488664260e-22, -4.444178732176570e-23,  1.254113005169820e-25,  1.395245459628085e-26,  4.552648027880983e-02, -3.099202101654491e-04,  1.561926596507430e-06,
 -6.889042353643850e-09,  2.759013617934931e-11, -1.055758415752124e-13,  3.287968205389218e-16, -1.651632602086505e-18, -4.085911761925295e-21, -7.774281489678655e-23,
  2.005698427029346e-25,  2.777754025564740e-26,  7.542760045689241e-02, -5.112592446500174e-04,  2.543841194675250e-06, -1.093309192079381e-08,  4.178824252266329e-11,
 -1.483778307295331e-13,  3.867090281931521e-16, -1.906180449163073e-18, -1.096351252752287e-20, -1.121768749054844e-22,  2.597380821449013e-25,  4.671082584438100e-26,
  1.129947541593068e-01, -7.616252980044874e-04,  3.726264094327478e-06, -1.546048275378243e-08,  5.521937800934868e-11, -1.735853240573757e-13,  3.005022956753620e-16,
 -1.479434774007152e-18, -2.282512717278075e-20, -1.472432033648722e-22,  3.164986078421164e-25,  7.093432122431345e-26,  1.583585161348135e-01, -1.059937033544878e-03,
  5.075151293026604e-06, -2.008619451088958e-08,  6.492071959974846e-11, -1.638264645041831e-13, -8.884307104613639e-18, -1.480650695795595e-19, -3.972572799358487e-20,
 -1.917351995227250e-22,  4.365085079449870e-25,  1.004978477998545e-25,  2.116788628852702e-01, -1.404654981228789e-03,  6.545106368649784e-06, -2.431356675242645e-08,
  6.729483733247943e-11, -1.005322156047727e-13, -6.022825519943961e-16,  2.041272228618343e-18, -5.957263100657480e-20, -2.681536410873442e-22,  7.437172768529329e-25,
  1.354418918948138e-25,  2.731467291482558e-01, -1.793601642889627e-03,  8.076222338811321e-06, -2.751423321301288e-08,  5.816297823774549e-11,  3.358170980210270e-14,
 -1.493244355439750e-15,  4.555446878300889e-18, -7.711001339758798e-20, -4.141804124756403e-22,  1.387974348196969e-24,  1.762368532677605e-25,  3.429854634957004e-01,
 -2.223699559602316e-03,  9.589719763550416e-06, -2.890513761277102e-08,  3.293215659848622e-11,  2.501661032475500e-13, -2.604167640829559e-15,  6.109784469666685e-18,
 -8.333181284886557e-20, -6.759016978328589e-22,  2.436072364258279e-24,  2.246870569952144e-25,  4.214517623459689e-01, -2.690586415519829e-03,  1.098194096107681e-05,
 -2.752552250169413e-08, -1.301077658284095e-11,  5.478020290886973e-13, -3.703113049353617e-15,  4.408749965600064e-18, -6.641300653145498e-20, -1.083090036196425e-21,
  3.640172636631282e-24,  2.852380784072087e-25,  5.088352757544156e-01, -3.188041814355364e-03,  1.211611100312671e-05, -2.222152647315797e-08, -8.346713179532975e-11,
  8.996086196973808e-13, -4.320477230305023e-15, -3.932292073479780e-18, -1.648782168644037e-20, -1.591709807308477e-21,  4.072668702858193e-24,  3.658012957335872e-25,
  6.054553352244015e-01, -3.707119532921702e-03,  1.281114253736293e-05, -1.165674467347299e-08, -1.797655169062509e-10,  1.233320364367753e-12, -3.660053079722036e-15,
 -2.282213145084223e-17,  6.131024650552509e-20, -1.979912578823406e-21,  1.810419807016941e-24,  4.749463657185840e-25,  7.116517922987559e-01, -4.234809745451728e-03,
  1.282679801716639e-05,  5.608837078058641e-09, -2.975593359767003e-10,  1.401275290921032e-12, -5.674985546173746e-16, -5.440234083143672e-17,  1.188461155202468e-19,
 -1.719832618873230e-21, -5.503988118081297e-24,  6.078506697267996e-25,  8.277640032813371e-01, -4.751937103345805e-03,  1.184522888990433e-05,  3.087517950367955e-08,
 -4.208391954994402e-10,  1.141564724627834e-12,  6.245301830165406e-15, -9.280209292665684e-17,  1.827341823388856e-20, -1.120318651805816e-23, -1.681128359959899e-23,
  7.109195132421715e-25,  9.540858305613520e-01, -5.229799572448102e-03,  9.451819055582646e-06,  6.467708277981938e-08, -5.112470496780444e-10,  4.977702960561475e-14,
  1.718046401857340e-14, -1.105088540934605e-16, -5.043306520729397e-19,  3.318515184958740e-21, -1.609485291043983e-23,  6.476001582179388e-25,  1.090771184399932e+00,
 -5.624731291090849e-03,  5.128006496619085e-06,  1.052999817806709e-07, -4.909250771204732e-10, -2.353421622722379e-12,  2.869079926266027e-14, -3.753958478314835e-17,
 -1.689258925632863e-18,  4.303540932792151e-21,  4.340575899431586e-23,  3.859735895443476e-25,  1.237634616204546e+00, -5.869361439580840e-03, -1.700735043716808e-06,
  1.454514518919563e-07, -2.232332548483586e-10, -6.170919454275415e-12,  2.629735980292015e-14,  2.329914588179733e-16, -2.815434801549011e-18, -1.183650122993864e-20,
  1.848366834922192e-22,  1.095962105774957e-24,  1.393721744856070e+00, -5.859358580986972e-03, -1.142707851597076e-05,  1.655057412032288e-07,  4.703698184580030e-10,
 -9.540868559393213e-12, -2.310067382281484e-14,  6.352103932786204e-16,  2.576678897825780e-19, -5.684043834914991e-20,  9.674934027002972e-24,  5.667848630229940e-24,
  1.556361003294313e+00, -5.437931238216174e-03, -2.345009195105809e-05,  1.236887651506318e-07,  1.587325259044681e-09, -5.216808548142359e-12, -1.364563970633850e-13,
  1.430248981809142e-16,  1.187983933125584e-17, -2.822876597785281e-21, -1.251883355848848e-21, -7.833114678164869e-25,  1.719055934746922e+00, -4.401540656056838e-03,
 -3.395767525795206e-05, -3.578871757835348e-08,  2.100361725487487e-09,  1.654426929358746e-11, -1.009893918473600e-13, -2.494464285054042e-15, -5.846211114810391e-18,
  2.501333769629915e-19,  2.330702513980521e-21, -1.569312054321425e-23,  1.867138552212340e+00, -2.638364319859551e-03, -3.260971424800242e-05, -2.556810555128944e-07,
 -4.644046079727807e-10,  2.070497692648030e-11,  3.289317748176049e-13,  1.707770234672437e-15, -2.343337231027147e-17, -5.964974905118371e-19, -5.053109507220228e-21,
  2.190163112124529e-23,  1.971889726468998e+00, -6.685233995669600e-04, -1.147916329137256e-05, -1.663764292524276e-07, -2.104973690723953e-09, -2.300116338726995e-11,
 -2.033755953266861e-13, -1.096502728436488e-15,  6.227373022455369e-18,  3.007997563435630e-19,  5.584430736357677e-21,  7.454715862704321e-23,  9.011358670889389e-04,
 -6.089655493498755e-06,  3.082817764105480e-08, -1.390620334258223e-10,  5.822453556761664e-13, -2.427896741509020e-15,  8.340927862288934e-18, -5.145046623946241e-20,
 -5.012911217562399e-23, -1.035136265956798e-24,  4.918645484525217e-26,  1.505701676815408e-27,  8.114963177769977e-03, -5.478799660798722e-05,  2.765917356180921e-07,
 -1.241010522989896e-09,  5.149851054607608e-12, -2.121520160363766e-14,  7.106278775727620e-17, -4.407302398371206e-19, -5.784190107478868e-22, -8.720037276522268e-24,
  4.408339686611406e-25,  1.360675673449562e-26,  2.256797800899149e-02, -1.520810919047036e-04,  7.634628243044608e-07, -3.388105034660135e-09,  1.380062026584629e-11,
 -5.540416637302302e-14,  1.753882740767397e-16, -1.103306629875164e-18, -2.286204709577553e-21, -2.112678190651587e-23,  1.215833479310373e-24,  3.809736033230255e-26,
  4.431127708292391e-02, -2.977481246782906e-04,  1.481838406446947e-06, -6.464079579754468e-09,  2.555369777787766e-11, -9.825690049547629e-14,  2.803280135826709e-16,
 -1.822550186774817e-18, -6.341027797238207e-21, -3.337419497356278e-23,  2.364883263110449e-24,  7.552191973487381e-26,  7.342244977577060e-02, -4.914221594541032e-04,
  2.416559415596874e-06, -1.028773513101759e-08,  3.890895277721058e-11, -1.397804747500574e-13,  3.278602434790187e-16, -2.314476307878382e-18, -1.414441277308391e-20,
 -4.076550959766807e-23,  3.891671311440016e-24,  1.266255021914854e-25,  1.100067190555992e-01, -7.325425301312342e-04,  3.545926022388617e-06, -1.460437013208801e-08,
  5.181599027468931e-11, -1.669575233899857e-13,  2.481166278661644e-16, -2.284394259824396e-18, -2.687988434975551e-20, -4.191842339908555e-23,  5.831849069156848e-24,
  1.923000928112423e-25,  1.541984684716715e-01, -1.020282551210720e-03,  4.840241174738640e-06, -1.907369088923966e-08,  6.164095406062488e-11, -1.642390854349513e-13,
 -3.177901997495466e-17, -1.515272438592009e-18, -4.486899290851423e-20, -4.270858063094119e-23,  8.272797934459380e-24,  2.735799049786684e-25,  2.061631424646021e-01,
 -1.353443035119103e-03,  6.259735020228604e-06, -2.325370443823620e-08,  6.514312551865033e-11, -1.145249102108730e-13, -5.731421756692649e-16,  1.216281376830029e-21,
 -6.673664659517906e-20, -6.032884951399913e-23,  1.136514804704828e-23,  3.717698003271092e-25,  2.660994734385771e-01, -1.730296688455505e-03,  7.751651148679629e-06,
 -2.658016149608070e-08,  5.848506887954250e-11, -1.017293986976101e-15, -1.402293149207417e-15,  1.879640630351352e-18, -8.846754682991390e-20, -1.256927243885461e-22,
  1.530835229864825e-23,  4.888387767595833e-25,  3.342419171028634e-01, -2.148359932096976e-03,  9.246173854125246e-06, -2.834153989823631e-08,  3.732268699419671e-11,
  1.893964095541908e-13, -2.473810776958207e-15,  3.097665827660444e-18, -1.026442915130876e-19, -2.802522843400232e-22,  2.027932060497589e-23,  6.282443555812355e-25,
  4.108630318619255e-01, -2.604054850366947e-03,  1.065073166719739e-05, -2.765083825691811e-08, -2.934872109256754e-12,  4.601342199666983e-13, -3.614905526331903e-15,
  1.719498659008158e-18, -9.864164782379882e-20, -5.593884625259532e-22,  2.625881905924077e-23,  7.962737580961577e-25,  4.962752471421267e-01, -3.092200932051407e-03,
  1.184201522647677e-05, -2.341873627289731e-08, -6.652131811047535e-11,  7.944854133796551e-13, -4.446132606379094e-15, -5.304874435031694e-18, -6.558735399899870e-20,
 -9.486047958972304e-22,  3.271672728715423e-23,  1.003494185909628e-24,  5.908308828619735e-01, -3.605236970014096e-03,  1.265480205717360e-05, -1.434064850220227e-08,
 -1.560284110103538e-10,  1.137968402116952e-12, -4.281931338747597e-15, -2.193475145247695e-17, -1.908573316542531e-21, -1.293914344068921e-21,  3.822502085950538e-23,
  1.264255266860293e-24,  6.949180968930552e-01, -4.132004950685871e-03,  1.286645941231930e-05,  1.070840816545512e-09, -2.697914367370164e-10,  1.369748700549714e-12,
 -2.046762402832095e-15, -5.156635137134446e-17,  6.155096487646343e-20, -1.161936569118713e-21,  4.052108994007804e-23,  1.588079525934000e-24,  8.089479657905867e-01,
 -4.655805948164479e-03,  1.217610788287150e-05,  2.433166428182013e-08, -3.967191749131388e-10,  1.260333358127850e-12,  3.654482658738784e-15, -9.227493156048048e-17,
  1.602243483882137e-20,  2.509680229897819e-22,  3.892710922405281e-23,  1.950600375619367e-24,  9.333225807924548e-01, -5.151219363365075e-03,  1.017896680477508e-05,
  5.652641416443391e-08, -5.063877988638403e-10,  4.232612624810002e-13,  1.387778204765727e-14, -1.247819005300935e-16, -3.860721201673195e-19,  3.643687337797915e-21,
  4.394112145610344e-23,  2.242272390840638e-24,  1.068362117210145e+00, -5.578789707959671e-03,  6.343044165473863e-06,  9.710558057666474e-08, -5.312237712600346e-10,
 -1.683407664240024e-12,  2.690890477867243e-14, -8.872186981209009e-17, -1.494797538453615e-18,  6.857384642245394e-21,  9.842536434485781e-23,  2.331836253827308e-24,
  1.214140915200943e+00, -5.876055516439145e-03,  1.929586942957378e-08,  1.409286948562907e-07, -3.398659441089261e-10, -5.472018274570397e-12,  3.150657610518718e-14,
  1.376239160517905e-16, -3.093216979132979e-18, -3.056198800741757e-21,  2.677367469630391e-22,  2.965547246217756e-24,  1.370114217004366e+00, -5.942717660768618e-03,
 -9.402232158613308e-06,  1.714810359279893e-07,  2.754457850136219e-10, -9.882797708266685e-12, -5.503450263396953e-15,  6.113111549179896e-16, -1.716400561254195e-18,
 -5.088584776709432e-20,  3.047531054325515e-22,  7.975106473464166e-24,  1.534244074850496e+00, -5.619172236350248e-03, -2.181745745846412e-05,  1.480754706493082e-07,
  1.450784290123630e-09, -8.401186324278405e-12, -1.272133035183709e-13,  5.119858876001048e-16,  1.089379921768554e-17, -5.076662797599317e-20, -1.069469478679292e-21,
  9.613447480616564e-24,  1.700904567846755e+00, -4.674324445521851e-03, -3.417507806154432e-05,  3.084478889329884e-10,  2.401280485053009e-09,  1.327016873798999e-11,
 -1.719807818012101e-13, -2.521120743659477e-15,  4.625555346644372e-18,  3.247208190938019e-19,  1.290854840133744e-21, -3.031202320072188e-23,  1.856043774506450e+00,
 -2.911606710686079e-03, -3.570737489252817e-05, -2.593553397045782e-07,  3.198478697693354e-11,  2.906724559721119e-11,  3.627611857420665e-13,  5.783169553214702e-16,
 -4.813938033270155e-17, -7.597134967305500e-19, -2.554016415836086e-21,  9.784006519446732e-23,  1.969018465014138e+00, -7.689520617965103e-04, -1.369382497731450e-05,
 -2.040112851885519e-07, -2.616128972514445e-09, -2.821636638028954e-11, -2.293121414658140e-13, -6.737815281904898e-16,  2.196814175481030e-17,  6.009581618721148e-19,
  9.714486636728181e-21,  1.143339161173679e-22,  8.772601460454043e-04, -5.849550301422764e-06,  2.921376026749953e-08, -1.301241879927166e-10,  5.355715319982546e-13,
 -2.245200305912696e-15,  6.875830137709280e-18, -5.311739103104864e-20, -3.229275124380763e-23,  2.673980375266703e-24,  1.475623510879461e-25,  3.050287471686053e-27,
  7.900144278068504e-03, -5.263346213471369e-05,  2.621802816195383e-07, -1.161918908143331e-09,  4.741591023054982e-12, -1.966000705487497e-14,  5.844812372224516e-17,
 -4.594702021720575e-19, -3.970691139459453e-22,  2.464825088501549e-23,  1.329527372634685e-24,  2.755046232921085e-26,  2.197161674079457e-02, -1.461323473644326e-04,
  7.240945684554301e-07, -3.175941727916426e-09,  1.273208363375365e-11, -5.157410066877510e-14,  1.434460060071794e-16, -1.175360221169788e-18, -1.673526316874301e-21,
  7.154316812055467e-23,  3.702609852837072e-24,  7.707065848604878e-26,  4.314351234726356e-02, -2.861968897041397e-04,  1.406658892611119e-06, -6.070593741247159e-09,
  2.365158469444719e-11, -9.216460879104482e-14,  2.264488823071359e-16, -2.018725269912252e-18, -4.853256254113519e-21,  1.484762761997276e-22,  7.291485493461354e-24,
  1.526417980889937e-25,  7.149465888501265e-02, -4.725731219823014e-04,  2.296750920828186e-06, -9.687152191218730e-09,  3.618651531081958e-11, -1.327406145344745e-13,
  2.567847281466621e-16, -2.747619444428206e-18, -1.115626848471958e-20,  2.611579032441108e-22,  1.214889741922934e-23,  2.557962842751718e-25,  1.071321933845677e-01,
 -7.048622895575778e-04,  3.375538708317588e-06, -1.380172744192361e-08,  4.853070588692949e-11, -1.618667977066068e-13,  1.723163039464391e-16, -3.104058737941050e-18,
 -2.167844275638446e-20,  4.134900894641863e-22,  1.837359022738735e-23,  3.885771037504024e-25,  1.501933558656676e-01, -9.824596426320853e-04,  4.617165837199727e-06,
 -1.811377265280511e-08,  5.834427463327715e-11, -1.656716345935568e-13, -9.392610069228750e-17, -2.883897296264993e-18, -3.687517184310522e-20,  6.044283311732316e-22,
  2.613132724026307e-23,  5.536046571322609e-25,  2.008477835822269e-01, -1.304463792791244e-03,  5.986866289225648e-06, -2.223049011091902e-08,  6.271383455165762e-11,
 -1.285192026518775e-13, -6.024927103572079e-16, -2.043400708479721e-18, -5.586303758507607e-20,  8.245117276237808e-22,  3.567333825144427e-23,  7.542728477384825e-25,
  2.593003154522033e-01, -1.669543432440228e-03,  7.438297217661474e-06, -2.564637961534030e-08,  5.813078380534229e-11, -3.435943950767512e-14, -1.388852205468805e-15,
 -8.555673462060947e-19, -7.556891748255256e-20,  1.053237387953908e-21,  4.734002067136917e-23,  9.951949217031198e-25,  3.257942768843169e-01, -2.075740516364736e-03,
  8.909772969925631e-06, -2.771727657050531e-08,  4.052199356486234e-11,  1.306924041321900e-13, -2.433098443290228e-15, -1.275398077906045e-19, -8.989614783898081e-20,
  1.260118264533995e-21,  6.152645307006131e-23,  1.283076544274886e-24,  4.006151224600326e-01, -2.520176366717740e-03,  1.031892830854742e-05, -2.762887877202747e-08,
  5.402244955230466e-12,  3.735881231549250e-13, -3.612073120442148e-15, -1.475032300966543e-18, -8.943132666471008e-20,  1.415562848757243e-21,  7.857056763016620e-23,
  1.628204129797262e-24,  4.840941118337738e-01, -2.998605833698165e-03,  1.155510977564276e-05, -2.436181251926092e-08, -5.171203209067993e-11,  6.857385380481011e-13,
 -4.626806125742409e-15, -7.594900307974563e-18, -6.303772694149831e-20,  1.523544034772381e-21,  9.851543877386017e-23,  2.046501879203073e-24,  5.766112642441613e-01,
 -3.504727652015920e-03,  1.246846794814278e-05, -1.666082113935902e-08, -1.343466246527507e-10,  1.027795641793780e-12, -4.901129899645378e-15, -2.231706793103878e-17,
 -4.454038966037531e-21,  1.695902103415857e-21,  1.207454539099332e-22,  2.561047800895794e-24,  6.785959209450786e-01, -4.029093196043332e-03,  1.285430358030198e-05,
 -3.029818620109696e-09, -2.430035989864624e-10,  1.303499048973345e-12, -3.466190172707902e-15, -4.979148741634486e-17,  6.959349405535978e-20,  2.288759762433702e-21,
  1.437865683388836e-22,  3.198674856572868e-24,  7.905212591497740e-01, -4.557335130520327e-03,  1.243084767278181e-05,  1.818969909999737e-08, -3.708443224300222e-10,
  1.317118321494022e-12,  1.082588591926692e-15, -9.111786462641987e-17,  7.861050367536545e-20,  4.067149276757882e-21,  1.666422685893128e-22,  3.970112453271917e-24,
  9.128846693514464e-01, -5.067211343592408e-03,  1.080900521566132e-05,  4.850881648634681e-08, -4.948815501842356e-10,  7.131441150526171e-13,  1.023437970412452e-14,
 -1.344651271100833e-16, -1.933004721097241e-19,  8.067380791048731e-21,  1.960704056629963e-22,  4.818468346753078e-24,  1.046155620027202e+00, -5.523531115018607e-03,
  7.456313729576653e-06,  8.837080557766930e-08, -5.586618578157658e-10, -1.072548531131314e-12,  2.379896036573788e-14, -1.315945774638736e-16, -1.144556810740192e-18,
  1.371944402199023e-20,  2.685491469721029e-22,  5.598370810448799e-24,  1.190647571318653e+00, -5.869237060526257e-03,  1.674337722967005e-06,  1.346575098294072e-07,
 -4.414905453620597e-10, -4.680824332957807e-12,  3.397422656013764e-14,  3.925793388634338e-17, -2.970472088028188e-18,  1.122835797846107e-20,  4.736455241392656e-22,
  6.681203738110263e-24,  1.346206029147411e+00, -6.009644547170124e-03, -7.324547237928023e-06,  1.743054316660203e-07,  7.781656177153860e-11, -9.817276946557678e-12,
  1.058995981147177e-14,  5.301749206925680e-16, -3.235057249261959e-18, -3.063697114032026e-20,  7.366323482272035e-22,  1.193958340379525e-23,  1.511430099261930e+00,
 -5.786223480660838e-03, -1.990734367964733e-05,  1.697835018084007e-07,  1.253585974667850e-09, -1.124484577746221e-11, -1.083250316487748e-13,  8.241345392621664e-16,
  8.431393299769808e-18, -8.140463068696284e-20, -3.682195048451683e-22,  2.250182576821223e-23,  1.681661438964207e+00, -4.947038520034317e-03, -3.393288644280947e-05,
  4.060434085873947e-08,  2.619823930926540e-09,  8.323350084273804e-12, -2.386872394338761e-13, -2.178834037814404e-15,  1.690556739092645e-17,  3.479513182084021e-19,
 -1.406960442696459e-22, -3.174298933337791e-23,  1.843806393080776e+00, -3.209658797270963e-03, -3.879584495668967e-05, -2.537177381054149e-07,  7.006953364160291e-10,
  3.776802085902166e-11,  3.531927573993996e-13, -1.409293703577590e-15, -7.602364720123644e-17, -7.461608687655434e-19,  3.999541931276892e-21,  2.026103100113838e-22,
  1.965706987092513e+00, -8.890516470589071e-04, -1.641271366759802e-05, -2.506876912890392e-07, -3.236513391480475e-09, -3.384388277979241e-11, -2.344886230886236e-13,
  4.609185425203052e-16,  5.192007743702261e-17,  1.102158432792400e-18,  1.562044928465319e-20,  1.514470303313256e-22,  8.543196767961065e-04, -5.621943861815881e-06,
  2.770223070661390e-08, -1.219058156312574e-10,  4.921971997884902e-13, -2.098007842004118e-15,  5.398343990067623e-18, -5.117751523890239e-20,  2.073202829874992e-22,
  1.178152887816181e-23,  3.202980308308129e-25,  4.740466589662379e-27,  7.693718790168054e-03, -5.059053168640060e-05,  2.486797067574564e-07, -1.089127221935100e-09,
  4.361373952859000e-12, -1.841181908046561e-14,  4.562676868842828e-17, -4.450610982903828e-19,  1.782646149660174e-21,  1.067760075238549e-22,  2.889573827434231e-24,
  4.281175688729767e-26,  2.139843628008918e-02, -1.404886501261931e-04,  6.871720840126043e-07, -2.980304448684553e-09,  1.173234606226101e-11, -4.852878842210967e-14,
  1.104194695780481e-16, -1.151696202601723e-18,  4.505309863705908e-21,  3.006166467878091e-22,  8.066230997884601e-24,  1.197441582628403e-25,  4.202077886541422e-02,
 -2.752287120999315e-04,  1.336022394637095e-06, -5.706638882419015e-09,  2.185800050370721e-11, -8.741837106127267e-14,  1.690389781766863e-16, -2.017514441719736e-18,
  7.598205375936046e-21,  6.004859895098495e-22,  1.593300492581575e-23,  2.371324849629487e-25,  6.964039182043899e-02, -4.546544549112545e-04,  2.183892402956255e-06,
 -9.129098331589229e-09,  3.358694223898908e-11, -1.275286883549744e-13,  1.770758427870501e-16, -2.835765593513738e-18,  1.010361760224785e-20,  1.015826735576833e-21,
  2.663044935723339e-23,  3.974144425445025e-25,  1.043657222274490e-01, -6.785075071855707e-04,  3.214470738917642e-06, -1.305094086287089e-08,  4.532736043180276e-11,
 -1.588328320903718e-13,  7.915311017616061e-17, -3.380324236274698e-18,  1.116253076029375e-20,  1.556686952426432e-21,  4.037682935665076e-23,  6.039495027486845e-25,
  1.463360373728295e-01, -9.463761601406563e-04,  4.405291795641092e-06, -1.720692371515245e-08,  5.500118556778863e-11, -1.689995880988822e-13, -1.861819237431455e-16,
 -3.460680639323289e-18,  1.043408839255650e-20,  2.231507656202624e-21,  5.749405229405389e-23,  8.611748549123543e-25,  1.957240525724377e-01, -1.257619068403056e-03,
  5.726033507494548e-06, -2.124844010681056e-08,  5.999333168738652e-11, -1.438285873544664e-13, -6.778946173943033e-16, -3.008005264674826e-18,  8.684634677944462e-21,
  3.044593385470877e-21,  7.843700660610621e-23,  1.174905061831169e-24,  2.527392275915463e-01, -1.611252333398384e-03,  7.136092640963372e-06, -2.472360811423378e-08,
  5.710712147100017e-11, -6.820220804383960e-14, -1.437810497107684e-15, -2.205685049477239e-18,  8.551766377375137e-21,  3.994059079999146e-21,  1.038193305019103e-22,
  1.552891927498441e-24,  3.176317804697117e-01, -2.005781561886561e-03,  8.581131726196641e-06, -2.705119298480090e-08,  4.255017802786397e-11,  7.199200269608745e-14,
 -2.466031667007331e-15, -1.679631675698453e-18,  1.540101603045113e-20,  5.072314485876198e-21,  1.344202376197334e-22,  2.005833267216689e-24,  3.906974228357865e-01,
 -2.438949119857842e-03,  9.988131638990544e-06, -2.748739791122217e-08,  1.200238408947401e-11,  2.861519304336024e-13, -3.680558598797489e-15, -2.757791203390304e-18,
  3.794659069344355e-20,  6.273847689363557e-21,  1.711432525479527e-22,  2.549092640067313e-24,  4.722827002246086e-01, -2.907347385414844e-03,  1.125823650873153e-05,
 -2.508559567308337e-08, -3.912576880012200e-11,  5.719979854642869e-13, -4.852911484616274e-15, -7.776532790901172e-18,  8.768636833138842e-20,  7.620378376995470e-21,
  2.148825303380343e-22,  3.205353183848137e-24,  5.627905333178719e-01, -3.405814650452697e-03,  1.225629788237033e-05, -1.865252255659516e-08, -1.150173015670640e-10,
  9.027495714726241e-13, -5.510771778667946e-15, -2.030358276189854e-17,  1.747371456214385e-19,  9.222482216976340e-21,  2.662654788612553e-22,  4.007872158578960e-24,
  6.626848960109719e-01, -3.926468346050826e-03,  1.279546179828947e-05, -6.714304332812943e-09, -2.178766388330624e-10,  1.203955441979545e-12, -4.807116020669637e-15,
 -4.482774502116422e-17,  2.944667545759747e-19,  1.140646124490909e-20,  3.254094142064467e-22,  5.001753584806681e-24,  7.724920548492101e-01, -4.457114106323652e-03,
  1.261439452495665e-05,  1.246748049639159e-08, -3.444465498846221e-10,  1.312959611012124e-12, -1.400127815450453e-15, -8.458999627588347e-17,  3.934186069939027e-19,
  1.491792682189776e-20,  3.926074703563563e-22,  6.234215963994901e-24,  8.927922662266335e-01, -4.978544322165321e-03,  1.134411277057450e-05,  4.071687174544009e-08,
 -4.784696242892453e-10,  9.132236854861484e-13,  6.439871780250373e-15, -1.340226584484832e-16,  2.974381816396097e-19,  2.103257833787480e-20,  4.735537731531316e-22,
  7.714133165971860e-24,  1.024187296338550e+00, -5.459792197687842e-03,  8.462520915069029e-06,  7.929032136634264e-08, -5.747186753175055e-10, -5.491843085692441e-13,
  1.969370597455375e-14, -1.576949697413658e-16, -3.875863512166717e-19,  3.052372586469108e-20,  5.993304884573931e-22,  9.349364988972021e-24,  1.167207467902047e+00,
 -5.849505709630868e-03,  3.244899480876788e-06,  1.268892182798150e-07, -5.269175815388570e-10, -3.862473487472646e-12,  3.383324533368002e-14, -4.501645679263257e-17,
 -2.141933820220318e-18,  3.742301210383205e-20,  8.698960487012920e-22,  1.126286462039075e-23,  1.322063515765973e+00, -6.059867906626839e-03, -5.231833078580151e-06,
  1.739983676127654e-07, -1.148489043873617e-10, -9.397465870084695e-12,  2.386666251091256e-14,  4.158065707985990e-16, -3.667900556929684e-18,  1.077556007543612e-20,
  1.369304591546304e-21,  1.671589885709462e-23,  1.487980049122849e+00, -5.937009615464147e-03, -1.775745388663878e-05,  1.879088052433661e-07,  1.004706060663778e-09,
 -1.354000664147205e-11, -8.192047104931304e-14,  1.046375539838948e-15,  5.509369920562014e-18, -7.251547103932159e-20,  9.020704199989971e-22,  3.465581517345690e-23,
  1.661334464656354e+00, -5.215829479773498e-03, -3.318969976551552e-05,  8.352251624881248e-08,  2.724429097302569e-09,  1.935370069359947e-12, -2.902603504615628e-13,
 -1.441042150647065e-15,  2.902789333970619e-17,  3.184158833204341e-19, -1.199725660277294e-21, -1.313438001352359e-23,  1.830328090241331e+00, -3.531953107338857e-03,
 -4.174682151108528e-05, -2.360218316749883e-07,  1.536105194381580e-09,  4.547297272505225e-11,  2.759659976070067e-13, -4.221674745170945e-15, -9.757850694595992e-17,
 -3.777784658222219e-19,  1.508914586675658e-20,  2.930922787664649e-22,  1.961867811719258e+00, -1.033320089241137e-03, -1.975497745569419e-05, -3.081844198575439e-07,
 -3.967480335202249e-09, -3.908769580666813e-11, -1.914210670395967e-13,  2.891114154085746e-15,  1.044885624753576e-16,  1.863464873047844e-18,  2.238975791366938e-20,
  1.422120373297236e-22,  8.322660570522286e-04, -5.406046763255817e-06,  2.628524868174740e-08, -1.143597700018265e-10,  4.514224679560842e-13, -1.984402778741575e-15,
  4.142104246277236e-18, -3.485734549361178e-20,  9.150693731898261e-22,  2.903430561635357e-23,  5.447457262934156e-25,  5.020045063484365e-27,  7.495254403394071e-03,
 -4.865221346507384e-05,  2.360169017393176e-07, -1.022235699382840e-09,  4.003130191882025e-12, -1.745542715162102e-14,  3.472281718072049e-17, -3.003490884138290e-19,
  8.185723696749737e-21,  2.624653627899410e-22,  4.916640960462476e-24,  4.534059688743180e-26,  2.084725433887375e-02, -1.351312097505102e-04,  6.525031443370349e-07,
 -2.800218049890573e-09,  1.078579450694004e-11, -4.623690917063069e-14,  8.232340683455348e-17, -7.613120872045762e-19,  2.247399679025203e-20,  7.354467047381123e-22,
  1.373627034898919e-23,  1.268414593458662e-25,  4.094081489075072e-02, -2.648086377691948e-04,  1.269584063355740e-06, -5.370695796215576e-09,  2.014587117143724e-11,
 -8.398694902141079e-14,  1.202024320559344e-16, -1.284125254047126e-18,  4.333884530533701e-20,  1.459975414192651e-21,  2.716285173536144e-23,  2.512695053458551e-25,
  6.785603511131794e-02, -4.376125692322668e-04,  2.077484077387692e-06, -8.611906766358946e-09,  3.107279695490294e-11, -1.241531316150066e-13,  1.093705032990463e-16,
 -1.685940089587397e-18,  7.029117692014603e-20,  2.453426809774173e-21,  4.545452758112402e-23,  4.213204431384546e-25,  1.017021489470858e-01, -6.534060983030781e-04,
  3.062106295345316e-06, -1.235104380484947e-08,  4.216250717744120e-11, -1.579643217133971e-13,  4.654920260534195e-19, -1.760341272525172e-18,  1.030288896539297e-19,
  3.737779794775391e-21,  6.899273676584186e-23,  6.407516177962565e-25,  1.426197304543962e-01, -9.119450564050727e-04,  4.203976412745454e-06, -1.635421860684049e-08,
  5.156923521209157e-11, -1.745010117794006e-13, -2.627180077716679e-16, -1.319974315211035e-18,  1.417971939536908e-19,  5.338598090856736e-21,  9.831627842492524e-23,
  9.145785829915540e-25,  1.907836006953052e-01, -1.212814631779242e-03,  5.476713722174384e-06, -2.031246988956369e-08,  5.694792232718558e-11, -1.609518218319119e-13,
 -7.368234162530036e-16, -2.649639347364120e-19,  1.879111116521481e-19,  7.283960151304477e-21,  1.341652632925155e-22,  1.249415810382903e-24,  2.464065385229882e-01,
 -1.555334908266745e-03,  6.844840488782167e-06, -2.382269986077346e-08,  5.539383928919271e-11, -1.032548991791164e-13, -1.467601807859619e-15,  1.310065462225188e-18,
  2.444703397195834e-19,  9.603952992791089e-21,  1.775329663962212e-22,  1.654069305521250e-24,  3.097439128962589e-01, -1.938419303222803e-03,  8.260639289912054e-06,
 -2.636209954934010e-08,  4.339551425127615e-11,  1.250884037771036e-14, -2.470269649142283e-15,  2.953515745688739e-18,  3.172492471916173e-19,  1.233234320227887e-20,
  2.297185286508828e-22,  2.140565388152408e-24,  3.810993525632884e-01, -2.360359793537424e-03,  9.659608347582921e-06, -2.725439550996064e-08,  1.683761885199172e-11,
  1.972906918439554e-13, -3.696078041768262e-15,  3.621484773820289e-18,  4.155867681548896e-19,  1.551426466730757e-20,  2.923637657281206e-22,  2.725906017004545e-24,
  4.608315220316111e-01, -2.818495416154498e-03,  1.095381012663677e-05, -2.562648093635753e-08, -2.886519189226148e-11,  4.535521565248897e-13, -4.976635948387904e-15,
  1.366989796539719e-18,  5.526599118261615e-19,  1.922847275995998e-20,  3.674434883707679e-22,  3.434926092915619e-24,  5.493619154730237e-01, -3.308689548587783e-03,
  1.202199799734888e-05, -2.035572269879820e-08, -9.832608044851715e-11,  7.646900343099159e-13, -5.934338613496297e-15, -6.982426643440709e-18,  7.433901322743052e-19,
  2.364189946665027e-20,  4.571761154234753e-22,  4.304444066916520e-24,  6.471831584227401e-01, -3.824484413452960e-03,  1.269474718690713e-05, -1.001436793777722e-08,
 -1.950454314098531e-10,  1.075067641062390e-12, -5.848128172217094e-15, -2.587081377854979e-17,  9.954911381589575e-19,  2.912898484932048e-20,  5.639124260885631e-22,
  5.387563980939974e-24,  7.548662466088651e-01, -4.355692220553473e-03,  1.273179593880740e-05,  7.163811294592017e-09, -3.187053414838322e-10,  1.252975310561549e-12,
 -3.486806596226220e-15, -5.981343694223066e-17,  1.283137775223921e-18,  3.649679720699204e-20,  6.905859036641059e-22,  6.752017617981044e-24,  8.730625073834564e-01,
 -4.885965717456559e-03,  1.178740866002144e-05,  3.321462497175901e-08, -4.589544863437247e-10,  1.024671986685434e-12,  2.964405976350970e-15, -1.080349813960872e-16,
  1.482452628567778e-18,  4.727349094436313e-20,  8.444753024984248e-22,  8.453761709205301e-24,  1.002489332355348e+00, -5.388443093841538e-03,  9.358548372509984e-06,
  7.003112198480192e-08, -5.813357895269365e-10, -1.297207906099551e-13,  1.530768818356970e-14, -1.470375532683643e-16,  1.248755505151851e-18,  6.341520670052532e-20,
  1.054102201160692e-21,  1.046230241494369e-23,  1.143870797316933e+00, -5.817604739843465e-03,  4.714578225045023e-06,  1.178841103642659e-07, -5.961829605625688e-10,
 -3.071836269696897e-12,  3.186952627558062e-14, -8.425812172950276e-17, -4.027153827775647e-20,  8.301127511568233e-20,  1.421266922646255e-21,  1.274320317788735e-23,
  1.297753496029193e+00, -6.093415951750140e-03, -3.160969417147298e-06,  1.706920411817267e-07, -2.961927036782531e-10, -8.697444973880310e-12,  3.400833377649309e-14,
  3.167071010558908e-16, -2.108660350533737e-18,  8.106361585777184e-20,  2.152318217968639e-21,  1.753699850618859e-23,  1.463962530328621e+00, -6.069797567883995e-03,
 -1.541535085855862e-05,  2.017211689264792e-07,  7.167120703859296e-10, -1.513668047131887e-11, -5.047857259248461e-14,  1.190994207261613e-15,  3.936295477527932e-18,
 -3.857112585283653e-21,  2.558627131665042e-21,  3.823234686180376e-23,  1.639947506140463e+00, -5.476596529704929e-03, -3.192586574188834e-05,  1.270328434723819e-07,
  2.690791882095894e-09, -5.399861449088107e-12, -3.159517996741719e-13, -3.386128593687576e-16,  3.956769588939294e-17,  2.677264883741622e-19, -1.108585896566967e-21,
  1.741627783648232e-23,  1.815515074671477e+00, -3.876767675568303e-03, -4.440056490508933e-05, -2.038552666802341e-07,  2.500362077418914e-09,  5.031706640270991e-11,
  1.129794151571594e-13, -7.419429278105571e-15, -9.711948169135298e-17,  4.912749902650382e-19,  2.828587252462081e-20,  2.805682425556390e-22,  1.957393426022955e+00,
 -1.207292783502450e-03, -2.386058162143311e-05, -3.781325718722573e-07, -4.786379134556146e-09, -4.226411476313356e-11, -5.227825380491064e-14,  7.491582887255604e-15,
  1.889404749794261e-16,  2.852535429594216e-18,  2.588129912162582e-20, -2.361272028138961e-23,  8.110539120476167e-04, -5.201134238408928e-06,  2.495497505578698e-08,
 -1.074493720409860e-10,  4.126712403043258e-13, -1.892269263242756e-15,  3.765486130156248e-18,  1.574691580516942e-20,  2.399312746396078e-21,  5.445049003748976e-23,
  6.952944831670555e-25,  7.207616228022416e-28,  7.304345632626099e-03, -4.681208296299635e-05,  2.241229936739585e-07, -9.609354070347753e-10,  3.661869193285732e-12,
 -1.668321889599645e-14,  3.169227665786522e-17,  1.542789602973337e-19,  2.159711236797203e-20,  4.918883745884146e-22,  6.276754919881497e-24,  6.530393291063403e-27,
  2.031696078353879e-02, -1.300427309375965e-04,  6.199057798641251e-07, -2.634941326587100e-09,  9.879625723681518e-12, -4.440717337273653e-14,  7.586993010812214e-17,
  4.974451156152900e-19,  6.002279002170924e-20,  1.376561885949202e-21,  1.754327945107434e-23,  1.838202163933094e-26,  3.990149308073702e-02, -2.549044056722590e-04,
  1.207014768680428e-06, -5.061651731173762e-09,  1.849311331560291e-11, -8.132027903766854e-14,  1.131753198411034e-16,  1.173031897661622e-18,  1.177985327378940e-19,
  2.728147139657577e-21,  3.471045102509257e-23,  3.674175272053858e-26,  6.613818175896083e-02, -4.213978041804342e-04,  1.977042675309072e-06, -8.134474199188634e-09,
  2.861386787693980e-11, -1.217455429266736e-13,  1.096292099426480e-16,  2.360452967550840e-18,  1.952723957849620e-19,  4.576367055502100e-21,  5.812329211512372e-23,
  6.231534695667727e-26,  9.913659544905516e-02, -6.294908699926629e-04,  2.917837090107093e-06, -1.170172564073840e-08,  3.900186653655653e-11, -1.580274137335589e-13,
  2.165546820788656e-17,  4.272360837970219e-18,  2.932440903210258e-19,  6.961276596552319e-21,  8.828421678295147e-23,  9.606670880762594e-26,  1.390379903808270e-01,
 -8.790844882477027e-04,  4.012560149055378e-06, -1.555737437565242e-08,  4.801667720633417e-11, -1.805304666355178e-13, -2.014251679250709e-16,  7.123241536480227e-18,
  4.133150576091039e-19,  9.933755942504761e-21,  1.258935071045662e-22,  1.392659894334563e-25,  1.860184473776804e-01, -1.169960681561727e-03,  5.238321773578423e-06,
 -1.942800305265472e-08,  5.355613017660179e-11, -1.777632988128818e-13, -6.126746735495255e-16,  1.107746665436637e-17,  5.584073994370910e-19,  1.355645989225621e-20,
  1.719047053051200e-22,  1.936013856930217e-25,  2.402929268613722e-01, -1.501704776064203e-03,  6.564211633954797e-06, -2.295479999372510e-08,  5.298560163220269e-11,
 -1.367813757932915e-13, -1.258883294871279e-15,  1.616530526035254e-17,  7.335036410486915e-19,  1.790584546091373e-20,  2.275969420609380e-22,  2.614202359627589e-25,
  3.021204190553166e-01, -1.873587767773000e-03,  7.948458025401438e-06, -2.566893647153979e-08,  4.306743929673315e-11, -4.416015916770342e-14, -2.165065406723739e-15,
  2.215038285046345e-17,  9.466449460653036e-19,  2.307675863548658e-20,  2.946641842637079e-22,  3.462201524725526e-25,  3.718104026105820e-01, -2.284386289033735e-03,
  9.334286787888245e-06, -2.695817782525592e-08,  1.991485553401821e-11,  1.119066272569097e-13, -3.307174858251833e-15,  2.832768377099699e-17,  1.210141693217097e-18,
  2.919299248467382e-20,  3.753161801101375e-22,  4.535969473376617e-25,  4.497308434883317e-01, -2.732102210079011e-03,  1.064379976219223e-05, -2.602218698493699e-08,
 -2.097200700297101e-11,  3.373185471354017e-13, -4.564886122133689e-15,  3.323450729756533e-17,  1.541669917954503e-18,  3.643147337361467e-20,  4.723765460989946e-22,
  5.929528889638630e-25,  5.363179259234745e-01, -3.213516272033878e-03,  1.176876960942236e-05, -2.181433468907529e-08, -8.445463988510383e-11,  6.235291655880188e-13,
 -5.641695322889719e-15,  3.429216156555919e-17,  1.964120061333074e-18,  4.507671270314887e-20,  5.893569091411023e-22,  7.802266417871125e-25,  6.320875028254123e-01,
 -3.723458594330252e-03,  1.255653476566862e-05, -1.297087748042704e-08, -1.749829868770993e-10,  9.307550937191376e-13, -5.935340790568148e-15,  2.754163534079661e-17,
  2.500907725470999e-18,  5.563956422915912e-20,  7.305318404372132e-22,  1.041089421548108e-24,  7.376476109992572e-01, -4.253578805399412e-03,  1.278797687999136e-05,
  2.259986664692963e-09, -2.945884563953298e-10,  1.155252703389595e-12, -4.348059138840704e-15,  8.134454940166009e-18,  3.158064040158706e-18,  6.909992143250052e-20,
  9.013753774506731e-22,  1.410273306071190e-24,  8.537095932045747e-01, -4.790195403819229e-03,  1.214261080494184e-05,  2.603825680663241e-08, -4.379593312588131e-10,
  1.066701183430904e-12,  9.098406451867456e-16, -2.617684659580729e-17,  3.872561395311330e-18,  8.732505708893418e-20,  1.111330666489742e-21,  1.910158938436329e-24,
  9.810903957817119e-01, -5.310371410346306e-03,  1.014308908035432e-05,  6.072766673377229e-08, -5.805564248944682e-10,  1.951961714588692e-13,  1.215620400018065e-14,
 -6.157964310786172e-17,  4.390371040467386e-18,  1.133849849606274e-19,  1.387273959154061e-21,  2.467069512399797e-24,  1.120684536046732e+00, -5.774396241561111e-03,
  6.070059077454748e-06,  1.078944817180223e-07, -6.501496197948428e-10, -2.332244622848399e-12,  3.002571377716184e-14, -2.574583696130777e-17,  4.092830246736676e-18,
  1.493543811635990e-19,  1.824944936251705e-21,  2.804723425057492e-24,  1.273342098519657e+00, -6.110603970973356e-03, -1.146688089375593e-06,  1.646086321134049e-07,
 -4.612869973276961e-10, -7.779130438312843e-12,  4.249679935102268e-14,  3.139240298494938e-16,  2.524884313232803e-18,  1.800787860923527e-19,  2.699903141046459e-21,
  3.748631525609427e-24,  1.439452269666899e+00, -6.183266191021103e-03, -1.293606429509046e-05,  2.107124693816021e-07,  4.046406220481018e-10, -1.593310191660872e-11,
 -1.522903858440758e-14,  1.337608900904463e-15,  6.017092708229155e-18,  1.286394219855967e-19,  3.923858142483712e-21,  1.834457828914425e-23,  1.617540979730178e+00,
 -5.725184873455810e-03, -3.014805645637794e-05,  1.688089965254752e-07,  2.506974508695512e-09, -1.294475685940413e-11, -3.063079055966886e-13,  1.075125833800642e-15,
  4.865383402874114e-17,  2.449875457162709e-19,  6.090232324014040e-23,  2.885197763334178e-23,  1.799283163653645e+00, -4.241000085380224e-03, -4.657331444092277e-05,
 -1.557280784391778e-07,  3.515275812653892e-09,  5.020916362550079e-11, -1.339304639763367e-13, -1.000426013334420e-14, -5.649245270807981e-17,  1.822224610337336e-18,
  3.664014641314278e-20,  5.698398367008433e-23,  1.952151824779048e+00, -1.417693970963723e-03, -2.888555276784019e-05, -4.614601715004582e-07, -5.623258213637179e-09,
 -4.021655018635264e-11,  2.589501267307183e-13,  1.537184527574259e-14,  3.089639456412093e-16,  3.744811275365976e-18,  1.482377268894064e-20, -5.656394261519637e-22,
  };
  constexpr double w[8832] = {  1.334663456484316e-01, -7.805615800915129e-04,  4.918753362310107e-06, -3.247049218770353e-08,  2.193701966566969e-10,
 -1.494224687957581e-12,  1.017488284782228e-14, -6.897799299431677e-17,  4.646662541538394e-19, -3.108600569579059e-21,  2.065214844241805e-23, -1.362839704994196e-25,
  1.317379343473204e-01, -1.326367052776038e-03,  1.511272309922405e-05, -1.649277218719746e-07,  1.706358500156431e-09, -1.689928501193165e-11,  1.615618617120367e-13,
 -1.499858667960557e-15,  1.357792126464576e-17, -1.202414468384216e-19,  1.044177080256813e-21, -8.908660883412219e-24,  1.283741257210984e-01, -2.367149731726697e-03,
  4.102854442596425e-05, -6.248239939418178e-07,  8.693308120254418e-09, -1.130416487461788e-10,  1.392719449320505e-12, -1.640789566087685e-14,  1.860695840346121e-16,
 -2.041199809532887e-18,  2.174472746365290e-20, -2.256140659593881e-22,  1.235502446119826e-01, -3.808129950133526e-03,  9.212384708814877e-05, -1.864130671760009e-06,
  3.347550632760374e-08, -5.498522607550087e-10,  8.414729903865764e-12, -1.214747363060782e-13,  1.668852927039621e-15, -2.196316664532097e-17,  2.783049690996401e-19,
 -3.408651803454618e-21,  1.175044622799110e-01, -5.522967598219096e-03,  1.790319421768115e-04, -4.665538797426365e-06,  1.050843745428806e-07, -2.123537149594769e-09,
  3.938653349870991e-11, -6.807621181029383e-13,  1.108370773537851e-14, -1.713549928601002e-16,  2.531093430678729e-18, -3.588876038034457e-20,  1.105129616076065e-01,
 -7.369306995664132e-03,  3.103925506012758e-04, -1.015327735024292e-05,  2.804508883521825e-07, -6.832231404631001e-09,  1.507316553220582e-10, -3.064996095763215e-12,
  5.816532441602273e-14, -1.039768356254658e-15,  1.763381968314671e-17, -2.852615806703384e-19,  1.028637494674476e-01, -9.204723682602325e-03,  4.900751470232508e-04,
 -1.968065870027836e-05,  6.541151041467986e-07, -1.888772018637520e-08,  4.880133008620556e-10, -1.150686592263195e-11,  2.510873154039703e-13, -5.123257767353809e-15,
  9.853571177533534e-17, -1.797166549022258e-18,  9.483286585532077e-02, -1.090057737162738e-02,  7.154367245914261e-04, -3.458039820627304e-05,  1.359911702671131e-06,
 -4.585499201288263e-08,  1.368867865696852e-09, -3.696023908526084e-11,  9.164844935576445e-13, -2.110870792554265e-14,  4.555582492505734e-16, -9.273148762420343e-18,
  8.666575961769350e-02, -1.235203067416929e-02,  9.769335356237486e-04, -5.582088376351838e-05,  2.558074413691838e-06, -9.937493805608269e-08,  3.385766718421992e-09,
 -1.035073287828120e-10,  2.886022065725645e-12, -7.428973822812594e-14,  1.782140235329201e-15, -4.012291581020344e-17,  7.856525382833825e-02, -1.348348159420166e-02,
  1.259045235431474e-03, -8.365441786437567e-05,  4.404777552134281e-06, -1.946963259814085e-07,  7.485691363257536e-09, -2.564257684628996e-10,  7.961761601503884e-12,
 -2.269663782496126e-13,  5.999911096555957e-15, -1.481758150734274e-16,  7.068618553169438e-02, -1.424959902435932e-02,  1.542179675605718e-03, -1.173552134446436e-04,
  7.007451972403725e-06, -3.483333370233041e-07,  1.495406480542678e-08, -5.684094123746682e-10,  1.947481901531374e-11, -6.095830362248864e-13,  1.761452327636129e-14,
 -4.735207025020960e-16,  6.313576498797716e-02, -1.463283803025430e-02,  1.805073442017405e-03, -1.551232723138023e-04,  1.037577032592691e-05, -5.736859552513442e-07,
  2.722504307457707e-08, -1.137671067825922e-09,  4.264215511106908e-11, -1.453709812784885e-12,  4.556537687477921e-14, -1.323631048534934e-15,  5.597810248311455e-02,
 -1.463865567868681e-02,  2.027197251323552e-03, -1.941860714804892e-04,  1.438209721111572e-05, -8.752985643294633e-07,  4.548014438681057e-08, -2.070922750168485e-09,
  8.421669160418209e-11, -3.102643119144765e-12,  1.047148740265151e-13, -3.264096922005707e-15,  4.924119378243307e-02, -1.428966959276358e-02,  2.190781523872995e-03,
 -2.310805245998460e-04,  1.874462841389566e-05, -1.243261342393277e-06,  7.008261483172994e-08, -3.447761803626945e-09,  1.509072602933975e-10, -5.963039084988831e-12,
  2.151631952540750e-13, -7.148311041039235e-15,  4.292483432770721e-02, -1.361979352172729e-02,  2.282239196539358e-03, -2.620587931420409e-04,  2.304146727348451e-05,
 -1.649688989711459e-06,  9.999744538885413e-08, -5.271229701837126e-09,  2.464068693506112e-10, -1.036700712160690e-11,  3.971584739508691e-13, -1.397059781315725e-14,
  3.700830166023452e-02, -1.266906406639414e-02,  2.292925456503714e-03, -2.835421777842253e-04,  2.675626260222244e-05, -2.048983520023987e-06,  1.324179462076128e-07,
 -7.419579206575585e-09,  3.676231891920542e-10, -1.635080937827982e-11,  6.605584507483132e-13, -2.444405489817294e-14,  3.145706924809713e-02, -1.147954246029808e-02,
  2.219300139303377e-03, -2.925483688019243e-04,  2.934829104398806e-05, -2.382707308471157e-06,  1.628140751951536e-07, -9.621309562077379e-09,  5.015646290611587e-10,
 -2.341812443259414e-11,  9.910360504202854e-13, -3.833585035780109e-14,  2.622819609273543e-02, -1.009240193201888e-02,  2.062632383966257e-03, -2.870335152910722e-04,
  3.033424268684957e-05, -2.588627273144522e-06,  1.855189455513597e-07, -1.147399954506511e-08,  6.247740661376133e-10, -3.041164146539279e-11,  1.339333014125664e-12,
 -5.381937003170791e-14,  2.127432541754001e-02, -8.546123840173938e-03,  1.828411169129636e-03, -2.661140303361176e-04,  2.936669053848675e-05, -2.612252998245666e-06,
  1.948027839557486e-07, -1.251534714965053e-08,  7.067451699693737e-10, -3.562172692707390e-11,  1.622015818415132e-12, -6.728997832192736e-14,  1.654641353710849e-02,
 -6.875625057019268e-03,  1.525612623918472e-03, -2.301565340444941e-04,  2.629535515976818e-05, -2.418371597753174e-06,  1.862058813593644e-07, -1.233532680527474e-08,
  7.173310607237839e-10, -3.718635314855831e-11,  1.739491147334157e-12, -7.404528463674585e-14,  1.199542596987383e-02, -5.112114422762343e-03,  1.165943002465030e-03,
 -1.807432642627352e-04,  2.120102552447973e-05, -1.999919039061902e-06,  1.577811471076478e-07, -1.069920326301634e-08,  6.362667445159004e-10, -3.369904349207579e-11,
  1.609099520991230e-12, -6.985393532457587e-14,  7.573467802615486e-03, -3.283574961625593e-03,  7.631554320735512e-04, -1.205353664552448e-04,  1.439747561111040e-05,
 -1.382079494442675e-06,  1.108843118350930e-07, -7.641285435600830e-09,  4.614955361447997e-10, -2.480746717908655e-11,  1.201485111536509e-12, -5.287199081042203e-14,
  3.239007394159592e-03, -1.417646514448382e-03,  3.329335376462291e-04, -5.313131145528466e-05,  6.410409702218215e-06, -6.213558703798244e-07,  5.031796775690481e-08,
 -3.498672947148852e-09,  2.131230993646107e-10, -1.155098143575374e-11,  5.638730826725664e-13, -2.500142782065775e-14,  1.304204129729376e-01, -7.427126562863063e-04,
  4.549222061081384e-06, -2.918700465571458e-08,  1.917794974410915e-10, -1.271621853507091e-12,  8.435918069900265e-15, -5.575080797822014e-17,  3.662884564594563e-19,
 -2.390827963923548e-21,  1.550130328618498e-23, -9.985457488752389e-26,  1.266623582162629e-01, -1.212942054752636e-03,  1.328689276770916e-05, -1.401326386693950e-07,
  1.403983730329993e-09, -1.348038447253001e-11,  1.250513033667383e-13, -1.127271113708470e-15,  9.915403697292962e-18, -8.536250470185012e-20,  7.209952777998780e-22,
 -5.985565927926639e-24,  1.195176225490324e-01, -2.066709101596506e-03,  3.429608998919429e-05, -5.021465340931268e-07,  6.732724252983247e-09, -8.451895151722683e-11,
  1.006703739744529e-12, -1.147917549553001e-14,  1.261157968692479e-16, -1.341448287954732e-18,  1.386598794496158e-20, -1.396863515987246e-22,  1.096618684151217e-01,
 -3.152281924581204e-03,  7.263765151727979e-05, -1.406582650843523e-06,  2.425083693855658e-08, -3.833401309656934e-10,  5.655991547418978e-12, -7.883610595701014e-14,
  1.047043016924035e-15, -1.333552754916043e-17,  1.636853783859505e-19, -1.943611992174169e-21,  9.795900315739876e-02, -4.288998548140462e-03,  1.318822920461470e-04,
 -3.278421200225050e-06,  7.070769401836050e-08, -1.371988568709541e-09,  2.448658696847123e-11, -4.079626448379670e-13,  6.411936472717407e-15, -9.581356919322924e-17,
  1.369446520841996e-18, -1.880768218521283e-20,  8.532581532689547e-02, -5.306480155608398e-03,  2.115324293404722e-04, -6.588460397340096e-06,  1.739866204744197e-07,
 -4.064449889832136e-09,  8.618738931829185e-11, -1.687740049697872e-12,  3.089465674235009e-14, -5.334716858735531e-16,  8.750157087756039e-18, -1.370551009039049e-19,
  7.260827213148596e-02, -6.075934061620586e-03,  3.060334947735796e-04, -1.169563645717475e-05,  3.714434509953007e-07, -1.028039386845805e-08,  2.552232175252822e-10,
 -5.794123793121615e-12,  1.219412654614225e-13, -2.403379979078388e-15,  4.470947518065276e-17, -7.896790213654113e-19,  6.049248054335404e-02, -6.526681833130791e-03,
  4.057059919063186e-04, -1.867374243622797e-05,  7.020634868673305e-07, -2.270051170574589e-08,  6.514256808968244e-10, -1.694302399882649e-11,  4.054210635368599e-13,
 -9.024934416309288e-15,  1.885074191184574e-16, -3.718461492619747e-18,  4.946030151622500e-02, -6.646760723723815e-03,  4.990711730361092e-04, -2.720169737280504e-05,
  1.193402725033327e-06, -4.451231292385835e-08,  1.459582042034598e-09, -4.303224922056110e-11,  1.159152788803355e-12, -2.887115455616800e-14,  6.710822199101667e-16,
 -1.465821192751431e-17,  3.978684964663034e-02, -6.471260214315855e-03,  5.755652099663849e-04, -3.657387832803663e-05,  1.847745390791143e-06, -7.857225434900552e-08,
  2.912822264048853e-09, -9.639559299817090e-11,  2.896391660386115e-12, -8.002383277543346e-14,  2.053066676755236e-15, -4.927012336662722e-17,  3.156851811661596e-02,
 -6.064455820767184e-03,  6.276793224986816e-04, -4.583238969260579e-05,  2.633430758921438e-06, -1.262660352510703e-07,  5.239319524655874e-09, -1.928339373253556e-10,
  6.407605643859369e-12, -1.947946105146906e-13,  5.473926923480484e-15, -1.432770317130546e-16,  2.476709977978438e-02, -5.501641085522504e-03,  6.519801303080569e-04,
 -5.397069486904248e-05,  3.485630526802272e-06, -1.864758175219788e-07,  8.578307504805236e-09, -3.480503627923123e-10,  1.268500925111045e-11, -4.210449292331647e-13,
  1.286489638142232e-14, -3.647121865885303e-16,  1.925710695900666e-02, -4.854706912049596e-03,  6.489758989088710e-04, -6.013526514866246e-05,  4.316887170302133e-06,
 -2.551028798072296e-07,  1.289094114796535e-08, -5.716811089891307e-10,  2.267147124355030e-11, -8.154908571026138e-13,  2.690125338838896e-14, -8.204492903687513e-16,
  1.486744317694749e-02, -4.183167096723612e-03,  6.221654114737182e-04, -6.376439429625950e-05,  5.033751494641565e-06, -3.254016485240605e-07,  1.790179443228565e-08,
 -8.605722434682497e-10,  3.684793118405171e-11, -1.425845744932488e-12,  5.042997874321331e-14, -1.643754449512126e-15,  1.141308244122740e-02, -3.530403265726490e-03,
  5.767417876847091e-04, -6.463718505128945e-05,  5.553917048966207e-06, -3.890593550443121e-07,  2.309988882379214e-08, -1.193949321433101e-09,  5.477611897202326e-11,
 -2.263794400111594e-12,  8.526005349651282e-14, -2.950775635846550e-15,  8.716012931593254e-03, -2.923809902747283e-03,  5.183595857656889e-04, -6.284069960378327e-05,
  5.818921162835527e-06, -4.376789163959045e-07,  2.780666527745534e-08, -1.532942579563462e-09,  7.478750969299444e-11, -3.277608111113097e-12,  1.305604541484345e-13,
 -4.766942504251561e-15,  6.616898460839119e-03, -2.377222065159204e-03,  4.522094569416821e-04, -5.868509943423349e-05,  5.799901287685752e-06, -4.642190668526662e-07,
  3.129350165414286e-08, -1.825515912618093e-09,  9.400043504907860e-11, -4.337629851784137e-12,  1.815171967428445e-13, -6.946848275737366e-15,  4.979818906012098e-03,
 -1.894232810462148e-03,  3.824756689902461e-04, -5.260162294153381e-05,  5.496606723572637e-06, -4.640314057203688e-07,  3.291539152143742e-08, -2.015883041205563e-09,
  1.087449194548740e-10, -5.246212492649085e-12,  2.290806755505693e-13, -9.130706687978836e-15,  3.692472611195780e-03, -1.471451499380058e-03,  3.121331804894680e-04,
 -4.505094947674905e-05,  4.931736212298852e-06, -4.353305181364638e-07,  3.222607509832237e-08, -2.055926138236857e-09,  1.153232767976630e-10, -5.775487093867823e-12,
  2.613793185078475e-13, -1.078031795125043e-14,  2.663788051582193e-03, -1.101198945209468e-03,  2.429856255125634e-04, -3.645721776769364e-05,  4.143305832922048e-06,
 -3.791338578085418e-07,  2.905086138301124e-08, -1.915597446098496e-09,  1.109045253548866e-10, -5.724968834898998e-12,  2.667173637227261e-13, -1.130956538376219e-14,
  1.820321338712203e-03, -7.734729998632108e-04,  1.758402930669006e-04, -2.717170939172576e-05,  3.177385201634397e-06, -2.988373899547651e-07,  2.350929396923135e-08,
 -1.589824859275957e-09,  9.429746132677505e-11, -4.981827532360829e-12,  2.373064455111630e-13, -1.027823927399328e-14,  1.102316889426819e-03, -4.772355577941278e-04,
  1.107412769500764e-04, -1.746328367438830e-05,  2.082721093050590e-06, -1.996335533113731e-07,  1.599372675204207e-08, -1.100647205572905e-09,  6.638558609294284e-11,
 -3.563976836330231e-12,  1.724001610195562e-13, -7.577622334414415e-15,  4.604951431811449e-04, -2.014296463696150e-04,  4.727427856584435e-05, -7.539249356687073e-06,
  9.090298042039759e-07, -8.805499428241309e-08,  7.126315558650176e-09, -4.952003359266215e-10,  3.014747347102945e-11, -1.633011039710526e-12,  7.967246390081914e-14,
 -3.530657750533287e-15,  1.275202028703392e-01, -7.076695559355845e-04,  4.216583804894394e-06, -2.631149965259503e-08,  1.682517605184510e-10, -1.086643045516439e-12,
  7.026859459104602e-15, -4.529510711454832e-17,  2.903977008076182e-19, -1.850322091342403e-21,  1.171415162949241e-23, -7.369787439152777e-26,  1.220130435886201e-01,
 -1.113010877222315e-03,  1.173168685939576e-05, -1.196728146715536e-07,  1.162005638198742e-09, -1.082471471744580e-11,  9.750472210208261e-14, -8.540575182318254e-16,
  7.303789722657979e-18, -6.116604197121211e-20,  5.027838208738054e-22, -4.063878444270372e-24,  1.117637865554909e-01, -1.814732565440806e-03,  2.886486289585001e-05,
 -4.067348498803308e-07,  5.260099886538043e-09, -6.380010242087868e-11,  7.352256437606823e-13, -8.120052087440850e-15,  8.648613940098992e-17, -8.925309481418729e-19,
  8.957228654953166e-21, -8.766394113866413e-23,  9.811664309252277e-02, -2.632638679399547e-03,  5.785572820453172e-05, -1.073215939133466e-06,  1.778050889327406e-08,
 -2.707013906914294e-10,  3.853609800793708e-12, -5.189843680522149e-14,  6.667771558308178e-16, -8.223520280926668e-18,  9.783143131317399e-20, -1.126806351934326e-21,
  8.268860758882939e-02, -3.373967627920652e-03,  9.851740524656176e-05, -2.338189826302167e-06,  4.832700373345285e-08, -9.010460504451385e-10,  1.548457572364760e-11,
 -2.488272454249154e-13,  3.777356440255199e-15, -5.458538203375030e-17,  7.552829467885423e-19, -1.005156503975627e-20,  6.704318768635803e-02, -3.888662572702971e-03,
  1.468156234544753e-04, -4.356861165365303e-06,  1.100647984469823e-07, -2.466911365617347e-09,  5.030528453952510e-11, -9.490974348113845e-13,  1.676539806185398e-14,
 -2.797456277407969e-16,  4.439293800736506e-18, -6.734625103689151e-20,  5.243666021467368e-02, -4.101732836350837e-03,  1.955037988267891e-04, -7.112735000227713e-06,
  2.159277270053040e-07, -5.730025189698087e-09,  1.367264903431041e-10, -2.989353347093464e-12,  6.069288427104832e-14, -1.155713840075073e-15,  2.079870699062202e-17,
 -3.558048172482804e-19,  3.968803430889026e-02, -4.016103791067375e-03,  2.364037652575960e-04, -1.036166204990599e-05,  3.724380129316559e-07, -1.154828560367121e-08,
  3.185817446516304e-10, -7.982065918294887e-12,  1.843170570742632e-13, -3.965590329721828e-15,  8.016615194036755e-17, -1.532381445687589e-18,  2.917354937793295e-02,
 -3.692325789435763e-03,  2.630432021848789e-04, -1.367088622280177e-05,  5.740320381369714e-07, -2.055192724521482e-08,  6.484449829640152e-10, -1.843312838326575e-11,
  4.795948208210928e-13, -1.155587665431594e-14,  2.602091113863217e-16, -5.513019706755694e-18,  2.090963291327698e-02, -3.218344544937588e-03,  2.723898949234532e-04,
 -1.654170792554483e-05,  8.013541583257320e-07, -3.276528165304213e-08,  1.170627742496614e-09, -3.740922157829289e-11,  1.087286541422585e-12, -2.910281452427903e-14,
  7.243409128996539e-16, -1.688490040835037e-17,  1.467502735809257e-02, -2.681889479590817e-03,  2.651276166563753e-04, -1.855716675819069e-05,  1.025105564742736e-06,
 -4.737176924562404e-08,  1.898530518706262e-09, -6.761446032830580e-11,  2.177585204946920e-12, -6.425604032333967e-14,  1.754956134500651e-15, -4.470001248507066e-17,
  1.013008573121043e-02, -2.152699545099538e-03,  2.447149559004713e-04, -1.948862404711105e-05,  1.213958863604068e-06, -6.277662103470455e-08,  2.796803396052693e-09,
 -1.100834577525832e-10,  3.898038746983906e-12, -1.258780455213293e-13,  3.746542609394320e-15, -1.035813545598839e-16,  6.908636671399349e-03, -1.675789839438987e-03,
  2.159037498704430e-04, -1.932551930822509e-05,  1.342964058782240e-06, -7.697006702432411e-08,  3.778632595344664e-09, -1.630428125714948e-10,  6.299634236384652e-12,
 -2.210438502854063e-13,  7.121073094369177e-15, -2.123255607543489e-16,  4.675164936984974e-03, -1.272996216607826e-03,  1.833759357732701e-04, -1.823429548512845e-05,
  1.399028926695965e-06, -8.803747229771007e-08,  4.721521788484761e-09, -2.215528381604830e-10,  9.270948344778662e-12, -3.509760625657947e-13,  1.215689240115061e-14,
 -3.884320407126331e-16,  3.151647761178750e-03, -9.487736571481585e-04,  1.508699327758753e-04, -1.647954809291181e-05,  1.381964262347548e-06, -9.460397746411114e-08,
  5.495642041429697e-09, -2.782188205063195e-10,  1.251476812005966e-11, -5.075797307678791e-13,  1.877687136924706e-14, -6.388296241575504e-16,  2.123284330018449e-03,
 -6.968808394672636e-04,  1.208519027456093e-04, -1.434397405459179e-05,  1.301760150905667e-06, -9.606111497006968e-08,  5.993239482982152e-09, -3.247488844621997e-10,
  1.558548981244996e-11, -6.724390856838958e-13,  2.638905441283908e-14, -9.498852502259440e-16,  1.432405709246543e-03, -5.059801754097942e-04,  9.458985551098071e-05,
 -1.207081411285065e-05,  1.173998570601063e-06, -9.254340811118092e-08,  6.148583765428235e-09, -3.537601997872539e-10,  1.797795504449627e-11, -8.192495141903315e-13,
  3.387535141098956e-14, -1.281740316536985e-15,  9.675614951459667e-04, -3.634587402134526e-04,  7.243272545958387e-05, -9.835671021332068e-06,  1.015333056891498e-06,
 -8.472568894549517e-08,  5.943727588404449e-09, -3.602003165706735e-10,  1.923625877809289e-11, -9.191612442239630e-13,  3.977019623327565e-14, -1.571389512085036e-15,
  6.520462282444231e-04, -2.575752976994914e-04,  5.413315000821385e-05, -7.742612106129749e-06,  8.402319136827220e-07, -7.355317666641361e-08,  5.401793075655207e-09,
 -3.420148966709434e-10,  1.904637665967817e-11, -9.472936363291121e-13,  4.258950498622959e-14, -1.745549725324026e-15,  4.339248433420892e-04, -1.783727535792787e-04,
  3.912075510954218e-05, -5.834762199824424e-06,  6.593167193360753e-07, -6.000008619450874e-08,  4.573361424131597e-09, -3.000542368936407e-10,  1.728865232806025e-11,
 -8.883700132665737e-13,  4.120677748141007e-14, -1.739993588151414e-15,  2.781989413097966e-04, -1.178269524698158e-04,  2.669235068039036e-05, -4.110316970195184e-06,
  4.790361614971966e-07, -4.490874264913791e-08,  3.522017330740827e-09, -2.374729982947144e-10,  1.404536227817738e-11, -7.400176657747349e-13,  3.515873996430723e-14,
 -1.519019004329493e-15,  1.610115398459724e-04, -6.959900109745563e-05,  1.612247308247725e-05, -2.538081248332123e-06,  3.021962552678893e-07, -2.891977415153064e-08,
  2.313344776873461e-09, -1.589621719614033e-10,  9.574128420712566e-12, -5.132914005209141e-13,  2.479666402321294e-14, -1.088524821179808e-15,  6.556596227739636e-05,
 -2.866171961337339e-05,  6.721980351935322e-06, -1.071253884686558e-06,  1.290742311716023e-07, -1.249452400290824e-08,  1.010515293037151e-09, -7.017442077408816e-11,
  4.269497301661047e-12, -2.311269101165831e-13,  1.126970705989603e-14, -4.991267765829915e-16,  1.247550528170135e-01, -6.751556672335121e-04,  3.916309340721161e-06,
 -2.378458442184743e-08,  1.481077936327644e-10, -9.322259624800344e-13,  5.879290521881609e-15, -3.698370683406024e-17,  2.314943767795016e-19, -1.440596765222727e-21,
  8.909710079612769e-24, -5.477316174262579e-26,  1.177400374465506e-01, -1.024601277947060e-03,  1.040041204668395e-05, -1.026932128894937e-07,  9.671038128677441e-10,
 -8.747058246453795e-12,  7.655795275792107e-14, -6.520106202977354e-16,  5.424560293856386e-18, -4.421724982712163e-20,  3.539315749067878e-22, -2.786818212367713e-24,
  1.049376816785344e-01, -1.601997297408469e-03,  2.444981335408591e-05, -3.318945676413186e-07,  4.143634419225648e-09, -4.859768202036315e-11,  5.422321486065540e-13,
 -5.804334976856323e-15,  5.997262734689890e-17, -6.008587289404126e-19,  5.858065335547869e-21, -5.573044440504373e-23,  8.843653917585136e-02, -2.216852026915381e-03,
  4.652042781491589e-05, -8.274688633561830e-07,  1.318503284791580e-08, -1.934903277201912e-10,  2.659535188377794e-12, -3.463033979168935e-14,  4.306710993597216e-16,
 -5.146513757779846e-18,  5.937437496053167e-20, -6.637002800630789e-22,  7.060821701927956e-02, -2.686165794746225e-03,  7.456330829731045e-05, -1.691077707595154e-06,
  3.352162251558590e-08, -6.009901001801650e-10,  9.951300894555827e-12, -1.543292575529410e-13,  2.264140630974668e-15, -3.165694760547466e-17,  4.242568625115152e-19,
 -5.473733335792714e-21,  5.354427410403892e-02, -2.896693623241665e-03,  1.036615380279568e-04, -2.932985021331885e-06,  7.092515125082304e-08, -1.526067380427154e-09,
  2.994190452493314e-11, -5.445278423955853e-13,  9.286221748081021e-15, -1.497906579113000e-16,  2.300603490614784e-18, -3.381490844313906e-20,  3.868995920581999e-02,
 -2.828059481186582e-03,  1.276065315091608e-04, -4.421355695888590e-06,  1.283515237647034e-07, -3.266926397851927e-09,  7.494915333102431e-11, -1.578629165434709e-12,
  3.092835485353658e-14, -5.691361968627691e-16,  9.910724563920359e-18, -1.642434885558796e-19,  2.674145820159603e-02, -2.536118510700098e-03,  1.413596340243592e-04,
 -5.900442661747530e-06,  2.027845423122528e-07, -6.030471453737385e-09,  1.599462390036709e-10, -3.860788893981860e-12,  8.603856484720089e-14, -1.789223116098601e-15,
  3.500767629175488e-17, -6.484685678066485e-19,  1.775918330468450e-02, -2.114550980298741e-03,  1.428605503894007e-04, -7.077693123217951e-06,  2.843736148714453e-07,
 -9.771370186392977e-09,  2.966076474660657e-10, -8.128406824548384e-12,  2.042426601775081e-13, -4.760088465462997e-15,  1.038186431320340e-16, -2.133208711250285e-18,
  1.139001637849321e-02, -1.656663296227310e-03,  1.333126597520623e-04, -7.732075245204188e-06,  3.589932449332875e-07, -1.410718631151230e-08,  4.855410264484557e-10,
 -1.497733324883700e-11,  4.209248910041296e-13, -1.091111045316931e-14,  2.633594561774486e-16, -5.961128091512099e-18,  7.094826967664113e-03, -1.231407322021142e-03,
  1.161366196757236e-04, -7.784576934913497e-06,  4.130919454090544e-07, -1.838529074198776e-08,  7.111996539394334e-10, -2.449401080065092e-11,  7.641282939441922e-13,
 -2.187366139338154e-14,  5.803254802173515e-16, -1.437643282155280e-17,  4.318489742390403e-03, -8.762954647301773e-04,  9.542020276901834e-05, -7.301893537077237e-06,
  4.382277909660572e-07, -2.188438443505960e-08,  9.434189730647207e-10, -3.599413000123270e-11,  1.237368544971434e-12, -3.884666862008016e-14,  1.125475214273465e-15,
 -3.032521964832234e-17,  2.585234454005333e-03, -6.021986570443670e-04,  7.465587194527744e-05, -6.446234361392880e-06,  4.331083644982153e-07, -2.404809898011745e-08,
  1.145746947637685e-09, -4.805465319390280e-11,  1.807356974234438e-12, -6.181001200334066e-14,  1.943057039113440e-15, -5.659547267271329e-17,  1.532215457627773e-03,
 -4.029712595429283e-04,  5.612861802164162e-05, -5.407130066585527e-06,  4.026718288953632e-07, -2.463630730070615e-08,  1.286581538482728e-09, -5.886800840420225e-11,
  2.405010591956410e-12, -8.899339039053028e-14,  3.016101632044730e-15, -9.438772243549039e-17,  9.049382636689617e-04, -2.646409646698045e-04,  4.089532859890746e-05,
 -4.347293847051089e-06,  3.553208240846630e-07, -2.374050317768320e-08,  1.347759525779971e-09, -6.675801273277558e-11,  2.941234475431127e-12, -1.169581796623405e-13,
  4.245859481402071e-15, -1.418810116280738e-16,  5.358111896812707e-04, -1.717802151844367e-04,  2.909548149591738e-05, -3.376332618785787e-06,  2.999234433747233e-07,
 -2.168772701344461e-08,  1.327293060120325e-09, -7.061716733571703e-11,  3.330641616314187e-12, -1.413396866416489e-13,  5.459740510842579e-15, -1.935882497999206e-16,
  3.196331692615540e-04, -1.108592385948281e-04,  2.033998919155795e-05, -2.549248667647528e-06,  2.437160063075143e-07, -1.890050190734717e-08,  1.236422403261604e-09,
 -7.009632778210149e-11,  3.512608257295215e-12, -1.579416290785537e-13,  6.447984367476999e-15, -2.410250982484733e-16,  1.926801520963563e-04, -7.139930616478036e-05,
  1.402857529481046e-05, -1.878944187112190e-06,  1.914310757699825e-07, -1.577552820832547e-08,  1.093590413655555e-09, -6.552626300422084e-11,  3.461794590293738e-12,
 -1.637198218875651e-13,  7.014587198222449e-15, -2.745779259494734e-16,  1.173046897074944e-04, -4.589740296656099e-05,  9.548992788140699e-06, -1.352395990246956e-06,
  1.453826263636546e-07, -1.261240097717819e-08,  9.183329710665179e-10, -5.766978442859588e-11,  3.186565111000164e-12, -1.573109306925559e-13,  7.022446491240198e-15,
 -2.858748690308870e-16,  7.159447990421959e-05, -2.924883157828274e-05,  6.372495795716081e-06, -9.442916827104485e-07,  1.060386925182610e-07, -9.592382335210468e-09,
  7.269947302527269e-10, -4.743834529483303e-11,  2.719146817550459e-12, -1.390302612910366e-13,  6.418369653826352e-15, -2.697993020809550e-16,  4.284585123358422e-05,
 -1.808240072695027e-05,  4.080613732581376e-06, -6.259888621446936e-07,  7.268904389600322e-08, -6.790555501488315e-09,  5.307681037354411e-10, -3.567221069096186e-11,
  2.103353141405572e-12, -1.104950784941539e-13,  5.234931171296620e-15, -2.255657956992459e-16,  2.360898083726850e-05, -1.018784007196014e-05,  2.355577169001670e-06,
 -3.701390563129471e-07,  4.399120281241539e-08, -4.202590575917709e-09,  3.356115513254482e-10, -2.302465736030989e-11,  1.384615069415776e-12, -7.412259909915784e-14,
  3.575707493178704e-15, -1.567526296886060e-16,  9.350045022936253e-06, -4.084552067549634e-06,  9.572219524109305e-07, -1.524332844744356e-07,  1.835290245448812e-08,
 -1.775295662516266e-09,  1.434789686127641e-10, -9.956972133035730e-12,  6.053922989791864e-13, -3.275146411215099e-14,  1.595956239739469e-15, -7.064085157102420e-17,
  1.221153385350097e-01, -6.449279361031300e-04,  3.644521313777065e-06, -2.155668689811258e-08,  1.307945564739837e-10, -8.027580043587513e-13,  4.940124115883301e-15,
 -3.034133330426696e-17,  1.855074932596164e-19, -1.128033349970348e-21,  6.818750040590911e-24, -4.098053430844371e-26,  1.138005888631737e-01, -9.460768799307235e-04,
  9.255469630565959e-06, -8.852512179594387e-08,  8.091532667412648e-10, -7.110506512145143e-12,  6.051073054908020e-14, -5.013842302187294e-16,  4.060587923313862e-18,
 -3.223528325764518e-20,  2.513956857915272e-22, -1.929354059719706e-24,  9.889716475136488e-02, -1.421272195279723e-03,  2.083494124665780e-05, -2.727165720068128e-07,
  3.289693744551426e-09, -3.733598724194488e-11,  4.036233153108600e-13, -4.190472803755105e-15,  4.202929051114086e-17, -4.090499462898664e-19,  3.876506590564183e-21,
 -3.586824451385296e-23,  8.025527209152147e-02, -1.881093884748752e-03,  3.773925703055825e-05, -6.443024614638678e-07,  9.882350481185894e-09, -1.398960862556377e-10,
  1.857938149501995e-12, -2.340644709691560e-14,  2.819406380440771e-16, -3.266407187260543e-18,  3.656473108114918e-20, -3.968857003721073e-22,  6.093981075360116e-02,
 -2.162549114099633e-03,  5.713014529196640e-05, -1.239248007672702e-06,  2.357834941879933e-08, -4.067729996292021e-10,  6.493970461733639e-12, -9.725502192904646e-14,
  1.379675093043417e-15, -1.867443793310944e-17,  2.425195379756955e-19, -3.034808064460410e-21,  4.341764521763993e-02, -2.190982400541211e-03,  7.438096478632516e-05,
 -2.007947021344672e-06,  4.650936897680611e-08, -9.612569694007047e-10,  1.815624449317819e-11, -3.184385994117107e-13,  5.245157693407903e-15, -8.182436782149180e-17,
  1.216785428918334e-18, -1.733411506163855e-20,  2.912686052705918e-02, -1.988918654570380e-03,  8.499572383371983e-05, -2.805940441071544e-06,  7.792705592489065e-08,
 -1.903238878800524e-09,  4.199653106458263e-11, -8.524372463904953e-13,  1.612085904474932e-14, -2.867571734304599e-16,  4.832973265201037e-18, -7.760691000599709e-20,
  1.847759757584085e-02, -1.641278671320890e-03,  8.662869659596507e-05, -3.444030130746405e-06,  1.131924757353437e-07, -3.228948413185841e-09,  8.235158156020920e-11,
 -1.915325483703329e-12,  4.119828601427819e-14, -8.281775704625222e-16,  1.568459422322498e-17, -2.815629273967771e-19,  1.114121499839896e-02, -1.246722336168326e-03,
  7.984849729983523e-05, -3.770232000177996e-06,  1.449331861622822e-07, -4.779048720345958e-09,  1.395524308588463e-10, -3.686558347473405e-12,  8.945187803021691e-14,
 -2.016308078854973e-15,  4.259051591828573e-17, -8.486179537791298e-19,  6.422744918198694e-03, -8.815957711184023e-04,  6.739874721357175e-05, -3.731411592926311e-06,
  1.659657540801203e-07, -6.265748517090695e-09,  2.076779383306694e-10, -6.181704762622821e-12,  1.679381632281251e-13, -4.214602334352685e-15,  9.862334077802504e-17,
 -2.166979067465554e-18,  3.563924598963059e-03, -5.865173455869814e-04,  5.271330220870501e-05, -3.380777717585401e-06,  1.722119813702184e-07, -7.376957904982782e-09,
  2.752731258966417e-10, -9.163018609359532e-12,  2.767506105514094e-13, -7.681439735978978e-15,  1.978702120724091e-16, -4.765332087540366e-18,  1.917835479988254e-03,
 -3.709220753275476e-04,  3.863535313583110e-05, -2.837639841569270e-06,  1.639196416859152e-07, -7.898019417489052e-09,  3.291846071467339e-10, -1.216474202310250e-11,
  4.056973521419973e-13, -1.237404711228176e-14,  3.487482861955617e-16, -9.152172978257475e-18,  1.009076619904576e-03, -2.252831595014717e-04,  2.683200159723818e-05,
 -2.231927227773334e-06,  1.448131225484455e-07, -7.781219937236502e-09,  3.594323199656547e-10, -1.463995239546212e-11,  5.355046960615369e-13, -1.783489276556890e-14,
  5.466566998933496e-16, -1.554255940749933e-17,  5.236659713301549e-04, -1.327624399962347e-04,  1.785065879176201e-05, -1.663539491971871e-06,  1.200849952437024e-07,
 -7.134615795346649e-09,  3.624042422484299e-10, -1.615207937930729e-11,  6.436219635399284e-13, -2.325715371808452e-14,  7.705590562435722e-16, -2.359872548276805e-17,
  2.704653766774589e-04, -7.669013706700652e-05,  1.149756204279216e-05, -1.187682906974480e-06,  9.448377051019616e-08, -6.153686013340360e-09,  3.410066378034041e-10,
 -1.650827604873848e-11,  7.116586019857253e-13, -2.771858784195324e-14,  9.865597044523426e-16, -3.235192288992951e-17,  1.402667746781041e-04, -4.385078930850675e-05,
  7.242702111918510e-06, -8.205335239568760e-07,  7.125045749250173e-08, -5.042469725806532e-09,  3.023685181551755e-10, -1.577869583807354e-11,  7.306262289080260e-13,
 -3.046645175205903e-14,  1.157379488347552e-15, -4.038982575300356e-17,  7.364126827035298e-05, -2.504087850388673e-05,  4.502831738609960e-06, -5.535418432555588e-07,
  5.195622927273293e-08, -3.959578087401650e-09,  2.547704544794766e-10, -1.421815423773540e-11,  7.019037971938170e-13, -3.111396020907179e-14,  1.253092348634791e-15,
 -4.623847990832359e-17,  3.939064610695966e-05, -1.438175930847594e-05,  2.782687652898808e-06, -3.672143050727628e-07,  3.688644775374081e-08, -2.999069783744805e-09,
  2.052550689981088e-10, -1.214963947027378e-11,  6.344735540202061e-13, -2.967678954173920e-14,  1.258186893174227e-15, -4.875909308748924e-17,  2.153005839722081e-05,
 -8.336414069903349e-06,  1.715422523157426e-06, -2.403648375362380e-07,  2.557583074164681e-08, -2.197213645997593e-09,  1.585019213720726e-10, -9.865880298391633e-12,
  5.405628986563904e-13, -2.647222150338694e-14,  1.172708014248412e-15, -4.739224904390993e-17,  1.197746051846837e-05, -4.860154705462111e-06,  1.051251261752565e-06,
 -1.546777387169490e-07,  1.725166969202797e-08, -1.550491363842227e-09,  1.167831826848894e-10, -7.575478665778910e-12,  4.317814698657797e-13, -2.195858804818918e-14,
  1.008533216027862e-15, -4.218740651181004e-17,  6.654372199865581e-06, -2.797454129629692e-06,  6.286398517354154e-07, -9.603802336193054e-08,  1.110733983143265e-08,
 -1.033673017367740e-09,  8.049933696098586e-11, -5.391355029936169e-12,  3.168314955654953e-13, -1.659097300550306e-14,  7.836350597124851e-16, -3.366754370940328e-17,
  3.476262099734763e-06, -1.497298222671890e-06,  3.454913820032414e-07, -5.417857169976910e-08,  6.426552762364227e-09, -6.127882579903578e-10,  4.884765187684287e-11,
 -3.345377781116978e-12,  2.008430917687213e-13, -1.073454566841134e-14,  5.170447747738322e-16, -2.263302062722025e-17,  1.335600484649563e-06, -5.830338783523350e-07,
  1.365252325024343e-07, -2.172351534798905e-08,  2.613434849617794e-09, -2.526056596473464e-10,  2.040025525966797e-11, -1.414683244386175e-12,  8.595334898366678e-14,
 -4.646862059097987e-15,  2.262882651960899e-16, -1.000963605860399e-17,  1.195923494908249e-01, -6.167720901707497e-04,  3.397887634023093e-06, -1.958625059722902e-08,
  1.158595261496170e-10, -6.937546430072079e-13,  4.167925071728359e-15, -2.500553046795331e-17,  1.494028467018458e-19, -8.881400947483185e-22,  5.249523142547589e-24,
 -3.085774184685928e-26,  1.101579380317826e-01, -8.760725570370800e-04,  8.266397110910180e-06, -7.664196667178899e-08,  6.804001465488479e-10, -5.813037776882709e-12,
  4.812959045841824e-14, -3.882266585941189e-16,  3.062401376299464e-18, -2.368980207748339e-20,  1.801026143389180e-22, -1.347924909493729e-24,  9.352590107031988e-02,
 -1.266841782796512e-03,  1.785511335471848e-05, -2.255662286176332e-07,  2.631070970955757e-09, -2.891765698217572e-11,  3.031021644772096e-13, -3.054054541306660e-15,
  2.975235962663074e-17, -2.814527435009207e-19,  2.594154868960640e-21, -2.335773330776404e-23,  7.328929071113871e-02, -1.607616285259333e-03,  3.087128210989000e-05,
 -5.063512623655391e-07,  7.482090132026090e-09, -1.022499860239807e-10,  1.313020014201164e-12, -1.601443646156080e-14,  1.869530520276587e-16, -2.101071599612206e-18,
  2.283368981416569e-20, -2.407875796579054e-22,  5.311781678903512e-02, -1.759146081015721e-03,  4.427932124012603e-05, -9.194534169291629e-07,  1.680423980122087e-08,
 -2.791666784717263e-10,  4.299833257169514e-12, -6.222278462223997e-14,  8.540203085003283e-16, -1.119623600195292e-17,  1.409691641242317e-19, -1.711742736202493e-21,
  3.570731724788621e-02, -1.680986658373031e-03,  5.418523060672148e-05, -1.396644626398060e-06,  3.100709506718683e-08, -6.159554971676049e-10,  1.120618482262938e-11,
 -1.896434584893107e-13,  3.018481248568519e-15, -4.555952708691238e-17,  6.562341279778447e-19, -9.064176887729332e-21,  2.234437959277073e-02, -1.425015392147222e-03,
  5.770680020991550e-05, -1.816038993844420e-06,  4.827328194901107e-08, -1.131801322352796e-09,  2.403025790251590e-11, -4.702219805467155e-13,  8.586638638900936e-15,
 -1.476889638884294e-16,  2.409786951043990e-18, -3.750382465887229e-20,  1.307457098029654e-02, -1.087065258575840e-03,  5.433949799374267e-05, -2.058064108988611e-06,
  6.470097081024856e-08, -1.770839007548347e-09,  4.343782303641649e-11, -9.736172315632691e-13,  2.021694970883171e-14, -3.929115138775665e-16,  7.203577208298894e-18,
 -1.253343852172788e-19,  7.192742965332822e-03, -7.557188062277980e-04,  4.587104452640907e-05, -2.064005472602600e-06,  7.590838079521662e-08, -2.401917959634923e-09,
  6.747038246605415e-11, -1.718091119102406e-12,  4.025568811662427e-14, -8.775554486362370e-16,  1.795156857583544e-17, -3.468275504057877e-19,  3.744235247270463e-03,
 -4.843886646071289e-04,  3.515841927787988e-05, -1.857152316492666e-06,  7.910296177439128e-08, -2.868243275594928e-09,  9.152648027379212e-11, -2.628226056305005e-12,
  6.900290399485191e-14, -1.676144882772798e-15,  3.801650752347524e-17, -8.106549956165035e-19,  1.858159983640623e-03, -2.894973436899074e-04,  2.476908032986812e-05,
 -1.518777479511747e-06,  7.421476181144040e-08, -3.058043967716968e-09,  1.100190419411507e-10, -3.537828126549501e-12,  1.034020404883400e-13, -2.781561334481015e-15,
  6.953870210694758e-17, -1.627380319274753e-18,  8.866907995960782e-04, -1.631595139437299e-04,  1.623499705165433e-05, -1.143227726927324e-06,  6.350552196062516e-08,
 -2.949787137596489e-09,  1.187772375787462e-10, -4.248406826661130e-12,  1.373624800429786e-13, -4.067780028949987e-15,  1.114582249112920e-16, -2.847171156522890e-18,
  4.107784316662059e-04, -8.772577037211237e-05,  1.002259983646450e-05, -8.020890553638844e-07,  5.019796563084361e-08, -2.607525135549132e-09,  1.166657283649674e-10,
 -4.610567595981288e-12,  1.638812170625810e-13, -5.311094034412649e-15,  1.586050693864610e-16, -4.398673761311680e-18,  1.867178090619476e-04, -4.554060299174163e-05,
  5.900887304232421e-06, -5.311975278770338e-07,  3.712042482505508e-08, -2.139109690864154e-09,  1.055693035305670e-10, -4.578461947992140e-12,  1.777737760678751e-13,
 -6.267327940026561e-15,  2.028229019638942e-16, -6.073712162845783e-18,  8.422336505466393e-05, -2.310976652160396e-05,  3.355574112781438e-06, -3.363152290901115e-07,
  2.600492280702834e-08, -1.648880951775682e-09,  8.908596496313789e-11, -4.210346072358564e-12,  1.774118065471691e-13, -6.761714123881078e-15,  2.357355807520605e-16,
 -7.579468183931575e-18,  3.814523009434202e-05, -1.160734201082478e-05,  1.866423993928315e-06, -2.061250974096180e-07,  1.747235099474997e-08, -1.208669222897924e-09,
  7.092974444565783e-11, -3.626390788604283e-12,  1.646854186367884e-13, -6.741365144447982e-15,  2.516207871512191e-16, -8.634788063098393e-18,  1.754642519693488e-05,
 -5.840289344338798e-06,  1.027731921901794e-06, -1.237512715044329e-07,  1.138934527061153e-08, -8.519574829288841e-10,  5.385735987760722e-11, -2.955669331173860e-12,
  1.436045395221941e-13, -6.269877784933929e-15,  2.488924318384301e-16, -9.058559697363693e-18,  8.280945118310672e-06, -2.975067359685961e-06,  5.661551474461904e-07,
 -7.352481195904680e-08,  7.273659303870203e-09, -5.828754417188795e-10,  3.934622224788768e-11, -2.298743963496182e-12,  1.185598462963774e-13, -5.480224373418829e-15,
  2.297350403021689e-16, -8.807976977798650e-18,  4.037631143734122e-06, -1.545601884875434e-06,  3.142590297702637e-07, -4.352508348388095e-08,  4.580066238671852e-09,
 -3.893303840888563e-10,  2.780410627825015e-11, -1.714162700443035e-12,  9.306907495179427e-14, -4.518367428235891e-15,  1.985137134961552e-16, -7.959616336906820e-18,
  2.034146124719186e-06, -8.192877096744515e-07,  1.758139105699685e-07, -2.566947723356409e-08,  2.841836674509275e-09, -2.536079317219115e-10,  1.897336188760941e-11,
 -1.222879954490233e-12,  6.927550929998885e-14, -3.502571636764726e-15,  1.599769763792231e-16, -6.656586239217249e-18,  1.042992015010121e-06, -4.365943615357820e-07,
  9.765869043022692e-08, -1.485193070111152e-08,  1.710225994637182e-09, -1.584935709718605e-10,  1.229383395747963e-11, -8.202355288687460e-13,  4.802751623267557e-14,
 -2.506262086094619e-15,  1.179856595615691e-16, -5.053070869817201e-18,  5.141911537579253e-07, -2.210218251516807e-07,  5.088576796054538e-08, -7.962148622867742e-09,
  9.424427146478187e-10, -8.968027583452740e-11,  7.134704981571441e-12, -4.877067826955590e-13,  2.922711708681180e-14, -1.559411828609242e-15,  7.498673121578543e-17,
 -3.277247902771708e-18,  1.911249662149701e-07, -8.336783559611438e-08,  1.950491097554916e-08, -3.100894400356247e-09,  3.727364519759798e-10, -3.599783884217850e-11,
  2.904842822131193e-12, -2.012845811553388e-13,  1.222049323122385e-14, -6.601922150041398e-16,  3.212676705091402e-17, -1.420129049508132e-18,  1.171781819200992e-01,
 -5.904986356761737e-04,  3.173534240773699e-06, -1.783829264514681e-08,  1.029306945105488e-10, -6.016142160660813e-13,  3.530170348063163e-15, -2.069819262613509e-17,
  1.209040834036075e-19, -7.029487242188203e-22,  4.064436575585540e-24, -2.337845172305242e-26,  1.067803354844601e-01, -8.134435713473366e-04,  7.408368979338681e-06,
 -6.662639570114675e-08,  5.748640530752158e-10, -4.778039152501926e-12,  3.851227062748529e-14, -3.025928691976213e-16,  2.326135392368006e-18, -1.754380928374585e-20,
  1.300888290577794e-22, -9.499403456614556e-25,  8.872802816730026e-02, -1.134153927467121e-03,  1.538302104365391e-05, -1.877279252501552e-07,  2.119054494579458e-09,
 -2.257047581383112e-11,  2.295264116759919e-13, -2.245917798287663e-15,  2.126439705422515e-17, -1.956339509663583e-19,  1.754679570990664e-21, -1.538244377611077e-23,
  6.731696474657517e-02, -1.383060766971515e-03,  2.545101969500674e-05, -4.014267719426678e-07,  5.719113077517304e-09, -7.550639899752554e-11,  9.381460093138963e-13,
 -1.108468845183321e-14,  1.254882887353900e-16, -1.368840326032960e-18,  1.444987528941647e-20, -1.481147157828143e-22,  4.672575907562213e-02, -1.444865157770393e-03,
  3.469150526368867e-05, -6.901864824199957e-07,  1.212625525436554e-08, -1.941262789918768e-10,  2.886584649592561e-12, -4.038679892133468e-14,  5.366058567674481e-16,
 -6.817417310985727e-18,  8.326036086287409e-20, -9.814835737643259e-22,  2.975497120181499e-02, -1.306959367432335e-03,  4.003848118878529e-05, -9.860979268634544e-07,
  2.099793896247891e-08, -4.011643947858687e-10,  7.033934550201399e-12, -1.149171003631906e-13,  1.768322609133582e-15, -2.583519599250090e-17,  3.605940236920599e-19,
 -4.830985992344570e-21,  1.744610849269924e-02, -1.038937439171579e-03,  3.989207037869115e-05, -1.197394104396035e-06,  3.047986192546064e-08, -6.863400455568072e-10,
  1.402758860880140e-11, -2.647245336773927e-13,  4.669444804396768e-15, -7.768397841258528e-17,  1.227502992021678e-18, -1.852031362872077e-20,  9.461038653130385e-03,
 -7.359025602993668e-04,  3.484626035929540e-05, -1.257643278580173e-06,  3.782992295878308e-08, -9.936816736780464e-10,  2.344897271532840e-11, -5.066319418333233e-13,
  1.015778884347325e-14, -1.908935394715296e-16,  3.388570924668687e-18, -5.715008649204773e-20,  4.771907738654997e-03, -4.703266714214236e-04,  2.705079812404955e-05,
 -1.159864683776802e-06,  4.081063183528427e-08, -1.239229944397265e-09,  3.348740698771457e-11, -8.220084560963261e-13,  1.859849019272849e-14, -3.921091072338348e-16,
  7.767883616473456e-18, -1.455175677313316e-19,  2.253543730377479e-03, -2.744411212913556e-04,  1.890111049621385e-05, -9.522281777120051e-07,  3.882987127111394e-08,
 -1.351942949265513e-09,  4.152536680246748e-11, -1.150121048489998e-12,  2.917626782946905e-14, -6.858497967911716e-16,  1.507454735449323e-17, -3.118974227699508e-19,
  1.004417486139651e-03, -1.479192488127089e-04,  1.203669490680499e-05, -7.051373962960096e-07,  3.303456167235305e-08, -1.308709365425435e-09,  4.537401724462901e-11,
 -1.408918840054655e-12,  3.983323591599840e-14, -1.038106137525792e-15,  2.517765946254764e-17, -5.723552521325888e-19,  4.264619840921435e-04, -7.452807762173310e-05,
  7.075400369104560e-06, -4.772011057238804e-07,  2.546895625022596e-08, -1.139594329171914e-09,  4.430076673360282e-11, -1.532682142368335e-12,  4.801438878390821e-14,
 -1.379708872469277e-15,  3.673274042437236e-17, -9.128693598016765e-19,  1.743517286913970e-04, -3.554778256397329e-05,  3.889907892080140e-06, -2.991214231268913e-07,
  1.803708308751741e-08, -9.048559097320025e-10,  3.917813011779301e-11, -1.500981273971195e-12,  5.180304137150493e-14, -1.632411848699478e-15,  4.746121377828237e-17,
 -1.283039461144165e-18,  6.947555164492376e-05, -1.626855650639764e-05,  2.028051486548450e-06, -1.760953568261943e-07,  1.189721968674127e-08, -6.641940090355783e-10,
  3.181360325883395e-11, -1.341236696811536e-12,  5.069787919784670e-14, -1.742234829627656e-15,  5.502486289722908e-17, -1.609904090928632e-18,  2.734914690409896e-05,
 -7.247004149982971e-06,  1.017362818637327e-06, -9.877982269088481e-08,  7.413489537661546e-09, -4.570425186256003e-10,  2.404670219197493e-11, -1.108293910242950e-12,
  4.560004759485469e-14, -1.698990180576342e-15,  5.796608444966944e-17, -1.825756905667464e-18,  1.079046567042856e-05, -3.189850817855861e-06,  4.984913749098927e-07,
 -5.358343372436421e-08,  4.427575895010344e-09, -2.989900561795633e-10,  1.715063300807413e-11, -8.581193554694128e-13,  3.817900059385044e-14, -1.532674252758412e-15,
  5.615435274276280e-17, -1.893255021574393e-18,  4.330787141267499e-06, -1.408611355134851e-06,  2.421922616863941e-07, -2.852367391274580e-08,  2.570608086671401e-09,
 -1.885058371373415e-10,  1.169439634477281e-11, -6.304295548046800e-13,  3.011528235933565e-14, -1.293828831395411e-15,  5.057817269929332e-17, -1.814127310794212e-18,
  1.793311731881740e-06, -6.330796893829774e-07,  1.183300470182183e-07, -1.510389184294520e-08,  1.469840755394960e-09, -1.159635857935969e-10,  7.713040807231246e-12,
 -4.443406476210576e-13,  2.261361592952430e-14, -1.032098034564828e-15,  4.274685839206521e-17, -1.620185551213866e-18,  7.749270814367987e-07, -2.929555992377442e-07,
  5.879319929814654e-08, -8.040704230044731e-09,  8.359697552592780e-10, -7.025195973018972e-11,  4.962711882596000e-12, -3.028082418941941e-13,  1.627975993653084e-14,
 -7.829943899615070e-16,  3.409546339877839e-17, -1.355557844036543e-18,  3.511469344207310e-07, -1.402789389571591e-07,  2.984306293909345e-08, -4.320545961491282e-09,
  4.744675560704656e-10, -4.201657010400079e-11,  3.120428362199954e-12, -1.997196436406026e-13,  1.123906968985335e-14, -5.646633301962815e-16,  2.563551601566004e-17,
 -1.060588164309719e-18,  1.651186069260889e-07, -6.879342348094410e-08,  1.531008100781994e-08, -2.316816225599313e-09,  2.655139447821383e-10, -2.449414139919499e-11,
  1.891673124233613e-12, -1.256880145549623e-13,  7.330374952023699e-15, -3.810861239153039e-16,  1.787565205219353e-17, -7.629555168116768e-19,  7.643528982806736e-08,
 -3.278186819052632e-08,  7.528976382577907e-09, -1.175235869360984e-09,  1.387840952920805e-10, -1.317685151656632e-11,  1.046071501907691e-12, -7.135994128930161e-14,
  4.268056349624425e-15, -2.272949678270224e-16,  1.091020168766614e-17, -4.760053267287354e-19,  2.740261013172239e-08, -1.194295632525160e-08,  2.791620425833347e-09,
 -4.434028310947170e-10,  5.325016570570283e-11, -5.138236995519048e-12,  4.142768103703799e-13, -2.868272899875749e-14,  1.740011458533451e-15, -9.392868558123587e-17,
  4.567409829467196e-18, -2.017516002580380e-19,  1.148656465712757e-01, -5.659394881413911e-04,  2.968973401663030e-06, -1.628324593549623e-08,  9.170087173289489e-11,
 -5.234298401526985e-13,  3.001194210016790e-15, -1.720468750087539e-17,  9.829262983859208e-20, -5.591880459654885e-22,  3.164045505625738e-24, -1.781680754022600e-26,
  1.036402430635400e-01, -7.572252735394658e-04,  6.661040827628119e-06, -5.814557360700681e-08,  4.879010532933048e-10, -3.947554150355314e-12,  3.099354531976675e-14,
 -2.373338077786130e-16,  1.778966506349888e-18, -1.308793142616845e-20,  9.470261438605415e-23, -6.750573953451774e-25,  8.442404428394445e-02, -1.019556780091096e-03,
  1.331973291426511e-05, -1.571551036190842e-07,  1.718009013570193e-09, -1.774563235198295e-11,  1.751978163981749e-13, -1.665816265182319e-15,  1.533740634456365e-17,
 -1.373061791437951e-19,  1.199049211211017e-21, -1.023949322393047e-23,  6.216348379405997e-02, -1.197272810123919e-03,  2.113679191203247e-05, -3.208765529402553e-07,
  4.411165542798230e-09, -5.630342333014634e-11,  6.773125120358463e-13, -7.757561443781675e-15,  8.521542432791624e-17, -9.027131629299024e-19,  9.261165106832425e-21,
 -9.231945147436351e-23,  4.145320444492732e-02, -1.197436118688970e-03,  2.745648515160739e-05, -5.238147635896356e-07,  8.854055931027809e-09, -1.366835686409242e-10,
  1.963394023338249e-12, -2.657533986756515e-14,  3.420058491983273e-16, -4.212936189918996e-18,  4.993238340200602e-20, -5.716860871140620e-22,  2.510013422194697e-02,
 -1.028827957072655e-03,  2.998331656503927e-05, -7.061340310142300e-07,  1.443189491681081e-08, -2.653371133071466e-10,  4.486318827756898e-12, -7.079649806039728e-14,
  1.053723536192914e-15, -1.490846736498133e-17,  2.017203235165638e-19, -2.622312910624223e-21,  1.384809454303388e-02, -7.699210496217593e-04,  2.804945517693913e-05,
 -8.034852017708056e-07,  1.959670195482246e-08, -4.240215935094680e-10,  8.346119128439298e-12, -1.519648798272754e-13,  2.590184399854024e-15, -4.169557581929976e-17,
  6.382349313783682e-19, -9.338177729219031e-21,  6.992146985075169e-03, -5.085428706305973e-04,  2.281768384475325e-05, -7.850114459580852e-07,  2.260093647250450e-08,
 -5.699275649885586e-10,  1.294227450894071e-11, -2.696144206863195e-13,  5.220748187098965e-15, -9.489220596690593e-17,  1.631211291999195e-18, -2.667233649112583e-20,
  3.248767216026080e-03, -3.001276829849260e-04,  1.635500592968862e-05, -6.682675674846669e-07,  2.249783060126444e-08, -6.556480572327054e-10,  1.704568414971662e-11,
 -4.033717726256402e-13,  8.813646856828923e-15, -1.797167267464011e-16,  3.447998439389193e-18, -6.263093600596418e-20,  1.398414043991643e-03, -1.601281687498826e-04,
  1.045924895318536e-05, -5.024191147318593e-07,  1.961031890114311e-08, -6.555074270420681e-10,  1.937744259180655e-11, -5.175866572925116e-13,  1.268508672153093e-14,
 -2.885287351050123e-16,  6.144660278199859e-18, -1.233401965768144e-19,  5.622137654128701e-04, -7.814913115295240e-05,  6.043021447337128e-06, -3.380142493773798e-07,
  1.517444983555393e-08, -5.777276867012625e-10,  1.929565456032413e-11, -5.783515648883446e-13,  1.581138027004398e-14, -3.990784107146130e-16,  9.386982730791046e-18,
 -2.072163321140457e-19,  2.131825979228318e-04, -3.532136814224748e-05,  3.195544878384431e-06, -2.062338999780740e-07,  1.056717096845854e-08, -4.551515617383017e-10,
  1.707107825657602e-11, -5.709455944705747e-13,  1.732010617746375e-14, -4.826845377301333e-16,  1.248012558537426e-17, -3.015871815823679e-19,  7.712427361179365e-05,
 -1.498305457562577e-05,  1.568069728184991e-06, -1.157215350985784e-07,  6.716334791481062e-09, -3.250933998095664e-10,  1.360970594582310e-11, -5.050729257387693e-13,
  1.691271544349286e-14, -5.178432228871846e-16,  1.464832691247327e-17, -3.857461311983221e-19,  2.697999036969216e-05, -6.052911889154435e-06,  7.247411364593704e-07,
 -6.061266303603679e-08,  3.954159659882625e-09, -2.136180230083326e-10,  9.920056159712021e-12, -4.061572980405256e-13,  1.493199782844117e-14, -4.997603193437253e-16,
  1.539129064030069e-17, -4.396216130472792e-19,  9.267162959764897e-06, -2.366485458469238e-06,  3.206251703766691e-07, -3.011108817659919e-08,  2.190376959593194e-09,
 -1.311290371217435e-10,  6.710662478153859e-12, -3.012864818408042e-13,  1.209175075306374e-14, -4.399922288412556e-16,  1.467722325240909e-17, -4.524689421855152e-19,
  3.178980943874415e-06, -9.111366391459852e-07,  1.381370427326416e-07, -1.442926286487789e-08,  1.160555922792620e-09, -7.640361520738267e-11,  4.278630828060913e-12,
 -2.092641426093697e-13,  9.111717386266549e-15, -3.583584117841819e-16,  1.287566174824142e-17, -4.261092311872413e-19,  1.109072123396200e-06, -3.518641020510446e-07,
  5.901256502056782e-08, -6.787419374047821e-09,  5.981494696012043e-10, -4.294450163521596e-11,  2.611349925762524e-12, -1.381289898800786e-13,  6.480620431680085e-15,
 -2.737005590705986e-16,  1.052664639548023e-17, -3.717648360023539e-19,  4.007748052985814e-07, -1.388113804137465e-07,  2.544651350431916e-08, -3.188100427953657e-09,
  3.048128024997373e-10, -2.364878457869242e-11,  1.548172304647112e-12, -8.785625191808876e-14,  4.407789858838666e-15, -1.984603940628674e-16,  8.114195295165951e-18,
 -3.037892065231005e-19,  1.524724378626678e-07, -5.685763692212706e-08,  1.124978026708743e-08, -1.517579540610673e-09,  1.557288377712202e-10, -1.292541328438694e-11,
  9.023771282956160e-13, -5.444772151525104e-14,  2.896320784957824e-15, -1.379023881406353e-16,  5.947537901668181e-18, -2.343120029108209e-19,  6.170073804591159e-08,
 -2.442797931965672e-08,  5.147683368259689e-09, -7.384066687294739e-10,  8.037613342081746e-11, -7.058128151054119e-12,  5.200106280415116e-13, -3.303088432690803e-14,
  1.845414634061365e-15, -9.208108744427854e-17,  4.153210635665147e-18, -1.707620638593376e-19,  2.642753294679212e-08, -1.095344827665370e-08,  2.424153844001407e-09,
 -3.648431038426821e-10,  4.159378570026052e-11, -3.817976543980529e-12,  2.934605760220343e-13, -1.941015969094826e-14,  1.127163934397090e-15, -5.835776364414460e-17,
  2.726690961946612e-18, -1.159458183855282e-19,  1.142410160318556e-08, -4.887589572293146e-09,  1.119529771018025e-09, -1.742933508804549e-10,  2.053011318084577e-11,
 -1.944484077744666e-12,  1.540071750352540e-13, -1.048251405142188e-14,  6.256265650681533e-16, -3.324983745027640e-17,  1.592889482833812e-18, -6.936757252209781e-20,
  3.936967052792734e-09, -1.714322809140643e-09,  4.003187876690379e-10, -6.352103098116912e-11,  7.621127416204098e-12, -7.346895883999934e-13,  5.918134933203078e-14,
 -4.093852174496475e-15,  2.481383481449460e-16, -1.338388869812831e-17,  6.502914741382418e-19, -2.870260044803651e-20,  1.126481888616942e-01, -5.429451250711126e-04,
  2.782044514835231e-06, -1.489602482897522e-08,  8.191530233146483e-11, -4.568442919626157e-13,  2.560637397236036e-15, -1.435844232363712e-17,  8.026315219025802e-20,
 -4.469928648029872e-22,  2.475977681480630e-24, -1.365572197482417e-26,  1.007136793197596e-01, -7.066009738359943e-04,  6.007652069859095e-06, -5.093249885044059e-08,
  4.158816367397778e-10, -3.277431065449233e-12,  2.507923843548987e-14, -1.872687467615998e-16,  1.369396730548511e-18, -9.832499933056382e-21,  6.946073763548244e-23,
 -4.835544671753527e-25,  8.054761503385591e-02, -9.201006272586864e-04,  1.158778740370247e-05, -1.322927188139465e-07,  1.401634153716459e-09, -1.404939592501816e-11,
  1.347442437068764e-13, -1.245664798198566e-15,  1.115924676515830e-17, -9.726414359310327e-20,  8.274018979766019e-22, -6.886315583432154e-24,  5.768978246818054e-02,
 -1.042460900754078e-03,  1.767525664184125e-05, -2.584919056140596e-07,  3.431531726071895e-09, -4.237398003587387e-11,  4.938589976048249e-13, -5.486381967461742e-15,
  5.851147346160483e-17, -6.022684206409763e-19,  6.008061731919436e-21, -5.827318218054898e-23,  3.706609937671089e-02, -1.000711339603698e-03,  2.193813820120842e-05,
 -4.016913900142740e-07,  6.537169513464005e-09, -9.738221685680102e-11,  1.352190296054666e-12, -1.771664383939012e-14,  2.209602101402791e-16, -2.640442595029311e-18,
  3.038536674415738e-20, -3.380412542559859e-22,  2.141594348983581e-02, -8.192987751601049e-04,  2.273730844848850e-05, -5.124387678460973e-07,  1.005907642726899e-08,
 -1.780881754144931e-10,  2.905320483398049e-12, -4.430800003071822e-14,  6.381889596541170e-16, -8.748040301754897e-18,  1.147949862395818e-19, -1.448599869894535e-21,
  1.116289320652210e-02, -5.793427543717674e-04,  2.004073308201170e-05, -5.481924627131240e-07,  1.281778502964955e-08, -2.666376647882148e-10,  5.056814081236940e-12,
 -8.887344245194170e-14,  1.464364932558306e-15, -2.281713810074513e-17,  3.384526894166297e-19, -4.803634771278574e-21,  5.271058273080391e-03, -3.583026291962619e-04,
  1.523947668780002e-05, -4.999716498536456e-07,  1.378269010229497e-08, -3.337824296782831e-10,  7.296442196625364e-12, -1.466010581186941e-13,  2.742377646807417e-15,
 -4.822106549973234e-17,  8.029083883248360e-19, -1.273069293122167e-20,  2.266634648162675e-03, -1.961142191473876e-04,  1.012559784549188e-05, -3.943132853986403e-07,
  1.270340811739852e-08, -3.553591915478349e-10,  8.889692478469773e-12, -2.028285748031837e-13,  4.280314106317585e-15, -8.442129805096127e-17,  1.568720600786702e-18,
 -2.763127185807188e-20,  8.934627356229530e-04, -9.608998630851505e-05,  5.950310537941793e-06, -2.724773262240230e-07,  1.017862645631324e-08, -3.266207321530601e-10,
  9.291651727960503e-12, -2.393336146280822e-13,  5.666363823580409e-15, -1.246981110047481e-16,  2.572895433514036e-18, -5.009838226919273e-20,  3.254626781849348e-04,
 -4.264054544231357e-05,  3.130908724457945e-06, -1.671229014290812e-07,  7.186489342017635e-09, -2.628507974198806e-10,  8.454350839904451e-12, -2.445332058537487e-13,
  6.462653429876531e-15, -1.579324923253918e-16,  3.601760341101962e-18, -7.718657448689767e-20,  1.106517327847367e-04, -1.735220218361537e-05,  1.494366713495217e-06,
 -9.220762497024318e-08,  4.532585447768056e-09, -1.878153631846662e-10,  6.792580620170246e-12, -2.194995953703477e-13,  6.444819545853223e-15, -1.741062078426654e-16,
  4.369787385713610e-18, -1.026357213250116e-19,  3.553459997801044e-05, -6.565191681057385e-06,  6.562038028457645e-07, -4.642264621065506e-08,  2.590710014194232e-09,
 -1.208858792326463e-10,  4.889271923164651e-12, -1.756305189917974e-13,  5.702094790501343e-15, -1.695278583699657e-16,  4.662674197594956e-18, -1.195348791757899e-19,
  1.093436342965494e-05, -2.345396932099173e-06,  2.692838231064706e-07, -2.166200393601313e-08,  1.362863038144462e-09, -7.116921466698992e-11,  3.201020985674604e-12,
 -1.271595942916926e-13,  4.542868167014904e-15, -1.479584471906992e-16,  4.439871186899307e-18, -1.237110562995576e-19,  3.278517390741082e-06, -8.050898879441872e-07,
  1.050843962330009e-07, -9.530758359223032e-09,  6.710484125586072e-10, -3.896106609476007e-11,  1.937132235547998e-12, -8.462877038281980e-14,  3.309679500137749e-15,
 -1.175049733543817e-16,  3.828924741599034e-18, -1.154309897546005e-19,  9.764946561596020e-07, -2.707822645726706e-07,  3.975509972155816e-08, -4.028850710395219e-09,
  3.149559295264694e-10, -2.018685502141403e-11,  1.102262952429747e-12, -5.263722555865462e-14,  2.240547265635346e-15, -8.624189444880711e-17,  3.035761770336252e-18,
 -9.852480376972669e-20,  2.951579332409605e-07, -9.116391702315775e-08,  1.488789297854130e-08, -1.669624322257556e-09,  1.436703968453257e-10, -1.008537682811659e-11,
  6.003633777631639e-13, -3.112370601080174e-14,  1.432624932344322e-15, -5.941785165937147e-17,  2.246158962383246e-18, -7.803625494867011e-20,  9.259965640357899e-08,
 -3.141509223938084e-08,  5.639389229271697e-09, -6.925034493491799e-10,  6.496311523871477e-11, -4.950312322094680e-12,  3.186048353136959e-13, -1.779115874688674e-14,
  8.790455388270310e-16, -3.900831758896384e-17,  1.573010607678976e-18, -5.812477148847598e-20,  3.081082100531699e-08, -1.131860986784298e-08,  2.205098019624799e-09,
 -2.930628487987827e-10,  2.964967920538599e-11, -2.428042331852173e-12,  1.673655177424418e-13, -9.977243273548596e-15,  5.246847490452032e-16, -2.471123427573305e-17,
  1.054784942393864e-18, -4.114837111235676e-20,  1.105206084230810e-08, -4.332494699524435e-09,  9.035178259559706e-10, -1.283013329657835e-10,  1.383158926630082e-11,
 -1.203515071550015e-12,  8.790087796209264e-14, -5.537479452620733e-15,  3.069570106450332e-16, -1.520250972494642e-17,  6.808462001194936e-19, -2.780563371145931e-20,
  4.280656685247379e-09, -1.764052034644048e-09,  3.880202667462095e-10, -5.804939828510630e-11,  6.579994192681678e-12, -6.006931314654881e-13,  4.593112643637769e-14,
 -3.022980220048920e-15,  1.747219137438487e-16, -9.005592928952897e-18,  4.189830306637715e-19, -1.774414020639510e-20,  1.717650196468878e-09, -7.328777164710214e-10,
  1.673770511989618e-10, -2.598279760526833e-11,  3.052016274235132e-12, -2.882979637292593e-13,  2.277568404721764e-14, -1.546462177345300e-15,  9.208317363260269e-17,
 -4.883051613234216e-18,  2.334356178391822e-19, -1.014520186899860e-20,  5.668857159021720e-10, -2.466074039715606e-10,  5.752474026549323e-11, -9.118067231225716e-12,
  1.092828781941009e-12, -1.052442224423459e-13,  8.469450104838799e-15, -5.853193614188565e-16,  3.544532962096261e-17, -1.910140635099632e-18,  9.273035284945481e-20,
 -4.089585551839764e-21,  1.105198195422444e-01, -5.213821705496630e-04,  2.610865023486618e-06, -1.365526766192375e-08,  7.336184378080847e-11, -3.999374128480597e-13,
  2.192269547914491e-15, -1.202948974433647e-17,  6.581840570544862e-20, -3.589846377013543e-22,  1.947210359485079e-24, -1.052427864689505e-26,  9.797968037546521e-02,
 -6.608761751439057e-04,  5.434324885428350e-06, -4.477177602540736e-08,  3.559515771540598e-10, -2.733808780903022e-12,  2.039958494609095e-14, -1.486143056468775e-16,
  1.060709086488442e-18, -7.436563892459214e-21,  5.131381573429708e-23, -3.490327260645335e-25,  7.704307431872910e-02, -8.333874036348961e-04,  1.012609747434962e-05,
 -1.119499412647873e-07,  1.150355287382620e-09, -1.119674648221825e-11,  1.043809053841572e-13, -9.387538870614182e-16,  8.187098528208242e-18, -6.951096633281007e-20,
  5.763029948682499e-22, -4.676911597319297e-24,  5.378433534903558e-02, -9.125935516281291e-04,  1.487676597651679e-05, -2.097719077194422e-07,  2.691149281935399e-09,
 -3.217170264424455e-11,  3.634977344865480e-13, -3.919124670432994e-15,  4.060214543180171e-17, -4.062990389345020e-19,  3.943099363175109e-21, -3.722955792905078e-23,
  3.338606427777793e-02, -8.428466584686383e-04,  1.768642064299492e-05, -3.110699118557102e-07,  4.877654466893619e-09, -7.016356246016222e-11,  9.423422587487879e-13,
 -1.195851534271336e-14,  1.446186056068427e-16, -1.677336716482411e-18,  1.875028353093530e-20, -2.027873619916305e-22,  1.846713441339059e-02, -6.595093174017750e-04,
  1.744738830659297e-05, -3.765828476575711e-07,  7.104897118651742e-09, -1.212024240829414e-10,  1.908923977701158e-12, -2.814981002692612e-14,  3.925639478862471e-16,
 -5.215883417314556e-18,  6.640841196103580e-20, -8.137942978779455e-22,  9.128948247386493e-03, -4.422099830908469e-04,  1.453620806705975e-05, -3.799355302945568e-07,
  8.521557395436237e-09, -1.705153358322318e-10,  3.117387109106204e-12, -5.290755154236859e-14,  8.430723563088613e-16, -1.272023797656939e-17,  1.829074811906212e-19,
 -2.519040644804431e-21,  4.048375396054607e-03, -2.570883666325600e-04,  1.037005418504792e-05, -3.245750333789474e-07,  8.570866986305843e-09, -1.994161519451864e-10,
  4.197790212851265e-12, -8.137342633924976e-14,  1.470967090331880e-15, -2.502891106090172e-17,  4.037636616824550e-19, -6.209323658248383e-21,  1.618469891844496e-03,
 -1.310545482297693e-04,  6.411702236999206e-06, -2.380086705666348e-07,  7.339215442933798e-09, -1.971069623409773e-10,  4.745461232516615e-12, -1.044109383811785e-13,
  2.128404460402020e-15, -4.060979321230630e-17,  7.309499835777522e-19, -1.248579362911115e-20,  5.869404829970405e-04, -5.922555193759606e-05,  3.475967561621721e-06,
 -1.517190401842298e-07,  5.423970722192514e-09, -1.670793699441421e-10,  4.573985256838701e-12, -1.136112214634240e-13,  2.598369601536506e-15, -5.532235041899595e-17,
  1.105849995235843e-18, -2.088657224174201e-20,  1.946044767264923e-04, -2.399841492056746e-05,  1.672088501930506e-06, -8.513692573659393e-08,  3.505550840090942e-09,
 -1.231429847532784e-10,  3.813352358940556e-12, -1.064114596685027e-13,  2.718058769641588e-15, -6.429768108735865e-17,  1.421405273330642e-18, -2.956489896098533e-20,
  5.957074595033776e-05, -8.827201107873703e-06,  7.228959494831446e-07, -4.261340586345454e-08,  2.008315583169778e-09, -8.001413321635189e-11,  2.789034406284788e-12,
 -8.703981743316315e-14,  2.472446130595639e-15, -6.472008779391518e-17,  1.576155766646478e-18, -3.596737153780117e-20,  1.704114594423808e-05, -2.988511301749929e-06,
  2.848968451715472e-07, -1.929980465610116e-08,  1.034698396494659e-09, -4.650484448843520e-11,  1.815822205477210e-12, -6.309301424761758e-14,  1.984770230880715e-15,
 -5.726267346680940e-17,  1.530431587152688e-18, -3.817439681930599e-20,  4.623763340096707e-06, -9.462588749768028e-07,  1.040111242483970e-07, -8.036955371418028e-09,
  4.870773387288139e-10, -2.456046974816213e-11,  1.068893921614056e-12, -4.116112956563906e-14,  1.427779678608411e-15, -4.521596262351258e-17,  1.321025726187206e-18,
 -3.588135392880850e-20,  1.211439924888503e-06, -2.854475830492399e-07,  3.582957114389851e-08, -3.133427501488352e-09,  2.132473156163745e-10, -1.199270640719703e-11,
  5.786434013534429e-13, -2.457270512412980e-14,  9.355069606393067e-16, -3.237606870050484e-17,  1.029626480347287e-18, -3.032896347013280e-20,  3.130529795429973e-07,
 -8.380615878177855e-08,  1.189272869377567e-08, -1.167361935268891e-09,  8.856731212265890e-11, -5.519150136216456e-12,  2.934735102743007e-13, -1.366743472969657e-14,
  5.681050580479335e-16, -2.137924332366187e-17,  7.365737036858310e-19, -2.342174887292964e-20,  8.175456319305634e-08, -2.453276805056620e-08,  3.894060174178390e-09,
 -4.251053395143682e-10,  3.566441910581720e-11, -2.444478391839424e-12,  1.422710193181452e-13, -7.219923187051644e-15,  3.256851550642604e-16, -1.325108818675471e-17,
  4.918740290112046e-19, -1.679502037468597e-20,  2.216091718436782e-08, -7.351001412541373e-09,  1.290057725868061e-09, -1.550325839011238e-10,  1.424958092078914e-11,
 -1.065109646176377e-12,  6.731311249072593e-14, -3.694549290972237e-15,  1.795850130530117e-16, -7.846557718593949e-18,  3.117825460173620e-19, -1.136063486879464e-20,
  6.406509936769780e-09, -2.315178922835272e-09,  4.435069216367591e-10, -5.799641582150976e-11,  5.778093077969722e-12, -4.663378241999645e-13,  3.170503803679696e-14,
 -1.865550927524268e-15,  9.690000784071749e-17, -4.510478722184792e-18,  1.903925743533815e-19, -7.349274535806098e-21,  2.021428279493332e-09, -7.838080273831445e-10,
  1.616001330473545e-10, -2.269501925792272e-11,  2.420983118695658e-12, -2.085571048111344e-13,  1.508850973326051e-14, -9.420170978016395e-16,  5.177480919579671e-17,
 -2.543539288261113e-18,  1.130394811977561e-19, -4.582938053196613e-21,  7.025103873316740e-10, -2.876696929702166e-10,  6.284870948132095e-11, -9.340607719710622e-12,
  1.052112271145090e-12, -9.547304723337752e-14,  7.258669156019165e-15, -4.751509482014075e-16,  2.732171294194674e-17, -1.401354636267683e-18,  6.489505566653464e-20,
 -2.736228713871002e-21,  2.599471726580414e-10, -1.105816015995590e-10,  2.517333764015916e-11, -3.895385551893249e-12,  4.561664941974572e-13, -4.296436319094493e-14,
  3.384752064295931e-15, -2.292132994122623e-16,  1.361381000273864e-17, -7.201792275224899e-19,  3.434902406359550e-20, -1.489546187353280e-21,  8.182189718922489e-11,
 -3.555699463717305e-11,  8.284593184370498e-12, -1.311653679357115e-12,  1.570294419560230e-13, -1.510620489800350e-14,  1.214385826178635e-15, -8.384068168163085e-17,
  5.072206756712350e-18, -2.730827448770134e-19,  1.324512701546637e-20, -5.836245434106967e-22,  1.084750542922754e-01, -5.011313386716807e-04,  2.453789547073757e-06,
 -1.254271981467915e-08,  6.586313856170063e-11, -3.511382782942811e-13,  1.883089809569401e-15, -1.011590364260414e-17,  5.419222507532838e-20, -2.896122822464107e-22,
  1.538643729531068e-24, -8.154677523038807e-27,  9.541985363439244e-02, -6.194577917992172e-04,  4.929513072297990e-06, -3.948870797440355e-08,  3.058530667801011e-10,
 -2.290551540548986e-12,  1.667599495181036e-14, -1.185871035187209e-16,  8.265189548949127e-19, -5.660744380303508e-21,  3.816951038607132e-23, -2.537857815714029e-25,
  7.386345442870680e-02, -7.574555014266346e-04,  8.886160140710431e-06, -9.520805584562797e-08,  9.494864186220527e-10, -8.979584075610373e-12,  8.141695734867298e-14,
 -7.127291190964434e-16,  6.054464862512472e-18, -5.009834062210372e-20,  4.050096366450798e-22, -3.206376076760787e-24,  5.035701932788695e-02, -8.029624792929362e-04,
  1.259805956268249e-05, -1.714218222328979e-07,  2.126771254641346e-09, -2.463026666123504e-11,  2.699529140134261e-13, -2.826379711358850e-15,  2.845983420152968e-17,
 -2.770140914851846e-19,  2.616711355129763e-21, -2.406170970047986e-23,  3.027576088269125e-02, -7.150591215021537e-04,  1.437921915256650e-05, -2.431298997846464e-07,
  3.675906859570470e-09, -5.109348941211465e-11,  6.641543280231127e-13, -8.167919885327784e-15,  9.583095544609895e-17, -1.079331187220953e-18,  1.172598655585370e-20,
 -1.233406915283904e-22,  1.608213931591141e-02, -5.362429448549176e-04,  1.353785868850340e-05, -2.800521471201583e-07,  5.081808178118543e-09, -8.358384071305029e-11,
  1.271655720839192e-12, -1.814210405315219e-14,  2.450792554841671e-16, -3.157778719026963e-18,  3.902552838901010e-20, -4.646043488155783e-22,  7.566773573573992e-03,
 -3.420744284887064e-04,  1.069442383514246e-05, -2.672617884003136e-07,  5.753557019336330e-09, -1.108039660466596e-10,  1.953767501758024e-12, -3.203558390259076e-14,
  4.938954491582632e-16, -7.218638208527335e-18,  1.006583010886113e-19, -1.345648988158573e-21,  3.164207209054705e-03, -1.876472991437747e-04,  7.182166256304727e-06,
 -2.145624715991683e-07,  5.429782154521526e-09, -1.214246973327363e-10,  2.462340379581189e-12, -4.606801736279848e-14,  8.049898779513124e-16, -1.325827138752969e-17,
  2.072740306736789e-19, -3.092421569628145e-21,  1.181218763996984e-03, -8.945290604246421e-05,  4.147700371593523e-06, -1.468012933354350e-07,  4.333883602697282e-09,
 -1.117745063173657e-10,  2.590458997130518e-12, -5.497439074976443e-14,  1.082708827766406e-15, -1.998759677422193e-17,  3.485329051198465e-19, -5.774302037465110e-21,
  3.959140840559293e-04, -3.744497194744126e-05,  2.082494078657358e-06, -8.663715864378434e-08,  2.964202290804812e-09, -8.765571081979321e-11,  2.309359997366072e-12,
 -5.531562466125812e-14,  1.222126201817800e-15, -2.517470378695814e-17,  4.875195418745423e-19, -8.931511228110269e-21,  1.200284990358123e-04, -1.391403600693551e-05,
  9.194163470223409e-07, -4.463857378291517e-08,  1.759522955475746e-09, -5.934975628899245e-11,  1.769141982499046e-12, -4.762041403410322e-14,  1.175406042245545e-15,
 -2.691082542803921e-17,  5.765732253939567e-19, -1.163771307239874e-20,  3.322593013518915e-05, -4.644752726743664e-06,  3.613754814689853e-07, -2.033732450863310e-08,
  9.184327214501551e-10, -3.516625572444382e-11,  1.180895957882401e-12, -3.557696774909479e-14,  9.773414584959315e-16, -2.478048751593346e-17,  5.853697359452551e-19,
 -1.297357655379620e-20,  8.499073931411335e-06, -1.412124156307202e-06,  1.282307854236345e-07, -8.309907492088234e-09,  4.276240542660516e-10, -1.849912201114585e-11,
  6.968503643513589e-13, -2.340603079490483e-14,  7.130093113048095e-16, -1.995112419986549e-17,  5.178732799820231e-19, -1.256183824173608e-20,  2.039332600661732e-06,
 -3.973605629402165e-07,  4.174928907397991e-08, -3.094729718607683e-09,  1.804662184793252e-10, -8.778079015996320e-12,  3.693201042035668e-13, -1.377464549886749e-14,
  4.635564480150962e-16, -1.426355593072849e-17,  4.054384493110813e-19, -1.072761224879712e-20,  4.676416176371068e-07, -1.054937341461391e-07,  1.271120505649579e-08,
 -1.070264200268647e-09,  7.030848251886091e-11, -3.825342568696360e-12,  1.789145377705883e-13, -7.377712546646984e-15,  2.731626334857981e-16, -9.206790715164225e-18,
  2.855105722369194e-19, -8.210564724755292e-21,  1.048339082234133e-07, -2.703253233259166e-08,  3.700806537179905e-09, -3.512607742354976e-10,  2.582533470794629e-11,
 -1.562543403631831e-12,  8.080967535946222e-14, -3.665935710918782e-15,  1.486389371723898e-16, -5.463226217960767e-18,  1.840454906950725e-19, -5.728653372250059e-21,
  2.360252442924225e-08, -6.866292339453952e-09,  1.057295136355552e-09, -1.121648691761513e-10,  9.160360168601793e-12, -6.121711694661022e-13,  3.478893030199260e-14,
 -1.726098976766662e-15,  7.621824731445685e-17, -3.038892121000298e-18,  1.106512903079080e-19, -3.709691207593704e-21,  5.503541727066635e-09, -1.781547392057233e-09,
  3.051133837980002e-10, -3.582602855201462e-11,  3.221586112773797e-12, -2.358826809862047e-13,  1.461967323241669e-14, -7.877666544489148e-16,  3.762954763404790e-17,
 -1.617156348966408e-18,  6.325572848017808e-20, -2.270769768654762e-21,  1.373433842749233e-09, -4.874897834421899e-10,  9.168805904591428e-11, -1.178091920477164e-11,
  1.154328811551851e-12, -9.170834870715529e-14,  6.142906970511603e-15, -3.564009252658823e-16,  1.826691030583708e-17, -8.396022463629808e-19,  3.501783763650658e-20,
 -1.336417226807579e-21,  3.781836194243244e-10, -1.448837099229919e-10,  2.949833247837798e-11, -4.092818860639482e-12,  4.315954974303355e-13, -3.677613575212035e-14,
  2.633274853677205e-15, -1.628004893052150e-16,  8.865139475978534e-18, -4.317018561002208e-19,  1.902603899719802e-20, -7.652874921552429e-22,  1.169585391558547e-10,
 -4.755686903181012e-11,  1.031257209640303e-11, -1.521557980958483e-12,  1.702001711492945e-13, -1.534311101431661e-14,  1.159234758645003e-15, -7.543412903507722e-17,
  4.313186884834187e-18, -2.200475859788597e-19,  1.013852426296467e-20, -4.254264919589368e-22,  3.962394709686027e-11, -1.680028745298908e-11,  3.810844512826150e-12,
 -5.876372975240372e-13,  6.858371933735999e-14, -6.438892407423708e-15,  5.057093152070831e-16, -3.414671940756621e-17,  2.022481617550683e-18, -1.067083776426150e-19,
  5.076674972448634e-21, -2.196239051684403e-22,  1.184048058412352e-11, -5.139614474419598e-12,  1.196002612259900e-12, -1.891206563046990e-13,  2.261383896229195e-14,
 -2.172899294311412e-15,  1.744818080335546e-16, -1.203304297011795e-17,  7.272139409774971e-19, -3.911296499941446e-20,  1.895220414334760e-21, -8.343159432464019e-23,
  1.065088609309300e-01, -4.820856763133681e-04,  2.309375718598171e-06, -1.154272907031945e-08,  5.927034503698463e-11, -3.091563331202357e-13,  1.622636035817896e-15,
 -8.537358003390095e-18,  4.479275555548717e-20, -2.346764296736584e-22,  1.221259093005755e-24, -6.352417135959876e-27,  9.301800656324131e-02, -5.818372989233430e-04,
  4.483566186091827e-06, -3.494087914636608e-08,  2.637900028432416e-10, -1.927362515828344e-12,  1.369718152284119e-14, -9.512492876535368e-17,  6.477233860773722e-19,
 -4.335632865658034e-21,  2.858006027518122e-23, -1.858324329007011e-25,  7.096892261033470e-02, -6.906909380366542e-04,  7.829213910696748e-06, -8.135325048541756e-08,
  7.879247975699739e-10, -7.244722287810841e-12,  6.392260105036753e-14, -5.449724740900536e-16,  4.511491875320711e-18, -3.640023553134684e-20,  2.870748941804797e-22,
 -2.218105489376215e-24,  4.733448035288661e-02, -7.098630458973303e-04,  1.072998273473349e-05, -1.410074731787862e-07,  1.693039621178602e-09, -1.900669001555510e-11,
  2.021979558128036e-13, -2.056925894886658e-15,  2.014158600174874e-17, -1.907899049964209e-19,  1.755015505314957e-21, -1.572433803522646e-23,  2.762842983314214e-02,
 -6.107681544276583e-04,  1.178343269945214e-05, -1.916962452922680e-07,  2.796558796502340e-09, -3.758459277498716e-11,  4.731322658336769e-13, -5.642137813648377e-15,
  6.425620973179913e-17, -7.031260107105897e-19,  7.427447078568933e-21, -7.601764902951848e-23,  1.413428582220435e-02, -4.401173976387234e-04,  1.061485637973138e-05,
 -2.106164074688106e-07,  3.678353011741294e-09, -5.836882557803906e-11,  8.583191896861772e-13, -1.185305338635274e-14,  1.551847738531044e-16, -1.939920043021822e-18,
  2.328156399144304e-20, -2.693812344364432e-22,  6.351281207955224e-03, -2.679358993920537e-04,  7.973983782191527e-06, -1.906614691666132e-07,  3.942028829325864e-09,
 -7.310653398343060e-11,  1.243903961351330e-12, -1.971444576788254e-14,  2.941925682237596e-16, -4.166941901799694e-18,  5.636803933517350e-20, -7.317200901107048e-22,
  2.514091481259900e-03, -1.391777542779684e-04,  5.057852772121736e-06, -1.442943493008046e-07,  3.501128765839563e-09, -7.528631426841275e-11,  1.471350027084667e-12,
 -2.657787961508803e-14,  4.490879407955581e-16, -7.161803481541376e-18,  1.085371859668789e-19, -1.571388352383568e-21,  8.800784488607602e-04, -6.228923886628791e-05,
  2.738031323635401e-06, -9.242569678779193e-08,  2.613148486640229e-09, -6.473949971357413e-11,  1.444700109360079e-12, -2.957903495238638e-14,  5.629559140604834e-16,
 -1.005730350802593e-17,  1.699290000099952e-19, -2.730973069296936e-21,  2.738540717802938e-04, -2.425333681535535e-05,  1.278045089061314e-06, -5.068006794635062e-08,
  1.659599279143611e-09, -4.711762848327496e-11,  1.194741055334407e-12, -2.759908682243502e-14,  5.890887660600967e-16, -1.174087825417757e-17,  2.202808282668839e-19,
 -3.914543135059077e-21,  7.626366882382897e-05, -8.299965689049488e-06,  5.198928571632380e-07, -2.406216290676569e-08,  9.077948716370152e-10, -2.939829158867462e-11,
  8.434513417197747e-13, -2.189727575016376e-14,  5.222275303489930e-16, -1.157045823053894e-17,  2.402312148344421e-19, -4.704792211393693e-21,  1.917631694564725e-05,
 -2.525030547291366e-06,  1.864829289952937e-07, -1.001338866604632e-08,  4.331109640004612e-10, -1.593121958239096e-11,  5.152023277439609e-13, -1.497904775866337e-14,
  3.978256559861830e-16, -9.767296509946792e-18,  2.237300842971160e-19, -4.814417833515314e-21,  4.404134269041177e-06, -6.919982613212302e-07,  5.978463462804126e-08,
 -3.702810950933000e-09,  1.827550400669170e-10, -7.604514166481850e-12,  2.761909481709998e-13, -8.962590266500532e-15,  2.642463328827762e-16, -7.167568375126332e-18,
  1.806049514598883e-19, -4.258183818787867e-21,  9.376593030135274e-07, -1.735870151188817e-07,  1.740671284646385e-08, -1.236281664130327e-09,  6.929448742893961e-11,
 -3.248324711248524e-12,  1.320071004769026e-13, -4.764921075094463e-15,  1.554545415556491e-16, -4.644267293237812e-18,  1.283511199169306e-19, -3.306109147236490e-21,
  1.885948784228363e-07, -4.063973978718906e-08,  4.692303272440645e-09, -3.798110168441281e-10,  2.405294729260623e-11, -1.264586924881081e-12,  5.727139419554830e-14,
 -2.290943329929658e-15,  8.241633260578222e-17, -2.702880136631031e-18,  8.166479723441878e-20, -2.290925022792653e-21,  3.669637935447314e-08, -9.093334062658645e-09,
  1.198661285109206e-09, -1.098270430650086e-10,  7.813106791300910e-12, -4.583608901007016e-13,  2.302668940708423e-14, -1.016373707743680e-15,  4.015473851976449e-17,
 -1.440003200159959e-18,  4.738845743007032e-20, -1.442534172643191e-21,  7.111728767396105e-09, -2.001165843741519e-09,  2.983434071827695e-10, -3.070298844534186e-11,
  2.437048998862414e-12, -1.585637863037861e-13,  8.786768660706380e-15, -4.257184079284079e-16,  1.837971998959851e-17, -7.173380235473888e-19,  2.559509102260903e-20,
 -8.417235874568843e-22,  1.420929658888295e-09, -4.479502171686791e-10,  7.472763805390982e-11, -8.558634993179668e-12,  7.517852585128692e-13, -5.384364774468214e-14,
  3.268426870964415e-15, -1.726884161160122e-16,  8.096898926974081e-18, -3.418911834615742e-19,  1.315136405535388e-20, -4.646773720182212e-22,  3.041978890152383e-10,
 -1.058683978260162e-10,  1.951828472313802e-11, -2.460509071414363e-12,  2.367795578282650e-13, -1.849411663133888e-14,  1.219053021193057e-15, -6.966188885791928e-17,
  3.519526233741032e-18, -1.595819158405781e-19,  6.570441031458307e-21, -2.477056560494445e-22,  7.251063784914731e-11, -2.741177628216489e-11,  5.504562012988379e-12,
 -7.536682936791132e-13,  7.848010306144300e-14, -6.607993529081265e-15,  4.678466386973195e-16, -2.861755373967997e-17,  1.542693693458907e-18, -7.440911695899667e-20,
  3.249777351393499e-21, -1.295990397397104e-22,  1.978128212186333e-11, -7.980616940295244e-12,  1.716312269454808e-12, -2.512078192808169e-13,  2.788578007255955e-14,
 -2.495658207015619e-15,  1.872656555253422e-16, -1.210674812699844e-17,  6.879853931603188e-19, -3.489457419582866e-20,  1.598845376960846e-21, -6.673814264253481e-23,
  6.087977644004735e-12, -2.571781698542212e-12,  5.810568808796401e-13, -8.925358313013850e-14,  1.037829016361663e-14, -9.709128807414138e-16,  7.599929616394647e-17,
 -5.115279421004484e-18,  3.020544314893170e-19, -1.589073428103210e-20,  7.539288159335473e-22, -3.253091062884857e-23,  1.718267445929938e-12, -7.449265904280058e-13,
  1.731103778114588e-13, -2.733648986100278e-14,  3.264432317869162e-15, -3.132726729495423e-16,  2.512482964498986e-17, -1.730687510518923e-18,  1.044756412537646e-19,
 -5.613087674128213e-21,  2.716981834527875e-22, -1.194872347157294e-23,  1.046166131468664e-01, -4.641490565887739e-04,  2.176355518442095e-06, -1.064183110401370e-08,
  5.345809344168918e-11, -2.729271321900497e-13,  1.402451279441698e-15, -7.230255638499664e-18,  3.716033406703551e-20, -1.909840239447224e-22,  9.733776125708010e-25,
 -4.975528900259848e-27,  9.075983649352776e-02, -5.475769986323935e-04,  4.088382897411441e-06, -3.101162120228275e-08,  2.283258529126846e-10, -1.628386677943208e-12,
  1.130188428253260e-14, -7.668950650166324e-17,  5.103913627720719e-19, -3.340420541509476e-21,  2.153560140946632e-23, -1.369966818230682e-25,  6.832553213055545e-02,
 -6.317583622721838e-04,  6.924090676167798e-06, -6.982716362129164e-08,  6.572152252115160e-10, -5.878513119264883e-12,  5.050228297985783e-14, -4.195326293481628e-16,
  3.386259863872666e-18, -2.665301676611463e-20,  2.051563934666513e-22, -1.547751231528798e-24,  4.465660540823734e-02, -6.303583052680720e-04,  9.188684010295499e-06,
 -1.167145918842964e-07,  1.357119359259280e-09, -1.477812772433466e-11,  1.526841993192534e-13, -1.509986796371972e-15,  1.438622185396697e-17, -1.326828658000001e-19,
  1.189095661965700e-21, -1.038543424512074e-23,  2.536032652620896e-02, -5.249948194925076e-04,  9.728602764241813e-06, -1.523976884321741e-07,  2.146730862315802e-09,
 -2.791431595405155e-11,  3.405077012708055e-13, -3.939554734651852e-15,  4.357339992414260e-17, -4.634700018764657e-19,  4.762572033953134e-21, -4.744885749074842e-23,
  1.252895112574369e-02, -3.643895929845675e-04,  8.405397791854012e-06, -1.600860360915128e-07,  2.692738323450798e-09, -4.124927681047038e-11,  5.866162950024320e-13,
 -7.845664943139077e-15,  9.960103468222542e-17, -1.208536146594975e-18,  1.409089172286002e-20, -1.585230534896226e-22,  5.394010537446330e-03, -2.123249911739005e-04,
  6.021014530911460e-06, -1.378341789467381e-07,  2.738684442066880e-09, -4.893757135931790e-11,  8.039186914474767e-13, -1.232128711671571e-14,  1.780494879752504e-16,
 -2.444955511629988e-18,  3.209772111110525e-20, -4.047353864659849e-22,  2.028547598006151e-03, -1.047918710498941e-04,  3.618327832851526e-06, -9.863004570555358e-08,
  2.295728704964669e-09, -4.749149006612361e-11,  8.948736493233208e-13, -1.561315081124389e-14,  2.551992385826210e-16, -3.941937321728095e-18,  5.792915063401109e-20,
 -8.140955127094651e-22,  6.685932270225107e-04, -4.419807274734040e-05,  1.842469812787455e-06, -5.933858683936698e-08,  1.607255939600643e-09, -3.826247634217874e-11,
  8.224087452049498e-13, -1.624938642796658e-14,  2.989342370077246e-16, -5.169394021450604e-18,  8.464802747786237e-20, -1.319896025676640e-21,  1.939919497868200e-04,
 -1.607286982029474e-05,  8.025192797518013e-07, -3.033624181505968e-08,  9.509387001570916e-10, -2.592415660400733e-11,  6.327533570203379e-13, -1.409855580939781e-14,
  2.907541674699974e-16, -5.607347741228346e-18,  1.019330224805293e-19, -1.757179069074247e-21,  4.985093211679998e-05, -5.087338430254236e-06,  3.019576900613376e-07,
 -1.332014842450132e-08,  4.809332249626466e-10, -1.495195934778142e-11,  4.128613650680574e-13, -1.033733829399348e-14,  2.381916874899673e-16, -5.106689513622305e-18,
  1.027392720600679e-19, -1.952124953919698e-21,  1.143803764664229e-05, -1.416469906458996e-06,  9.922720023426310e-08, -5.081130977841469e-09,  2.104142899305791e-10,
 -7.432852446953010e-12,  2.314207318069153e-13, -6.491441509395778e-15,  1.666361371064615e-16, -3.960587319661764e-18,  8.794900795717339e-20, -1.837094884505174e-21,
  2.368723456407831e-06, -3.513287860228065e-07,  2.884548996159783e-08, -1.706059857023900e-09,  8.070600100607587e-11, -3.228213619532992e-12,  1.129838469684310e-13,
 -3.540462853755432e-15,  1.009808905666875e-16, -2.653976965839054e-18,  6.488844445810257e-20, -1.486422438372046e-21,  4.491367845226137e-07, -7.883590055547590e-08,
  7.533999184438540e-09, -5.120925915124034e-10,  2.756189964699805e-11, -1.244079777407420e-12,  4.879512647059101e-14, -1.703324042165321e-15,  5.383582021638347e-17,
 -1.560593368267608e-18,  4.190692117076863e-20, -1.050220639568732e-21,  7.945032400697911e-08, -1.631672854226946e-08,  1.802126287082567e-09, -1.400273965956983e-10,
  8.537860416981299e-12, -4.332675816738018e-13,  1.898063815203134e-14, -7.358219172983820e-16,  2.569698757478448e-17, -8.193226812795985e-19,  2.409949995969568e-20,
 -6.589843517507560e-22,  1.343413692905288e-08, -3.191427451003012e-09,  4.042730436448714e-10, -3.569759734768784e-11,  2.453617010494225e-12, -1.393816282322349e-13,
  6.793410790065986e-15, -2.914170145596486e-16,  1.120651951000581e-17, -3.917160966937850e-19,  1.258058600813138e-20, -3.741864410283623e-22,  2.239181593450391e-09,
 -6.080077763823477e-10,  8.758232415918847e-11, -8.727774415986231e-12,  6.722232522379137e-13, -4.252004084025850e-14,  2.294497623609476e-15, -1.084185366422012e-16,
  4.571231268268314e-18, -1.744487157788872e-19,  6.093128404056485e-21, -1.963617848912715e-22,  3.820859537379227e-10, -1.170479692272264e-10,  1.898209912779609e-11,
 -2.116800169925136e-12,  1.813359993589561e-13, -1.268510248030858e-14,  7.531216493294231e-16, -3.896731512776733e-17,  1.791279030342451e-18, -7.423249095495185e-20,
  2.805150125364441e-21, -9.745733788143931e-23,  6.975698719991552e-11, -2.375963148321160e-11,  4.286310076005288e-12, -5.292821447526429e-13,  4.994999863336039e-14,
 -3.830404771863439e-15,  2.481480092679046e-16, -1.395027092317030e-17,  6.940002794753604e-19, -3.101028470680766e-20,  1.259199803746637e-21, -4.685250875167490e-23,
  1.427709383411880e-11, -5.318451458505066e-12,  1.051925048437783e-12, -1.419454606429479e-13,  1.457851404415902e-14, -1.211627391151886e-15,  8.473552610412546e-17,
 -5.123340213651089e-18,  2.731708768562649e-19, -1.303978696466495e-20,  5.639298659617344e-22, -2.228078804911732e-23,  3.404008469832310e-12, -1.361412569002032e-12,
  2.901133781755044e-13, -4.208754079921294e-14,  4.632756155133476e-15, -4.113129057363630e-16,  3.063120496620504e-17, -1.966211059124652e-18,  1.109801686684320e-19,
 -5.592982953081974e-21,  2.547164535331636e-22, -1.057137929253983e-23,  9.436099043318289e-13, -3.969848761600726e-13,  8.929954837511075e-14, -1.365822762283768e-14,
  1.581659938765604e-15, -1.473917192446302e-16,  1.149459326725156e-17, -7.709507530621092e-19,  4.537255831298141e-20, -2.379445260615408e-21,  1.125522561927097e-22,
 -4.842611692811217e-24,  2.501162036914839e-13, -1.082869132806304e-13,  2.512697051298819e-14, -3.962057157047171e-15,  4.724610424044826e-16, -4.527765109148383e-17,
  3.626525504178113e-18, -2.494911816805512e-19,  1.504258004583281e-20, -8.072362444234270e-22,  3.902984743189727e-23, -1.714600570805666e-24,  1.027940498251661e-01,
 -4.472348830326744e-04,  2.053611131785098e-06, -9.828407646962717e-09,  4.832040932432903e-11, -2.415693900685574e-13,  1.215669540152263e-15, -6.144025260925564e-18,
  3.093603261669405e-20, -1.560963074588211e-22,  7.786866676983933e-25, -3.920082130325629e-27,  8.863267027233514e-02, -5.162987715315742e-04,  3.737133810907319e-06,
 -2.760491001401725e-08,  1.983057271989026e-10, -1.381169005008090e-12,  9.366275513070293e-15, -6.212591189322393e-17,  4.042929318681920e-19, -2.588323177635781e-21,
  1.632623555794408e-23, -1.016538174270959e-25,  6.590421837376026e-02, -5.795471046318910e-04,  6.145580471045037e-06, -6.019021161734613e-08,  5.508737270237246e-10,
 -4.796009664855376e-12,  4.013873297580571e-14, -3.250647569351939e-16,  2.559419277074507e-18, -1.966114563584783e-20,  1.477706767192611e-22, -1.088977360065920e-24,
  4.227381388754492e-02, -5.621032340978974e-04,  7.909246597984918e-06, -9.717957500771950e-08,  1.095027611083063e-09, -1.157314811533493e-11,  1.161921329324954e-13,
 -1.117697387248853e-15,  1.036611863964291e-17, -9.313208030356430e-20,  8.135377487618539e-22, -6.929358977335119e-24,  2.340519449231765e-02, -4.539368959424665e-04,
  8.088835463805261e-06, -1.221071182841539e-07,  1.661984840780013e-09, -2.092245685216999e-11,  2.474530084971771e-13, -2.779123345954039e-15,  2.986805048860462e-17,
 -3.089573597281567e-19,  3.089802448827788e-21, -2.997870989586233e-23,  1.119466976528617e-02, -3.041561908253512e-04,  6.717932047942915e-06, -1.229058498046080e-07,
  1.992450631166443e-09, -2.948309612058262e-11,  4.057215019935177e-13, -5.258078528743171e-15,  6.475754194788550e-17, -7.630408066336855e-19,  8.647007336471345e-21,
 -9.462292165605394e-23,  4.631532912981427e-03, -1.700961063363090e-04,  4.600720318474896e-06, -1.009036057155464e-07,  1.927940783862464e-09, -3.321290972503771e-11,
  5.270403241355930e-13, -7.815279179524301e-15,  1.094112035867543e-16, -1.457196102947702e-18,  1.857283844408789e-20, -2.275716509209642e-22,  1.660572586799349e-03,
 -8.002033396886467e-05,  2.627223267729506e-06, -6.846367953505425e-08,  1.529523789924926e-09, -3.045445439982092e-11,  5.535248928609676e-13, -9.331878893416127e-15,
  1.476046429647588e-16, -2.209129314969750e-18,  3.149050129603905e-20, -4.296943516991821e-22,  5.173191548282830e-04, -3.192128034719601e-05,  1.262543715637875e-06,
 -3.880930690794883e-08,  1.007464539390451e-09, -2.305463936162392e-11,  4.774462007123832e-13, -9.106455502445419e-15,  1.619784537647379e-16, -2.711988230415633e-18,
  4.304826489423988e-20, -6.513896427238545e-22,  1.405544559286233e-04, -1.088484095433451e-05,  5.150113958346103e-07, -1.856141969999551e-08,  5.570745403156882e-10,
 -1.458555193415714e-11,  3.427457314634689e-13, -7.367224308575881e-15,  1.468198600699752e-16, -2.740211795853194e-18,  4.826928683164597e-20, -8.072510866373157e-22,
  3.347916206665348e-05, -3.199891851207758e-06,  1.799252973829154e-07, -7.564001478291372e-09,  2.613574774326036e-10, -7.800514020635677e-12,  2.072986658438208e-13,
 -5.005797763121388e-15,  1.114382079633926e-16, -2.311849690461096e-18,  4.506720627670413e-20, -8.307539102580276e-22,  7.041672847421944e-06, -8.189192362002276e-07,
  5.437922622246096e-08, -2.654420479530092e-09,  1.052079243084211e-10, -3.568209074682414e-12,  1.069347260734286e-13, -2.893346306036890e-15,  7.177301597249251e-17,
 -1.651104635065925e-18,  3.553702532071679e-20, -7.204023284514694e-22,  1.320826808849948e-06, -1.845974994915773e-07,  1.438873570880594e-08, -8.120597876542212e-10,
  3.679689395847382e-11, -1.414153086006787e-12,  4.767206741500502e-14, -1.441914447044300e-15,  3.976899641436497e-17, -1.012340924375991e-18,  2.400730057238883e-20,
 -5.341155202976421e-22,  2.239459267324559e-07, -3.719341041716471e-08,  3.382721449029153e-09, -2.198061568800640e-10,  1.134968611373146e-11, -4.928937695879364e-13,
  1.864476010729857e-14, -6.289968364173426e-16,  1.924752154694112e-17, -5.410498234040814e-19,  1.410901832002392e-20, -3.438167611098490e-22,  3.495263792402371e-08,
 -6.825525757167752e-09,  7.198856390626863e-10, -5.362030785370612e-11,  3.143952301124649e-12, -1.538305273057117e-13,  6.512340722059331e-15, -2.444502550490905e-16,
  8.280215547948677e-18, -2.564631254291018e-19,  7.338222752036032e-21, -1.954478212247978e-22,  5.145301106040278e-09, -1.168953241778651e-09,  1.420216223441033e-10,
 -1.206559048251339e-11,  8.000828817846591e-13, -4.395187698943505e-14,  2.075847819230941e-15, -8.644574449296153e-17,  3.232357942038408e-18, -1.100190787312579e-19,
  3.445197571179945e-21, -1.000346927811926e-22,  7.375041875307600e-10, -1.927610496480716e-10,  2.677269913469271e-11, -2.578743735330042e-12,  1.924133526921796e-13,
 -1.181440207894956e-14,  6.199874412277033e-16, -2.853469069430526e-17,  1.173556586264879e-18, -4.374288504064121e-20,  1.494052961927671e-21, -4.713643716646988e-23,
  1.071918900476179e-10, -3.183399271238657e-11,  5.008387733665268e-12, -5.427990819136127e-13,  4.527180464197654e-14, -3.088440718090027e-15,  1.790860463535674e-16,
 -9.062268016886457e-18,  4.079191778602035e-19, -1.657170750225862e-20,  6.145240447802636e-22, -2.097163097196676e-23,  1.659748470857291e-11, -5.521451073410118e-12,
  9.728552992250344e-13, -1.174699985157383e-13,  1.085481140984843e-14, -8.160635671831471e-16,  5.189043213022294e-17, -2.866287464823587e-18,  1.402434804483920e-19,
 -6.168871940917494e-21,  2.467925698615739e-22, -9.054265243211905e-24,  2.893079352256470e-12, -1.060324212581270e-12,  2.062520969280181e-13, -2.739100646139375e-14,
  2.771100805431972e-15, -2.270577333634603e-16,  1.566806912567785e-17, -9.354398340705550e-19,  4.928508393813723e-20, -2.326232360139820e-21,  9.953400745734383e-23,
 -3.893086291591364e-24,  5.970086815262236e-13, -2.364626677905017e-13,  4.987957711623072e-14, -7.165514227301522e-15,  7.814260500106463e-16, -6.876967581595907e-17,
  5.078999404964018e-18, -3.234704073164534e-19,  1.812290833517593e-20, -9.069410228907157e-22,  4.103065948320938e-23, -1.692222959891640e-24,  1.476809608453461e-13,
 -6.184696930872338e-14,  1.384423141073340e-14, -2.107398506378412e-15,  2.429358901687480e-16, -2.254123578452432e-17,  1.750742354887899e-18, -1.169694971509796e-19,
  6.858744249990552e-21, -3.584387452284362e-22,  1.689890553611613e-23, -7.248114415207548e-25,  3.652957193653031e-14, -1.579185769285766e-14,  3.658400557439979e-15,
 -5.759359964165086e-16,  6.857160467584841e-17, -6.561648034757529e-18,  5.248036235682508e-19, -3.605487345923921e-20,  2.170992685056505e-21, -1.163556001958034e-22,
  5.618963680220108e-24, -2.465570432537843e-25,  1.010372391957239e-01, -4.312649715628741e-04,  1.940154543392833e-06, -9.092403510101221e-09,  4.376740441861741e-11,
 -2.143508344269179e-13,  1.056692363794236e-15, -5.238294085421982e-18,  2.583799382762096e-20, -1.281444120808287e-22,  6.248009157220985e-25, -3.110137350954701e-27,
  8.662524483205832e-02, -4.876748204261882e-04,  3.424038677130740e-06, -2.464135799340636e-08,  1.727965574632264e-10, -1.175872574934024e-12,  7.794715610243064e-15,
 -5.056162153482447e-17,  3.218657299363077e-19, -2.016559430870271e-21,  1.244918366170380e-23, -7.590421789747421e-26,  6.367998712139401e-02, -5.331287179622888e-04,
  5.473177916797275e-06, -5.209418872727475e-08,  4.638947793159586e-10, -3.933262397658384e-12,  3.208475496760342e-14, -2.534348317176081e-16,  1.947407343961489e-18,
 -1.460690821198015e-20,  1.072423923402145e-22, -7.723084168928614e-25,  4.014496172573136e-02, -5.032126904288675e-04,  6.841039333895192e-06, -8.136932606947993e-08,
  8.890971715629639e-10, -9.125486680417010e-12,  8.907814452103871e-14, -8.338961165802899e-16,  7.532453957610665e-18, -6.595349006844648e-20,  5.618083835134021e-22,
 -4.668712928277380e-24,  2.171018689810120e-02, -3.946651236392108e-04,  6.770269124866248e-06, -9.856491308489775e-08,  1.297138849151458e-09, -1.581885131023728e-11,
  1.815025788731903e-13, -1.979811198770667e-15,  2.068546695843509e-17, -2.081871970882522e-19,  2.027187573584982e-21, -1.916283866506464e-23,  1.007690113304862e-02,
 -2.558118781636508e-04,  5.416464738515245e-06, -9.526102141148966e-08,  1.489347113333524e-09, -2.130151339345039e-11,  2.838097214106894e-13, -3.565961976420407e-15,
  4.262667173971847e-17, -4.879772431843842e-19,  5.377056171848387e-21, -5.725702392575530e-23,  4.017770315525884e-03, -1.376556779921588e-04,  3.555077646686378e-06,
 -7.475121576913280e-08,  1.374303419341102e-09, -2.283803690259924e-11,  3.502614362401924e-13, -5.027609022539654e-15,  6.821943429837961e-17, -8.816039244181941e-19,
  1.091345058487413e-20, -1.299885276086629e-22,  1.377855302275679e-03, -6.191478037058433e-05,  1.934510027244371e-06, -4.822231453021855e-08,  1.034591519258560e-09,
 -1.983725777536507e-11,  3.479436711680522e-13, -5.670591531045911e-15,  8.683031688863748e-17, -1.259622212849674e-18,  1.742268221590845e-20, -2.309038778861599e-22,
  4.072305075828334e-04, -2.344113642107718e-05,  8.801354841810314e-07, -2.583323127050730e-08,  6.429888321383137e-10, -1.414956960813342e-11,  2.824344801915684e-13,
 -5.201899564154502e-15,  8.948912597152831e-17, -1.451065821884988e-18,  2.233339062366571e-20, -3.280205143383199e-22,  1.040325687905333e-04, -7.523753056982816e-06,
  3.374038587118369e-07, -1.159660833636667e-08,  3.333140945962779e-10, -8.383507950346755e-12,  1.897107583559036e-13, -3.934633288045944e-15,  7.578695060228051e-17,
 -1.369090678938977e-18,  2.337277645339233e-20, -3.792608909777296e-22,  2.307021959377050e-05, -2.062783089174393e-06,  1.098602021308068e-07, -4.401327480456363e-09,
  1.455421471351075e-10, -4.170363528724572e-12,  1.066686461790921e-13, -2.484307858053164e-15,  5.343479362436193e-17, -1.072684062614931e-18,  2.026192911786162e-20,
 -3.623522096279490e-22,  4.468571202029840e-06, -4.873187473157820e-07,  3.065743260115348e-08, -1.426057601943308e-09,  5.408553531036946e-11, -1.760867014390658e-12,
  5.078655012138697e-14, -1.325285478933658e-15,  3.176438492164973e-17, -7.071535348760058e-19,  1.474994765789279e-20, -2.901417952789348e-22,  7.626727011036478e-07,
 -1.002623277094891e-07,  7.412441823710936e-09, -3.989236037909374e-10,  1.730608701871641e-11, -6.387354708203858e-13,  2.073147967050904e-14, -6.050321333794444e-16,
  1.613089170024243e-17, -3.975746390629553e-19,  9.141946748934952e-21, -1.974723168865734e-22,  1.161290441292354e-07, -1.821180110113116e-08,  1.574280313400517e-09,
 -9.769463942701435e-11,  4.835448656828324e-12, -2.018930350527380e-13,  7.360635785676498e-15, -2.398360533657645e-16,  7.101421641545979e-18, -1.934708740912643e-19,
  4.896789808322538e-21, -1.159729286017482e-22,  1.605019638311609e-08, -2.973402824042877e-09,  2.989756973770962e-10, -2.131857971704948e-11,  1.200656036721605e-12,
 -5.658538304164342e-14,  2.312803715964698e-15, -8.398731539818542e-17,  2.757146777024825e-18, -8.289449265817670e-20,  2.305641189583325e-21, -5.977287080830444e-23,
  2.062027563238480e-09, -4.468963414717299e-10,  5.197401800912939e-11, -4.241317470229063e-12,  2.709480865099530e-13, -1.437529564943734e-14,  6.571486261736103e-16,
 -2.653772656826955e-17,  9.638758039037358e-19, -3.191570399467703e-20,  9.735887735454973e-22, -2.757325337877852e-23,  2.543268860561729e-10, -6.382089632753526e-11,
  8.528538700014387e-12, -7.925336670908793e-13,  5.719385498304289e-14, -3.403909122097912e-15,  1.734745277225860e-16, -7.767003801485039e-18,  3.112255759076000e-19,
 -1.131796116486502e-20,  3.776246627512152e-22, -1.165189057192494e-23,  3.142602079970505e-11, -9.025323840806978e-12,  1.374524685650355e-12, -1.444981309883569e-13,
  1.171336174260588e-14, -7.780498525007996e-16,  4.399964862945803e-17, -2.174595653094091e-18,  9.572916562335532e-20, -3.807924656131179e-21,  1.384166970863088e-22,
 -4.635141377255967e-24,  4.106479374383460e-12, -1.331314035355180e-12,  2.286388419784059e-13, -2.694695346532645e-14,  2.434044522283208e-15, -1.791261945124256e-16,
  1.116367739915638e-17, -6.051075447323868e-19,  2.908390149169537e-20, -1.257935689806209e-21,  4.952890458511382e-23, -1.789894816515527e-24,  6.047334313109202e-13,
 -2.176822863599135e-13,  4.157420364471725e-14, -5.425544750857842e-15,  5.399209675565138e-16, -4.355918746027406e-17,  2.962247424123617e-18, -1.744422138399674e-19,
  9.072361425951615e-21, -4.229998229157330e-22,  1.789082166638555e-23, -6.921545013285528e-25,  1.069153969473617e-13, -4.189024403218361e-14,  8.737055783692258e-15,
 -1.241564772601547e-15,  1.340104526015702e-16, -1.167964093301149e-17,  8.547407066464495e-19, -5.396864335388681e-20,  2.999141789655474e-21, -1.489384298772758e-22,
  6.689248678072030e-24, -2.739961386385806e-25,  2.336315046677888e-14, -9.734170692708341e-15,  2.167096528125799e-15, -3.281369206629055e-16,  3.763639419893754e-17,
 -3.475497314530191e-18,  2.687178800006589e-19, -1.787675057888009e-20,  1.044004337414783e-21, -5.435105865799860e-23,  2.553138835953408e-24, -1.091312730766399e-25,
  5.354729224492607e-15, -2.311083384702340e-15,  5.344394442126582e-16, -8.398801917672490e-17,  9.982731954237994e-18, -9.536954492717266e-19,  7.615795082317321e-20,
 -5.224360306681061e-21,  3.141275232367553e-22, -1.681278753864735e-23,  8.108459147955754e-25, -3.553482542864773e-26,  9.934254714760719e-02, -4.161685829521255e-04,
  1.835110231685743e-06, -8.425091486659905e-09,  3.972257882582482e-11, -1.906609508746157e-13,  9.209349305664075e-16, -4.480721780101851e-18,  2.164346608893024e-20,
 -1.056947088483379e-22,  5.021890207190219e-25, -2.491042952673403e-27,  8.472752150377884e-02, -4.614200191262645e-04,  3.144186433094405e-06, -2.205504961072415e-08,
  1.510409063434560e-10, -1.004688036314106e-12,  6.512921614305630e-15, -4.133351477346688e-17,  2.574833622333855e-19, -1.579406292053154e-21,  9.545762336315151e-24,
 -5.702442009172034e-26,  6.163125451959926e-02, -4.917233545282083e-04,  4.890114823322295e-06, -4.526164767486930e-08,  3.923895163877774e-10, -3.241798405908489e-12,
  2.578750474535066e-14, -1.987655862902902e-16,  1.491237702427702e-18, -1.092619001936587e-20,  7.839518025447421e-23, -5.519242425962877e-25,  3.823570755526080e-02,
 -4.521614225642888e-04,  5.944293624354556e-06, -6.849516660148142e-08,  7.262069073317820e-10, -7.242611155676813e-12,  6.877539528748540e-14, -6.268815347363169e-16,
  5.517618456048940e-18, -4.710516095043558e-20,  3.914555812589674e-22, -3.175160373857707e-24,  2.023282800555222e-02, -3.449038600659677e-04,  5.702293280008259e-06,
 -8.012261393490107e-08,  1.020191326948521e-09, -1.205961120043751e-11,  1.343109534558236e-13, -1.423653581899984e-15,  1.446778353172567e-17, -1.417389375965382e-19,
  1.344401932064463e-21, -1.238685372345139e-23,  9.133609275565377e-03, -2.166777186918082e-04,  4.403363109762629e-06, -7.450099091843821e-08,  1.124076340292024e-09,
 -1.554896663119526e-11,  2.006882883830917e-13, -2.445942340091793e-15,  2.839242570007333e-17, -3.159211152390331e-19,  3.386389819527089e-21, -3.510352810950076e-23,
  3.518833186872026e-03, -1.124612718666963e-04,  2.776281727369067e-06, -5.600347884580806e-08,  9.913633909160475e-10, -1.590092645922884e-11,  2.358210357258503e-13,
 -3.278178864833663e-15,  4.313264606858043e-17, -5.410843353662559e-19,  6.508102540348237e-21, -7.538103087414139e-23,  1.157844386348562e-03, -4.849941401226254e-05,
  1.443405174899681e-06, -3.443792112013507e-08,  7.099528767701065e-10, -1.311549110450838e-11,  2.221049983399842e-13, -3.500695323710005e-15,  5.191394659512249e-17,
 -7.302345998529509e-19,  9.804000397652132e-21, -1.262393304939540e-22,  3.258060962306114e-04, -1.748449344152213e-05,  6.235953904135590e-07, -1.748530954357694e-08,
  4.174717433566677e-10, -8.838125041534217e-12,  1.701022873164926e-13, -3.026403901353899e-15,  5.037046091235963e-17, -7.912387401515659e-19,  1.181115532611159e-20,
 -1.684252095640521e-22,  7.856768764268401e-05, -5.301801447059680e-06,  2.254192997710293e-07, -7.390614323090693e-09,  2.034949542777851e-10, -4.918256601590342e-12,
  1.072032754412609e-13, -2.145875209592137e-15,  3.995742657143852e-17, -6.988077054931840e-19,  1.156383406855561e-20, -1.820896594550252e-22,  1.629089068113582e-05,
 -1.361117717731771e-06,  6.865729641813816e-08, -2.621397329460706e-09,  8.296624773734365e-11, -2.282598559594048e-12,  5.619871275581712e-14, -1.262486019649757e-15,
  2.623838091030141e-17, -5.097231173678886e-19,  9.329793452796818e-21, -1.618730030020943e-22,  2.919149335795813e-06, -2.981002220258227e-07,  1.775921901490226e-08,
 -7.870180244652097e-10,  2.855806826950675e-11, -8.924207713766186e-13,  2.476877977007859e-14, -6.233123094623534e-16,  1.443336840090839e-17, -3.109277630318124e-19,
  6.284377820537752e-21, -1.199388210648759e-22,  4.554606185367746e-07, -5.622396623657852e-08,  3.939210151304856e-09, -2.020480879117085e-10,  8.388050021640803e-12,
 -2.972087395617282e-13,  9.284776856504230e-15, -2.613733990987093e-16,  6.734281153527948e-18, -1.606601542265892e-19,  3.581062348729249e-21, -7.508193891872997e-23,
  6.256442163699323e-08, -9.245887156751228e-09,  7.587067869723806e-10, -4.492419746621531e-11,  2.129823338147042e-12, -8.544012099138702e-14,  3.000496142008769e-15,
 -9.437684883457322e-17,  2.702589086517583e-18, -7.132588743327433e-20,  1.751361079449542e-21, -4.029370644112892e-23,  7.688223956125928e-09, -1.348073430414093e-09,
  1.290196325184092e-10, -8.795981490386234e-12,  4.753271528850690e-13, -2.155692781376567e-14,  8.499421573550266e-16, -2.983610454595758e-17,  9.485519188768198e-19,
 -2.766330211841405e-20,  7.474434689148334e-22, -1.884873744058267e-23,  8.646619880121868e-10, -1.783125232402899e-10,  1.981286565918025e-11, -1.550564848602176e-12,
  9.529591957973279e-14, -4.877058887703974e-15,  2.155490447383144e-16, -8.432331143695032e-18,  2.972113542153560e-19, -9.565032900507107e-21,  2.839917300196208e-22,
 -7.838522516267217e-24,  9.189344636068176e-11, -2.208069238292386e-11,  2.832850246248468e-12, -2.535066733553804e-13,  1.766508217349531e-14, -1.017551829949212e-15,
  5.029395829042956e-17, -2.187862490853467e-18,  8.531548336890972e-20, -3.023681943508187e-21,  9.844959590943544e-23, -2.968043888366654e-24,  9.642854601572826e-12,
 -2.671030556625342e-12,  3.928892126391460e-13, -3.998390484006828e-14,  3.144574290683179e-15, -2.030484818342001e-16,  1.118191372757108e-17, -5.390176298733998e-19,
  2.317615975117878e-20, -9.016042680351359e-22,  3.208890840139420e-23, -1.053291429826954e-24,  1.058810447265097e-12, -3.337262784642856e-13,  5.574399065439728e-14,
 -6.400242520474128e-15,  5.641243426560337e-16, -4.057287059828023e-17,  2.474717641181888e-18, -1.314462696789420e-19,  6.198283916964853e-21, -2.632948483717683e-22,
  1.019134346845904e-23, -3.624033870544117e-25,  1.307089199896813e-13, -4.612226268318589e-14,  8.633044023241735e-15, -1.105273859369461e-15,  1.080280152502160e-16,
 -8.569235679319830e-18,  5.735660898746662e-19, -3.327533817276527e-20,  1.706381051964723e-21, -7.851030821636535e-23,  3.279190413387307e-24, -1.253704336519190e-25,
  1.959145042965773e-14, -7.583537804690287e-15,  1.561942598829652e-15, -2.192982638031699e-16,  2.340228466334395e-17, -2.017864457445082e-18,  1.461889917082604e-19,
 -9.143159073263985e-21,  5.035754208209270e-22, -2.479749332241585e-23,  1.104883183305640e-24, -4.491785336687322e-26,  3.740564882005276e-15, -1.549542090254321e-15,
  3.428701100523651e-16, -5.161060010296085e-17,  5.886422085710327e-18, -5.406955628962352e-19,  4.159620757984345e-20, -2.754158701646714e-21,  1.601253290517840e-22,
 -8.300983450123764e-24,  3.883818569133550e-25, -1.653839283605660e-26,  7.880946712813744e-16, -3.395246751792237e-16,  7.836104210660145e-17, -1.229077138170335e-17,
  1.458148631582774e-18, -1.390550797566102e-19,  1.108540133241114e-20, -7.592091103263033e-22,  4.557827597997360e-23, -2.435818980154124e-24,  1.173073035820811e-25,
 -5.133935240325416e-27,  9.770660915351503e-02, -4.018815831572538e-04,  1.737700441956082e-06, -7.818876370577262e-09,  3.612061195651253e-11, -1.699891546466957e-13,
  8.046254170853030e-16, -3.845339495333458e-18,  1.817497656460758e-20, -8.765205197143280e-23,  4.033311406977368e-25, -2.025637463789974e-27,  8.293052827994832e-02,
 -4.372855607524575e-04,  2.893389144990254e-06, -1.979102973736642e-08,  1.324211005181175e-10, -8.613849378442597e-13,  5.462886308259485e-15, -3.393472978393107e-17,
  2.069336819432297e-19, -1.243351409957367e-21,  7.358245346714892e-24, -4.309970970516821e-26,  5.973930749864700e-02, -4.546729831593893e-04,  4.382608837772244e-06,
 -3.947027593690604e-08,  3.333181501915231e-10, -2.684634143871885e-12,  2.083506508624371e-14, -1.567787137104308e-16,  1.148944633473291e-18, -8.226603081558776e-21,
  5.770778620091642e-23, -3.973315952312452e-25,  3.651722997909309e-02, -4.077077676290097e-04,  5.187562388058378e-06, -5.795061876881106e-08,  5.965358486259503e-10,
 -5.784147411069188e-12,  5.345973382074713e-14, -4.746816498220548e-16,  4.073002087492214e-18, -3.391861229713050e-20,  2.751085721926938e-22, -2.178889248906301e-24,
  1.893872888075779e-02, -3.028711636445326e-04,  4.831333375146495e-06, -6.556661791444009e-08,  8.082565232120882e-10, -9.266548917850965e-12,  1.002313821985816e-13,
 -1.032926360860886e-15,  1.021486784691969e-17, -9.745754496530304e-20,  9.008339056135469e-22, -8.093212373268121e-24,  8.332092629631010e-03, -1.847431553555401e-04,
  3.607788483139193e-06, -5.876347084439622e-08,  8.562039812171130e-10, -1.146126111095449e-11,  1.433821939564257e-13, -1.695959429816376e-15,  1.912630530260018e-17,
 -2.069475411220309e-19,  2.158820856197266e-21, -2.179387198380746e-23,  3.109503501186373e-03, -9.269185001591269e-05,  2.189833376550780e-06, -4.240691847671596e-08,
  7.232427464470752e-10, -1.120307281096470e-11,  1.607509618889409e-13, -2.165194570088544e-15,  2.763726057539009e-17, -3.366913713585413e-19,  3.936366975079767e-21,
 -4.435377906928016e-23,  9.845724532652317e-04, -3.843029226241865e-05,  1.090503986017397e-06, -2.491776455036413e-08,  4.938848223568037e-10, -8.795315004160275e-12,
  1.438735688298771e-13, -2.194048959786582e-15,  3.152398182980109e-17, -4.301245313044746e-19,  5.607316822853080e-21, -7.017211089428433e-23,  2.646610182306686e-04,
 -1.323359651707653e-05,  4.486628023769126e-07, -1.202389042359149e-08,  2.755103551372794e-10, -5.613788119768619e-12,  1.042215538688769e-13, -1.791876874837596e-15,
  2.886330865241402e-17, -4.393681803855896e-19,  6.362910170172133e-21, -8.811573986251180e-23,  6.047482170451536e-05, -3.804505244005596e-06,  1.534240681364723e-07,
 -4.799921472061643e-09,  1.266503344548810e-10, -2.942308708615109e-12,  6.179366649918722e-14, -1.194102155528888e-15,  2.150025451784635e-17, -3.641011873585913e-19,
  5.841422261946082e-21, -8.927596956792633e-23,  1.177352951447043e-05, -9.181664545041611e-07,  4.386699832761470e-08, -1.596376257829694e-09,  4.836541879436161e-11,
 -1.277834557442199e-12,  3.028796847522431e-14, -6.563876649428096e-16,  1.318299014467744e-17, -2.478590291421501e-19,  4.396506502638444e-21, -7.401016472331192e-23,
  1.960492935543209e-06, -1.872082387659315e-07,  1.055799150343030e-08, -4.456899706063803e-10,  1.547191141158855e-11, -4.640455186494934e-13,  1.239348063258464e-14,
 -3.007598486587730e-16,  6.728151142455810e-18, -1.402444056141075e-19,  2.746564024842670e-21, -5.085520916765208e-23,  2.809477609546825e-07, -3.251092574265180e-08,
  2.157070892189413e-09, -1.053953732928658e-10,  4.185743303058066e-12, -1.423397297249260e-13,  4.278837282218393e-15, -1.161594151781737e-16,  2.891579591780064e-18,
 -6.675923530197267e-20,  1.442120712384942e-21, -2.934154901579523e-23,  3.497989646820776e-08, -4.861570431673634e-09,  3.782735129231430e-10, -2.135368355609057e-11,
  9.690500034522668e-13, -3.732945410860087e-14,  1.262114934891169e-15, -3.830363897587160e-17,  1.060339846382813e-18, -2.709716081658942e-20,  6.452161264336424e-22,
 -1.441474566266725e-23,  3.838683137774417e-09, -6.355953807085553e-10,  5.781213839912007e-11, -3.763898481729063e-12,  1.949677236041438e-13, -8.501342413619385e-15,
  3.230846647362873e-16, -1.095547861742287e-17,  3.370753828362626e-19, -9.529408748079587e-21,  2.499650724123726e-22, -6.127943876271441e-24,  3.792884788541812e-10,
 -7.423535436063448e-11,  7.865762700394975e-12, -5.894433071163994e-13,  3.480568744389060e-14, -1.716232113939174e-15,  7.325567149991602e-17, -2.773419475803200e-18,
  9.477480431900368e-20, -2.961921036350067e-21,  8.552267906405629e-23, -2.298698271894656e-24,  3.480704583356439e-11, -7.986539498060201e-12,  9.815717351855452e-13,
 -8.443250401674014e-14,  5.671899809371764e-15, -3.157560931551260e-16,  1.511602761689017e-17, -6.381123808725417e-19,  2.418776270763915e-20, -8.345527414770232e-22,
  2.648971520573315e-23, -7.795357526920601e-25,  3.101047833444063e-12, -8.261831344324781e-13,  1.170992334933193e-13, -1.151304814492527e-14,  8.768727947670421e-16,
 -5.495074319380055e-17,  2.942467095260951e-18, -1.381504959366433e-19,  5.794311048882676e-21, -2.201813329052194e-22,  7.664135932306520e-24, -2.463249344279126e-25,
  2.851163341066315e-13, -8.714344720011055e-14,  1.412488815211629e-14, -1.576643295532855e-15,  1.353534167461403e-16, -9.497936453013997e-18,  5.660948545369779e-19,
 -2.942307548437048e-20,  1.359368023774959e-21, -5.664140767989675e-23,  2.152815164964264e-24, -7.524629315618995e-26,  2.928780743822054e-14, -1.010914249272380e-14,
  1.850791199302149e-15, -2.320403863934405e-16,  2.223781149041302e-17, -1.731792654657869e-18,  1.139281744642608e-19, -6.503071272446562e-21,  3.284253680038677e-22,
 -1.489477083460932e-23,  6.137215104879159e-25, -2.316502719803822e-26,  3.681657709034699e-15, -1.405879616854611e-15,  2.855374025138905e-16, -3.955709026147536e-17,
  4.168423601178006e-18, -3.551901126955334e-19,  2.544786134747006e-20, -1.575038174842627e-21,  8.589860420211717e-23, -4.190870155785123e-24,  1.851044578438949e-25,
 -7.463527997045938e-27,  6.069271451013186e-16, -2.497950130551260e-16,  5.489508281793829e-17, -8.208625640471702e-18,  9.303783238731070e-19, -8.495551775574012e-20,
  6.499374290836714e-21, -4.280806351416396e-22,  2.476543250134162e-23, -1.277868008332151e-24,  5.952489493643597e-26, -2.524210796081383e-27,  1.165058420494335e-16,
 -5.009212891546356e-17,  1.153596054231999e-17, -1.805535818616699e-18,  2.137656354985862e-19, -2.034565087699645e-20,  1.618915263286832e-21, -1.106776431090346e-22,
  6.633122939214361e-24, -3.539163441216908e-25,  1.701797473213640e-26, -7.436901167702819e-28,  9.612630533138081e-02, -3.883457126247395e-04,  1.647232612894703e-06,
 -7.267131073993586e-09,  3.290554540693436e-11, -1.519072665205144e-13,  7.046451500514114e-16, -3.311281855564847e-18,  1.528941291454787e-20, -7.319428810236840e-23,
  3.219743528409775e-25, -1.693740086643135e-27,  8.122622532489279e-02, -4.150536630551168e-04,  2.668062923544628e-06, -1.780330022216686e-08,  1.164312292897019e-10,
 -7.409688794844947e-13,  4.599075647622220e-15, -2.797572626091313e-17,  1.670440605769264e-19, -9.836865981960734e-22,  5.700069620980498e-24, -3.277696700679796e-26,
  5.798786039426992e-02, -4.214199344126867e-04,  3.939276312188844e-06, -3.454097921419951e-08,  2.842906744521953e-10, -2.233374174361361e-12,  1.691845471557686e-14,
 -1.243375556509429e-16,  8.904461809207142e-19, -6.233034379918132e-21,  4.276493491465089e-23, -2.880595359581515e-25,  3.496521368248566e-02, -3.688350008750179e-04,
  4.545818941274450e-06, -4.926606501871013e-08,  4.926782492984985e-10, -4.646935587901215e-12,  4.182390706779957e-14, -3.619330306013062e-16,  3.028913833269345e-18,
 -2.461504414130410e-20,  1.949424450931690e-22, -1.508162106394499e-24,  1.779985531075621e-02, -2.671611307814094e-04,  4.116408686797721e-06, -5.399566777355960e-08,
  6.448163913338160e-10, -7.174131435056958e-12,  7.540408797040869e-14, -7.558726403519673e-16,  7.277523003832628e-18, -6.764784005187976e-20,  6.096202793474617e-22,
 -5.342605262286241e-24,  7.646685852231021e-03, -1.584848883846274e-04,  2.977822328040913e-06, -4.672602245142622e-08,  6.578742996243672e-10, -8.527101478089520e-12,
  1.034526971989136e-13, -1.188162856301157e-15,  1.302435466077974e-17, -1.370978802164579e-19,  1.392413414515061e-21, -1.369500237596063e-23,  2.770807382500238e-03,
 -7.702775535293580e-05,  1.743614356843634e-06, -3.243685507745113e-08,  5.333234917830775e-10, -7.982819505360047e-12,  1.108812336372156e-13, -1.447792203525304e-15,
  1.793603422755559e-17, -2.122882950557056e-19,  2.413445058385613e-21, -2.646444464869252e-23,  8.465790420434600e-04, -3.078022234637452e-05,  8.336540623997382e-07,
 -1.825425232306301e-08,  3.480656717004145e-10, -5.978456430592743e-12,  9.451197262305275e-14, -1.395137336290971e-15,  1.942933424468444e-17, -2.572492323516193e-19,
  3.257555092007232e-21, -3.963377065418445e-23,  2.180869846341376e-04, -1.015422968107754e-05,  3.275177766975436e-07, -8.393378174912427e-09,  1.846670071329376e-10,
 -3.623201687922687e-12,  6.491261122535431e-14, -1.078902013860543e-15,  1.682533798414121e-17, -2.482789015920622e-19,  3.489320806421425e-21, -4.693995060407877e-23,
  4.739012595804502e-05, -2.777060083429859e-06,  1.062745322162111e-07, -3.173816366182254e-09,  8.028213143701199e-11, -1.793405034936671e-12,  3.630229245678840e-14,
 -6.774256096803076e-16,  1.179750710092984e-17, -1.935056861386254e-19,  3.010504051350028e-21, -4.466575624906029e-23,  8.697711775714348e-06, -6.324147170461142e-07,
  2.862291106002354e-08, -9.929735650923520e-10,  2.880449007237622e-11, -7.309722050861092e-13,  1.668316837428707e-14, -3.488466636889350e-16,  6.771713875626088e-18,
 -1.232372751289358e-19,  2.118660721302531e-21, -3.460742395886417e-23,  1.351843501096379e-06, -1.205420413900031e-07,  6.434208849297043e-09, -2.587041757168435e-10,
  8.591700719341401e-12, -2.473312248219736e-13,  6.356512468411509e-15, -1.487573943657185e-16,  3.214934921229832e-18, -6.484240753637880e-20,  1.230435051467913e-21,
 -2.210247536672872e-23,  1.787689962352150e-07, -1.935973464833580e-08,  1.215663639972680e-09, -5.656093088710225e-11,  2.148305572889431e-12, -7.009862022542739e-14,
  2.027296974051749e-15, -5.306507292221283e-17,  1.276046329804152e-18, -2.850545759178036e-20,  5.966639166391677e-22, -1.177854472467988e-23,  2.027197188993599e-08,
 -2.644391243964575e-09,  1.948994737916339e-10, -1.048147785357668e-11,  4.550483640319691e-13, -1.682437632524168e-14,  5.474110123898502e-16, -1.602318167385751e-17,
  4.286262882478253e-19, -1.060253056577716e-20,  2.447306018612547e-22, -5.307338784532324e-24,  1.995978674938100e-09, -3.113600676726643e-10,  2.687623136537856e-11,
 -1.669167433296354e-12,  8.280310574013995e-14, -3.468633878396969e-15,  1.269708566737324e-16, -4.156190753624001e-18,  1.236799454609925e-19, -3.387495022243218e-21,
  8.621555226524492e-23, -2.053594733649743e-24,  1.739749716446694e-10, -3.223324480110324e-11,  3.250858025725063e-12, -2.329249555993638e-13,  1.319780881572115e-14,
 -6.263068473942320e-16,  2.579242114809578e-17, -9.441380032638821e-19,  3.125322326741183e-20, -9.477158705462640e-22,  2.659101389389480e-23, -6.954758737342238e-25,
  1.382532357063193e-11, -3.020671022840570e-12,  3.548720781442261e-13, -2.928804300440319e-14,  1.893711053813667e-15, -1.017429474059055e-16,  4.711477031861156e-18,
 -1.927769582933168e-19,  7.095163462102754e-21, -2.380768737976657e-22,  7.359658175374988e-24, -2.112082712068350e-25,  1.046452974833449e-12, -2.673734006618989e-13,
  3.642830847402967e-14, -3.453002461246386e-15,  2.542239017927428e-16, -1.543598456043767e-17,  8.024865977863585e-19, -3.664601524992181e-20,  1.497349359243935e-21,
 -5.551086503680642e-23,  1.887588530624386e-24, -5.933819137136503e-26,  8.035013005371829e-14, -2.374840932573922e-14,  3.726270092667980e-15, -4.034972294914163e-16,
  3.367413742407762e-17, -2.301416018523144e-18,  1.338221382170178e-19, -6.796093937663749e-21,  3.072106582820241e-22, -1.254011053560315e-23,  4.674496109867839e-25,
 -1.604129662277503e-26,  6.821058495806660e-15, -2.297630085546934e-15,  4.105558739037163e-16, -5.030683705114850e-17,  4.718930340115085e-18, -3.601955203093251e-19,
  2.325506287783180e-20, -1.304227116856802e-21,  6.478579238829060e-23, -2.892716300216128e-24,  1.174513367440371e-25, -4.372211203110213e-27,  7.112879356928358e-16,
 -2.675045256750597e-16,  5.348993263431187e-17, -7.301005149879046e-18,  7.586920511622421e-19, -6.380706729038746e-20,  4.515738495194636e-21, -2.762910810035710e-22,
  1.490606367677573e-23, -7.198813670679180e-25,  3.149273650537910e-26, -1.258405914423437e-27,  9.995512737032547e-17, -4.083808824428860e-17,  8.905666291553113e-18,
 -1.321849955519960e-18,  1.487732983023554e-19, -1.349551895957183e-20,  1.026061834677773e-21, -6.718808336369488e-23,  3.865687107192859e-24, -1.984355195318820e-25,
  9.198415160934103e-27, -3.882799477675988e-28,  1.730823741878776e-17, -7.425125531558704e-18,  1.705842883160314e-18, -2.663576284891735e-19,  3.146391240044880e-20,
 -2.988189200387480e-21,  2.372835602280047e-22, -1.619026212499283e-23,  9.685086037263662e-25, -5.158412059081709e-26,  2.476220700942182e-27, -1.080376820152638e-28,
  9.459873823936765e-02, -3.755079487866446e-04,  1.563088606186096e-06, -6.764059211921811e-09,  3.002928063428075e-11, -1.360554365015011e-13,  6.183996861124727e-16,
 -2.861836389793522e-18,  1.286892087782270e-20, -6.173734547612277e-23,  2.523141923605740e-25, -1.496325274745275e-27,  7.960738990084258e-02, -3.945331373719031e-04,
  2.465130403496982e-06, -1.605321424543970e-08,  1.026551692871967e-10, -6.394180918057313e-13,  3.885565467256887e-15, -2.315558766754509e-17,  1.354102190700517e-19,
 -7.821017364060489e-22,  4.435021036725424e-24, -2.509852943019718e-26,  5.636268882878903e-02, -3.914896208999023e-04,  3.550670802576153e-06, -3.032873493463868e-08,
  2.434174244413986e-10, -1.866084944072039e-12,  1.380440759792918e-14, -9.912662789053533e-17,  6.940226237941160e-19, -4.751112981032644e-21,  3.189678268656902e-23,
 -2.102481324871815e-25,  3.355904286349207e-02, -3.347059373328469e-04,  3.999023997563483e-06, -4.207544288470510e-08,  4.090097270010611e-10, -3.754586797846642e-12,
  3.292354166939443e-14, -2.778018459250534e-16,  2.268499335286634e-18, -1.799766263243501e-20,  1.392367887627356e-22, -1.052561018478756e-24,  1.679320365173289e-02,
 -2.366565630360608e-04,  3.525928045441681e-06, -4.473488932386687e-08,  5.178434561269764e-10, -5.594183698112164e-12,  5.716494246989998e-14, -5.576747182920921e-16,
  5.229863022050435e-18, -4.738427276454160e-20,  4.164878335198159e-22, -3.561869290483291e-24,  7.057076853100403e-03, -1.367383546794658e-04,  2.475046101571235e-06,
 -3.743998642374219e-08,  5.096915222197861e-10, -6.400566774778203e-12,  7.534739235137740e-14, -8.406791112868327e-16,  8.961443320485894e-18, -9.180932191339166e-20,
  9.082118076610466e-22, -8.706146487106600e-24,  2.488318893647183e-03, -6.450200403671012e-05,  1.400735816575749e-06, -2.504904165066014e-08,  3.973024841328263e-10,
 -5.749719119967491e-12,  7.735021364066335e-14, -9.795459089426401e-16,  1.178322070370913e-17, -1.355532650175505e-19,  1.499141902935740e-21, -1.600372326283084e-23,
  7.355319047963730e-04, -2.490086780593320e-05,  6.444373062753933e-07, -1.353063009024700e-08,  2.483450502246740e-10, -4.116414534647819e-12,  6.292154746930261e-14,
 -8.994805815499646e-16,  1.214681130567557e-17, -1.561247803800686e-19,  1.921080536004915e-21, -2.273169870250974e-23,  1.821367402939537e-04, -7.891744409076674e-06,
  2.423825064843828e-07, -5.943045889548931e-09,  1.256176468544356e-10, -2.374356676353670e-12,  4.106836823945226e-14, -6.601414089582824e-16,  9.970645423844635e-18,
 -1.426727554606592e-19,  1.946494283727472e-21, -2.544400446153130e-23,  3.776865423102464e-05, -2.059817858222746e-06,  7.484957563209902e-08, -2.134665441789882e-09,
  5.178608294613915e-11, -1.112797245400654e-12,  2.171821726963387e-14, -3.914905311079109e-16,  6.596352432798920e-18, -1.048210614128448e-19,  1.581790339228579e-21,
 -2.278766878697477e-23,  6.560309423252176e-06, -4.442439413151944e-07,  1.905236967746804e-08, -6.302301959816690e-10,  1.750889066565220e-11, -4.268828652818915e-13,
  9.383592718110797e-15, -1.893574656701302e-16,  3.553359578147588e-18, -6.260491438583983e-20,  1.043298359235949e-21, -1.653851050937096e-23,  9.558248944790735e-07,
 -7.947758764623577e-08,  4.014753119647205e-09, -1.537527138459340e-10,  4.885285842558900e-12, -1.349913373679780e-13,  3.338763000209876e-15, -7.535413548058778e-17,
  1.573410242624830e-18, -3.070744459861994e-20,  5.646120215844857e-22, -9.839518008993660e-24,  1.171854511381869e-07, -1.185659438571101e-08,  7.042639497982990e-10,
 -3.119309554913906e-11,  1.132883760581346e-12, -3.546474565149039e-14,  9.866428361476377e-16, -2.489798630436299e-17,  5.782945873359428e-19, -1.249812390667737e-20,
  2.534570257727216e-22, -4.853884234387693e-24,  1.216226579461136e-08, -1.486126573432470e-09,  1.036562192004714e-10, -5.307369337536349e-12,  2.203264072708773e-13,
 -7.815344538180122e-15,  2.446209064578893e-16, -6.903638467735949e-18,  1.784001309172225e-19, -4.270159487031823e-21,  9.551874604743205e-23, -2.010171022873027e-24,
  1.079695905187727e-09, -1.583125780531376e-10,  1.295086938196649e-11, -7.664898878185470e-13,  3.638475914224128e-14, -1.463224978387269e-15,  5.155814708586715e-17,
 -1.628209051858090e-18,  4.683625230126659e-20, -1.242146932890958e-21,  3.065862879782619e-23, -7.091868768530979e-25,  8.339552062093625e-11, -1.458802401613478e-11,
  1.397913343175146e-12, -9.563264677509376e-14,  5.193459374899934e-15, -2.369467997031892e-16,  9.405632040055779e-18, -3.326017113471317e-19,  1.065648401144737e-20,
 -3.133048171577641e-22,  8.536012797946646e-24, -2.170917727930233e-25,  5.759044798040346e-12, -1.194701277102118e-12,  1.338724738614658e-13, -1.058196233925797e-14,
  6.575453437702588e-16, -3.404781100823713e-17,  1.523241413458696e-18, -6.034027322196540e-20,  2.154064589174809e-21, -7.022198399639716e-23,  2.112108975794089e-24,
 -5.905674519325648e-26,  3.709148025633509e-13, -9.061145622298381e-14,  1.183808269631197e-14, -1.079574571652261e-15,  7.669139421955166e-17, -4.504309305557726e-18,
  2.270089340834538e-19, -1.006877897997648e-20,  4.002754843474975e-22, -1.445986588828122e-23,  4.797831552091069e-25, -1.473619132246973e-26,  2.374501016820650e-14,
 -6.766515236075165e-15,  1.025147950608024e-15, -1.074481072857357e-16,  8.699753716433478e-18, -5.780409664292985e-19,  3.273752152863249e-20, -1.621986300469226e-21,
  7.163694273803988e-23, -2.860858692820660e-24,  1.044606686282006e-25, -3.515428775539486e-27,  1.655663204253223e-15, -5.428450081687296e-16,  9.444855233343192e-17,
 -1.128704851893162e-17,  1.034319095354425e-18, -7.724735695481293e-20,  4.886672295648969e-21, -2.688796450970865e-22,  1.311900256270477e-23, -5.759774151730610e-25,
  2.301753579969536e-26, -8.441198646350113e-28,  1.416580891196342e-16, -5.237124406132351e-17,  1.029151930098463e-17, -1.381730728965140e-18,  1.413797958976034e-19,
 -1.171940881064833e-20,  8.182481198345282e-22, -4.943270741116404e-23,  2.635379072454370e-24, -1.258597376983212e-25,  5.448411344640197e-27, -2.155701738265016e-28,
  1.673827257744315e-17, -6.781984000505034e-18,  1.466156156699000e-18, -2.158113686112610e-19,  2.409914700684067e-20, -2.169997520529906e-21,  1.638455219014433e-22,
 -1.065932878386009e-23,  6.095543001407435e-25, -3.111083755091510e-26,  1.434360413407717e-27, -6.023988558712075e-29,  2.585432541484546e-18, -1.106361972617086e-18,
  2.534908813187133e-19, -3.947727371449606e-20,  4.651608338683996e-21, -4.407176210819822e-22,  3.491679936911383e-23, -2.377306438810995e-24,  1.419209061390284e-25,
 -7.544224582859743e-27,  3.614804245513302e-28, -1.574374583699457e-29,  9.312121305844719e-02, -3.633199485121279e-04,  1.484715449633331e-06, -6.304579631546218e-09,
  2.745032920723133e-11, -1.221308741906218e-13,  5.437125710858799e-16, -2.483770913620281e-18,  1.081240897101011e-20, -5.293852516373821e-23,  1.878565163097233e-25,
 -1.466024200927119e-27,  7.806751757189302e-02, -3.755556662784205e-04,  2.281940543670752e-06, -1.450818360767895e-08,  9.074925073000962e-11, -5.534799978499504e-13,
  3.293872195130586e-15, -1.924076246403406e-17,  1.101982883011241e-19, -6.249829203112666e-22,  3.462432064582018e-24, -1.939165048210091e-26,  5.485132596865080e-02,
 -3.644765482234037e-04,  3.208918275819969e-06, -2.671552926323648e-08,  2.091962941168390e-10, -1.565725787807711e-12,  1.131572732160842e-14, -7.942530587556838e-17,
  5.438830663803719e-19, -3.642489190671161e-21,  2.394017849678596e-23, -1.544336860957262e-25,  3.228115563603987e-02, -3.046275565649197e-04,  3.531037771572854e-06,
 -3.609159324278895e-08,  3.412295727685717e-10, -3.050122695514630e-12,  2.607114388402551e-14, -2.145860155298113e-16,  1.710603007029951e-18, -1.325401317843004e-20,
  1.002139572274260e-22, -7.403946410189894e-25,  1.589978061736271e-02, -2.104636038407707e-04,  3.035357919739250e-06, -3.727490827622091e-08,  4.185060046841995e-10,
 -4.392160988022413e-12,  4.365784926410750e-14, -4.146803104045342e-16,  3.789645028883248e-18, -3.348058221367093e-20,  2.871538370910818e-22, -2.397279692514642e-24,
  6.547062386175666e-03, -1.186055971343785e-04,  2.070769998969714e-06, -3.021821681080823e-08,  3.980122693227098e-10, -4.845113596291444e-12,  5.537219430567781e-14,
 -6.004696325930754e-16,  6.227404988940759e-18, -6.212045336690454e-20,  5.987972172883277e-22, -5.596623348793845e-24,  2.250960737632623e-03, -5.439853286249420e-05,
  1.134796515018290e-06, -1.951990493041923e-08,  2.988530176772425e-10, -4.183960255394102e-12,  5.454336869483182e-14, -6.702373175912927e-16,  7.832185651689080e-18,
 -8.761076255985605e-20,  9.429427664688673e-22, -9.803421541031581e-24,  6.452988410202037e-04, -2.033305314489768e-05,  5.034381867119358e-07, -1.014152040858221e-08,
  1.792846566323472e-10, -2.869307789100735e-12,  4.242831176893432e-14, -5.876367232156330e-16,  7.698282582598251e-18, -9.609228206677170e-20,  1.149368986527508e-21,
 -1.323148649281967e-23,  1.540400933836176e-04, -6.207072413494812e-06,  1.817159144175492e-07, -4.265199254638007e-09,  8.665770869337159e-11, -1.578727744186201e-12,
  2.637477689065085e-14, -4.101795894989206e-16,  6.002474262156664e-18, -8.331874036945362e-20,  1.103843810991614e-21, -1.402496530335587e-23,  3.058260836735947e-05,
 -1.550923738414688e-06,  5.355310597517265e-08, -1.459153698268432e-09,  3.396453289344792e-11, -7.023426956839575e-13,  1.322124175452077e-14, -2.302966372637517e-16,
  3.755436043966608e-18, -5.783236332256558e-20,  8.467209520020177e-22, -1.184706644553413e-23,  5.046232266125887e-06, -3.178910748378899e-07,  1.292393236823319e-08,
 -4.077486126194580e-10,  1.085234657588703e-11, -2.542780341966091e-13,  5.384782808101327e-15, -1.048925067413019e-16,  1.903222089260059e-18, -3.246910549069579e-20,
  5.245993898242611e-22, -8.071666610903529e-24,  6.921025499278403e-07, -5.359098303366080e-08,  2.561977195711340e-09, -9.345972112432483e-11,  2.841435101462767e-12,
 -7.537485837355368e-14,  1.794319983438635e-15, -3.905994763771734e-17,  7.880424924977406e-19, -1.488335918996846e-20,  2.651808471642173e-22, -4.483611416077794e-24,
  7.902983456114906e-08, -7.458195148286755e-09,  4.188970368698079e-10, -1.765885081812990e-11,  6.131825290673026e-13, -1.841482823264706e-14,  4.927880589199282e-16,
 -1.198815568478394e-17,  2.689291911606843e-19, -5.622613014877379e-21,  1.104643474109487e-22, -2.052071899162540e-24,  7.544104600053833e-09, -8.617934292666436e-10,
  5.683912983495234e-11, -2.769323410978875e-12,  1.098860965268354e-13, -3.738383017235940e-15,  1.125319085497274e-16, -3.061215424945022e-18,  7.639894464020794e-20,
 -1.769073912247245e-21,  3.833967586373396e-23, -7.827807052875202e-25,  6.069149509133069e-10, -8.345397860559075e-11,  6.461955421281047e-12, -3.641281171071413e-13,
  1.652794366955679e-14, -6.377057388188497e-16,  2.161749359358010e-17, -6.582885803544664e-19,  1.829556151104290e-20, -4.696195730530762e-22,  1.123578156349732e-23,
 -2.522893204559895e-25,  4.174549364285771e-11, -6.876244222293507e-12,  6.250047506657164e-13, -4.077047241685386e-14,  2.119752938469043e-15, -9.289073600813920e-17,
  3.551131550896827e-18, -1.212133910852490e-19,  3.756178138329726e-21, -1.069946159329953e-22,  2.828702822107497e-24, -6.990905976787818e-26,  2.515587734847326e-12,
 -4.940226979613119e-13,  5.268829564454577e-14, -3.981934025779057e-15,  2.374362388693330e-16, -1.183353234835583e-17,  5.108637129147038e-19, -1.957081100323763e-20,
  6.769568175051847e-22, -2.141988737961084e-23,  6.262775734287954e-25, -1.704674747006321e-26,  1.382006434839767e-13, -3.217778666491743e-14,  4.021157542232086e-15,
 -3.520677507323682e-16,  2.408799337153002e-17, -1.366266866094748e-18,  6.665233284946306e-20, -2.867468883702328e-21,  1.107676276858090e-22, -3.894480009510769e-24,
  1.259482778270990e-25, -3.775567132762796e-27,  7.371890264728226e-15, -2.019018005401305e-15,  2.945676203001673e-16, -2.981516892608867e-17,  2.337247562289936e-18,
 -1.506967914988413e-19,  8.298709165283043e-21, -4.005022963327813e-22,  1.725758097383068e-23, -6.733606121486071e-25,  2.405347625043372e-26, -7.928803104226507e-28,
  4.199858239626855e-16, -1.336527054798375e-16,  2.258497796945599e-17, -2.626334937294463e-18,  2.346364567084856e-19, -1.711410584630223e-20,  1.059005321422619e-21,
 -5.707875223891379e-23,  2.731537011495557e-24, -1.177628083007017e-25,  4.626152893136308e-27, -1.669399697653930e-28,  2.916720400163681e-17, -1.057761902426127e-17,
  2.038666870018664e-18, -2.687365845984298e-19,  2.703004830242672e-20, -2.205050932525825e-21,  1.516739808414563e-22, -9.035962054972190e-24,  4.754681900570818e-25,
 -2.243030295228585e-26,  9.598653887409018e-28, -3.756883211753812e-29,  2.855789872888603e-18, -1.146200168535484e-18,  2.453641527629317e-19, -3.577861157021219e-20,
  3.960160601545369e-21, -3.536517957445851e-22,  2.649640671902279e-23, -1.711322553715206e-24,  9.719889428883918e-26, -4.929345097357998e-27,  2.259080613200761e-28,
 -9.434390281636314e-30,  3.885674900370355e-19, -1.658087952177042e-19,  3.787576892185685e-20, -5.881274467490335e-21,  6.910534919814091e-22, -6.530040824157535e-23,
  5.160574275805638e-24, -3.505216689993168e-25,  2.087836578045693e-26, -1.107479809652802e-27,  5.295710538375508e-29, -2.302035089810993e-30,  9.169121986537963e-02,
 -3.517375593950399e-04,  1.411617352960829e-06, -5.884229267063083e-09,  2.513276431642262e-11, -1.098789340978241e-13,  4.787340403868398e-16, -2.166944449198329e-18,
  9.025988771558666e-21, -4.675613404913860e-23,  1.197122724185777e-25, -1.680946951404095e-27,  7.660073710613924e-02, -3.579726652111117e-04,  2.116202401170764e-06,
 -1.314063344648867e-08,  8.042851656785698e-11, -4.805133579158753e-13,  2.801298581849524e-15, -1.604926464624002e-17,  8.999853784606741e-20, -5.022175708696993e-22,
  2.706367988304531e-24, -1.519473612111999e-26,  5.344280939795799e-02, -3.400329336812868e-04,  2.907427203413725e-06, -2.360487121038125e-08,  1.804270892990144e-10,
 -1.318983424189216e-12,  9.317009796142611e-15, -6.394680809147061e-17,  4.284712532228575e-19, -2.807963812027470e-21,  1.807935621222799e-23, -1.140973415679094e-25,
  3.111652423912983e-02, -2.780232614449988e-04,  3.128788409463657e-06, -3.108787989864814e-08,  2.860277050577725e-10, -2.490745322743880e-12,  2.076252269476122e-14,
 -1.667668373087191e-16,  1.298402898523506e-18, -9.827733326217912e-21,  7.266773435384964e-23, -5.246644112118073e-25,  1.510381138325712e-02, -1.878624273076699e-04,
  2.625510958572290e-06, -3.122834286447674e-08,  3.402665417370811e-10, -3.471041094956559e-12,  3.357805095253043e-14, -3.106705704287304e-16,  2.767989218408581e-18,
 -2.385452603206371e-20,  1.997351619469853e-22, -1.628134576457726e-24,  6.103619418431789e-03, -1.033885744941324e-04,  1.743381993466925e-06, -2.455836960672548e-08,
  3.131456336460834e-10, -3.697332714763642e-12,  4.104309161536527e-14, -4.327932014769854e-16,  4.368830005342967e-18, -4.245105505311169e-20,  3.989005663641634e-22,
 -3.636363214109083e-24,  2.050146758332350e-03, -4.618175541732332e-05,  9.267002387498853e-07, -1.534247178716077e-08,  2.268790086799565e-10, -3.074471437223043e-12,
  3.885878707763858e-14, -4.635586970660355e-16,  5.264654254243421e-18, -5.728649151313581e-20,  6.002747298043446e-22, -6.080141870347589e-24,  5.713144002872473e-04,
 -1.674760297268280e-05,  3.972225794513274e-07, -7.681860142207920e-09,  1.308799078398710e-10, -2.023542499034627e-12,  2.896049138562448e-14, -3.887931820980816e-16,
  4.943153200525065e-18, -5.994541921962917e-20,  6.972478448321946e-22, -7.811777309395380e-24,  1.318254755933369e-04, -4.936697900200922e-06,  1.379123087435833e-07,
 -3.100426781137473e-09,  6.058424678468595e-11, -1.064342757492686e-12,  1.718235176956340e-14, -2.586464314847404e-16,  3.668615427197812e-18, -4.941578906344673e-20,
  6.359594694625073e-22, -7.856343037631257e-24,  2.513663122780808e-05, -1.184265437285490e-06,  3.889070526745818e-08, -1.012826141317628e-09,  2.263125888271290e-11,
 -4.505459150088569e-13,  8.183679715703549e-15, -1.377967449475653e-16,  2.175433675321054e-18, -3.247538172836235e-20,  4.614386880908578e-22, -6.272131312341921e-24,
  3.954171686483167e-06, -2.314650925838473e-07,  8.925238148745932e-09, -2.686610920100789e-10,  6.852698617457254e-12, -1.543558539577862e-13,  3.150007319149962e-15,
 -5.924741668643830e-17,  1.039705562792380e-18, -1.717908675295309e-20,  2.691550351892424e-22, -4.020348763404651e-24,  5.125844963472075e-07, -3.690938797329500e-08,
  1.670164981576570e-09, -5.804321799456039e-11,  1.688851591118019e-12, -4.301618654549989e-14,  9.857636941470264e-16, -2.070052989244449e-17,  4.035908759892215e-19,
 -7.377226694905549e-21,  1.273831921036019e-22, -2.089754299262577e-24,  5.476053663384841e-08, -4.812176727408307e-09,  2.555096978098942e-10, -1.025046617770055e-11,
  3.402964768602759e-13, -9.803897339031186e-15,  2.523600985459253e-16, -5.918335650811045e-18,  1.282275211544812e-19, -2.593445041022864e-21,  4.935958695058948e-23,
 -8.894220849218232e-25,  4.831638740311501e-09, -5.149747002653109e-10,  3.209519498614724e-11, -1.487379645425046e-12,  5.639506409520660e-14, -1.839650893291477e-15,
  5.324521419338722e-17, -1.395872269673122e-18,  3.363808428917327e-20, -7.533829310429776e-22,  1.581581322884642e-23, -3.132158593690761e-25,  3.540831557641584e-10,
 -4.555394515068335e-11,  3.334886605634969e-12, -1.787747753107562e-13,  7.754423329011162e-15, -2.868990947894454e-16,  9.352033925714612e-18, -2.744883200807380e-19,
  7.367660600284900e-21, -1.829638494312112e-22,  4.241601523134622e-24, -9.241570541242542e-26,  2.180180100383036e-11, -3.372599168585557e-12,  2.902967313946870e-13,
 -1.803480410131652e-14,  8.968182730630638e-16, -3.771434692634113e-17,  1.387452148834505e-18, -4.568099203224565e-20,  1.368178823418102e-21, -3.773474611349816e-23,
  9.674661986983223e-25, -2.322094982802105e-26,  1.151848903358163e-12, -2.134987709720103e-13,  2.162670080389649e-14, -1.560103587343478e-15,  8.914325168587812e-17,
 -4.270918154298410e-18,  1.777198903157119e-19, -6.577433266454254e-21,  2.202370749097298e-22, -6.757614321238962e-24,  1.918995511949914e-25, -5.080549234346688e-27,
  5.415784791369375e-14, -1.197902317181031e-14,  1.428318078893259e-15, -1.198122259324660e-16,  7.880862854508046e-18, -4.309882930289684e-19,  2.032254194113940e-20,
 -8.468934491577118e-22,  3.174923956499769e-23, -1.085159077006816e-24,  3.416794073077976e-26, -9.986278122151931e-28,  2.408393163109722e-15, -6.318243195456798e-16,
  8.852406260409220e-17, -8.632176405325503e-18,  6.537859366594693e-19, -4.082852312624974e-20,  2.182448336666777e-21, -1.024343535072513e-22,  4.300011234571062e-24,
 -1.637013753775371e-25,  5.713465161816147e-27, -1.842509102857244e-28,  1.116412306897732e-16, -3.437588074939180e-17,  5.626387733181364e-18, -6.351189648458478e-19,
  5.519905038267370e-20, -3.924365977906651e-21,  2.371109996997829e-22, -1.249817181891126e-23,  5.857465495605329e-25, -2.476254104110348e-26,  9.549814542167319e-28,
 -3.386860062022815e-29,  6.228196467469116e-18, -2.210295557143091e-18,  4.168731959398150e-19, -5.384397286201665e-20,  5.313890153276053e-21, -4.259019000538014e-22,
  2.881706390664080e-23, -1.690582251674581e-24,  8.768781234137963e-26, -4.081341921187737e-27,  1.724600222652665e-28, -6.670484070164655e-30,  4.975583861863744e-19,
 -1.975537211936664e-19,  4.182058916554009e-20, -6.033808480604227e-21,  6.612393557625611e-22, -5.850390933213206e-23,  4.345371976580466e-24, -2.783878276371673e-25,
  1.569225764873422e-26, -7.901829993044342e-28,  3.597295072850593e-29, -1.492955251760766e-30,  5.879985089044211e-20, -2.501117749463706e-20,  5.693922481983897e-21,
 -8.812334788523955e-22,  1.032217415154072e-22, -9.724993248362313e-24,  7.664024875057174e-25, -5.191904251835252e-26,  3.084779929601968e-27, -1.632442393548347e-28,
  7.788519409049027e-30, -3.378500960582677e-31,  9.030641773979360e-02, -3.407203905245252e-04,  1.343348794210644e-06, -5.499081460006752e-09,  2.304532936031007e-11,
 -9.908629846397377e-14,  4.218559080394580e-16, -1.904272630483256e-18,  7.409916224992355e-21, -4.358658083821872e-23,  3.456772449865959e-26, -2.258728776049550e-27,
  7.520173694617120e-02, -3.416526272338676e-04,  1.965930227440835e-06, -1.192715356623351e-08,  7.145577495796663e-11, -4.183653002221315e-13,  2.389662191856844e-15,
 -1.343894425247071e-17,  7.371505654345350e-20, -4.063734681246222e-22,  2.107636950532839e-24, -1.219803649573746e-26,  5.212746926491099e-02, -3.178594025380656e-04,
  2.640656976653712e-06, -2.091750779673700e-08,  1.561461001366093e-10, -1.115400611084081e-12,  7.704198630826516e-15, -5.172279069454667e-17,  3.392779261414122e-19,
 -2.175873360466096e-21,  1.373885395897274e-23, -8.470837857634823e-26,  3.005223418457313e-02, -2.544109904544162e-04,  2.781632175994039e-06, -2.688438868935020e-08,
  2.408405237780249e-10, -2.044091326019003e-12,  1.662530083032002e-14, -1.303599147090217e-16,  9.918078291064172e-19, -7.334536847273544e-21,  5.308511301189339e-23,
 -3.742684680469776e-25,  1.439212054296397e-02, -1.682697530923464e-04,  2.281279709961271e-06, -2.629844614995594e-08,  2.782484023427636e-10, -2.760285780967799e-12,
  2.600046605326745e-14, -2.344230470884265e-16,  2.037310620102222e-18, -1.713186461100076e-20,  1.401232485067218e-22, -1.115267791535640e-24,  5.716206049103727e-03,
 -9.054043626470870e-05,  1.476466054424666e-06, -2.008994554539997e-08,  2.481437762287773e-10, -2.843228609451678e-12,  3.067264097800081e-14, -3.146506076474123e-16,
  3.093036878741953e-18, -2.928650673850181e-20,  2.683963515084611e-22, -2.387000725002308e-24,  1.879162262474282e-03, -3.944724564637424e-05,  7.624946667430826e-07,
 -1.215774467558984e-08,  1.737552014435796e-10, -2.280331261299569e-12,  2.795791312482555e-14, -3.239294799893504e-16,  3.577030195257465e-18, -3.787797297365298e-20,
  3.865751594453155e-22, -3.816073750940483e-24,  5.101422191200028e-04, -1.390579987340433e-05,  3.163821286597094e-07, -5.877187436200422e-09,  9.656235968533903e-11,
 -1.443067770304867e-12,  1.999919724576288e-14, -2.603651136975361e-16,  3.214075377467974e-18, -3.788231540674375e-20,  4.286406399646848e-22, -4.675399757712868e-24,
  1.140709494433036e-04, -3.967224556278594e-06,  1.058871910199258e-07, -2.281210987084066e-09,  4.289671898350311e-11, -7.270894330293084e-13,  1.134779609191713e-14,
 -1.654092105343624e-16,  2.274928416154139e-18, -2.974689405622927e-20,  3.720092487184656e-22, -4.469708730924809e-24,  2.095271351274218e-05, -9.162212277121634e-07,
  2.864332844978861e-08, -7.133248093969208e-10,  1.530839532084087e-11, -2.935360338914419e-13,  5.146788684870678e-15, -8.380407748195559e-17,  1.281317643706212e-18,
 -1.854817962454158e-20,  2.558463333682318e-22, -3.379310462508137e-24,  3.153049492775654e-06, -1.713054687484544e-07,  6.269201943523143e-09, -1.801102888773176e-10,
  4.404460589972682e-12, -9.540814165714763e-14,  1.876920078092646e-15, -3.409692771243721e-17,  5.788561430763900e-19, -9.265667533843724e-21,  1.408061750518882e-22,
 -2.042191803969047e-24,  3.878300565465412e-07, -2.593268986993622e-08,  1.111067821292440e-09, -3.679238926642518e-11,  1.024778363455639e-12, -2.506808081245060e-14,
  5.531229145154037e-16, -1.120702880579824e-17,  2.111867456423634e-19, -3.736667392672527e-21,  6.253718504441263e-23, -9.955597750040365e-25,  3.893436467878268e-08,
 -3.180574119732611e-09,  1.596319289382280e-10, -6.094253777804939e-12,  1.934365395265553e-13, -5.346472176218732e-15,  1.323863237661360e-16, -2.993159027433888e-18,
  6.263594615498444e-20, -1.225534100223750e-21,  2.259617002138051e-23, -3.949437173563426e-25,  3.190688450604496e-09, -3.166711655367121e-10,  1.863963920156387e-11,
 -8.213541724354415e-13,  2.975133013042839e-14, -9.304248807567662e-16,  2.588909578265347e-17, -6.539879537737350e-19,  1.521559164663443e-20, -3.295637187283346e-22,
  6.700793630108483e-24, -1.286984921970961e-25,  2.141274534809165e-10, -2.571496076977364e-11,  1.778027832079318e-12, -9.061445676392573e-14,  3.753956236703958e-15,
 -1.331231913774202e-16,  4.171098934921987e-18, -1.179548510065272e-19,  3.056654060291165e-21, -7.341254132795826e-23,  1.648534574117483e-24, -3.484103283098087e-26,
  1.186685301932286e-11, -1.719379006007823e-12,  1.399383321668471e-13, -8.270441937297640e-15,  3.929913716922857e-16, -1.584754089468848e-17,  5.606434730152945e-19,
 -1.779335692758202e-20,  5.147704442090923e-22, -1.373864354165414e-23,  3.414014034650233e-25, -7.953758300692472e-27,  5.525619845920442e-13, -9.637062686683729e-14,
  9.253116518138306e-15, -6.361342682814255e-16,  3.478493807869856e-17, -1.600242616175640e-18,  6.411658787095579e-20, -2.290282390697255e-21,  7.416752159996347e-23,
 -2.204925617887218e-24,  6.076496904809668e-26, -1.563558359999513e-27,  2.232812959868468e-14, -4.675802013372173e-15,  5.306175952679318e-16, -4.255701673737364e-17,
  2.686454531322831e-18, -1.414333803505844e-19,  6.437019027103925e-21, -2.595012855392036e-22,  9.429966926683021e-24, -3.129691177245905e-25,  9.583944282875564e-27,
 -2.728235038775116e-28,  8.291720225088465e-16, -2.076236898681078e-16,  2.785616846774873e-17, -2.610564479302917e-18,  1.906230986071189e-19, -1.150820068174166e-20,
  5.960901069400164e-22, -2.716638880088091e-23,  1.109344161540166e-24, -4.114981198746857e-26,  1.401434109267279e-27, -4.416067132754931e-29,  3.118203306697701e-17,
 -9.258582784218353e-18,  1.463467444188660e-18, -1.599524400782305e-19,  1.349300067868882e-20, -9.331109570869500e-22,  5.494667044115411e-23, -2.827542617006461e-24,
  1.295730256633267e-25, -5.363464439391881e-27,  2.027856643348589e-28, -7.059023905778128e-30,  1.383846608639939e-18, -4.792780285386851e-19,  8.823659027212153e-20,
 -1.114184708521623e-20,  1.076731550452230e-21, -8.463138376293987e-23,  5.623307178769368e-24, -3.243660295798693e-25,  1.656080048059616e-26, -7.595028370026835e-28,
  3.165200256711047e-29, -1.208469995555301e-30,  8.875449243148489e-20, -3.480633555868821e-20,  7.275351749689656e-21, -1.037134303802176e-21,  1.123893444467702e-22,
 -9.840320241360527e-24,  7.238046262085274e-25, -4.595169104337515e-26,  2.568360163692761e-27, -1.283090486564977e-28,  5.798081039429615e-30, -2.389693196095945e-31,
  8.966885761213065e-21, -3.800373949997029e-21,  8.618516988141755e-22, -1.328919994469766e-22,  1.551138516134785e-23, -1.456558236622141e-24,  1.144297012883922e-25,
 -7.729132736943145e-27,  4.579560551813356e-28, -2.417134590192719e-29,  1.150386879152769e-30, -4.978514672631142e-32,  8.896462048344400e-02, -3.302314348766548e-04,
  1.279508504857626e-06, -5.145677563022062e-09,  2.116066226107529e-11, -8.957624343247787e-14,  3.716207283361811e-16, -1.692204058249310e-18,  5.839367400391724e-21,
 -4.445753698901842e-23, -8.540673082467314e-26, -3.255377981724707e-27,  7.386570148256778e-02, -3.264788691010554e-04,  1.829397773480839e-06, -1.084780680619067e-08,
  6.363283061601357e-11, -3.652753003548056e-13,  2.044306930926870e-15, -1.129887162734219e-17,  6.047989348118731e-20, -3.321412203242386e-22,  1.618803721015047e-24,
 -1.015686238844967e-26,  5.089675023997382e-02, -2.976973478568920e-04,  2.403931992607701e-06, -1.858805923728354e-08,  1.355758348369165e-10, -9.467206315499253e-13,
  6.396897209238529e-15, -4.202000752623878e-17,  2.700033674924667e-19, -1.694023835936320e-21,  1.051073419939946e-23, -6.310277772233096e-26,  2.907714168064553e-02,
 -2.333858471600585e-04,  2.480858084862895e-06, -2.333749501884333e-08,  2.036706636664350e-10, -1.685528743146967e-12,  1.338260414640615e-14, -1.024670719852046e-16,
  7.623300791041963e-19, -5.506658148784377e-21,  3.907776990188936e-23, -2.684765342758765e-25,  1.375364490440014e-02, -1.512101431865704e-04,  1.990692446191418e-06,
 -2.225631893426321e-08,  2.287869156722527e-10, -2.208207271462670e-12,  2.026380875578228e-14, -1.781044184583609e-16,  1.510659722960601e-18, -1.239686414664398e-20,
  9.913455246908225e-23, -7.700655388925533e-25,  5.376230824564095e-03, -7.962960605285641e-05,  1.257453814621285e-06, -1.653737061961836e-08,  1.979809332981834e-10,
 -2.202528297936769e-12,  2.310326910590416e-14, -2.306596316045611e-16,  2.209094784774140e-18, -2.038869025059902e-20,  1.823372194493929e-22, -1.582259278099543e-24,
  1.732711638936820e-03, -3.388684230424521e-05,  6.318874064884721e-07, -9.708923586294319e-09,  1.341856680962603e-10, -1.706407982587613e-12,  2.030491792051841e-14,
 -2.285977970404205e-16,  2.455565291917990e-18, -2.531392052671622e-20,  2.517379899640071e-22, -2.422585193335752e-24,  4.591688548540032e-04, -1.163261841843332e-05,
  2.542516155525757e-07, -4.539286202752312e-09,  7.196542173666840e-11, -1.040098673065736e-12,  1.396531207717916e-14, -1.763900389256760e-16,  2.115070038944661e-18,
 -2.423825721456516e-20,  2.669035050240693e-22, -2.835220417178967e-24,  9.973800173092008e-05, -3.218973543301853e-06,  8.219482615471926e-08, -1.697838699038268e-09,
  3.074191365460762e-11, -5.029892803176745e-13,  7.592960828850987e-15, -1.072187521403780e-16,  1.430432506839419e-18, -1.816401944999701e-20,  2.208137393701108e-22,
 -2.581219377002822e-24,  1.769724981926152e-05, -7.175565264589919e-07,  2.137904774812390e-08, -5.093665558236287e-10,  1.050439913814743e-11, -1.940909875283596e-13,
  3.286481788996724e-15, -5.176873133832474e-17,  7.668326052624093e-19, -1.076773597018791e-20,  1.442294961283618e-22, -1.851709593033530e-24,  2.555964814632988e-06,
 -1.287297241403261e-07,  4.474861250119153e-09, -1.227472603953565e-10,  2.879065206283551e-12, -5.999878082170164e-14,  1.138226437915077e-15, -1.997789945128856e-17,
  3.282070357234263e-19, -5.090809584387762e-21,  7.505522625650817e-23, -1.057220892664316e-24,  2.994287566513280e-07, -1.856533863881819e-08,  7.534677259293233e-10,
 -2.377994577991228e-11,  6.342245656046650e-13, -1.490398459472295e-14,  3.167170688530602e-16, -6.192970359421800e-18,  1.128184476507955e-19, -1.932603823966377e-21,
  3.135462078166328e-23, -4.844371487427551e-25,  2.836783918324013e-08, -2.150559753851943e-09,  1.020322435175575e-10, -3.706959852959562e-12,  1.125091507671515e-13,
 -2.983689233385789e-15,  7.107724422119947e-17, -1.549411957713704e-18,  3.131903835331592e-20, -5.928497986487120e-22,  1.058987185067384e-23, -1.795434146183319e-25,
  2.169617909864621e-09, -2.001089312586071e-10,  1.111988982381851e-11, -4.658017803264971e-13,  1.611674765776499e-14, -4.831617870384200e-16,  1.292363846059868e-17,
 -3.145523125459257e-19,  7.064989106503511e-21, -1.479759516824017e-22,  2.913724334384155e-24, -5.426821470173875e-26,  1.340426619166760e-10, -1.499102946987057e-11,
  9.781417865283240e-13, -4.736316141022692e-14,  1.873240725135414e-15, -6.364845178078902e-17,  1.916315903640384e-18, -5.219781197061263e-20,  1.305524860102072e-21,
 -3.031639735196394e-23,  6.592493376516214e-25, -1.351139508155633e-26,  6.724045699416839e-12, -9.100212033108396e-13,  6.993562687761819e-14, -3.928057113901514e-15,
  1.782159428222441e-16, -6.886606333967373e-18,  2.341411813824117e-19, -7.159078155504478e-21,  1.999538185777129e-22, -5.161429336029984e-24,  1.242521713384933e-25,
 -2.808434523837716e-27,  2.775059477417624e-13, -4.539928423784042e-14,  4.123806688416713e-15, -2.697821053136202e-16,  1.410034913121188e-17, -6.221881407680020e-19,
  2.398047632785814e-20, -8.260178380912410e-22,  2.584903576299311e-23, -7.439782547252064e-25,  1.988254994417449e-26, -4.968700464648173e-28,  9.684879754344344e-15,
 -1.913494960517315e-15,  2.061575262855712e-16, -1.577749879431433e-17,  9.542162458323194e-19, -4.828931790849846e-20,  2.118447386550768e-21, -8.251577472932880e-23,
  2.903163282620351e-24, -9.345915787080032e-26,  2.780577387040827e-27, -7.701923989319927e-29,  3.011948287453103e-16, -7.171626531040379e-17,  9.186966840088006e-18,
 -8.254233463416294e-19,  5.798557679902386e-20, -3.377789612263116e-21,  1.692446795168950e-22, -7.477701817857636e-24,  2.966044741328555e-25, -1.070544433630029e-26,
  3.553117614045156e-28, -1.092695844792202e-29,  9.174683754391710e-18, -2.617223377363797e-18,  3.982826814358605e-19, -4.203508810590053e-20,  3.433495860744297e-21,
 -2.304726897006892e-22,  1.320109430191400e-23, -6.620299559146748e-25,  2.961500250023916e-26, -1.198465776241051e-27,  4.436004803485522e-29, -1.513654896990313e-30,
  3.210650824665297e-19, -1.081855403594306e-19,  1.938791151085977e-20, -2.387478546457373e-21,  2.254242093450064e-22, -1.734127844429738e-23,  1.129458954867815e-24,
 -6.395104991344876e-26,  3.209018973427940e-27, -1.448077993141734e-28,  5.944057636450481e-30, -2.237473358617238e-31,  1.625703274907798e-20, -6.285479552195821e-21,
  1.294958133738870e-21, -1.821019390720195e-22,  1.948460837253082e-23, -1.685997088938072e-24,  1.226632336885129e-25, -7.708554570895297e-27,  4.267848091405254e-28,
 -2.113333261035708e-29,  9.471188485413456e-31, -3.873557416013700e-32,  1.379460316537541e-21, -5.822290587900302e-22,  1.314613583413680e-22, -2.018533673591752e-23,
  2.346721982389688e-24, -2.195417907857149e-25,  1.718723200425445e-26, -1.157093779508360e-27,  6.834676823120250e-29, -3.596917058582517e-30,  1.707189360164527e-31,
 -7.369122702123260e-33,  8.766378375857400e-02, -3.202367367467072e-04,  1.219734203938687e-06, -4.820970321488875e-09,  1.945459118977428e-11, -8.120632108571669e-14,
  3.266080234494828e-16, -1.531911692548900e-18,  4.139800782982705e-21, -5.107428647629091e-23, -2.532285607906736e-25, -4.302233438050673e-27,  7.258825566140141e-02,
 -3.123476119275949e-04,  1.705100112265059e-06, -9.885563556104843e-09,  5.679341735500843e-11, -3.198002822563387e-13,  1.753320141912653e-15, -9.543177744233186e-18,
  4.958480823456985e-20, -2.758756483505094e-22,  1.205000814376172e-24, -8.698392151147793e-27,  4.974306129774658e-02, -2.793226288703070e-04,  2.193291694522482e-06,
 -1.656236278631180e-08,  1.180861930094159e-10, -8.063910665357058e-13,  5.332679037428132e-15, -3.427963577341603e-17,  2.159637903902201e-19, -1.324067727787158e-21,
  8.103340032250566e-24, -4.711841118764954e-26,  2.818159334062158e-02, -2.146062370972279e-04,  2.219302056597618e-06, -2.033192621995026e-08,  1.729530251241603e-10,
 -1.396191526593279e-12,  1.082727226415114e-14, -8.096429938171009e-17,  5.896009332717484e-19, -4.155865518439586e-21,  2.900665813707786e-23, -1.935397202005027e-25,
  1.317904756592812e-02, -1.362938697212254e-04,  1.744203933136290e-06, -1.892421974175938e-08,  1.891087194585159e-10, -1.776642961600803e-12,  1.589166434104189e-14,
 -1.362002003496409e-16,  1.128284059410047e-18, -9.033573082892637e-21,  7.073268531996018e-23, -5.357213337219074e-25,  5.076646665957725e-03, -7.031308097083068e-05,
  1.076649784351723e-06, -1.369401393330952e-08,  1.589905944577719e-10, -1.718194446127977e-12,  1.753342964411328e-14, -1.704304813442906e-16,  1.591188900557742e-18,
 -1.431715694300964e-20,  1.250414840218172e-22, -1.058670396212184e-24,  1.606584901936984e-03, -2.926370479074750e-05,  5.272161023391392e-07, -7.810527203031312e-09,
  1.044547827203329e-10, -1.287796879457043e-12,  1.488000971849947e-14, -1.628479223781262e-16,  1.702479395741955e-18, -1.709108072168824e-20,  1.657005828023424e-22,
 -1.554911258413792e-24,  4.163871111401420e-04, -9.798387084731310e-06,  2.060571077792642e-07, -3.537595758157126e-09,  5.415142568904025e-11, -7.572883540781379e-13,
  9.856154224526252e-15, -1.208299509442722e-16,  1.407984593338436e-18, -1.569383264781760e-20,  1.682514536986502e-22, -1.741149284088463e-24,  8.805906121293402e-05,
 -2.635254322049392e-06,  6.446950450468728e-08, -1.277479989071698e-09,  2.228563995535213e-11, -3.521596178449755e-13,  5.144344086234189e-15, -7.040246150112976e-17,
  9.114932523274799e-19, -1.124417697994483e-20,  1.329238069515469e-22, -1.512216074976082e-24,  1.513405366383280e-05, -5.683859768214155e-07,  1.615961764946256e-08,
 -3.685123319102572e-10,  7.306867402233601e-12, -1.301588381736691e-13,  2.129325489963482e-15, -3.246077310862392e-17,  4.660103779616642e-19, -6.349587807975191e-21,
  8.261639714085887e-23, -1.031290795807990e-24,  2.104311320676815e-06, -9.812201646927537e-08,  3.243020439239437e-09, -8.496859430062668e-11,  1.912437779130432e-12,
 -3.835779771332537e-14,  7.019883676382758e-16, -1.190834512916306e-17,  1.893778352667580e-19, -2.847247866313013e-21,  4.073644690723809e-23, -5.574190802551886e-25,
  2.356323399981531e-07, -1.352676149337016e-08,  5.203500551318754e-10, -1.565635459178738e-11,  3.999753553602774e-13, -9.032224405467728e-15,  1.849083106546289e-16,
 -3.490236139265595e-18,  6.148122891805448e-20, -1.019861535067970e-21,  1.604303251206525e-23, -2.406032196346799e-25,  2.115428947637132e-08, -1.485632184444211e-09,
  6.664470214510357e-11, -2.304458517123492e-12,  6.689097628953424e-14, -1.702327646683427e-15,  3.902023794803420e-17, -8.202326702777206e-19,  1.601694580050991e-20,
 -2.933565897072094e-22,  5.077104641332387e-24, -8.350317541160673e-26,  1.517041846126567e-09, -1.297626570456285e-10,  6.805979992253880e-12, -2.709781657223584e-13,
  8.955518915181486e-15, -2.573573749131555e-16,  6.617279865281863e-18, -1.551799168454209e-19,  3.364674317630598e-21, -6.814541895879660e-23,  1.299404568485828e-24,
 -2.346743671260606e-26,  8.673879183773201e-11, -9.012478167062619e-12,  5.545232177198012e-13, -2.549950922949595e-14,  9.625017196401353e-16, -3.132622189187123e-17,
  9.060795843947323e-19, -2.376702120232491e-20,  5.736092603096487e-22, -1.287608406100869e-23,  2.710854065236129e-25, -5.386640405117488e-27,  3.961173922985073e-12,
 -4.993844509829238e-13,  3.619241770879085e-14, -1.930189150201733e-15,  8.355710026970362e-17, -3.092198803039258e-18,  1.009858008713912e-19, -2.973291965108588e-21,
  8.013604960533201e-23, -1.999799872702834e-24,  4.661722171700318e-26, -1.021824187084789e-27,  1.457692717611684e-13, -2.229880789423967e-14,  1.912669180441353e-15,
 -1.189085199406461e-16,  5.933579446946807e-18, -2.508902525475140e-19,  9.293773156121499e-21, -3.084517058045520e-22,  9.320613803645484e-24, -2.595283427222653e-25,
  6.721259162156404e-27, -1.630206838917832e-28,  4.418604666859412e-15, -8.207114867515669e-16,  8.374411010065624e-17, -6.103956000082878e-18,  3.531179162192629e-19,
 -1.715302036154712e-20,  7.244123898669925e-22, -2.723073672385023e-23,  9.265780330381478e-25, -2.890304209746048e-26,  8.346452952908166e-28, -2.247433848607772e-29,
  1.155393253059032e-16, -2.605756540498214e-17,  3.177682258846446e-18, -2.730516217559080e-19,  1.841511429945353e-20, -1.033130712290245e-21,  4.998970052740799e-23,
 -2.137923725518122e-24,  8.225292445074355e-26, -2.884821439837510e-27,  9.319092591784599e-29, -2.793635837808640e-30,  2.850566702203410e-18, -7.781449023028140e-19,
  1.136314654593760e-19, -1.154815635844223e-20,  9.111151107406561e-22, -5.923203363556769e-23,  3.293528898743325e-24, -1.606698938674657e-25,  7.004291349424384e-27,
 -2.766817476561471e-28,  1.001120556825972e-29, -3.343907151410726e-31,  7.806574582111416e-20, -2.550420116593638e-20,  4.435485560307395e-21, -5.312180202590606e-22,
  4.888728349975383e-23, -3.672734669860879e-24,  2.340197417266791e-25, -1.298323269698955e-26,  6.392489086990793e-28, -2.834009755977534e-29,  1.144198104783459e-30,
 -4.240827051675549e-32,  3.067880561927088e-21, -1.166884583069571e-21,  2.364694410276137e-22, -3.274189315060759e-23,  3.453340858217539e-24, -2.948679640327441e-25,
  2.119015797882540e-26, -1.316523496219742e-27,  7.211923267563208e-29, -3.536019322936012e-30,  1.570162740384276e-31, -6.366721875418821e-33,  2.143421837553397e-22,
 -9.003672654533385e-23,  2.022771325808965e-23, -3.091014445870245e-24,  3.577399015206979e-25, -3.332643153932908e-26,  2.598733853102991e-27, -1.743084216921658e-28,
  1.026036048236859e-29, -5.382232048202579e-31,  2.546747664135510e-32, -1.096158677670853e-33,  8.640199347632981e-02, -3.107050987797987e-04,  1.163697945006644e-06,
 -4.522278313961610e-09,  1.790544618859288e-11, -7.386925947528562e-14,  2.852765941357438e-16, -1.431188621404835e-18,  2.072374887476291e-21, -6.504267196108156e-23,
 -4.415716515560384e-25, -3.737841400122004e-27,  7.136541669862610e-02, -2.991663419512938e-04,  1.591721614773946e-06, -9.025838333785005e-09,  5.079745346912728e-11,
 -2.807566701080798e-13,  1.506894233846988e-15, -8.106788312674137e-18,  4.043265339677331e-20, -2.348793817345158e-22,  8.575715944665697e-25, -6.914398368073035e-27,
  4.865964849389693e-02, -2.625403513843610e-04,  2.005369063699631e-06, -1.479536529059593e-08,  1.031643252994042e-10, -6.891857055415227e-13,  4.462858808912800e-15,
 -2.807272668297104e-17,  1.736664940153849e-19, -1.037679482204903e-21,  6.300896515468333e-24, -3.546653553757235e-26,  2.735719572580063e-02, -1.977827440394713e-04,
  1.991044662942463e-06, -1.777468381717270e-08,  1.474545726272417e-10, -1.161539627482048e-12,  8.803426761880341e-15, -6.428253220385254e-17,  4.589789922648728e-19,
 -3.148984749198243e-21,  2.172094579716153e-23, -1.408074772616989e-25,  1.266041032871543e-02, -1.231997352472257e-04,  1.534158901169310e-06, -1.616324726351851e-08,
  1.571008354396470e-10, -1.437208461789766e-12,  1.253828209992070e-14, -1.047953239654959e-16,  8.487996177449827e-19, -6.624181179735334e-21,  5.089790705466976e-23,
 -3.759674885204359e-25,  4.811637780463510e-03, -6.231642069046696e-05,  9.265205703884318e-07, -1.140373670019190e-08,  1.284760263051839e-10, -1.349346897598740e-12,
  1.340313309623316e-14, -1.268780137800778e-16,  1.155611394998414e-18, -1.013546566065405e-20,  8.653850613139863e-23, -7.150753313126286e-25,  1.497409620157644e-03,
 -2.539430823569911e-05,  4.427263578556611e-07, -6.327341059917105e-09,  8.193026829833837e-11, -9.797632710129191e-13,  1.099888185776190e-14, -1.170565604352090e-16,
  1.191681974944859e-18, -1.165227364359880e-20,  1.102039887288269e-22, -1.008734479072261e-24,  3.802409944283802e-04, -8.306078568858755e-06,  1.683433813792273e-07,
 -2.780551619305219e-09,  4.112134834838107e-11, -5.567273005189668e-13,  7.027217627529249e-15, -8.365148282901568e-17,  9.477166309896831e-19, -1.027784550298191e-20,
  1.073260631064964e-22, -1.082373110152774e-24,  7.846037058710384e-05, -2.175250433428510e-06,  5.106677209927249e-08, -9.711624510251871e-10,  1.633298813816198e-11,
 -2.493949470716179e-13,  3.527196626292241e-15, -4.680249121481322e-17,  5.882896830816397e-19, -7.052579147490825e-21,  8.110539167620803e-23, -8.982913769315758e-25,
  1.309362269025957e-05, -4.549913812667342e-07,  1.236124150393886e-08, -2.699324341996705e-10,  5.148996731719039e-12, -8.846718160277304e-14,  1.398912806551563e-15,
 -2.064728300380907e-17,  2.873901836363704e-19, -3.800983637847148e-21,  4.805654441380944e-23, -5.834380013577969e-25,  1.757918336082310e-06, -7.578903571197370e-08,
  2.384357844152192e-09, -5.969360316777761e-11,  1.289925521865691e-12, -2.491104092428628e-14,  4.399785862748987e-16, -7.216205811275737e-18,  1.111249576612921e-19,
 -1.619926663846440e-21,  2.249775036352400e-23, -2.991318640996650e-25,  1.887982918293663e-07, -1.001898531867296e-08,  3.656091916440155e-10, -1.049040641988072e-11,
  2.568126264403688e-13, -5.574788495281629e-15,  1.099818043749640e-16, -2.004537774862080e-18,  3.415247405985085e-20, -5.487298020457293e-22,  8.371103780016439e-24,
 -1.218875383617470e-25,  1.612558552418378e-08, -1.047186120251649e-09,  4.443494397757292e-11, -1.462572044092851e-12,  4.061149284265025e-14, -9.920392060929865e-16,
  2.188435189417389e-17, -4.436806744112797e-19,  8.371136097031807e-21, -1.483683616984864e-22,  2.488217124984750e-24, -3.970334966319617e-26,  1.089278360467018e-09,
 -8.622752601997861e-11,  4.268500806540287e-12, -1.615223978616703e-13,  5.098992020749990e-15, -1.404689690324746e-16,  3.472116045054823e-18, -7.845392702251863e-20,
  1.642186899847493e-21, -3.216145542552610e-23,  5.938724800004535e-25, -1.039995497845017e-26,  5.793857130202215e-11, -5.579396752693846e-12,  3.235422062767459e-13,
 -1.412392688015543e-14,  5.086744906417305e-16, -1.585542360521904e-17,  4.404988885837592e-19, -1.112525006705581e-20,  2.590559692967888e-22, -5.620421867168992e-24,
  1.145437734605515e-25, -2.206333746149392e-27,  2.422838095648042e-12, -2.837332195880863e-13,  1.937091760459098e-14, -9.801751705278051e-16,  4.046228500124447e-17,
 -1.433336369377992e-18,  4.494411372008793e-20, -1.273717388429410e-21,  3.311422275617943e-23, -7.986009286736551e-25,  1.802008068779128e-26, -3.829114200678375e-28,
  7.999935582537246e-14, -1.140619719003029e-14,  9.222870116508263e-16, -5.441946595105157e-17,  2.590046220660596e-18, -1.048510664899434e-19,  3.730055520752589e-21,
 -1.191961109341058e-22,  3.475590662037128e-24, -9.356506789635669e-26,  2.346736996528173e-27, -5.520981959172002e-29,  2.119396395069562e-15, -3.687147727660468e-16,
  3.554873346005833e-17, -2.463255263168053e-18,  1.361001994577865e-19, -6.337538324755292e-21,  2.573511626356515e-22, -9.325608363426865e-24,  3.065793836776210e-25,
 -9.257543287778002e-27,  2.592387338716349e-28, -6.779891779316671e-30,  4.683298678765312e-17, -9.963442826234811e-18,  1.153224674658383e-18, -9.454274276629687e-20,
  6.108672863511368e-21, -3.294603944977360e-22,  1.536934728790034e-23, -6.352855296448111e-25,  2.367381858499993e-26, -8.057606584902189e-28,  2.530305472803482e-29,
 -7.385266863773581e-31,  9.372916310554441e-19, -2.437941999192739e-19,  3.404541959800984e-20, -3.322058699397388e-21,  2.525260182910218e-22, -1.586397884833600e-23,
  8.545687195488143e-25, -4.047776370855814e-26,  1.716704660362685e-27, -6.608779778375041e-29,  2.334099981998322e-30, -7.621029061421475e-32,  1.996698624982561e-20,
 -6.300223570495696e-21,  1.059715497311484e-21, -1.230735971049083e-22,  1.101075108913408e-23, -8.059505958270191e-25,  5.013336326727846e-26, -2.720031115482745e-27,
  1.311767822697426e-28, -5.704189212543083e-30,  2.261776218026600e-31, -8.242675996170851e-33,  5.986917723706981e-22, -2.234515861629789e-22,  4.443516777730925e-23,
 -6.045002720460528e-24,  6.272746258619578e-25, -5.276179040298646e-26,  3.739367965559928e-27, -2.293583007416613e-28,  1.241550402519619e-29, -6.020348737360953e-31,
  2.645923341378857e-32, -1.062637270477611e-33,  3.368731606235890e-23, -1.407264880130575e-23,  3.143370509963880e-24, -4.777072306919683e-25,  5.500374577932313e-26,
 -5.099514230681955e-27,  3.958754232896481e-28, -2.644248383707056e-29,  1.550432670819947e-30, -8.103413873525150e-32,  3.821257255468195e-33, -1.639468597543476e-34,
  8.517745528579872e-02, -3.016078242290598e-04,  1.111101942403770e-06, -4.247251774837428e-09,  1.649331052690665e-11, -6.749829919337089e-14,  2.457538645380741e-16,
 -1.406002713713197e-18, -6.161731321073109e-22, -8.472022899032414e-23, -4.951564178618327e-25,  2.874312528277155e-27,  7.019355187215641e-02, -2.868524067223278e-04,
  1.488108971264947e-06, -8.256109799498801e-09,  4.552631175524298e-11, -2.471764750246380e-13,  1.296790829609985e-15, -6.942155917827943e-18,  3.252940490922383e-20,
 -2.057038774682220e-22,  6.314491742205403e-25, -2.698868662225760e-27,  4.764048682565207e-02, -2.471805267475918e-04,  1.837291740029599e-06, -1.324944261067220e-08,
  9.039113346221598e-11, -5.909144031306090e-13,  3.749339037826492e-15, -2.306735331842505e-17,  1.404943518862836e-19, -8.143022372130344e-22,  4.923705577825998e-24,
 -2.782684653371934e-26,  2.659662497349493e-02, -1.826691577944679e-04,  1.791173062578500e-06, -1.559036072230236e-08,  1.261989635249642e-10, -9.702956873717151e-13,
  7.193225005239618e-15, -5.125274052645000e-17,  3.598683728160737e-19, -2.392561263716817e-21,  1.635411300302747e-23, -1.059459580764204e-25,  1.219098709793351e-02,
 -1.116616515499909e-04,  1.354383419429260e-06, -1.386418245254580e-08,  1.311431541367709e-10, -1.168638720217789e-12,  9.951049873307619e-15, -8.108653588673041e-17,
  6.433126024339011e-19, -4.884214382949306e-21,  3.688208066044005e-23, -2.684555349837495e-25,  4.576376509614633e-03, -5.541863317149565e-05,  8.011723460487864e-07,
 -9.547674891316092e-09,  1.044383286732011e-10, -1.066438724638465e-12,  1.031783862899406e-14, -9.512539857972137e-17,  8.461423831755313e-19, -7.229638326799435e-21,
  6.039654341961288e-23, -4.888023709856647e-25,  1.402464739787238e-03, -2.213532600246876e-05,  3.740605179019780e-07, -5.159917882345649e-09,  6.472997984690952e-11,
 -7.511711904781552e-13,  8.197707268345221e-15, -8.486345448867643e-17,  8.419061086794887e-19, -8.018217084739141e-21,  7.401765089242077e-23, -6.617619197451050e-25,
  3.495135977031402e-04, -7.082403397377019e-06,  1.385846178144505e-07, -2.203261734263880e-09,  3.149997406022244e-11, -4.130684436785128e-13,  5.059338019106184e-15,
 -5.850095232693790e-17,  6.447459487794160e-19, -6.804709384272315e-21,  6.924274256783213e-23, -6.809688873005370e-25,  7.050843605926066e-05, -1.809240745859655e-06,
  4.082995632591720e-08, -7.455484547406117e-10,  1.209554254983948e-11, -1.785545954090893e-13,  2.446165262396488e-15, -3.148325535661569e-17,  3.843796336532896e-19,
 -4.479616297279800e-21,  5.013415797096383e-23, -5.408098757328933e-25,  1.145273591431276e-05, -3.677812026840590e-07,  9.563381289675357e-09, -2.000584171140792e-10,
  3.673442941189361e-12, -6.090587510061538e-14,  9.313489858233909e-16, -1.331414724931926e-17,  1.797512845552156e-19, -2.308429891306096e-21,  2.836980410076187e-23,
 -3.350985920590314e-25,  1.488824926505112e-06, -5.926305738179659e-08,  1.777112941977128e-09, -4.252893203115313e-11,  8.828019719342339e-13, -1.642263046913883e-14,
  2.800453908678362e-16, -4.442441142657160e-18,  6.626789779519546e-20, -9.369351031490047e-22,  1.263475926321224e-23, -1.632811162395839e-25,  1.538633389758880e-07,
 -7.535426638646824e-09,  2.611162680145639e-10, -7.147028629905214e-12,  1.677346317010145e-13, -3.501432517880858e-15,  6.659170120348899e-17, -1.172310946454782e-18,
  1.932394088699858e-20, -3.008020829937104e-22,  4.451288309173721e-24, -6.293853328448136e-26,  1.255046181655986e-08, -7.522051548208324e-10,  3.021012085667539e-11,
 -9.467135594048466e-13,  2.515443578777616e-14, -5.899460522698112e-16,  1.252800538322220e-17, -2.450209301399874e-19,  4.467595769432031e-21, -7.663841386063096e-23,
  1.245621831263367e-24, -1.928564983928873e-26,  8.020980792943124e-10, -5.863308316705256e-11,  2.739881445113724e-12, -9.853821929253921e-14,  2.971669087575742e-15,
 -7.848619306423926e-17,  1.865190127058686e-18, -4.061128261731933e-20,  8.207052137566038e-22, -1.554334743369918e-23,  2.779517817827858e-25, -4.719923272059454e-27,
  3.989193047635524e-11, -3.551481306264588e-12,  1.940304401502119e-13, -8.038768884729641e-15,  2.762032035363201e-16, -8.244272517125205e-18,  2.199831038233472e-19,
 -5.349004595315878e-21,  1.201599321467314e-22, -2.519415604094837e-24,  4.969764537150544e-26, -9.278372809241432e-28,  1.536427122978156e-12, -1.666589502240402e-13,
  1.070843599975555e-14, -5.137739419824104e-16,  2.021526090009522e-17, -6.852069365580429e-19,  2.062187642347877e-20, -5.623562148879423e-22,  1.409839244736150e-23,
 -3.284804637744367e-25,  7.172531470438411e-27, -1.477046243761646e-28,  4.581362490147868e-14, -6.068152145250926e-15,  4.618199679435479e-16, -2.583386319574953e-17,
  1.171674789160496e-18, -4.537756787413678e-20,  1.549254287265292e-21, -4.763744389553660e-23,  1.339574149941859e-24, -3.484577179320076e-26,  8.459542022256242e-28,
 -1.929413311543225e-29,  1.067963265202710e-15, -1.733662721417873e-16,  1.575762197689756e-17, -1.036247887533680e-18,  5.460643283336888e-20, -2.434535460394453e-21,
  9.495215981494606e-23, -3.313556715834154e-24,  1.051460050489472e-25, -3.070777157677974e-27,  8.331578884764918e-29, -2.114615355890213e-30,  2.006472257393856e-17,
 -4.009492229221386e-18,  4.391719836385016e-19, -3.426916380066870e-20,  2.117106453029422e-21, -1.095748137704111e-22,  4.920410587394136e-24, -1.962841195663984e-25,
  7.075189067806422e-27, -2.333973033551708e-28,  7.116318688171211e-30, -2.020003649678743e-31,  3.267752777781362e-19, -8.061695432953901e-20,  1.072788189684697e-20,
 -1.002099407564329e-21,  7.320400078010968e-23, -4.433799377588423e-24,  2.309137433248064e-25, -1.059988728704790e-26,  4.365943135593592e-28, -1.635364151133437e-29,
  5.629265353553654e-31, -1.794150727209709e-32,  5.392396540003211e-21, -1.636211067027758e-21,  2.652040049568687e-22, -2.977282737924969e-23,  2.582183391539696e-24,
 -1.836931703896047e-25,  1.112985775479208e-26, -5.893377661716971e-28,  2.778619597354450e-29, -1.183101217286127e-30,  4.599811026518197e-32, -1.645829523668524e-33,
  1.213245547713647e-22, -4.430202878242852e-23,  8.621186422912026e-24, -1.149507188247181e-24,  1.170976923817512e-25, -9.683510182628188e-27,  6.756432026078646e-28,
 -4.084721224388693e-29,  2.181775558841961e-30, -1.044929456540377e-31,  4.539864433088336e-33, -1.803874044682953e-34,  5.364620817690411e-24, -2.226605863328654e-24,
  4.940339928022569e-25, -7.460534503724615e-26,  8.539542564696688e-27, -7.873878952800321e-28,  6.081441374273045e-29, -4.042911020935083e-30,  2.360100987491072e-31,
 -1.228457793022093e-32,  5.770721766656483e-34, -2.467000571709806e-35,  8.398848502953202e-02, -2.929184911766920e-04,  1.061674731352394e-06, -3.993851533823878e-09,
  1.519911271796161e-11, -6.207779545518213e-14,  2.056266790573813e-16, -1.477830870859301e-18, -3.950562097436488e-21, -9.717030574993435e-23,  2.671579586040504e-26,
  2.423232927349537e-26,  6.906934152467381e-02, -2.753318101074353e-04,  1.393248345097570e-06, -7.565610091216784e-09,  4.087884674067350e-11, -2.182751047274644e-13,
  1.115904438655764e-15, -6.014920513669186e-18,  2.557163623832389e-20, -1.803409894704688e-22,  7.131380482645932e-25,  7.887345962621316e-27,  4.668018799359298e-02,
 -2.330944471641574e-04,  1.686601232459479e-06, -1.189305243688525e-08,  7.942288538899591e-11, -5.081986550757342e-13,  3.162245147122792e-15, -1.900487525841052e-17,
  1.144413132433981e-19, -6.406156254189137e-22,  3.781163581941900e-24, -2.503827649641084e-26,  2.589346883375451e-02, -1.690552007296092e-04,  1.615592544471785e-06,
 -1.371751014162003e-08,  1.084095857936688e-10, -8.136532143129250e-13,  5.907270125960498e-15, -4.099752244782390e-17,  2.844485214509009e-19, -1.825203230353400e-21,
  1.213989438304339e-23, -8.868219862466164e-26,  1.176500506731610e-02, -1.014580897093464e-04,  1.199871691652671e-06, -1.194063009012402e-08,  1.099860955361843e-10,
 -9.548852154745385e-13,  7.944300672170373e-15, -6.305081368852867e-17,  4.913993198329671e-19, -3.622627140572484e-21,  2.668934737281831e-23, -2.008131802747656e-25,
  4.366833183232842e-03, -4.944067342928163e-05,  6.959637116024727e-07, -8.034690838114730e-09,  8.538494076754182e-11, -8.479378831811537e-13,  7.997367792289407e-15,
 -7.178594240962447e-17,  6.246249418145116e-19, -5.195772693632809e-21,  4.236714108677240e-23, -3.414804421092071e-25,  1.319539684116837e-03, -1.937398749214107e-05,
  3.178923528200801e-07, -4.234492139836163e-09,  5.149620729436053e-11, -5.801436188394299e-13,  6.159076203554256e-15, -6.202200233338967e-17,  6.001993011924368e-19,
 -5.567381166200932e-21,  5.013212678597767e-23, -4.402957945335196e-25,  3.232452091212543e-04, -6.071502630645576e-06,  1.149167932613401e-07, -1.759273430022031e-09,
  2.433131984352784e-11, -3.091778464054838e-13,  3.676827213383147e-15, -4.130759258000271e-17,  4.431682989871289e-19, -4.552798755436768e-21,  4.514579868762276e-23,
 -4.338579988638366e-25,  6.387240196411171e-05, -1.515349505281026e-06,  3.293627087057398e-08, -5.776752051417241e-10,  9.046724165676455e-12, -1.291713290744860e-13,
  1.715103994823230e-15, -2.141850848345228e-17,  2.541293413889489e-19, -2.880014199418985e-21,  3.137499362245178e-23, -3.299275074450658e-25,  1.012071853608796e-05,
 -2.999630514316162e-07,  7.478746769055808e-09, -1.499297595790261e-10,  2.651712431606255e-12, -4.244668846428871e-14,  6.279972330630350e-16, -8.698653624216782e-18,
  1.139595113517727e-19, -1.421550729289608e-21,  1.698692300489227e-23, -1.953052282931929e-25,  1.277283142182251e-06, -4.687020404814267e-08,  1.341752736994939e-09,
 -3.070489053911610e-11,  6.126026252870783e-13, -1.098257428746215e-14,  1.808960880085812e-16, -2.776508266254525e-18,  4.013496260286029e-20, -5.505427143004214e-22,
  7.210885458163989e-24, -9.060375568791732e-26,  1.274143604645682e-07, -5.748738774822263e-09,  1.893970619371665e-10, -4.946688469674267e-12,  1.113519322624338e-13,
 -2.236152023642001e-15,  4.101301781865115e-17, -6.976146257702967e-19,  1.112881696117185e-20, -1.678813245752572e-22,  2.410438825571292e-24, -3.310451177875337e-26,
  9.961650813706763e-09, -5.499255171914051e-10,  2.092219905023088e-11, -6.243689625396907e-13,  1.588033258927593e-14, -3.576886798169120e-16,  7.314146730654251e-18,
 -1.380314265757657e-19,  2.432794168666853e-21, -4.040002435924542e-23,  6.364904009362190e-25, -9.563558924741440e-27,  6.049165782096779e-10, -4.074079276924974e-11,
  1.797839801538037e-12, -6.145626521810372e-14,  1.770877915666943e-15, -4.484865231986616e-17,  1.024857916922340e-18, -2.150549710944458e-20,  4.196373738817599e-22,
 -7.686320913149815e-24,  1.331206045278771e-25, -2.192122056659687e-27,  2.827115962414614e-11, -2.320863440200385e-12,  1.194462921472010e-13, -4.695801386853866e-15,
  1.539163333869379e-16, -4.399282167427139e-18,  1.127406808259842e-19, -2.639200706945766e-21,  5.719364821652524e-23, -1.158866700113489e-24,  2.212473975142783e-26,
 -4.003315751472128e-28,  1.008660579039077e-12, -1.010441534833714e-13,  6.105993479005633e-15, -2.776311196943361e-16,  1.040836488253586e-17, -3.374757641831862e-19,
  9.745823660098059e-21, -2.556696843767012e-22,  6.179465824637104e-24, -1.390633927476415e-25,  2.937702745376454e-27, -5.861425840136819e-29,  2.733990513667996e-14,
 -3.352713864739913e-15,  2.398315698255596e-16, -1.270645050433123e-17,  5.487525432402891e-19, -2.031882639368160e-20,  6.653773034923183e-22, -1.967613657338244e-23,
  5.333213595175519e-25, -1.339854053701697e-26,  3.146970415797604e-28, -6.954935468281554e-30,  5.648061704735887e-16, -8.522107520020964e-17,  7.286965275137430e-18,
 -4.540712042863558e-19,  2.279183322709487e-20, -9.718096941135873e-22,  3.636816251720222e-23, -1.221100954403187e-24,  3.736882305881865e-26, -1.054662080590176e-27,
  2.770305202451132e-29, -6.818436714176067e-31,  9.085508581257646e-18, -1.697753611506266e-18,  1.754673028416291e-19, -1.300262984107678e-20,  7.665879033275894e-22,
 -3.801157917480606e-23,  1.640557893372155e-24, -6.307338607325225e-26,  2.196316132862091e-27, -7.013722487724639e-29,  2.073979797179109e-30, -5.719156009918119e-32,
  1.209860310175781e-19, -2.817214146681302e-20,  3.559380987666014e-21, -3.173367801154296e-22,  2.222054748109766e-23, -1.294632007153268e-24,  6.505364580237723e-26,
 -2.888645777126381e-27,  1.153507114257344e-28, -4.197306398871062e-30,  1.406029896037631e-31, -4.368184935120253e-33,  1.543390617671115e-21, -4.481890235377168e-22,
  6.972396979331559e-23, -7.540711569527941e-24,  6.321296236811037e-25, -4.358947812305591e-26,  2.566410406822747e-27, -1.323403213910957e-28,  6.088098735010940e-30,
 -2.533617862050993e-31,  9.642536192572725e-33, -3.382086271931460e-34,  2.564989420570078e-23, -9.131269802154371e-24,  1.733378907454268e-24, -2.258885346085349e-25,
  2.253339294455831e-26, -1.827978610230745e-27,  1.253135091754817e-28, -7.454050461515815e-30,  3.922213191782520e-31, -1.852612113571514e-32,  7.946082693917072e-34,
 -3.119854633164358e-35,  8.674261286873847e-25, -3.573031339376996e-25,  7.866092389327258e-26, -1.179175385779639e-26,  1.340545922216067e-27, -1.228283458073010e-28,
  9.431605666686953e-30, -6.236342940272564e-31,  3.622367896509785e-32, -1.876728760110921e-33,  8.777872317550785e-35, -3.737457964530099e-36,  8.283350004197358e-02,
 -2.846127567280513e-04,  1.015167485840218e-06, -3.760344407212397e-09,  1.400346817479913e-11, -5.765675289580598e-14,  1.619684411091313e-16, -1.657261741882549e-18,
 -7.068700302598787e-21, -6.293490682487958e-23,  2.035573798400647e-24,  7.252053170556337e-26,  6.798974654302258e-02, -2.645381761867297e-04,  1.306245892682468e-06,
 -6.945073093912137e-09,  3.676797308542562e-11, -1.934277240621303e-13,  9.580114468726902e-16, -5.294007643194579e-18,  1.972514407170157e-20, -1.393345246327841e-22,
  1.499329884014234e-24,  3.021853465973607e-26,  4.577392146531555e-02, -2.201516473369676e-04,  1.551186669417255e-06, -1.069964823220110e-08,  6.997679994612131e-11,
 -4.382969093859168e-13,  2.678106860316632e-15, -1.568473733568467e-17,  9.383163969018910e-20, -5.119955910523336e-22,  2.621623334626074e-24, -2.894113655536899e-26,
  2.524209504026292e-02, -1.567606020249444e-04,  1.460876660682146e-06, -1.210581074042415e-08,  9.346635369123870e-11, -6.846828832568963e-13,  4.877518795661121e-15,
 -3.286032852499391e-17,  2.265505009736417e-19, -1.416969809442156e-21,  8.249339936297736e-24, -9.180807506742796e-26,  1.137750357002557e-02, -9.240373717922245e-05,
  1.066544561877542e-06, -1.032384457742503e-08,  9.266072155021737e-11, -7.837437225969800e-13,  6.380791886241409e-15, -4.922313291909801e-17,  3.781870544132600e-19,
 -2.719561804515107e-21,  1.870692964196950e-23, -1.674009541056826e-25,  4.179626442346193e-03, -4.423662853989092e-05,  6.072167436534616e-07, -6.794418150235058e-09,
  7.019372078003391e-11, -6.780243197475392e-13,  6.241244905212288e-15, -5.449113458719919e-17,  4.647436612939298e-19, -3.771185066999986e-21,  2.952685074431493e-23,
 -2.500034268805208e-25,  1.246826864661531e-03, -1.702092974318229e-05,  2.716636799561793e-07, -3.495898012600442e-09,  4.124132548735350e-11, -4.511671032067025e-13,
  4.663772736889638e-15, -4.567045066947714e-17,  4.316289090139045e-19, -3.903406888259078e-21,  3.408769184986090e-23, -2.996706561446322e-25,  3.006729231350725e-04,
 -5.230435932095987e-06,  9.595178325717179e-08, -1.415012426878225e-09,  1.894419767482508e-11, -2.333506973349984e-13,  2.696398358787594e-15, -2.943430365547148e-17,
  3.076412986221459e-19, -3.078314647010389e-21,  2.969030346332387e-23, -2.806406017757946e-25,  5.829731318854217e-05, -1.277309798444496e-06,  2.679412559538312e-08,
 -4.515470542064600e-10,  6.830717419532924e-12, -9.437431565580657e-14,  1.215224384009785e-15, -1.472883997691676e-17,  1.699295304777063e-19, -1.873581932049950e-21,
  1.985947650494588e-23, -2.040543969457478e-25,  9.030071045569886e-06, -2.466680215258975e-07,  5.908582236477839e-09, -1.135508825053462e-10,  1.935714293125139e-12,
 -2.992840763687872e-14,  4.286412561072225e-16, -5.754764049093998e-18,  7.319291756233891e-20, -8.872016871556746e-22,  1.030898065329350e-23, -1.154816565157495e-25,
  1.109151810678373e-06, -3.745867132864957e-08,  1.025553096411602e-09, -2.244860967558874e-11,  4.307480822897239e-13, -7.445347212321860e-15,  1.185106717354421e-16,
 -1.760594341913196e-18,  2.467166720981328e-20, -3.284594916207038e-22,  4.179413713445842e-24, -5.108248947428987e-26,  1.071124886445037e-07, -4.443797350603142e-09,
  1.394074170801245e-10, -3.475343699677967e-12,  7.507631797841194e-14, -1.450979712656427e-15,  2.567476049854167e-17, -4.221018527420405e-19,  6.518937411087757e-21,
 -9.532988553067071e-23,  1.328360488196775e-24, -1.772550850916811e-26,  8.054703930874627e-09, -4.086858419216213e-10,  1.474586001583397e-11, -4.191476078824470e-13,
  1.020924015952482e-14, -2.209173497254538e-16,  4.351293869056253e-18, -7.925848703506391e-20,  1.350650293037590e-21, -2.171818897060893e-23,  3.317339902072957e-25,
 -4.838196628851351e-27,  4.666481259878812e-10, -2.888669957477789e-11,  1.204597623552857e-12, -3.914196801225376e-14,  1.077973703120162e-15, -2.618362190030537e-17,
  5.754652661184614e-19, -1.163977528062438e-20,  2.193426081881774e-22, -3.886100945409320e-24,  6.519164775250384e-26, -1.041138305468864e-27,  2.059332058864238e-11,
 -1.554669272916921e-12,  7.538467197658039e-14, -2.811855587912913e-15,  8.792777426781923e-17, -2.406663810760507e-18,  5.923754467435925e-20, -1.335094422115601e-21,
  2.791166643177914e-23, -5.465376260953229e-25,  1.009879121888426e-26, -1.770949673592472e-28,  6.844914076057948e-13, -6.313245584739564e-14,  3.586257791128166e-15,
 -1.544689806559026e-16,  5.516436307025494e-18, -1.710606086567544e-19,  4.739365739826855e-21, -1.195874892049031e-22,  2.786112112879580e-24, -6.054913836866735e-26,
  1.237250377241465e-27, -2.391362656338814e-29,  1.697678079546325e-14, -1.920764346872626e-15,  1.289953091849722e-16, -6.467350146733914e-18,  2.657909419607392e-19,
 -9.404128678574723e-21,  2.952357702642636e-22, -8.392554380625481e-24,  2.191744429005483e-25, -5.315748010299006e-27,  1.207428907869924e-28, -2.584691322360651e-30,
  3.131363688726632e-16, -4.373963157900925e-17,  3.511592297740143e-18, -2.070454436261345e-19,  9.887811565622454e-21, -4.028139912862085e-22,  1.445149001458942e-23,
 -4.664761306786144e-25,  1.375667610842917e-26, -3.749280237070062e-28,  9.527769883892507e-30, -2.272501366996482e-31,  4.346425310182712e-18, -7.559980197741582e-19,
  7.351810092214921e-20, -5.162454742092902e-21,  2.899342479776237e-22, -1.375181869965080e-23,  5.696525672384032e-25, -2.108018695162762e-26,  7.082654566558503e-28,
 -2.187021028759271e-29,  6.265232462176032e-31, -1.676670101547103e-32,  4.762615187243130e-20, -1.041324769454552e-20,  1.244514358238419e-21, -1.055844302300757e-22,
  7.068753652598861e-24, -3.952897171215478e-25,  1.912583559726006e-26, -8.200068216149813e-28,  3.169247477928639e-29, -1.118494825388506e-30,  3.640828425832750e-32,
 -1.101027871713785e-33,  4.698236521537685e-22, -1.298801560571670e-22,  1.931044807422713e-23, -2.004722812674965e-24,  1.619284992091473e-25, -1.079374192323915e-26,
  6.160129574506038e-28, -3.086539954171658e-29,  1.382589245057288e-30, -5.613019309791771e-32,  2.087453806417717e-33, -7.165572631828182e-35,  5.686188570865389e-24,
 -1.965383731217029e-24,  3.626101362659070e-25, -4.603724958824392e-26,  4.484531259299059e-27, -3.559905720419276e-28,  2.392427825747838e-29, -1.397368302421001e-30,
  7.230228503877692e-32, -3.362517167036634e-33,  1.421645164297834e-34, -5.507976849685043e-36,  1.427723916240057e-25, -5.828209361784368e-26,  1.271371115020906e-26,
 -1.889570462744595e-27,  2.131219172494556e-28, -1.938575045438807e-29,  1.478627748367591e-30, -9.716707299039542e-32,  5.611787955466086e-33, -2.892096432927107e-34,
  1.346070559508763e-35, -5.705265429122832e-37,  8.171101117207823e-02, -2.766681907758690e-04,  9.713502723357373e-07, -3.545319046943375e-09,  1.288530850019451e-11,
 -5.435326479304334e-14,  1.122120813713966e-16, -1.896487005292466e-18, -6.903879857430464e-21,  1.043233889494832e-22,  6.935498023350326e-24,  1.558272401498472e-25,
  6.695197968820073e-02, -2.544118578041625e-04,  1.226310990575331e-06, -6.386533883897085e-09,  3.311768524246463e-11, -1.721470559660057e-13,  8.179623993609790e-16,
 -4.728309759059581e-18,  1.619773811499595e-20, -4.281127611035547e-23,  3.600428629266755e-24,  6.769229377009521e-26,  4.491734670986239e-02, -2.082373476468393e-04,
  1.429230306029626e-06, -9.646798113121365e-09,  6.181971810309288e-11, -3.789694933287010e-13,  2.278328941189994e-15, -1.295945126313381e-17,  7.695466673466010e-20,
 -4.355505239385184e-22,  1.112887401840328e-24, -4.095470565968262e-26,  2.463754118632116e-02, -1.456302456977511e-04,  1.324147593129370e-06, -1.071383673289651e-08,
  8.087281471948471e-11, -5.778893544810499e-13,  4.051662312764604e-15, -2.637142686790021e-17,  1.804545412842355e-19, -1.173704336781849e-21,  3.728603149533003e-24,
 -1.171401305991724e-25,  1.102420279857903e-02, -8.434286097048120e-05,  9.510623142288907e-07, -8.958796587144324e-09,  7.841230043045592e-11, -6.458618182779725e-13,
  5.158200985747065e-15, -3.855739053145192e-17,  2.920068333991150e-19, -2.115691775601500e-21,  1.150821198798781e-23, -1.642692665524563e-25,  4.011904679539912e-03,
 -3.968691414898352e-05,  5.319998420198150e-07, -5.772153977391642e-09,  5.801572809774289e-11, -5.449807573363330e-13,  4.904794626186175e-15, -4.158401501486898e-17,
  3.477526463908553e-19, -2.792687415376985e-21,  1.976555761542285e-23, -1.993218668566640e-25,  1.182839056118396e-03, -1.500485408015021e-05,  2.333928767047076e-07,
 -2.902550259622648e-09,  3.324125589583732e-11, -3.531420981922320e-13,  3.558980340780303e-15, -3.386752822033932e-17,  3.127406830794689e-19, -2.774710184695152e-21,
  2.298273401285423e-23, -2.121063444620023e-25,  2.811857011028555e-04, -4.525922604154361e-06,  8.064693506375307e-08, -1.145986708255272e-09,  1.486290503637873e-11,
 -1.775093956528172e-13,  1.994905233552260e-15, -2.115589007733303e-17,  2.155148611662097e-19, -2.106306527932156e-21,  1.960151050740134e-23, -1.853676816339950e-25,
  5.358490846797408e-05, -1.082906904586411e-06,  2.197379772295261e-08, -3.559007246031813e-10,  5.204409772979583e-12, -6.960060244248602e-14,  8.698045735026693e-16,
 -1.023296279081497e-17,  1.148497323478899e-19, -1.233638296797585e-21,  1.268822942746318e-23, -1.281550113247358e-25,  8.129994010332066e-06, -2.043654053242925e-07,
  4.713719047925641e-09, -8.685942639611171e-11,  1.428220455134152e-12, -2.133684713789927e-14,  2.960113744334702e-16, -3.853010599586643e-18,  4.759554859436239e-20,
 -5.610351084655093e-22,  6.334196307751145e-24, -6.928495235255312e-26,  9.741715378708760e-07, -3.022500639644372e-08,  7.930660392812456e-10, -1.660864321794012e-11,
  3.067092472457634e-13, -5.113310547296773e-15,  7.869617608187817e-17, -1.131964424675281e-18,  1.538348776670742e-20, -1.988699889077393e-22,  2.458164113813371e-24,
 -2.925184322372564e-26,  9.132986490952311e-08, -3.476940084284174e-09,  1.040513821012974e-10, -2.476431080396975e-12,  5.137093188853611e-14, -9.558781349789755e-16,
  1.632560418420482e-17, -2.595037464175118e-19,  3.881309616341454e-21, -5.504128394068156e-23,  7.444519856205961e-25, -9.656099046297860e-27,  6.627558994593649e-09,
 -3.083634826660305e-10,  1.056688152167684e-11, -2.861475552199298e-13,  6.677923812188080e-15, -1.388734169353486e-16,  2.635709481601566e-18, -4.635182155204919e-20,
  7.639350902300403e-22, -1.189763265207188e-23,  1.762241011172679e-25, -2.495374587621074e-27,  3.677671034189753e-10, -2.087094541052193e-11,  8.232573477541368e-13,
 -2.543139756150359e-14,  6.696234885828434e-16, -1.560354512917484e-17,  3.299137732496752e-19, -6.433676549933493e-21,  1.171053135218675e-22, -2.007205593246096e-24,
  3.261975368928083e-26, -5.053066061169589e-28,  1.539660169711139e-11, -1.065857339007246e-12,  4.871447719237828e-14, -1.723934099438247e-15,  5.143703798469740e-17,
 -1.348354499449589e-18,  3.187993357371911e-20, -6.918218801215447e-22,  1.395398851233043e-23, -2.640620177613395e-25,  4.722527486391595e-27, -8.026302342826745e-29,
  4.794220412434258e-13, -4.058129053287715e-14,  2.166602388785158e-15, -8.837558779758752e-17,  3.006064878103737e-18, -8.914013208637431e-20,  2.369181079052833e-21,
 -5.749470432305480e-23,  1.291036766093514e-24, -2.709245853860890e-26,  5.354270852363487e-28, -1.002359138180107e-29,  1.095207544683732e-14, -1.139078311882462e-15,
  7.175505054328381e-17, -3.401982842021162e-18,  1.329819607959473e-19, -4.494120378043370e-21,  1.352114788930818e-22, -3.693508536554656e-24,  9.290382360730535e-26,
 -2.174544902660872e-27,  4.775098003816123e-29, -9.897597226298386e-31,  1.817486472556780e-16, -2.340433199599857e-17,  1.761180286226842e-18, -9.812912325997815e-20,
  4.454303772847141e-21, -1.732270095156515e-22,  5.953315144291736e-24, -1.846094458353459e-25,  5.242912176510714e-27, -1.378978761934159e-28,  3.388119491693947e-30,
 -7.826399993028000e-32,  2.195206981557490e-18, -3.537026436870689e-19,  3.227755239052158e-20, -2.143441315206580e-21,  1.144848080209455e-22, -5.186689324378957e-24,
  2.059457590439041e-25, -7.326734788643528e-27,  2.372586449835775e-28, -7.076612704158641e-30,  1.962015425544266e-31, -5.090700620056391e-33,  1.994839807087934e-20,
 -4.073071367059166e-21,  4.587601818187378e-22, -3.692896179454414e-23,  2.358012359070237e-24, -1.262873534503426e-25,  5.872184958921677e-27, -2.426604033778723e-28,
  9.062236216638811e-30, -3.097224305328725e-31,  9.782565662086210e-33, -2.875729367106842e-34,  1.526108859481280e-22, -3.992843712606685e-23,  5.648034677632362e-24,
 -5.607427680970712e-25,  4.350181980460964e-26, -2.795084154732027e-27,  1.542337543085363e-28, -7.491577075938995e-30,  3.260668624985401e-31, -1.288860277000134e-32,
  4.675303637969077e-34, -1.568022962747668e-35,  1.329065599924433e-24, -4.438691127466879e-25,  7.926109404608036e-26, -9.768539262303200e-27,  9.262804314400822e-28,
 -7.175144494711935e-29,  4.715478308191048e-30, -2.698401223849380e-31,  1.370170097150198e-32, -6.262549166125798e-34,  2.605619299559704e-35, -9.946470392469825e-37,
  2.399432325417940e-26, -9.689897906747205e-27,  2.090930898776097e-27, -3.076442951583413e-28,  3.437936091062809e-29, -3.100830453614832e-30,  2.346867080137899e-31,
 -1.531294609108341e-32,  8.786115538043935e-34, -4.500743166480836e-35,  2.083108546477386e-36, -8.783647381424311e-38,  8.061961540920540e-02, -2.690641408650658e-04,
  9.300079839451740e-07, -3.347722746362156e-09,  1.182076671501603e-11, -5.231660931760184e-14,  5.705032633976833e-17, -1.988569670201501e-18,  3.772073992469825e-21,
  5.491064811341265e-22,  1.605763024766230e-23,  2.582488049405965e-25,  6.595348023692842e-02, -2.448991704485775e-04,  1.152741599294209e-06, -5.883171792992926e-09,
  2.986063207937257e-11, -1.540463708133403e-13,  6.928304485396629e-16, -4.200221018985156e-18,  1.808853645041382e-20,  1.741957832443809e-22,  7.583116278064703e-24,
  1.129482901137454e-25,  4.410655485042275e-02, -1.972502938691550e-04,  1.319162599956169e-06, -8.715465352334267e-09,  5.475911261710224e-11, -3.283799799156474e-13,
  1.947622202019487e-15, -1.074300540838853e-17,  6.159694828732098e-20, -4.320497019564843e-22, -1.065160753353646e-24, -5.822998748088864e-26,  2.407542225227344e-02,
 -1.355301769768784e-04,  1.202980391007714e-06, -9.507290434730659e-09,  7.023082575680842e-11, -4.888960093723633e-13,  3.387897533554835e-15, -2.125488749139244e-17,
  1.395431961801611e-19, -1.138774870886035e-21, -2.266875508795811e-24, -1.556948970203942e-25,  1.070139635211501e-02, -7.714399630506680e-05,  8.506788963318275e-07,
 -7.801160319556227e-09,  6.665075295004246e-11, -5.340319350631255e-13,  4.198513468431064e-15, -3.035732313285380e-17,  2.223515651307499e-19, -1.803866713508174e-21,
  3.966962275887481e-24, -1.796934933058746e-25,  3.861251572664405e-03, -3.569298722055023e-05,  4.679635050240892e-07, -4.925077792657149e-09,  4.820507424202496e-11,
 -4.400682968200103e-13,  3.882112598562332e-15, -3.192854290911866e-17,  2.594138470948803e-19, -2.168926214884455e-21,  1.160048946510857e-23, -1.745126417419582e-25,
  1.126345425074288e-03, -1.326850000368654e-05,  2.015345590584452e-07, -2.422855187037874e-09,  2.696123219717845e-11, -2.780615750703359e-13,  2.736945345538075e-15,
 -2.529778720633042e-17,  2.273145169540698e-19, -2.024322894312274e-21,  1.492776483819464e-23, -1.581243076939631e-25,  2.642906384188814e-04, -3.931965634846631e-06,
  6.821268531440747e-08, -9.341686052403683e-10,  1.174726154194886e-11, -1.360257736667846e-13,  1.488684115742455e-15, -1.533606524731127e-17,  1.520170730200909e-19,
 -1.465822430659621e-21,  1.285489507654832e-23, -1.257910376870953e-25,  4.957968089880841e-05, -9.228830370882673e-07,  1.816010074797888e-08, -2.827224787962820e-10,
  3.999926565015211e-12, -5.178606052544148e-14,  6.286970304805949e-16, -7.180475067898658e-18,  7.835751346049770e-20, -8.236140135965767e-22,  8.148487391578145e-24,
 -8.190200012888769e-26,  7.381859206050763e-06, -1.704665239572555e-07,  3.795589868090100e-09, -6.706960304445674e-11,  1.064603808734857e-12, -1.537213127682466e-14,
  2.067304491503135e-16, -2.609610473071893e-18,  3.130834348289119e-20, -3.596164547984799e-22,  3.933128766441096e-24, -4.219512619566335e-26,  8.648066204327982e-07,
 -2.460142327120427e-08,  6.201368282837607e-10, -1.242665916809592e-11,  2.210245224772704e-13, -3.555309908549842e-15,  5.293868479662810e-17, -7.375252878154451e-19,
  9.722327245923153e-21, -1.221679862629993e-22,  1.465626496626405e-24, -1.700884997924856e-26,  7.891668918579500e-08, -2.750750765481475e-09,  7.869770862507321e-11,
 -1.788387638830015e-12,  3.564841130416739e-14, -6.388663433801623e-16,  1.053706040145423e-17, -1.619977498160464e-19,  2.347141240659009e-21, -3.229668914906938e-23,
  4.239507101452219e-25, -5.348935979922928e-27,  5.543739652780405e-09, -2.359378809104908e-10,  7.692572090023046e-12, -1.984797562995008e-13,  4.440658241983526e-15,
 -8.878016958030693e-17,  1.624294468040872e-18, -2.758763778414275e-20,  4.398610086001264e-22, -6.637468229230839e-24,  9.534443924262626e-26, -1.311280141281394e-27,
  2.957517027535033e-10, -1.534465434335009e-11,  5.733089321692336e-13, -1.683818609830950e-14,  4.240750797032561e-16, -9.482612165987162e-18,  1.929424751153666e-19,
 -3.628515694291317e-21,  6.380873031600534e-23, -1.058330758181843e-24,  1.666408960042668e-26, -2.504357893956935e-28,  1.179893903065978e-11, -7.467082623829058e-13,
  3.219393813467110e-14, -1.080886057486159e-15,  3.077982795561549e-17, -7.728636842116574e-19,  1.755593573970390e-20, -3.668798826244848e-22,  7.140178324620031e-24,
 -1.305982033885125e-25,  2.260759881223734e-27, -3.724160566874685e-29,  3.460439990152121e-13, -2.679068368243061e-14,  1.344536581639201e-15, -5.192516166954513e-17,
  1.682247030466046e-18, -4.770191598799364e-20,  1.216215973806577e-21, -2.838532460139558e-23,  6.143086683827720e-25, -1.244734050490871e-26,  2.379040905505122e-28,
 -4.313464338867208e-30,  7.328607151958052e-15, -6.980004287515208e-16,  4.121922353058628e-17, -1.846945079512377e-18,  6.864465872126522e-20, -2.215119433481465e-21,
  6.385067582145180e-23, -1.675627235560595e-24,  4.058432074873723e-26, -9.165177031168357e-28,  1.945165826170877e-29, -3.902895001586624e-31,  1.102700298712543e-16,
 -1.303390490022636e-17,  9.179680733296359e-19, -4.828058866144464e-20,  2.081316146335321e-21, -7.721331211543219e-23,  2.540329242765708e-24, -7.563134553483107e-26,
  2.067311821317381e-27, -5.244459603647152e-29,  1.245157380380128e-30, -2.784106714719967e-32,  1.169343367800370e-18, -1.736591919961046e-19,  1.483442311914464e-20,
 -9.298744997843250e-22,  4.716312495038528e-23, -2.038275104820094e-24,  7.748745584958304e-26, -2.647371710232550e-27,  8.254256391064696e-29, -2.375807666783233e-30,
  6.369155620972689e-32, -1.600797298870999e-33,  8.893149096220550e-21, -1.685871854338590e-21,  1.783010503374004e-22, -1.357956859495657e-23,  8.250379148173381e-25,
 -4.223105800142604e-26,  1.883655211506912e-27, -7.489718699167129e-29,  2.698458287385295e-30, -8.918082667456294e-32,  2.729357879794192e-33, -7.788942612602122e-35,
  5.305084027875481e-23, -1.305292287207465e-23,  1.748368271167725e-24, -1.653590378604996e-25,  1.228051275352812e-26, -7.583801745601891e-28,  4.035656176623982e-29,
 -1.895831241446803e-30,  8.000372007598880e-32, -3.072850953347785e-33,  1.085242154027388e-34, -3.550007160809697e-36,  3.294627059222193e-25, -1.057173751555576e-25,
  1.818440857127773e-26, -2.166757214750583e-27,  1.992984284285042e-28, -1.501822344305666e-29,  9.625365576044507e-31, -5.383180181302189e-32,  2.676516481937995e-33,
 -1.199875188998653e-34,  4.903786464480029e-36, -1.841272292311933e-37,  4.132895208884489e-27, -1.647472364275990e-27,  3.509251202205204e-28, -5.102003532773620e-29,
  5.639885442014825e-30, -5.036831579587603e-31,  3.777942976752380e-32, -2.444839732045258e-33,  1.392233333851603e-34, -7.082523680769797e-36,  3.257171124715667e-37,
 -1.365355605766696e-38,  7.955798898138802e-02, -2.617816315667311e-04,  8.909357660828776e-07, -3.166905146592623e-09,  1.078378252938163e-11, -5.157864530972814e-14,
  7.051904563366408e-18, -1.403925320530186e-18,  3.805515147474386e-20,  1.441014677989672e-21,  2.890758680656412e-23,  3.064041493993795e-25,  6.499189146459823e-02,
 -2.359517362825994e-04,  1.084911308152832e-06, -5.429184360738994e-09,  2.693682893054100e-11, -1.387561658759868e-13,  5.847475357105895e-16, -3.452153900435661e-18,
  3.111046742789437e-20,  5.865765186549429e-22,  1.319218942555782e-23,  1.332466388544688e-25,  4.333801829078895e-02, -1.871009240572334e-04,  1.219625116298931e-06,
 -7.889419102012492e-09,  4.863566586329316e-11, -2.850387570721375e-13,  1.671986271356611e-15, -9.034259005728953e-18,  4.462029822247684e-20, -5.299031303837182e-22,
 -3.895099717703963e-24, -6.700868693096922e-26,  2.355185270041114e-02, -1.263442963941769e-04,  1.095326172071819e-06, -8.457596528106397e-09,  6.122023855200469e-11,
 -4.142623708836838e-13,  2.848907817126072e-15, -1.747689385424690e-17,  9.518299657913155e-20, -1.374793550713280e-21, -9.657592314484782e-24, -1.713899715935607e-25,
  1.040586290786481e-02, -7.069566936238788e-05,  7.631279617302907e-07, -6.814993817577685e-09,  5.691281049270096e-11, -4.427229453447617e-13,  3.438487033251916e-15,
 -2.426616030774277e-17,  1.583321043345426e-19, -1.806268249630240e-21, -4.094443684058412e-24, -1.795841971947287e-25,  3.725610402469822e-03, -3.217320859241467e-05,
  4.132154197496618e-07, -4.219433236182718e-09,  4.026755364351166e-11, -3.567568554879603e-13,  3.093145712580410e-15, -2.480172869620404e-17,  1.878860820617200e-19,
 -1.852661205572460e-21,  4.378203107670462e-24, -1.511173922739782e-25,  1.076321664706946e-03, -1.176558772972523e-05,  1.748759910704733e-07, -2.032623218415823e-09,
  2.200346846462585e-11, -2.201165144446018e-13,  2.120234927513922e-15, -1.908738017742347e-17,  1.636186859801981e-19, -1.554564973273474e-21,  8.838618595951799e-24,
 -1.195363900725843e-25,  2.495874354321314e-04, -3.428103824033918e-06,  5.804653393967392e-08, -7.661720016208592e-10,  9.351894146371155e-12, -1.049460437042129e-13,
  1.120093572972946e-15, -1.122664455561183e-17,  1.072855312886485e-19, -1.049760635828269e-21,  8.231892361889002e-24, -8.664346540593242e-26,  4.615866196551187e-05,
 -7.901586383810992e-07,  1.511972553823313e-08, -2.262531930970035e-10,  3.100163072217712e-12, -3.885194185162134e-14,  4.587010653602760e-16, -5.090993605302018e-18,
  5.379364714396774e-20, -5.603035427634186e-22,  5.226273759112828e-24, -5.305099922078011e-26,  6.756005325488297e-06, -1.430533035116924e-07,  3.083620927819567e-09,
 -5.224885650866854e-11,  8.013959049543511e-13, -1.118517901520711e-14,  1.459383488337776e-16, -1.787817379921197e-18,  2.079645404851044e-20, -2.340693682610320e-22,
  2.461326902724318e-24, -2.604433873062494e-26,  7.754569643972645e-07, -2.018167764837902e-08,  4.900946129007621e-10, -9.396521434713038e-12,  1.611167119239110e-13,
 -2.501126808303858e-15,  3.605532039063344e-17, -4.867829982370797e-19,  6.220988164947905e-21, -7.617385633070997e-23,  8.846198648488811e-25, -1.003388036762977e-26,
  6.904944450484485e-08, -2.198204223154253e-09,  6.027828702898695e-11, -1.307893562726242e-12,  2.507226471051264e-14, -4.328886427234657e-16,  6.898767471921687e-18,
 -1.026300158777894e-19,  1.440391989690944e-21, -1.925402045789030e-23,  2.451093994969418e-25, -3.010911727156095e-27,  4.709527990708639e-09, -1.828388550578816e-10,
  5.684729901325612e-12, -1.397525799656989e-13,  2.999687528222104e-15, -5.767303082148493e-17,  1.017635802404118e-18, -1.669894418429707e-20,  2.576132057839425e-22,
 -3.768807039828406e-24,  5.249822169075560e-26, -7.015639171939780e-28,  2.424120361824653e-10, -1.146400243648022e-11,  4.064330794493844e-13, -1.134940768823670e-14,
  2.735578062307058e-16, -5.871529041073127e-18,  1.150085090780235e-19, -2.086434818505425e-21,  3.545470704598164e-23, -5.692335443146540e-25,  8.684856558701458e-27,
 -1.266551016287976e-28,  9.255500539143543e-12, -5.337088235425455e-13,  2.173369995502741e-14, -6.922523264819142e-16,  1.882093727960158e-17, -4.527653191088618e-19,
  9.883343562467931e-21, -1.989352523094032e-22,  3.736279388433860e-24, -6.606394217346678e-26,  1.107050685954444e-27, -1.767756142124577e-29,  2.570094428639411e-13,
 -1.813262665177504e-14,  8.559318383145815e-16, -3.129055766719197e-17,  9.656583936673243e-19, -2.618539866470534e-20,  6.404897790145367e-22, -1.437699598606614e-23,
  2.998820898340201e-25, -5.867159483657462e-27,  1.084471992627013e-28, -1.904287402850702e-30,  5.078261829984087e-15, -4.411243809924346e-16,  2.441550871750472e-17,
 -1.033443710342662e-18,  3.651235267707632e-20, -1.124808314870846e-21,  3.105774860320117e-23, -7.828749781110539e-25,  1.825496999403080e-26, -3.976780688159074e-28,
  8.155744943608019e-30, -1.583751396240360e-31,  6.982038637641760e-17, -7.540450008075704e-18,  4.964906187372198e-19, -2.462597344539417e-20,  1.007512214493190e-21,
 -3.563428243975235e-23,  1.121740873269645e-24, -3.204844778288752e-26,  8.427336890640882e-28, -2.061073733533961e-29,  4.726505576626913e-31, -1.022496028120762e-32,
  6.561096042320526e-19, -8.933748717876474e-20,  7.127792526519966e-21, -4.210410512055616e-22,  2.025210264441169e-23, -8.339704050533749e-25,  3.032340179151109e-26,
 -9.939698983521202e-28,  2.981241177209147e-29, -8.273461553663474e-31,  2.142849555947374e-32, -5.212859518175222e-34,  4.219117654924285e-21, -7.380447660656857e-22,
  7.303816467555305e-23, -5.248838802859217e-24,  3.027575497814874e-25, -1.478280728860850e-26,  6.313951796356395e-28, -2.411782043177773e-29,  8.370622995065392e-31,
 -2.671321922741027e-32,  7.911338334196522e-34, -2.188987756980768e-35,  1.978382575430103e-23, -4.546002658408594e-24,  5.737794739918401e-25, -5.149568180367281e-26,
  3.648948112797229e-27, -2.159554559975823e-28,  1.105375445941762e-29, -5.010328025466582e-31,  2.045580016474650e-32, -7.619251158457695e-34,  2.614992387179901e-35,
 -8.328693246543652e-37,  8.714697258904936e-26, -2.669154931926987e-26,  4.398964820505196e-27, -5.044901449911691e-28,  4.483837748809822e-29, -3.275844782434679e-30,
  2.041382269118795e-31, -1.112812622814388e-32,  5.404621774673062e-34, -2.371195419845444e-35,  9.500114946790730e-37, -3.502261965054569e-38,  7.329549912168711e-28,
 -2.875840912527334e-28,  6.031217885739657e-29, -8.644911300799862e-30,  9.434335846335664e-31, -8.328270945402555e-32,  6.181320251009597e-33, -3.962042968224364e-34,
  2.236599277788022e-35, -1.128737568398691e-36,  5.152985497437595e-38, -2.145544910587902e-39,  7.852488078020527e-02, -2.548033020899657e-04,  8.539341062761573e-07,
 -3.002618206077140e-09,  9.751663669043487e-12, -5.168696448907335e-14, -5.672121952580120e-18,  8.921982803082205e-19,  1.137877924695216e-19,  2.840130528777017e-21,
  3.982728470575078e-23,  1.345071692025757e-25,  6.406504055411423e-02, -2.275259259585723e-04,  1.022257838001779e-06, -5.019664126361225e-09,  2.429489387853216e-11,
 -1.257462252249192e-13,  5.059892548679700e-16, -2.006000262365958e-18,  6.304276808553600e-20,  1.219157039219559e-21,  1.788322220067824e-23,  5.536093972514918e-26,
  4.260854712278295e-02, -1.777098058524924e-04,  1.129439819360691e-06, -7.154757719965856e-09,  4.331643242661869e-11, -2.478040917837996e-13,  1.435902251594503e-15,
 -7.947255920327388e-18,  2.206580489343633e-20, -7.398361721090747e-22, -6.378236201912933e-24, -3.552017542347372e-26,  2.306338066406509e-02, -1.179716060919240e-04,
  9.994503362185063e-07, -7.540800517285167e-09,  5.358066528086449e-11, -3.514653888648851e-13,  2.394142484639781e-15, -1.531155039845758e-17,  3.703342353797666e-20,
 -1.897456513416578e-21, -1.585453020452607e-23, -8.406907103554510e-26,  1.013479334091899e-02, -6.490293000314732e-05,  6.865333846294003e-07, -5.970962230764295e-09,
  4.883125145624492e-11, -3.678417406328563e-13,  2.819880630872306e-15, -2.028621353328836e-17,  8.858447327651775e-20, -2.112098596711290e-21, -1.057713407437812e-23,
 -9.267387738546731e-26,  3.603223117326743e-03, -2.905958244575138e-05,  3.662248945668606e-07, -3.628424681929325e-09,  3.382177428733910e-11, -2.902360701483111e-13,
  2.473012994244426e-15, -1.983494453385635e-17,  1.228617933626942e-19, -1.796308977929726e-21, -1.094246062913349e-24, -8.606173397725138e-26,  1.031910880074976e-03,
 -1.045847824784221e-05,  1.524600521173363e-07, -1.713193286657904e-09,  1.806955075078111e-11, -1.751021042807104e-13,  1.651106444513754e-15, -1.468836748402565e-17,
  1.128579375423951e-19, -1.294202492301246e-21,  4.507890763360639e-24, -7.399291326664231e-26,  2.367489277610446e-04, -2.998114625698615e-06,  4.968544248538876e-08,
 -6.319727846254985e-10,  7.498198182462298e-12, -8.148082734003666e-14,  8.485428238435821e-16, -8.341510162232981e-18,  7.458811681761417e-20, -7.873645568168363e-22,
  5.114260830406038e-24, -5.537611505835673e-26,  4.322386499911599e-05, -6.792731390200743e-07,  1.267847365132638e-08, -1.823139404836986e-10,  2.422597232855299e-12,
 -2.937647369626455e-14,  3.374835264289507e-16, -3.656170751478376e-18,  3.688025689409593e-20, -3.917607855499403e-22,  3.341346178711046e-24, -3.367444884849719e-26,
  6.229445914701876e-06, -1.206901459295448e-07,  2.526759429271261e-09, -4.104160761053882e-11,  6.090206688213955e-13, -8.215323747036666e-15,  1.040529828548976e-16,
 -1.240192564663593e-18,  1.389628459521667e-20, -1.552727463968682e-22,  1.550635858488661e-24, -1.609640153893570e-26,  7.019148471024091e-07, -1.667164774991690e-08,
  3.912933597831845e-10, -7.176077868762369e-12,  1.187497592096404e-13, -1.779172597728919e-15,  2.484425215591782e-17, -3.255376515844993e-19,  4.021859304456173e-21,
 -4.826775887466461e-23,  5.400736847190578e-25, -5.978816230874123e-27,  6.113050866574689e-08, -1.772541203031236e-09,  4.673147489294489e-11, -9.678944344395922e-13,
  1.786185861434074e-14, -2.971721681092179e-16,  4.578345271516659e-18, -6.596744011269218e-20,  8.958708870841819e-22, -1.166361878629202e-23,  1.437657770660856e-25,
 -1.719101503625330e-27,  4.059553328899372e-09, -1.433329926397543e-10,  4.261505971460183e-12, -9.980195625561778e-14,  2.056916918097978e-15, -3.804132901891575e-17,
  6.476531559869856e-19, -1.027440353933244e-20,  1.533174776646362e-22, -2.177174320739594e-24,  2.939701884694586e-26, -3.817777905373470e-28,  2.022907977493736e-10,
 -8.690942040032061e-12,  2.930631180473561e-13, -7.779733585988286e-15,  1.795873946917837e-16, -3.700945283831390e-18,  6.981287793259239e-20, -1.222282160638005e-21,
  2.007123059157523e-23, -3.121172506183764e-25,  4.614252062249382e-27, -6.531096595278674e-29,  7.422208246565553e-12, -3.885610168630477e-13,  1.497175869177681e-14,
 -4.523481134916399e-16,  1.174794910430454e-17, -2.708227853481051e-19,  5.682596391534752e-21, -1.102007528576656e-22,  1.997573876927007e-24, -3.415460139720724e-26,
  5.540816572148332e-28, -8.577570907053611e-30,  1.961201924381952e-13, -1.255944335159589e-14,  5.582394902373819e-16, -1.931408304606520e-17,  5.679342009666318e-19,
 -1.472878539128442e-20,  3.456651995570696e-22, -7.463407737164563e-24,  1.500482295081154e-25, -2.834884946444345e-27,  5.067565081614057e-29, -8.618086126961831e-31,
  3.637928805661871e-15, -2.869535429088059e-16,  1.489034953308496e-17, -5.951311798279958e-19,  1.998672977632799e-20, -5.877326552520103e-22,  1.554384102645558e-23,
 -3.763171061992115e-25,  8.446991120521022e-27, -1.774899545713810e-28,  3.516930284752247e-30, -6.608719682386922e-32,  4.605669351925701e-17, -4.522508263918905e-18,
  2.782011827124293e-19, -1.300244211998282e-20,  5.046115254723350e-22, -1.700751473870823e-23,  5.120549939397553e-25, -1.403353483056778e-26,  3.548666995292968e-28,
 -8.364021397971041e-30,  1.851917506832852e-31, -3.874699381145012e-33,  3.871852001010691e-19, -4.806745086837626e-20,  3.575314374946529e-21, -1.987261676950494e-22,
  9.054773456240878e-24, -3.549367071076438e-25,  1.233253224365374e-26, -3.875264614424594e-28,  1.117238335129677e-29, -2.987208384882239e-31,  7.469400478212271e-33,
 -1.757472689673057e-34,  2.128843542497296e-21, -3.414069433405398e-22,  3.150980593509791e-23, -2.131328103472724e-24,  1.164765304142438e-25, -5.415424781276896e-27,
  2.211353641498833e-28, -8.102697749471358e-30,  2.705344790909043e-31, -8.326076778453380e-33,  2.383210597631119e-34, -6.385825039092811e-36,  7.929454255626533e-24,
 -1.688870502030732e-24,  1.998734143732165e-25, -1.695594655509770e-26,  1.142642992198898e-27, -6.462449554911821e-29,  3.173628829393573e-30, -1.384772191863622e-31,
  5.458125835805222e-33, -1.967637820151770e-34,  6.550490093592168e-36, -2.027825722169930e-37,  2.474982023289121e-26, -7.180881547651804e-27,  1.127183152306218e-27,
 -1.238094708667576e-28,  1.058850707638593e-29, -7.472759359928464e-31,  4.513166146077712e-32, -2.391111895802834e-33,  1.131418008457522e-34, -4.846550800695804e-36,
  1.899423118322742e-37, -6.861443746681925e-39,  1.345939356969969e-28, -5.179177574650302e-29,  1.065922641950807e-29, -1.502063719977479e-30,  1.614387024950558e-31,
 -1.405707971009661e-32,  1.030513871613349e-33, -6.531844094866749e-35,  3.650019310901606e-36, -1.825077551472210e-37,  8.261764291871763e-39, -3.413417147698009e-40,
  };
  int offset = -23;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 23;
    if (std::isnan(t)) {
      fill_n(rr+offset, 23, 0.5);
      fill_n(ww+offset, 23, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 23; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=23; ++j) {
        const int boxof = it*276+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
